/*
  Copyright (c) 2008 - 2014 Freescale Semiconductor
  Freescale Confidential Proprietary
  \file     	"main.h"
  \brief    	
  \author   	Freescale Semiconductor
  
*/
#ifndef MAIN_INCLUDED
#define MAIN_INCLUDED  /* MAIN_INCLUDED  */

/*--- TARGET Related ---*/
#define THIS_IS_SUZUKA 0x1234
#define THIS_IS_7X7    0x9ABC

#define ALL_PTAS_ARE_OUTPUT  (0b1111)
#define PTA0_IS_HIGH         PTAD_PTAD0_MASK
#define PTA1_IS_HIGH         PTAD_PTAD1_MASK
#define PTA2_IS_HIGH         PTAD_PTAD2_MASK
#define PTA3_IS_HIGH         PTAD_PTAD3_MASK
#define ALL_PTBS_ARE_OUTPUT  (0b11)
/* 
 *****************************************************************************
 *
 * DEFINES 
 *
 ****************************************************************************/
/*
 ******************************************************************************
 *
 *  General bit positions.
 *
 ******************************************************************************
 */
#define BIT0	((UINT8)1u)
#define BIT1	((UINT8)2u)
#define BIT2	((UINT8)4u)
#define BIT3	((UINT8)8u)
#define BIT4	((UINT8)16u)
#define BIT5	((UINT8)32u)
#define BIT6	((UINT8)64u)
#define BIT7	((UINT8)128u)

/*
 ******************************************************************************
 *
 *  Define SET and CLEAR.
 *
 ******************************************************************************
 */
#ifndef CLEAR
#define CLEAR 0u
#endif
#ifndef SET
#define SET   1u
#endif

/*
 ******************************************************************************
 *
 * The following defines bis in the STATUS byte.
 *
 ******************************************************************************
 */
#define OVERFLOWERROR BIT0
#define BONDINGERROR  BIT1
#define PCELLERROR    BIT2
#define ZGCELLERROR   BIT4
#define VOLTERROR     BIT5
#define TEMPERROR     BIT6
#define ADCERROR      BIT7

/*
 ******************************************************************************
 *
 * The following define STOP mode entries.
 *
 ******************************************************************************
 */  
#define STOP1 ((UINT8)1u) 
#define STOP4 ((UINT8)4u)
/*
 ******************************************************************************
 *
 *  General typedefs.
 *
 ******************************************************************************
 */
typedef unsigned char  UINT8;
typedef   signed char   INT8;
typedef unsigned short UINT16;
typedef   signed short  INT16;
typedef unsigned long  UINT32;
typedef   signed long   INT32;



typedef struct 
{
  UINT16 u16CompPress;      /* I/O 9-bit Compensated pressure reading   */
  UINT8  u8ElapsedTime;     /* I Elapsed time from previous reading     */
  UINT16 u16WAvg;           /* O Weighed average for running pressure   */
  UINT8  u8PRes;            /* O 8-bit pressure reserve value           */
  UINT8  u8PMin;            /* O 8-bit minimum pressure value           */
  UINT8  u8RDEStatusFlags;  /* O Contains flags for Plock and RDE Event */
  UINT16 u16RDEBailTimeOut; /* O Seconds to 60 mins bail-out            */
  UINT8  u8RDETimeToAvg;    /* O Seconds to next averaging event        */
} T_RDE;



/* Dynamic acceleration G-level offset index */
enum
{
  G_LEVEL_OFFSET_N144 = 0u,
  G_LEVEL_OFFSET_N120,
  G_LEVEL_OFFSET_N96,
  G_LEVEL_OFFSET_N72,
  G_LEVEL_OFFSET_N48,
  G_LEVEL_OFFSET_N24,
  G_LEVEL_OFFSET_0,
  G_LEVEL_OFFSET_24,
  G_LEVEL_OFFSET_48,
  G_LEVEL_OFFSET_72,
  G_LEVEL_OFFSET_96,
  G_LEVEL_OFFSET_120,
  G_LEVEL_OFFSET_144,
  G_LEVEL_OFFSET_168,
  G_LEVEL_OFFSET_192,
  G_LEVEL_OFFSET_216
};
  
  
/*
 ******************************************************************************
 *
 * User's interrupt wrappers. The user must handle interrupts through routine
 * prototypes included in "user_int_routines.c"
 *
 ******************************************************************************
 */
/*
 ******************************************************************************
 *
 * Global Variables
 *
 ******************************************************************************
 */
#pragma DATA_SEG BATTERY_BACKED_RAM
extern UINT16 gu16UUMA[];
extern UINT16 FrameID;

#pragma DATA_SEG FIRMWARE_GLOBAL_RAM
extern UINT8 TPMS_CONT_ACCEL_GV  @ 0x008Eu; /* Embedded Firmware maps this location */
extern UINT8 TPMS_INTERRUPT_FLAG @ 0x008Fu; /* Embedded Firmware maps this location */

/*
 ******************************************************************************
 *
 * Function Prototypes
 *
 ******************************************************************************
 */
#pragma CODE_SEG DEFAULT
/*
 *******************************************************************************
 *
 * Function:          main()
 *
 */
/*!
 * \internal
 * \brief    main function.
 * \param    Nothing
 * \return   Void
 *
 *****************************************************************************/
void main(void);
/*
 *******************************************************************************
 *
 * Function:          vfnSetupMCU()
 *
 */
/*!
 * \brief    This function disables the COP and enables STOP.
 * \param    Nothing
 * \return   Void
 *
 *****************************************************************************/
void vfnSetupMCU(void);
/*
 *******************************************************************************
 *
 * Function:          vfnSetSTOPMode()
 *
 */
/*!
 * \brief    This function configures the MCU for either STOP1 or STOP4.
 * \param    UINT8 u8Mode: 1 for STOP1, 4 for STOP4.
 * \return   Void
 *
 *****************************************************************************/
void vfnSetSTOPMode(UINT8 u8Mode);
/*
 *******************************************************************************
 *
 * Function:          vfnSetPWU()
 *
 */
/*!
 * \brief    This function configures the PWU for a periodic wake-up.
 * \param    Nothing
 * \return   Void
 *
 *****************************************************************************/
void vfnSetPWU(void);
void Init_RF(void);
void delay (unsigned char);
UINT8 CheckSum_FSL_Full(UINT8 *array, UINT8 u8Size);
void Fill_RFBUFFER(void);
void delay (unsigned char);
void Measure_P_T_V_AccZ(void);
void vfnSetupGPIO(void);
UINT16 u16fnAccessUUMA(UINT8 u8Index);

/* Added for MKW01 CRC */
UINT16 Calculate_CRC_MKW01( UINT8 *buffer, UINT8 length );
UINT16 ComputeCrc_MKW01( UINT16 crc, UINT8 dataByte, UINT16 polynomial );

#pragma CODE_SEG DEFAULT
#endif /* MAIN_INCLUDED */
/*
 ******************************************************************************
 *
 * End of file.
 *
 ******************************************************************************
 */
