/**
  \mainpage 
  
  \n Copyright (c) 2013 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief      Layered firmware for TPMS centrifuge applications.
  
  \author   	Freescale Semiconductor
  \author         SASD Automotive
  \author   	R11515
  
*/
/**
  Copyright (c) 2010 - 2014 Freescale Semiconductor
  \file     	common.h
  \brief    	
  \author   	Freescale Semiconductor
  \author         SASD Automotive     
  \author   	R11515
  \version    
  \date     	

  * History:
  
*/

#ifndef _COMMON_H
#define _COMMON_H

/*
 **************************************************************
 * Defines, Macros and Typedefs 
 **************************************************************/
/* Constant Macros */

#define BIT0	((UINT8)1u)
#define BIT1	((UINT8)2u)
#define BIT2	((UINT8)4u)
#define BIT3	((UINT8)8u)
#define BIT4	((UINT8)16u)
#define BIT5	((UINT8)32u)
#define BIT6	((UINT8)64u)
#define BIT7	((UINT8)128u)
#define BIT8  ((UINT16)256u)
#define BIT9  ((UINT16)512u)
#define BIT10 ((UINT16)1024u)
#define BIT11 ((UINT16)2048u)
#define BIT12 ((UINT16)4096u)
#define BIT13 ((UINT16)8192u)
#define BIT14 ((UINT16)16384u)
#define BIT15 ((UINT16)32768u)
#define BIT16 ((UINT32)65536u)

#ifndef CLEAR
#define CLEAR (0u)
#endif
#ifndef SET
#define SET   (1u)
#endif

#define MAX_COUNT_BYTE   ((UINT8)0xFFu)
#define MAX_COUNT_WORD   ((UINT16)0xFFFFu)
#define MSB_8_BITS   (0x80u)
#define BITS_IN_BYTE (8u)
#define BITS_IN_NIBBLE   ((UINT8)(4u))
#define MSN_MASK         ((UINT8)(0xF0u))
#define LSN_MASK         ((UINT8)(0x0Fu))
#define EMPTY_FLASH_VALUE_BYTE ((UINT8)0xFFu)
#define EMPTY_FLASH_VALUE_WORD ((UINT16)0xFFFFu)
#define HALF_10_BIT_RAIL       ((UINT16)0x200u)

#define SIMSES_FLAGS_MASK ((UINT8)0x3Fu)

#define UUMA_SIZE_WORD  ((UINT8)5u)
#define UUMA_SIZE_BYTE  (UUMA_SIZE_WORD * sizeof(UINT16))

/* Define memory spaces */
#define FLASH_FSL_START_ADDRESS ((UINT16)0xE000u)
#define FLASH_FSL_END_ADDRESS   ((UINT16)0xFFAEu)
#define FLASH_FSL_SIZE          (FLASH_FSL_END_ADDRESS - FLASH_FSL_START_ADDRESS)


/* For InterruptFlags */
#define LVD_INTERRUPT_FLAG     BIT7
#define PWU_INTERRUPT_FLAG     BIT6
#define TOF_INTERRUPT_FLAG     BIT5
#define LFERROR_INTERRUPT_FLAG BIT4
#define ADC_INTERRUPT_FLAG     BIT3
#define LFR_INTERRUPT_FLAG     BIT2
#define RTI_INTERRUPT_FLAG     BIT1
#define KBI_INTERRUPT_FLAG     BIT0

/* Status Flag Related */
#define OVERFLOW_ERROR BIT0
#define BONDING_ERROR  BIT1
#define PCELL_ERROR    BIT2
#define XGCELL_ERROR   BIT3
#define ZGCELL_ERROR   BIT4
#define VOLT_ERROR     BIT5
#define TEMP_ERROR     BIT6
#define ADC_ERROR      BIT7

/* For STOP and Interrupt Flag */
#define INTERRUPT_TIME_OUT_VALUE ((UINT8)5u)

/* Absolute Memory Locations */
#define RAM_SPACE_END         (0x028Fu)

/* For SetSystemRegisters */
#define STOP1         ((UINT8)1u)
#define STOP4         ((UINT8)4u)
#define STOP_ENABLED  ((UINT8)1u) 
#define STOP_DISABLED ((UINT8)0u)
#define COP_ENABLED   SET
#define COP_DISABLED  CLEAR

/* When a macro is written in assembly, PCLint shouldn't bother going over it at all */
#define PCLINT_EXCEPTION_ASM_MACRO(xx) /*lint --emacro(*, xx) */

/* Function Macros */
PCLINT_EXCEPTION_ASM_MACRO(asmmacroLoadIntoAccumulator)
#define asmmacroLoadIntoAccumulator(XX)  {__asm LDA  %(XX);}

PCLINT_EXCEPTION_ASM_MACRO(asmmacroWaitAccClocks)
#define asmmacroWaitAccClocks()          {asm ldx %(7); asm decx; asm bne -3; asm deca; asm bne -8;}

#define NUL 
/*! Determines the number of elements within an array */
#define N_ELEMENTS(xx) (sizeof(xx)/sizeof(*xx))

/* Enums */ 

/* TypeDefs */
typedef unsigned char   UINT8;  	/** unsigned 8 bit definition  */
typedef unsigned short  UINT16; 	/** unsigned 16 bit definition */
typedef unsigned long   UINT32; 	/** unsigned 32 bit definition */
typedef signed char      INT8;   	/** signed 8 bit definition    */
typedef signed short     INT16;  	/** signed 16 bit definition   */
typedef long int    	 INT32;  	/** signed 32 bit definition   */


/*
 **************************************************************
 * Declarations 
 **************************************************************/
/* Extern */

/* Globals */

/* Static Globals */

/*
 **************************************************************
 * Function Prototypes 
 **************************************************************/

#endif /* _FILENAME_H */
