/*************************************************************************//**
 * @file LFAST.h
 * @copyright Freescale 2014 All Rights Reserved                             
 * @version 1.1                                                              
 * @brief This file defines all the data types and constants for LFAST.c
 * @date 13-Dec-15
 * @author S.Becerra                                                        */
/*===========================================================================*
 * UPDATE HISTORY                                                            *
 * REV      AUTHOR      DATE       	DESCRIPTION OF CHANGE                    *
 * ---   -----------  ---------    	---------------------                    * 
 * 1.0     MSG-IDC                  Original source from IDC                 *
 *                                                                           *
 * 1.1   S.Becerra    13-Jan-15    Added definitions                         *
 *                                                                           *
 *===========================================================================*
 * COPYRIGHT:                                                                *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby        *
 *  granted a copyright license to use, modify, and distribute the           *
 *  SOFTWARE so long as this entire notice is retained without alteration    *
 *  in any modified and/or redistributed versions, and that such modified    *
 *  versions are clearly identified as such. No licenses are granted by      *
 *  implication, estoppel or otherwise under any patentsor trademarks        *
 *  of Freescale Semiconductor, Inc. This software is provided on an         *
 *  "AS IS" basis and without warranty.                                      *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, Freescale             *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,       *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A         *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD     *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY        *
 *  ACCOMPANYING WRITTEN MATERIALS.                                          *
 *                                                                           *
 *  To the maximum extent permitted by applicable law, IN NO EVENT           *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER       *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,     *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER            *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.     *
 *                                                                           *
 *  Freescale Semiconductor assumes no responsibility for the                *
 *  maintenance and support of this software                                 *
 *                                                                           *
 ****************************************************************************/

#ifndef _LFAST_H_
#define _LFAST_H_

#include "typedefs.h"
#include "mpc5777m.h"

/******************************Definitions***********************************/

#define FAST	1
#define SLOW    0
#define REF_10	1
#define REF_20	2

#define	MASTER	1
#define SLAVE	0
#define SINGLE  2

#define AUTO	1
#define MANUAL	0

#define INT		0
#define EXT		0


/* MCR */
#define MCR_MSEN 0x80000000
#define MCR_DATAEN 0x00000001
#define MCR_LSSEL 0x00010000
#define MCR_DRFEN 0x00008000
#define MCR_RXEN 0x00004000
#define MCR_TXEN 0x00002000
#define MCR_TXARBD 0x00000010

/* SCR */
#define SCR_DRMD 0x00010000
#define SCR_RDR 0x00000100
#define SCR_TDR 0x00000001

/* ICR */
#define ICR_ICLCSEQ 0x00020000
#define ICR_SNDICLC 0x00010000
#define ICR_ICLCPLD 0x000000FF
#define ICR_ICLCPLD_02 0x00000002
#define ICR_ICLCPLD_08 0x00000008
#define ICR_ICLCPLD_10 0x00000010
#define ICR_ICLCPLD_31 0x00000031
#define ICR_ICLCPLD_80 0x00000080

/* PICR */
#define PICR_PNGAUTO 0x00008000

/* LCR */
#define LCR_LVTXOE 0x00004000
#define LCR_LVRFEN 0x00001000
#define LCR_LVRXOP_4 0x00000020
#define LCR_LVTXOP 0x00000004

/* GSR */
#define GSR_LDSM 0x00020000
#define GSR_DRSM 0x00010000

/* TISR */
#define TISR_TXICLCF 0x00000002

/* RIISR */
#define RIISR_ICPFF 0x00002000
#define RIISR_ICPSF 0x00001000
#define RIISR_ICPRF 0x00000800
#define RIISR_ICTEF 0x00000040
#define RIISR_ICRFF 0x00000020
#define RIISR_ICTFF 0x00000008
#define RIISR_ICPONF 0x00000001

/* PLLCR */
#define PLLCR_SWPON 0x00010000
#define PLLCR_FBDIV 0x000000FC

/* PLLLSR */
#define PLLLSR_PLLDIS 0x00020000
#define PLLLSR_PLDCR 0x00010000
#define PLLLSR_LPCFG 0x00006000
#define PLLLSR_PREDIV 0x00000003


/**************************Global Functions to be exported*********************/
/** \fn LFAST_clk_settings(volatile struct LFAST_tag *LFAST, uint8_t ref, uint8_t speed, uint8_t direction)

	\brief Configures the Slave node to drive a 20 MHz Clock on PF12. The Master node receives the clock and uses it as its clock source.
	\return 
			Nothing
	\param[in] volatile struct LFAST_tag *LFAST LFAST structure to point to the desired LFAST instance to be used.
	\param[in] uint8_t ref reference clock to be used.
	\param[in] uint8_t speed desired speed
	\param[in] uint8_t direction Sets if the Module will act as Master or SLAVE
*/
void LFAST_clk_settings(volatile struct LFAST_tag *LFAST, uint8_t ref, uint8_t speed, uint8_t direction);

#endif /* _LFAST_H_ */
