::-----------------------------------------------------------------------------
:: Copyright:	Freescale 2015 - All rights reserved - Confidential Property
:: Warning:		Example Code - Subject to change without notice
:: File Name:	MPC5777M_SC_debug_start.bat
:: Description:	Launch T32 and run "MPC5777M_SC_debug.cmm"
:: Notes:	- Single Core Debug
::			- Launch procedure in cmd: "MPC5777M_SC_debug_start.bat PARAM"
:: ToDos:	- Add PARAM List to "Notes" and describe functions
::			- Create CONFIG File to store GHS BUILD Path and Backup Files list
::-----------------------------------------------------------------------------
:: Rev		Author					Date		Description
:: 1.0		Samuel Perez Azaola		03/12/2014	Initial Release
:: 1.1		Samuel Perez Azaola		08/12/2014	Merged Backup function into "MPC5777M_SC_debug_start.bat"
:: 1.2		Samuel Perez Azaola		09/12/2014	Split Backup function from "MPC5777M_SC_debug_start.bat"
:: 1.3		Samuel Perez Azaola		10/12/2014	Added "t32mppc.exe" Process detect to avoid double launch
:: 1.4		Samuel Perez Azaola		15/12/2014	Added "BUILD" Option
:: 1.5		Samuel Perez Azaola		16/12/2014	- Added "PROJ_LOC" and "PROJ_NAM" Variables
::												- Added "/t" parameter to "taskkill" to close child processes
:: 2.0		Samuel Perez Azaola		17/12/2014	- Inserted "Backup" Function from "MPC5777M_SC_debug_backup.bat" REV 2.1
::												- Added "LTB" in "BCKP" to suppress "Done" Dialogue
::												- Added Title "cmd_mpc5777m_t32startup" to spot process in Tasklist
:: 2.1		Samuel Perez Azaola		19/12/2014	- Added "LTB" in "BUILD" to suppress "Done" Dialogue
::												- Added Error Message for Function ":StartT32"
:: 2.2		Samuel Perez Azaola		21/12/2014	Added "CLEAN" Parameter with "LTB" detect
:: 2.3		Samuel Perez Azaola		07/01/2015	- Added "RESTART" Parameter
::												- Added second chance on debugger launch: Already Running -> Still Running
::												- Changed Default Backup Location to Script folder
::												- Added "WINRAR_DIR" for user easier configuration
::												- Updated Backup File List
:: 2.4		Samuel Perez Azaola		08/01/2015	- BUILD Options lets user select compiler + Default Run
::												- Script checks for 32/64bit versions of t32mppc
:: 2.5		Samuel Perez Azaola		08/01/2015	Major GIT Release
:: 2.6		Samuel Perez Azaola		09/01/2015	- Added: "GHSCOMP_PATH_A/B" for ease of use with other versions of GHS
::												- Deleted: .LOG Files from the backup list
::-----------------------------------------------------------------------------

@echo OFF



title=cmd_mpc5777m_t32startup

:: Variables
set PROG_NAME=t32mppc
set PROG_PATH=c:\t32\bin\windows64\
set GHS_PROJ_LOC=MPC5777M_GHS_SC_BIST
set GHS_PROJ_NAM=MPC5777M_default
set WINRAR_PATH=C:\Program Files\WinRAR\WinRAR
set GHSCOMP_PATH_A=C:\ghs\comp_201354_PPC\gbuild.exe
set GHSCOMP_PATH_B=C:\ghs\comp_201354\gbuild.exe

:: Parameter: "BUILD"
if "%1"=="BUILD" (
	call :Build_Proj %2
	exit /b
)

:: Parameter: "BCKP"
if "%1"=="BCKP" (
	call :Backup %2 %3
	exit /b
)

:: Parameter: "CLEAN"
if "%1"=="CLEAN" (
	del /f /q *.bak
	if not "%2"=="LTB" call :MsgBox "Cleanup Complete!" "vbOKOnly+vbApplicationModal+VbMsgBoxSetForeground" "T32 Launcher"
	exit /b
)

:: Parameter: "RESTART"
if "%1"=="RESTART" (
	timeout /t 1 /nobreak
	goto POST_RESTART_DELAY
)

:: Parameter: No Parameter
if "%1"=="" (
:POST_RESTART_DELAY
	call :StartT32
	exit /b
)

call :MsgBox "No Valid Parameters Found!" "vbOKOnly+vbExclamation+vbApplicationModal+VbMsgBoxSetForeground" "Warning"
exit /b

::-----------------------------------------------------------------------------
:: Functions
::-----------------------------------------------------------------------------

:StartT32
	if not exist "%PROG_PATH%" set PROG_PATH=c:\t32\bin\windows\
	start %PROG_PATH%%PROG_NAME% -c config_mc.t32,MPC5777M_SC_debug.cmm 1000 MPC5777M_Core2(IOP) USB CORE=1
	if not "%errorlevel%"=="0" call :MsgBox "Error: %errorlevel%. Check: '%PROG_NAME%'" "vbOKOnly+vbApplicationModal+VbMsgBoxSetForeground" "T32 Launcher"
	endlocal & exit /b %errorlevel%

:Build_Proj
	if exist "%GHSCOMP_PATH_A%" set GHSCOMP_PATH=%GHSCOMP_PATH_A% & goto :EXIT_COMP_LOOP
	if exist "%GHSCOMP_PATH_B%" set GHSCOMP_PATH=%GHSCOMP_PATH_B% & goto :EXIT_COMP_LOOP
	@echo OFF
	cls
	set /a CNT=0
	setLocal EnableDelayedExpansion
	for /f %%f in ('dir C:\ghs\gbuild.exe /s/b') do (
		set /a CNT+=1
		@echo !CNT!. %%f  %%~tf
	)
	SET /P comp_num=Enter Compiler Number:
	set /a CNT=0
	setLocal EnableDelayedExpansion
	for /f %%f in ('dir C:\ghs\gbuild.exe /s/b') do (
		set /a CNT+=1
		if "!CNT!"=="%comp_num%" set GHSCOMP_PATH=%%f & goto :EXIT_COMP_LOOP
	)
	:EXIT_COMP_LOOP
	@echo Compiler Choice = "%GHSCOMP_PATH%"
	%GHSCOMP_PATH% -cleanfirst -top %~dp0\%GHS_PROJ_LOC%\%GHS_PROJ_NAM%.gpj
	set /a error=%errorlevel%
	@echo Compiler errorlevel=%errorlevel%
	if not %error%==0 (
		call :MsgBox "GHS Build Failed! (%error%)" "vbOKOnly+vbApplicationModal+VbMsgBoxSetForeground" "GHS BUILD"
	) else (
		call :MsgBox "GHS Build Succesful!" "vbOKOnly+vbApplicationModal+VbMsgBoxSetForeground" "GHS BUILD"
	)
	endlocal & exit /b %error%
		
:MsgBox text type Title
    setlocal enableextensions
    set "tempFile=%temp%\%~nx0.%random%%random%%random%vbs.tmp"
    >"%tempFile%" echo(WScript.Quit msgBox("%~1",%~2,"%~3") & cscript //nologo //e:vbscript "%tempFile%"
    set "exitCode=%errorlevel%" & del "%tempFile%" >nul 2>nul
    endlocal & exit /b %exitCode%
	
:Backup param1 param1
	set hour=%time:~0,2%
	if "%hour:~0,1%"==" " set hour=0%hour:~1,1%
	set min=%time:~3,2%
	if "%min:~0,1%"==" " set min=0%min:~1,1%
	set secs=%time:~6,2%
	if "%secs:~0,1%"==" " set secs=0%secs:~1,1%
	set year=%date:~-4%
	set month=%date:~3,2%
	if "%month:~0,1%"==" " set month=0%month:~1,1%
	set day=%date:~0,2%
	if "%day:~0,1%"==" " set day=0%day:~1,1%
	
	set timestamp=%year%%month%%day%_%hour%%min%%secs%
	
	setlocal enabledelayedexpansion
	(
		echo %~dp0\MPC5777M_GHS_SC_PER_DEMO
		echo %~dp0\MPC5777M_LTB_DCF_RECORD
		echo %~dp0\config_mc.t32
		echo %~dp0\custom_windows.cmm
		echo %~dp0\MPC5777M_SC_debug.cmm
		echo %~dp0\MPC5777M_SC_debug_launcher.bat
		echo %~dp0\MPC5777M_SC_debug_start.bat
		echo %~dp0\VBS_IE_BUTTONS.vbs
	)>list%timestamp%.txt

	"%WINRAR_PATH%" a -ep1 -m5 "%~dp0\MPC5777M_GHS_SC_PER_DEMO_%timestamp%.rar" @list%timestamp%.txt
	set "exitCode=%errorlevel%"
	
	del list%timestamp%.txt
	
	:: Backup: launched from .bat
	if not "%~1"=="LTB" (
		:: Show "Success/Error" Dialogue
		if "%exitCode%"=="0" call :MsgBox "Backup Finished" "vbOKOnly+vbApplicationModal+VbMsgBoxSetForeground" "Backup"
		if "%exitCode%"=="1" call :MsgBox "Backup Error %errorlevel%" "vbOKOnly+vbApplicationModal+VbMsgBoxSetForeground" "Backup"
	)
	endlocal & exit /b %exitCode%