/*---------- MODIFY THIS SECTION FOR YOUR DEVICE -----------*/
DEFAULTS {
// Define Core 1 Flash Allocation
   FLASH_SIZE = 256K       
// Define Core 1 Flash Base Address 
   FLASH_BASE_ADDR = 0x01040000 
        
// Define Core 1 SRAM Allocation  
   C1_SRAM_SIZE =  16K    
// Define Processor 1 SRAM Base Address
   C1_SRAM_BASE_ADDR = 0x40010000    

// Define Core 1 Local Instruction SRAM Allocation  
   C1_LOCALIMEM_SIZE =  16K    
// Define Processor 1 Local Instruction SRAM Base Address
   C1_LOCALIMEM_BASE_ADDR = 0x51000000   
   
// Define Core 1 Local Data SRAM Allocation  
   C1_LOCALDMEM_SIZE =  64K    
// Define Processor 1 Local Data SRAM Base Address
   C1_LOCALDMEM_BASE_ADDR = 0x51800000    
   
// Stack located at end of SRAM     
// Define Stack Size
   STACK_SIZE = 1K       
       
}

/*---------- DO NOT MODIFY ANYTHING BELOW THIS POINT -------*/
MEMORY {
    int_flash : org = FLASH_BASE_ADDR,     len = FLASH_SIZE
    int_sram  : org = C1_SRAM_BASE_ADDR,   len = C1_SRAM_SIZE-STACK_SIZE
//    stack_ram : org = (C1_SRAM_BASE_ADDR+C1_SRAM_SIZE-STACK_SIZE)  len = STACK_SIZE
    stack_ram : org = C1_LOCALDMEM_BASE_ADDR  len = STACK_SIZE  
}

SECTIONS
{


    .init             : {} > int_flash 			
    .text             : {} > .              /* BookE Code   */
    .vletext          : {} > .              /* VLE Code */
                                            
    .fixaddr          : {} > .              /* Required for         */
    .fixtype          : {} > .              /* compatibility with   */
    .secinfo          : {} > .              /* GHS provided startup */
    .syscall          : {} > .              /* code                 */

    .isrvectbl    ALIGN(0x1000)   : {} > .  /* ISR Vector Table - must be 4K aligned */
    .xptn_vectors ALIGN(0x1000)   : {} > .   /* Exception Vector Table (IVPR) - align 4K boundary */ 
    .IVOR4_HWvectors ALIGN(0x1000): {} > .   /* IVOR4 HW Vector Table (IVPR) - align 4K boundary */
	
    .rodata  : {*(.rdata) *(.rodata)} > .   /* Read Only Data */
     
    .ROM.data   ROM(.data)       : {} > .   /* Store Initialised RAM Variables */
    .ROM.sdata  ROM(.sdata)      : {} > .   /* temporarily in Flash            */
                                            
    .data             : {} > int_sram       /* Initialised Data                */
    .bss              : {} > .              /* Uninitialised Data              */
    .sdabase ALIGN (2): {} > .              /* Base location for SDA Area      */
    .sdata            : {} > .              /* Small Initialised Data (Area1)  */
    .sbss             : {} > .              /* Small Uninitialised Data (Area1)*/
    .sdata2           : {} > .              /* Small Initialised Constant Data */
    .sbss2            : {} > .              /* Small Uninitialised Data (Area2)*/
    
    .heap   ALIGN(16) PAD(1K)         : {} > int_sram   /* Heap Area  */
    .stack  ALIGN(4)  PAD(STACK_SIZE) : {} > stack_ram  /* Stack Area */

/*------------------------------------------------------------*/
/*  Example of allocating section at absolute address         */
/*                                                            */
/*  .my_section 0x40001000 :{} > int_flash                    */
/*                                                            */
/*  Linker uses "0x40001000" address, rather than "int_flash" */
/*------------------------------------------------------------*/

/*-------- LABELS USED IN CODE -------------------------------*/
        
/* Stack Address Parameters */
__SP_INIT      = ADDR(stack_ram) + SIZEOF(stack_ram); 

/* Interrupt Handler Parameters */
__IVPR = ADDR(.xptn_vectors);

/* Label for Local SRAM Init */
__LOCAL_DMEM_SIZE=C1_LOCALDMEM_SIZE;
__LOCAL_DMEM_BASE_ADDR =C1_LOCALDMEM_BASE_ADDR;

__LOCAL_IMEM_SIZE=C1_LOCALIMEM_SIZE;
__LOCAL_IMEM_BASE_ADDR =C1_LOCALIMEM_BASE_ADDR;

/* Labels for Copying Initialised Data from Flash to RAM */
__DATA_SRAM_ADDR  = ADDR(.data);
__SDATA_SRAM_ADDR = ADDR(.sdata);

__DATA_SIZE   = SIZEOF(.data);
__SDATA_SIZE  = SIZEOF(.sdata);

__DATA_ROM_ADDR  = ADDR(.ROM.data);
__SDATA_ROM_ADDR = ADDR(.ROM.sdata);

/* These special symbols mark the bounds of RAM and ROM memory. */
/* They are used by the MULTI debugger.                         */

    __ghs_ramstart  = MEMADDR(int_sram);
    __ghs_ramend    = MEMENDADDR(int_sram);
    __ghs_romstart  = MEMADDR(int_flash);
    __ghs_romend    = MEMENDADDR(int_flash);

    __ghs_rambootcodestart = 0;           /* zero for ROM image */
    __ghs_rambootcodeend = 0;             /* zero for ROM image */
    __ghs_rombootcodestart = MEMADDR(int_flash);
    __ghs_rombootcodeend = MEMENDADDR(int_flash);

}
