#*****************************************************************************/
#* FILE NAME: mem_init                      COPYRIGHT (c) Freescale 2012 */
#*                                                       All Rights Reserved */
#* DESCRIPTION:                                                              */
#* Function to re initialize the memory and ECC                  */
#* Flash Execution                                                            */	
#*===========================================================================*/
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE                    */
#* ---   -----------    ----------    ---------------------                  										*/
#* 1.0	  A Turner    			04/2/15   Initial Public Release                                */
#*****************************************************************************/

 .globl	_mem_init
 
 # macro to allow immediate register load to be done more easily
 .macro e_lwi  register value
  e_lis register, value@h
  e_or2i register, value@l        
  .endm

 #************************** GHS Section Infomation ***************************/	
 .section .init , axv
 .vle
 .align 4
_mem_init:



#***************************** Initialise SRAM ECC ***************************/
# Store number of 128Byte (32GPRs) segments in Counter
  e_lis       r5, __SRAM_SIZE@h  # Initialize r5 to size of SRAM (Bytes)
 e_or2i      r5, __SRAM_SIZE@l
 e_srwi      r5, r5, 0x7         # Divide SRAM size by 128
  mtctr       r5                  # Move to counter for use with "bdnz"
    
# Base Address of the internal SRAM
 e_lis       r5, __SRAM_BASE_ADDR@h
 e_or2i      r5, __SRAM_BASE_ADDR@l

# Fill SRAM with writes of 32GPRs    
sram_loop:
    e_stmw      r0,0(r5)            # Write all 32 registers to SRAM
    e_addi      r5,r5,128           # Increment the RAM pointer to next 128bytes
    e_bdnz      sram_loop           # Loop for all of SRAM

#************************ Initialise Local Data SRAM *************************/
# Store number of 128Byte (32GPRs) segments in Counter
 e_lis       r5, __LOCAL_DMEM_SIZE@h  # Initialize r5 to size of SRAM (Bytes)
 e_or2i      r5, __LOCAL_DMEM_SIZE@l
 e_srwi      r5, r5, 0x7         # Divide SRAM size by 128
 mtctr       r5                  # Move to counter for use with "bdnz"
    
# Base Address of the Local SRAM
 e_lis       r5, __LOCAL_DMEM_BASE_ADDR@h
 e_or2i      r5, __LOCAL_DMEM_BASE_ADDR@l

# Fill Local SRAM with writes of 32GPRs    
ldmem_loop:
    e_stmw      r0,0(r5)            # Write all 32 registers to SRAM
    e_addi      r5,r5,128           # Increment the RAM pointer to next 128bytes
    e_bdnz      ldmem_loop           # Loop for all of SRAM

#************************ Initialise Local Instruction SRAM ******************/
# Store number of 128Byte (32GPRs) segments in Counter
 e_lis       r5, __LOCAL_IMEM_SIZE@h  # Initialize r5 to size of SRAM (Bytes)
 e_or2i      r5, __LOCAL_IMEM_SIZE@l
 e_srwi      r5, r5, 0x7         # Divide SRAM size by 128
 mtctr       r5                  # Move to counter for use with "bdnz"
    
# Base Address of the Local SRAM
 e_lis       r5, __LOCAL_IMEM_BASE_ADDR@h
 e_or2i      r5, __LOCAL_IMEM_BASE_ADDR@l

# Fill Local SRAM with writes of 32GPRs    
limem_loop:
    e_stmw      r0,0(r5)            # Write all 32 registers to SRAM
    e_addi      r5,r5,128           # Increment the RAM pointer to next 128bytes
    e_bdnz      limem_loop          # Loop for all of SRAM	       
		   

#****************** Invalidate and Enable the Instruction cache	***************/


__icache_cfg:

#***Instruction cache disable**************************************/
  e_li r5, 0x0
  mtspr 1011,r5
  
  e_li r5, 0x0
   e_li r5, 0x0
    e_li r5, 0x0
 mtspr 1011,r5
 
#***Instruction cache invalidate - set ICFI**************************************/ 
  e_li r5, 0x2
  mtspr 1011,r5

  e_li r7, 0x4
  e_li r8, 0x2
  e_lwi r11, 0xFFFFFFFB

__icache_inv:
  mfspr r9, 1011
  and.  r10, r7, r9
  e_beq   __icache_no_abort
  and.  r10, r11, r9
  mtspr 1011, r10
  e_b     __icache_cfg

__icache_no_abort:
  and.  r10, r8, r9
  e_bne __icache_inv

  mfspr r5, 1011
  e_ori   r5, r5, 0x0001
  se_isync
  msync
  mtspr 1011, r5  




# Jump to Main
se_blr 
	  
       

		
