//-----------------------------------------------------------------------------
// Copyright:	Freescale 2014 - All rights reserved - Confidential Property
//
// Warning: 	Example Code - Subject to change without notice
//
// File Name: 	mcu_init_flash.c
//
// Description: Configure Core Reset Adresses for MPC5777M running from FLASH
//
//-----------------------------------------------------------------------------
// Revision	Author				Date		Description
// 1.0		samuel@freescale.com		27/11/214	Initial Public Release
//-----------------------------------------------------------------------------

#include "../../headers/project.h"
#include "../../headers/MPC5777m.h"

//------------------- Functions Constants/Variables/Defines -------------------

//--------------------------- Functions Declaration ---------------------------

void mc_core_rst_addr(void);		// Configure Core Reset Adresses 

//------------------- Functions Constants/Variables/Defines -------------------

//Function: mc_core_reset_address ---------------------------------------------

void mc_core_rst_addr(void)
{
    // Set Start address for other cores: Will reset and start
    // Flash Addresses
    if(SIUL2.MIDR1.R & 0x10){		// Only CUT2 & CUT2B
	MC_ME.CADDR1.R = 0x01200001;	// Core 0 
	MC_ME.CADDR2.R = 0x00000001;	// Core 0_s RMC bit = 1, no ADDR field in Cut 2 
	MC_ME.CADDR3.R = 0x01400001;	// Core 1
	MC_ME.CADDR4.R = 0x01040001;	// HSM
    }else{
	MC_ME.CADDR1.R = 0x01010001; 	// Core 0 
	MC_ME.CADDR2.R = 0x01010001; 	// Core 0_s
	MC_ME.CADDR3.R = 0x01014001; 	// Core 1
	MC_ME.CADDR4.R = 0x01014001; 	// HSM  
    }
}
