//-----------------------------------------------------------------------------
// Copyright:	Freescale 2014 - All rights reserved - Confidential Property
//
// Warning: 	Example Code - Subject to change without notice
//
// File Name: 	interrupt_cnfg_table.c
//
// Description:
//	This file contains a table of ISRs for INTC in software (SW) vector
//	mode. The table contains addresses for 1024 ISR vectors. Table address
//	stards at base of section ".isrvectbl" This file is an example
//	Interrupt Service Routine call file with ISR's be replaced by the
//	user application code as needed.
//
// Notes:
//	- For details about Device Temperature calcultations see "tsens.c"
//-----------------------------------------------------------------------------
// - interrupt_cnfg_table.c
// Revision	Author			Date		Description
// 0.1   	S. Mihalik		07/06/2004	Initial version
// 0.2	  	R. Moran		23/02/2007	Modified for specific test ISRs
// 0.21	  	I. Harris		11/01/2010	Modified for specific test ISRs
// 0.23   	I.Harris		01/02/2011	Modified for GTM FPGA
// 0.23   	I.Harris		01/02/2012	Modified for MPC5764M
// 1.0		samuel@freescale.com	03/12/2014	- Combined "interrupt routines" and "INTCISRVEC_table". Renamed "interrupt_cnfg_table.c"
//							- Added "STM_2_CH_0()" related to TSENS Operations
//							- Added "SARADC_B_INT()" related to TSENS Operations
//-----------------------------------------------------------------------------
// - MPC57xx_Interrupt_Init.c
// Revision	Author			Date		Description
// 1.0		Robert Moran		27/10/2014	Initial Release
// 1.1		Samuel Perez Azaola	17/11/2014	Code Cleanup
//-----------------------------------------------------------------------------
// Revision	Author			Date		Description
// 1.0		samuel@freescale.com	12/12/2014	- Updated "TSCA" and "TSCA" Extraction for "tsens_temp_c" in "SARADC_B_INT"

//-----------------------------------------------------------------------------

#include "../../headers/typedefs.h"
#include "../../headers/MPC5777m.h"
#include "../../headers/project.h"

//--------------------------- Functions Prototypes ---------------------------

extern void e200zX_Interrupt_Setup(void);	// External Prototype in: "Vector_SW_VLE - Z4.s"

void intc_init(void);		// Intializes the INTC for software vector mode and priority level for the interrupts (Add configs as required)
void xirq_ena(void);		// Sets INTC's current priority to 0. External interrupts to the core are enabled
void irq_cnfg(void);		// Sets up the necessary functions to raise and handle a SWT Interrupt in hardware vector mode

void dummy(void);		// Dummy function which is entered if any non-used vector is called.
void IRQ_PIT0_CH2(void);	// PIT0 CH2
void IRQ_PIT0_RTI(void);	// PIT0 RTI
void STM_2_CH_0(void);		// Starts SARADC_B Scan at set intervals to get device Temperature


//------------------- Functions Constants/Variables/Defines -------------------

volatile float 		tsens_temp_c=0x0;	// Device Temperature in Degrees Celcius

// Place the constant "IntcIsrVectorTable" in section .isrvectbl
// Routine for Diab compiler
//#pragma section const_type ".isrvectbl" ".isrvectbl"
//#pragma use_section const_type IntcIsrVectorTable
        
// Vector Table. ISRs called are:
// Software Settable Interrupt 4, Vector 4

#pragma ghs section rodata =".isrvectbl"

uint32_t const IntcIsrVectorTable[] = {
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 00 - 04 
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 05 - 09
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 10 - 14
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 15 - 19
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 20 - 24
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 25 - 29
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 30 - 34
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 35 - 39
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&STM_2_CH_0,	// ISRs 40 - 44
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 45 - 49
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 50 - 54
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 55 - 59
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 60 - 64
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 65 - 69
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 70 - 74
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 75 - 79
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 80 - 84
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 85 - 89
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 90 - 94
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 95 - 99
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 100 - 104
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 105 - 109
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 110 - 114
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 115 - 119
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 120 - 124
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 125 - 129
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 130 - 134
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 135 - 139
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 140 - 144
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 145 - 149
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 150 - 154
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 155 - 159
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 160 - 164
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 165 - 169
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 170 - 174
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 175 - 179
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 180 - 184
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 185 - 189
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 190 - 194
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 195 - 199
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 200 - 204
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 205 - 209
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 210 - 214
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 215 - 219
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 220 - 224
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&IRQ_PIT0_CH2, (unsigned int)&dummy,	// ISRs 225 - 229
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 230 - 234
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&IRQ_PIT0_RTI,	// ISRs 235 - 239
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 240 - 244
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 245 - 249
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 250 - 254
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 255 - 259
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 260 - 264
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 265 - 269
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 270 - 274
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 275 - 279
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 280 - 284
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 285 - 289
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 290 - 294
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 295 - 299
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 300 - 304
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 305 - 309
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 310 - 314
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 315 - 319
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 320 - 324
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 325 - 329
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 330 - 334
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 335 - 339
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 340 - 344
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 345 - 349
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 350 - 354
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 355 - 359
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 360 - 364
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 365 - 369
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 370 - 374
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 375 - 379
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 380 - 384
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 385 - 389
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 390 - 394
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 395 - 399
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 400 - 404
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 405 - 409
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 410 - 414
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 415 - 419
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 420 - 424
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 425 - 429
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 430 - 434
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 435 - 439
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 440 - 444
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 445 - 449
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 450 - 454
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 455 - 459
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 460 - 464
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 465 - 469
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 470 - 474
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 475 - 479
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 480 - 484
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 485 - 489
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 490 - 494
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 495 - 499
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 500 - 504
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 505 - 509
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 510 - 514
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 515 - 519
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 520 - 524
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 525 - 529
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 530 - 534
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 535 - 539
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 540 - 544
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 545 - 549
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 550 - 554
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 555 - 559
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 560 - 564
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 565 - 569
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 570 - 574
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 575 - 579
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 580 - 584
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 585 - 589
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 590 - 594
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 595 - 599
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 600 - 604
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 605 - 609
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 610 - 614
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 615 - 619
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 620 - 624
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 625 - 629
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 630 - 634
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 635 - 639
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 640 - 644
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 645 - 649
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 650 - 654
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 655 - 659
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 660 - 664
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 665 - 669
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 670 - 674
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 675 - 679
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 680 - 684
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 685 - 689
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 690 - 694
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 695 - 699
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 700 - 704
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 705 - 709
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 710 - 714
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 715 - 719
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 720 - 724
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 725 - 729
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 730 - 734
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 735 - 739
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 740 - 744
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 745 - 749
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 750 - 754
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 755 - 759
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 760 - 764
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 765 - 769
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 770 - 774
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 775 - 779
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 780 - 784
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 785 - 789
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 790 - 794
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 795 - 799
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 800 - 804
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 805 - 809
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 810 - 814
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 815 - 819
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 820 - 824
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 825 - 829
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 830 - 834
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 835 - 839
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 845 - 849
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 850 - 854
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 855 - 859
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 860 - 864
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 865 - 869
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 870 - 874
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 875 - 879
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 880 - 884
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 885 - 889
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 890 - 894
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 895 - 899
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 900 - 904
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 905 - 909
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 910 - 914
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 915 - 919
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 920 - 924
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 925 - 929
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 930 - 934
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 935 - 939
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 940 - 944
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 945 - 949
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 950 - 954
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 955 - 959
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 960 - 964
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 965 - 969
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 970 - 974
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 975 - 979
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 980 - 984
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 985 - 989
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 990 - 994
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 995 - 999
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 1000 - 1004
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 1005 - 1009
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 1010 - 1014
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 1015 - 1019
(unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy, (unsigned int)&dummy,	// ISRs 1020 - 1024
};      

//Function: irq_cnfg ----------------------------------------------------------

void irq_cnfg(void){
    e200zX_Interrupt_Setup();	// Initialise Core IVPR and IVOR Registers
    intc_init();		// Initialize INTC for SW vector mode and configure priorities
    xirq_ena();			// Enable interrupts
}

//Function: InitINTC ----------------------------------------------------------

void intc_init(void){
    volatile int16_t temp=0x00;

    INTC_0.BCR.R = 0x00000000;	// Choose software (HVEN=0) or hardware (HVEN=1) vector mode
    temp = INTC_0.IACKR[2].R;	//read IACKR before enabling interrupts
    INTC_0.IACKR[2].R = (uint32_t) &IntcIsrVectorTable[0];	// Set INTC ISR vector table base addr.

    // Add Configurations as required:
    INTC_0.PSR[228].R = 0x2001; // set IRQ228 (PIT1 chan 2) to interrupt processor 2 and  have a priority of 1
    INTC_0.PSR[229].R = 0x2001; // set IRQ229 (PIT1 chan 2) to interrupt processor 2 and  have a priority of 1
    INTC_0.PSR[44].R = 0x2001; // set IRQ44 (STM_2_CIR0[CIF]) to interrupt processor 2 and  have a priority of 2
    INTC_0.PSR[543].R = 0x2001; // set IRQ543 (SARADC_B) to interrupt processor 2 and  have a priority of 1
}

//Function: enableIrq ---------------------------------------------------------

void xirq_ena(void){
    INTC_0.CPR[2].B.PRI = 0;	// Ensure INTC's current priority is 0
    asm("wrteei 1");       	// Enable external interrupts
}

//Function: dummy -------------------------------------------------------------

void dummy(void){
    while(1);
}  

//Function: IRQ_PIT0_CH2 ------------------------------------------------------

// PIT0 CH2
void IRQ_PIT0_CH2 (void){
    PIT_0.TIMER[2].TFLG.B.TIF = 0x1;				// Clear timer 0 channel 0 interrupt flag
    //while(1){SIUL2.GPDO[4].B.PDO = ~SIUL2.GPDO[4].B.PDO;}	// Toggle PA[4]
}

//Function: IRQ_PIT0_RTI ------------------------------------------------------

// PIT0 RTI
void IRQ_PIT0_RTI (void){
    PIT_0.RTI_TFLG.B.TIF = 0x1;					// clear timer 0 channel 0 interrupt flag
    //while(1){SIUL2.GPDO[4].B.PDO = ~SIUL2.GPDO[4].B.PDO;}	// Toggle PA[4]
}

//Function: STM_2_CH_0 --------------------------------------------------------

// STM_2 CHANNEL[0]
void STM_2_CH_0 (void){
    STM_2.CHANNEL[0].CIR.B.CIF = 0x1;	// Channel Interrupt Register (W1C). Clear System Timer Interrupt
    STM_2.CNT.R = 0x00000000;		// Reset Counter
    SARADC_B.MCR.B.NSTART = 0x1;	// Starts SCAN on SARADC_B
}


