/**************************************************************************
 * FILE NAME: MPC5777M.h                     COPYRIGHT (c) Freescale 2014 * 
 * REVISION:  1.8                                     All Rights Reserved *
 *                                                                        *
 * DESCRIPTION:                                                           *
 * This file contains all of the register and bit field definitions for   *
 * the MPC5777M.                                                          *
 *========================================================================*
 * UPDATE HISTORY                                                         *
 * REV      AUTHOR      DATE       	DESCRIPTION OF CHANGE                 *
 * ---   -----------  ---------    	---------------------                 *
 * 0.2      P.A.      21-Mar-12     Adding register array style           *
 *                                                                        *
 * 0.3      P.A.      05-Apr-12     Adding new modules sent by Curt       *
 *                                  Hillier                               *
 *                                                                        *
 * 0.4      P.A.      25-Jul-12     Adding latest modules.                *
 * 0.4A     C.H.      13-Aug-12     Corrected errors in memory map.       *
 *                                                                        ******
 * CGM was incorrectly generated at 0UL.  Corrected to 0xFFFB0700UL            *
 * FR_0 was incorrectly generated at 0xFC250000UL.  Corrected to 0xFFE50000UL  *
 * LFAST was incorrectly generated at 0x1UL.  Corrected to 0xFFFD8000UL        *
 * PRAMC was incorrectly generated at 0UL.  Correct to 0xFC020000UL.           *
 *                                                                             *
 * 0.4b to                                                                     *
 *  0.5b    C.H.      22-Oct-12     Interim builds for debugging.              *
 * 0.5c     C.H.      23-Oct-12     replace autogenerated SARADC               *
 *                                  block with McKinley.  Too many mis-        *
 *                                  matches present.                           *
 *                                  Collapse DSPI CTARs to array               *
 * 0.5d     C.H.      24-Oct-12     Incorporate feedback from PE.              *
 *                                    add #ifdef support for SARADC arrays     *
 *                                    add array support for MC_ME_RUN_MC       *
 * 0.6      C.H.      26-Oct-12     MC_CGM uses base address of 0xFFFB_0700    *
 *                                  and registers offsets starting at 0x0700.  *
 *                                  This results in incorrect absolute         *
 *                                  addresses starting at 0xFFFB_0E000.        *
 *                                  To fix this, commented out the reserved    *
 *                                  space "//  uint8_t MC_CGM_reserved0[1792];" *
 *                                  and keep module base address = 0xFFFB_0700. *
 *                                  This matches McKinley implementation.      *
 *                                                                             *
 * 0.7      M.D.      05-Mar-13     Updated to RDP from Jan 2013 as follows:   *
 *                                  Module INTC: Added register MPROT          *
 *                                  And updated structure of PSR register      * 
 *                                  Module MCAN: Updated registers NDAT1,      *
 *                                  NDAT2, RXFOS, RXF1S, TXFQS, TXEFS          *
 *                                  Also added some comments to Module MCAN    *
 *                                                                             *
 * 0.8      M.D.      13-Mar-13     Updated PRAMC & CRC from new XML drop      *
 *                                  Expanded AC0_DC[5] register                *
 *                                  Change to PRAMC was manually inserted as   *
 *                                  code generated from XML was not correct    *  
 *                                  MC_ME: Inserted hand coded PCTL11 & 15     *
 *                                  due to missing from XML                    *
 *                                                                        *   
 * 0.9      M.D.      25-Jul-13     Updated from new XML drop             *
 *                                                                        *
 * 1.0      M.D.      17-Oct-13     Updated from RDP rev3                 *
 *                                                                        *
 * 1.1      M.D.      31-Jan-14     Added GTM104 modules                  *
 *                                                                        *     
 * 1.2      M.D.      26-Feb-14     Compressed GTM_ATOM modules           *
 *                                                                        *     
 * 1.3      M.D.      27-Feb-14     Compressed GTM modules: MCSs, AFDs,   *
 *                                  F2As, FIFOs, SPEs, TIMs and TOM       *
 *                                                                        *     
 * 1.4      M.D.      27-Feb-14     Removed a module                      *
 *                                                                        *
 * 1.5      M.D.      13-Mar-14     Updated with new GTM RDP              *
 *                                                                        *
 * 1.6      M.D.      02-Apr-14     Updated with RDP Rev 3                *
 *                                                                        *
 * 1.7      M.D.      03-Apr-14     Corrected some GTM macros             *
 *                                                                        *
 * 1.8      M.D.      07-Apr-14     Corrected MC_CGM base address         *
 *                                                                        *
 *========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
/*>>>>>>> NOTE! this file is auto-generated please do not edit it! <<<<<<<*/

/**************************************************************************
 * Example register & bit field write:                                    *
 *                                                                        *
 *  <MODULE>.<REGISTER>.B.<BIT> = 1;                                      *
 *  <MODULE>.<REGISTER>.R       = 0x10000000;                             *
 *                                                                        *
 **************************************************************************/

#ifndef _MPC5777M_H_
#define _MPC5777M_H_
#include "typedefs.h"
#ifdef __cplusplus
extern "C" {
#endif
#ifdef __MWERKS__
#pragma push
#pragma ANSI_strict off
#endif
#ifdef __ghs__
#pragma ghs nowarning 618
#endif


/* ============================================================================
   =============================== Module: C55FMC =============================
   ============================================================================ */

struct C55FMC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t RVE:1;                 /* Read Voltage Error */
      vuint32_t RRE:1;                 /* Read Reference Error */
      vuint32_t AEE:1;                 /* Address Encode Error */
      vuint32_t EEE:1;                 /* ECC after ECC Error */
      vuint32_t  :12;
      vuint32_t EER:1;                 /* ECC Event Error */
      vuint32_t RWE:1;                 /* Read-While-Write Event Error */
      vuint32_t SBC:1;                 /* Single Bit Correction */
      vuint32_t  :1;
      vuint32_t PEAS:1;                /* Program Access Space */
      vuint32_t DONE:1;                /* State Machine Status */
      vuint32_t PEG:1;                 /* Program/Erase Good */
      vuint32_t PECIE:1;               /* Program/Erase Complete Interrupt Enable */
      vuint32_t FERS:1;                /* Factory Erase and Program */
      vuint32_t  :2;
      vuint32_t PGM:1;                 /* Program */
      vuint32_t PSUS:1;                /* Program Suspend */
      vuint32_t ERS:1;                 /* Erase */
      vuint32_t ESUS:1;                /* Erase Suspend */
      vuint32_t EHV:1;                 /* Enable High Voltage */
    } B;
  } MCR;

  union {                              /* Alternate Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PEASa:1;               /* Program Access Space */
      vuint32_t DONEa:1;               /* State Machine Status */
      vuint32_t PEGa:1;                /* Program/Erase Good */
      vuint32_t  :4;
      vuint32_t PGMa:1;                /* Program */
      vuint32_t PSUSa:1;               /* Program Suspend */
      vuint32_t ERSa:1;                /* Erase Suspend */
      vuint32_t ESUSa:1;               /* Erase Suspend */
      vuint32_t EHVa:1;                /* Enable High Voltage */
    } B;
  } MCRA;

  union {                              /* Extended Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t HT:1;                  /* High Temperature Enabled. */
      vuint32_t  :2;
      vuint32_t n256K:5;
      vuint32_t n64Kh:3;
      vuint32_t n32Kh:2;
      vuint32_t n16Kh:3;
      vuint32_t n64Km:3;
      vuint32_t n32Km:2;
      vuint32_t n16Km:3;
      vuint32_t n64Kl:3;
      vuint32_t n32Kl:2;
      vuint32_t n16Kl:3;
    } B;
  } MCRE;

  uint8_t C55FMC_reserved0[4];
  union {                              /* Lock 0 register */
    vuint32_t R;
    struct {
      vuint32_t TSLOCK:1;              /* UTest NVM Lock. */
      vuint32_t  :1;
      vuint32_t LOWLOCK:14;            /* Low Block Lock */
      vuint32_t MIDLOCK:16;            /* Mid Block Lock */
    } B;
  } LOCK0;

  union {                              /* Lock 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHLOCK:16;           /* High Block Lock */
    } B;
  } LOCK1;

  union {                              /* Lock 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KLOCK:32;          /* 256 KB Block Lock */
    } B;
  } LOCK2;

  union {                              /* Lock 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KLOCK:16;          /* 256 KB Block Lock */
    } B;
  } LOCK3;

  uint8_t C55FMC_reserved1[8];
  union {                              /* Alternate Lock 0 register */
    vuint32_t R;
    struct {
      vuint32_t TSLOCKa:1;             /* Alternate UTest NVM Lock. */
      vuint32_t  :1;
      vuint32_t LOWLOCKa:14;           /* Alternate Low Block Lock */
      vuint32_t MIDLOCKa:16;           /* Alternate Mid Block Lock */
    } B;
  } LOCK0A;

  union {                              /* Alternate Lock 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHLOCKa:16;          /* Alternate High Block Lock */
    } B;
  } LOCK1A;

  uint8_t C55FMC_reserved2[8];
  union {                              /* Select 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWSEL:14;             /* LOW Block Select. */
      vuint32_t MIDSEL:16;             /* Mid Block Select. */
    } B;
  } SEL0;

  union {                              /* Select 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHSEL:16;            /* High Block Select. */
    } B;
  } SEL1;

  union {                              /* Select 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KSEL:32;           /* 256 KB Block Select. */
    } B;
  } SEL2;

  union {                              /* Select 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KSEL:16;           /* 256 KB Block Select. */
    } B;
  } SEL3;

  uint8_t C55FMC_reserved3[8];
  union {                              /* Address register */
    vuint32_t R;
    struct {
      vuint32_t SAD:1;
      vuint32_t aH:1;
      vuint32_t aM:1;
      vuint32_t aL:1;
      vuint32_t a256k:1;
      vuint32_t a64k:1;
      vuint32_t a32k:1;
      vuint32_t a16k:1;
      vuint32_t ADDR:21;
      vuint32_t  :3;
    } B;
  } ADR;

  union {                              /* UTest 0 register */
    vuint32_t R;
    struct {
      vuint32_t UTE:1;
      vuint32_t SBCE:1;
      vuint32_t  :11;
      vuint32_t CPR:1;
      vuint32_t CPA:1;
      vuint32_t CPE:1;
      vuint32_t  :6;
      vuint32_t NAIBP:1;
      vuint32_t AIBPE:1;
      vuint32_t  :1;
      vuint32_t AISUS:1;
      vuint32_t MRE:1;
      vuint32_t MRV:1;
      vuint32_t  :1;
      vuint32_t AIS:1;
      vuint32_t AIE:1;
      vuint32_t AID:1;
    } B;
  } UT0;

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t MISR:32;
    } B;
  } UM[9];

  union {                              /* UMISR register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t MISR:1;                /* MISR[288]. */
    } B;
  } UM9;

  union {                              /* Over-Program Protection 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t LOWOPP:14;             /* Low Block Over-Program Protection[13:0]. */
      vuint32_t MIDOPP:16;             /* Mid Block Over-Program Protection[15:0]. */
    } B;
  } OPP0;

  union {                              /* Over-Program Protection 1 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HIGHOPP:16;            /* High Block Over-Program Protection[15:0]. */
    } B;
  } OPP1;

  union {                              /* Over-Program Protection 2 register */
    vuint32_t R;
    struct {
      vuint32_t A256KOPP:32;           /* 256K Block Over-Program Protection[31:0]. */
    } B;
  } OPP2;

  union {                              /* Over-Program Protection 3 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t A256KOPP:16;           /* 256K Block Over-Program Protection[47:32]. */
    } B;
  } OPP3;

  union {                              /* Test Mode Disable Password Check register */
    vuint32_t R;
    struct {
      vuint32_t PWD:32;                /* Password challenge */
    } B;
  } TMD;
};


/* ============================================================================
   =============================== Module: CMU ================================
   ============================================================================ */

struct CMU_tag {
  union {                              /* CMU Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SFM:1;                 /* Start frequency measure. */
      vuint32_t  :13;
      vuint32_t CKSEL1:2;              /* Frequency measure clock selection bit. */
      vuint32_t  :5;
      vuint32_t RCDIV:2;               /* CLKMT0_RMN division factor. */
      vuint32_t CME:1;                 /* CLKMN1 monitor enable. */
    } B;
  } CSR;

  union {                              /* CMU Frequency Display Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t FD:20;                 /* Measured frequency bits. */
    } B;
  } FDR;

  union {                              /* CMU High Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t HFREF:12;              /* High Frequency reference value. */
    } B;
  } HFREFR;

  union {                              /* CMU Low Frequency Reference Register CLKMN1 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t LFREF:12;              /* Low Frequency reference value. */
    } B;
  } LFREFR;

  union {                              /* CMU Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t FHHI:1;                /* CLKMN1 frequency higher than high reference event status. */
      vuint32_t FLLI:1;                /* CLKMN1 frequency less than low reference event status. */
      vuint32_t OLRI:1;                /* Oscillator frequency less than f CLKMT0_RMN * 2RCDIVevent status. */
    } B;
  } ISR;

  uint8_t CMU_reserved0[4];
  union {                              /* CMU Measurement Duration Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t MD:20;                 /* Measurement duration bits */
    } B;
  } MDR;
};


/* ============================================================================
   =============================== Module: CRC ================================
   ============================================================================ */

struct CRC_tag {
  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t  :18;
      vuint32_t SWAP_BYTEWISE:1;       /* Swap CRC_INP byte-wise */
      vuint32_t SWAP_BITWISE:1;        /* Swap CRC_INP bit-wise */
      vuint32_t POLYG:2;               /* Polynomial selection */
      vuint32_t SWAP:1;                /* Swap selection */
      vuint32_t INV:1;                 /* Inversion selection */
    } B;
  } CFG;

  union {                              /* Input Register */
    vuint32_t R;
    struct {
      vuint32_t INP:32;                /* Input data for the CRC computation */
    } B;
  } INP;

  union {                              /* Current Status Register */
    vuint32_t R;
    struct {
      vuint32_t CSTAT:32;              /* CRC signature status */
    } B;
  } CSTAT;

  union {                              /* Output Register */
    vuint32_t R;
    struct {
      vuint32_t OUTP:32;               /* Final CRC signature */
    } B;
  } OUTP;
};


/* ============================================================================
   =============================== Module: DMAMUX =============================
   ============================================================================ */

struct DMAMUX_tag {
  union {                              /* Channel Configuration register */
    vuint8_t R;
    struct {
      vuint8_t ENBL:1;                 /* DMA Channel Enable */
      vuint8_t TRIG:1;                 /* DMA Channel Trigger Enable */
      vuint8_t SOURCE:6;               /* DMA Channel Source (Slot) */
    } B;
  } CHCFG[16];
};


/* ============================================================================
   =============================== Module: DSPI ===============================
   ============================================================================ */

struct DSPI_tag {
  union {                              /* DSPI Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSTR:1;
      vuint32_t CONT_SCKE:1;
      vuint32_t DCONF:2;
      vuint32_t FRZ:1;
      vuint32_t MTFE:1;
      vuint32_t PCSSE:1;
      vuint32_t ROOE:1;
      vuint32_t PCSIS:8;
      vuint32_t  :1;
      vuint32_t MDIS:1;
      vuint32_t DIS_TXF:1;
      vuint32_t DIS_RXF:1;
      vuint32_t CLR_TXF:1;
      vuint32_t CLR_RXF:1;
      vuint32_t SMPL_PT:2;
      vuint32_t  :4;
      vuint32_t XSPI:1;
      vuint32_t FCPCS:1;
      vuint32_t PES:1;
      vuint32_t HALT:1;
    } B;
  } MCR;

  uint8_t DSPI_reserved0[4];
  union {                              /* DSPI Transfer Count Register */
    vuint32_t R;
    struct {
      vuint32_t SPI_TCNT:16;
      vuint32_t  :16;
    } B;
  } TCR;

  union {
    union {                            /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
      vuint32_t R;
      struct {
        vuint32_t DBR:1;
        vuint32_t FMSZ:4;
        vuint32_t CPOL:1;
        vuint32_t CPHA:1;
        vuint32_t LSBFE:1;
        vuint32_t PCSSCK:2;
        vuint32_t PASC:2;
        vuint32_t PDT:2;
        vuint32_t PBR:2;
        vuint32_t CSSCK:4;
        vuint32_t ASC:4;
        vuint32_t DT:4;
        vuint32_t BR:4;
      } B;
    } CTAR[8];
    union {                            /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
      vuint32_t R;
      struct {
        vuint32_t FMSZ:5;
        vuint32_t CPOL:1;
        vuint32_t CPHA:1;
        vuint32_t PE:1;
        vuint32_t PP:1;
        vuint32_t FMSZ5:1;
        vuint32_t  :22;
      } B;
    } CTAR_SLAVE[2];
  } MODE;

  union {                              /* DSPI Status Register */
    vuint32_t R;
    struct {
      vuint32_t TCF:1;
      vuint32_t TXRXS:1;
      vuint32_t SPITCF:1;
      vuint32_t EOQF:1;
      vuint32_t TFUF:1;
      vuint32_t DSITCF:1;
      vuint32_t TFFF:1;
      vuint32_t BSYF:1;
      vuint32_t CMDTCF:1;
      vuint32_t DPEF:1;
      vuint32_t SPEF:1;
      vuint32_t DDIF:1;
      vuint32_t RFOF:1;
      vuint32_t TFIWF:1;
      vuint32_t RFDF:1;
      vuint32_t CMDFFF:1;
      vuint32_t TXCTR:4;
      vuint32_t TXNXTPTR:4;
      vuint32_t RXCTR:4;
      vuint32_t POPNXTPTR:4;
    } B;
  } SR;

  union {                              /* DSPI DMA/Interrupt Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t TCF_RE:1;
      vuint32_t CMDFFF_RE:1;
      vuint32_t SPITCF_RE:1;
      vuint32_t EOQF_RE:1;
      vuint32_t TFUF_RE:1;
      vuint32_t DSITCF_RE:1;
      vuint32_t TFFF_RE:1;
      vuint32_t TFFF_DIRS:1;
      vuint32_t CMDTCF_RE:1;
      vuint32_t DPEF_RE:1;
      vuint32_t SPEF_RE:1;
      vuint32_t DDIF_RE:1;
      vuint32_t RFOF_RE:1;
      vuint32_t TFIWF_RE:1;
      vuint32_t RFDF_RE:1;
      vuint32_t RFDF_DIRS:1;
      vuint32_t CMDFFF_DIRS:1;
      vuint32_t DDIF_DIRS:1;
      vuint32_t  :14;
    } B;
  } RSER;

  union {
    union {                            /* DSPI PUSH FIFO Register In Master Mode */
      vuint32_t R;
      struct {
        vuint32_t CONT:1;
        vuint32_t CTAS:3;
        vuint32_t EOQ:1;
        vuint32_t CTCNT:1;
        vuint32_t PE_MASC:1;
        vuint32_t PP_MCSC:1;
        vuint32_t PCS:8;
        vuint32_t TXDATA:16;
      } B;
    } PUSHR;
    union {                            /* DSPI PUSH FIFO Register In Slave Mode */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t TXDATA:16;
      } B;
    } PUSHR_SLAVE;
  } PUSHR;

  union {                              /* DSPI POP FIFO Register */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;
    } B;
  } POPR;

  union {                              /* DSPI Transmit FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t TXCMD_TXDATA:16;
      vuint32_t TXDATA:16;
    } B;
  } TXFR[4];

  uint8_t DSPI_reserved1[48];
  union {                              /* DSPI Receive FIFO Registers */
    vuint32_t R;
    struct {
      vuint32_t RXDATA:32;
    } B;
  } RXFR[4];

  uint8_t DSPI_reserved2[48];
  union {                              /* DSPI DSI Configuration Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FMSZ4:1;
      vuint32_t  :6;
      vuint32_t FMSZ5:1;
      vuint32_t  :1;
      vuint32_t ITSB:1;
      vuint32_t TSBC:1;
      vuint32_t TXSS:1;
      vuint32_t TPOL:1;
      vuint32_t  :1;
      vuint32_t CID:1;
      vuint32_t DCONT:1;
      vuint32_t DSICTAS:3;
      vuint32_t DMS:1;
      vuint32_t PES:1;
      vuint32_t PE:1;
      vuint32_t PP:1;
      vuint32_t DPCSx:8;
    } B;
  } DSICR0;

  union {                              /* DSPI DSI Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;
    } B;
  } SDR0;

  union {                              /* DSPI DSI Alternate Serialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;
    } B;
  } ASDR0;

  union {                              /* DSPI DSI Transmit Comparison Register 0 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;
    } B;
  } COMPR0;

  union {                              /* DSPI DSI Deserialization Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DESER_DATA:32;
    } B;
  } DDR0;

  union {                              /* DSPI DSI Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t TSBCNT:6;
      vuint32_t  :5;
      vuint32_t DSI64E:1;
      vuint32_t DSE1:1;
      vuint32_t DSE0:1;
      vuint32_t TRGPRD:8;
      vuint32_t DPCS1_x:8;
    } B;
  } DSICR1;

  union {                              /* DSPI DSI Serialization Source Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;
    } B;
  } SSR0;

  union {                              /* DSPI DSI Parallel Input Select Register 0 */
    vuint32_t R;
    struct {
      vuint32_t IPS7:4;
      vuint32_t IPS6:4;
      vuint32_t IPS5:4;
      vuint32_t IPS4:4;
      vuint32_t IPS3:4;
      vuint32_t IPS2:4;
      vuint32_t IPS1:4;
      vuint32_t IPS0:4;
    } B;
  } PISR0;

  union {                              /* DSPI DSI Parallel Input Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t IPS15:4;
      vuint32_t IPS14:4;
      vuint32_t IPS13:4;
      vuint32_t IPS12:4;
      vuint32_t IPS11:4;
      vuint32_t IPS10:4;
      vuint32_t IPS9:4;
      vuint32_t IPS8:4;
    } B;
  } PISR1;

  union {                              /* DSPI DSI Parallel Input Select Register 2 */
    vuint32_t R;
    struct {
      vuint32_t IPS23:4;
      vuint32_t IPS22:4;
      vuint32_t IPS21:4;
      vuint32_t IPS20:4;
      vuint32_t IPS19:4;
      vuint32_t IPS18:4;
      vuint32_t IPS17:4;
      vuint32_t IPS16:4;
    } B;
  } PISR2;

  union {                              /* DSPI DSI Parallel Input Select Register 3 */
    vuint32_t R;
    struct {
      vuint32_t IPS31:4;
      vuint32_t IPS30:4;
      vuint32_t IPS29:4;
      vuint32_t IPS28:4;
      vuint32_t IPS27:4;
      vuint32_t IPS26:4;
      vuint32_t IPS25:4;
      vuint32_t IPS24:4;
    } B;
  } PISR3;

  union {                              /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MASK:32;
    } B;
  } DIMR0;

  union {                              /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
    vuint32_t R;
    struct {
      vuint32_t DP:32;
    } B;
  } DPIR0;

  union {                              /* DSPI DSI Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SER_DATA:32;
    } B;
  } SDR1;

  union {                              /* DSPI DSI Alternate Serialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t ASER_DATA:32;
    } B;
  } ASDR1;

  union {                              /* DSPI DSI Transmit Comparison Register 1 */
    vuint32_t R;
    struct {
      vuint32_t COMP_DATA:32;
    } B;
  } COMPR1;

  union {                              /* DSPI DSI Deserialization Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DESER_DATA:32;
    } B;
  } DDR1;

  union {                              /* DSPI DSI Serialization Source Select Register 1 */
    vuint32_t R;
    struct {
      vuint32_t SS:32;
    } B;
  } SSR1;

  union {                              /* DSPI DSI Parallel Input Select Register 4 */
    vuint32_t R;
    struct {
      vuint32_t IPS39:4;
      vuint32_t IPS38:4;
      vuint32_t IPS37:4;
      vuint32_t IPS36:4;
      vuint32_t IPS35:4;
      vuint32_t IPS34:4;
      vuint32_t IPS33:4;
      vuint32_t IPS32:4;
    } B;
  } PISR4;

  union {                              /* DSPI DSI Parallel Input Select Register 5 */
    vuint32_t R;
    struct {
      vuint32_t IPS47:4;
      vuint32_t IPS46:4;
      vuint32_t IPS45:4;
      vuint32_t IPS44:4;
      vuint32_t IPS43:4;
      vuint32_t IPS42:4;
      vuint32_t IPS41:4;
      vuint32_t IPS40:4;
    } B;
  } PISR5;

  union {                              /* DSPI DSI Parallel Input Select Register 6 */
    vuint32_t R;
    struct {
      vuint32_t IPS55:4;
      vuint32_t IPS54:4;
      vuint32_t IPS53:4;
      vuint32_t IPS52:4;
      vuint32_t IPS51:4;
      vuint32_t IPS50:4;
      vuint32_t IPS49:4;
      vuint32_t IPS48:4;
    } B;
  } PISR6;

  union {                              /* DSPI DSI Parallel Input Select Register 7 */
    vuint32_t R;
    struct {
      vuint32_t IPS63:4;
      vuint32_t IPS62:4;
      vuint32_t IPS61:4;
      vuint32_t IPS60:4;
      vuint32_t IPS59:4;
      vuint32_t IPS58:4;
      vuint32_t IPS57:4;
      vuint32_t IPS56:4;
    } B;
  } PISR7;

  union {                              /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MASK:32;
    } B;
  } DIMR1;

  union {                              /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
    vuint32_t R;
    struct {
      vuint32_t DP:32;
    } B;
  } DPIR1;

  union {                              /* DSPI Clock and Transfer Attributes Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t FMSZE:1;
      vuint32_t  :5;
      vuint32_t DTCP:11;
    } B;
  } CTARE[8];

  union {                              /* DSPI Status Register Extended */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CMDCTR:4;
      vuint32_t CMDNXTPTR:4;
    } B;
  } SREX;
};


/* ============================================================================
   =============================== Module: DTS ================================
   ============================================================================ */

struct DTS_tag {
  union {                              /* Output Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t DTS_EN_B:1;
      vuint32_t DTS_EN:1;
    } B;
  } ENABLE;

  union {                              /* Startup Register */
    vuint32_t R;
    struct {
      vuint32_t AD:32;
    } B;
  } STARTUP;

  union {                              /* Semaphore Register */
    vuint32_t R;
    struct {
      vuint32_t ST:32;
    } B;
  } SEMAPHORE;

  union {                              /* Semaphore Extension */
    vuint32_t R;
    struct {
      vuint32_t ST_B:32;
    } B;
  } SEMAPHORE_B;
};


/* ============================================================================
   =============================== Module: EBI ================================
   ============================================================================ */

struct EBI_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ACGE:1;
      vuint32_t  :8;
      vuint32_t MDIS:1;
      vuint32_t  :3;
      vuint32_t D16_31:1;
      vuint32_t  :1;
      vuint32_t DBM:1;
    } B;
  } MCR;

  uint8_t EBI_reserved0[12];
  union {                              /* Base Register Bank */
    vuint32_t R;
    struct {
      vuint32_t BA:17;
      vuint32_t  :2;
      vuint32_t LWRN:1;
      vuint32_t PS:1;
      vuint32_t EOE:2;
      vuint32_t SBL:1;
      vuint32_t AD_MUX:1;
      vuint32_t BL:1;
      vuint32_t WEBS:1;
      vuint32_t TBDIP:1;
      vuint32_t GCSN:1;
      vuint32_t  :1;
      vuint32_t BI:1;
      vuint32_t V:1;
    } B;
  } BR0;

  union {                              /* Option Register Bank */
    vuint32_t R;
    struct {
      vuint32_t AM:17;
      vuint32_t  :2;
      vuint32_t APS:1;                 /* Address by Port Size */
      vuint32_t  :1;
      vuint32_t AWE:1;                 /* Address / Write Enable Select */
      vuint32_t  :2;
      vuint32_t SCY:4;
      vuint32_t  :1;
      vuint32_t BSCY:2;
      vuint32_t  :1;
    } B;
  } OR0;

  union {                              /* Base Register Bank */
    vuint32_t R;
    struct {
      vuint32_t BA:17;
      vuint32_t  :2;
      vuint32_t LWRN:1;
      vuint32_t PS:1;
      vuint32_t EOE:2;
      vuint32_t SBL:1;
      vuint32_t AD_MUX:1;
      vuint32_t BL:1;
      vuint32_t WEBS:1;
      vuint32_t TBDIP:1;
      vuint32_t GCSN:1;
      vuint32_t  :1;
      vuint32_t BI:1;
      vuint32_t V:1;
    } B;
  } BR1;

  union {                              /* Option Register Bank */
    vuint32_t R;
    struct {
      vuint32_t AM:17;
      vuint32_t  :2;
      vuint32_t APS:1;                 /* Address by Port Size */
      vuint32_t  :1;
      vuint32_t AWE:1;                 /* Address / Write Enable Select */
      vuint32_t  :2;
      vuint32_t SCY:4;
      vuint32_t  :1;
      vuint32_t BSCY:2;
      vuint32_t  :1;
    } B;
  } OR1;

  union {                              /* Base Register Bank */
    vuint32_t R;
    struct {
      vuint32_t BA:17;
      vuint32_t  :2;
      vuint32_t LWRN:1;
      vuint32_t PS:1;
      vuint32_t EOE:2;
      vuint32_t SBL:1;
      vuint32_t AD_MUX:1;
      vuint32_t BL:1;
      vuint32_t WEBS:1;
      vuint32_t TBDIP:1;
      vuint32_t GCSN:1;
      vuint32_t  :1;
      vuint32_t BI:1;
      vuint32_t V:1;
    } B;
  } BR2;

  union {                              /* Option Register Bank */
    vuint32_t R;
    struct {
      vuint32_t AM:17;
      vuint32_t  :2;
      vuint32_t APS:1;                 /* Address by Port Size */
      vuint32_t  :1;
      vuint32_t AWE:1;                 /* Address / Write Enable Select */
      vuint32_t  :2;
      vuint32_t SCY:4;
      vuint32_t  :1;
      vuint32_t BSCY:2;
      vuint32_t  :1;
    } B;
  } OR2;

  union {                              /* Base Register Bank */
    vuint32_t R;
    struct {
      vuint32_t BA:17;
      vuint32_t  :2;
      vuint32_t LWRN:1;
      vuint32_t PS:1;
      vuint32_t EOE:2;
      vuint32_t SBL:1;
      vuint32_t AD_MUX:1;
      vuint32_t BL:1;
      vuint32_t WEBS:1;
      vuint32_t TBDIP:1;
      vuint32_t GCSN:1;
      vuint32_t  :1;
      vuint32_t BI:1;
      vuint32_t V:1;
    } B;
  } BR3;

  union {                              /* Option Register Bank */
    vuint32_t R;
    struct {
      vuint32_t AM:17;
      vuint32_t  :2;
      vuint32_t APS:1;                 /* Address by Port Size */
      vuint32_t  :1;
      vuint32_t AWE:1;                 /* Address / Write Enable Select */
      vuint32_t  :2;
      vuint32_t SCY:4;
      vuint32_t  :1;
      vuint32_t BSCY:2;
      vuint32_t  :1;
    } B;
  } OR3;
};


/* ============================================================================
   =============================== Module: FCCU ===============================
   ============================================================================ */

struct FCCU_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t FILTER_BYPASS:1;
      vuint32_t FILTER_WIDTH:2;
      vuint32_t  :19;
      vuint32_t DEBUG:1;
      vuint32_t  :1;
      vuint32_t OPS:2;
      vuint32_t  :1;
      vuint32_t OPR:5;
    } B;
  } CTRL;

  union {                              /* CTRL Key Register */
    vuint32_t R;
    struct {
      vuint32_t CTRLK:32;
    } B;
  } CTRLK;

  union {                              /* Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t FCCU_SET_AFTER_RESET:1;
      vuint32_t FCCU_SET_CLEAR:2;
      vuint32_t  :2;
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t OD:1;
      vuint32_t  :1;
      vuint32_t SM:1;
      vuint32_t PS:1;
      vuint32_t FOM:3;
      vuint32_t  :6;
    } B;
  } CFG;

  uint8_t FCCU_reserved0[16];
  union {                              /* RF Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t RFC31:1;
      vuint32_t RFC30:1;
      vuint32_t RFC29:1;
      vuint32_t RFC28:1;
      vuint32_t RFC27:1;
      vuint32_t RFC26:1;
      vuint32_t RFC25:1;
      vuint32_t RFC24:1;
      vuint32_t RFC23:1;
      vuint32_t RFC22:1;
      vuint32_t RFC21:1;
      vuint32_t RFC20:1;
      vuint32_t RFC19:1;
      vuint32_t RFC18:1;
      vuint32_t RFC17:1;
      vuint32_t RFC16:1;
      vuint32_t RFC15:1;
      vuint32_t RFC14:1;
      vuint32_t RFC13:1;
      vuint32_t RFC12:1;
      vuint32_t RFC11:1;
      vuint32_t RFC10:1;
      vuint32_t RFC9:1;
      vuint32_t RFC8:1;
      vuint32_t RFC7:1;
      vuint32_t RFC6:1;
      vuint32_t RFC5:1;
      vuint32_t RFC4:1;
      vuint32_t RFC3:1;
      vuint32_t RFC2:1;
      vuint32_t RFC1:1;
      vuint32_t RFC0:1;
    } B;
  } RF_CFG[4];

  uint8_t FCCU_reserved1[32];
  union {                              /* RFS Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t RFSC31:1;
      vuint32_t RFSC30:1;
      vuint32_t RFSC29:1;
      vuint32_t RFSC28:1;
      vuint32_t RFSC27:1;
      vuint32_t RFSC26:1;
      vuint32_t RFSC25:1;
      vuint32_t RFSC24:1;
      vuint32_t RFSC23:1;
      vuint32_t RFSC22:1;
      vuint32_t RFSC21:1;
      vuint32_t RFSC20:1;
      vuint32_t RFSC19:1;
      vuint32_t RFSC18:1;
      vuint32_t RFSC17:1;
      vuint32_t RFSC16:1;
      vuint32_t RFSC15:1;
      vuint32_t RFSC14:1;
      vuint32_t RFSC13:1;
      vuint32_t RFSC12:1;
      vuint32_t RFSC11:1;
      vuint32_t RFSC10:1;
      vuint32_t RFSC9:1;
      vuint32_t RFSC8:1;
      vuint32_t RFSC7:1;
      vuint32_t RFSC6:1;
      vuint32_t RFSC5:1;
      vuint32_t RFSC4:1;
      vuint32_t RFSC3:1;
      vuint32_t RFSC2:1;
      vuint32_t RFSC1:1;
      vuint32_t RFSC0:1;
    } B;
  } RFS_CFG[8];

  uint8_t FCCU_reserved2[20];
  union {                              /* UF Status Register */
    vuint32_t R;
    struct {
      vuint32_t RFS31:1;
      vuint32_t RFS30:1;
      vuint32_t RFS29:1;
      vuint32_t RFS28:1;
      vuint32_t RFS27:1;
      vuint32_t RFS26:1;
      vuint32_t RFS25:1;
      vuint32_t RFS24:1;
      vuint32_t RFS23:1;
      vuint32_t RFS22:1;
      vuint32_t RFS21:1;
      vuint32_t RFS20:1;
      vuint32_t RFS19:1;
      vuint32_t RFS18:1;
      vuint32_t RFS17:1;
      vuint32_t RFS16:1;
      vuint32_t RFS15:1;
      vuint32_t RFS14:1;
      vuint32_t RFS13:1;
      vuint32_t RFS12:1;
      vuint32_t RFS11:1;
      vuint32_t RFS10:1;
      vuint32_t RFS9:1;
      vuint32_t RFS8:1;
      vuint32_t RFS7:1;
      vuint32_t RFS6:1;
      vuint32_t RFS5:1;
      vuint32_t RFS4:1;
      vuint32_t RFS3:1;
      vuint32_t RFS2:1;
      vuint32_t RFS1:1;
      vuint32_t RFS0:1;
    } B;
  } RF_S[4];

  union {                              /* RF Key Register */
    vuint32_t R;
    struct {
      vuint32_t RFK:32;
    } B;
  } RFK;

  union {                              /* RF Enable Register */
    vuint32_t R;
    struct {
      vuint32_t RFE31:1;
      vuint32_t RFE30:1;
      vuint32_t RFE29:1;
      vuint32_t RFE28:1;
      vuint32_t RFE27:1;
      vuint32_t RFE26:1;
      vuint32_t RFE25:1;
      vuint32_t RFE24:1;
      vuint32_t RFE23:1;
      vuint32_t RFE22:1;
      vuint32_t RFE21:1;
      vuint32_t RFE20:1;
      vuint32_t RFE19:1;
      vuint32_t RFE18:1;
      vuint32_t RFE17:1;
      vuint32_t RFE16:1;
      vuint32_t RFE15:1;
      vuint32_t RFE14:1;
      vuint32_t RFE13:1;
      vuint32_t RFE12:1;
      vuint32_t RFE11:1;
      vuint32_t RFE10:1;
      vuint32_t RFE9:1;
      vuint32_t RFE8:1;
      vuint32_t RFE7:1;
      vuint32_t RFE6:1;
      vuint32_t RFE5:1;
      vuint32_t RFE4:1;
      vuint32_t RFE3:1;
      vuint32_t RFE2:1;
      vuint32_t RFE1:1;
      vuint32_t RFE0:1;
    } B;
  } RF_E[4];

  union {                              /* RF Time-out Enable Register */
    vuint32_t R;
    struct {
      vuint32_t RFTOE31:1;
      vuint32_t RFTOE30:1;
      vuint32_t RFTOE29:1;
      vuint32_t RFTOE28:1;
      vuint32_t RFTOE27:1;
      vuint32_t RFTOE26:1;
      vuint32_t RFTOE25:1;
      vuint32_t RFTOE24:1;
      vuint32_t RFTOE23:1;
      vuint32_t RFTOE22:1;
      vuint32_t RFTOE21:1;
      vuint32_t RFTOE20:1;
      vuint32_t RFTOE19:1;
      vuint32_t RFTOE18:1;
      vuint32_t RFTOE17:1;
      vuint32_t RFTOE16:1;
      vuint32_t RFTOE15:1;
      vuint32_t RFTOE14:1;
      vuint32_t RFTOE13:1;
      vuint32_t RFTOE12:1;
      vuint32_t RFTOE11:1;
      vuint32_t RFTOE10:1;
      vuint32_t RFTOE9:1;
      vuint32_t RFTOE8:1;
      vuint32_t RFTOE7:1;
      vuint32_t RFTOE6:1;
      vuint32_t RFTOE5:1;
      vuint32_t RFTOE4:1;
      vuint32_t RFTOE3:1;
      vuint32_t RFTOE2:1;
      vuint32_t RFTOE1:1;
      vuint32_t RFTOE0:1;
    } B;
  } RF_TOE[4];

  union {                              /* RF Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t TO:32;
    } B;
  } RF_TO;

  union {                              /* CFG Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TO:3;
    } B;
  } CFG_TO;

  union {                              /* IO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t EIN1:1;
      vuint32_t EIN0:1;
      vuint32_t  :2;
      vuint32_t EOUT1:1;
      vuint32_t EOUT0:1;
    } B;
  } EINOUT;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t PhysicErrorPin:2;
      vuint32_t ESTAT:1;
      vuint32_t STATUS:3;
    } B;
  } STAT;

  union {                              /* NA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t NAFS:8;
    } B;
  } N2AF_STATUS;

  union {                              /* AF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t AF_SRC:2;
      vuint32_t AFFS:8;
    } B;
  } A2FF_STATUS;

  union {                              /* NF Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t NF_SRC:2;
      vuint32_t NFFS:8;
    } B;
  } N2FF_STATUS;

  union {                              /* FA Freeze Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t FAFS:9;
    } B;
  } F2A_STATUS;

  uint8_t FCCU_reserved3[8];
  union {                              /* RF Fake Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t FRFC:7;
    } B;
  } RFF;

  union {                              /* IRQ Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t NMI_STAT:1;
      vuint32_t ALRM_STAT:1;
      vuint32_t CFG_TO_STAT:1;
    } B;
  } IRQ_STAT;

  union {                              /* IRQ Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t CFG_TO_IEN:1;
    } B;
  } IRQ_EN;

  union {                              /* XTMR Register */
    vuint32_t R;
    struct {
      vuint32_t XTMR:32;
    } B;
  } XTMR;

  union {                              /* MCS Register */
    vuint32_t R;
    struct {
      vuint32_t VL3:1;
      vuint32_t FS3:1;
      vuint32_t  :2;
      vuint32_t MCS3:4;
      vuint32_t VL2:1;
      vuint32_t FS2:1;
      vuint32_t  :2;
      vuint32_t MCS2:4;
      vuint32_t VL1:1;
      vuint32_t FS1:1;
      vuint32_t  :2;
      vuint32_t MCS1:4;
      vuint32_t VL0:1;
      vuint32_t FS0:1;
      vuint32_t  :2;
      vuint32_t MCS0:4;
    } B;
  } MCS;

  union {                              /* Transient Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t TRANSKEY:9;
    } B;
  } TRANS_LOCK;

  union {                              /* Permanent Lock Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t PERMNTKEY:9;
    } B;
  } PERMNT_LOCK;

  union {                              /* Delta T Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t  :14;
      vuint32_t  :2;
      vuint32_t DELTA_T:14;
    } B;
  } DELTA_T;

  union {                              /* IRQ Alarm Enable Register */
    vuint32_t R;
    struct {
      vuint32_t IRQEN31:1;
      vuint32_t IRQEN30:1;
      vuint32_t IRQEN29:1;
      vuint32_t IRQEN28:1;
      vuint32_t IRQEN27:1;
      vuint32_t IRQEN26:1;
      vuint32_t IRQEN25:1;
      vuint32_t IRQEN24:1;
      vuint32_t IRQEN23:1;
      vuint32_t IRQEN22:1;
      vuint32_t IRQEN21:1;
      vuint32_t IRQEN20:1;
      vuint32_t IRQEN19:1;
      vuint32_t IRQEN18:1;
      vuint32_t IRQEN17:1;
      vuint32_t IRQEN16:1;
      vuint32_t IRQEN15:1;
      vuint32_t IRQEN14:1;
      vuint32_t IRQEN13:1;
      vuint32_t IRQEN12:1;
      vuint32_t IRQEN11:1;
      vuint32_t IRQEN10:1;
      vuint32_t IRQEN9:1;
      vuint32_t IRQEN8:1;
      vuint32_t IRQEN7:1;
      vuint32_t IRQEN6:1;
      vuint32_t IRQEN5:1;
      vuint32_t IRQEN4:1;
      vuint32_t IRQEN3:1;
      vuint32_t IRQEN2:1;
      vuint32_t IRQEN1:1;
      vuint32_t IRQEN0:1;
    } B;
  } IRQ_ALARM_EN[4];

  union {                              /* NMI Enable Register */
    vuint32_t R;
    struct {
      vuint32_t NMIEN31:1;
      vuint32_t NMIEN30:1;
      vuint32_t NMIEN29:1;
      vuint32_t NMIEN28:1;
      vuint32_t NMIEN27:1;
      vuint32_t NMIEN26:1;
      vuint32_t NMIEN25:1;
      vuint32_t NMIEN24:1;
      vuint32_t NMIEN23:1;
      vuint32_t NMIEN22:1;
      vuint32_t NMIEN21:1;
      vuint32_t NMIEN20:1;
      vuint32_t NMIEN19:1;
      vuint32_t NMIEN18:1;
      vuint32_t NMIEN17:1;
      vuint32_t NMIEN16:1;
      vuint32_t NMIEN15:1;
      vuint32_t NMIEN14:1;
      vuint32_t NMIEN13:1;
      vuint32_t NMIEN12:1;
      vuint32_t NMIEN11:1;
      vuint32_t NMIEN10:1;
      vuint32_t NMIEN9:1;
      vuint32_t NMIEN8:1;
      vuint32_t NMIEN7:1;
      vuint32_t NMIEN6:1;
      vuint32_t NMIEN5:1;
      vuint32_t NMIEN4:1;
      vuint32_t NMIEN3:1;
      vuint32_t NMIEN2:1;
      vuint32_t NMIEN1:1;
      vuint32_t NMIEN0:1;
    } B;
  } NMI_EN[4];

  union {                              /* EOUT Signaling Enable Register */
    vuint32_t R;
    struct {
      vuint32_t EOUTEN31:1;
      vuint32_t EOUTEN30:1;
      vuint32_t EOUTEN29:1;
      vuint32_t EOUTEN28:1;
      vuint32_t EOUTEN27:1;
      vuint32_t EOUTEN26:1;
      vuint32_t EOUTEN25:1;
      vuint32_t EOUTEN24:1;
      vuint32_t EOUTEN23:1;
      vuint32_t EOUTEN22:1;
      vuint32_t EOUTEN21:1;
      vuint32_t EOUTEN20:1;
      vuint32_t EOUTEN19:1;
      vuint32_t EOUTEN18:1;
      vuint32_t EOUTEN17:1;
      vuint32_t EOUTEN16:1;
      vuint32_t EOUTEN15:1;
      vuint32_t EOUTEN14:1;
      vuint32_t EOUTEN13:1;
      vuint32_t EOUTEN12:1;
      vuint32_t EOUTEN11:1;
      vuint32_t EOUTEN10:1;
      vuint32_t EOUTEN9:1;
      vuint32_t EOUTEN8:1;
      vuint32_t EOUTEN7:1;
      vuint32_t EOUTEN6:1;
      vuint32_t EOUTEN5:1;
      vuint32_t EOUTEN4:1;
      vuint32_t EOUTEN3:1;
      vuint32_t EOUTEN2:1;
      vuint32_t EOUTEN1:1;
      vuint32_t EOUTEN0:1;
    } B;
  } EOUT_SIG_EN[4];
};


/* ============================================================================
   =============================== Module: FEC ================================
   ============================================================================ */

struct FEC_tag {
  uint8_t FEC_reserved0[4];
  union {                              /* Interrupt Event Register */
    vuint32_t R;
    struct {
      vuint32_t HBERR:1;
      vuint32_t BABR:1;
      vuint32_t BABT:1;
      vuint32_t GRA:1;
      vuint32_t TXF:1;
      vuint32_t TXB:1;
      vuint32_t RXF:1;
      vuint32_t RXB:1;
      vuint32_t MII:1;
      vuint32_t EBERR:1;
      vuint32_t LC:1;
      vuint32_t RL:1;
      vuint32_t UN:1;
      vuint32_t  :19;
    } B;
  } EIR;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t HBERR:1;
      vuint32_t BABR:1;
      vuint32_t BABT:1;
      vuint32_t GRA:1;
      vuint32_t TXF:1;
      vuint32_t TXB:1;
      vuint32_t RXF:1;
      vuint32_t RXB:1;
      vuint32_t MII:1;
      vuint32_t EBERR:1;
      vuint32_t LC:1;
      vuint32_t RL:1;
      vuint32_t UN:1;
      vuint32_t  :19;
    } B;
  } EIMR;

  uint8_t FEC_reserved1[4];
  union {                              /* Receive Descriptor Active Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDAR:1;
      vuint32_t  :24;
    } B;
  } RDAR;

  union {                              /* Transmit Descriptor Active Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t TDAR:1;
      vuint32_t  :24;
    } B;
  } TDAR;

  uint8_t FEC_reserved2[12];
  union {                              /* Ethernet Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :23;
      vuint32_t  :1;
      vuint32_t ETHER_EN:1;
      vuint32_t RESET:1;
    } B;
  } ECR;

  uint8_t FEC_reserved3[24];
  union {                              /* MII Management Frame Register */
    vuint32_t R;
    struct {
      vuint32_t ST:2;
      vuint32_t OP:2;
      vuint32_t PA:5;
      vuint32_t RA:5;
      vuint32_t TA:2;
      vuint32_t DATA:16;
    } B;
  } MMFR;

  union {                              /* MII Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t DIS_PRE:1;
      vuint32_t MII_SPEED:6;
      vuint32_t  :1;
    } B;
  } MSCR;

  uint8_t FEC_reserved4[28];
  union {                              /* MIB Control Register */
    vuint32_t R;
    struct {
      vuint32_t MIB_DIS:1;
      vuint32_t MIB_IDLE:1;
      vuint32_t  :30;
    } B;
  } MIBC;

  uint8_t FEC_reserved5[28];
  union {                              /* Receive Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MAX_FL:11;
      vuint32_t  :4;
      vuint32_t RMII_ECHO:1;
      vuint32_t RMII_LOOP:1;
      vuint32_t RMII_10T:1;
      vuint32_t RMII_MODE:1;
      vuint32_t  :2;
      vuint32_t FCE:1;
      vuint32_t BC_REJ:1;
      vuint32_t PROM:1;
      vuint32_t MII_MODE:1;
      vuint32_t DRT:1;
      vuint32_t LOOP:1;
    } B;
  } RCR;

  uint8_t FEC_reserved6[60];
  union {                              /* Transmit Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t RFC_PAUSE:1;
      vuint32_t TFC_PAUSE:1;
      vuint32_t FDEN:1;
      vuint32_t HBC:1;
      vuint32_t GTS:1;
    } B;
  } TCR;

  uint8_t FEC_reserved7[28];
  union {                              /* Physical Address Low Register */
    vuint32_t R;
    struct {
      vuint32_t PADDR1:32;
    } B;
  } PALR;

  union {                              /* Physical Address High Register and Type Field */
    vuint32_t R;
    struct {
      vuint32_t PADDR2:16;
      vuint32_t TYPE:16;
    } B;
  } PAUR;

  union {                              /* Opcode/Pause Duration */
    vuint32_t R;
    struct {
      vuint32_t OPCODE:16;
      vuint32_t PAUSE_DUR:16;
    } B;
  } OPD;

  uint8_t FEC_reserved8[40];
  union {                              /* Descriptor Individual Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR1:32;
    } B;
  } IAUR;

  union {                              /* Descriptor Individual Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t IADDR2:32;
    } B;
  } IALR;

  union {                              /* Descriptor Group Upper Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR1:32;
    } B;
  } GAUR;

  union {                              /* Descriptor Group Lower Address Register */
    vuint32_t R;
    struct {
      vuint32_t GADDR2:32;
    } B;
  } GALR;

  uint8_t FEC_reserved9[28];
  union {                              /* Transmit FIFO Watermark */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TFWR:2;
    } B;
  } TFWR;

  uint8_t FEC_reserved10[4];
  union {                              /* FIFO Receive Bound Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t R_BOUND:8;
      vuint32_t  :2;
    } B;
  } FRBR;

  union {                              /* FIFO Receive Start Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t R_FSTART:8;
      vuint32_t  :2;
    } B;
  } FRSR;

  uint8_t FEC_reserved11[44];
  union {                              /* Receive Descriptor Ring Start Register */
    vuint32_t R;
    struct {
      vuint32_t R_DES_START:30;
      vuint32_t  :2;
    } B;
  } ERDSR;

  union {                              /* Transmit Buffer Descriptor Ring Start Register */
    vuint32_t R;
    struct {
      vuint32_t X_DES_START:30;
      vuint32_t  :2;
    } B;
  } ETDSR;

  union {                              /* Receive Buffer Size Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t R_BUF_SIZE:7;
      vuint32_t  :4;
    } B;
  } EMRBR;

  uint8_t FEC_reserved12[116];
  union {                              /* Count of frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_DROP:32;
    } B;
  } RMON_T_DROP;

  union {                              /* RMON Tx packet count */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_PACKETS:32;
    } B;
  } RMON_T_PACKETS;

  union {                              /* RMON Tx broadcast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_BC_PKT:32;
    } B;
  } RMON_T_BC_PKT;

  union {                              /* RMON Tx multicast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_MC_PKT:32;
    } B;
  } RMON_T_MC_PKT;

  union {                              /* RMON Tx packets with CRC/align error */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_CRC_ALIGN:32;
    } B;
  } RMON_T_CRC_ALIGN;

  union {                              /* RMON Tx packets < 64 bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_UNDERSIZE:32;
    } B;
  } RMON_T_UNDERSIZE;

  union {                              /* RMON Tx packets > MAX_FL bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_OVERSIZE:32;
    } B;
  } RMON_T_OVERSIZE;

  union {                              /* RMON Tx packets < 64 bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_FRAG:32;
    } B;
  } RMON_T_FRAG;

  union {                              /* RMON Tx packets > MAX_FL bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_JAB:32;
    } B;
  } RMON_T_JAB;

  union {                              /* RMON Tx collision count */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_COL:32;
    } B;
  } RMON_T_COL;

  union {                              /* RMON Tx 64 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P64:32;
    } B;
  } RMON_T_P64;

  union {                              /* RMON Tx 65 to 127 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P65TO127:32;
    } B;
  } RMON_T_P65TO127;

  union {                              /* RMON Tx 128 to 255 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P128TO255:32;
    } B;
  } RMON_T_P128TO255;

  union {                              /* RMON Tx 256 to 511 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P256TO511:32;
    } B;
  } RMON_T_P256TO511;

  union {                              /* RMON Tx 512 to 1023 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P512TO1023:32;
    } B;
  } RMON_T_P512TO1023;

  union {                              /* RMON Tx 1024 to 2047 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P1024TO2047:32;
    } B;
  } RMON_T_P1024TO2047;

  union {                              /* RMON Tx packets with > 2048 bytes */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_P_GTE2048:32;
    } B;
  } RMON_T_P_GTE2048;

  union {                              /* RMON Tx Octets */
    vuint32_t R;
    struct {
      vuint32_t RMON_T_OCTETS:32;
    } B;
  } RMON_T_OCTETS;

  union {                              /* Count of transmitted frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_DROP:32;
    } B;
  } IEEE_T_DROP;

  union {                              /* Frames transmitted OK */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_FRAME_OK:32;
    } B;
  } IEEE_T_FRAME_OK;

  union {                              /* Frames transmitted with single collision */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_1COL:32;
    } B;
  } IEEE_T_1COL;

  union {                              /* Frames transmitted with multiple collisions */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_MCOL:32;
    } B;
  } IEEE_T_MCOL;

  union {                              /* Frames transmitted after deferral delay */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_DEF:32;
    } B;
  } IEEE_T_DEF;

  union {                              /* Frames transmitted with late collision */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_LCOL:32;
    } B;
  } IEEE_T_LCOL;

  union {                              /* Frames transmitted with excessive collisions */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_EXCOL:32;
    } B;
  } IEEE_T_EXCOL;

  union {                              /* Frames transmitted with Tx FIFO underrun */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_MACERR:32;
    } B;
  } IEEE_T_MACERR;

  union {                              /* Frames transmitted with carrier sense error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_CSERR:32;
    } B;
  } IEEE_T_CSERR;

  union {                              /* Frames transmitted with SQE error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_SQE:32;
    } B;
  } IEEE_T_SQE;

  union {                              /* Flow control pause frames transmitted */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_FDXFC:32;
    } B;
  } IEEE_T_FDXFC;

  union {                              /* Octet count for frames transmitted without error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_T_OCTETS_OK:32;
    } B;
  } IEEE_T_OCTETS_OK;

  uint8_t FEC_reserved13[8];
  union {                              /* Count of received frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_DROP:32;
    } B;
  } RMON_R_DROP;

  union {                              /* RMON Rx packet count */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_PACKETS:32;
    } B;
  } RMON_R_PACKETS;

  union {                              /* RMON Rx broadcast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_BC_PKT:32;
    } B;
  } RMON_R_BC_PKT;

  union {                              /* RMON Rx multicast packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_MC_PKT:32;
    } B;
  } RMON_R_MC_PKT;

  union {                              /* RMON Rx packets with CRC/Align error */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_CRC_ALIGN:32;
    } B;
  } RMON_R_CRC_ALIGN;

  union {                              /* RMON Rx packets < 64 bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_UNDERSIZE:32;
    } B;
  } RMON_R_UNDERSIZE;

  union {                              /* RMON Rx packets > MAX_FL bytes, good CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_OVERSIZE:32;
    } B;
  } RMON_R_OVERSIZE;

  union {                              /* RMON Rx packets < 64 bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_FRAG:32;
    } B;
  } RMON_R_FRAG;

  union {                              /* RMON Rx packets > MAX_FL bytes, bad CRC */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_JAB:32;
    } B;
  } RMON_R_JAB;

  union {                              /* Reserved */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_RESVD_0:32;
    } B;
  } RMON_R_RESVD_0;

  union {                              /* RMON Rx 64 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P64:32;
    } B;
  } RMON_R_P64;

  union {                              /* RMON Rx 65 to 127 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P65TO127:32;
    } B;
  } RMON_R_P65TO127;

  union {                              /* RMON Rx 128 to 255 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P128TO255:32;
    } B;
  } RMON_R_P128TO255;

  union {                              /* RMON Rx 256 to 511 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P256TO511:32;
    } B;
  } RMON_R_P256TO511;

  union {                              /* RMON Rx 512 to 1023 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P512TO1023:32;
    } B;
  } RMON_R_P512TO1023;

  union {                              /* RMON Rx 1024 to 2047 byte packets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P1024TO2047:32;
    } B;
  } RMON_R_P1024TO2047;

  union {                              /* RMON Rx packets with > 2048 bytes */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_P_GTE2048:32;
    } B;
  } RMON_R_P_GTE2048;

  union {                              /* RMON Rx octets */
    vuint32_t R;
    struct {
      vuint32_t RMON_R_OCTETS:32;
    } B;
  } RMON_R_OCTETS;

  union {                              /* Count of received frames not counted correctly */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_DROP:32;
    } B;
  } IEEE_R_DROP;

  union {                              /* Frames received OK */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_FRAME_OK:32;
    } B;
  } IEEE_R_FRAME_OK;

  union {                              /* Frames received with CRC error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_CRC:32;
    } B;
  } IEEE_R_CRC;

  union {                              /* Frames received with alignment error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_ALIGN:32;
    } B;
  } IEEE_R_ALIGN;

  union {                              /* Receive FIFO overflow count */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_MACERR:32;
    } B;
  } IEEE_R_MACERR;

  union {                              /* Flow control pause frames received */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_FDXFC:32;
    } B;
  } IEEE_R_FDXFC;

  union {                              /* Octet count for frames received without error */
    vuint32_t R;
    struct {
      vuint32_t IEEE_R_OCTETS_OK:32;
    } B;
  } IEEE_R_OCTETS_OK;
};


/* ============================================================================
   =============================== Module: FR =================================
   ============================================================================ */

struct FR_tag {
  union {                              /* Module Version Register */
    vuint16_t R;
    struct {
      vuint16_t CHIVER:8;
      vuint16_t PEVER:8;
    } B;
  } MVR;

  union {                              /* Module Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MEN:1;
      vuint16_t SBFF:1;                /* System Bus Failure Freeze */
      vuint16_t SCM:1;
      vuint16_t CHB:1;
      vuint16_t CHA:1;
      vuint16_t SFFE:1;
      vuint16_t ECCE:1;
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t FUM:1;
      vuint16_t FAM:1;
      vuint16_t  :1;
      vuint16_t CLKSEL:1;
      vuint16_t BITRATE:3;
      vuint16_t  :1;
    } B;
  } MCR;

  union {                              /* System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;               /* System Memory Base Address high. This is the value of the system memory base address for the individual message buffers and sync frame table. This is the value of the system memory base address for the receive FIFO if the FIFO address mode bit FR_MCR[FAM] is set to 1. It is defines as a byte address. */
    } B;
  } SYMBADHR;

  union {                              /* System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } SYMBADLR;

  union {                              /* Strobe Signal Control Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :3;
      vuint16_t SEL:4;
      vuint16_t  :3;
      vuint16_t ENB:1;
      vuint16_t  :2;
      vuint16_t STBPSEL:2;
    } B;
  } STBSCR;

  uint8_t FR_reserved0[2];
  union {                              /* Message Buffer Data Size Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t MBSEG2DS:7;
      vuint16_t  :1;
      vuint16_t MBSEG1DS:7;
    } B;
  } MBDSR;

  union {                              /* Message Buffer Segment Size and Utilization Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t LAST_MB_SEG1:7;
      vuint16_t  :1;
      vuint16_t LAST_MB_UTIL:7;
    } B;
  } MBSSUTR;

  union {                              /* PE DRAM Access Register */
    vuint16_t R;
    struct {
      vuint16_t INST:4;
      vuint16_t ADDR:11;
      vuint16_t DAD:1;
    } B;
  } PEDRAR;

  union {                              /* PE DRAM Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } PEDRDR;

  union {                              /* Protocol Operation Control Register */
    vuint16_t R;
    struct {
      vuint16_t WME:1;
      vuint16_t  :3;
      vuint16_t EOC_AP:2;
      vuint16_t ERC_AP:2;
      vuint16_t BSY_WMC:1;
      vuint16_t  :3;
      vuint16_t POCCMD:4;
    } B;
  } POCR;

  union {                              /* Global Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
      vuint16_t MIE:1;
      vuint16_t PRIE:1;
      vuint16_t CHIE:1;
      vuint16_t WUPIE:1;
      vuint16_t FAFBIE:1;
      vuint16_t FAFAIE:1;
      vuint16_t RBIE:1;
      vuint16_t TBIE:1;
    } B;
  } GIFER;

  union {                              /* Protocol Interrupt Flag Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IF:1;
      vuint16_t INTL_IF:1;
      vuint16_t ILCF_IF:1;
      vuint16_t CSA_IF:1;
      vuint16_t MRC_IF:1;
      vuint16_t MOC_IF:1;
      vuint16_t CCL_IF:1;
      vuint16_t MXS_IF:1;
      vuint16_t MTX_IF:1;
      vuint16_t LTXB_IF:1;
      vuint16_t LTXA_IF:1;
      vuint16_t TBVB_IF:1;
      vuint16_t TBVA_IF:1;
      vuint16_t TI2_IF:1;
      vuint16_t TI1_IF:1;
      vuint16_t CYS_IF:1;
    } B;
  } PIFR0;

  union {                              /* Protocol Interrupt Flag Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IF:1;
      vuint16_t IPC_IF:1;
      vuint16_t PECF_IF:1;
      vuint16_t PSC_IF:1;
      vuint16_t SSI3_IF:1;
      vuint16_t SSI2_IF:1;
      vuint16_t SSI1_IF:1;
      vuint16_t SSI0_IF:1;
      vuint16_t  :2;
      vuint16_t EVT_IF:1;
      vuint16_t ODT_IF:1;
      vuint16_t  :4;
    } B;
  } PIFR1;

  union {                              /* Protocol Interrupt Enable Register 0 */
    vuint16_t R;
    struct {
      vuint16_t FATL_IE:1;
      vuint16_t INTL_IE:1;
      vuint16_t ILCF_IE:1;
      vuint16_t CSA_IE:1;
      vuint16_t MRC_IE:1;
      vuint16_t MOC_IE:1;
      vuint16_t CCL_IE:1;
      vuint16_t MXS_IE:1;
      vuint16_t MTX_IE:1;
      vuint16_t LTXB_IE:1;
      vuint16_t LTXA_IE:1;
      vuint16_t TBVB_IE:1;
      vuint16_t TBVA_IE:1;
      vuint16_t TI2_IE:1;
      vuint16_t TI1_IE:1;
      vuint16_t CYS_IE:1;
    } B;
  } PIER0;

  union {                              /* Protocol Interrupt Enable Register 1 */
    vuint16_t R;
    struct {
      vuint16_t EMC_IE:1;
      vuint16_t IPC_IE:1;
      vuint16_t PECF_IE:1;
      vuint16_t PSC_IE:1;
      vuint16_t SSI3_IE:1;
      vuint16_t SSI2_IE:1;
      vuint16_t SSI1_IE:1;
      vuint16_t SSI0_IE:1;
      vuint16_t  :2;
      vuint16_t EVT_IE:1;
      vuint16_t ODT_IE:1;
      vuint16_t  :4;
    } B;
  } PIER1;

  union {                              /* CHI Error Flag Register */
    vuint16_t R;
    struct {
      vuint16_t FRLB_EF:1;
      vuint16_t FRLA_EF:1;
      vuint16_t PCMI_EF:1;
      vuint16_t FOVB_EF:1;
      vuint16_t FOVA_EF:1;
      vuint16_t MBS_EF:1;
      vuint16_t MBU_EF:1;
      vuint16_t LCK_EF:1;
      vuint16_t  :1;
      vuint16_t SBCF_EF:1;
      vuint16_t FID_EF:1;
      vuint16_t DPL_EF:1;
      vuint16_t SPL_EF:1;
      vuint16_t NML_EF:1;
      vuint16_t NMF_EF:1;
      vuint16_t ILSA_EF:1;
    } B;
  } CHIERFR;

  union {                              /* Message Buffer Interrupt Vector Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t TBIVEC:7;
      vuint16_t  :1;
      vuint16_t RBIVEC:7;
    } B;
  } MBIVEC;

  union {                              /* Channel A Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHAERSCNT:16;
    } B;
  } CASERCR;

  union {                              /* Channel B Status Error Counter Register */
    vuint16_t R;
    struct {
      vuint16_t CHBERSCNT:16;
    } B;
  } CBSERCR;

  union {                              /* Protocol Status Register 0 */
    vuint16_t R;
    struct {
      vuint16_t ERRMODE:2;
      vuint16_t SLOTMODE:2;
      vuint16_t  :1;
      vuint16_t PROTSTATE:3;
      vuint16_t STARTUPSTATE:4;
      vuint16_t  :1;
      vuint16_t WAKEUPSTATUS:3;
    } B;
  } PSR0;

  union {                              /* Protocol Status Register 1 */
    vuint16_t R;
    struct {
      vuint16_t CSAA:1;
      vuint16_t CSP:1;
      vuint16_t  :1;
      vuint16_t REMCSAT:5;
      vuint16_t CPN:1;
      vuint16_t HHR:1;
      vuint16_t FRZ:1;
      vuint16_t APTAC:5;
    } B;
  } PSR1;

  union {                              /* Protocol Status Register 2 */
    vuint16_t R;
    struct {
      vuint16_t NBVB:1;
      vuint16_t NSEB:1;
      vuint16_t STCB:1;
      vuint16_t SBVB:1;
      vuint16_t SSEB:1;
      vuint16_t MTB:1;
      vuint16_t NBVA:1;
      vuint16_t NSEA:1;
      vuint16_t STCA:1;
      vuint16_t SBVA:1;
      vuint16_t SSEA:1;
      vuint16_t MTA:1;
      vuint16_t CKCORFCNT:4;
    } B;
  } PSR2;

  union {                              /* Protocol Status Register 3 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t WUB:1;
      vuint16_t ABVB:1;
      vuint16_t AACB:1;
      vuint16_t ACEB:1;
      vuint16_t ASEB:1;
      vuint16_t AVFB:1;
      vuint16_t  :2;
      vuint16_t WUA:1;
      vuint16_t ABVA:1;
      vuint16_t AACA:1;
      vuint16_t ACEA:1;
      vuint16_t ASEA:1;
      vuint16_t AVFA:1;
    } B;
  } PSR3;

  union {                              /* Macrotick Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t MTCT:14;
    } B;
  } MTCTR;

  union {                              /* Cycle Counter Register */
    vuint16_t R;
    struct {
      vuint16_t  :10;
      vuint16_t CYCCNT:6;
    } B;
  } CYCTR;

  union {                              /* Slot Counter Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTA:11;
    } B;
  } SLTCTAR;

  union {                              /* Slot Counter Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t SLOTCNTB:11;
    } B;
  } SLTCTBR;

  union {                              /* Rate Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t RATECORR:16;
    } B;
  } RTCORVR;

  union {                              /* Offset Correction Value Register */
    vuint16_t R;
    struct {
      vuint16_t OFFSETCORR:16;
    } B;
  } OFCORVR;

  union {                              /* Combined Interrupt Flag Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t MIF:1;
      vuint16_t PRIF:1;
      vuint16_t CHIF:1;
      vuint16_t WUPIF:1;
      vuint16_t FAFBIF:1;
      vuint16_t FAFAIF:1;
      vuint16_t RBIF:1;
      vuint16_t TBIF:1;
    } B;
  } CIFR;

  union {                              /* System Memory Access Time-Out Register */
    vuint16_t R;
    struct {
      vuint16_t  :8;
      vuint16_t TIMEOUT:8;
    } B;
  } SYMATOR;

  union {                              /* Sync Frame Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SFEVB:4;
      vuint16_t SFEVA:4;
      vuint16_t SFODB:4;
      vuint16_t SFODA:4;
    } B;
  } SFCNTR;

  union {                              /* Sync Frame Table Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SFT_OFFSET:15;
      vuint16_t  :1;
    } B;
  } SFTOR;

  union {                              /* Sync Frame Table Configuration, Control, Status Register */
    vuint16_t R;
    struct {
      vuint16_t ELKT:1;
      vuint16_t OLKT:1;
      vuint16_t CYCNUM:6;
      vuint16_t ELKS:1;
      vuint16_t OLKS:1;
      vuint16_t EVAL:1;
      vuint16_t OVAL:1;
      vuint16_t  :1;
      vuint16_t OPT:1;
      vuint16_t SDVEN:1;
      vuint16_t SIDEN:1;
    } B;
  } SFTCCSR;

  union {                              /* Sync Frame ID Rejection Filter Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SYNFRID:10;
    } B;
  } SFIDRFR;

  union {                              /* Sync Frame ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FVAL:10;
    } B;
  } SFIDAFVR;

  union {                              /* Sync Frame ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t FMSK:10;
    } B;
  } SFIDAFMR;

  union {                              /* Network Management Vector Register */
    vuint16_t R;
    struct {
      vuint16_t NMVP:16;
    } B;
  } NMVR[6];

  union {                              /* Network Management Vector Length Register */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t NMVL:4;
    } B;
  } NMVLR;

  union {                              /* Timer Configuration and Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T2_CFG:1;
      vuint16_t T2_REP:1;
      vuint16_t  :1;
      vuint16_t T2SP:1;
      vuint16_t T2TR:1;
      vuint16_t T2ST:1;
      vuint16_t  :3;
      vuint16_t T1_REP:1;
      vuint16_t  :1;
      vuint16_t T1SP:1;
      vuint16_t T1TR:1;
      vuint16_t T1ST:1;
    } B;
  } TICCR;

  union {                              /* Timer 1 Cycle Set Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_CYC_VAL:6;
      vuint16_t  :2;
      vuint16_t T1_CYC_MSK:6;
    } B;
  } TI1CYSR;

  union {                              /* Timer 1 Macrotick Offset Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t T1_MTOFFSET:14;
    } B;
  } TI1MTOR;

  union {
    union {                            /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2CYCVAL:6;          /* Timer T2 Cycle Filter Mask */
        vuint16_t  :2;
        vuint16_t T2CYCMSK:6;          /* Timer T2 Cycle Filter Mask */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;          /* Timer T2 Macrotick High Word */
      } B;
    } REL;
  } TI2CR0;

  union {
    union {                            /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t T2MOFF:14;           /* Timer T2 Macrotick Offset */
      } B;
    } ABS;
    union {                            /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
      vuint16_t R;
      struct {
        vuint16_t T2MTCNT:16;
      } B;
    } REL;
  } TI2CR1;

  union {                              /* Slot Status Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SLOTNUMBER:11;
    } B;
  } SSSR;

  union {                              /* Slot Status Counter Condition Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t CNTCFG:2;
      vuint16_t MCY:1;
      vuint16_t VFR:1;
      vuint16_t SYF:1;
      vuint16_t NUF:1;
      vuint16_t SUF:1;
      vuint16_t STATUSMASK:4;
    } B;
  } SSCCR;

  union {                              /* Slot Status Register */
    vuint16_t R;
    struct {
      vuint16_t VFB:1;
      vuint16_t SYB:1;
      vuint16_t NFB:1;
      vuint16_t SUB:1;
      vuint16_t SEB:1;
      vuint16_t CEB:1;
      vuint16_t BVB:1;
      vuint16_t TCB:1;
      vuint16_t VFA:1;
      vuint16_t SYA:1;
      vuint16_t NFA:1;
      vuint16_t SUA:1;
      vuint16_t SEA:1;
      vuint16_t CEA:1;
      vuint16_t BVA:1;
      vuint16_t TCA:1;
    } B;
  } SSR[8];

  union {                              /* Slot Status Counter Register */
    vuint16_t R;
    struct {
      vuint16_t SLOTSTATUSCNT:16;
    } B;
  } SSCR[4];

  union {                              /* MTS A Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSACFR;

  union {                              /* MTS B Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t MTE:1;
      vuint16_t  :1;
      vuint16_t CYCCNTMSK:6;
      vuint16_t  :2;
      vuint16_t CYCCNTVAL:6;
    } B;
  } MTSBCFR;

  union {                              /* Receive Shadow Buffer Index Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t  :1;
      vuint16_t SEL:2;
      vuint16_t  :4;
      vuint16_t RSBIDX:8;              /* RSBIDXA1/RSBIDXA2/RSBIDXB1/RSBIDXB2- Receive Shadow Buffer Index */
    } B;
  } RSBIR;

  union {                              /* Receive FIFO Watermark and Selection Register */
    vuint16_t R;
    struct {
      vuint16_t WM:8;                  /* WMA/WMB - Watermark */
      vuint16_t  :7;
      vuint16_t SEL:1;
    } B;
  } RFWMSR;

  union {                              /* Receive FIFO Start Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t SIDX:10;               /* SIDXA/SIDXB - Start Index */
    } B;
  } RFSIR;

  union {                              /* Receive FIFO Depth and Size Register */
    vuint16_t R;
    struct {
      vuint16_t FIFO_DEPTH:8;          /* FIFO_DEPTHA/FIFO_DEPTHB - FIFO Depth */
      vuint16_t  :1;
      vuint16_t ENTRY_SIZE:7;          /* ENTRY_SIZEA/ENTRY_SIZEB - Entry Size */
    } B;
  } RFDSR;

  union {                              /* Receive FIFO A Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFARIR;

  union {                              /* Receive FIFO B Read Index Register */
    vuint16_t R;
    struct {
      vuint16_t  :6;
      vuint16_t RDIDX:10;
    } B;
  } RFBRIR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFVAL:16;           /* MIDAFVALA/MIDAFVALB - Message ID Acceptance Filter Value */
    } B;
  } RFMIDAFVR;

  union {                              /* Receive FIFO Message ID Acceptance Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t MIDAFMSK:16;           /* MIDAFMSKA/MIDAFMSKB - Message ID Acceptance Filter Mask */
    } B;
  } RFMIDAFMR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Value Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFVAL:11;           /* FIDRFVALA/FIDRFVALB - Frame ID Rejection Filter Value */
    } B;
  } RFFIDRFVR;

  union {                              /* Receive FIFO Frame ID Rejection Filter Mask Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t FIDRFMSK:11;
    } B;
  } RFFIDRFMR;

  union {                              /* Receive FIFO Range Filter Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t WMD:1;
      vuint16_t IBD:1;
      vuint16_t SEL:2;
      vuint16_t  :1;
      vuint16_t SID:11;                /* Slot ID */
    } B;
  } RFRFCFR;

  union {                              /* Receive FIFO Range Filter Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :4;
      vuint16_t F3MD:1;
      vuint16_t F2MD:1;
      vuint16_t F1MD:1;
      vuint16_t F0MD:1;
      vuint16_t  :4;
      vuint16_t F3EN:1;
      vuint16_t F2EN:1;
      vuint16_t F1EN:1;
      vuint16_t F0EN:1;
    } B;
  } RFRFCTR;

  union {                              /* Last Dynamic Transmit Slot Channel A Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTA:11;
    } B;
  } LDTXSLAR;

  union {                              /* Last Dynamic Transmit Slot Channel B Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t LDYNTXSLOTB:11;
    } B;
  } LDTXSLBR;

  union {                              /* Protocol Configuration Register 0 */
    vuint16_t R;
    struct {
      vuint16_t action_point_offset:6;
      vuint16_t static_slot_length:10;
    } B;
  } PCR0;

  union {                              /* Protocol Configuration Register 1 */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t macro_after_first_static_slot:14;
    } B;
  } PCR1;

  union {                              /* Protocol Configuration Register 2 */
    vuint16_t R;
    struct {
      vuint16_t minislot_after_action_point:6;
      vuint16_t number_of_static_slots:10; /* gNumberOfStaticSlots */
    } B;
  } PCR2;

  union {                              /* Protocol Configuration Register 3 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_symbol_rx_low:6;
      vuint16_t minislot_action_point_offset:5;
      vuint16_t coldstart_attempts:5;
    } B;
  } PCR3;

  union {                              /* Protocol Configuration Register 4 */
    vuint16_t R;
    struct {
      vuint16_t cas_rx_low_max:7;
      vuint16_t wakeup_symbol_rx_window:9;
    } B;
  } PCR4;

  union {                              /* Protocol Configuration Register 5 */
    vuint16_t R;
    struct {
      vuint16_t tss_transmitter:4;
      vuint16_t wakeup_symbol_tx_low:6;
      vuint16_t wakeup_symbol_rx_idle:6;
    } B;
  } PCR5;

  union {                              /* Protocol Configuration Register 6 */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t symbol_window_after_action_point:8;
      vuint16_t macro_initial_offset_a:7;
    } B;
  } PCR6;

  union {                              /* Protocol Configuration Register 7 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_b:9;
      vuint16_t micro_per_macro_nom_half:7;
    } B;
  } PCR7;

  union {                              /* Protocol Configuration Register 8 */
    vuint16_t R;
    struct {
      vuint16_t max_without_clock_correction_fatal:4;
      vuint16_t max_without_clock_correction_passive:4;
      vuint16_t wakeup_symbol_tx_idle:8;
    } B;
  } PCR8;

  union {                              /* Protocol Configuration Register 9 */
    vuint16_t R;
    struct {
      vuint16_t minislot_exists:1;
      vuint16_t symbol_window_exists:1;
      vuint16_t offset_correction_out:14;
    } B;
  } PCR9;

  union {                              /* Protocol Configuration Register 10 */
    vuint16_t R;
    struct {
      vuint16_t single_slot_enabled:1;
      vuint16_t wakeup_channel:1;
      vuint16_t macro_per_cycle:14;
    } B;
  } PCR10;

  union {                              /* Protocol Configuration Register 11 */
    vuint16_t R;
    struct {
      vuint16_t key_slot_used_for_startup:1;
      vuint16_t key_slot_used_for_sync:1;
      vuint16_t offset_correction_start:14;
    } B;
  } PCR11;

  union {                              /* Protocol Configuration Register 12 */
    vuint16_t R;
    struct {
      vuint16_t allow_passive_to_active:5;
      vuint16_t key_slot_header_crc:11;
    } B;
  } PCR12;

  union {                              /* Protocol Configuration Register 13 */
    vuint16_t R;
    struct {
      vuint16_t first_minislot_action_point_offset:6;
      vuint16_t static_slot_after_action_point:10;
    } B;
  } PCR13;

  union {                              /* Protocol Configuration Register 14 */
    vuint16_t R;
    struct {
      vuint16_t rate_correction_out:11;
      vuint16_t listen_timeout:5;
    } B;
  } PCR14;

  union {                              /* Protocol Configuration Register 15 */
    vuint16_t R;
    struct {
      vuint16_t listen_timeout:16;
    } B;
  } PCR15;

  union {                              /* Protocol Configuration Register 16 */
    vuint16_t R;
    struct {
      vuint16_t macro_initial_offset_b:7;
      vuint16_t noise_listen_timeout:9;
    } B;
  } PCR16;

  union {                              /* Protocol Configuration Register 17 */
    vuint16_t R;
    struct {
      vuint16_t noise_listen_timeout:16;
    } B;
  } PCR17;

  union {                              /* Protocol Configuration Register 18 */
    vuint16_t R;
    struct {
      vuint16_t wakeup_pattern:6;
      vuint16_t key_slot_id:10;
    } B;
  } PCR18;

  union {                              /* Protocol Configuration Register 19 */
    vuint16_t R;
    struct {
      vuint16_t decoding_correction_a:9;
      vuint16_t payload_length_static:7;
    } B;
  } PCR19;

  union {                              /* Protocol Configuration Register 20 */
    vuint16_t R;
    struct {
      vuint16_t micro_initial_offset_b:8;
      vuint16_t micro_initial_offset_a:8;
    } B;
  } PCR20;

  union {                              /* Protocol Configuration Register 21 */
    vuint16_t R;
    struct {
      vuint16_t extern_rate_correction:3;
      vuint16_t latest_tx:13;
    } B;
  } PCR21;

  union {                              /* Protocol Configuration Register 22 */
    vuint16_t R;
    struct {
      vuint16_t  :1;                   /* Reserved bit, will not be changed. Application must not write any value different from the reset value. */
      vuint16_t comp_accepted_startup_range_a:11;
      vuint16_t micro_per_cycle:4;
    } B;
  } PCR22;

  union {                              /* Protocol Configuration Register 23 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle:16;
    } B;
  } PCR23;

  union {                              /* Protocol Configuration Register 24 */
    vuint16_t R;
    struct {
      vuint16_t cluster_drift_damping:5;
      vuint16_t max_payload_length_dynamic:7;
      vuint16_t micro_per_cycle_min:4;
    } B;
  } PCR24;

  union {                              /* Protocol Configuration Register 25 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_min:16;
    } B;
  } PCR25;

  union {                              /* Protocol Configuration Register 26 */
    vuint16_t R;
    struct {
      vuint16_t allow_halt_due_to_clock:1;
      vuint16_t comp_accepted_startup_range_b:11;
      vuint16_t micro_per_cycle_max:4;
    } B;
  } PCR26;

  union {                              /* Protocol Configuration Register 27 */
    vuint16_t R;
    struct {
      vuint16_t micro_per_cycle_max:16;
    } B;
  } PCR27;

  union {                              /* Protocol Configuration Register 28 */
    vuint16_t R;
    struct {
      vuint16_t dynamic_slot_idle_phase:2;
      vuint16_t macro_after_offset_correction:14;
    } B;
  } PCR28;

  union {                              /* Protocol Configuration Register 29 */
    vuint16_t R;
    struct {
      vuint16_t extern_offset_correction:3;
      vuint16_t minislots_max:13;
    } B;
  } PCR29;

  union {                              /* Protocol Configuration Register 30 */
    vuint16_t R;
    struct {
      vuint16_t  :12;
      vuint16_t sync_node_max:4;
    } B;
  } PCR30;

  union {                              /* StopWatch Count Register */
    vuint16_t R;
    struct {
      vuint16_t STPW:16;               /* StopWatch Count Register */
    } B;
  } STPWR;

  uint8_t FR_reserved1[2];
  union {                              /* Protocol Event Output Enable and StopWatch Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :7;
      vuint16_t STPW_EN:1;             /* Stopwatch count Enable */
      vuint16_t  :5;
      vuint16_t TIM2_EE:1;
      vuint16_t TIM1_EE:1;
      vuint16_t CYC_EE:1;
    } B;
  } PEOER;

  uint8_t FR_reserved2[2];
  union {                              /* Receive FIFO Start Data Offset Register */
    vuint16_t R;
    struct {
      vuint16_t SDO:16;                /* SDOA/SDOB - Start Data Field Offset */
    } B;
  } RFSDOR;

  union {                              /* Receive FIFO System Memory Base Address High Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:16;
    } B;
  } RFSYMBADHR;

  union {                              /* Receive FIFO System Memory Base Address Low Register */
    vuint16_t R;
    struct {
      vuint16_t SMBA:12;
      vuint16_t  :4;
    } B;
  } RFSYMBADLR;

  union {                              /* Receive FIFO Periodic Timer Register */
    vuint16_t R;
    struct {
      vuint16_t  :2;
      vuint16_t PTD:14;
    } B;
  } RFPTR;

  union {                              /* Receive FIFO Fill Level and POP Count Register */
    vuint16_t R;
    struct {
      vuint16_t FLB_or_PCB:8;
      vuint16_t FLA_or_PCA:8;
    } B;
  } RFFLPCR;

  union {                              /* ECC Error Interrupt Flag and Enable Register */
    vuint16_t R;
    struct {
      vuint16_t LRNE_OF:1;
      vuint16_t LRCE_OF:1;
      vuint16_t DRNE_OF:1;
      vuint16_t DRCE_OF:1;
      vuint16_t LRNE_IF:1;
      vuint16_t LRCE_IF:1;
      vuint16_t DRNE_IF:1;
      vuint16_t DRCE_IF:1;
      vuint16_t  :4;
      vuint16_t LRNE_IE:1;
      vuint16_t LRCE_IE:1;
      vuint16_t DRNE_IE:1;
      vuint16_t DRCE_IE:1;
    } B;
  } EEIFER;

  union {                              /* ECC Error Report and Injection Control Register */
    vuint16_t R;
    struct {
      vuint16_t BSY:1;
      vuint16_t  :5;
      vuint16_t ERS:2;
      vuint16_t  :3;
      vuint16_t ERM:1;
      vuint16_t  :2;
      vuint16_t EIM:1;
      vuint16_t EIE:1;
    } B;
  } EERICR;

  union {                              /* ECC Error Report Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EERAR;

  union {                              /* ECC Error Report Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EERDR;

  union {                              /* ECC Error Report Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EERCR;

  union {                              /* ECC Error Injection Address Register */
    vuint16_t R;
    struct {
      vuint16_t MID:1;
      vuint16_t BANK:3;
      vuint16_t ADDR:12;
    } B;
  } EEIAR;

  union {                              /* ECC Error Injection Data Register */
    vuint16_t R;
    struct {
      vuint16_t DATA:16;
    } B;
  } EEIDR;

  union {                              /* ECC Error Injection Code Register */
    vuint16_t R;
    struct {
      vuint16_t  :11;
      vuint16_t CODE:5;
    } B;
  } EEICR;

  uint8_t FR_reserved3[1792];
  struct {
    union {                            /* Message Buffer Configuration, Control, Status Register */
      vuint16_t R;
      struct {
        vuint16_t  :3;
        vuint16_t MTD:1;
        vuint16_t CMT:1;
        vuint16_t EDT:1;
        vuint16_t LCKT:1;
        vuint16_t MBIE:1;
        vuint16_t  :3;
        vuint16_t DUP:1;
        vuint16_t DVAL:1;
        vuint16_t EDS:1;
        vuint16_t LCKS:1;
        vuint16_t MBIF:1;
      } B;
    } CCSR;
    union {                            /* Message Buffer Cycle Counter Filter Register */
      vuint16_t R;
      struct {
        vuint16_t MTM:1;
        vuint16_t CHA:1;
        vuint16_t CHB:1;
        vuint16_t CCFE:1;
        vuint16_t CCFMSK:6;
        vuint16_t CCFVAL:6;
      } B;
    } CCFR;
    union {                            /* Message Buffer Frame ID Register */
      vuint16_t R;
      struct {
        vuint16_t  :5;
        vuint16_t FID:11;
      } B;
    } FIDR;
    union {                            /* Message Buffer Index Register */
      vuint16_t R;
      struct {
        vuint16_t  :8;
        vuint16_t MBIDX:8;
      } B;
    } IDXR;
  } MB[128];

  uint8_t FR_reserved4[1024];
  union {                              /* Message Buffer Data Field Offset Register */
    vuint16_t R;
    struct {
      vuint16_t MBDO:16;
    } B;
  } MBDOR[132];

  union {                              /* LRAM ECC Error Test Register */
    vuint16_t R;
    struct {
      vuint16_t LEETD:16;
    } B;
  } LEETR[6];
};


/* ============================================================================
   =============================== Module: GTM ================================
   ============================================================================ */

struct GTM_tag {
  union {                              /* GTM Revision Register */
    vuint32_t R;
    struct {
      vuint32_t DEV_CODE2:4;           /* Device encoding digit 2. */
      vuint32_t DEV_CODE1:4;           /* Device encoding digit 1. */
      vuint32_t DEV_CODE0:4;           /* Device encoding digit 0. */
      vuint32_t MAJOR:4;               /* Major version number */
      vuint32_t MINOR:4;               /* Minor version number */
      vuint32_t NO:4;                  /* Delivery number. */
      vuint32_t STEP:8;                /* Release step. */
    } B;
  } REV;

  union {                              /* GTM Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t RST:1;                 /* GTM Reset. */
    } B;
  } RST;

  union {                              /* GTM Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;                  /* Read as zero, should be written as zero. */
      vuint32_t TO_VAL:5;              /* AEI Timeout value. */
      vuint32_t  :2;                   /* Read as zero, should be written as zero. */
      vuint32_t TO_MODE:1;             /* AEI Timeout mode. */
      vuint32_t RF_PROT:1;             /* RST and FORCINT protection. */
    } B;
  } CTRL;

  union {                              /* GTM AEI Address Pointer Register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t TO_W1R0:1;             /* AEI Timeout Read/Write flag. */
      vuint32_t TO_ADDR:20;            /* AEI Timeout address. */
    } B;
  } AEI_ADDR_XPT;

  union {                              /* GTM Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t AEI_USP_BE:1;          /* AEI Unsupported byte enable interrupt. */
      vuint32_t AEI_IM_ADDR:1;         /* AEI Illegal Module address interrupt. */
      vuint32_t AEI_USP_ADDR:1;        /* AEI Unsupported address interrupt. */
      vuint32_t AEI_TO_XPT:1;          /* AEI Timeout exception occurred. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* GTM Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t AEI_USP_BE_IRQ_EN:1;   /* AEI Unsupported Byte Enable Interrupt Enable. */
      vuint32_t AEI_IM_ADDR_IRQ_EN:1;  /* AEI Illegal Module Address Interrupt Enable. */
      vuint32_t AEI_USP_ADDR_IRQ_EN:1; /* AEI Unsupported Address Interrupt Enable. */
      vuint32_t AEI_TO_XPT_IRQ_EN:1;   /* AEI Timeout Exception Interrupt Enable. */
    } B;
  } IRQ_EN;

  union {                              /* GTM Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TRG_AEI_USP_BE:1;      /* Trigger AEI_USP_BE_IRQ interrupt by software. */
      vuint32_t TRG_AEI_IM_ADDR:1;     /* Trigger AEI_IM_ADDR_IRQ interrupt by software. */
      vuint32_t TRG_AEI_USP_ADDR:1;    /* Trigger AEI_USP_ADDR_IRQ interrupt by software. */
      vuint32_t TRG_AEI_TO_XPT:1;      /* Trigger AEI_TO_XPT_IRQ interrupt by software. */
    } B;
  } IRQ_FORCINT;

  union {                              /* GTM Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Read as zero, should be written as zero. */
      vuint32_t IRQ_MODE:2;            /* Interrupt strategy mode selection for the AEI timeout and address monitoring interrupts. */
    } B;
  } IRQ_MODE;

  union {                              /* GTM Error Interrupt Request Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t AEI_USP_BE_EIRQ_EN:1;  /* AEI_USP_BE_EIRQ error interrupt enable. */
      vuint32_t AEI_IM_ADDR_EIRQ_EN:1; /* AEI_IM_ADDR_EIRQ error interrupt enable. */
      vuint32_t AEI_USP_ADDR_EIRQ_EN:1; /* AEI_USP_ADDR_EIRQ error interrupt enable. */
      vuint32_t AEI_TO_XPT_EIRQ_EN:1;  /* AEI_TO_XPT_EIRQ error interrupt enable. */
    } B;
  } EIRQ_EN;

  uint8_t GTM_reserved0[12];
  union {                              /* GTM Bridge Mode Register */
    vuint32_t R;
    struct {
      vuint32_t BUFF_DPT:8;            /* Buffer depth of AEI bridge. */
      vuint32_t  :7;
      vuint32_t BRG_RST:1;             /* Bridge software reset. */
      vuint32_t  :3;
      vuint32_t SYNC_INPUT_REG:1;      /* Additional pipelined stage in synchronous bridge mode. */
      vuint32_t  :2;
      vuint32_t BUFF_OVL:1;            /* Buffer overflow register. */
      vuint32_t MODE_UP_PGR:1;         /* Mode update in progress. */
      vuint32_t  :6;
      vuint32_t MSK_WR_RSP:1;          /* Mask write response. */
      vuint32_t BRG_MODE:1;            /* Defines the operation mode for the AEI bridge. */
    } B;
  } BRIDGE_MODE;

  union {                              /* GTM Bridge Pointer 1 Register */
    vuint32_t R;
    struct {
      vuint32_t RSP_TRAN_RDY:6;        /* Response transactions ready. */
      vuint32_t FBC:6;                 /* Free buffer count. */
      vuint32_t ABT_TRAN_PGR:5;        /* Aborted transaction in progress pointer. */
      vuint32_t TRAN_IN_PGR:5;         /* Transaction in progress pointer (acquire). */
      vuint32_t FIRST_RSP_PTR:5;       /* First response pointer. */
      vuint32_t NEW_TRAN_PTR:5;        /* New transaction pointer. */
    } B;
  } BRIDGE_PTR1;

  union {                              /* GTM Bridge Pointer 2 Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t TRAN_IN_PGR2:5;        /* Transaction in progress pointer (aquire2). */
    } B;
  } BRIDGE_PTR2;

  uint8_t GTM_reserved1[4];
  union {                              /* GTM TIM0 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM0_AUX_IN_SRC;

  union {                              /* GTM TIM1 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM1_AUX_IN_SRC;

  union {                              /* GTM TIM2 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM2_AUX_IN_SRC;

  union {                              /* GTM TIM3 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM3_AUX_IN_SRC;

  union {                              /* GTM TIM4 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM4_AUX_IN_SRC;

  union {                              /* GTM TIM5 Auxiliary Input Source register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRC_CH7:1;             /* Defines AUX_IN source of TIM[i] channel 7. */
      vuint32_t SRC_CH6:1;             /* Defines AUX_IN source of TIM[i] channel 6. */
      vuint32_t SRC_CH5:1;             /* Defines AUX_IN source of TIM[i] channel 5. */
      vuint32_t SRC_CH4:1;             /* Defines AUX_IN source of TIM[i] channel 4. */
      vuint32_t SRC_CH3:1;             /* Defines AUX_IN source of TIM[i] channel 3. */
      vuint32_t SRC_CH2:1;             /* Defines AUX_IN source of TIM[i] channel 2. */
      vuint32_t SRC_CH1:1;             /* Defines AUX_IN source of TIM[i] channel 1. */
      vuint32_t SRC_CH0:1;             /* Defines AUX_IN source of TIM[i] channel 0. */
    } B;
  } TIM5_AUX_IN_SRC;
};


/* ============================================================================
   =============================== Module: GTMINT =============================
   ============================================================================ */

struct GTMINT_tag {
  uint8_t GTMINT_reserved0[192];
  union {                              /* GTM Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MDIS:1;                /* [BLG_GTMW_007] [Covers: Saf1461] MDIS [end] Module Disable. */
      vuint32_t  :13;
      vuint32_t AEISREN:1;             /* [BLG_GTMW_007] [Covers: Saf1461] Saf1276 - Safety-critical AEISREN [end] AEI interface soft-reset control enable. */
      vuint32_t  :1;
      vuint32_t STPS:1;                /* [BLG_GTMW_007] [Covers: Saf1461] STPS [end] Stop Mode Status. */
      vuint32_t  :14;
    } B;
  } GTMMCR;

  uint8_t GTMINT_reserved1[4];
  union {                              /* GTM Interrupts Clear Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t INTCLR_PTR:10;         /* [BLG_GTMW_007] [Covers: Saf1461] INTCLR_PTR [end] Interrupt Clear Pointer. */
    } B;
  } GTMINTCLR;

  union {                              /* GTM AEI Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t AEISRST:1;             /* [BLG_GTMW_007] [Covers: Saf1461] AEISRST [end] AEI interface soft-reset control. */
    } B;
  } GTMAEICR;
};


/* ============================================================================
   =============================== Module: GTM_AFD ============================
   ============================================================================ */

struct GTM_AFD_tag {
  struct {
    union {                            /* AFD FIFO Channel n Buffer Access Register, n=0:7 */
      vuint32_t R;
      struct {
        vuint32_t  :3;
        vuint32_t DATA:29;             /* Read/write data from/to FIFO. */
      } B;
    } BUF_ACC;
    uint8_t CH_reserved0[12];
  } CH[8];
};


/* ============================================================================
   =============================== Module: GTM_ARU ============================
   ============================================================================ */

struct GTM_ARU_tag {
  union {                              /* ARU Access Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t WREQ:1;                /* Initiate write request. */
      vuint32_t RREQ:1;                /* Initiate read request. */
      vuint32_t  :3;
      vuint32_t ADDR:9;                /* ARU address. */
    } B;
  } ACCESS;

  union {                              /* ARU Data High Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Upper ARU data word. */
    } B;
  } DATA_H;

  union {                              /* ARU Data Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Lower ARU data word. */
    } B;
  } DATA_L;

  union {                              /* ARU Debug Access 0 Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ADDR:9;                /* ARU debugging address. */
    } B;
  } DBG_ACCESS0;

  union {                              /* ARU Debug Data 0 High Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Upper debug data word. */
    } B;
  } DBG_DATA0_H;

  union {                              /* ARU Debug Data 0 Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Lower debug data word. */
    } B;
  } DBG_DATA0_L;

  union {                              /* ARU Debug Access 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ADDR:9;                /* ARU debugging address. */
    } B;
  } DBG_ACCESS1;

  union {                              /* ARU Debug Data 1 High */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Upper debug data word */
    } B;
  } DBG_DATA1_H;

  union {                              /* ARU Debug Data 1 Low Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DATA:29;               /* Lower debug data word. */
    } B;
  } DBG_DATA1_L;

  union {                              /* ARU Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t ACC_ACK:1;             /* On read access data valid, AEI to ARU access is complete. */
      vuint32_t NEW_DATA1:1;           /* Data was transferred for address ARU_DBG_ACCESS1. */
      vuint32_t NEW_DATA0:1;           /* Data was transferred for address ARU_DBG_ACCESS0. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* ARU Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t ACC_ACK_IRQ_EN:1;      /* ACC_ACK_IRQ interrupt enable. */
      vuint32_t NEW_DATA1_IRQ_EN:1;    /* ARU_NEW_DATA1_IRQ interrupt enable. */
      vuint32_t NEW_DATA0_IRQ_EN:1;    /* ARU_NEW_DATA0_IRQ interrupt enable. */
    } B;
  } IRQ_EN;

  union {                              /* ARU Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_ACC_ACK:1;         /* Trigger ACC_ACK interrupt. */
      vuint32_t TRG_NEW_DATA1:1;       /* Trigger new data 1 interrupt. */
      vuint32_t TRG_NEW_DATA0:1;       /* Trigger new data 0 interrupt. */
    } B;
  } IRQ_FORCINT;

  union {                              /* ARU Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t IRQ_MODE:2;            /* IRQ mode select. */
    } B;
  } IRQ_MODE;
};


/* ============================================================================
   =============================== Module: GTM_ATOM ===========================
   ============================================================================ */

struct GTM_ATOM_tag {
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH0_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH0_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH0_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH0_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH0_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH0_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH0_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH0_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  uint8_t ATOM_reserved0[16];
  union {                              /* ATOM AGC Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t UPEN_CTRL7:2;          /* For channel 7, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL6:2;          /* For channel 6, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL5:2;          /* For channel 5, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL4:2;          /* For channel 4, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL3:2;          /* For channel 3, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL2:2;          /* For channel 2, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL1:2;          /* For channel 1, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL0:2;          /* For channel 0, ATOM channel enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t RST_CH7:1;             /* See RST_CH0 */
      vuint32_t RST_CH6:1;             /* See RST_CH0 */
      vuint32_t RST_CH5:1;             /* See RST_CH0 */
      vuint32_t RST_CH4:1;             /* See RST_CH0 */
      vuint32_t RST_CH3:1;             /* See RST_CH0 */
      vuint32_t RST_CH2:1;             /* See RST_CH0 */
      vuint32_t RST_CH1:1;             /* See RST_CH0 */
      vuint32_t RST_CH0:1;             /* Software reset of corresponding channel 0. */
      vuint32_t  :7;
      vuint32_t HOST_TRIG:1;           /* Trigger request signal (see AGC) to update the register ENDIS_STAT and OUTEN_STAT. */
    } B;
  } AGC_GLB_CTRL;

  union {                              /* ATOM TGC0 Enable/Disable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_CTRL7:2;         /* Channel 7 enable/disable update value. */
      vuint32_t ENDIS_CTRL6:2;         /* Channel 6 enable/disable update value. */
      vuint32_t ENDIS_CTRL5:2;         /* Channel 5 enable/disable update value. */
      vuint32_t ENDIS_CTRL4:2;         /* TOM channel 4 enable/disable update value. */
      vuint32_t ENDIS_CTRL3:2;         /* TOM channel 3 enable/disable update value. */
      vuint32_t ENDIS_CTRL2:2;         /* TOM channel 2 enable/disable update value. */
      vuint32_t ENDIS_CTRL1:2;         /* TOM channel 1 enable/disable update value. */
      vuint32_t ENDIS_CTRL0:2;         /* TOM channel 0 enable/disable update value. */
    } B;
  } AGC_ENDIS_CTRL;

  union {                              /* ATOM TGC0 Enable/Disable Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_STAT7:2;         /* TOM channel 7 enable/disable. */
      vuint32_t ENDIS_STAT6:2;         /* TOM channel 6 enable/disable. */
      vuint32_t ENDIS_STAT5:2;         /* TOM channel 5 enable/disable. */
      vuint32_t ENDIS_STAT4:2;         /* TOM channel 4 enable/disable. */
      vuint32_t ENDIS_STAT3:2;         /* TOM channel 3 enable/disable. */
      vuint32_t ENDIS_STAT2:2;         /* TOM channel 2 enable/disable. */
      vuint32_t ENDIS_STAT1:2;         /* TOM channel 1 enable/disable. */
      vuint32_t ENDIS_STAT0:2;         /* TOM channel 0 enable/disable. */
    } B;
  } AGC_ENDIS_STAT;

  union {                              /* ATOM TGC0 Action Time Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TBU_SEL:2;             /* Selection of time base used for comparison. */
      vuint32_t TB_TRIG:1;             /* Set trigger request. */
      vuint32_t ACT_TB:24;             /* Specifies the signed compare value with selected signal TBU_TS[n], x=0..2. */
    } B;
  } AGC_ACT_TB;

  union {                              /* ATOM TGC0 Out Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_CTRL7:2;         /* Output TOM_OUT(7) enable/disable update value. */
      vuint32_t OUTEN_CTRL6:2;         /* Output TOM_OUT(6) enable/disable update value. */
      vuint32_t OUTEN_CTRL5:2;         /* Output TOM_OUT(5) enable/disable update value. */
      vuint32_t OUTEN_CTRL4:2;         /* Output TOM_OUT(4) enable/disable update value. */
      vuint32_t OUTEN_CTRL3:2;         /* Output TOM_OUT(3) enable/disable update value. */
      vuint32_t OUTEN_CTRL2:2;         /* Output TOM_OUT(2) enable/disable update value. */
      vuint32_t OUTEN_CTRL1:2;         /* Output TOM_OUT(1) enable/disable update value. */
      vuint32_t OUTEN_CTRL0:2;         /* Output TOM_OUT(0) enable/disable update value. */
    } B;
  } AGC_OUTEN_CTRL;

  union {                              /* ATOM TGC0 Out Enable Control/Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_STAT7:2;         /* Control/status of output TOM_OUT(7). */
      vuint32_t OUTEN_STAT6:2;         /* Control/status of output TOM_OUT(6). */
      vuint32_t OUTEN_STAT5:2;         /* Control/status of output TOM_OUT(5). */
      vuint32_t OUTEN_STAT4:2;         /* Control/status of output TOM_OUT(4) */
      vuint32_t OUTEN_STAT3:2;         /* Control/status of output TOM_OUT(3). */
      vuint32_t OUTEN_STAT2:2;         /* Control/status of output TOM_OUT(2). */
      vuint32_t OUTEN_STAT1:2;         /* Control/status of output TOM_OUT(1). */
      vuint32_t OUTEN_STAT0:2;         /* Control/status of output TOM_OUT(0). */
    } B;
  } AGC_OUTEN_STAT;

  union {                              /* ATOM TGC0 Force Update Control Register */
    vuint32_t R;
    struct {
      vuint32_t RSTCN0_CH7:2;          /* Reset CN0 of channel 7 on force update event. */
      vuint32_t RSTCN0_CH6:2;          /* Reset CN0 of channel 6 on force update event. */
      vuint32_t RSTCN0_CH5:2;          /* Reset CN0 of channel 5 on force update event. */
      vuint32_t RSTCN0_CH4:2;          /* Reset CN0 of channel 4 on force update event. */
      vuint32_t RSTCN0_CH3:2;          /* Reset CN0 of channel 3 on force update event. */
      vuint32_t RSTCN0_CH2:2;          /* Reset CN0 of channel 2 on force update event. */
      vuint32_t RSTCN0_CH1:2;          /* Reset CN0 of channel 1 on force update event. */
      vuint32_t RSTCN0_CH0:2;          /* Reset CN0 of channel 0 on force update event. */
      vuint32_t FUPD_CTRL7:2;          /* Force update of TOM channel 7 operation registers. */
      vuint32_t FUPD_CTRL6:2;          /* Force update of TOM channel 6 operation registers, */
      vuint32_t FUPD_CTRL5:2;          /* Force update of TOM channel 5 operation registers. */
      vuint32_t FUPD_CTRL4:2;          /* Force update of TOM channel 4 operation registers. */
      vuint32_t FUPD_CTRL3:2;          /* Force update of TOM channel 3 operation registers. */
      vuint32_t FUPD_CTRL2:2;          /* ce update of TOM channel 2 operation registers. */
      vuint32_t FUPD_CTRL1:2;          /* Force update of TOM channel 1 operation registers. */
      vuint32_t FUPD_CTRL0:2;          /* Force update of TOM channel 0 operation registers. */
    } B;
  } AGC_FUPD_CTRL;

  union {                              /* ATOM TGC0 Interrupt Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INT_TRIG7:2;           /* Select input signal TRIG_7 as a trigger source. */
      vuint32_t INT_TRIG6:2;           /* Select input signal TRIG_6 as a trigger source. */
      vuint32_t INT_TRIG5:2;           /* Select input signal TRIG_5 as a trigger source. */
      vuint32_t INT_TRIG4:2;           /* Select input signal TRIG_4 as a trigger source. */
      vuint32_t INT_TRIG3:2;           /* Select input signal TRIG_3 as a trigger source. */
      vuint32_t INT_TRIG2:2;           /* Select input signal TRIG_2 as a trigger source. */
      vuint32_t INT_TRIG1:2;           /* Select input signal TRIG_1 as a trigger source. */
      vuint32_t INT_TRIG0:2;           /* Select input signal TRIG_0 as a trigger source. */
    } B;
  } AGC_INT_TRIG;

  uint8_t ATOM_reserved1[32];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH1_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH1_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH1_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH1_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH1_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH1_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH1_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH1_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  uint8_t ATOM_reserved2[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH2_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH2_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH2_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH2_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH2_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH2_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH2_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH2_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  uint8_t ATOM_reserved3[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH3_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH3_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH3_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH3_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH3_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH3_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH3_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH3_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  uint8_t ATOM_reserved4[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH4_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH4_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH4_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH4_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH4_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH4_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH4_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH4_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  uint8_t ATOM_reserved5[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH5_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH5_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH5_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH5_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH5_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH5_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH5_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH5_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  uint8_t ATOM_reserved6[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH6_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH6_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH6_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH6_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH6_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH6_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH6_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH6_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  uint8_t ATOM_reserved7[80];
  union {                              /* ATOM Channel n Read Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t RDADDR1:9;             /* ARU Read address 1. */
      vuint32_t  :7;
      vuint32_t RDADDR0:9;             /* ARU Read address 0. */
    } B;
  } CH7_RDADDR;

  union {                              /* ATOM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ABM:1;                 /* ARU blocking mode. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t SLA:1;                 /* Serve last ARU communication strategy */
      vuint32_t TRIGOUT:1;             /* NTrigger output selection (output signal TRIG_CHn) of module ATOM_CHn. */
      vuint32_t  :3;                   /* Reads as zero, should be written as zero. */
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :3;
      vuint32_t WR_REQ:1;              /* CPU Write request bit for late compare register update. */
      vuint32_t  :1;
      vuint32_t CLK_SRC_SR:3;          /* Actual CMU clock source (SOMS) / shadow register for CMU clock source (SOMP). */
      vuint32_t SL:1;                  /* Initial signal level after channel enable. */
      vuint32_t  :1;
      vuint32_t CMP_CTRL:1;            /* CCUn compare strategy select.. */
      vuint32_t ACB:5;                 /* ATOM Mode control bits. */
      vuint32_t ARU_EN:1;              /* ARU Input stream enable. */
      vuint32_t TB12_SEL:1;            /* Select time base value TBU_TS1 or TBU_TS2. */
      vuint32_t MODE:2;                /* ATOM channel mode select. */
    } B;
  } CH7_CTRL;

  union {                              /* ATOM Channel n Shadow 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR0:24;                /* ATOM channel n shadow register SR0. */
    } B;
  } CH7_SR0;

  union {                              /* ATOM Channel n Shadow 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SR1:24;                /* ATOM channel n shadow register SR1. */
    } B;
  } CH7_SR1;

  union {                              /* ATOM Channel n Compare Match 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM0:24;                /* ATOM CCU0 compare register. */
    } B;
  } CH7_CM0;

  union {                              /* ATOM Channel n Compare Match 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CM1:24;                /* ATOM CCU1 compare register. */
    } B;
  } CH7_CM1;

  union {                              /* ATOM Channel n Counter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CN0:24;                /* ATOM CCU0 counter register. */
    } B;
  } CH7_CN0;

  union {                              /* ATOM Channel n Status Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACBO:5;                /* ATOM Internal status bits. */
      vuint32_t  :1;
      vuint32_t WRF:1;                 /* Write request of CPU failed for late update. */
      vuint32_t DV:1;                  /* Valid ARU Data stored in compare registers. */
      vuint32_t ACBI:5;                /* ATOM Mode control bits received through ARU. */
      vuint32_t  :15;
      vuint32_t OL:1;                  /* Actual output signal level of ATOM_CHn_OUT. */
    } B;
  } CH7_STAT;

  union {                              /* ATOM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* ATOM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t CCU1TC_IRQ_EN:1;       /* ATOM_CCU1TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* ATOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* ATOM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t TRG_CCU1TC:1;          /* Trigger ATOM_CCU1TC_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC:1;          /* Trigger ATOM_CCU0TC_IRQ interrupt by software. */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* ATOM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;
};


/* ============================================================================
   =============================== Module: GTM_BRC ============================
   ============================================================================ */

struct GTM_BRC_tag {
  struct {
    union {                            /* BRC Source n Address Register, n[0:11] */
      vuint32_t R;
      struct {
        vuint32_t  :19;
        vuint32_t BRC_MODE:1;          /* BRC Operation mode select. */
        vuint32_t  :3;
        vuint32_t ADDR:9;              /* Source ARU address. */
      } B;
    } ADDR;
    union {                            /* BRC Source n to Destination Register, n[0:11] */
      vuint32_t R;
      struct {
        vuint32_t  :9;
        vuint32_t EN_TRASHBIN:1;       /* Control trash bin functionality. */
        vuint32_t EN_DEST21:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST20:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST19:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST18:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST17:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST16:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST15:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST14:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST13:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST12:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST11:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST10:1;         /* See EN_DEST0. */
        vuint32_t EN_DEST9:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST8:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST7:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST6:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST5:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST4:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST3:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST2:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST1:1;          /* See EN_DEST0. */
        vuint32_t EN_DEST0:1;          /* Enable BRC destination address. */
      } B;
    } DEST;
  } SRC[12];

  union {                              /* BRC Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t DID0:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID1:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID2:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID3:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID4:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID5:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID6:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID7:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID8:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID9:1;                /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID10:1;               /* Data inconsistency occurred in MTM mode. */
      vuint32_t DID11:1;               /* Data inconsistency occurred in MTM mode. */
      vuint32_t DEST_ERR:1;            /* Configuration error interrupt for BRC submodule. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* BRC Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t DID_IRQ_EN0:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN1:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN2:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN3:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN4:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN5:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN6:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN7:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN8:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN9:1;         /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN10:1;        /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DID_IRQ_EN11:1;        /* BRC_DID_IRQ interrupt enable. */
      vuint32_t DEST_ERR_EN:1;         /* BRC_DEST_ERR_IRQ interrupt enable. */
    } B;
  } IRQ_EN;

  union {                              /* BRC Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t TRG_DID0:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID1:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID2:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID3:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID4:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID5:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID6:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID7:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID8:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID9:1;            /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID10:1;           /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DID11:1;           /* Trigger data inconsistency error interrupt. */
      vuint32_t TRG_DEST_ERR:1;        /* Trigger destination error interrupt. */
    } B;
  } IRQ_FORCINT;

  union {                              /* BRC Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode select */
    } B;
  } IRQ_MODE;

  union {                              /* BRC Software Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t RST:1;                 /* Software reset. */
    } B;
  } RST;

  union {                              /* BRC Error Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t DID_EIRQ_EN0:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN1:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN2:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN3:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN4:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN5:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN6:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN7:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN8:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN9:1;        /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN10:1;       /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DID_EIRQ_EN11:1;       /* BRC_DID_EIRQ error interrupt enable. */
      vuint32_t DEST_ERR_EIRQ_EN:1;    /* BRC_DEST_ERR_EIRQ error interrupt enable. */
    } B;
  } EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_CMP ============================
   ============================================================================ */

struct GTM_CMP_tag {
  union {                              /* Compare Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11_EN:1;           /* See TBWC0_EN. */
      vuint32_t TBWC10_EN:1;           /* See TBWC0_EN. */
      vuint32_t TBWC9_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC8_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC7_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC6_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC5_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC4_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC3_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC2_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC1_EN:1;            /* See TBWC0_EN. */
      vuint32_t TBWC0_EN:1;            /* Enable corresponding comparator in TBWC. */
      vuint32_t ABWC11_EN:1;           /* See ABWC0_EN. */
      vuint32_t ABWC10_EN:1;           /* See ABWC0_EN. */
      vuint32_t ABWC9_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC8_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC7_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC6_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC5_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC4_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC3_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC2_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC1_EN:1;            /* See ABWC0_EN. */
      vuint32_t ABWC0_EN:1;            /* Enable corresponding comparator in ABWC. */
    } B;
  } EN;

  union {                              /* Compare Interrupt Request Notification Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11:1;              /* See TBWC0. */
      vuint32_t TBWC10:1;              /* See TBWC0. */
      vuint32_t TBWC9:1;               /* See TBWC0. */
      vuint32_t TBWC8:1;               /* See TBWC0. */
      vuint32_t TBCW7:1;               /* See TBWC0. */
      vuint32_t TBWC6:1;               /* See TBWC0. */
      vuint32_t TBWC5:1;               /* See TBWC0. */
      vuint32_t TBWC4:1;               /* See TBWC0. */
      vuint32_t TBWC3:1;               /* See TBWC0. */
      vuint32_t TBWC2:1;               /* See TBWC0. */
      vuint32_t TBWC1:1;               /* See TBWC0. */
      vuint32_t TBWC0:1;               /* TOM sub modules outputs bitwise comparator 0 error indication. */
      vuint32_t ABWC11:1;              /* See ABWC0. */
      vuint32_t ABWC10:1;              /* See ABWC0. */
      vuint32_t ABWC9:1;               /* See ABWC0. */
      vuint32_t ABWC8:1;               /* See ABWC0. */
      vuint32_t ABWC7:1;               /* See ABWC0. */
      vuint32_t ABWC6:1;               /* See ABWC0. */
      vuint32_t ABWC5:1;               /* See ABWC0. */
      vuint32_t ABWC4:1;               /* See ABWC0. */
      vuint32_t ABWC3:1;               /* See ABWC0. */
      vuint32_t ABWC2:1;               /* See ABWC0. */
      vuint32_t ABWC1:1;               /* See ABWC0. */
      vuint32_t ABWC0:1;               /* ATOM sub modules outputs bitwise comparator error indication. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* Compare Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11_EN_IRQ:1;       /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC10_EN_IRQ:1;       /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC9_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC8_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC7_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC6_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC5_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC4_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC3_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC2_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC1_EN_IRQ:1;        /* See TBWC0_EN_IRQ. */
      vuint32_t TBWC0_EN_IRQ:1;        /* Enable corresponding TBWC interrupt source for CMP_IRQ line. */
      vuint32_t ABWC11_EN_IRQ:1;       /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC10_EN_IRQ:1;       /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC9_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC8_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC7_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC6_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC5_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC4_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC3_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC2_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC1_EN_IRQ:1;        /* See ABWC0_EN_IRQ. */
      vuint32_t ABWC0_EN_IRQ:1;        /* Enable corresponding ABWC interrupt source for CMP_IRQ line. */
    } B;
  } IRQ_EN;

  union {                              /* Compare Force Interrupt Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TRG_TBWC11:1;          /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC10:1;          /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC9:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC8:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC7:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC6:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC5:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC4:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC3:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC2:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC1:1;           /* See TRG_TBWC0. */
      vuint32_t TRG_TBWC0:1;           /* Trigger corresponding TBWC bit in CMP_IRQ_NOTIFY register by software. */
      vuint32_t TRG_ABWC11:1;          /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC10:1;          /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC9:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC8:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC7:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC6:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC5:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC4:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC3:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC2:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC1:1;           /* See TRG_ABWC0. */
      vuint32_t TRG_ABWC0:1;           /* Trigger corresponding ABWC bit in CMP_IRQ_NOTIFY register by software. */
    } B;
  } IRQ_FORCINT;

  union {                              /* Compare Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } IRQ_MODE;

  union {                              /* Compare Error Interrupt Request Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBWC11_EN_EIRQ:1;      /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC10_EN_EIRQ:1;      /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC9_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC8_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC7_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC6_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC5_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC4_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC3_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC2_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC1_EN_EIRQ:1;       /* See TBWC0_EN_EIRQ. */
      vuint32_t TBWC0_EN_EIRQ:1;       /* Enable comparator 0-11 in TBWC. */
      vuint32_t ABWC11_EN_EIRQ:1;      /* ABWC0_EN_EIRQ */
      vuint32_t ABWC10_EN_EIRQ:1;      /* ABWC0_EN_EIRQ */
      vuint32_t ABWC9_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC8_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC7_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC6_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC5_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC4_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC3_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC2_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC1_EN_EIRQ:1;       /* ABWC0_EN_EIRQ */
      vuint32_t ABWC0_EN_EIRQ:1;       /* Enable comparator 0-11 in ABWC. */
    } B;
  } EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_CMU ============================
   ============================================================================ */

struct GTM_CMU_tag {
  union {                              /* CMU Clock Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t EN_FXCLK:2;            /* Enable all CMU_FXCLK. */
      vuint32_t EN_ECLK2:2;            /* Enable ECLK 2 generation subunit. */
      vuint32_t EN_ECLK1:2;            /* Enable ECLK 1 generation subunit */
      vuint32_t EN_ECLK0:2;            /* Enable ECLK 0 generation subunit. */
      vuint32_t EN_CLK7:2;             /* Enable clock source 7. */
      vuint32_t EN_CLK6:2;             /* Enable clock source 6. */
      vuint32_t EN_CLK5:2;             /* Enable clock source 5. */
      vuint32_t EN_CLK4:2;             /* Enable clock source 4. */
      vuint32_t EN_CLK3:2;             /* Enable clock source 3 */
      vuint32_t EN_CLK2:2;             /* Enable clock source 2. */
      vuint32_t EN_CLK1:2;             /* Enable clock source 1 */
      vuint32_t EN_CLK0:2;             /* Enable clock source 0. */
    } B;
  } CLK_EN;

  union {                              /* Global Clock Control Numerator Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t GCLK_NUM:24;           /* Numerator for global clock divider. */
    } B;
  } GCLK_NUM;

  union {                              /* Global Clock Control Denominator Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t GCLK_DEN:24;           /* Denominator for global clock divider. */
    } B;
  } GCLK_DEN;

  union {                              /* Control for Clock Source n register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CLK_CNT:24;            /* Clock count. */
    } B;
  } CLK_CTRL[6];

  union {                              /* Control for Clock Source 6 register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t CLK6_SEL:1;            /* Clock source selection for CMU_CLK6. */
      vuint32_t CLK_CNT:24;            /* Clock count. */
    } B;
  } CLK_6_CTRL;

  union {                              /* Control for Clock Source 7 register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t CLK7_SEL:1;            /* Clock source selection for CMU_CLK7. */
      vuint32_t CLK_CNT:24;            /* Clock count. */
    } B;
  } CLK_7_CTRL;

  struct {
    union {                            /* CMU External Clock n Numerator Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t ECLK_NUM:24;         /* Numerator for external clock divider. */
      } B;
    } NUM;
    union {                            /* CMU External Clock n Denominator Register */
      vuint32_t R;
      struct {
        vuint32_t  :8;
        vuint32_t ECLK_DEN:24;         /* Denominator for external clock divider. */
      } B;
    } DEN;
  } ECLK[3];

  union {                              /* CMU FX Clock Control register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FXCLK_SEL:4;           /* Input clock selection for EN_FXCLK line. */
    } B;
  } FXCLK_CTRL;
};


/* ============================================================================
   =============================== Module: GTM_DPLL ===========================
   ============================================================================ */

struct GTM_DPLL_tag {
  union {                              /* Control Register 0 */
    vuint32_t R;
    struct {
      vuint32_t RMO:1;                 /* Reference mode. */
      vuint32_t TEN:1;                 /* TRIGGER enable. */
      vuint32_t SEN:1;                 /* STATE enable. */
      vuint32_t IDT:1;                 /* Input delay TRIGGER. */
      vuint32_t IDS:1;                 /* Input delay STATE. */
      vuint32_t AMT:1;                 /* Adapt mode TRIGGER */
      vuint32_t AMS:1;                 /* Addapt mode STATE. */
      vuint32_t TNU:9;                 /* TRIGGER number. */
      vuint32_t SNU:5;                 /* STATE number. */
      vuint32_t IFP:1;                 /* Input filter position. */
      vuint32_t MLT:10;                /* Multiplier for TRIGGER. */
    } B;
  } CTRL_0;

  union {                              /* Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t TSL:2;                 /* TRIGGER slope select. */
      vuint32_t SSL:2;                 /* STATE slope select. */
      vuint32_t SMC:1;                 /* Synchronous Motor Control */
      vuint32_t TS0_HRT:1;             /* Time stamp high resolution TRIGGER */
      vuint32_t TS0_HRS:1;             /* Time stamp high resolution STATE. */
      vuint32_t SYSF:1;                /* SYN_NS for FULL_SCALE. */
      vuint32_t SWR:1;                 /* Software reset */
      vuint32_t LCD:1;                 /* Locking Condition Definition. */
      vuint32_t SYN_NT:6;              /* Synchronization number of TRIGGER. */
      vuint32_t SYN_NS:5;              /* Synchronization number of STATE. */
      vuint32_t PCM2:1;                /* Pulse Correction Mode. */
      vuint32_t DLM2:1;                /* Direct Load Mode. */
      vuint32_t SGE2:1;                /* SUB_INC2 generator enable. */
      vuint32_t PCM1:1;                /* Pulse Correction Mode. */
      vuint32_t DLM1:1;                /* Direct Load Mode. */
      vuint32_t SGE1:1;                /* SUB_INC1 generator enable. */
      vuint32_t PIT:1;                 /* Plausibility. */
      vuint32_t COA:1;                 /* Correction strategy in automatic end mode (DMO=0). */
      vuint32_t IDDS:1;                /* Input Direction Detection Strategy in the case of SMC=0. */
      vuint32_t DEN:1;                 /* DPLL enable. */
      vuint32_t DMO:1;                 /* DPLL mode select. */
    } B;
  } CTRL_1;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD7:1;                /* Write control bit of Action_7. */
      vuint32_t WAD6:1;                /* Write control bit of Action_6. */
      vuint32_t WAD5:1;                /* Write control bit of Action_5. */
      vuint32_t WAD4:1;                /* Write control bit of Action_4. */
      vuint32_t WAD3:1;                /* Write control bit of Action_3. */
      vuint32_t WAD2:1;                /* Write control bit of Action_2. */
      vuint32_t WAD1:1;                /* Write control bit of Action_1. */
      vuint32_t WAD0:1;                /* Write control bit of Action_0. */
      vuint32_t AEN7:1;                /* ACTION_7 enable. */
      vuint32_t AEN6:1;                /* ACTION_6 enable. */
      vuint32_t AEN5:1;                /* ACTION_5 enable. */
      vuint32_t AEN4:1;                /* ACTION_4 enable. */
      vuint32_t AEN3:1;                /* ACTION_3 enable. */
      vuint32_t AEN2:1;                /* ACTION_2 enable. */
      vuint32_t AEN1:1;                /* ACTION_1 enable. */
      vuint32_t AEN0:1;                /* ACTION_0 enable. */
      vuint32_t  :8;                   /* Reserved. */
    } B;
  } CTRL_2;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD15:1;               /* Write control bit of Action_15. */
      vuint32_t WAD14:1;               /* Write control bit of Action_14. */
      vuint32_t WAD13:1;               /* Write control bit of Action_13. */
      vuint32_t WAD12:1;               /* Write control bit of Action_12. */
      vuint32_t WAD11:1;               /* Write control bit of Action_11. */
      vuint32_t WAD10:1;               /* Write control bit of Action_10. */
      vuint32_t WAD9:1;                /* Write control bit of Action_9. */
      vuint32_t WAD8:1;                /* Write control bit of Action_8. */
      vuint32_t AEN15:1;               /* ACTION_15 enable. */
      vuint32_t AEN14:1;               /* ACTION_14 enable. */
      vuint32_t AEN13:1;               /* ACTION_13 enable. */
      vuint32_t AEN12:1;               /* ACTION_12 enable. */
      vuint32_t AEN11:1;               /* ACTION_11 enable. */
      vuint32_t AEN10:1;               /* ACTION_10 enable. */
      vuint32_t AEN9:1;                /* ACTION_9 enable. */
      vuint32_t AEN8:1;                /* ACTION_8 enable. */
      vuint32_t  :8;
    } B;
  } CTRL_3;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD23:1;               /* Write control bit of Action_23. */
      vuint32_t WAD22:1;               /* Write control bit of Action_22. */
      vuint32_t WAD21:1;               /* Write control bit of Action_21. */
      vuint32_t WAD20:1;               /* Write control bit of Action_20. */
      vuint32_t WAD19:1;               /* Write control bit of Action_19. */
      vuint32_t WAD18:1;               /* Write control bit of Action_18. */
      vuint32_t WAD17:1;               /* Write control bit of Action_17. */
      vuint32_t WAD16:1;               /* Write control bit of Action_16. */
      vuint32_t AEN23:1;               /* ACTION_23 enable. */
      vuint32_t AEN22:1;               /* ACTION_22 enable. */
      vuint32_t AEN21:1;               /* ACTION_21 enable. */
      vuint32_t AEN20:1;               /* ACTION_20 enable. */
      vuint32_t AEN19:1;               /* ACTION_19 enable. */
      vuint32_t AEN18:1;               /* ACTION_18 enable. */
      vuint32_t AEN17:1;               /* ACTION_17 enable. */
      vuint32_t AEN16:1;               /* ACTION_16 enable. */
      vuint32_t  :8;
    } B;
  } CTRL_4;

  union {                              /* Action Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t WAD31:1;               /* Write control bit of Action_31. */
      vuint32_t WAD30:1;               /* Write control bit of Action_30. */
      vuint32_t WAD29:1;               /* Write control bit of Action_29. */
      vuint32_t WAD28:1;               /* Write control bit of Action_28. */
      vuint32_t WAD27:1;               /* Write control bit of Action_27. */
      vuint32_t WAD26:1;               /* Write control bit of Action_26. */
      vuint32_t WAD25:1;               /* Write control bit of Action_25. */
      vuint32_t WAD24:1;               /* Write control bit of Action_24. */
      vuint32_t AEN31:1;               /* ACTION_31 enable. */
      vuint32_t AEN30:1;               /* ACTION_30 enable. */
      vuint32_t AEN29:1;               /* ACTION_29 enable. */
      vuint32_t AEN28:1;               /* ACTION_28 enable. */
      vuint32_t AEN27:1;               /* ACTION_27 enable. */
      vuint32_t AEN26:1;               /* ACTION_26 enable. */
      vuint32_t AEN25:1;               /* ACTION_25 enable. */
      vuint32_t AEN24:1;               /* ACTION_24 enable. */
      vuint32_t  :8;
    } B;
  } CTRL_5;

  union {                              /* Action Status Register including Shadow Register */
    vuint32_t R;
    struct {
      vuint32_t ACT_N:32;              /* New output data values concerning to action i provided. */
    } B;
  } ACT_STA;

  union {                              /* Offset and Switch Old/New Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t OSS:2;                 /* Offset size of RAM region 2. */
      vuint32_t  :6;
      vuint32_t SWON_T:1;              /* Switch of new TRIGGER. */
      vuint32_t SWON_S:1;              /* Switch of new STATE. */
    } B;
  } OSW;

  union {                              /* Address Offset Register of RAM2 Regions */
    vuint32_t R;
    struct {
      vuint32_t AOSV_2D:8;             /* Address offset value of the RAM 2d region. */
      vuint32_t AOSV_2C:8;             /* Address offset value of the RAM 2c region. */
      vuint32_t AOSV_2B:8;             /* Address offset value of the RAM 2b region. */
      vuint32_t AOSV_2A:8;             /* Address offset value of the RAM 2a region. */
    } B;
  } AOSV_2;

  union {                              /* Actual RAM Pointer Address for Trigger */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t APT_2B:10;             /* Address pointer TRIGGER for RAM region 2b. */
      vuint32_t WAPT_2B:1;             /* Write bit for address pointer APT_2b, read as zero. */
      vuint32_t  :1;
      vuint32_t APT:10;                /* Address pointer TRIGGER. */
      vuint32_t WAPT:1;                /* Write bit for address pointer APT, reads as zero. */
      vuint32_t  :1;
    } B;
  } APT;

  union {                              /* Actual RAM Pointer Address for STATE */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t APS_1C2:6;             /* Address pointer STATE for RAM regoin 1c2. */
      vuint32_t WAPS_1C2:1;            /* Write bit for address pointer APS_1c2, reads as zero. */
      vuint32_t  :5;
      vuint32_t APS:6;                 /* Address pointer STATE. */
      vuint32_t WAPS:1;                /* Write bit for address pointer APS, reads as zero. */
      vuint32_t  :1;
    } B;
  } APS;

  union {                              /* Actual RAM Pointer Address for Region 2C */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t APT_2C:10;             /* Address pointer TRIGGER for RAM region 2c. */
      vuint32_t  :2;
    } B;
  } APT_2C;

  union {                              /* Actual RAM Pointer Address for Region 1C3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t APS_1C3:6;             /* Address pointer STATE for RAM region 1c3. */
      vuint32_t  :2;
    } B;
  } APS_1C3;

  union {                              /* Number of Recent TRIGGER Events used for Calculations */
    vuint32_t R;
    struct {
      vuint32_t WVTN:1;                /* Write control bit for VTN; reads as zero. */
      vuint32_t WSYN:1;                /* Write control bit for SYN_T and SYN_T_old; reads as zero. */
      vuint32_t WNUT:1;                /* Write control bit for NUTE and FST; reads as zero. */
      vuint32_t  :4;
      vuint32_t VTN:6;                 /* Virtual TRIGGER number. */
      vuint32_t SYN_T_old:3;           /* Number of real and virtual events to be considered for the last increment. */
      vuint32_t SYN_T:3;               /* Number of real and virtual events to be considered for the current increment. */
      vuint32_t  :2;
      vuint32_t FST:1;                 /* FULL_SCALE of TRIGGER. */
      vuint32_t NUTE:10;               /* Number of recent TRIGGER events used for SUB_INC1 and action calculations modulo 2 * (TNU max +1). */
    } B;
  } NUTC;

  union {                              /* Number of Recent STATE Events used for Calculations */
    vuint32_t R;
    struct {
      vuint32_t WVSN:1;                /* Write control bit for VSN; reads as zero. */
      vuint32_t WSYN:1;                /* Write control bit for SYN_S and SYN_S_old; reads as zero. */
      vuint32_t WNUS:1;                /* Write control bit for NUSE; reads as zero. */
      vuint32_t  :4;
      vuint32_t VSN:6;                 /* Virtual STATE number. */
      vuint32_t SYN_S_OLD:6;           /* Number of real and virtual events to be considered for the last increment. */
      vuint32_t SYN_S:6;               /* Number of real and virtual events to be considered for the current increment. */
      vuint32_t FSS:1;                 /* FULL_SCALE of STATE. */
      vuint32_t NUSE:6;                /* Number of recent STATE events used for SUB_INCx calculations modulo 2*(SNU max +1). */
    } B;
  } NUSC;

  union {                              /* Number of Active TRIGGER Events to Interrupt */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t NTI_CNT:10;            /* Number of TRIGGERs to interrupt. */
    } B;
  } NTI_CNT;

  union {                              /* Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DCGI:1;                /* Direction change interrupt. */
      vuint32_t SORI:1;                /* STATE out of range. */
      vuint32_t TORI:1;                /* TRIGGER out of range interrupt. */
      vuint32_t CDSI:1;                /* Calculation of STATE duration done. */
      vuint32_t CDTI:1;                /* Calculation of TRIGGER duration done, only while NTI_CNT is zero. */
      vuint32_t TE4I:1;                /* TRIGGER event interrupt 4. */
      vuint32_t TE3I:1;                /* TRIGGER event interrupt 3. */
      vuint32_t TE2I:1;                /* TRIGGER event interrupt 2. */
      vuint32_t TE1I:1;                /* TRIGGER event interrupt 1. */
      vuint32_t TE0I:1;                /* TRIGGER event interrupt 0. */
      vuint32_t LL2I:1;                /* Loss of lock interrupt for SUB_INC2. */
      vuint32_t GL2I:1;                /* Get of lock interrupt, for SUB_INC2. */
      vuint32_t EI:1;                  /* Error interrupt (see status register bit 31). */
      vuint32_t LL1I:1;                /* Loss of lock interrupt for SUB_INC1. */
      vuint32_t GL1I:1;                /* Get of lock interrupt, for SUB_INC1. */
      vuint32_t W1I:1;                 /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t W2I:1;                 /* RAM write access to RAM region 2 interrupt. */
      vuint32_t PWI:1;                 /* Plausibility window (PVT) violation interrupt of TRIGGER. */
      vuint32_t TASI:1;                /* TRIGGER active slope interrupt. */
      vuint32_t SASI:1;                /* STATE active slope interrupt. */
      vuint32_t MTI:1;                 /* Missing TRIGGER interrupt. */
      vuint32_t MSI:1;                 /* Missing STATE interrupt. */
      vuint32_t TISI:1;                /* TRIGGER inactive slope interrupt. */
      vuint32_t SISI:1;                /* STATE inactive slope interrupt. */
      vuint32_t TAXI:1;                /* TRIGGER maximum hold time violation interrupt (dt > THMA > 0). */
      vuint32_t TINI:1;
      vuint32_t PEI:1;                 /* DPLL enable interrupt; announces the switch on of the DEN bit. */
      vuint32_t PDI:1;                 /* DPLL disable interrupt; announces the switch off of the DEN bit. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DCGI_IRQ_EN:1;         /* Direction change interrupt. */
      vuint32_t SORI_IRQ_EN:1;         /* STATE out of range. */
      vuint32_t TORI_IRQ_EN:1;         /* TRIGGER out of range interrupt. */
      vuint32_t CDSI_IRQ_EN:1;         /* Enable interrupt when calculation of TRIGGER duration done. */
      vuint32_t CDTI_IRQ_EN:1;         /* Enable interrupt when calculation of TRIGGER duration done. */
      vuint32_t TE4I_IRQ_EN:1;         /* TRIGGER event interrupt 4 enable. */
      vuint32_t TE3I_IRQ_EN:1;         /* TRIGGER event interrupt 3 enable. */
      vuint32_t TE2I_IRQ_EN:1;         /* TRIGGER event interrupt 2 enable. */
      vuint32_t TE1I_IRQ_EN:1;         /* TRIGGER event interrupt 1 enable. */
      vuint32_t TE0I_IRQ_EN:1;         /* TRIGGER event interrupt 0 enable. */
      vuint32_t LL2I_IRQ_EN:1;         /* Loss of lock interrupt enable for SUB_INC2. */
      vuint32_t GL2I_IRQ_EN:1;         /* Get of lock interrupt enable for SUB_INC2. */
      vuint32_t EI_IRQ_EN:1;           /* Error interrupt enable (see status register). */
      vuint32_t LL1I_IRQ_EN:1;         /* Loss of lock interrupt enable. */
      vuint32_t GL1I_IRQ_EN:1;         /* Get of lock interrupt enable, when lock arises. */
      vuint32_t W1I_IRQ_EN:1;          /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t W2I_IRQ_EN:1;          /* RAM write access to RAM region 2 interrupt enable. */
      vuint32_t PWI_IRQ_EN:1;          /* Plausibility window (PVT) violation interrupt of TRIGGER enable. */
      vuint32_t TASI_IRQ_EN:1;         /* TRIGGER active slope interrupt enable. */
      vuint32_t SASI_IRQ_EN:1;         /* STATE active slope interrupt enable. */
      vuint32_t MTI_IRQ_EN:1;          /* Missing TRIGGER interrupt enable. */
      vuint32_t MSI_IRQ_EN:1;          /* Missing STATE interrupt enable. */
      vuint32_t TISI_IRQ_EN:1;         /* TRIGGER inactive slope interrupt enable bit. */
      vuint32_t SISI_IRQ_EN:1;         /* STATE inactive slope interrupt enable bit. */
      vuint32_t TAXI_IRQ_EN:1;         /* TRIGGER maximum hold time violation interrupt enable bit. */
      vuint32_t TINI_IRQ_EN:1;         /* TRIGGER minimum hold time violation interrupt enable bit. */
      vuint32_t PEI_IRQ_EN:1;          /* DPLL enable interrupt enable, when switch on of the DEN bit. */
      vuint32_t PDI_IRQ_EN:1;          /* DPLL disable interrupt enable, when switch off of the DEN bit. */
    } B;
  } IRQ_EN;

  union {                              /* Force Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t TRG_DCGI:1;            /* Force interrupt DCGI. */
      vuint32_t TRG_SORI:1;            /* Force Interrupt SORI. */
      vuint32_t TRG_TORI:1;            /* Force Interrupt TORI. */
      vuint32_t TRG_CDSI:1;            /* Force Interrupt CDSI. */
      vuint32_t TRG_CDTI:1;            /* Force Interrupt CDTI. */
      vuint32_t TRG_TE4I:1;            /* Force Interrupt TE4I. */
      vuint32_t TRG_TE3I:1;            /* Force Interrupt TE3I. */
      vuint32_t TRG_TE2I:1;            /* Force Interrupt TE2I. */
      vuint32_t TRG_TE1I:1;            /* Force Interrupt TE1I. */
      vuint32_t TRG_TE0I:1;            /* Force Interrupt TE0I. */
      vuint32_t TRG_LL2I:1;            /* Force Interrupt LL2I. */
      vuint32_t TRG_GL2I:1;            /* Force Interrupt GL2I. */
      vuint32_t TRG_EI:1;              /* Force Interrupt EI. */
      vuint32_t TRG_LL1I:1;            /* Force Interrupt LL1I. */
      vuint32_t TRG_GL1I:1;            /* Force Interrupt GL1I. */
      vuint32_t TRG_W1I:1;             /* Force Interrupt W1I. */
      vuint32_t TRG_W2I:1;             /* Force Interrupt W2I. */
      vuint32_t TRG_PWI:1;             /* Force Interrupt PWI. */
      vuint32_t TRG_TASI:1;            /* Force Interrupt TASI. */
      vuint32_t TRG_SASI:1;            /* Force Interrupt SASI. */
      vuint32_t TRG_MTI:1;
      vuint32_t TRG_MSI:1;             /* Force Interrupt MSI. */
      vuint32_t TRG_TISI:1;            /* Force Interrupt TISI. */
      vuint32_t TRG_SISI:1;            /* Force Interrupt SISI. */
      vuint32_t TRG_TAXI:1;            /* Force Interrupt TAXI. */
      vuint32_t TRG_TINI:1;            /* Force Interrupt TINI. */
      vuint32_t TRG_PEI:1;             /* Force Interrupt PEI. */
      vuint32_t TRG_PDI:1;             /* Force Interrupt PDI. */
    } B;
  } IRQ_FORCINT;

  union {                              /* Interrupt Request Mode */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } IRQ_MODE;

  union {                              /* Error Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t DCGI_EIRQ_EN:1;        /* Direction Change Interrupt. */
      vuint32_t SORI_EIRQ_EN:1;        /* STATE Out of Range Interrupt. */
      vuint32_t TORI_EIRQ_EN:1;        /* TRIGGER Out of Range Interrupt */
      vuint32_t CDSI_EIRQ_EN:1;        /* Enable interrupt when calculation of STATE duration done. */
      vuint32_t CDTI_EIRQ_EN:1;        /* Enable interrupt when calculation of TRIGGER duration done */
      vuint32_t TE4I_EIRQ_EN:1;        /* TRIGGER event interrupt 4 enable. */
      vuint32_t TE3I_EIRQ_EN:1;        /* TRIGGER event interrupt 3 enable. */
      vuint32_t TE2I_EIRQ_EN:1;        /* TRIGGER event interrupt 2 enable. */
      vuint32_t TE1I_EIRQ_EN:1;        /* TRIGGER event interrupt 1 enable. */
      vuint32_t TE0I_EIRQ_EN:1;        /* TRIGGER event interrupt 0 enable. */
      vuint32_t LL2I_EIRQ_EN:1;        /* Loss of lock interrupt enable for SUB_INC2. */
      vuint32_t GL2I_EIRQ_EN:1;        /* Get of lock interrupt enable for SUB_INC2. */
      vuint32_t EI_EIRQ_EN:1;          /* Error interrupt enable (see status register). */
      vuint32_t LL1I_EIRQ_EN:1;        /* Loss of lock interrupt enable. */
      vuint32_t GL1I_EIRQ_EN:1;        /* Get of lock interrupt enable, when lock arises. */
      vuint32_t W1I_EIRQ_EN:1;         /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t W2I_EIRQ_EN:1;         /* RAM write access to RAM region 2 interrupt enable. */
      vuint32_t PWI_EIRQ_EN:1;         /* Plausibility window (PVT) violation interrupt of TRIGGER enable. */
      vuint32_t TASI_EIRQ_EN:1;        /* TRIGGER active slope interrupt enable. */
      vuint32_t SASI_EIRQ_EN:1;        /* STATE active slope interrupt enable. */
      vuint32_t MTI_EIRQ_EN:1;         /* Missing TRIGGER interrupt enable. */
      vuint32_t MSI_EIRQ_EN:1;         /* Missing STATE interrupt enable. */
      vuint32_t TISI_EIRQ_EN:1;        /* TRIGGER inactive slope interrupt enable bit. */
      vuint32_t SISI_EIRQ_EN:1;        /* STATE inactive slope interrupt enable bit. */
      vuint32_t TAXI_EIRQ_EN:1;        /* TRIGGER maximum hold time violation interrupt enable bit. */
      vuint32_t TINI_EIRQ_EN:1;        /* TRIGGER minimum hold time violation interrupt enable bit. */
      vuint32_t PEI_EIRQ_EN:1;         /* DPLL enable interrupt enable, when switch on of the DEN bit. */
      vuint32_t PDI_EIRQ_EN:1;         /* DPLL disable interrupt enable, when switch off of the DEN bit. */
    } B;
  } EIRQ_EN;

  uint8_t DPLL_reserved0[92];
  union {                              /* Counter Value of Sent SUB_INC1 Pulses */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t INC_CNT1:24;           /* Actual number of pulses to be still sent out at the current increment until the next valid input signal in automatic end mode. */
    } B;
  } INC_CNT1;

  union {                              /* Counter Value of sent SUB_INC2 values (for SMC=1 and RMO=1) */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t INC_CNT2:24;           /* Actual number of pulses to be still sent out at the current increment until the next valid input signal in automatic end mode. */
    } B;
  } INC_CNT2;

  union {                              /* TRIGGER Time Stamp Field Offset at Synchronization Time */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t APT_2B_OLD:10;         /* Address pointer TRIGGER for RAM region 2B at synchronization time. */
      vuint32_t  :7;
      vuint32_t APT_2B_STATUS:1;       /* Address pointer 2B status. */
      vuint32_t APT_2B_EXT:6;          /* Address pointer 2B extension. */
    } B;
  } APT_SYNC;

  union {                              /* STATE Time Stamp Field Offset at Synchronization Time */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t APS_1C2_OLD:6;         /* Address pointer STATE for RAM regoin 1C2 at synchronization time. */
      vuint32_t  :7;
      vuint32_t APS_1C2_STATUS:1;      /* Address pointer 1C2 status. */
      vuint32_t APS_1C2_EXT:6;         /* Address pointer 1C2 extension. */
    } B;
  } APS_SYNC;

  union {                              /* Time Stamp Value for the last valid TRIGGER */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBU_TS0_T:24;          /* Value of TBU_TS0 at the last TRIGGER event. */
    } B;
  } TBU_TS0_T;

  union {                              /* Time Stamp Value for the last valid STATE */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TBU_TS0_S:24;          /* Value of TBU_TS0 at the last STATE event. */
    } B;
  } TBU_TS0_S;

  union {                              /* ADD_IN Value in Direct Load Mode for TRIGGER */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t ADD_IN_LD1:24;         /* Input value for SUB_INC1 generation. */
    } B;
  } ADD_IN_LD1;

  union {                              /* ADD_IN Value in Direct Load Mode for STATE */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t ADD_IN_LD2:24;         /* Input value for SUB_INC2 generation. */
    } B;
  } ADD_IN_LD2;

  uint8_t DPLL_reserved1[44];
  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t ERR:1;                 /* Error. */
      vuint32_t LOCK1:1;               /* DPLL Lock status concerning SUB_INC1. */
      vuint32_t FTD:1;                 /* First TRIGGER detected. */
      vuint32_t FSD:1;                 /* First STATE detected. */
      vuint32_t SYT:1;                 /* Synchronization condition of TRIGGER fixed. */
      vuint32_t SYS:1;                 /* Synchronization condition of STATE fixed. */
      vuint32_t LOCK2:1;               /* DPLL Lock status concerning SUB_INC2. */
      vuint32_t  :1;
      vuint32_t BWD1:1;                /* Backwards drive of SUB_INC1. */
      vuint32_t BWD2:1;                /* Backwards drive of SUB_INC2. */
      vuint32_t ITN:1;                 /* Increment number of TRIGGER is not plausible. */
      vuint32_t ISN:1;                 /* Increment number of STATE is not plausible. */
      vuint32_t CAIP1:1;               /* Calculation of actions 0 to 11 in progress (1st part). */
      vuint32_t CAIP2:1;               /* Calculation of actions 12 to 23 in progress (2nd part). */
      vuint32_t CSVT:1;                /* Current signal value TRIGGER. */
      vuint32_t CSVS:1;                /* Current signal value STATE. */
      vuint32_t LOW_RES:1;             /* Low resolution of TBU_TS0. */
      vuint32_t  :2;
      vuint32_t RAM2_ERR:1;            /* DPLL internal access to not configured RAM2 memory space. */
      vuint32_t MT:1;                  /* Missing TRIGGER detected according to TOV. */
      vuint32_t TOR:1;                 /* TRIGGER out of range. */
      vuint32_t MS:1;                  /* Missing STATE detected according to TOV_S. */
      vuint32_t SOR:1;                 /* STATE out of range. */
      vuint32_t PSE:1;                 /* Prediction space configuration error. */
      vuint32_t RCT:1;                 /* Resolution conflict TRIGGER. */
      vuint32_t RCS:1;                 /* Resolution conflict STATE. */
      vuint32_t CRO:1;                 /* Calculated Reciprocal value overflow. */
      vuint32_t CTO:1;                 /* Calculated TRIGGER duration overflow. */
      vuint32_t  :1;
      vuint32_t CSO:1;                 /* Calculated STATE duration overflow. */
      vuint32_t  :1;
    } B;
  } STATUS;

  union {                              /* ID Information for In ut Signal PTR x (Position minus Time Request) */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ID_PMTR_n:9;           /* ID information to the input signal PMTR_n from the ARU. */
    } B;
  } ID_PMTR[32];

  uint8_t DPLL_reserved2[96];
  union {                              /* Shadow Register of DPLL_CTRL_0 controlled by a valid TRIGGER Slope */
    vuint32_t R;
    struct {
      vuint32_t RMO:1;                 /* Reference mode. */
      vuint32_t  :3;
      vuint32_t IDT:1;                 /* Input delay TRIGGER; */
      vuint32_t  :1;
      vuint32_t AMT:1;                 /* Adapt mode TRIGGER */
      vuint32_t  :14;
      vuint32_t IFP:1;                 /* Input filter position. */
      vuint32_t MLT:10;                /* Multiplier for TRIGGER. */
    } B;
  } CTRL_0_SHADOW_TRIGGER;

  union {                              /* Shadow Register of DPLL_CTRL_0 controlled by a valid STATE Slope */
    vuint32_t R;
    struct {
      vuint32_t RMO:1;                 /* Reference mode. */
      vuint32_t  :3;
      vuint32_t IDS:1;                 /* Input delay STATE. */
      vuint32_t  :1;
      vuint32_t AMS:1;                 /* Addapt mode STATE. */
      vuint32_t  :14;
      vuint32_t IFP:1;                 /* Input filter position. */
      vuint32_t  :10;
    } B;
  } CTRL_0_SHADOW_STATE;

  union {                              /* Shadow Register of DPLL_CTRL_1 controlled by a valid TRIGGER Slope */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t PCM1:1;                /* Pulse Correction Mode. */
      vuint32_t DLM1:1;                /* Direct Load Mode. */
      vuint32_t SGE1:1;                /* SUB_INC1 generator enable. */
      vuint32_t PIT:1;                 /* Plausibility. */
      vuint32_t COA:1;                 /* Correction strategy in automatic end mode (DMO=0). */
      vuint32_t  :2;
      vuint32_t DMO:1;                 /* DPLL mode select.. */
    } B;
  } CTRL_1_SHADOW_TRIGGER;

  union {                              /* Shadow Register of DPLL_CTRL_1 controlled by a valid STATE Slope */
    vuint32_t R;
    struct {
      vuint32_t SYN_NS:21;             /* Synchronization number of STATE. */
      vuint32_t PCM2:1;                /* Pulse Correction Mode for SUB_INC2 generation. */
      vuint32_t DLM2:1;                /* Direct Load Mode for SUB_INC2 generation. */
      vuint32_t SGE2:1;                /* SUB_INC2 generator enable. */
      vuint32_t PCM1:1;                /* Pulse Correction Mode for SUB_INC1 generation. */
      vuint32_t DLM1:1;                /* Direct Load Mode for SUB_INC1 generation. */
      vuint32_t SGE1:1;                /* SUB_INC1 generator enable. */
      vuint32_t PIT:1;                 /* Plausibility value PVT to next valid TRIGGER is time related. */
      vuint32_t COA:1;                 /* Correction strategy in automatic end mode (DMO=0). */
      vuint32_t  :1;
      vuint32_t DEN:1;                 /* DPLL enable. */
      vuint32_t DMO:1;                 /* DPLL mode select. */
    } B;
  } CTRL_1_SHADOW_STATE;

  uint8_t DPLL_reserved3[12];
  union {                              /* Register to control the RAM Initialization */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t INIT_RAM:1;            /* RAM regions 1A, 1B and 2 are to be initialized. */
      vuint32_t  :1;
      vuint32_t INIT_2:1;              /* RAM region 2 initialization in progress. */
      vuint32_t INIT_1B:1;             /* RAM region 1B initialization in progress. */
      vuint32_t INIT_1A:1;             /* RAM region 1A initialization in progress. */
    } B;
  } RAM_INI;

  uint8_t DPLL_reserved4[3072];
  union {                              /* Calculated Time Value to start Action i */
    vuint32_t R;
    struct {
      vuint32_t TSAC:32;               /* Calculated time stamp for ACTION_i. */
    } B;
  } TSAC[32];

  union {                              /* DPLL Calculated Position Value ACTION i */
    vuint32_t R;
    struct {
      vuint32_t PSAC:32;               /* Calculated position value for the start of ACTION_i . */
    } B;
  } PSAC[32];

  union {                              /* Control Bits for up to 32 Actions */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ACB_3:5;               /* Action Control Bits of ACTION_(i + 3), reflects ACT_D[i+3](52:48), i=4*j. */
      vuint32_t  :3;
      vuint32_t ACB_2:5;               /* Action Control Bits of ACTION_(i + 2), reflects ACT_D[i+2](52:48), i=4*j. */
      vuint32_t  :3;
      vuint32_t ACB_1:5;               /* Action Control Bits of ACTION_(i + 1) , reflects ACT_D[i+1](52:48), i=4*j. */
      vuint32_t  :3;
      vuint32_t ACB_0:5;               /* Control Bits of ACTION_i, reflects ACT_D[i](52:48), i=4*j. */
    } B;
  } ACB[8];
};


/* ============================================================================
   =============================== Module: GTM_F2A ============================
   ============================================================================ */

struct GTM_F2A_tag {
  union {                              /* F2A Read Channel n Address Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t ADDR:9;                /* ARU Read address. */
    } B;
  } CH_ARU_RD_FIFO[8];

  union {                              /* F2A Channel n Stream Configuration Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t DIR:1;                 /* Data transfer direction. */
      vuint32_t TMODE:2;               /* Transfer mode for 53 bit ARU data from/to FIFO. */
      vuint32_t  :16;
    } B;
  } CH_STR_CFG[8];

  union {                              /* F2A Stream Activation Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t STR7_EN:2;             /* Enable/disable stream 7. */
      vuint32_t STR6_EN:2;             /* Enable/disable stream 6. */
      vuint32_t STR5_EN:2;             /* Enable/disable stream 5. */
      vuint32_t STR4_EN:2;             /* Enable/disable stream 4. */
      vuint32_t STR3_EN:2;             /* Enable/disable stream 3. */
      vuint32_t STR2_EN:2;             /* Enable/disable stream 2. */
      vuint32_t STR1_EN:2;             /* Enable/disable stream 1. */
      vuint32_t STR0_EN:2;             /* STR0_EN */
    } B;
  } ENABLE;
};


/* ============================================================================
   =============================== Module: GTM_FIFO ===========================
   ============================================================================ */

struct GTM_FIFO_tag {
  struct {
    union {                            /* FIFO Channel Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t WULOCK:1;            /* RAM write unlock. */
        vuint32_t FLUSH:1;             /* FIFO Flush control. */
        vuint32_t RAP:1;               /* RAM access priority. */
        vuint32_t RBM:1;               /* Ring buffer mode enable. */
      } B;
    } CTRL;
    union {                            /* FIFO Channel End Address Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* End address for FIFO channel n. */
      } B;
    } END_ADDR;
    union {                            /* FIFO Channel Start Address Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Start address for FIFO channel n. */
      } B;
    } START_ADDR;
    union {                            /* FIFO Channel Upper Watermark Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Upper watermark. */
      } B;
    } UPPER_WM;
    union {                            /* FIFO Channel Lower Watermark Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Normal Operation mode: Lower watermark. Ring buffer operation mode: Gate pointer from LWU to UWE. */
      } B;
    } LOWER_WM;
    union {                            /* FIFO Channel Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t UP_WM:1;             /* Upper watermark reached. */
        vuint32_t LOW_WM:1;            /* Lower watermark reached. */
        vuint32_t FULL:1;              /* FIFO fill level status. */
        vuint32_t EMPTY:1;             /* FIFO fill level status. */
      } B;
    } STATUS;
    union {                            /* FIFO Channel Fill Level Register */
      vuint32_t R;
      struct {
        vuint32_t  :21;                /* Reserved. */
        vuint32_t LEVEL:11;            /* Fill level of the current FIFO. */
      } B;
    } FILL_LEVEL;
    union {                            /* FIFO Channel Write Pointer Register */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Position of the write pointer. */
      } B;
    } WR_PTR;
    union {                            /* FIFO Channel Read Pointer */
      vuint32_t R;
      struct {
        vuint32_t  :22;                /* Reserved. */
        vuint32_t ADDR:10;             /* Position of the read pointer. */
      } B;
    } RD_PTR;
    union {                            /* FIFO Channel IRQ Notification Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t FIFO_UWM:1;          /* FIFO Upper watermark was over-run. */
        vuint32_t FIFO_LWM:1;          /* FIFO Lower watermark was under-run. */
        vuint32_t FIFO_FULL:1;         /* FIFO is full. */
        vuint32_t FIFO_EMPTY:1;        /* FIFO is empty. */
      } B;
    } IRQ_NOTIFY;
    union {                            /* FIFO Channel IRQ Enable Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t FIFO_UWM_IRQ_EN:1;   /* FIFO Upper Water Mark Interrupt Enable. */
        vuint32_t FIFO_LWM_IRQ_EN:1;   /* FIFO Lower Watermark Interrupt Enable. */
        vuint32_t FIFO_FULL_IRQ_EN:1;  /* FIFO Full Interrupt Enable. */
        vuint32_t FIFO_EMPTY_IRQ_EN:1; /* FIFO Empty Interrupt Enable. */
      } B;
    } IRQ_EN;
    union {                            /* FIFO Channel Force Interrupt Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t TRG_FIFO_UWM:1;      /* Force interrupt of upper watermark. */
        vuint32_t TRG_FIFO_LWM:1;      /* Force interrupt of lower watermark. */
        vuint32_t TRG_FIFO_FULL:1;     /* Force interrupt of FIFO full status. */
        vuint32_t TRG_FIFO_EMPTY:1;    /* Force interrupt of FIFO empty status. */
      } B;
    } IRQ_FORCINT;
    union {                            /* FIFO Channel IRQ Mode Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;                /* Reserved. */
        vuint32_t DMA_HYST_DIR:1;      /* DMA direction in hysteresis mode. */
        vuint32_t DMA_HYSTERESIS:1;    /* Enable DMA hysteresis mode. */
        vuint32_t IRQ_MODE:2;          /* IRQ mode select. */
      } B;
    } IRQ_MODE;
    union {                            /* FIFO Channel Error Interrupt Request Register */
      vuint32_t R;
      struct {
        vuint32_t  :28;
        vuint32_t FIFO_UWM_EIRQ_EN:1;  /* FIFO Upper Water Mark Error Interrupt Request Enable. */
        vuint32_t FIFO_LWM_EIRQ_EN:1;  /* FIFO Lower Water Mark Error Interrupt Request Enable. */
        vuint32_t FIFO_FULL_EIRQ_EN:1; /* FIFO Full Error Interrupt Request Enable. */
        vuint32_t FIFO_EMPTY_EIRQ_EN:1; /* FIFO Empty Error Interrupt Request Enable. */
      } B;
    } EIRQ_EN;
    uint8_t CHANNEL_reserved0[8];
  } CHANNEL[8];
};


/* ============================================================================
   =============================== Module: GTM_ICM ============================
   ============================================================================ */

struct GTM_ICM_tag {
  union {                              /* GTM Infrastructure Interrupt Group Register */
    vuint32_t R;
    struct {
      vuint32_t PSM1_CH7_IRQ:1;        /* PSM1 shared submodule channel 7 interrupt. */
      vuint32_t PSM1_CH6_IRQ:1;        /* PSM1 shared submodule channel 6 interrupt. */
      vuint32_t PSM1_CH5_IRQ:1;        /* PSM1 shared submodule channel 5 interrupt. */
      vuint32_t PSM1_CH4_IRQ:1;        /* PSM1 shared submodule channel 4 interrupt. */
      vuint32_t PSM1_CH3_IRQ:1;        /* PSM1 shared submodule channel 3 interrupt. */
      vuint32_t PSM1_CH2_IRQ:1;        /* PSM1 shared submodule channel 2 interrupt. */
      vuint32_t PSM1_CH1_IRQ:1;        /* PSM1 shared submodule channel 1 interrupt. */
      vuint32_t PSM1_CH0_IRQ:1;        /* PSM1 shared submodule channel 0 interrupt. */
      vuint32_t PSM0_CH7_IRQ:1;        /* PSM0 shared submodule channel 7 interrupt. */
      vuint32_t PSM0_CH6_IRQ:1;        /* PSM0 shared submodule channel 6 interrupt. */
      vuint32_t PSM0_CH5_IRQ:1;        /* PSM0 shared submodule channel 5 interrupt. */
      vuint32_t PSM0_CH4_IRQ:1;        /* PSM0 shared submodule channel 4 interrupt. */
      vuint32_t PSM0_CH3_IRQ:1;        /* PSM0 shared submodule channel 3 interrupt. */
      vuint32_t PSM0_CH2_IRQ:1;        /* PSM0 shared submodule channel 2 interrupt. */
      vuint32_t PSM0_CH1_IRQ:1;        /* PSM0 shared submodule channel 1 interrupt. */
      vuint32_t PSM0_CH0_IRQ:1;        /* PSM0 shared submodule channel 0 interrupt. */
      vuint32_t  :6;
      vuint32_t SPE3_IRQ:1;            /* SPE3 shared submodule interrupt. */
      vuint32_t SPE2_IRQ:1;            /* SPE2 shared submodule interrupt. */
      vuint32_t SPE1_IRQ:1;            /* SPE1 shared submodule interrupt. */
      vuint32_t SPE0_IRQ:1;            /* SPE0 shared submodule interrupt. */
      vuint32_t CMP_IRQ:1;             /* CMP shared submodule interrupt. */
      vuint32_t AEI_IRQ:1;             /* AEI_IRQ interrupt. */
      vuint32_t BRC_IRQ:1;             /* BRC shared submodule interrupt. */
      vuint32_t ARU_ACC_ACK_IRQ:1;     /* ARU_ACC_ACK interrupt. */
      vuint32_t ARU_NEW_DATA1_IRQ:1;   /* ARU_NEW_DATA1 interrupt. */
      vuint32_t ARU_NEW_DATA0_IRQ:1;   /* ARU_NEW_DATA0 interrupt. */
    } B;
  } IRQG_0;

  union {                              /* DPLL Interrupt Group Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t DPLL_SORI_IRQ:1;       /* DPLL calculated duration interrupt for STATE. */
      vuint32_t DPLL_TORI_IRQ:1;       /* DPLL calculated duration interrupt for TRIGGER. */
      vuint32_t DPLL_CDSI_IRQ:1;       /* DPLL calculated duration interrupt for STATE. */
      vuint32_t DPLL_CDTI_IRQ:1;       /* DPLL calculated duration interrupt for TRIGGER. */
      vuint32_t DPLL_TE4I_IRQ:1;       /* TRIGGER event interrupt 4. */
      vuint32_t DPLL_TE3I_IRQ:1;       /* TRIGGER event interrupt 3. */
      vuint32_t DPLL_TE2I_IRQ:1;       /* TRIGGER event interrupt 2. */
      vuint32_t DPLL_TE1I_IRQ:1;       /* TRIGGER event interrupt 1. */
      vuint32_t DPLL_TE0I_IRQ:1;       /* TRIGGER event interrupt 0. */
      vuint32_t DPLL_LL2I_IRQ:1;       /* Lost of lock interrupt for SUB_INC2. */
      vuint32_t DPLL_GL2I_IRQ:1;       /* Get of lock interrupt for SUB_INC2. */
      vuint32_t DPLL_EI_IRQ:1;         /* Error interrupt. */
      vuint32_t DPLL_LLI_IRQ:1;        /* Lost of lock interrupt for SUB_INC1. */
      vuint32_t DPLL_GLI_IRQ:1;        /* Get of lock interrupt for SUB_INC1. */
      vuint32_t DPLL_W1I_IRQ:1;        /* Write access to RAM region 1b or 1c interrupt. */
      vuint32_t DPLL_W2I_IRQ:1;        /* Write access to RAM region 2 interrupt. */
      vuint32_t DPLL_PWI_IRQ:1;        /* Plausibility window (PVT) violation interrupt of TRIGGER. */
      vuint32_t DPLL_TASI_IRQ:1;       /* TRIGGER active slope detected while NTI_CNT is zero. */
      vuint32_t DPLL_SASI_IRQ:1;       /* STATE active slope detected. */
      vuint32_t DPLL_MTI_IRQ:1;        /* Missing TRIGGER interrupt. */
      vuint32_t DPLL_MSI_IRQ:1;        /* Missing STATE interrupt. */
      vuint32_t DPLL_TISI_IRQ:1;       /* TRIGGER inactive slope detected interrupt. */
      vuint32_t DPLL_SISI_IRQ:1;       /* STATE inactive slope detected interrupt. */
      vuint32_t DPLL_TAXI_IRQ:1;       /* TRIGGER maximum hold time (THMA) violation detected interrupt. */
      vuint32_t DPLL_TINI_IRQ:1;       /* TRIGGER minimum hold time (THMI) violation detected interrupt. */
      vuint32_t DPLL_EDI_IRQ:1;        /* DPLL enable/disable interrupt. */
      vuint32_t DPLL_DCGI_IRQ:1;       /* TRIGGER direction change detected. */
    } B;
  } IRQG_1;

  union {                              /* TIM Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t TIM3_CH7_IRQ:1;        /* TIM3 shared interrupt channel 7. */
      vuint32_t TIM3_CH6_IRQ:1;        /* TIM3 shared interrupt channel 6. */
      vuint32_t TIM3_CH5_IRQ:1;        /* TIM3 shared interrupt channel 5. */
      vuint32_t TIM3_CH4_IRQ:1;        /* TIM3 shared interrupt channel 4. */
      vuint32_t TIM3_CH3_IRQ:1;        /* TIM3 shared interrupt channel 3. */
      vuint32_t TIM3_CH2_IRQ:1;        /* TIM3 shared interrupt channel 2. */
      vuint32_t TIM3_CH1_IRQ:1;        /* TIM3 shared interrupt channel 1. */
      vuint32_t TIM3_CH0_IRQ:1;        /* TIM3 shared interrupt channel 0. */
      vuint32_t TIM2_CH7_IRQ:1;        /* TIM2 shared interrupt channel 7. */
      vuint32_t TIM2_CH6_IRQ:1;        /* TIM2 shared interrupt channel 6. */
      vuint32_t TIM2_CH5_IRQ:1;        /* TIM2 shared interrupt channel 5. */
      vuint32_t TIM2_CH4_IRQ:1;        /* TIM2 shared interrupt channel 4. */
      vuint32_t TIM2_CH3_IRQ:1;        /* TIM2 shared interrupt channel 3. */
      vuint32_t TIM2_CH2_IRQ:1;        /* TIM2 shared interrupt channel 2. */
      vuint32_t TIM2_CH1_IRQ:1;        /* TIM2 shared interrupt channel 1. */
      vuint32_t TIM2_CH0_IRQ:1;        /* TIM2 shared interrupt channel 0. */
      vuint32_t TIM1_CH7_IRQ:1;        /* TIM1 shared interrupt channel 7. */
      vuint32_t TIM1_CH6_IRQ:1;        /* TIM1 shared interrupt channel 6. */
      vuint32_t TIM1_CH5_IRQ:1;        /* TIM1 shared interrupt channel 5. */
      vuint32_t TIM1_CH4_IRQ:1;        /* TIM1 shared interrupt channel 4. */
      vuint32_t TIM1_CH3_IRQ:1;        /* TIM1 shared interrupt channel 3. */
      vuint32_t TIM1_CH2_IRQ:1;        /* TIM1 shared interrupt channel 2. */
      vuint32_t TIM1_CH1_IRQ:1;        /* TIM1 shared interrupt channel 1. */
      vuint32_t TIM1_CH0_IRQ:1;        /* TIM1 shared interrupt channel 0. */
      vuint32_t TIM0_CH7_IRQ:1;        /* TIM0 shared interrupt channel 7. */
      vuint32_t TIM0_CH6_IRQ:1;        /* TIM0 shared interrupt channel 6. */
      vuint32_t TIM0_CH5_IRQ:1;        /* TIM0 shared interrupt channel 5. */
      vuint32_t TIM0_CH4_IRQ:1;        /* TIM0 shared interrupt channel 4. */
      vuint32_t TIM0_CH3_IRQ:1;        /* TIM0 shared interrupt channel 3. */
      vuint32_t TIM0_CH2_IRQ:1;        /* TIM0 shared interrupt channel 2. */
      vuint32_t TIM0_CH1_IRQ:1;        /* TIM0 shared interrupt channel 1. */
      vuint32_t TIM0_CH0_IRQ:1;        /* TIM0 shared interrupt channel 0. */
    } B;
  } IRQG_2;

  union {                              /* TIM Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TIM6_CH7_IRQ:1;        /* TIM6 shared interrupt channel 7. */
      vuint32_t TIM6_CH6_IRQ:1;        /* TIM6 shared interrupt channel 6. */
      vuint32_t TIM6_CH5_IRQ:1;        /* TIM6 shared interrupt channel 5. */
      vuint32_t TIM6_CH4_IRQ:1;        /* TIM6 shared interrupt channel 4. */
      vuint32_t TIM6_CH3_IRQ:1;        /* TIM6 shared interrupt channel 3. */
      vuint32_t TIM6_CH2_IRQ:1;        /* TIM6 shared interrupt channel 2. */
      vuint32_t TIM6_CH1_IRQ:1;        /* TIM6 shared interrupt channel 1. */
      vuint32_t TIM6_CH0_IRQ:1;        /* TIM6 shared interrupt channel 0. */
      vuint32_t TIM5_CH7_IRQ:1;        /* TIM5 shared interrupt channel 7. */
      vuint32_t TIM5_CH6_IRQ:1;        /* TIM5 shared interrupt channel 6. */
      vuint32_t TIM5_CH5_IRQ:1;        /* TIM5 shared interrupt channel 5. */
      vuint32_t TIM5_CH4_IRQ:1;        /* TIM5 shared interrupt channel 4. */
      vuint32_t TIM5_CH3_IRQ:1;        /* TIM5 shared interrupt channel 3. */
      vuint32_t TIM5_CH2_IRQ:1;        /* TIM5 shared interrupt channel 2. */
      vuint32_t TIM5_CH1_IRQ:1;        /* TIM5 shared interrupt channel 1. */
      vuint32_t TIM5_CH0_IRQ:1;        /* TIM5 shared interrupt channel 0. */
      vuint32_t TIM4_CH7_IRQ:1;        /* TIM4 shared interrupt channel 7. */
      vuint32_t TIM4_CH6_IRQ:1;        /* TIM4 shared interrupt channel 6. */
      vuint32_t TIM4_CH5_IRQ:1;        /* TIM4 shared interrupt channel 5. */
      vuint32_t TIM4_CH4_IRQ:1;        /* TIM4 shared interrupt channel 4. */
      vuint32_t TIM4_CH3_IRQ:1;        /* TIM4 shared interrupt channel 3. */
      vuint32_t TIM4_CH2_IRQ:1;        /* TIM4 shared interrupt channel 2. */
      vuint32_t TIM4_CH1_IRQ:1;        /* TIM4 shared interrupt channel 1. */
      vuint32_t TIM4_CH0_IRQ:1;        /* TIM4 shared interrupt channel 0. */
    } B;
  } IRQG_3;

  union {                              /* MCS Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t MCS3_CH7_IRQ:1;        /* MCS3 channel 7 interrupt. */
      vuint32_t MCS3_CH6_IRQ:1;        /* MCS3 channel 6 interrupt. */
      vuint32_t MCS3_CH5_IRQ:1;        /* MCS3 channel 5 interrupt. */
      vuint32_t MCS3_CH4_IRQ:1;        /* MCS3 channel 4 interrupt. */
      vuint32_t MCS3_CH3_IRQ:1;        /* MCS3 channel 3 interrupt. */
      vuint32_t MCS3_CH2_IRQ:1;        /* MCS3 channel 2 interrupt. */
      vuint32_t MCS3_CH1_IRQ:1;        /* MCS3 channel 1 interrupt. */
      vuint32_t MCS3_CH0_IRQ:1;        /* MCS3 channel 0 interrupt. */
      vuint32_t MCS2_CH7_IRQ:1;        /* MCS2 channel 7 interrupt. */
      vuint32_t MCS2_CH6_IRQ:1;        /* MCS2 channel 6 interrupt. */
      vuint32_t MCS2_CH5_IRQ:1;        /* MCS2 channel 5 interrupt. */
      vuint32_t MCS2_CH4_IRQ:1;        /* MCS2 channel 4 interrupt. */
      vuint32_t MCS2_CH3_IRQ:1;        /* MCS2 channel 3 interrupt. */
      vuint32_t MCS2_CH2_IRQ:1;        /* MCS2 channel 2 interrupt. */
      vuint32_t MCS2_CH1_IRQ:1;        /* MCS2 channel 1 interrupt. */
      vuint32_t MCS2_CH0_IRQ:1;        /* MCS2 channel 0 interrupt. */
      vuint32_t MCS1_CH7_IRQ:1;        /* MCS1 channel 7 interrupt. */
      vuint32_t MCS1_CH6_IRQ:1;        /* MCS1 channel 6 interrupt. */
      vuint32_t MCS1_CH5_IRQ:1;        /* MCS1 channel 5 interrupt. */
      vuint32_t MCS1_CH4_IRQ:1;        /* MCS1 channel 4 interrupt. */
      vuint32_t MCS1_CH3_IRQ:1;        /* MCS1 channel 3 interrupt. */
      vuint32_t MCS1_CH2_IRQ:1;        /* MCS1 channel 2 interrupt. */
      vuint32_t MCS1_CH1_IRQ:1;        /* MCS1 channel 1 interrupt. */
      vuint32_t MCS1_CH0_IRQ:1;        /* MCS1 channel 0 interrupt. */
      vuint32_t MCS0_CH7_IRQ:1;        /* MCS0 channel 7 interrupt. */
      vuint32_t MCS0_CH6_IRQ:1;        /* MCS0 channel 6 interrupt. */
      vuint32_t MCS0_CH5_IRQ:1;        /* MCS0 channel 5 interrupt. */
      vuint32_t MCS0_CH4_IRQ:1;        /* MCS0 channel 4 interrupt. */
      vuint32_t MCS0_CH3_IRQ:1;        /* MCS0 channel 3 interrupt. */
      vuint32_t MCS0_CH2_IRQ:1;        /* MCS0 channel 2 interrupt. */
      vuint32_t MCS0_CH1_IRQ:1;        /* MCS0 channel 1 interrupt. */
      vuint32_t MCS0_CH0_IRQ:1;        /* MCS0 channel 0 interrupt. */
    } B;
  } IRQG_4;

  union {                              /* MCS Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t MCS6_CH7_IRQ:1;        /* MCS6 channel 7 interrupt. */
      vuint32_t MCS6_CH6_IRQ:1;        /* MCS6 channel 6 interrupt. */
      vuint32_t MCS6_CH5_IRQ:1;        /* MCS6 channel 5 interrupt. */
      vuint32_t MCS6_CH4_IRQ:1;        /* MCS6 channel 4 interrupt. */
      vuint32_t MCS6_CH3_IRQ:1;        /* MCS6 channel 3 interrupt. */
      vuint32_t MCS6_CH2_IRQ:1;        /* MCS6 channel 2 interrupt. */
      vuint32_t MCS6_CH1_IRQ:1;        /* MCS6 channel 1 interrupt. */
      vuint32_t MCS6_CH0_IRQ:1;        /* MCS6 channel 0 interrupt. */
      vuint32_t MCS5_CH7_IRQ:1;        /* MCS5 channel 7 interrupt. */
      vuint32_t MCS5_CH6_IRQ:1;        /* MCS5 channel 6 interrupt. */
      vuint32_t MCS5_CH5_IRQ:1;        /* MCS5 channel 5 interrupt. */
      vuint32_t MCS5_CH4_IRQ:1;        /* MCS5 channel 4 interrupt. */
      vuint32_t MCS5_CH3_IRQ:1;        /* MCS5 channel 3 interrupt. */
      vuint32_t MCS5_CH2_IRQ:1;        /* MCS5 channel 2 interrupt. */
      vuint32_t MCS5_CH1_IRQ:1;        /* MCS5 channel 1 interrupt. */
      vuint32_t MCS5_CH0_IRQ:1;        /* MCS5 channel 0 interrupt. */
      vuint32_t MCS4_CH7_IRQ:1;        /* MCS4 channel 7 interrupt. */
      vuint32_t MCS4_CH6_IRQ:1;        /* MCS4 channel 6 interrupt. */
      vuint32_t MCS4_CH5_IRQ:1;        /* MCS4 channel 5 interrupt. */
      vuint32_t MCS4_CH4_IRQ:1;        /* MCS4 channel 4 interrupt. */
      vuint32_t MCS4_CH3_IRQ:1;        /* MCS4 channel 3 interrupt. */
      vuint32_t MCS4_CH2_IRQ:1;        /* MCS4 channel 2 interrupt. */
      vuint32_t MCS4_CH1_IRQ:1;        /* MCS4 channel 1 interrupt. */
      vuint32_t MCS4_CH0_IRQ:1;        /* MCS4 channel 0 interrupt. */
    } B;
  } IRQG_5;

  union {                              /* TOM Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t TOM1_CH15_IRQ:1;       /* TOM1 channel 15 shared interrupt. */
      vuint32_t TOM1_CH14_IRQ:1;       /* TOM1 channel 14 shared interrupt. */
      vuint32_t TOM1_CH13_IRQ:1;       /* TOM1 channel 13 shared interrupt. */
      vuint32_t TOM1_CH12_IRQ:1;       /* TOM1 channel 12 shared interrupt. */
      vuint32_t TOM1_CH11_IRQ:1;       /* TOM1 channel 11 shared interrupt. */
      vuint32_t TOM1_CH10_IRQ:1;       /* TOM1 channel 10 shared interrupt. */
      vuint32_t TOM1_CH9_IRQ:1;        /* TOM1 channel 9 shared interrupt. */
      vuint32_t TOM1_CH8_IRQ:1;        /* TOM1 channel 8 shared interrupt. */
      vuint32_t TOM1_CH7_IRQ:1;        /* TOM1 channel 7 shared interrupt. */
      vuint32_t TOM1_CH6_IRQ:1;        /* TOM1 channel 6 shared interrupt. */
      vuint32_t TOM1_CH5_IRQ:1;        /* TOM1 channel 5 shared interrupt. */
      vuint32_t TOM1_CH4_IRQ:1;        /* TOM1 channel 4 shared interrupt. */
      vuint32_t TOM1_CH3_IRQ:1;        /* TOM1 channel 3 shared interrupt. */
      vuint32_t TOM1_CH2_IRQ:1;        /* TOM1 channel 2 shared interrupt. */
      vuint32_t TOM1_CH1_IRQ:1;        /* TOM1 channel 1 shared interrupt. */
      vuint32_t TOM1_CH0_IRQ:1;        /* TOM1 channel 0 shared interrupt. */
      vuint32_t TOM0_CH15_IRQ:1;       /* TOM0 channel 15 shared interrupt. */
      vuint32_t TOM0_CH14_IRQ:1;       /* TOM0 channel 14 shared interrupt. */
      vuint32_t TOM0_CH13_IRQ:1;       /* TOM0 channel 13 shared interrupt. */
      vuint32_t TOM0_CH12_IRQ:1;       /* TOM0 channel 12 shared interrupt. */
      vuint32_t TOM0_CH11_IRQ:1;       /* TOM0 channel 11 shared interrupt. */
      vuint32_t TOM0_CH10_IRQ:1;       /* TOM0 channel 10 shared interrupt. */
      vuint32_t TOM0_CH9_IRQ:1;        /* TOM0 channel 9 shared interrupt. */
      vuint32_t TOM0_CH8_IRQ:1;        /* TOM0 channel 8 shared interrupt. */
      vuint32_t TOM0_CH7_IRQ:1;        /* TOM0 channel 7 shared interrupt. */
      vuint32_t TOM0_CH6_IRQ:1;        /* TOM0 channel 6 shared interrupt. */
      vuint32_t TOM0_CH5_IRQ:1;        /* TOM0 channel 5 shared interrupt. */
      vuint32_t TOM0_CH4_IRQ:1;        /* TOM0 channel 4 shared interrupt. */
      vuint32_t TOM0_CH3_IRQ:1;        /* TOM0 channel 3 shared interrupt. */
      vuint32_t TOM0_CH2_IRQ:1;        /* TOM0 channel 2 shared interrupt. */
      vuint32_t TOM0_CH1_IRQ:1;        /* TOM0 channel 1 shared interrupt */
      vuint32_t TOM0_CH0_IRQ:1;        /* TOM0 channel 0 shared interrupt. */
    } B;
  } IRQG_6;

  union {                              /* TOM Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t TOM3_CH15_IRQ:1;       /* TOM3 channel 15 shared interrupt. */
      vuint32_t TOM3_CH14_IRQ:1;       /* TOM3 channel 14 shared interrupt. */
      vuint32_t TOM3_CH13_IRQ:1;       /* TOM3 channel 13 shared interrupt. */
      vuint32_t TOM3_CH12_IRQ:1;       /* TOM3 channel 12 shared interrupt. */
      vuint32_t TOM3_CH11_IRQ:1;       /* TOM3 channel 11 shared interrupt. */
      vuint32_t TOM3_CH10_IRQ:1;       /* TOM3 channel 10 shared interrupt. */
      vuint32_t TOM3_CH9_IRQ:1;        /* TOM3 channel 9 shared interrupt. */
      vuint32_t TOM3_CH8_IRQ:1;        /* TOM3 channel 8 shared interrupt. */
      vuint32_t TOM3_CH7_IRQ:1;        /* TOM3 channel 7 shared interrupt. */
      vuint32_t TOM3_CH6_IRQ:1;        /* TOM3 channel 7 shared interrupt. */
      vuint32_t TOM3_CH5_IRQ:1;        /* TOM3 channel 5 shared interrupt. */
      vuint32_t TOM3_CH4_IRQ:1;        /* TOM3 channel 4 shared interrupt. */
      vuint32_t TOM3_CH3_IRQ:1;        /* TOM3 channel 3 shared interrupt. */
      vuint32_t TOM3_CH2_IRQ:1;        /* TOM3 channel 2 shared interrupt. */
      vuint32_t TOM3_CH1_IRQ:1;        /* TOM3 channel 1 shared interrupt. */
      vuint32_t TOM3_CH0_IRQ:1;        /* TOM3 channel 0 shared interrupt. */
      vuint32_t TOM2_CH15_IRQ:1;       /* TOM2 channel 15 shared interrupt. */
      vuint32_t TOM2_CH14_IRQ:1;       /* TOM2 channel 14 shared interrupt. */
      vuint32_t TOM2_CH13_IRQ:1;       /* TOM2 channel 13 shared interrupt. */
      vuint32_t TOM2_CH12_IRQ:1;       /* TOM2 channel 12 shared interrupt. */
      vuint32_t TOM2_CH11_IRQ:1;       /* TOM2 channel 11 shared interrupt. */
      vuint32_t TOM2_CH10_IRQ:1;       /* TOM2 channel 10 shared interrupt. */
      vuint32_t TOM2_CH9_IRQ:1;        /* TOM2 channel 9 shared interrupt. */
      vuint32_t TOM2_CH8_IRQ:1;        /* TOM2 channel 8 shared interrupt. */
      vuint32_t TOM2_CH7_IRQ:1;        /* TOM2 channel 7 shared interrupt. */
      vuint32_t TOM2_CH6_IRQ:1;        /* TOM2 channel 6 shared interrupt. */
      vuint32_t TOM2_CH5_IRQ:1;        /* TOM2 channel 5 shared interrupt. */
      vuint32_t TOM2_CH4_IRQ:1;        /* TOM2 channel 4 shared interrupt. */
      vuint32_t TOM2_CH3_IRQ:1;        /* TOM2 channel 3 shared interrupt. */
      vuint32_t TOM2_CH2_IRQ:1;        /* TOM2 channel 2 shared interrupt. */
      vuint32_t TOM2_CH1_IRQ:1;        /* TOM2 channel 1 shared interrupt */
      vuint32_t TOM2_CH0_IRQ:1;        /* TOM2 channel 0 shared interrupt. */
    } B;
  } IRQG_7;

  union {                              /* TOM Interrupt Group 2 Register */
    vuint32_t R;
    struct {
      vuint32_t TOM5_CH15_IRQ:1;       /* TOM5 channel 15 shared interrupt. */
      vuint32_t TOM5_CH14_IRQ:1;       /* TOM5 channel 14 shared interrupt. */
      vuint32_t TOM5_CH13_IRQ:1;       /* TOM5 channel 13 shared interrupt. */
      vuint32_t TOM5_CH12_IRQ:1;       /* TOM5 channel 12 shared interrupt. */
      vuint32_t TOM5_CH11_IRQ:1;       /* TOM5 channel 11 shared interrupt. */
      vuint32_t TOM5_CH10_IRQ:1;       /* TOM5 channel 10 shared interrupt. */
      vuint32_t TOM5_CH9_IRQ:1;        /* TOM5 channel 9 shared interrupt. */
      vuint32_t TOM5_CH8_IRQ:1;        /* TOM5 channel 8 shared interrupt. */
      vuint32_t TOM5_CH7_IRQ:1;        /* TOM5 channel 7 shared interrupt. */
      vuint32_t TOM5_CH6_IRQ:1;        /* TOM5 channel 6 shared interrupt. */
      vuint32_t TOM5_CH5_IRQ:1;        /* TOM5 channel 5 shared interrupt. */
      vuint32_t TOM5_CH4_IRQ:1;        /* TOM5 channel 4 shared interrupt. */
      vuint32_t TOM5_CH3_IRQ:1;        /* TOM5 channel 3 shared interrupt. */
      vuint32_t TOM5_CH2_IRQ:1;        /* TOM5 channel 2 shared interrupt. */
      vuint32_t TOM5_CH1_IRQ:1;        /* TOM5 channel 1 shared interrupt. */
      vuint32_t TOM5_CH0_IRQ:1;        /* TOM5 channel 0 shared interrupt. */
      vuint32_t TOM4_CH15_IRQ:1;       /* TOM4 channel 15 shared interrupt. */
      vuint32_t TOM4_CH14_IRQ:1;       /* TOM4 channel 14 shared interrupt. */
      vuint32_t TOM4_CH13_IRQ:1;       /* TOM4 channel 13 shared interrupt. */
      vuint32_t TOM4_CH12_IRQ:1;       /* TOM4 channel 12 shared interrupt. */
      vuint32_t TOM4_CH11_IRQ:1;       /* TOM4 channel 11 shared interrupt. */
      vuint32_t TOM4_CH10_IRQ:1;       /* TOM4 channel 10 shared interrupt. */
      vuint32_t TOM4_CH9_IRQ:1;        /* TOM4 channel 9 shared interrupt. */
      vuint32_t TOM4_CH8_IRQ:1;        /* TOM4 channel 8 shared interrupt. */
      vuint32_t TOM4_CH7_IRQ:1;        /* TOM4 channel 7 shared interrupt. */
      vuint32_t TOM4_CH6_IRQ:1;        /* TOM4 channel 6 shared interrupt. */
      vuint32_t TOM4_CH5_IRQ:1;        /* TOM4 channel 5 shared interrupt. */
      vuint32_t TOM4_CH4_IRQ:1;        /* TOM4 channel 4 shared interrupt. */
      vuint32_t TOM4_CH3_IRQ:1;        /* TOM4 channel 3 shared interrupt. */
      vuint32_t TOM4_CH2_IRQ:1;        /* TOM4 channel 2 shared interrupt. */
      vuint32_t TOM4_CH1_IRQ:1;        /* TOM4 channel 1 shared interrupt */
      vuint32_t TOM4_CH0_IRQ:1;        /* TOM4 channel 0 shared interrupt. */
    } B;
  } IRQG_8;

  union {                              /* ATOM Interrupt Group 0 Register */
    vuint32_t R;
    struct {
      vuint32_t ATOM3_CH7_IRQ:1;       /* ATOM3 channel 7 interrupt. */
      vuint32_t ATOM3_CH6_IRQ:1;       /* ATOM3 channel 6 interrupt. */
      vuint32_t ATOM3_CH5_IRQ:1;       /* ATOM3 channel 5 interrupt. */
      vuint32_t ATOM3_CH4_IRQ:1;       /* ATOM3 channel 4 interrupt. */
      vuint32_t ATOM3_CH3_IRQ:1;       /* ATOM3 channel 3 interrupt. */
      vuint32_t ATOM3_CH2_IRQ:1;       /* ATOM3 channel 2 interrupt. */
      vuint32_t ATOM3_CH1_IRQ:1;       /* ATOM3 channel 1 interrupt. */
      vuint32_t ATOM3_CH0_IRQ:1;       /* ATOM3 channel 0 interrupt. */
      vuint32_t ATOM2_CH7_IRQ:1;       /* ATOM2 channel 7 interrupt. */
      vuint32_t ATOM2_CH6_IRQ:1;       /* ATOM2 channel 6 interrupt. */
      vuint32_t ATOM2_CH5_IRQ:1;       /* ATOM2 channel 5 interrupt. */
      vuint32_t ATOM2_CH4_IRQ:1;       /* ATOM2 channel 4 interrupt. */
      vuint32_t ATOM2_CH3_IRQ:1;       /* ATOM2 channel 3 interrupt. */
      vuint32_t ATOM2_CH2_IRQ:1;       /* ATOM2 channel 2 interrupt. */
      vuint32_t ATOM2_CH1_IRQ:1;       /* ATOM2 channel 1 interrupt. */
      vuint32_t ATOM2_CH0_IRQ:1;       /* ATOM2 channel 0 interrupt. */
      vuint32_t ATOM1_CH7_IRQ:1;       /* ATOM1 channel 7 interrupt. */
      vuint32_t ATOM1_CH6_IRQ:1;       /* ATOM1 channel 6 interrupt. */
      vuint32_t ATOM1_CH5_IRQ:1;       /* ATOM1 channel 5 interrupt. */
      vuint32_t ATOM1_CH4_IRQ:1;       /* ATOM1 channel 4 interrupt. */
      vuint32_t ATOM1_CH3_IRQ:1;       /* ATOM1 channel 3 interrupt. */
      vuint32_t ATOM1_CH2_IRQ:1;       /* ATOM1 channel 2 interrupt. */
      vuint32_t ATOM1_CH1_IRQ:1;       /* ATOM1 channel 1 interrupt. */
      vuint32_t ATOM1_CH0_IRQ:1;       /* ATOM1 channel 0 interrupt. */
      vuint32_t ATOM0_CH7_IRQ:1;       /* ATOM0 channel 7 interrupt. */
      vuint32_t ATOM0_CH6_IRQ:1;       /* ATOM0 channel 6 interrupt. */
      vuint32_t ATOM0_CH5_IRQ:1;       /* ATOM0 channel 5 interrupt. */
      vuint32_t ATOM0_CH4_IRQ:1;       /* ATOM0 channel 4 interrupt. */
      vuint32_t ATOM0_CH3_IRQ:1;       /* ATOM0 channel 3 interrupt. */
      vuint32_t ATOM0_CH2_IRQ:1;       /* ATOM0 channel 2 interrupt. */
      vuint32_t ATOM0_CH1_IRQ:1;       /* ATOM0 channel 1 interrupt. */
      vuint32_t ATOM0_CH0_IRQ:1;       /* ATOM0 channel 0 interrupt. */
    } B;
  } IRQG_9;

  union {                              /* ATOM Interrupt Group 1 Register */
    vuint32_t R;
    struct {
      vuint32_t ATOM7_CH7_IRQ:1;       /* ATOM7 channel 7 interrupt. */
      vuint32_t ATOM7_CH6_IRQ:1;       /* ATOM7 channel 6 interrupt. */
      vuint32_t ATOM7_CH5_IRQ:1;       /* ATOM7 channel 5 interrupt. */
      vuint32_t ATOM7_CH4_IRQ:1;       /* ATOM7 channel 4 interrupt. */
      vuint32_t ATOM7_CH3_IRQ:1;       /* ATOM7 channel 3 interrupt. */
      vuint32_t ATOM7_CH2_IRQ:1;       /* ATOM7 channel 2 interrupt. */
      vuint32_t ATOM7_CH1_IRQ:1;       /* ATOM7 channel 1 interrupt. */
      vuint32_t ATOM7_CH0_IRQ:1;       /* ATOM7 channel 0 interrupt. */
      vuint32_t ATOM6_CH7_IRQ:1;       /* ATOM6 channel 7 interrupt. */
      vuint32_t ATOM6_CH6_IRQ:1;       /* ATOM6 channel 6 interrupt. */
      vuint32_t ATOM6_CH5_IRQ:1;       /* ATOM6 channel 5 interrupt. */
      vuint32_t ATOM6_CH4_IRQ:1;       /* ATOM channel 4 interrupt. */
      vuint32_t ATOM6_CH3_IRQ:1;       /* ATOM6 channel 3 interrupt. */
      vuint32_t ATOM6_CH2_IRQ:1;       /* ATOM6 channel 2 interrupt. */
      vuint32_t ATOM6_CH1_IRQ:1;       /* ATOM6 channel 1 interrupt. */
      vuint32_t ATOM6_CH0_IRQ:1;       /* ATOM6 channel 0 interrupt. */
      vuint32_t ATOM5_CH7_IRQ:1;       /* ATOM5 channel 7 interrupt. */
      vuint32_t ATOM5_CH6_IRQ:1;       /* ATOM5 channel 6 interrupt. */
      vuint32_t ATOM5_CH5_IRQ:1;       /* ATOM5 channel 5 interrupt. */
      vuint32_t ATOM5_CH4_IRQ:1;       /* ATOM5 channel 4 interrupt. */
      vuint32_t ATOM5_CH3_IRQ:1;       /* ATOM5 channel 3 interrupt. */
      vuint32_t ATOM5_CH2_IRQ:1;       /* ATOM5 channel 2 interrupt. */
      vuint32_t ATOM5_CH1_IRQ:1;       /* ATOM5 channel 1 interrupt. */
      vuint32_t ATOM5_CH0_IRQ:1;       /* ATOM5 channel 0 interrupt. */
      vuint32_t ATOM4_CH7_IRQ:1;       /* ATOM4 channel 7 interrupt. */
      vuint32_t ATOM4_CH6_IRQ:1;       /* ATOM4 channel 6 interrupt. */
      vuint32_t ATOM4_CH5_IRQ:1;       /* ATOM4 channel 5 interrupt. */
      vuint32_t ATOM4_CH4_IRQ:1;       /* ATOM4 channel 4 interrupt. */
      vuint32_t ATOM4_CH3_IRQ:1;       /* ATOM4 channel 3 interrupt. */
      vuint32_t ATOM4_CH2_IRQ:1;       /* ATOM4 channel 2 interrupt. */
      vuint32_t ATOM4_CH1_IRQ:1;       /* ATOM4 channel 1 interrupt. */
      vuint32_t ATOM4_CH0_IRQ:1;       /* ATOM4 channel 0 interrupt. */
    } B;
  } IRQG_10;

  union {                              /* ATOM Interrupt Group 2 Register */
    vuint32_t R;
    struct {
      vuint32_t ATOM11_CH7_IRQ:1;      /* ATOM11 channel 7 interrupt. */
      vuint32_t ATOM11_CH6_IRQ:1;      /* ATOM11 channel 6 interrupt. */
      vuint32_t ATOM11_CH5_IRQ:1;      /* ATOM11 channel 5 interrupt. */
      vuint32_t ATOM11_CH4_IRQ:1;      /* ATOM11 channel 4 interrupt. */
      vuint32_t ATOM11_CH3_IRQ:1;      /* ATOM11 channel 3 interrupt. */
      vuint32_t ATOM11_CH2_IRQ:1;      /* ATOM11 channel 2 interrupt. */
      vuint32_t ATOM11_CH1_IRQ:1;      /* ATOM11 channel 1 interrupt. */
      vuint32_t ATOM11_CH0_IRQ:1;      /* ATOM11 channel 0 interrupt. */
      vuint32_t ATOM10_CH7_IRQ:1;      /* ATOM10 channel 7 interrupt. */
      vuint32_t ATOM10_CH6_IRQ:1;      /* ATOM10 channel 6 interrupt. */
      vuint32_t ATOM10_CH5_IRQ:1;      /* ATOM10 channel 5 interrupt. */
      vuint32_t ATOM10_CH4_IRQ:1;      /* ATOM10 channel 4 interrupt. */
      vuint32_t ATOM10_CH3_IRQ:1;      /* ATOM10 channel 3 interrupt. */
      vuint32_t ATOM10_CH2_IRQ:1;      /* ATOM10 channel 2 interrupt. */
      vuint32_t ATOM10_CH1_IRQ:1;      /* ATOM10 channel 1 interrupt. */
      vuint32_t ATOM10_CH0_IRQ:1;      /* ATOM10 channel 0 interrupt. */
      vuint32_t ATOM9_CH7_IRQ:1;       /* ATOM9 channel 7 interrupt. */
      vuint32_t ATOM9_CH6_IRQ:1;       /* ATOM9 channel 6 interrupt. */
      vuint32_t ATOM9_CH5_IRQ:1;       /* ATOM9 channel 5 interrupt. */
      vuint32_t ATOM9_CH4_IRQ:1;       /* ATOM9 channel 4 interrupt. */
      vuint32_t ATOM9_CH3_IRQ:1;       /* ATOM9 channel 3 interrupt. */
      vuint32_t ATOM9_CH2_IRQ:1;       /* ATOM9 channel 2 interrupt. */
      vuint32_t ATOM9_CH1_IRQ:1;       /* ATOM9 channel 1 interrupt. */
      vuint32_t ATOM9_CH0_IRQ:1;       /* ATOM9 channel 0 interrupt. */
      vuint32_t ATOM8_CH7_IRQ:1;       /* ATOM8 channel 7 interrupt. */
      vuint32_t ATOM8_CH6_IRQ:1;       /* ATOM8 channel 6 interrupt. */
      vuint32_t ATOM8_CH5_IRQ:1;       /* ATOM8 channel 5 interrupt. */
      vuint32_t ATOM8_CH4_IRQ:1;       /* ATOM8 channel 4 interrupt. */
      vuint32_t ATOM4_CH3_IR8:1;       /* ATOM8 channel 3 interrupt. */
      vuint32_t ATOM8_CH2_IRQ:1;       /* ATOM8 channel 2 interrupt. */
      vuint32_t ATOM8_CH1_IRQ:1;       /* ATOM8 channel 1 interrupt. */
      vuint32_t ATOM8_CH0_IRQ:1;       /* ATOM8 channel 0 interrupt. */
    } B;
  } IRQG_11;

  union {                              /* ICM IRQG Module Error Interrupt register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t DPLL_EIRQ:1;           /* DPLL error interrupt. */
      vuint32_t CMP_EIRQ:1;            /* CMP error interrupt. */
      vuint32_t SPE3_EIRQ:1;           /* SPE3 error interrupt. */
      vuint32_t SPE2_EIRQ:1;           /* SPE2 error interrupt. */
      vuint32_t SPE1_EIRQ:1;           /* SPE1 error interrupt. */
      vuint32_t SPE0_EIRQ:1;           /* SPE0 error interrupt. */
      vuint32_t  :1;
      vuint32_t MCS6_EIRQ:1;           /* MCS6 error interrupt. */
      vuint32_t MCS5_EIRQ:1;           /* MCS5 error interrupt. */
      vuint32_t MCS4_EIRQ:1;           /* MCS4 error interrupt. */
      vuint32_t MCS3_EIRQ:1;           /* MCS3 error interrupt. */
      vuint32_t MCS2_EIRQ:1;           /* MCS2 error interrupt. */
      vuint32_t MCS1_EIRQ:1;           /* MCS1 error interrupt */
      vuint32_t MCS0_EIRQ:1;           /* MCS0 error interrupt. */
      vuint32_t  :1;
      vuint32_t TIM6_EIRQ:1;           /* TIM6 error interrupt. */
      vuint32_t TIM5_EIRQ:1;           /* TIM5 error interrupt. */
      vuint32_t TIM4_EIRQ:1;           /* TIM4 error interrupt. */
      vuint32_t TIM3_EIRQ:1;           /* TIM3 error interrupt. */
      vuint32_t TIM2_EIRQ:1;           /* TIM2 error interrupt. */
      vuint32_t TIM1_EIRQ:1;           /* TIM1 error interrupt. */
      vuint32_t TIM0_EIRQ:1;           /* TIM0 error interrupt. */
      vuint32_t FIFO1_EIRQ:1;          /* FIFO1 error interrupt. */
      vuint32_t FIFO0_EIRQ:1;          /* FIFO0 error interrupt. */
      vuint32_t BRC_EIRQ:1;            /* BRC error interrupt. */
      vuint32_t GTM_EIRQ:1;            /* GTM Error interrupt request. */
    } B;
  } IRQG_MEI;

  union {                              /* ICM Channel Error Interrupt Request Group 0 register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FIFO1_CH7_EIRQ:1;      /* FIFO1 channel 7 error interrupt */
      vuint32_t FIFO1_CH6_EIRQ:1;      /* FIFO1 channel 6 error interrupt */
      vuint32_t FIFO1_CH5_EIRQ:1;      /* FIFO1 channel 5 error interrupt */
      vuint32_t FIFO1_CH4_EIRQ:1;      /* FIFO1 channel 4 error interrupt */
      vuint32_t FIFO1_CH3_EIRQ:1;      /* FIFO1 channel 3 error interrupt */
      vuint32_t FIFO1_CH2_EIRQ:1;      /* FIFO1 channel 2 error interrupt */
      vuint32_t FIFO1_CH1_EIRQ:1;      /* FIFO1 channel 1 error interrupt */
      vuint32_t FIFO1_CH0_EIRQ:1;      /* FIFO1 channel 0 error interrupt */
      vuint32_t FIFO0_CH7_EIRQ:1;      /* FIFO0 channel 7 error interrupt */
      vuint32_t FIFO0_CH6_EIRQ:1;      /* FIFO0 channel 6 error interrupt */
      vuint32_t FIFO0_CH5_EIRQ:1;      /* FIFO0 channel 5 error interrupt */
      vuint32_t FIFO0_CH4_EIRQ:1;      /* FIFO0 channel 4 error interrupt */
      vuint32_t FIFO0_CH3_EIRQ:1;      /* FIFO0 channel 3 error interrupt */
      vuint32_t FIFO0_CH2_EIRQ:1;      /* FIFO0 channel 2 error interrupt */
      vuint32_t FIFO0_CH1_EIRQ:1;      /* FIFO0 channel 1 error interrupt */
      vuint32_t FIFO0_CH0_EIRQ:1;      /* FIFO0 channel 0 error interrupt */
    } B;
  } IRQG_CEI0;

  union {                              /* Channel Error Interrupt Request Group 1 register */
    vuint32_t R;
    struct {
      vuint32_t TIM3_CH7_EIRQ:1;       /* TIM3 Channel 7 Error interrupt */
      vuint32_t TIM3_CH6_EIRQ:1;       /* TIM3 Channel 6 Error interrupt */
      vuint32_t TIM3_CH5_EIRQ:1;       /* TIM3 Channel 5 Error interrupt */
      vuint32_t TIM3_CH4_EIRQ:1;       /* TIM3 Channel 4 Error interrupt */
      vuint32_t TIM3_CH3_EIRQ:1;       /* TIM3 Channel 3 Error interrupt */
      vuint32_t TIM3_CH2_EIRQ:1;       /* TIM3 Channel 2 Error interrupt */
      vuint32_t TIM3_CH1_EIRQ:1;       /* TIM3 Channel 1 Error interrupt */
      vuint32_t TIM3_CH0_EIRQ:1;       /* TIM3 Channel 0 Error interrupt */
      vuint32_t TIM2_CH7_EIRQ:1;       /* TIM2 Channel 7 Error interrupt */
      vuint32_t TIM2_CH6_EIRQ:1;       /* TIM2 Channel 6 Error interrupt */
      vuint32_t TIM2_CH5_EIRQ:1;       /* TIM2 Channel 5 Error interrupt */
      vuint32_t TIM2_CH4_EIRQ:1;       /* TIM2 Channel 4 Error interrupt */
      vuint32_t TIM2_CH3_EIRQ:1;       /* TIM2 Channel 3 Error interrupt */
      vuint32_t TIM2_CH2_EIRQ:1;       /* TIM2 Channel 2 Error interrupt */
      vuint32_t TIM2_CH1_EIRQ:1;       /* TIM2 Channel 1 Error interrupt */
      vuint32_t TIM2_CH0_EIRQ:1;       /* TIM2 Channel 0 Error interrupt */
      vuint32_t TIM1_CH7_EIRQ:1;       /* TIM1 Channel 7 Error interrupt */
      vuint32_t TIM1_CH6_EIRQ:1;       /* TIM1 Channel 6 Error interrupt */
      vuint32_t TIM1_CH5_EIRQ:1;       /* TIM1 Channel 5 Error interrupt */
      vuint32_t TIM1_CH4_EIRQ:1;       /* TIM1 Channel 4 Error interrupt */
      vuint32_t TIM1_CH3_EIRQ:1;       /* TIM1 Channel 3 Error interrupt */
      vuint32_t TIM1_CH2_EIRQ:1;       /* TIM1 Channel 2 Error interrupt */
      vuint32_t TIM1_CH1_EIRQ:1;       /* TIM1 Channel 1 Error interrupt */
      vuint32_t TIM1_CH0_EIRQ:1;       /* TIM1 Channel 0 Error interrupt */
      vuint32_t TIM0_CH7_EIRQ:1;       /* TIM0 Channel 7 Error interrupt */
      vuint32_t TIM0_CH6_EIRQ:1;       /* TIM0 Channel 6 Error interrupt */
      vuint32_t TIM0_CH5_EIRQ:1;       /* TIM0 Channel 5 Error interrupt */
      vuint32_t TIM0_CH4_EIRQ:1;       /* TIM0 Channel 4 Error interrupt */
      vuint32_t TIM0_CH3_EIRQ:1;       /* TIM0 Channel 3 Error interrupt */
      vuint32_t TIM0_CH2_EIRQ:1;       /* TIM0 Channel 2 Error interrupt */
      vuint32_t TIM0_CH1_EIRQ:1;       /* TIM0 Channel 1 Error interrupt */
      vuint32_t TIM0_CH0_EIRQ:1;       /* TIM0 Channel 0 Error interrupt */
    } B;
  } IRQG_CEI1;

  union {                              /* Channel Error Interrupt Request Group 2 register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t TIM6_CH7_EIRQ:1;       /* TIM6 Channel 7 Error interrupt */
      vuint32_t TIM6_CH6_EIRQ:1;       /* TIM6 Channel 6 Error interrupt */
      vuint32_t TIM6_CH5_EIRQ:1;       /* TIM6 Channel 5 Error interrupt */
      vuint32_t TIM6_CH4_EIRQ:1;       /* TIM6 Channel 4 Error interrupt */
      vuint32_t TIM6_CH3_EIRQ:1;       /* TIM6 Channel 3 Error interrupt */
      vuint32_t TIM6_CH2_EIRQ:1;       /* TIM6 Channel 2 Error interrupt */
      vuint32_t TIM6_CH1_EIRQ:1;       /* TIM6 Channel 1 Error interrupt */
      vuint32_t TIM6_CH0_EIRQ:1;       /* TIM6 Channel 0 Error interrupt */
      vuint32_t TIM5_CH7_EIRQ:1;       /* TIM5 Channel 7 Error interrupt */
      vuint32_t TIM5_CH6_EIRQ:1;       /* TIM5 Channel 6 Error interrupt */
      vuint32_t TIM5_CH5_EIRQ:1;       /* TIM5 Channel 5 Error interrupt */
      vuint32_t TIM5_CH4_EIRQ:1;       /* TIM5 Channel 4 Error interrupt */
      vuint32_t TIM5_CH3_EIRQ:1;       /* TIM5 Channel 3 Error interrupt */
      vuint32_t TIM5_CH2_EIRQ:1;       /* TIM5 Channel 2 Error interrupt */
      vuint32_t TIM5_CH1_EIRQ:1;       /* TIM5 Channel 1 Error interrupt */
      vuint32_t TIM5_CH0_EIRQ:1;       /* TIM5 Channel 0 Error interrupt */
      vuint32_t TIM4_CH7_EIRQ:1;       /* TIM4 Channel 7 Error interrupt */
      vuint32_t TIM4_CH6_EIRQ:1;       /* TIM4 Channel 6 Error interrupt */
      vuint32_t TIM4_CH5_EIRQ:1;       /* TIM4 Channel 5 Error interrupt */
      vuint32_t TIM4_CH4_EIRQ:1;       /* TIM4 Channel 4 Error interrupt */
      vuint32_t TIM4_CH3_EIRQ:1;       /* TIM4 Channel 3 Error interrupt */
      vuint32_t TIM4_CH2_EIRQ:1;       /* TIM4 Channel 2 Error interrupt */
      vuint32_t TIM4_CH1_EIRQ:1;       /* TIM4 Channel 1 Error interrupt */
      vuint32_t TIM4_CH0_EIRQ:1;       /* TIM4 Channel 0 Error interrupt */
    } B;
  } IRQG_CEI2;

  union {                              /* Channel Error Interrupt Request Group 3 register */
    vuint32_t R;
    struct {
      vuint32_t MCS3_CH7_EIRQ:1;       /* MCS3 Channel 7 error interrupt */
      vuint32_t MCS3_CH6_EIRQ:1;       /* MCS3 Channel 6 error interrupt */
      vuint32_t MCS3_CH5_EIRQ:1;       /* MCS3 Channel 5 error interrupt */
      vuint32_t MCS3_CH4_EIRQ:1;       /* MCS3 Channel 4 error interrupt */
      vuint32_t MCS3_CH3_EIRQ:1;       /* MCS3 Channel 3 error interrupt */
      vuint32_t MCS3_CH2_EIRQ:1;       /* MCS3 Channel 2 error interrupt */
      vuint32_t MCS3_CH1_EIRQ:1;       /* MCS3 Channel 1 error interrupt */
      vuint32_t MCS3_CH0_EIRQ:1;       /* MCS3 Channel 0 error interrupt */
      vuint32_t MCS2_CH7_EIRQ:1;       /* MCS2 Channel 7 error interrupt */
      vuint32_t MCS2_CH6_EIRQ:1;       /* MCS2 Channel 6 error interrupt */
      vuint32_t MCS2_CH5_EIRQ:1;       /* MCS2 Channel 5 error interrupt */
      vuint32_t MCS2_CH4_EIRQ:1;       /* MCS2 Channel 4 error interrupt */
      vuint32_t MCS2_CH3_EIRQ:1;       /* MCS2 Channel 3 error interrupt */
      vuint32_t MCS2_CH2_EIRQ:1;       /* MCS2 Channel 2 error interrupt */
      vuint32_t MCS2_CH1_EIRQ:1;       /* MCS2 Channel 1 error interrupt */
      vuint32_t MCS2_CH0_EIRQ:1;       /* MCS2 Channel 0 error interrupt */
      vuint32_t MCS1_CH7_EIRQ:1;       /* MCS1 Channel 7 error interrupt */
      vuint32_t MCS1_CH6_EIRQ:1;       /* MCS1 Channel 6 error interrupt */
      vuint32_t MCS1_CH5_EIRQ:1;       /* MCS1 Channel 5 error interrupt */
      vuint32_t MCS1_CH4_EIRQ:1;       /* MCS1 Channel 4 error interrupt */
      vuint32_t MCS1_CH3_EIRQ:1;       /* MCS1 Channel 3 error interrupt */
      vuint32_t MCS1_CH2_EIRQ:1;       /* MCS1 Channel 2 error interrupt */
      vuint32_t MCS1_CH1_EIRQ:1;       /* MCS1 Channel 1 error interrupt */
      vuint32_t MCS1_CH0_EIRQ:1;       /* MCS1 Channel 0 error interrupt */
      vuint32_t MCS0_CH7_EIRQ:1;       /* MCS0 Channel 7 error interrupt */
      vuint32_t MCS0_CH6_EIRQ:1;       /* MCS0 Channel 6 error interrupt */
      vuint32_t MCS0_CH5_EIRQ:1;       /* MCS0 Channel 5 error interrupt */
      vuint32_t MCS0_CH4_EIRQ:1;       /* MCS0 Channel 4 error interrupt */
      vuint32_t MCS0_CH3_EIRQ:1;       /* MCS0 Channel 3 error interrupt */
      vuint32_t MCS0_CH2_EIRQ:1;       /* MCS0 Channel 2 error interrupt */
      vuint32_t MCS0_CH1_EIRQ:1;       /* MCS0 Channel 1 error interrupt */
      vuint32_t MCS0_CH0_EIRQ:1;       /* MCS0 Channel 0 error interrupt */
    } B;
  } IRQG_CEI3;

  union {                              /* Channel Error Interrupt Request Group 4 register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t MCS6_CH7_EIRQ:1;       /* MCS6 Channel 7 error interrupt */
      vuint32_t MCS6_CH6_EIRQ:1;       /* MCS6 Channel 6 error interrupt */
      vuint32_t MCS6_CH5_EIRQ:1;       /* MCS6 Channel 5 error interrupt */
      vuint32_t MCS6_CH4_EIRQ:1;       /* MCS6 Channel 4 error interrupt */
      vuint32_t MCS6_CH3_EIRQ:1;       /* MCS6 Channel 3 error interrupt */
      vuint32_t MCS6_CH2_EIRQ:1;       /* MCS6 Channel 2 error interrupt */
      vuint32_t MCS6_CH1_EIRQ:1;       /* MCS6 Channel 1 error interrupt */
      vuint32_t MCS6_CH0_EIRQ:1;       /* MCS6 Channel 0 error interrupt */
      vuint32_t MCS5_CH7_EIRQ:1;       /* MCS5 Channel 7 error interrupt */
      vuint32_t MCS5_CH6_EIRQ:1;       /* MCS5 Channel 6 error interrupt */
      vuint32_t MCS5_CH5_EIRQ:1;       /* MCS5 Channel 5 error interrupt */
      vuint32_t MCS5_CH4_EIRQ:1;       /* MCS5 Channel 4 error interrupt */
      vuint32_t MCS5_CH3_EIRQ:1;       /* MCS5 Channel 3 error interrupt */
      vuint32_t MCS5_CH2_EIRQ:1;       /* MCS5 Channel 2 error interrupt */
      vuint32_t MCS5_CH1_EIRQ:1;       /* MCS5 Channel 1 error interrupt */
      vuint32_t MCS5_CH0_EIRQ:1;       /* MCS5 Channel 0 error interrupt */
      vuint32_t MCS4_CH7_EIRQ:1;       /* MCS4 Channel 7 error interrupt */
      vuint32_t MCS4_CH6_EIRQ:1;       /* MCS4 Channel 6 error interrupt */
      vuint32_t MCS4_CH5_EIRQ:1;       /* MCS4 Channel 5 error interrupt */
      vuint32_t MCS4_CH4_EIRQ:1;       /* MCS4 Channel 4 error interrupt */
      vuint32_t MCS4_CH3_EIRQ:1;       /* MCS4 Channel 3 error interrupt */
      vuint32_t MCS4_CH2_EIRQ:1;       /* MCS4 Channel 2 error interrupt */
      vuint32_t MCS4_CH1_EIRQ:1;       /* MCS4 Channel 1 error interrupt */
      vuint32_t MCS4_CH0_EIRQ:1;       /* MCS4 Channel 0 error interrupt */
    } B;
  } IRQG_CEI4;
};


/* ============================================================================
   =============================== Module: GTM_MAP ============================
   ============================================================================ */

struct GTM_MAP_tag {
  union {                              /* TIM0 Input MAP Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TSPP1_I2V:1;           /* Disable of TSPP1 TIM0_CHz(48) input line. */
      vuint32_t TSPP1_I1V:1;           /* Disable of TSPP1 TIM0_CHy(48) input line. */
      vuint32_t TSPP1_I0V:1;           /* Disable of TSPP1 TIM0_CHx(48) input line. */
      vuint32_t  :2;
      vuint32_t TSPP1_DLD:1;           /* DIR level definition bit. */
      vuint32_t TSPP1_EN:1;            /* Enable of TSPP1 subunit. */
      vuint32_t  :1;
      vuint32_t TSPP0_I2V:1;           /* Disable of TSPP0 TIM0_CHz(48) input line. */
      vuint32_t TSPP0_I1V:1;           /* Disable of TSPP0 TIM0_CHy(48) input line. */
      vuint32_t TSPP0_I0V:1;           /* Disable of TSPP0 TIM0_CHx(48) input line. */
      vuint32_t  :2;
      vuint32_t TSPP0_DLD:1;           /* DIR level definition bit. */
      vuint32_t TSPP0_EN:1;            /* Enable of TSPP0 subunit. */
      vuint32_t  :11;
      vuint32_t LSEL:1;                /* TIM0_IN6 input level selection. */
      vuint32_t SSL:3;                 /* STATE signal output select. */
      vuint32_t TSEL:1;                /* TRIGGER signal output select. */
    } B;
  } CTRL;
};


/* ============================================================================
   =============================== Module: GTM_MCFG ===========================
   ============================================================================ */

struct GTM_MCFG_tag {
  union {                              /* Memory Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t MEM6:2;                /* Configure Memory pages for MCS-instance MCS6. */
      vuint32_t MEM5:2;                /* Configure Memory pages for MCS-instance MCS5. */
      vuint32_t MEM4:2;                /* Configure Memory pages for MCS-instance MCS4. */
      vuint32_t MEM3:2;                /* Configure Memory pages for MCS-instance MCS3 */
      vuint32_t MEM2:2;                /* Configure Memory pages for MCS-instance MCS2 */
      vuint32_t MEM1:2;                /* Configure Memory pages for MCS-instance MCS1. */
      vuint32_t MEM0:2;                /* Configure Memory pages for MCS-instance MCS0. */
    } B;
  } CTRL;
};


/* ============================================================================
   =============================== Module: GTM_MCS ============================
   ============================================================================ */

struct GTM_MCS_tag {
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH0_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH0_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH0_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH0_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH0_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH0_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH0_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH0_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH0_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH0_ACB;

  union {                              /* MCS Clear Trigger Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TRG15:1;               /* Trigger bit. */
      vuint32_t TRG14:1;               /* Trigger bit. */
      vuint32_t TRG13:1;               /* Trigger bit. */
      vuint32_t TRG12:1;               /* Trigger bit. */
      vuint32_t TRG11:1;               /* Trigger bit. */
      vuint32_t TRG10:1;               /* Trigger bit. */
      vuint32_t TRG9:1;                /* Trigger bit. */
      vuint32_t TRG8:1;                /* Trigger bit. */
      vuint32_t TRG7:1;                /* Trigger bit. */
      vuint32_t TRG6:1;                /* Trigger bit. */
      vuint32_t TRG5:1;                /* Trigger bit. */
      vuint32_t TRG4:1;                /* Trigger bit. */
      vuint32_t TRG3:1;                /* Trigger bit. */
      vuint32_t TRG2:1;                /* Trigger bit. */
      vuint32_t TRG1:1;                /* Trigger bit. */
      vuint32_t TRG0:1;                /* Trigger bit. */
    } B;
  } CTRG;

  union {                              /* MCS Set Trigger Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TRG15:1;               /* Trigger bit. */
      vuint32_t TRG14:1;               /* Trigger bit. */
      vuint32_t TRG13:1;               /* Trigger bit. */
      vuint32_t TRG12:1;               /* Trigger bit. */
      vuint32_t TRG11:1;               /* Trigger bit. */
      vuint32_t TRG10:1;               /* Trigger bit. */
      vuint32_t TRG9:1;                /* Trigger bit. */
      vuint32_t TRG8:1;                /* Trigger bit. */
      vuint32_t TRG7:1;                /* Trigger bit. */
      vuint32_t TRG6:1;                /* Trigger bit. */
      vuint32_t TRG5:1;                /* Trigger bit. */
      vuint32_t TRG4:1;                /* Trigger bit. */
      vuint32_t TRG3:1;                /* Trigger bit. */
      vuint32_t TRG2:1;                /* Trigger bit. */
      vuint32_t TRG1:1;                /* Trigger bit. */
      vuint32_t TRG0:1;                /* Trigger bit. */
    } B;
  } STRG;

  uint8_t MCS_reserved0[16];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH0_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH0_EIRQ_EN;

  uint8_t MCS_reserved1[28];
  union {                              /* MCS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t RAM_RST:1;             /* RAM reset bit. */
      vuint32_t  :14;
      vuint32_t HLT_SP_OFL:1;          /* Halt on stack pointer overflow. */
      vuint32_t SCHED:1;               /* MCS submodule scheduling scheme. */
    } B;
  } CTRL;

  union {                              /* MCS Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CWT7:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT6:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT5:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT4:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT3:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT2:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT1:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CWT0:1;                /* Cancel WURM instruction for channel. */
      vuint32_t CAT7:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT6:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT5:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT4:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT3:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT2:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT1:1;                /* Cancel ARU transfer for channel. */
      vuint32_t CAT0:1;                /* Cancel ARU transfer for channel. */
      vuint32_t RST7:1;                /* Software reset of channel. */
      vuint32_t RST6:1;                /* Software reset of channel. */
      vuint32_t RST5:1;                /* Software reset of channel. */
      vuint32_t RST4:1;                /* Software reset of channel. */
      vuint32_t RST3:1;                /* Software reset of channel. */
      vuint32_t RST2:1;                /* Software reset of channel. */
      vuint32_t RST1:1;                /* Software reset of channel. */
      vuint32_t RST0:1;                /* Software reset of channel. */
    } B;
  } RST;

  union {                              /* MCS Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t ERR7:1;                /* Error State of MCS-channel. */
      vuint32_t ERR6:1;                /* Error State of MCS-channel. */
      vuint32_t ERR5:1;                /* Error State of MCS-channel. */
      vuint32_t ERR4:1;                /* Error State of MCS-channel. */
      vuint32_t ERR3:1;                /* Error State of MCS-channel. */
      vuint32_t ERR2:1;                /* Error State of MCS-channel. */
      vuint32_t ERR1:1;                /* Error State of MCS-channel. */
      vuint32_t ERR0:1;                /* Error State of MCS-channel. */
    } B;
  } ERR;

  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH1_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH1_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH1_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH1_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH1_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH1_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH1_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH1_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH1_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH1_ACB;

  uint8_t MCS_reserved2[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH1_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH1_EIRQ_EN;

  uint8_t MCS_reserved3[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH2_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH2_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH2_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH2_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH2_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH2_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH2_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH2_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH2_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH2_ACB;

  uint8_t MCS_reserved4[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH2_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH2_EIRQ_EN;

  uint8_t MCS_reserved5[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH3_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH3_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH3_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH3_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH3_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH3_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH3_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH3_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH3_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH3_ACB;

  uint8_t MCS_reserved6[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH3_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH3_EIRQ_EN;

  uint8_t MCS_reserved7[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH4_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH4_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH4_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH4_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH4_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH4_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH4_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH4_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH4_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH4_ACB;

  uint8_t MCS_reserved8[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH4_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH4_EIRQ_EN;

  uint8_t MCS_reserved9[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH5_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH5_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH5_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH5_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH5_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH5_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH5_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH5_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH5_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH5_ACB;

  uint8_t MCS_reserved10[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH5_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH5_EIRQ_EN;

  uint8_t MCS_reserved11[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH6_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH6_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH6_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH6_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH6_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH6_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH6_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH6_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH6_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH6_ACB;

  uint8_t MCS_reserved12[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH6_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH6_EIRQ_EN;

  uint8_t MCS_reserved13[40];
  union {                              /* MCS Channel n General Purpose 0 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R0. */
    } B;
  } CH7_R0;

  union {                              /* MCS Channel n General Purpose 1 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R1. */
    } B;
  } CH7_R1;

  union {                              /* MCS Channel n General Purpose 2 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R2. */
    } B;
  } CH7_R2;

  union {                              /* MCS Channel n General Purpose 3 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R3. */
    } B;
  } CH7_R3;

  union {                              /* MCS Channel n General Purpose 4 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R4. */
    } B;
  } CH7_R4;

  union {                              /* MCS Channel n General Purpose 5 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R5. */
    } B;
  } CH7_R5;

  union {                              /* MCS Channel n General Purpose 6 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R6. */
    } B;
  } CH7_R6;

  union {                              /* MCS Channel n General Purpose 7 Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DATA:24;               /* Data of MCS general purpose register R7. */
    } B;
  } CH7_R7;

  union {                              /* MCS Channel n Control Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SP_CNT:3;              /* Stack pointer counter value. */
      vuint32_t  :5;
      vuint32_t SAT:1;                 /* Successful ARU transfer bit. */
      vuint32_t CWT:1;                 /* Cancel WURM instruction state. */
      vuint32_t CAT:1;                 /* Cancel ARU transfer state. */
      vuint32_t N:1;                   /* Negative bit state. */
      vuint32_t V:1;                   /* Overflow bit state. */
      vuint32_t Z:1;                   /* Zero bit state. */
      vuint32_t CY:1;                  /* Carry bit state. */
      vuint32_t  :1;
      vuint32_t ERR:1;                 /* Error state. */
      vuint32_t IRQ:1;                 /* Interrupt state. */
      vuint32_t EN:1;                  /* Enable MCS-channel. */
    } B;
  } CH7_CTRL;

  union {                              /* MCS Channel n ARU Control Bit Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t ACB4:1;                /* See ACB0. */
      vuint32_t ACB3:1;                /* See ACB0. */
      vuint32_t ACB2:1;                /* See ACB0. */
      vuint32_t ACB1:1;                /* See ACB0. */
      vuint32_t ACB0:1;                /* ARU Control bit[4:0]. */
    } B;
  } CH7_ACB;

  uint8_t MCS_reserved14[24];
  union {                              /* MCS Channel n Program Counter Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t PC:14;                 /* Current Program Counter. */
    } B;
  } CH7_PC;

  union {                              /* MCS Channel n Interrupt Request Notification Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ:1;         /* Memory access out of range in channel n. */
      vuint32_t STK_ERR_IRQ:1;         /* Stack counter overflow/underflow of channel n. */
      vuint32_t MCS_IRQ:1;             /* Interrupt request by MCS-channel n. */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* MCS Channel n Interrupt Request Enable Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_IRQ_EN:1;      /* MCS channel n MEM_ERR_IRQ interrupt enable. */
      vuint32_t STK_ERR_IRQ_EN:1;      /* MCS channel n STK_ERR_IRQ interrupt enable. */
      vuint32_t MCS_IRQ_EN:1;          /* MCS channel n MCS_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* MCS Channel n Force Interrupt Request Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TRG_MEM_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_STK_ERR_IRQ:1;     /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register by software. */
      vuint32_t TRG_MCS_IRQ:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* MCS Channel n Interrupt Request Mode Register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;

  union {                              /* MCS Channel n Error Interrupt Request Enable register, n=0:8 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MEM_ERR_EIRQ_EN:1;     /* MCS[i] channel n MEM_ERR_EIRQ error interrupt enable. */
      vuint32_t STK_ERR_EIRQ_EN:1;     /* MCS[i] channel n STK_ERR_IRQ error interrupt enable. */
      vuint32_t MCS_EIRQ_EN:1;         /* Trigger IRQ bit in MCS_CH_[x]_IRQ_NOTIFY register */
    } B;
  } CH7_EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_MON ============================
   ============================================================================ */

struct GTM_MON_tag {
  union {                              /* Monitor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t MCS6_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS5_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS4_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS3_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS2_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS1_ERR:1;            /* See MCS0_ERR. */
      vuint32_t MCS0_ERR:1;            /* Error detected at corresponding MCS. */
      vuint32_t  :3;
      vuint32_t CMP_ERR:1;             /* Error detected at CMP. */
      vuint32_t  :3;
      vuint32_t ACT_CMUFX4:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX3:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX2:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX1:1;          /* See ACT_CMUFX0. */
      vuint32_t ACT_CMUFX0:1;          /* Corresponding CMU_CLKFX activity. */
      vuint32_t ACT_CMU7:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU6:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU5:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU4:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU3:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU2:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU1:1;            /* See ACT_CMU0. */
      vuint32_t ACT_CMU0:1;            /* Corresponding CMU_CLK activity. */
    } B;
  } STATUS;

  union {                              /* Monitor Acitivity 0 */
    vuint32_t R;
    struct {
      vuint32_t MCA_3_7:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_6:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_5:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_4:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_3:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_2:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_1:1;             /* See MCA_3_0. */
      vuint32_t MCA_3_0:1;             /* Activity of check performed in module MCS[3] at corresponding channel. */
      vuint32_t MCA_2_7:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_6:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_5:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_4:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_3:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_2:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_1:1;             /* See MCA_2_0. */
      vuint32_t MCA_2_0:1;             /* Activity of check performed in module MCS[2] at corresponding channel. */
      vuint32_t MCA_1_7:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_6:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_5:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_4:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_3:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_2:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_1:1;             /* See MCA_1_0. */
      vuint32_t MCA_1_0:1;             /* Activity of check performed in module MCS[1] at corresponding channel. */
      vuint32_t MCA_0_7:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_6:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_5:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_4:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_3:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_2:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_1:1;             /* See MCA_0_0. */
      vuint32_t MCA_0_0:1;             /* Activity of check performed in module MCS[0] at corresponding channel. */
    } B;
  } ACTIVITY_0;

  union {                              /* Monitor Acitivity 1 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t MCA_6_7:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_6:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_5:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_4:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_3:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_2:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_1:1;             /* See MCA_6_0. */
      vuint32_t MCA_6_0:1;             /* Activity of check performed in module MCS[6] at corresponding channel. */
      vuint32_t MCA_5_7:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_6:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_5:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_4:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_3:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_2:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_1:1;             /* See MCA_5_0. */
      vuint32_t MCA_5_0:1;             /* Activity of check performed in module MCS[5] at corresponding channel. */
      vuint32_t MCA_4_7:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_6:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_5:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_4:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_3:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_2:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_1:1;             /* See MCA_4_0. */
      vuint32_t MCA_4_0:1;             /* Activity of check performed in module MCS[4] at corresponding channel. */
    } B;
  } ACTIVITY_1;
};


/* ============================================================================
   =============================== Module: GTM_SPE ============================
   ============================================================================ */

struct GTM_SPE_tag {
  union {                              /* SPE Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t FSOL:8;                /* Fast Shut-Off Level for TOM[i] channel 0 to 7. */
      vuint32_t  :1;
      vuint32_t NIP:3;                 /* New input pattern that was detected. */
      vuint32_t PDIR:1;                /* Previous rotation direction. */
      vuint32_t PIP:3;                 /* Previous input pattern that was detected by a regular input pattern change. */
      vuint32_t ADIR:1;                /* Actual rotation direction. */
      vuint32_t AIP:3;                 /* Actual input pattern that was detected by a regular input pattern change. */
      vuint32_t  :1;
      vuint32_t SPE_PAT_PTR:3;         /* Pattern selector for TOM output signals. */
      vuint32_t FSOM:1;                /* Fast Shut-Off Mode. */
      vuint32_t TIM_SEL:1;             /* Select TIM input signal. */
      vuint32_t TRIG_SEL:2;            /* Select trigger input signal. */
      vuint32_t SIE2:1;                /* SPE Input enable for TIM_CHz(48). */
      vuint32_t SIE1:1;                /* SPE Input enable for TIM_CHy(48). */
      vuint32_t SIE0:1;                /* SPE Input enable for TIM_CHx(48). */
      vuint32_t EN:1;                  /* SPE Submodule enable. */
    } B;
  } CTRL_STAT;

  union {                              /* SPE Input Pattern Register */
    vuint32_t R;
    struct {
      vuint32_t IP7_PAT:3;             /* Input pattern 7. */
      vuint32_t IP7_VAL:1;             /* Input pattern 7 is a valid pattern. */
      vuint32_t IP6_PAT:3;             /* Input pattern 6. */
      vuint32_t IP6_VAL:1;             /* Input pattern 6 is a valid pattern. */
      vuint32_t IP5_PAT:3;             /* Input pattern 5. */
      vuint32_t IP5_VAL:1;             /* Input pattern 5 is a valid pattern. */
      vuint32_t IP4_PAT:3;             /* Input pattern 4. */
      vuint32_t IP4_VAL:1;             /* Input pattern 4 is a valid pattern. */
      vuint32_t IP3_PAT:3;             /* Input pattern 3. */
      vuint32_t IP3_VAL:1;             /* Input pattern 3 is a valid pattern. */
      vuint32_t IP2_PAT:3;             /* Input pattern 2. */
      vuint32_t IP2_VAL:1;             /* Input pattern 2 is a valid pattern. */
      vuint32_t IP1_PAT:3;
      vuint32_t IP1_VAL:1;             /* Input pattern 1 is a valid pattern. */
      vuint32_t IP0_PAT:3;             /* Input pattern 0. */
      vuint32_t IP0_VAL:1;             /* Input pattern 0 is a valid pattern. */
    } B;
  } PAT;

  union {                              /* SPE Output Pattern n Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SPE_OUT_PAT:16;        /* SPE output control value for TOM_CH0 to TOM_CH7 SPE_OUT_PAT[n+1:n] defines output select signal of TOM[i]_CH[n]. */
    } B;
  } OUT_PAT[8];

  union {                              /* SPE Output Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Reserved. */
      vuint32_t SPE_OUT_CTRL:16;       /* SPE output control value for TOM_CH0 to TOM_CH7. */
    } B;
  } OUT_CTRL;

  union {                              /* SPE Interrupt Request Notify Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SPE_RCMP:1;            /* SPE revolution counter match event. */
      vuint32_t SPE_BIS:1;             /* Bouncing input signal detected. */
      vuint32_t SPE_PERR:1;            /* Wrong or invalid pattern detected at input. */
      vuint32_t SPE_DCHG:1;            /* SPE_DIR bit changed on behalf of new input pattern. */
      vuint32_t SPE_NIPD:1;            /* New input pattern interrupt occurred. */
    } B;
  } IRQ_NOTIFY;

  union {                              /* SPE Interrupt Request Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;                  /* Reserved. */
      vuint32_t SPE_RCMP_IRQ_EN:1;     /* SPE_RCMP_IRQ interrupt enable. */
      vuint32_t SPE_BIS_IRQ_EN:1;      /* SPE_BIS_IRQ interrupt enable. */
      vuint32_t SPE_PERR_IRQ_EN:1;     /* SPE_PERR_IRQ interrupt enable. */
      vuint32_t SPE_DCHG_IRQ_EN:1;     /* SPE_DCHG_IRQ interrupt enable. */
      vuint32_t SPE_NIPD_IRQ_EN:1;     /* SPE_NIPD_IRQ interrupt enable. */
    } B;
  } IRQ_EN;

  union {                              /* SPE Interrupt Request Force Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;                  /* Reserved. */
      vuint32_t TRG_SPE_RCMP:1;        /* Force interrupt of SPE_RCMP. */
      vuint32_t TRG_SPE_BIS:1;         /* Force interrupt of SPE_BIS. */
      vuint32_t TRG_SPE_PERR:1;        /* Force interrupt of SPE_PERR. */
      vuint32_t TRG_SPE_DCHG:1;        /* Force interrupt of SPE_DCHG. */
      vuint32_t TRG_SPE_NIPD:1;        /* Force interrupt of SPE_NIPD. */
    } B;
  } IRQ_FORCINT;

  union {                              /* SPE Interrupt Request Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } IRQ_MODE;

  union {                              /* SPE Error Interrupt Request Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t SPE_RCMP_EIRQ_EN:1;    /* SPE_BIS_EIRQ error interrupt enable. */
      vuint32_t SPE_BIS_EIRQ_EN:1;     /* SPE_BIS_EIRQ error interrupt enable. */
      vuint32_t SPE_PERR_EIRQ_EN:1;    /* SPE_PERR_EIRQ interrupt enable. */
      vuint32_t SPE_DCHG_EIRQ_EN:1;
      vuint32_t SPE_NIPD_EIRQ_EN:1;    /* SPE_NIPD_EIRQ interrupt enable. */
    } B;
  } EIRQ_EN;

  union {                              /* SPE Revolution Counter register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t REV_CNT:24;            /* Input signal revolution counter. */
    } B;
  } REV_CNT;

  union {                              /* SPE Revolution Counter Compare register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t REV_CMP:24;            /* Input signal revolution counter compare value. */
    } B;
  } REV_CMP;
};


/* ============================================================================
   =============================== Module: GTM_TBU ============================
   ============================================================================ */

struct GTM_TBU_tag {
  union {                              /* TBU Global Channel Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ENDIS_CH2:2;           /* TBU channel 2 enable/disable control. */
      vuint32_t ENDIS_CH1:2;           /* TBU channel 1 enable/disable control. */
      vuint32_t ENDIS_CH0:2;           /* TBU channel 0 enable/disable control. */
    } B;
  } CHEN;

  union {                              /* TBU Channel 0 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CH_CLK_SRC:3;          /* Clock source for channel 0. */
      vuint32_t LOW_RES:1;             /* TBU_CH0_BASE register resolution. */
    } B;
  } CH0_CTRL;

  union {                              /* TBU Channel 0 Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t BASE:27;               /* Time base value for channel 0. */
    } B;
  } CH0_BASE;

  union {                              /* TBU Channel 1 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CH_CLK_SRC:3;          /* Clock source for channel time base counter. */
      vuint32_t CH_MODE:1;             /* Channel mode. */
    } B;
  } CH1_CTRL;

  union {                              /* TBU Channel 1 Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t BASE:24;               /* Time base value for the channel. */
    } B;
  } CH1_BASE;

  union {                              /* TBU Channel 2 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CH_CLK_SRC:3;          /* Clock source for channel time base counter. */
      vuint32_t CH_MODE:1;             /* Channel mode. */
    } B;
  } CH2_CTRL;

  union {                              /* TBU Channel 2 Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t BASE:24;               /* Time base value for the channel. */
    } B;
  } CH2_BASE;
};


/* ============================================================================
   =============================== Module: GTM_TIM ============================
   ============================================================================ */

struct GTM_TIM_tag {
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH0_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH0_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH0_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH0_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH0_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH0_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH0_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH0_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH0_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH0_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH0_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH0_EIRQ_EN;

  uint8_t TIM_reserved0[56];
  union {                              /* TIM Input Source Register */
    vuint32_t R;
    struct {
      vuint32_t MODE_7:2;              /* Input source to Channel 7 */
      vuint32_t VAL_7:2;               /* Value to be fed to Channel 7 */
      vuint32_t MODE_6:2;              /* Input source to Channel 6 */
      vuint32_t VAL_6:2;               /* Value to be fed to Channel 6 */
      vuint32_t MODE_5:2;              /* Input source to Channel 5 */
      vuint32_t VAL_5:2;               /* Value to be fed to Channel 5 */
      vuint32_t MODE_4:2;              /* Input source to Channel 4 */
      vuint32_t VAL_4:2;               /* Value to be fed to Channel 4 */
      vuint32_t MODE_3:2;              /* Input source to Channel 3 */
      vuint32_t VAL_3:2;               /* Value to be fed to Channel 3 */
      vuint32_t MODE_2:2;              /* Input source to Channel 2 */
      vuint32_t VAL_2:2;               /* Value to be fed to Channel 2 */
      vuint32_t MODE_1:2;              /* Input source to Channel 1 */
      vuint32_t VAL_1:2;               /* Value to be fed to Channel 1 */
      vuint32_t MODE_0:2;              /* Input source to Channel 0 */
      vuint32_t VAL_0:2;               /* Value to be fed to Channel 0 */
    } B;
  } IN_SRC;

  union {                              /* TIM Channel Reset Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RST_CH7:1;             /* Software reset of channel 7. */
      vuint32_t RST_CH6:1;             /* Software reset of channel 6. */
      vuint32_t RST_CH5:1;             /* Software reset of channel 5. */
      vuint32_t RST_CH4:1;             /* Software reset of channel 4. */
      vuint32_t RST_CH3:1;             /* Software reset of channel 3. */
      vuint32_t RST_CH2:1;             /* Software reset of channel 2. */
      vuint32_t RST_CH1:1;             /* Software reset of channel 1. */
      vuint32_t RST_CH0:1;             /* Software reset of channel 0. */
    } B;
  } RST;

  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH1_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH1_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH1_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH1_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH1_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH1_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH1_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH1_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH1_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH1_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH1_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH1_EIRQ_EN;

  uint8_t TIM_reserved1[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH2_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH2_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH2_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH2_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH2_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH2_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH2_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH2_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH2_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH2_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH2_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH2_EIRQ_EN;

  uint8_t TIM_reserved2[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH3_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH3_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH3_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH3_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH3_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH3_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH3_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH3_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH3_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH3_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH3_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH3_EIRQ_EN;

  uint8_t TIM_reserved3[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH4_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH4_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH4_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH4_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH4_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH4_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH4_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH4_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH4_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH4_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH4_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH4_EIRQ_EN;

  uint8_t TIM_reserved4[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH5_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH5_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH5_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH5_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH5_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH5_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH5_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH5_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH5_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH5_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH5_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH5_EIRQ_EN;

  uint8_t TIM_reserved5[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH6_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH6_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH6_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH6_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH6_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH6_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH6_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH6_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH6_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH6_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH6_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH6_EIRQ_EN;

  uint8_t TIM_reserved6[64];
  union {                              /* TIM Channel n General Purpose Register 0, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR0:24;               /* Input signal characteristic parameter 0. */
    } B;
  } CH7_GPR0;

  union {                              /* TIM Channel n General Purpose Register 1, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t GPR1:24;               /* Input signal characteristic parameter 1. */
    } B;
  } CH7_GPR1;

  union {                              /* TIM Channel n Count Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CNT:24;                /* Actual SMU counter value. */
    } B;
  } CH7_CNT;

  union {                              /* TIM Channel n Edge Counter Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ECNT:16;               /* Edge counter. */
    } B;
  } CH7_ECNT;

  union {                              /* TIM Channel n Counter Shadow Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t ECNT:8;                /* Edge counter. */
      vuint32_t CNTS:24;               /* Counter shadow register. */
    } B;
  } CH7_CNTS;

  union {                              /* TIM Channel n TDUC Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TO_CNT:8;              /* Current Timeout value for channel n (n:0...m-1). */
    } B;
  } CH7_TDUC;

  union {                              /* TIM Channel n TDUV Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TCS:3;                 /* Timeout Clock selection. */
      vuint32_t  :20;
      vuint32_t TOV:8;                 /* Time out duration for channel n (n:0...m-1). */
    } B;
  } CH7_TDUV;

  union {                              /* TIM Channel n Filter Parameter 0 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_RE:24;             /* Filter parameter for rising edge. */
    } B;
  } CH7_FLT_RE;

  union {                              /* TIM Channel n Filter Parameter 1 Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t FLT_FE:24;             /* Filter parameter for falling edge. */
    } B;
  } CH7_FLT_FE;

  union {                              /* TIM Channel n Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t TOCTRL:2;              /* Timeout control */
      vuint32_t EGPR1_SEL:1;           /* Extension of GPR1_SEL bit field. */
      vuint32_t EGPR0_SEL:1;           /* Extension of GPR0_SEL bit field. */
      vuint32_t FR_ECNT_OFL:1;         /* Extended Edge counter overflow behavior. */
      vuint32_t CLK_SEL:3;             /* CMU clock source select for channel. */
      vuint32_t FLT_CTR_FE:1;          /* Filter counter mode for falling edge. */
      vuint32_t FLT_MODE_FE:1;         /* Filter mode for falling edge. */
      vuint32_t FLT_CTR_RE:1;          /* Filter counter mode for rising edge. */
      vuint32_t FLT_MODE_RE:1;         /* Filter mode for rising edge. */
      vuint32_t EXT_CAP_EN:1;          /* Enables external capture mode. The selected TIM mode is only sensitive to external capture pulses, the input event changes are ignored. */
      vuint32_t FLT_CNT_FRQ:2;         /* Filter counter frequency select. */
      vuint32_t FLT_EN:1;              /* Filter enable for channel n. */
      vuint32_t ECNT_RESET:1;          /* Enables resetting the ECNT counter in periodic sampling mode. */
      vuint32_t ISL:1;                 /* Ignore Signal Level. */
      vuint32_t DSL:1;                 /* Signal level control. */
      vuint32_t CNTS_SEL:1;            /* Selection for CNTS register. */
      vuint32_t GPR1_SEL:2;            /* Selection for GPR1 register. */
      vuint32_t GPR0_SEL:2;            /* Selection for GPR0 register. */
      vuint32_t TBU0_SEL:1;            /* TBU_TS0 bits input select for TIM_CHn_GPRz (z: 0, 1) */
      vuint32_t CICTRL:1;              /* Channel Input Control. */
      vuint32_t ARU_EN:1;              /* GPR0 and GPR1 register values routed to ARU. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t TIM_MODE:3;            /* TIM channel n mode. */
      vuint32_t TIM_EN:1;              /* TIM channel n enable. */
    } B;
  } CH7_CTRL;

  union {                              /* TIM Channel n External Control Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t EXT_CAP_SRC:3;         /* Defines selected source for triggering the EXT_CAPTURE functionality. */
    } B;
  } CH7_ECTRL;

  union {                              /* TIM Channel n Interrupt Request Notification Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET:1;           /* Glitch detected on channel n. */
      vuint32_t TODET:1;               /* Timeout reached for input signal of channel n. */
      vuint32_t GPROFL:1;              /* GPR0 and GPR1 data overflow, old data not read out before new data has arrived at input pin. */
      vuint32_t CNTOFL:1;              /* SMU CNT counter overflow of channel n. */
      vuint32_t ECNTOFL:1;             /* ECNT counter overflow of channel n. */
      vuint32_t NEWVAL:1;              /* New measurement value detected by in channel n */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* TIM Channel n Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_IRQ_EN:1;    /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_IRQ_EN:1;        /* TIM_TODETn_IRQ interrupt enable. */
      vuint32_t GPROFL_IRQ_EN:1;       /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_IRQ_EN:1;       /* TIM_CNTOFLn_IRQ interrupt enable. */
      vuint32_t ECNTOFL_IRQ_EN:1;      /* TIM_ECNTOFLn_IRQ interrupt enable. */
      vuint32_t NEWVAL_IRQ_EN:1;       /* TIM_NEWVALn_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* TIM Channel n Force Interrupt Request Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TRG_GLITCHDET:1;       /* Trigger bit TIM_CHn_IRQ_NOTIFY[GLITCHDET] by software. */
      vuint32_t TRG_TODET:1;           /* Trigger bit TIM_CHn_IRQ_NOTIFY[TODET] by software. */
      vuint32_t TRG_GPROFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[GPROFL] by software. */
      vuint32_t TRG_CNTOFL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[CNTOFL] by software. */
      vuint32_t TRG_ECNTOFL:1;         /* Trigger bit TIM_CHn_IRQ_NOTIFY[ECNTOFL] by software. */
      vuint32_t TRG_NEWVAL:1;          /* Trigger bit TIM_CHn_IRQ_NOTIFY[NEWVAL] by software. */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* TIM Channel n Interrupt Request Mode Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;

  union {                              /* TIM Channel Error Interrupt Request Enable Register, n=0:7 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t GLITCHDET_EIRQ_EN:1;   /* TIM_GLITCHDETx_IRQ interrupt enable. */
      vuint32_t TODET_EIRQ_EN:1;       /* TIM_TODETx_IRQ interrupt enable. */
      vuint32_t GPROFL_EIRQ_EN:1;      /* TIM_GPROFL_IRQ interrupt enable. */
      vuint32_t CNTOFL_EIRQ_EN:1;      /* TIM_CNTOFLx_IRQ interrupt enable. */
      vuint32_t ECNTOFL_EIRQ_EN:1;     /* TIM_ECNTOFLx_IRQ interrupt enable. */
      vuint32_t NEWVAL_EIRQ_EN:1;      /* TIM_NEWVALx_EIRQ error interrupt enable. */
    } B;
  } CH7_EIRQ_EN;
};


/* ============================================================================
   =============================== Module: GTM_TOM ============================
   ============================================================================ */

struct GTM_TOM_tag {
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH0_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH0_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH0_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH0_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH0_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH0_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH0_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH0_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH0_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH0_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH0_IRQ_MODE;

  uint8_t TOM_reserved0[4];
  union {                              /* TOM TGC0 Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t UPEN_CTRL7:2;          /* TOM channel 7 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL6:2;          /* TOM channel 6 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL5:2;          /* TOM channel 5 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL4:2;          /* TOM channel 4 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL3:2;          /* TOM channel 3 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL2:2;          /* TOM channel 2 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL1:2;          /* TOM channel 1 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL0:2;          /* TOM channel 0 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t RST_CH7:1;             /* Software reset of channel 7. */
      vuint32_t RST_CH6:1;             /* Software reset of channel 6. */
      vuint32_t RST_CH5:1;             /* Software reset of channel 5. */
      vuint32_t RST_CH4:1;             /* Software reset of channel 4. */
      vuint32_t RST_CH3:1;             /* Software reset of channel 3. */
      vuint32_t RST_CH2:1;             /* Software reset of channel 2. */
      vuint32_t RST_CH1:1;             /* Software reset of channel 1. */
      vuint32_t RST_CH0:1;             /* Software reset of channel 0. */
      vuint32_t  :7;
      vuint32_t HOST_TRIG:1;           /* Trigger request signal (see TGC0, TGC1) to update the register ENDIS_STAT and OUTEN_STAT. */
    } B;
  } TGC0_GLB_CTRL;

  union {                              /* TOM TGC0 Action Time Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TBU_SEL:2;             /* Selection of time base used for comparison. */
      vuint32_t TB_TRIG:1;             /* Set trigger request. */
      vuint32_t ACT_TB:24;             /* Specifies the signed compare value with selected signal TBU_TS[n], x=0..2. */
    } B;
  } TGC0_ACT_TB;

  union {                              /* TOM TGC0 Force Update Control Register */
    vuint32_t R;
    struct {
      vuint32_t RSTCN0_CH7:2;          /* Reset CN0 of channel 7 on force update event. */
      vuint32_t RSTCN0_CH6:2;          /* Reset CN0 of channel 6 on force update event. */
      vuint32_t RSTCN0_CH5:2;          /* Reset CN0 of channel 5 on force update event. */
      vuint32_t RSTCN0_CH4:2;          /* Reset CN0 of channel 4 on force update event. */
      vuint32_t RSTCN0_CH3:2;          /* Reset CN0 of channel 3 on force update event. */
      vuint32_t RSTCN0_CH2:2;          /* Reset CN0 of channel 2 on force update event. */
      vuint32_t RSTCN0_CH1:2;          /* Reset CN0 of channel 1 on force update event. */
      vuint32_t RSTCN0_CH0:2;          /* Reset CN0 of channel 0 on force update event. */
      vuint32_t FUPD_CTRL7:2;          /* Force update of TOM channel 7 operation registers. */
      vuint32_t FUPD_CTRL6:2;          /* Force update of TOM channel 6 operation registers, */
      vuint32_t FUPD_CTRL5:2;          /* Force update of TOM channel 5 operation registers. */
      vuint32_t FUPD_CTRL4:2;          /* Force update of TOM channel 4 operation registers. */
      vuint32_t FUPD_CTRL3:2;          /* Force update of TOM channel 3 operation registers. */
      vuint32_t FUPD_CTRL2:2;          /* ce update of TOM channel 2 operation registers. */
      vuint32_t FUPD_CTRL1:2;          /* Force update of TOM channel 1 operation registers. */
      vuint32_t FUPD_CTRL0:2;          /* Force update of TOM channel 0 operation registers. */
    } B;
  } TGC0_FUPD_CTRL;

  union {                              /* TOM TGC0 Interrupt Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INT_TRIG7:2;           /* Select input signal TRIG_7 as a trigger source. */
      vuint32_t INT_TRIG6:2;           /* Select input signal TRIG_6 as a trigger source. */
      vuint32_t INT_TRIG5:2;           /* Select input signal TRIG_5 as a trigger source. */
      vuint32_t INT_TRIG4:2;           /* Select input signal TRIG_4 as a trigger source. */
      vuint32_t INT_TRIG3:2;           /* Select input signal TRIG_3 as a trigger source. */
      vuint32_t INT_TRIG2:2;           /* Select input signal TRIG_2 as a trigger source. */
      vuint32_t INT_TRIG1:2;           /* Select input signal TRIG_1 as a trigger source. */
      vuint32_t INT_TRIG0:2;           /* Select input signal TRIG_0 as a trigger source. */
    } B;
  } TGC0_INT_TRIG;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH1_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH1_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH1_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH1_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH1_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH1_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH1_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH1_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH1_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH1_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH1_IRQ_MODE;

  uint8_t TOM_reserved1[4];
  union {                              /* TOM TGC0 Enable/Disable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_CTRL7:2;         /* Channel 7 enable/disable update value. */
      vuint32_t ENDIS_CTRL6:2;         /* Channel 6 enable/disable update value. */
      vuint32_t ENDIS_CTRL5:2;         /* Channel 5 enable/disable update value. */
      vuint32_t ENDIS_CTRL4:2;         /* TOM channel 4 enable/disable update value. */
      vuint32_t ENDIS_CTRL3:2;         /* TOM channel 3 enable/disable update value. */
      vuint32_t ENDIS_CTRL2:2;         /* TOM channel 2 enable/disable update value. */
      vuint32_t ENDIS_CTRL1:2;         /* TOM channel 1 enable/disable update value. */
      vuint32_t ENDIS_CTRL0:2;         /* TOM channel 0 enable/disable update value. */
    } B;
  } TGC0_ENDIS_CTRL;

  union {                              /* TOM TGC0 Enable/Disable Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_STAT7:2;         /* TOM channel 7 enable/disable. */
      vuint32_t ENDIS_STAT6:2;         /* TOM channel 6 enable/disable. */
      vuint32_t ENDIS_STAT5:2;         /* TOM channel 5 enable/disable. */
      vuint32_t ENDIS_STAT4:2;         /* TOM channel 4 enable/disable. */
      vuint32_t ENDIS_STAT3:2;         /* TOM channel 3 enable/disable. */
      vuint32_t ENDIS_STAT2:2;         /* TOM channel 2 enable/disable. */
      vuint32_t ENDIS_STAT1:2;         /* TOM channel 1 enable/disable. */
      vuint32_t ENDIS_STAT0:2;         /* TOM channel 0 enable/disable. */
    } B;
  } TGC0_ENDIS_STAT;

  union {                              /* TOM TGC0 Out Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_CTRL7:2;         /* Output TOM_OUT(7) enable/disable update value. */
      vuint32_t OUTEN_CTRL6:2;         /* Output TOM_OUT(6) enable/disable update value. */
      vuint32_t OUTEN_CTRL5:2;         /* Output TOM_OUT(5) enable/disable update value. */
      vuint32_t OUTEN_CTRL4:2;         /* Output TOM_OUT(4) enable/disable update value. */
      vuint32_t OUTEN_CTRL3:2;         /* Output TOM_OUT(3) enable/disable update value. */
      vuint32_t OUTEN_CTRL2:2;         /* Output TOM_OUT(2) enable/disable update value. */
      vuint32_t OUTEN_CTRL1:2;         /* Output TOM_OUT(1) enable/disable update value. */
      vuint32_t OUTEN_CTRL0:2;         /* Output TOM_OUT(0) enable/disable update value. */
    } B;
  } TGC0_OUTEN_CTRL;

  union {                              /* TOM TGC0 Out Enable Control/Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_STAT7:2;         /* Control/status of output TOM_OUT(7). */
      vuint32_t OUTEN_STAT6:2;         /* Control/status of output TOM_OUT(6). */
      vuint32_t OUTEN_STAT5:2;         /* Control/status of output TOM_OUT(5). */
      vuint32_t OUTEN_STAT4:2;         /* Control/status of output TOM_OUT(4) */
      vuint32_t OUTEN_STAT3:2;         /* Control/status of output TOM_OUT(3). */
      vuint32_t OUTEN_STAT2:2;         /* Control/status of output TOM_OUT(2). */
      vuint32_t OUTEN_STAT1:2;         /* Control/status of output TOM_OUT(1). */
      vuint32_t OUTEN_STAT0:2;         /* Control/status of output TOM_OUT(0). */
    } B;
  } TGC0_OUTEN_STAT;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH2_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH2_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH2_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH2_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH2_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH2_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH2_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH2_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH2_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH2_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH2_IRQ_MODE;

  uint8_t TOM_reserved2[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH3_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH3_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH3_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH3_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH3_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH3_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH3_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH3_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH3_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH3_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH3_IRQ_MODE;

  uint8_t TOM_reserved3[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH4_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH4_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH4_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH4_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH4_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH4_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH4_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH4_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH4_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH4_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH4_IRQ_MODE;

  uint8_t TOM_reserved4[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH5_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH5_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH5_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH5_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH5_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH5_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH5_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH5_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH5_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH5_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH5_IRQ_MODE;

  uint8_t TOM_reserved5[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH6_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH6_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH6_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH6_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH6_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH6_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH6_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH6_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH6_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH6_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH6_IRQ_MODE;

  uint8_t TOM_reserved6[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH7_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH7_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH7_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH7_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH7_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH7_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH7_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH7_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH7_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH7_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH7_IRQ_MODE;

  uint8_t TOM_reserved7[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH8_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH8_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH8_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH8_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH8_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH8_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH8_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH8_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH8_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH8_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH8_IRQ_MODE;

  uint8_t TOM_reserved8[4];
  union {                              /* TOM TGC1 Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t UPEN_CTRL15:2;         /* TOM channel 15 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL14:2;         /* TOM channel 14 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL13:2;         /* TOM channel 13 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL12:2;         /* TOM channel 12 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL11:2;         /* TOM channel 11 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL10:2;         /* TOM channel 10 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL9:2;          /* TOM channel 9 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t UPEN_CTRL8:2;          /* TOM channel 8 enable update of register CM0, CM1 and CLK_SRC_STAT from SR0, SR1 and CLK_SRC. */
      vuint32_t RST_CH15:1;            /* Software reset of channel 15. */
      vuint32_t RST_CH14:1;            /* Software reset of channel 14. */
      vuint32_t RST_CH13:1;            /* Software reset of channel 13. */
      vuint32_t RST_CH12:1;            /* Software reset of channel 12. */
      vuint32_t RST_CH11:1;            /* Software reset of channel 11. */
      vuint32_t RST_CH10:1;            /* Software reset of channel 10. */
      vuint32_t RST_CH9:1;             /* Software reset of channel 9. */
      vuint32_t RST_CH8:1;             /* Software reset of channel 8. */
      vuint32_t  :7;
      vuint32_t HOST_TRIG:1;           /* Trigger request signal (see TGC0, TGC1) to update the register ENDIS_STAT and OUTEN_STAT. */
    } B;
  } TGC1_GLB_CTRL;

  union {                              /* TOM TGC1 Action Time Base Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TBU_SEL:2;             /* Selection of time base used for comparison. */
      vuint32_t TB_TRIG:1;             /* Set trigger request. */
      vuint32_t ACT_TB:24;             /* Specifies the signed compare value with selected signal TBU_TS[n], x=0..2. */
    } B;
  } TGC1_ACT_TB;

  union {                              /* TOM TGC1 Force Update Control Register */
    vuint32_t R;
    struct {
      vuint32_t RSTCN0_CH15:2;         /* Reset CN0 of channel 15 on force update event. */
      vuint32_t RSTCN0_CH14:2;         /* Reset CN0 of channel 14 on force update event. */
      vuint32_t RSTCN0_CH13:2;         /* Reset CN0 of channel 13 on force update event. */
      vuint32_t RSTCN0_CH12:2;         /* Reset CN0 of channel 12 on force update event. */
      vuint32_t RSTCN0_CH11:2;         /* Reset CN0 of channel 11 on force update event. */
      vuint32_t RSTCN0_CH10:2;         /* Reset CN0 of channel 10 on force update event. */
      vuint32_t RSTCN0_CH9:2;          /* Reset CN0 of channel 9 on force update event. */
      vuint32_t RSTCN0_CH8:2;          /* Reset CN0 of channel 8 on force update event. */
      vuint32_t FUPD_CTRL15:2;         /* Force update of TOM channel 15 operation registers. */
      vuint32_t FUPD_CTRL14:2;         /* Force update of TOM channel 14 operation registers, */
      vuint32_t FUPD_CTRL13:2;         /* Force update of TOM channel 13 operation registers. */
      vuint32_t FUPD_CTRL12:2;         /* Force update of TOM channel 12 operation registers. */
      vuint32_t FUPD_CTRL11:2;         /* Force update of TOM channel 11 operation registers. */
      vuint32_t FUPD_CTRL10:2;         /* ce update of TOM channel 10 operation registers. */
      vuint32_t FUPD_CTRL9:2;          /* Force update of TOM channel 9 operation registers. */
      vuint32_t FUPD_CTRL8:2;          /* Force update of TOM channel 8 operation registers. */
    } B;
  } TGC1_FUPD_CTRL;

  union {                              /* TOM TGC1 Interrupt Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INT_TRIG15:2;          /* Select input signal TRIG_15 as a trigger source. */
      vuint32_t INT_TRIG14:2;          /* Select input signal TRIG_14 as a trigger source. */
      vuint32_t INT_TRIG13:2;          /* Select input signal TRIG_13as a trigger source. */
      vuint32_t INT_TRIG12:2;          /* Select input signal TRIG_12 as a trigger source. */
      vuint32_t INT_TRIG11:2;          /* Select input signal TRIG_1 as a trigger source. */
      vuint32_t INT_TRIG10:2;          /* Select input signal TRIG_10 as a trigger source. */
      vuint32_t INT_TRIG9:2;           /* Select input signal TRIG_9 as a trigger source. */
      vuint32_t INT_TRIG8:2;           /* Select input signal TRIG_8 as a trigger source. */
    } B;
  } TGC1_INT_TRIG;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH9_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH9_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH9_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH9_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH9_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH9_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH9_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH9_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH9_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH9_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH9_IRQ_MODE;

  uint8_t TOM_reserved9[4];
  union {                              /* TOM TGC1 Enable/Disable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_CTRL15:2;        /* Channel 15 enable/disable update value. */
      vuint32_t ENDIS_CTRL14:2;        /* Channel 14 enable/disable update value. */
      vuint32_t ENDIS_CTRL13:2;        /* Channel 13 enable/disable update value. */
      vuint32_t ENDIS_CTRL12:2;        /* TOM channel 12 enable/disable update value. */
      vuint32_t ENDIS_CTRL11:2;        /* TOM channel 11 enable/disable update value. */
      vuint32_t ENDIS_CTRL10:2;        /* TOM channel 10 enable/disable update value. */
      vuint32_t ENDIS_CTRL9:2;         /* TOM channel 9 enable/disable update value. */
      vuint32_t ENDIS_CTRL8:2;         /* TOM channel 8 enable/disable update value. */
    } B;
  } TGC1_ENDIS_CTRL;

  union {                              /* TOM TGC1 Enable/Disable Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ENDIS_STAT15:2;        /* TOM channel 15 enable/disable. */
      vuint32_t ENDIS_STAT14:2;        /* TOM channel 14 enable/disable. */
      vuint32_t ENDIS_STAT13:2;        /* TOM channel 13 enable/disable. */
      vuint32_t ENDIS_STAT12:2;        /* TOM channel 12 enable/disable. */
      vuint32_t ENDIS_STAT11:2;        /* TOM channel 11 enable/disable. */
      vuint32_t ENDIS_STAT10:2;        /* TOM channel 10 enable/disable. */
      vuint32_t ENDIS_STAT9:2;         /* TOM channel 9 enable/disable. */
      vuint32_t ENDIS_STAT8:2;         /* TOM channel 8 enable/disable. */
    } B;
  } TGC1_ENDIS_STAT;

  union {                              /* TOM TGC1 Out Enable Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_CTRL15:2;        /* Output TOM_OUT(15) enable/disable update value. */
      vuint32_t OUTEN_CTRL14:2;        /* Output TOM_OUT(14) enable/disable update value. */
      vuint32_t OUTEN_CTRL13:2;        /* Output TOM_OUT(13) enable/disable update value. */
      vuint32_t OUTEN_CTRL12:2;        /* Output TOM_OUT(12) enable/disable update value. */
      vuint32_t OUTEN_CTRL11:2;        /* Output TOM_OUT(11) enable/disable update value. */
      vuint32_t OUTEN_CTRL10:2;        /* Output TOM_OUT(10) enable/disable update value. */
      vuint32_t OUTEN_CTRL9:2;         /* Output TOM_OUT(9) enable/disable update value. */
      vuint32_t OUTEN_CTRL8:2;         /* Output TOM_OUT(8) enable/disable update value. */
    } B;
  } TGC1_OUTEN_CTRL;

  union {                              /* TOM TGC1 Out Enable Control/Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OUTEN_STAT15:2;        /* Control/status of output TOM_OUT(15). */
      vuint32_t OUTEN_STAT14:2;        /* Control/status of output TOM_OUT(14). */
      vuint32_t OUTEN_STAT13:2;        /* Control/status of output TOM_OUT(13). */
      vuint32_t OUTEN_STAT12:2;        /* Control/status of output TOM_OUT(12) */
      vuint32_t OUTEN_STAT11:2;        /* Control/status of output TOM_OUT(11). */
      vuint32_t OUTEN_STAT10:2;        /* Control/status of output TOM_OUT(10). */
      vuint32_t OUTEN_STAT9:2;         /* Control/status of output TOM_OUT(9). */
      vuint32_t OUTEN_STAT8:2;         /* Control/status of output TOM_OUT(8). */
    } B;
  } TGC1_OUTEN_STAT;

  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH10_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH10_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH10_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH10_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH10_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH10_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH10_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH10_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH10_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH10_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH10_IRQ_MODE;

  uint8_t TOM_reserved10[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH11_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH11_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH11_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH11_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH11_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH11_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH11_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH11_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH11_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH11_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH11_IRQ_MODE;

  uint8_t TOM_reserved11[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH12_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH12_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH12_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH12_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH12_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH12_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH12_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH12_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH12_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH12_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH12_IRQ_MODE;

  uint8_t TOM_reserved12[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH13_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH13_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH13_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH13_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH13_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH13_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH13_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH13_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH13_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH13_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH13_IRQ_MODE;

  uint8_t TOM_reserved13[20];
  union {                              /* TOM Channel n Control Register, n[0:14] */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t GCM:1;                 /* Gated Counter Mode enable. */
      vuint32_t SPEM:1;                /* SPE mode enable for channel. */
      vuint32_t  :1;
      vuint32_t OSM:1;                 /* One-shot mode.. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_[n]) of module TOM_CH[n]. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH14_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH14_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH14_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH14_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH14_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH14_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH14_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH14_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH14_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH14_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH14_IRQ_MODE;

  uint8_t TOM_reserved14[20];
  union {                              /* TOM Channel 15 Control register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t BITREV:1;              /* Bit-reversing of output of counter register CN0.. */
      vuint32_t OSM:1;                 /* One-shot mode. */
      vuint32_t  :1;
      vuint32_t TRIGOUT:1;             /* Trigger output selection (output signal TRIG_15) of module TOM_CH15. */
      vuint32_t  :3;
      vuint32_t RST_CCU0:1;            /* Reset source of CCU0. */
      vuint32_t  :5;
      vuint32_t CLK_SRC_SR:3;          /* Clock source select for channel. */
      vuint32_t SL:1;                  /* Signal level for duty cycle. */
      vuint32_t  :11;
    } B;
  } CH15_CTRL;

  union {                              /* TOM Channel n Shadow 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR0:16;                /* TOM channel n shadow register SR0 for update of compare register CM0. */
    } B;
  } CH15_SR0;

  union {                              /* TOM Channel n Shadow 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SR1:16;                /* TOM channel n shadow register SR1 for update of compare register CM1. */
    } B;
  } CH15_SR1;

  union {                              /* TOM Channel n Compare 0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM0:16;                /* TOM CCU0 compare register. */
    } B;
  } CH15_CM0;

  union {                              /* TOM Channel n Compare 1 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CM1:16;                /* TOM CCU1 compare register. */
    } B;
  } CH15_CM1;

  union {                              /* TOM Channel n CN0 Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CN0:16;                /* TOM CCU0 counter register. */
    } B;
  } CH15_CN0;

  union {                              /* TOM Channel n Status Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :31;                  /* Reserved. */
      vuint32_t OL:1;                  /* Output level of output TOM_OUT(n). */
    } B;
  } CH15_STAT;

  union {                              /* TOM Channel n Interrupt Request Notification Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC:1;              /* CCU1 Trigger condition interrupt for channel n. */
      vuint32_t CCU0TC:1;              /* CCU0 Trigger condition interrupt for channel n. */
    } B;
  } CH15_IRQ_NOTIFY;

  union {                              /* TOM Channel n Interrupt Request Enable Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t CCU1TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
      vuint32_t CCU0TC_IRQ_EN:1;       /* TOM_CCU0TC_IRQ interrupt enable. */
    } B;
  } CH15_IRQ_EN;

  union {                              /* TOM Channel n Force Interrupt Request Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;                  /* Reserved. */
      vuint32_t TRG_CCU1TC0:1;         /* Trigger TOM_CCU1TC0_IRQ interrupt by software. */
      vuint32_t TRG_CCU0TC0:1;         /* Trigger TOM_CCU0TC0_IRQ interrupt by software. */
    } B;
  } CH15_IRQ_FORCINT;

  union {                              /* TOM Channel n Interrupt Request Mode Register, n[0:15] */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t IRQ_MODE:2;            /* IRQ mode selection. */
    } B;
  } CH15_IRQ_MODE;
};


/* ============================================================================
   =============================== Module: I2C ================================
   ============================================================================ */

struct I2C_tag {
  union {                              /* I2C Bus Address Register */
    vuint8_t R;
    struct {
      vuint8_t ADR:7;
      vuint8_t  :1;
    } B;
  } IBAD;

  union {                              /* I2C Bus Frequency Divider Register */
    vuint8_t R;
    struct {
      vuint8_t IBC:8;
    } B;
  } IBFD;

  union {                              /* I2C Bus Control Register */
    vuint8_t R;
    struct {
      vuint8_t MDIS:1;
      vuint8_t IBIE:1;
      vuint8_t MSSL:1;
      vuint8_t TXRX:1;
      vuint8_t NOACK:1;
      vuint8_t RSTA:1;
      vuint8_t DMAEN:1;
      vuint8_t  :1;
    } B;
  } IBCR;

  union {                              /* I2C Bus Status Register */
    vuint8_t R;
    struct {
      vuint8_t TCF:1;
      vuint8_t IAAS:1;
      vuint8_t IBB:1;
      vuint8_t IBAL:1;
      vuint8_t  :1;
      vuint8_t SRW:1;
      vuint8_t IBIF:1;
      vuint8_t RXAK:1;
    } B;
  } IBSR;

  union {                              /* I2C Bus Data I/O Register */
    vuint8_t R;
    struct {
      vuint8_t DATA:8;
    } B;
  } IBDR;

  union {                              /* I2C Bus Interrupt Config Register */
    vuint8_t R;
    struct {
      vuint8_t BIIE:1;
      vuint8_t  :7;
    } B;
  } IBIC;

  union {                              /* I2C Bus Debug Register */
    vuint8_t R;
    struct {
      vuint8_t  :6;
      vuint8_t IPG_DEBUG_HALTED:1;
      vuint8_t IPG_DEBUG_EN:1;
    } B;
  } IBDBG;
};


/* ============================================================================
   =============================== Module: IMA ================================
   ============================================================================ */

struct IMA_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t READ:1;
    } B;
  } CTRL;

  union {                              /* Enable Access Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t EN:1;
    } B;
  } ENABLE;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t WRITE_LOCK:1;
      vuint32_t  :7;
      vuint32_t READ_LOCK:1;
    } B;
  } STATUS;

  union {                              /* RAM Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ROW_SLCT:13;
      vuint32_t  :10;
      vuint32_t ARRAY_SLCT:6;
    } B;
  } SLCT;

  union {                              /* Write Unlock Register */
    vuint32_t R;
    struct {
      vuint32_t WRITE_KEY:32;
    } B;
  } WRITE_UNLOCK;

  union {                              /* Read Unlock Register */
    vuint32_t R;
    struct {
      vuint32_t READ_KEY:32;
    } B;
  } READ_UNLOCK;

  uint8_t IMA_reserved0[20];
  union {                              /* RAM Write Data Register 4 */
    vuint32_t R;
    struct {
      vuint32_t WRITE_4:32;
    } B;
  } WRITE_DATA_4;

  union {                              /* RAM Write Data Register 3 */
    vuint32_t R;
    struct {
      vuint32_t WRITE_3:32;
    } B;
  } WRITE_DATA_3;

  union {                              /* RAM Write Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t WRITE_2:32;
    } B;
  } WRITE_DATA_2;

  union {                              /* RAM Write Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t WRITE_1:32;
    } B;
  } WRITE_DATA_1;

  union {                              /* RAM Write Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t WRITE_0:32;
    } B;
  } WRITE_DATA_0;

  uint8_t IMA_reserved1[12];
  union {                              /* RAM Read Data Register 4 */
    vuint32_t R;
    struct {
      vuint32_t READ_4:32;
    } B;
  } READ_DATA_4;

  union {                              /* RAM Read Data Register 3 */
    vuint32_t R;
    struct {
      vuint32_t READ_3:32;
    } B;
  } READ_DATA_3;

  union {                              /* RAM Read Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t READ_2:32;
    } B;
  } READ_DATA_2;

  union {                              /* RAM Read Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t READ_1:32;
    } B;
  } READ_DATA_1;

  union {                              /* RAM Read Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t READ_0:32;
    } B;
  } READ_DATA_0;
};


/* ============================================================================
   =============================== Module: INTC ===============================
   ============================================================================ */

struct INTC_tag {
  union {                              /* INTC Block Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t HVEN3:1;
      vuint32_t  :3;
      vuint32_t HVEN2:1;
      vuint32_t  :3;
      vuint32_t HVEN1:1;
      vuint32_t  :3;
      vuint32_t HVEN0:1;
    } B;
  } BCR;

  union {                              /* INTC Master Protection Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ID:2;
      vuint32_t  :3;
      vuint32_t MPROT:1;
    } B;
  } MPROT;

  uint8_t INTC_reserved0[8];
  union {                              /* INTC Current Priority Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t PRI:6;
    } B;
  } CPR[4];

  union {                              /* INTC Interrupt Acknowledge Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t VTBA:20;
      vuint32_t INTVEC:10;
      vuint32_t  :2;
    } B;
  } IACKR[4];

  union {                              /* INTC End Of Interrupt Register for Processor n */
    vuint32_t R;
    struct {
      vuint32_t EOI:32;
    } B;
  } EOIR[4];

  union {                              /* INTC Software Set/Clear Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t  :6;
      vuint8_t SET:1;
      vuint8_t CLR:1;
    } B;
  } SSCIR[32];

  union {                              /* INTC Priority Select Register */
    vuint16_t R;
    struct {
      vuint16_t PRC_SELN:4;
      vuint16_t  :3;
      vuint16_t SWTN:1;
      vuint16_t  :2;
      vuint16_t PRIN:6;
    } B;
  } PSR[1024];
};


/* ============================================================================
   =============================== Module: IRCOSC =============================
   ============================================================================ */

struct IRCOSC_tag {
  union {                              /* IRCOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t  :1;
      vuint32_t  :3;
      vuint32_t USER_TRIM:5;
      vuint32_t  :3;
      vuint32_t  :5;
      vuint32_t  :2;
      vuint32_t  :1;
      vuint32_t  :5;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: JDC ================================
   ============================================================================ */

struct JDC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t JIN_IEN:1;
      vuint32_t  :15;
      vuint32_t JOUT_IEN:1;
    } B;
  } MCR;

  union {                              /* Module Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t JIN_RDY:1;
      vuint32_t  :1;
      vuint32_t JIN_INT:1;
      vuint32_t  :13;
      vuint32_t JOUT_RDY:1;
      vuint32_t  :1;
      vuint32_t JOUT_INT:1;
    } B;
  } MSR;

  union {                              /* JTAG Output Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JOUT_IPS;

  union {                              /* JTAG Input Data Register */
    vuint32_t R;
    struct {
      vuint32_t Data:32;
    } B;
  } JIN_IPS;
};


/* ============================================================================
   =============================== Module: JTAGM ==============================
   ============================================================================ */

struct JTAGM_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t SWRESET:1;
      vuint32_t evto0_sense:2;
      vuint32_t evto1_sense:2;
      vuint32_t evto_IE:1;
      vuint32_t evti0_assert:1;
      vuint32_t evti1_assert:1;
      vuint32_t  :10;
      vuint32_t inter_jtag_frame_timer:6;
      vuint32_t  :1;
      vuint32_t SIE:1;
      vuint32_t IIE:1;
      vuint32_t TCKSEL:3;
      vuint32_t jtagm_JCOMP:1;
      vuint32_t DTM:1;
    } B;
  } MCR;

  union {                              /* Status Register */
    vuint32_t R;
    struct {
      vuint32_t Overrun:1;
      vuint32_t  :1;
      vuint32_t TXGOOD:1;
      vuint32_t TXERROR:1;
      vuint32_t RXOVFL:1;
      vuint32_t INVFPS:1;
      vuint32_t INVICLC:1;
      vuint32_t ILLLCT:1;
      vuint32_t  :1;
      vuint32_t LVDSEN:1;
      vuint32_t JTAGEN:1;
      vuint32_t LVDSSAFE:1;
      vuint32_t JTAGSAFE:1;
      vuint32_t LVDSESC:1;
      vuint32_t LFASTEN:1;
      vuint32_t TOOL:1;
      vuint32_t evto0_edge:1;
      vuint32_t evto1_edge:1;
      vuint32_t SPU_INT_CLR:1;
      vuint32_t SPU_INT:1;
      vuint32_t CRC_err:1;
      vuint32_t Nexus_err:1;
      vuint32_t Idle:1;
      vuint32_t NR:1;
      vuint32_t CRC:8;
    } B;
  } SR;

  union {                              /* Data Out Register 0 */
    vuint32_t R;
    struct {
      vuint32_t TMS_HIGH:32;
    } B;
  } DOR0;

  union {                              /* Data Out Register 1 */
    vuint32_t R;
    struct {
      vuint32_t TMS_LOW:28;
      vuint32_t  :4;
    } B;
  } DOR1;

  union {                              /* Data Out Register 2 */
    vuint32_t R;
    struct {
      vuint32_t TDI_HIGH:32;
    } B;
  } DOR2;

  union {                              /* Data Out Register 3 */
    vuint32_t R;
    struct {
      vuint32_t TDI_LOW:28;
      vuint32_t  :3;
      vuint32_t Send:1;
    } B;
  } DOR3;

  union {                              /* Receive CRC Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CRC:8;
    } B;
  } RxCRC;

  union {                              /* Data Input Register 0 */
    vuint32_t R;
    struct {
      vuint32_t TDO_LOW:32;
    } B;
  } DIR0;

  union {                              /* Data Input Register 1 */
    vuint32_t R;
    struct {
      vuint32_t TDO_HIGH:28;
      vuint32_t  :4;
    } B;
  } DIR1;
};


/* ============================================================================
   =============================== Module: LFAST ==============================
   ============================================================================ */

struct LFAST_tag {
  union {                              /* LFAST Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t MSEN:1;
      vuint32_t  :6;
      vuint32_t IPGDBG:1;
      vuint32_t  :7;
      vuint32_t LSSEL:1;
      vuint32_t DRFEN:1;
      vuint32_t RXEN:1;
      vuint32_t TXEN:1;
      vuint32_t  :8;
      vuint32_t TXARBD:1;
      vuint32_t CTSEN:1;
      vuint32_t  :1;
      vuint32_t DRFRST:1;
      vuint32_t DATAEN:1;
    } B;
  } MCR;

  union {                              /* LFAST Speed Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t DRMD:1;
      vuint32_t  :7;
      vuint32_t RDR:1;
      vuint32_t  :7;
      vuint32_t TDR:1;
    } B;
  } SCR;

  union {                              /* LFAST Correlator Control Register */
    vuint32_t R;
    struct {
      vuint32_t SMPSEL:8;
      vuint32_t  :6;
      vuint32_t  :2;
      vuint32_t  :12;
      vuint32_t CORRTH:3;
      vuint32_t PHSSEL:1;
    } B;
  } COCR;

  union {                              /* LFAST Test Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t CLKTST:1;
      vuint32_t LPON:1;
      vuint32_t  :5;
      vuint32_t LPMOD:3;
      vuint32_t LPFRMTH:16;
    } B;
  } TMCR;

  union {                              /* LFAST Auto Loopback Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t LPCNTEN:1;
      vuint32_t LPFMCNT:16;
    } B;
  } ALCR;

  union {                              /* LFAST Rate Change Delay Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DRCNT:4;
      vuint32_t  :16;
    } B;
  } RCDCR;

  union {                              /* LFAST Wakeup Delay Control Register */
    vuint32_t R;
    struct {
      vuint32_t HSCNT:8;
      vuint32_t  :4;
      vuint32_t LSCNT:4;
      vuint32_t HWKCNT:8;
      vuint32_t  :4;
      vuint32_t LWKCNT:4;
    } B;
  } SLCR;

  union {                              /* LFAST ICLC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t ICLCSEQ:1;
      vuint32_t SNDICLC:1;
      vuint32_t  :8;
      vuint32_t ICLCPLD:8;
    } B;
  } ICR;

  union {                              /* LFAST Ping Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t PNGREQ:1;
      vuint32_t PNGAUTO:1;
      vuint32_t  :7;
      vuint32_t PNGPYLD:8;
    } B;
  } PICR;

  uint8_t LFAST_reserved0[8];
  union {                              /* LFAST Rx FIFO CTS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t RCTSMX:6;
      vuint32_t  :10;
      vuint32_t RCTSMN:6;
    } B;
  } RFCR;

  union {                              /* LFAST Tx Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t TXIIE:1;
      vuint32_t TXOVIE:1;
      vuint32_t  :11;
      vuint32_t TXPNGIE:1;
      vuint32_t  :1;
      vuint32_t TXUNSIE:1;
      vuint32_t TXICLCIE:1;
      vuint32_t TXDTIE:1;
    } B;
  } TIER;

  union {                              /* LFAST Rx Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RXUOIE:1;
      vuint32_t RXMNIE:1;
      vuint32_t RXMXIE:1;
      vuint32_t RXUFIE:1;
      vuint32_t RXOFIE:1;
      vuint32_t RXSZIE:1;
      vuint32_t RXICIE:1;
      vuint32_t RXLCEIE:1;
      vuint32_t  :12;
      vuint32_t RXCTSIE:1;
      vuint32_t RXDIE:1;
      vuint32_t RXUNSIE:1;
      vuint32_t  :1;
    } B;
  } RIER;

  union {                              /* LFAST Rx ICLC Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t ICPFIE:1;
      vuint32_t ICPSIE:1;
      vuint32_t ICPRIE:1;
      vuint32_t ICTOIE:1;
      vuint32_t ICLPIE:1;
      vuint32_t ICCTIE:1;
      vuint32_t ICTDIE:1;
      vuint32_t ICTEIE:1;
      vuint32_t ICRFIE:1;
      vuint32_t ICRSIE:1;
      vuint32_t ICTFIE:1;
      vuint32_t ICTSIE:1;
      vuint32_t ICPOFIE:1;
      vuint32_t ICPONIE:1;
    } B;
  } RIIER;

  union {                              /* LFAST PLL Control Register */
    vuint32_t R;
    struct {
      vuint32_t IPTMOD:3;
      vuint32_t  :11;
      vuint32_t SWPOFF:1;
      vuint32_t SWPON:1;
      vuint32_t REFINV:1;
      vuint32_t LPCFG:2;
      vuint32_t  :2;
      vuint32_t PLCKCW:2;
      vuint32_t FDIVEN:1;
      vuint32_t FBDIV:6;
      vuint32_t PREDIV:2;
    } B;
  } PLLCR;

  union {                              /* LFAST LVDS Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t SWWKLD:1;
      vuint32_t SWSLPLD:1;
      vuint32_t SWWKLR:1;
      vuint32_t SWSLPLR:1;
      vuint32_t SWOFFLD:1;
      vuint32_t SWONLD:1;
      vuint32_t SWOFFLR:1;
      vuint32_t SWONLR:1;
      vuint32_t LVRXOFF:1;
      vuint32_t LVTXOE:1;
      vuint32_t TXCMUX:1;
      vuint32_t LVRFEN:1;
      vuint32_t LVLPEN:1;              /* Tx LVDS internal loopback enable */
      vuint32_t  :5;
      vuint32_t LVRXOP:3;
      vuint32_t LVTXOP:1;
      vuint32_t LVCKSS:1;
      vuint32_t LVCKP:1;
    } B;
  } LCR;

  union {                              /* LFAST Unsolicited Tx Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t USNDRQ:1;
      vuint32_t  :9;
      vuint32_t UNSHDR:7;
    } B;
  } UNSTCR;

  union {                              /* LFAST Unsolicited Tx Data Registers */
    vuint32_t R;
    struct {
      vuint32_t UNTXD:32;
    } B;
  } UNSTDR[9];

  uint8_t LFAST_reserved1[20];
  union {                              /* LFAST Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t DUALMD:1;
      vuint32_t  :12;
      vuint32_t LRMD:1;
      vuint32_t LDSM:1;
      vuint32_t DRSM:1;
      vuint32_t  :11;
      vuint32_t LPTXDN:1;
      vuint32_t LPFPDV:1;
      vuint32_t LPCPDV:1;
      vuint32_t LPCHDV:1;
      vuint32_t LPCSDV:1;
    } B;
  } GSR;

  union {                              /* LFAST Ping Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RXPNGD:8;
    } B;
  } PISR;

  uint8_t LFAST_reserved2[12];
  union {                              /* LFAST Data Frame Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t RXDCNT:6;
      vuint32_t  :5;
      vuint32_t RXFCNT:3;
      vuint32_t  :2;
      vuint32_t TXDCNT:6;
      vuint32_t  :5;
      vuint32_t TXFCNT:3;
    } B;
  } DFSR;

  union {                              /* LFAST Tx Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t TXIEF:1;
      vuint32_t TXOVF:1;
      vuint32_t  :11;
      vuint32_t TXPNGF:1;
      vuint32_t  :1;
      vuint32_t TXUNSF:1;
      vuint32_t TXICLCF:1;
      vuint32_t TXDTF:1;
    } B;
  } TISR;

  union {                              /* LFAST Rx Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t RXUOF:1;
      vuint32_t RXMNF:1;
      vuint32_t RXMXF:1;
      vuint32_t RXUFF:1;
      vuint32_t RXOFF:1;
      vuint32_t RXSZF:1;
      vuint32_t RXICF:1;
      vuint32_t RXLCEF:1;
      vuint32_t  :12;
      vuint32_t RXCTSF:1;
      vuint32_t RXDF:1;
      vuint32_t RXUNSF:1;
      vuint32_t  :1;
    } B;
  } RISR;

  union {                              /* LFAST Rx ICLC Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t ICPFF:1;
      vuint32_t ICPSF:1;
      vuint32_t ICPRF:1;
      vuint32_t ICTOF:1;
      vuint32_t ICLPF:1;
      vuint32_t ICCTF:1;
      vuint32_t ICTDF:1;
      vuint32_t ICTEF:1;
      vuint32_t ICRFF:1;
      vuint32_t ICRSF:1;
      vuint32_t ICTFF:1;
      vuint32_t ICTSF:1;
      vuint32_t ICPOFF:1;
      vuint32_t ICPONF:1;
    } B;
  } RIISR;

  union {                              /* LFAST PLL and LVDS Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t PLLDIS:1;
      vuint32_t PLDCR:1;
      vuint32_t  :12;
      vuint32_t LRSLPS:1;
      vuint32_t LDSLPS:1;
      vuint32_t LDPDS:1;
      vuint32_t LRPDS:1;
    } B;
  } PLLLSR;

  union {                              /* LFAST Unsolicited Rx Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t URXDV:1;
      vuint32_t  :5;
      vuint32_t URPCNT:3;
    } B;
  } UNSRSR;

  union {                              /* LFAST Unsolicited Rx Data Register */
    vuint32_t R;
    struct {
      vuint32_t UNRXD:32;
    } B;
  } UNSRDR[9];
};


/* ============================================================================
   =============================== Module: LINFlexD ===========================
   ============================================================================ */

struct LINFlexD_tag {
  union {                              /* LIN Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CCD:1;
      vuint32_t CFD:1;
      vuint32_t LASE:1;
      vuint32_t AUTOWU:1;
      vuint32_t MBL:4;
      vuint32_t BF:1;
      vuint32_t  :1;
      vuint32_t LBKM:1;
      vuint32_t MME:1;
      vuint32_t SSBL:1;
      vuint32_t RBLM:1;
      vuint32_t SLEEP:1;
      vuint32_t INIT:1;
    } B;
  } LINCR1;

  union {                              /* LIN Interrupt enable register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZIE:1;
      vuint32_t OCIE:1;
      vuint32_t BEIE:1;
      vuint32_t CEIE:1;
      vuint32_t HEIE:1;
      vuint32_t  :2;
      vuint32_t FEIE:1;
      vuint32_t BOIE:1;
      vuint32_t LSIE:1;
      vuint32_t WUIE:1;
      vuint32_t DBFIE:1;
      vuint32_t DBEIETOIE:1;
      vuint32_t DRIE:1;
      vuint32_t DTIE:1;
      vuint32_t HRIE:1;
    } B;
  } LINIER;

  union {                              /* LIN Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t AUTOSYNC_COMP:1;
      vuint32_t RDC:3;
      vuint32_t LINS:4;                /* LIN state */
      vuint32_t  :2;
      vuint32_t RMB:1;
      vuint32_t DRBNE:1;
      vuint32_t RXbusy:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t DBFF:1;
      vuint32_t DBEF:1;
      vuint32_t DRF:1;
      vuint32_t DTF:1;
      vuint32_t HRF:1;
    } B;
  } LINSR;

  union {                              /* LIN Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t BEF:1;
      vuint32_t CEF:1;
      vuint32_t SFEF:1;
      vuint32_t SDEF:1;
      vuint32_t IDPEF:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t  :6;
      vuint32_t NF:1;
    } B;
  } LINESR;

  union {                              /* UART Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t MIS:1;
      vuint32_t CSP:3;
      vuint32_t OSR:4;
      vuint32_t ROSE:1;
      vuint32_t NEF:3;
      vuint32_t DTU_PCETX:1;           /* Disable Timeout in UART mode/Parity transmission and checking */
      vuint32_t SBUR:2;
      vuint32_t WLS:1;
      vuint32_t TDFL_TFC:3;
      vuint32_t RDFL_RFC:3;
      vuint32_t RFBM:1;
      vuint32_t TFBM:1;
      vuint32_t WL1:1;
      vuint32_t PC1:1;
      vuint32_t RxEn:1;
      vuint32_t TxEn:1;
      vuint32_t PC0:1;
      vuint32_t PCE:1;
      vuint32_t WL0:1;
      vuint32_t UART:1;
    } B;
  } UARTCR;

  union {                              /* UART Mode Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t PE:4;
      vuint32_t RMB:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t RFNE:1;
      vuint32_t TO:1;
      vuint32_t DRFRFE:1;
      vuint32_t DTFTFF:1;
      vuint32_t NF:1;
    } B;
  } UARTSR;

  union {                              /* LIN Time-Out Control Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t MODE:1;
      vuint32_t IOT:1;
      vuint32_t TOCE:1;
      vuint32_t CNT:8;
    } B;
  } LINTCSR;

  union {                              /* LIN Output Compare Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t OC2:8;
      vuint32_t OC1:8;
    } B;
  } LINOCR;

  union {                              /* LIN Time-Out Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t RTO:4;
      vuint32_t  :1;
      vuint32_t HTO:7;
    } B;
  } LINTOCR;

  union {                              /* LIN Fractional Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FBR:4;
    } B;
  } LINFBRR;

  union {                              /* LIN Integer Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t IBR:20;
    } B;
  } LINIBRR;

  union {                              /* LIN Checksum Field Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t CF:8;
    } B;
  } LINCFR;

  union {                              /* LIN Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TBDE:1;
      vuint32_t IOBE:1;
      vuint32_t IOPE:1;
      vuint32_t WURQ:1;
      vuint32_t DDRQ:1;
      vuint32_t DTRQ:1;
      vuint32_t ABRQ:1;
      vuint32_t HTRQ:1;
      vuint32_t  :8;
    } B;
  } LINCR2;

  union {                              /* Buffer Identifier Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;
      vuint32_t DIR:1;
      vuint32_t CCS:1;
      vuint32_t  :2;
      vuint32_t ID:6;
    } B;
  } BIDR;

  union {                              /* Buffer Data Register Least Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA3:8;
      vuint32_t DATA2:8;
      vuint32_t DATA1:8;
      vuint32_t DATA0:8;
    } B;
  } BDRL;

  union {                              /* Buffer Data Register Most Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA7:8;
      vuint32_t DATA6:8;
      vuint32_t DATA5:8;
      vuint32_t DATA4:8;
    } B;
  } BDRM;

  union {                              /* Identifier Filter Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FACT:16;
    } B;
  } IFER;

  union {                              /* Identifier Filter Match Index */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t IFMI:5;
    } B;
  } IFMI;

  union {                              /* Identifier Filter Mode Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t IFM:8;
    } B;
  } IFMR;

  union {                              /* Identifier Filter Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DFL:6;                 /* Data Field Length */
      vuint32_t DIR:1;                 /* Direction */
      vuint32_t CCS:1;                 /* Classic Checksum */
      vuint32_t  :2;
      vuint32_t ID:6;                  /* Identifier */
    } B;
  } IFCR[16];

  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDFBM:1;
      vuint32_t RDFBM:1;
      vuint32_t TDLIS:1;
      vuint32_t RDLIS:1;
      vuint32_t STOP:1;
      vuint32_t SR:1;
    } B;
  } GCR;

  union {                              /* UART Preset Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PTO:12;
    } B;
  } UARTPTO;

  union {                              /* UART Current Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t CTO:12;
    } B;
  } UARTCTO;

  union {                              /* DMA Tx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DTE:16;
    } B;
  } DMATXE;

  union {                              /* DMA Rx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DRE:16;
    } B;
  } DMARXE;

  union {                              /* PSI5-S Tx Delay register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t IFD:5;
      vuint32_t EN:1;
    } B;
  } PTD;
};


/* ============================================================================
   =============================== Module: MC_CGM =============================
   ============================================================================ */

struct MC_CGM_tag {
  uint8_t MC_CGM_reserved0[1664];
  union {                              /* Auxiliary Clock 5 Cascaded Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC0;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC1;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC2;

  uint8_t MC_CGM_reserved1[4];
  union {                              /* Auxiliary Clock 5 Cascaded Divider 10 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC10;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 11 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC11;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 12 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC12;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 13 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC13;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 20 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC20;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 21 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC21;

  union {                              /* Auxiliary Clock 5 Cascaded Divider 22 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_CDC22;

  uint8_t MC_CGM_reserved2[84];
  union {                              /* PCS Switch Duration Register */
    vuint8_t R;
    struct {
      vuint8_t SDUR:8;
    } B;
  } PCS_SDUR;

  uint8_t MC_CGM_reserved3[3];
  union {                              /* PCS Divider Change Register 1 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC1;

  union {                              /* PCS Divider End Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE1;

  union {                              /* PCS Divider Start Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS1;

  union {                              /* PCS Divider Change Register 2 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC2;

  union {                              /* PCS Divider End Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE2;

  union {                              /* PCS Divider Start Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS2;

  uint8_t MC_CGM_reserved4[12];
  union {                              /* PCS Divider Change Register 4 */
    vuint32_t R;
    struct {
      vuint32_t INIT:16;
      vuint32_t  :8;
      vuint32_t RATE:8;
    } B;
  } PCS_DIVC4;

  union {                              /* PCS Divider End Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVE:20;
    } B;
  } PCS_DIVE4;

  union {                              /* PCS Divider Start Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIVS:20;
    } B;
  } PCS_DIVS4;

  uint8_t MC_CGM_reserved5[156];
  union {                              /* System Clock Divider Ratio Change Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t SYS_DIV_RATIO_CHNG:1;
    } B;
  } SC_DIV_RC;

  union {                              /* Divider Update Type Register */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_TYPE:1;
      vuint32_t  :31;
    } B;
  } DIV_UPD_TYPE;

  union {                              /* Divider Update Trigger Register */
    vuint32_t R;
    struct {
      vuint32_t DIV_UPD_TRIGGER:32;
    } B;
  } DIV_UPD_TRIG;

  union {                              /* Divider Update Status Register */
    vuint32_t R;
    struct {
      vuint32_t SYS_UPD_STAT:1;
      vuint32_t  :31;
    } B;
  } DIV_UPD_STAT;

  uint8_t MC_CGM_reserved6[4];
  union {                              /* System Clock Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :4;
      vuint32_t SWTRG:3;
      vuint32_t SWIP:1;
      vuint32_t  :16;
    } B;
  } SC_SS;

  union {                              /* System Clock Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } SC_DC0;

  union {                              /* System Clock Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } SC_DC1;

  union {                              /* System Clock Divider 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } SC_DC2;

  union {                              /* System Clock Divider 3 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } SC_DC3;

  union {                              /* System Clock Divider 4 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } SC_DC4;

  uint8_t MC_CGM_reserved7[4];
  union {                              /* Auxiliary Clock 0 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC0_SC;

  union {                              /* Auxiliary Clock 0 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC0_SS;

  union {                              /* Auxiliary Clock 0 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC0_DC0;

  union {                              /* Auxiliary Clock 0 Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :8;
      vuint32_t DIV:7;
      vuint32_t  :16;
    } B;
  } AC0_DC1;

  union {                              /* Auxiliary Clock 0 Divider 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :8;
      vuint32_t DIV:7;
      vuint32_t  :16;
    } B;
  } AC0_DC2;

  union {                              /* Auxiliary Clock 0 Divider 3 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :6;
      vuint32_t DIV:9;
      vuint32_t  :14;
      vuint32_t DIV_FMT:2;
    } B;
  } AC0_DC3;

  union {                              /* Auxiliary Clock 0 Divider 4 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC0_DC4;

  uint8_t MC_CGM_reserved8[4];
  union {                              /* Auxiliary Clock 1 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC1_SC;

  union {                              /* Auxiliary Clock 1 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC1_SS;

  union {                              /* Auxiliary Clock 1 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :8;
      vuint32_t DIV:7;
      vuint32_t  :16;
    } B;
  } AC1_DC0;

  uint8_t MC_CGM_reserved9[28];
  union {                              /* Auxiliary Clock 2 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC2_DC0;

  union {                              /* Auxiliary Clock 2 Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC2_DC1;

  uint8_t MC_CGM_reserved10[16];
  union {                              /* Auxiliary Clock 3 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC3_SC;

  union {                              /* Auxiliary Clock 3 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC3_SS;

  uint8_t MC_CGM_reserved11[24];
  union {                              /* Auxiliary Clock 4 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC4_SC;

  union {                              /* Auxiliary Clock 4 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC4_SS;

  uint8_t MC_CGM_reserved12[32];
  union {                              /* Auxiliary Clock 5 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :2;
      vuint32_t DIV:13;
      vuint32_t  :14;
      vuint32_t DIV_FMT:2;
    } B;
  } AC5_DC0;

  union {                              /* Auxiliary Clock 5 Divider 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :7;
      vuint32_t DIV:8;
      vuint32_t  :16;
    } B;
  } AC5_DC1;

  union {                              /* Auxiliary Clock 5 Divider 2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :5;
      vuint32_t DIV:10;
      vuint32_t  :16;
    } B;
  } AC5_DC2;

  uint8_t MC_CGM_reserved13[12];
  union {                              /* Auxiliary Clock 6 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC6_SC;

  union {                              /* Auxiliary Clock 6 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC6_SS;

  union {                              /* Auxiliary Clock 6 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :6;
      vuint32_t DIV:9;
      vuint32_t  :16;
    } B;
  } AC6_DC0;

  uint8_t MC_CGM_reserved14[20];
  union {                              /* Auxiliary Clock 7 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC7_SC;

  union {                              /* Auxiliary Clock 7 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC7_SS;

  union {                              /* Auxiliary Clock 7 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :6;
      vuint32_t DIV:9;
      vuint32_t  :16;
    } B;
  } AC7_DC0;

  uint8_t MC_CGM_reserved15[20];
  union {                              /* Auxiliary Clock 8 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC8_SC;

  union {                              /* Auxiliary Clock 8 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC8_SS;

  union {                              /* Auxiliary Clock 8 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC8_DC0;

  uint8_t MC_CGM_reserved16[20];
  union {                              /* Auxiliary Clock 9 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC9_SC;

  union {                              /* Auxiliary Clock 9 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC9_SS;

  union {                              /* Auxiliary Clock 9 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :9;
      vuint32_t DIV:6;
      vuint32_t  :16;
    } B;
  } AC9_DC0;

  uint8_t MC_CGM_reserved17[20];
  union {                              /* Auxiliary Clock 10 Select Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELCTL:4;
      vuint32_t  :24;
    } B;
  } AC10_SC;

  union {                              /* Auxiliary Clock 10 Select Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t SELSTAT:4;
      vuint32_t  :24;
    } B;
  } AC10_SS;

  union {                              /* Auxiliary Clock 10 Divider 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t DE:1;
      vuint32_t  :11;
      vuint32_t DIV:4;
      vuint32_t  :16;
    } B;
  } AC10_DC0;
};


/* ============================================================================
   =============================== Module: MC_ME ==============================
   ============================================================================ */

struct MC_ME_tag {
  union {                              /* Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t S_CURRENT_MODE:4;
      vuint32_t S_MTRANS:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t S_PDO:1;
      vuint32_t  :2;
      vuint32_t S_MVR:1;
      vuint32_t  :2;
      vuint32_t S_FLA:2;
      vuint32_t  :8;
      vuint32_t S_PLL1:1;
      vuint32_t S_PLL0:1;
      vuint32_t S_XOSC:1;
      vuint32_t S_IRC:1;
      vuint32_t S_SYSCLK:4;
    } B;
  } GS;

  union {                              /* Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t TARGET_MODE:4;
      vuint32_t  :12;
      vuint32_t KEY:16;
    } B;
  } MCTL;

  union {                              /* Mode Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RESET_DEST:1;
      vuint32_t  :4;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RESET_FUNC:1;
    } B;
  } ME;

  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t I_ICONF_CC:1;
      vuint32_t I_ICONF_CU:1;
      vuint32_t I_ICONF:1;
      vuint32_t I_IMODE:1;
      vuint32_t I_SAFE:1;
      vuint32_t I_MTC:1;
    } B;
  } IS;

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t M_ICONF_CC:1;
      vuint32_t M_ICONF_CU:1;
      vuint32_t M_ICONF:1;
      vuint32_t M_IMODE:1;
      vuint32_t M_SAFE:1;
      vuint32_t M_MTC:1;
    } B;
  } IM;

  union {                              /* Invalid Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t S_MRIG:1;
      vuint32_t S_MTI:1;
      vuint32_t S_MRI:1;
      vuint32_t S_DMA:1;
      vuint32_t S_NMA:1;
      vuint32_t S_SEA:1;
    } B;
  } IMTS;

  union {                              /* Debug Mode Transition Status Register */
    vuint32_t R;
    struct {
      vuint32_t PREVIOUS_MODE:4;
      vuint32_t  :4;
      vuint32_t MPH_BUSY:1;
      vuint32_t  :2;
      vuint32_t PMC_PROG:1;
      vuint32_t DBG_MODE:1;
      vuint32_t CCKL_PROG:1;
      vuint32_t PCS_PROG:1;
      vuint32_t SMR:1;
      vuint32_t  :1;
      vuint32_t VREG_CSRC_SC:1;
      vuint32_t CSRC_CSRC_SC:1;
      vuint32_t IRC_SC:1;
      vuint32_t SCSRC_SC:1;
      vuint32_t SYSCLK_SW:1;
      vuint32_t  :1;
      vuint32_t FLASH_SC:1;
      vuint32_t CDP_PRPH_224_255:1;
      vuint32_t CDP_PRPH_192_223:1;
      vuint32_t CDP_PRPH_160_191:1;
      vuint32_t CDP_PRPH_128_159:1;
      vuint32_t CDP_PRPH_96_127:1;
      vuint32_t CDP_PRPH_64_95:1;
      vuint32_t CDP_PRPH_32_63:1;
      vuint32_t CDP_PRPH_0_31:1;
    } B;
  } DMTS;

  uint8_t MC_ME_reserved0[4];
  union {                              /* RESET Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RESET_MC;

  union {                              /* TEST Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } TEST_MC;

  union {                              /* SAFE Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } SAFE_MC;

  union {                              /* DRUN Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } DRUN_MC;

  union {                              /* RUN0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } RUN_MC[4];

  union {                              /* HALT0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } HALT0_MC;

  uint8_t MC_ME_reserved1[4];
  union {                              /* STOP0 Mode Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PWRLVL:3;
      vuint32_t  :4;
      vuint32_t PDO:1;
      vuint32_t  :2;
      vuint32_t MVRON:1;
      vuint32_t  :2;
      vuint32_t FLAON:2;
      vuint32_t  :8;
      vuint32_t PLL1ON:1;
      vuint32_t PLL0ON:1;
      vuint32_t XOSCON:1;
      vuint32_t IRCON:1;
      vuint32_t SYSCLK:4;
    } B;
  } STOP0_MC;

  uint8_t MC_ME_reserved2[20];
  union {                              /* Peripheral Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t S_PIT_RTC_1:1;
      vuint32_t S_PIT_RTC_0:1;
      vuint32_t  :14;
      vuint32_t S_SIUL:1;
      vuint32_t  :3;
      vuint32_t S_SIPI_0:1;
      vuint32_t  :1;
      vuint32_t S_LFAST_0:1;
      vuint32_t  :5;
      vuint32_t S_EBI_0:1;
      vuint32_t  :3;
    } B;
  } PS0;

  union {                              /* Peripheral Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t S_ADCSD_0:1;
      vuint32_t S_ADCSD_2:1;
      vuint32_t S_ADCSD_4:1;
      vuint32_t S_ADCSD_6:1;
      vuint32_t S_ADCSD_8:1;
      vuint32_t  :17;
      vuint32_t S_CRC_0:1;
      vuint32_t  :1;
      vuint32_t S_DMAMUX_0:1;
      vuint32_t  :4;
    } B;
  } PS1;

  union {                              /* Peripheral Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t S_DSPI_12:1;
      vuint32_t S_LINFlexD_0:1;
      vuint32_t S_LINFlexD_1:1;
      vuint32_t  :5;
      vuint32_t S_LINFlexD_14:1;
      vuint32_t S_LINFlexD_16:1;
      vuint32_t  :9;
      vuint32_t S_CAN_RAM_CTRL:1;
      vuint32_t  :1;
      vuint32_t S_TTCAN:1;
      vuint32_t  :1;
      vuint32_t S_MCAN_1:1;
      vuint32_t S_MCAN_2:1;
      vuint32_t S_MCAN_3:1;
      vuint32_t S_MCAN_4:1;
      vuint32_t  :3;
    } B;
  } PS2;

  union {                              /* Peripheral Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t S_ADCSAR_0:1;
      vuint32_t  :3;
      vuint32_t S_ADCSAR_4:1;
      vuint32_t  :10;
      vuint32_t S_ADCSAR_b:1;
      vuint32_t S_PSI5_0:1;
      vuint32_t  :3;
      vuint32_t S_FLEXRAY_0:1;
      vuint32_t  :2;
      vuint32_t S_SENT_0:1;
      vuint32_t  :2;
      vuint32_t S_IIC_0:1;
      vuint32_t  :1;
      vuint32_t S_DSPI_0:1;
      vuint32_t S_DSPI_1:1;
      vuint32_t S_DSPI_4:1;
      vuint32_t S_DSPI_6:1;
    } B;
  } PS3;

  union {                              /* Peripheral Status Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t S_GTMINT:1;
    } B;
  } PS4;

  union {                              /* Peripheral Status Register 5 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t S_ADCSD_1:1;
      vuint32_t S_ADCSD_3:1;
      vuint32_t S_ADCSD_5:1;
      vuint32_t S_ADCSD_7:1;
      vuint32_t S_ADCSD_9:1;
      vuint32_t  :17;
      vuint32_t S_CRC_1:1;
      vuint32_t  :3;
      vuint32_t S_PSI5S_0:1;
      vuint32_t  :2;
    } B;
  } PS5;

  union {                              /* Peripheral Status Register 6 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t S_LINFlexD_2:1;
      vuint32_t  :6;
      vuint32_t S_LINFlexD_15:1;
      vuint32_t  :21;
    } B;
  } PS6;

  union {                              /* Peripheral Status Register 7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t S_ADCSAR_1:1;
      vuint32_t S_ADCSAR_2:1;
      vuint32_t S_ADCSAR_3:1;
      vuint32_t  :1;
      vuint32_t S_ADCSAR_5:1;
      vuint32_t S_ADCSAR_6:1;
      vuint32_t S_ADCSAR_7:1;
      vuint32_t S_ADCSAR_8:1;
      vuint32_t S_ADCSAR_9:1;
      vuint32_t S_ADCSAR_10:1;
      vuint32_t  :5;
      vuint32_t S_PSI5_1:1;
      vuint32_t  :3;
      vuint32_t S_FLEXRAY_1:1;
      vuint32_t  :2;
      vuint32_t S_SENT_1:1;
      vuint32_t  :2;
      vuint32_t S_IIC_1:1;
      vuint32_t  :1;
      vuint32_t S_DSPI_2:1;
      vuint32_t S_DSPI_3:1;
      vuint32_t S_DSPI_5:1;
      vuint32_t  :1;
    } B;
  } PS7;

  union {                              /* Run Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RUN3:1;
      vuint32_t RUN2:1;
      vuint32_t RUN1:1;
      vuint32_t RUN0:1;
      vuint32_t DRUN:1;
      vuint32_t SAFE:1;
      vuint32_t TEST:1;
      vuint32_t RESET:1;
    } B;
  } RUN_PC[8];

  union {                              /* Low-Power Peripheral Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t STOP0:1;
      vuint32_t  :1;
      vuint32_t HALT0:1;
      vuint32_t  :8;
    } B;
  } LP_PC[8];

  uint8_t MC_ME_reserved3[3];
  union {                              /* EBI_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL3;

  uint8_t MC_ME_reserved4[5];
  union {                              /* LFAST_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL9;

  uint8_t MC_ME_reserved5[1];
  union {                              /* SIPI_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL11;

  uint8_t MC_ME_reserved6[3];
  union {                              /* SIUL Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL15;

  uint8_t MC_ME_reserved7[14];
  union {                              /* PIT_RTC_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL30;

  union {                              /* PIT_RTC_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL31;

  uint8_t MC_ME_reserved8[4];
  union {                              /* DMAMUX_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL36;

  uint8_t MC_ME_reserved9[1];
  union {                              /* CRC_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL38;

  uint8_t MC_ME_reserved10[17];
  union {                              /* ADCSD_8 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL56;

  union {                              /* ADCSD_6 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL57;

  union {                              /* ADCSD_4 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL58;

  union {                              /* ADCSD_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL59;

  union {                              /* ADCSD_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL60;

  uint8_t MC_ME_reserved11[6];
  union {                              /* MCAN_4 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL67;

  union {                              /* MCAN_3 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL68;

  union {                              /* MCAN_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL69;

  union {                              /* MCAN_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL70;

  uint8_t MC_ME_reserved12[1];
  union {                              /* TTCAN Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL72;

  uint8_t MC_ME_reserved13[1];
  union {                              /* CAN_RAM_CTRL Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL74;

  uint8_t MC_ME_reserved14[9];
  union {                              /* LINFlexD_16 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL84;

  union {                              /* LINFlexD_14 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL85;

  uint8_t MC_ME_reserved15[5];
  union {                              /* LINFlexD_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL91;

  union {                              /* LINFlexD_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL92;

  union {                              /* DSPI_12 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL93;

  uint8_t MC_ME_reserved16[2];
  union {                              /* DSPI_6 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL96;

  union {                              /* DSPI_4 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL97;

  union {                              /* DSPI_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL98;

  union {                              /* DSPI_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL99;

  uint8_t MC_ME_reserved17[1];
  union {                              /* IIC_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL101;

  uint8_t MC_ME_reserved18[2];
  union {                              /* SENT_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL104;

  uint8_t MC_ME_reserved19[2];
  union {                              /* FLEXRAY_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL107;

  uint8_t MC_ME_reserved20[3];
  union {                              /* PSI5_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL111;

  union {                              /* ADCSAR_b Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL112;

  uint8_t MC_ME_reserved21[10];
  union {                              /* ADCSAR_4 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL123;

  uint8_t MC_ME_reserved22[3];
  union {                              /* ADCSAR_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL127;

  union {                              /* GTMINT Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL128;

  uint8_t MC_ME_reserved23[33];
  union {                              /* PSI5_S_0 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL162;

  uint8_t MC_ME_reserved24[3];
  union {                              /* CRC_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL166;

  uint8_t MC_ME_reserved25[17];
  union {                              /* ADCSD_9 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL184;

  union {                              /* ADCSD_7 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL185;

  union {                              /* ADCSD_5 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL186;

  union {                              /* ADCSD_3 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL187;

  union {                              /* ADCSD_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL188;

  uint8_t MC_ME_reserved26[24];
  union {                              /* LINFlexD_15 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL213;

  uint8_t MC_ME_reserved27[6];
  union {                              /* LINFlexD_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL220;

  uint8_t MC_ME_reserved28[4];
  union {                              /* DSPI_5 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL225;

  union {                              /* DSPI_3 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL226;

  union {                              /* DSPI_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL227;

  uint8_t MC_ME_reserved29[1];
  union {                              /* IIC_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL229;

  uint8_t MC_ME_reserved30[2];
  union {                              /* SENT_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL232;

  uint8_t MC_ME_reserved31[2];
  union {                              /* FLEXRAY_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL235;

  uint8_t MC_ME_reserved32[3];
  union {                              /* PSI5_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL239;

  uint8_t MC_ME_reserved33[5];
  union {                              /* ADCSAR_10 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL245;

  union {                              /* ADCSAR_9 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL246;

  union {                              /* ADCSAR_8 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL247;

  union {                              /* ADCSAR_7 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL248;

  union {                              /* ADCSAR_6 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL249;

  union {                              /* ADCSAR_5 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL250;

  uint8_t MC_ME_reserved34[1];
  union {                              /* ADCSAR_3 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL252;

  union {                              /* ADCSAR_2 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL253;

  union {                              /* ADCSAR_1 Peripheral Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :1;
      vuint8_t DBG_F:1;
      vuint8_t LP_CFG:3;
      vuint8_t RUN_CFG:3;
    } B;
  } PCTL254;

  uint8_t MC_ME_reserved35[1];
  union {                              /* Core Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t S_CORE4:1;
      vuint32_t S_CORE3:1;
      vuint32_t S_CORE2:1;
      vuint32_t S_CORE1:1;
      vuint32_t S_CORE0:1;
    } B;
  } CS;

  union {                              /* CORE0 Core Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t HALT0:1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t TEST:1;
      vuint16_t RESET:1;
    } B;
  } CCTL0;

  union {                              /* CORE1 Core Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t HALT0:1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t TEST:1;
      vuint16_t RESET:1;
    } B;
  } CCTL1;

  union {                              /* CORE2 Core Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t HALT0:1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t TEST:1;
      vuint16_t RESET:1;
    } B;
  } CCTL2;

  union {                              /* CORE3 Core Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t HALT0:1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t TEST:1;
      vuint16_t RESET:1;
    } B;
  } CCTL3;

  union {                              /* CORE4 Core Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :5;
      vuint16_t STOP0:1;
      vuint16_t  :1;
      vuint16_t HALT0:1;
      vuint16_t RUN3:1;
      vuint16_t RUN2:1;
      vuint16_t RUN1:1;
      vuint16_t RUN0:1;
      vuint16_t DRUN:1;
      vuint16_t SAFE:1;
      vuint16_t TEST:1;
      vuint16_t RESET:1;
    } B;
  } CCTL4;

  uint8_t MC_ME_reserved36[18];
  union {                              /* CORE0 Core Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;
    } B;
  } CADDR0;

  union {                              /* CORE1 Core Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;
    } B;
  } CADDR1;

  union {                              /* CORE2 Core Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t RMC:1;
    } B;
  } CADDR2;

  union {                              /* CORE3 Core Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;
    } B;
  } CADDR3;

  union {                              /* CORE4 Core Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:30;
      vuint32_t  :1;
      vuint32_t RMC:1;
    } B;
  } CADDR4;
};


/* ============================================================================
   =============================== Module: MC_PCU =============================
   ============================================================================ */

struct MC_PCU_tag {
  uint8_t MC_PCU_reserved0[64];
  union {                              /* Power Domain Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t PD0:1;
    } B;
  } PSTAT;
};


/* ============================================================================
   =============================== Module: MC_RGM =============================
   ============================================================================ */

struct MC_RGM_tag {
  union {                              /* 'Destructive' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t F_VOR_DEST:1;
      vuint32_t F_TSR_DEST:1;
      vuint32_t  :7;
      vuint32_t F_HSM_DEST:1;
      vuint32_t F_SSCM_DEST:1;
      vuint32_t  :3;
      vuint32_t F_JTAG_DEST:1;
      vuint32_t F_FIF:1;
      vuint32_t F_EDR:1;
      vuint32_t  :2;
      vuint32_t F_SUF:1;
      vuint32_t F_FFRR:1;
      vuint32_t F_SOFT_DEST:1;
      vuint32_t  :1;
      vuint32_t F_PORST:1;
      vuint32_t F_POR:1;
    } B;
  } DES;

  uint8_t MC_RGM_reserved0[12];
  union {                              /* 'Destructive' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t D_VOR_DEST:1;
      vuint32_t  :8;
      vuint32_t D_HSM_DEST:1;
      vuint32_t D_SSCM_DEST:1;
      vuint32_t  :3;
      vuint32_t D_JTAG_DEST:1;
      vuint32_t D_FIF:1;
      vuint32_t D_EDR:1;
      vuint32_t  :2;
      vuint32_t D_SUF:1;
      vuint32_t D_FFRR:1;
      vuint32_t D_SOFT_DEST:1;
      vuint32_t  :1;
      vuint32_t D_PORST:1;
      vuint32_t D_POR:1;
    } B;
  } DERD;

  uint8_t MC_RGM_reserved1[12];
  union {                              /* 'Destructive' Event Alternate Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t AR_PORST:1;
      vuint32_t  :1;
    } B;
  } DEAR;

  uint8_t MC_RGM_reserved2[12];
  union {                              /* 'Destructive' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t BE_VOR_DEST:1;
      vuint32_t BE_TSR_DEST:1;
      vuint32_t  :7;
      vuint32_t BE_HSM_DEST:1;
      vuint32_t BE_SSCM_DEST:1;
      vuint32_t  :3;
      vuint32_t BE_JTAG_DEST:1;
      vuint32_t BE_FIF:1;
      vuint32_t BE_EDR:1;
      vuint32_t  :2;
      vuint32_t BE_SUF:1;
      vuint32_t BE_FFRR:1;
      vuint32_t BE_SOFT_DEST:1;
      vuint32_t  :1;
      vuint32_t BE_PORST:1;
      vuint32_t BE_POR:1;
    } B;
  } DBRE;

  uint8_t MC_RGM_reserved3[716];
  union {                              /* 'Functional' Event Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t F_VOR_FUNC:1;
      vuint32_t F_TSR_FUNC:1;
      vuint32_t  :7;
      vuint32_t F_HSM_FUNC:1;
      vuint32_t  :4;
      vuint32_t F_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t F_FCCU_SOFT:1;
      vuint32_t F_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t F_SOFT_FUNC:1;
      vuint32_t F_ST_DONE:1;
      vuint32_t F_ESR1:1;
      vuint32_t F_ESR0:1;
    } B;
  } FES;

  uint8_t MC_RGM_reserved4[12];
  union {                              /* 'Functional' Event Reset Disable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t D_VOR_FUNC:1;
      vuint32_t D_TSR_FUNC:1;
      vuint32_t  :7;
      vuint32_t D_HSM_FUNC:1;
      vuint32_t  :4;
      vuint32_t D_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t D_FCCU_SOFT:1;
      vuint32_t D_FCCU_HARD:1;
      vuint32_t  :2;
      vuint32_t D_ST_DONE:1;
      vuint32_t D_ESR1:1;
      vuint32_t D_ESR0:1;
    } B;
  } FERD;

  uint8_t MC_RGM_reserved5[12];
  union {                              /* 'Functional' Event Alternate Request Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t AR_VOR_FUNC:1;
      vuint32_t AR_TSR_FUNC:1;
      vuint32_t  :21;
      vuint32_t AR_ESR1:1;
      vuint32_t  :1;
    } B;
  } FEAR;

  uint8_t MC_RGM_reserved6[12];
  union {                              /* 'Functional' Bidirectional Reset Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t BE_VOR_FUNC:1;
      vuint32_t BE_TSR_FUNC:1;
      vuint32_t  :7;
      vuint32_t BE_HSM_FUNC:1;
      vuint32_t  :4;
      vuint32_t BE_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t BE_FCCU_SOFT:1;
      vuint32_t BE_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t BE_SOFT_FUNC:1;
      vuint32_t BE_ST_DONE:1;
      vuint32_t BE_ESR1:1;
      vuint32_t BE_ESR0:1;
    } B;
  } FBRE;

  uint8_t MC_RGM_reserved7[12];
  union {                              /* 'Functional' Event Short Sequence Register */
    vuint32_t R;
    struct {
      vuint32_t  :7;
      vuint32_t SS_VOR_FUNC:1;
      vuint32_t SS_TSR_FUNC:1;
      vuint32_t  :7;
      vuint32_t SS_HSM_FUNC:1;
      vuint32_t  :4;
      vuint32_t SS_JTAG_FUNC:1;
      vuint32_t  :3;
      vuint32_t SS_FCCU_SOFT:1;
      vuint32_t SS_FCCU_HARD:1;
      vuint32_t  :1;
      vuint32_t SS_SOFT_FUNC:1;
      vuint32_t SS_ST_DONE:1;
      vuint32_t SS_ESR1:1;
      vuint32_t SS_ESR0:1;
    } B;
  } FESS;

  uint8_t MC_RGM_reserved8[704];
  union {                              /* 'Functional' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t FRET:4;
    } B;
  } FRET;

  uint8_t MC_RGM_reserved9[3];
  union {                              /* 'Destructive' Reset Escalation Threshold Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t DRET:4;
    } B;
  } DRET;

  uint8_t MC_RGM_reserved10[3];
  union {                              /* External Reset Output Extension Control Register */
    vuint8_t R;
    struct {
      vuint8_t  :6;
      vuint8_t ERIS:1;
      vuint8_t EROEC:1;
    } B;
  } EROEC;

  uint8_t MC_RGM_reserved11[3];
  union {                              /* Peripheral Reset Register 0 */
    vuint32_t R;
    struct {
      vuint32_t PIT_RTC_1_RST:1;
      vuint32_t PIT_RTC_0_RST:1;
      vuint32_t  :14;
      vuint32_t SIUL_RST:1;
      vuint32_t  :3;
      vuint32_t SIPI_0_RST:1;
      vuint32_t  :1;
      vuint32_t LFAST_0_RST:1;
      vuint32_t  :5;
      vuint32_t EBI_0_RST:1;
      vuint32_t  :3;
    } B;
  } PRST0;

  union {                              /* Peripheral Reset Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ADCSD_0_RST:1;
      vuint32_t ADCSD_2_RST:1;
      vuint32_t ADCSD_4_RST:1;
      vuint32_t ADCSD_6_RST:1;
      vuint32_t ADCSD_8_RST:1;
      vuint32_t  :17;
      vuint32_t CRC_0_RST:1;
      vuint32_t  :1;
      vuint32_t DMAMUX_0_RST:1;
      vuint32_t  :4;
    } B;
  } PRST1;

  union {                              /* Peripheral Reset Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t DSPI_12_RST:1;
      vuint32_t LINFlexD_0_RST:1;
      vuint32_t LINFlexD_1_RST:1;
      vuint32_t  :5;
      vuint32_t LINFlexD_14_RST:1;
      vuint32_t LINFlexD_16_RST:1;
      vuint32_t  :9;
      vuint32_t CAN_RAM_CTR_RST:1;
      vuint32_t  :1;
      vuint32_t TTCAN_RST:1;
      vuint32_t  :1;
      vuint32_t MCAN_1_RST:1;
      vuint32_t MCAN_2_RST:1;
      vuint32_t MCAN_3_RST:1;
      vuint32_t MCAN_4_RST:1;
      vuint32_t  :3;
    } B;
  } PRST2;

  union {                              /* Peripheral Reset Register 3 */
    vuint32_t R;
    struct {
      vuint32_t ADCSAR_0_RST:1;
      vuint32_t  :3;
      vuint32_t ADCSAR_4_RST:1;
      vuint32_t  :10;
      vuint32_t ADCSAR_b_RST:1;
      vuint32_t PSI5_0_RST:1;
      vuint32_t  :3;
      vuint32_t FLEXRAY_0_RST:1;
      vuint32_t  :2;
      vuint32_t SENT_0_RST:1;
      vuint32_t  :2;
      vuint32_t IIC_0_RST:1;
      vuint32_t  :1;
      vuint32_t DSPI_0_RST:1;
      vuint32_t DSPI_1_RST:1;
      vuint32_t DSPI_4_RST:1;
      vuint32_t DSPI_6_RST:1;
    } B;
  } PRST3;

  union {                              /* Peripheral Reset Register 4 */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t GTMINT_RST:1;
    } B;
  } PRST4;

  union {                              /* Peripheral Reset Register 5 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t ADCSD_1_RST:1;
      vuint32_t ADCSD_3_RST:1;
      vuint32_t ADCSD_5_RST:1;
      vuint32_t ADCSD_7_RST:1;
      vuint32_t ADCSD_9_RST:1;
      vuint32_t  :14;
      vuint32_t FCCU_RST:1;
      vuint32_t  :2;
      vuint32_t CRC_1_RST:1;
      vuint32_t  :3;
      vuint32_t PSI5_S_0_RST:1;
      vuint32_t  :2;
    } B;
  } PRST5;

  union {                              /* Peripheral Reset Register 6 */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t LINFlexD_2_RST:1;
      vuint32_t  :6;
      vuint32_t LINFlexD_15_RST:1;
      vuint32_t  :21;
    } B;
  } PRST6;

  union {                              /* Peripheral Reset Register 7 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t ADCSAR_1_RST:1;
      vuint32_t ADCSAR_2_RST:1;
      vuint32_t ADCSAR_3_RST:1;
      vuint32_t  :1;
      vuint32_t ADCSAR_5_RST:1;
      vuint32_t ADCSAR_6_RST:1;
      vuint32_t ADCSAR_7_RST:1;
      vuint32_t ADCSAR_8_RST:1;
      vuint32_t ADCSAR_9_RST:1;
      vuint32_t ADCSAR_10_RST:1;
      vuint32_t  :5;
      vuint32_t PSI5_1_RST:1;
      vuint32_t  :3;
      vuint32_t FLEXRAY_1_RST:1;
      vuint32_t  :2;
      vuint32_t SENT_1_RST:1;
      vuint32_t  :2;
      vuint32_t IIC_1_RST:1;
      vuint32_t  :1;
      vuint32_t DSPI_2_RST:1;
      vuint32_t DSPI_3_RST:1;
      vuint32_t DSPI_5_RST:1;
      vuint32_t  :1;
    } B;
  } PRST7;
};


/* ============================================================================
   =============================== Module: MEMU ===============================
   ============================================================================ */

struct MEMU_tag {
  union {                              /* Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SWR:1;
      vuint32_t  :15;
    } B;
  } CTRL;

  union {                              /* Error flag register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t PR_CE:1;
      vuint32_t PR_UCE:1;
      vuint32_t PR_CEO:1;
      vuint32_t PR_UCO:1;
      vuint32_t PR_EBO:1;
      vuint32_t  :3;
      vuint32_t F_CE:1;
      vuint32_t F_UCE:1;
      vuint32_t F_CEO:1;
      vuint32_t F_UCO:1;
      vuint32_t F_EBO:1;
      vuint32_t  :3;
      vuint32_t SR_CE:1;
      vuint32_t SR_UCE:1;
      vuint32_t SR_CEO:1;
      vuint32_t SR_UCO:1;
      vuint32_t SR_EBO:1;
    } B;
  } ERR_FLAG;

  uint8_t MEMU_reserved0[4];
  union {                              /* Debug register */
    vuint32_t R;
    struct {
      vuint32_t  :11;
      vuint32_t FR_PR_CE:1;
      vuint32_t FR_PR_UCE:1;
      vuint32_t FR_PR_CEO:1;
      vuint32_t FR_PR_UCO:1;
      vuint32_t FR_PR_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_F_CE:1;
      vuint32_t FR_F_UCE:1;
      vuint32_t FR_F_CEO:1;
      vuint32_t FR_F_UCO:1;
      vuint32_t FR_F_EBO:1;
      vuint32_t  :3;
      vuint32_t FR_SR_CE:1;
      vuint32_t FR_SR_UCE:1;
      vuint32_t FR_SR_CEO:1;
      vuint32_t FR_SR_UCO:1;
      vuint32_t FR_SR_EBO:1;
    } B;
  } DEBUG;

  uint8_t MEMU_reserved1[16];
  struct {
    union {                            /* System RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* System RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } SYS_RAM_CERR[10];

  union {                              /* System RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } SYS_RAM_UNCERR_STS;

  union {                              /* System RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } SYS_RAM_UNCERR_ADDR;

  union {                              /* System RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } SYS_RAM_OFLW[3];

  uint8_t MEMU_reserved2[1436];
  struct {
    union {                            /* Peripheral RAM correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Peripheral RAM correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } PERIPH_RAM_CERR[2];

  union {                              /* Peripheral RAM uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } PERIPH_RAM_UNCERR_STS;

  union {                              /* Peripheral RAM uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } PERIPH_RAM_UNCERR_ADDR;

  union {                              /* Peripheral RAM concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } PERIPH_RAM_OFLW0;

  uint8_t MEMU_reserved3[1508];
  struct {
    union {                            /* Flash memory correctable error reporting table status register */
      vuint32_t R;
      struct {
        vuint32_t VLD:1;
        vuint32_t  :23;
        vuint32_t BAD_BIT:8;
      } B;
    } STS;
    union {                            /* Flash memory correctable error reporting table address register */
      vuint32_t R;
      struct {
        vuint32_t ERR_ADD:32;
      } B;
    } ADDR;
  } FLASH_CERR[20];

  union {                              /* Flash memory uncorrectable error reporting table status register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :31;
    } B;
  } FLASH_UNCERR_STS;

  union {                              /* Flash memory uncorrectable error reporting table address register */
    vuint32_t R;
    struct {
      vuint32_t ERR_ADD:32;
    } B;
  } FLASH_UNCERR_ADDR;

  union {                              /* Flash memory concurrent overflow register */
    vuint32_t R;
    struct {
      vuint32_t OFLW:32;
    } B;
  } FLASH_OFLW0;
};


/* ============================================================================
   =============================== Module: M_CAN ==============================
   ============================================================================ */

struct M_CAN_tag {
  union {                              /* Core Release Register */
    vuint32_t R;
    struct {
      vuint32_t REL:4;
      vuint32_t STEP:4;
      vuint32_t SUBSTEP:4;
      vuint32_t YEAR:4;
      vuint32_t MON:8;
      vuint32_t DAY:8;
    } B;
  } CREL;

  union {                              /* Endian Register */
    vuint32_t R;
    struct {
      vuint32_t ETV:32;
    } B;
  } ENDN;

  uint8_t M_CAN_reserved0[4];
  union {                              /* Fast Bit Timing and Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t TDCO:5;                /* Transceiver Delay Compensation Offset */
      vuint32_t TDC:1;                 /* Transceiver Delay Compensation */
      vuint32_t  :2;
      vuint32_t FBRP:5;                /* Fast Baud Rate Prescaler */
      vuint32_t  :4;
      vuint32_t FTSEG1:4;              /* Fast time segment before sample point */
      vuint32_t  :1;
      vuint32_t FTSEG2:3;              /* Fast time segment before sample point */
      vuint32_t  :2;
      vuint32_t FSJW:2;                /* Fast (Re) Synchronization Jump Width */
    } B;
  } FBTP;

  union {                              /* Test Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t TDCV:6;                /* Transceiver Delay Compensation Value */
      vuint32_t RX:1;
      vuint32_t TX:2;
      vuint32_t LBCK:1;
      vuint32_t  :4;
    } B;
  } TEST;

  union {                              /* RAM Watchdog Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t WDV:8;
      vuint32_t WDC:8;
    } B;
  } RWD;

  union {                              /* CC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :1;
      vuint32_t TXP:1;                 /* Transmit Pause */
      vuint32_t FDBS:1;                /* CAN FD Bit Rate Switching */
      vuint32_t FDO:1;                 /* Fast Frame Mode Active */
      vuint32_t CMR:2;                 /* CAN Mode Request */
      vuint32_t CME:2;                 /* CAN Mode Enable */
      vuint32_t TEST:1;
      vuint32_t DAR:1;
      vuint32_t MON:1;
      vuint32_t CSR:1;
      vuint32_t CSA:1;
      vuint32_t ASM:1;
      vuint32_t CCE:1;
      vuint32_t INIT:1;
    } B;
  } CCCR;

  union {                              /* Bit Timing and Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t BRP:10;                /* Baud Rate Prescaler */
      vuint32_t  :2;
      vuint32_t TSEG1:6;
      vuint32_t TSEG2:4;
      vuint32_t SJW:4;
    } B;
  } BTP;

  union {                              /* Timestamp Counter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t TCP:4;
      vuint32_t  :14;
      vuint32_t TSS:2;
    } B;
  } TSCC;

  union {                              /* Timestamp Counter Value Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TSC:16;                /* Timestamp Counter */
    } B;
  } TSCV;

  union {                              /* Timeout Counter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t TOP:16;
      vuint32_t  :13;
      vuint32_t TOS:2;
      vuint32_t ETOC:1;
    } B;
  } TOCC;

  union {                              /* Timeout Counter Value Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TOC:16;
    } B;
  } TOCV;

  uint8_t M_CAN_reserved1[16];
  union {                              /* Error Counter Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CEL:8;
      vuint32_t RP:1;
      vuint32_t REC:7;
      vuint32_t TEC:8;
    } B;
  } ECR;

  union {                              /* Protocol Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t REDL:1;                /* Received CAN FD Message with EDL flag */
      vuint32_t RBRS:1;                /* BRS flag of last received CAN FD Message */
      vuint32_t RESI:1;                /* ESI CAN FD Message with ESI flag */
      vuint32_t FLEC:3;                /* Fast Last Error Code */
      vuint32_t BO:1;
      vuint32_t EW:1;
      vuint32_t EP:1;
      vuint32_t ACT:2;
      vuint32_t LEC:3;
    } B;
  } PSR;

  uint8_t M_CAN_reserved2[8];
  union {                              /* Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t STE:1;
      vuint32_t FOE:1;
      vuint32_t ACKE:1;
      vuint32_t BE:1;
      vuint32_t CRCE:1;
      vuint32_t WDI:1;
      vuint32_t BO:1;
      vuint32_t EW:1;
      vuint32_t EP:1;
      vuint32_t ELO:1;
      vuint32_t BEU:1;
      vuint32_t BEC:1;
      vuint32_t DRX:1;                 /* Message stored to Dedicated Rx Buffer */
      vuint32_t TOO:1;
      vuint32_t MRAF:1;                /* Message RAM Access Failure */
      vuint32_t TSW:1;
      vuint32_t TEFL:1;
      vuint32_t TEFF:1;
      vuint32_t TEFW:1;
      vuint32_t TEFN:1;
      vuint32_t TFE:1;
      vuint32_t TCF:1;
      vuint32_t TC:1;
      vuint32_t HPM:1;
      vuint32_t RF1L:1;
      vuint32_t RF1F:1;
      vuint32_t RF1W:1;
      vuint32_t RF1N:1;
      vuint32_t RF0L:1;
      vuint32_t RF0F:1;
      vuint32_t RF0W:1;
      vuint32_t RF0N:1;
    } B;
  } IR;

  union {                              /* Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t STEE:1;
      vuint32_t FOEE:1;
      vuint32_t ACKEE:1;
      vuint32_t BEE:1;
      vuint32_t CRCEE:1;
      vuint32_t WDIE:1;
      vuint32_t BOE:1;
      vuint32_t EWE:1;
      vuint32_t EPE:1;
      vuint32_t ELOE:1;
      vuint32_t BEUE:1;
      vuint32_t BECE:1;
      vuint32_t DRXE:1;                /* Message stored to Dedicated Rx Buffer Interrupt Enable */
      vuint32_t TOOE:1;
      vuint32_t MRAFE:1;
      vuint32_t TSWE:1;
      vuint32_t TEFLE:1;
      vuint32_t TEFFE:1;
      vuint32_t TEFWE:1;
      vuint32_t TEFNE:1;
      vuint32_t TFEE:1;
      vuint32_t TCFE:1;
      vuint32_t TCE:1;
      vuint32_t HPME:1;
      vuint32_t RF1LE:1;
      vuint32_t RF1FE:1;
      vuint32_t RF1WE:1;
      vuint32_t RF1NE:1;
      vuint32_t RF0LE:1;
      vuint32_t RF0FE:1;
      vuint32_t RF0WE:1;
      vuint32_t RF0NE:1;
    } B;
  } IE;

  union {                              /* Interrupt Line Select Register */
    vuint32_t R;
    struct {
      vuint32_t STEL:1;
      vuint32_t FOEL:1;
      vuint32_t ACKEL:1;
      vuint32_t BEL:1;
      vuint32_t CRCEL:1;
      vuint32_t WDIL:1;
      vuint32_t BOL:1;
      vuint32_t EWL:1;
      vuint32_t EPL:1;
      vuint32_t ELOL:1;
      vuint32_t BEUL:1;
      vuint32_t BECL:1;
      vuint32_t DRXL:1;                /* Message stored to Dedicated Rx Buffer Interrupt Line */
      vuint32_t TOOL:1;
      vuint32_t MRAFL:1;
      vuint32_t TSWL:1;
      vuint32_t TEFLL:1;
      vuint32_t TEFFL:1;
      vuint32_t TEFWL:1;
      vuint32_t TEFNL:1;
      vuint32_t TFEL:1;
      vuint32_t TCFL:1;
      vuint32_t TCL:1;
      vuint32_t HPML:1;
      vuint32_t RF1LL:1;
      vuint32_t RF1FL:1;
      vuint32_t RF1WL:1;
      vuint32_t RF1NL:1;
      vuint32_t RF0LL:1;
      vuint32_t RF0FL:1;
      vuint32_t RF0WL:1;
      vuint32_t RF0NL:1;
    } B;
  } ILS;

  union {                              /* Interrupt Line Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t EINT1:1;
      vuint32_t EINT0:1;
    } B;
  } ILE;

  uint8_t M_CAN_reserved3[32];
  union {                              /* Global Filter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ANFS:2;
      vuint32_t ANFE:2;
      vuint32_t RRFS:1;
      vuint32_t RRFE:1;
    } B;
  } GFC;

  union {                              /* Standard ID Filter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t LSS:8;
      vuint32_t FLSSA:14;
      vuint32_t  :2;
    } B;
  } SIDFC;

  union {                              /* Extended ID Filter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t LSE:7;
      vuint32_t FLESA:14;
      vuint32_t  :2;
    } B;
  } XIDFC;

  uint8_t M_CAN_reserved4[4];
  union {                              /* Extended ID and Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t EIDM:29;
    } B;
  } XIDAM;

  union {                              /* High Priority Message Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FLST:1;
      vuint32_t FIDX:7;
      vuint32_t MSI:2;
      vuint32_t BIDX:6;
    } B;
  } HPMS;

  union {                              /* New Data 1 Register */
    vuint32_t R;
    struct {
      vuint32_t ND1:32;                /* New Data[0:31] */
    } B;
  } NDAT1;

  union {                              /* New Data 2 Register */
    vuint32_t R;
    struct {
      vuint32_t ND2:32;                /* New Data[32:63] */
    } B;
  } NDAT2;

  union {                              /* Rx FIFO 0 Configuration */
    vuint32_t R;
    struct {
      vuint32_t F0OM:1;                /* FIFO 0 Operation Mode */
      vuint32_t F0WM:7;
      vuint32_t  :2;
      vuint32_t F0S:6;
      vuint32_t F0SA:14;
      vuint32_t  :2;
    } B;
  } RXF0C;

  union {                              /* Rx FIFO 0 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t RF0L:1;
      vuint32_t F0F:1;
      vuint32_t  :2;
      vuint32_t F0PI:6;                /* Rx FIFO 0 Put Index */
      vuint32_t  :2;
      vuint32_t F0GI:6;
      vuint32_t  :1;
      vuint32_t F0FL:7;
    } B;
  } RXF0S;

  union {                              /* Rx FIFO 0 Acknowledge Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t F0AI:6;
    } B;
  } RXF0A;

  union {                              /* Rx Buffer Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RBSA:14;               /* Rx Buffer Start Address */
      vuint32_t  :2;
    } B;
  } RXBC;

  union {                              /* Rx FIFO 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t F1OM:1;                /* FIFO 1 Operation Mode */
      vuint32_t F1WM:7;
      vuint32_t  :1;
      vuint32_t F1S:7;
      vuint32_t F1SA:14;
      vuint32_t  :2;
    } B;
  } RXF1C;

  union {                              /* Rx FIFO 1 Status Register */
    vuint32_t R;
    struct {
      vuint32_t DMS:2;
      vuint32_t  :4;
      vuint32_t RF1L:1;
      vuint32_t F1F:1;
      vuint32_t  :2;
      vuint32_t F1PI:6;                /* Rx FIFO 1 Put Index */
      vuint32_t  :2;
      vuint32_t F1G1:6;
      vuint32_t  :1;
      vuint32_t F1FL:7;
    } B;
  } RXF1S;

  union {                              /* Rx FIFO 1 Acknowledge Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t F1AI:6;
    } B;
  } RXF1A;

  union {                              /* Rx Buffer / FIFO Element Size Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t RBDS:3;                /* Rx Buffer Data Field Size */
      vuint32_t  :1;
      vuint32_t F1DS:3;                /* Rx FIFO 1 Data Field Size */
      vuint32_t  :1;
      vuint32_t F0DS:3;                /* Rx FIFO 0 Data Field Size */
    } B;
  } RXESC;

  union {                              /* Tx Buffer Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TQFM:1;
      vuint32_t TQFS:6;
      vuint32_t  :2;
      vuint32_t NDTB:6;
      vuint32_t TBSA:14;
      vuint32_t  :2;
    } B;
  } TXBC;

  union {                              /* Tx FIFO/Queue Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t TFQF:1;
      vuint32_t TFQPI:5;
      vuint32_t  :3;
      vuint32_t TFGI:5;                /* Tx FIFO Get Index */
      vuint32_t  :2;
      vuint32_t TFFL:6;
    } B;
  } TXFQS;

  union {                              /* Tx Buffer Element Size Configuration */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t TBDS:3;
    } B;
  } TXESC;

  union {                              /* Tx Buffer Request Pending Register */
    vuint32_t R;
    struct {
      vuint32_t TRP:32;                /* Transmission Request Pending */
    } B;
  } TXBRP;

  union {                              /* Tx Buffer Add Request register */
    vuint32_t R;
    struct {
      vuint32_t AR:32;                 /* Add Request */
    } B;
  } TXBAR;

  union {                              /* Tx Buffer Cancellation Request register */
    vuint32_t R;
    struct {
      vuint32_t CR:32;                 /* Cancellation Request */
    } B;
  } TXBCR;

  union {                              /* Tx Buffer Transmission Occurred register */
    vuint32_t R;
    struct {
      vuint32_t TO:32;                 /* Transmission Occurred */
    } B;
  } TXBTO;

  union {                              /* Tx Buffer Cancellation Finished register */
    vuint32_t R;
    struct {
      vuint32_t CF:32;                 /* Cancellation Finished */
    } B;
  } TXBCF;

  union {                              /* Tx Buffer Transmission Interrupt Enable register */
    vuint32_t R;
    struct {
      vuint32_t TIE:32;
    } B;
  } TXBTIE;

  union {                              /* Tx Buffer Cancellation Finished Interrupt Enable register */
    vuint32_t R;
    struct {
      vuint32_t CFIE:32;
    } B;
  } TXBCIE;

  uint8_t M_CAN_reserved5[8];
  union {                              /* Tx Event FIFO Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t EFWM:6;
      vuint32_t  :2;
      vuint32_t EFS:6;
      vuint32_t EFSA:14;
      vuint32_t  :2;
    } B;
  } TXEFC;

  union {                              /* Tx Event FIFO Status register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t TEFL:1;
      vuint32_t EFF:1;
      vuint32_t  :3;
      vuint32_t EFPI:5;
      vuint32_t  :3;
      vuint32_t EFGI:5;
      vuint32_t  :2;
      vuint32_t EFFL:6;
    } B;
  } TXEFS;

  union {                              /* Tx Event FIFO Acknowledge register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t EFAI:5;
    } B;
  } TXEFA;
};


/* ============================================================================
   =============================== Module: M_TTCAN ============================
   ============================================================================ */

struct M_TTCAN_tag {
  union {                              /* Core Release Register */
    vuint32_t R;
    struct {
      vuint32_t REL:4;
      vuint32_t STEP:4;
      vuint32_t SUBSTEP:4;
      vuint32_t YEAR:4;
      vuint32_t MON:8;
      vuint32_t DAY:8;
    } B;
  } CREL;

  union {                              /* Endian Register */
    vuint32_t R;
    struct {
      vuint32_t ETV:32;
    } B;
  } ENDN;

  uint8_t M_TTCAN_reserved0[4];
  union {                              /* Fast Bit Timing and Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t TDCO:3;                /* Transceiver Delay Compensation Offset */
      vuint32_t TDC:1;                 /* Transceiver Delay Compensation */
      vuint32_t  :1;
      vuint32_t FBRP:12;               /* Fast Baud Rate Prescaler */
      vuint32_t  :3;
      vuint32_t FTSEG1:4;              /* Fast time segment before sample point */
      vuint32_t  :1;
      vuint32_t FTSEG2:3;              /* Fast time segment before sample point */
      vuint32_t  :2;
      vuint32_t FSJW:2;                /* Fast (Re) Synchronization Jump Width */
    } B;
  } FBTP;

  union {                              /* Test Register */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t TDCV:5;                /* Transceiver Delay Compensation Value */
      vuint32_t RX:1;
      vuint32_t TX:2;
      vuint32_t LBCK:1;
      vuint32_t CAT:1;                 /* Check ASC Transmit Control */
      vuint32_t CAM:1;                 /* Check ASC Multiplexer Control */
      vuint32_t TAT:1;                 /* Test ASC Transmit Control */
      vuint32_t TAM:1;                 /* Test ASC Multiplexer Control */
    } B;
  } TEST;

  union {                              /* RAM Watchdog Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t WDV:8;
      vuint32_t WDC:8;
    } B;
  } RWD;

  union {                              /* CC Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t FDBS:1;                /* Long Frame Mode Active */
      vuint32_t FDO:1;                 /* Fast Frame Mode Active */
      vuint32_t CMR:2;                 /* CAN Mode Request */
      vuint32_t CME:2;                 /* CAN Mode Enable */
      vuint32_t TEST:1;
      vuint32_t DAR:1;
      vuint32_t MON:1;
      vuint32_t CSR:1;
      vuint32_t CSA:1;
      vuint32_t ASM:1;                 /* ASM Restricted Operation Mode */
      vuint32_t CCE:1;
      vuint32_t INIT:1;
    } B;
  } CCCR;

  union {                              /* Bit Timing and Prescaler Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t BRP:10;                /* Baud Rate Prescaler */
      vuint32_t  :2;
      vuint32_t TSEG1:6;
      vuint32_t TSEG2:4;               /* Time segment after sample point */
      vuint32_t SJW:4;                 /* (Re) Synchronization Jump Width */
    } B;
  } BTP;

  union {                              /* Timestamp Counter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t TCP:4;
      vuint32_t  :14;
      vuint32_t TSS:2;
    } B;
  } TSCC;

  union {                              /* Timestamp Counter Value Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TSC:16;
    } B;
  } TSCV;

  union {                              /* Timeout Counter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t TOP:16;
      vuint32_t  :13;
      vuint32_t TOS:2;
      vuint32_t ETOC:1;
    } B;
  } TOCC;

  union {                              /* Timeout Counter Value Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TOC:16;
    } B;
  } TOCV;

  uint8_t M_TTCAN_reserved1[16];
  union {                              /* Error Counter Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t CEL:8;
      vuint32_t RP:1;
      vuint32_t REC:7;
      vuint32_t TEC:8;
    } B;
  } ECR;

  union {                              /* Protocol Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t REDL:1;                /* Received a CAN FD Message */
      vuint32_t RBRS:1;                /* BRS flag of last received CAN FD Message */
      vuint32_t RESI:1;                /* ESI CAN FD Message with ESI flag */
      vuint32_t FLEC:3;                /* Fast Last Error Code */
      vuint32_t BO:1;
      vuint32_t EW:1;
      vuint32_t EP:1;
      vuint32_t ACT:2;
      vuint32_t LEC:3;
    } B;
  } PSR;

  uint8_t M_TTCAN_reserved2[8];
  union {                              /* Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t STE:1;
      vuint32_t FOE:1;
      vuint32_t ACKE:1;
      vuint32_t BE:1;
      vuint32_t CRCE:1;
      vuint32_t WDI:1;
      vuint32_t BO:1;
      vuint32_t EW:1;
      vuint32_t EP:1;
      vuint32_t ELO:1;
      vuint32_t BEU:1;
      vuint32_t BEC:1;
      vuint32_t DRX:1;                 /* Message stored to Dedicated Rx Buffer */
      vuint32_t TOO:1;
      vuint32_t UMD:1;
      vuint32_t TSW:1;
      vuint32_t TEFL:1;
      vuint32_t TEFF:1;
      vuint32_t TEFW:1;
      vuint32_t TEFN:1;
      vuint32_t TFE:1;
      vuint32_t TCF:1;
      vuint32_t TC:1;
      vuint32_t HPM:1;
      vuint32_t RF1L:1;
      vuint32_t RF1F:1;
      vuint32_t RF1W:1;
      vuint32_t RF1N:1;
      vuint32_t RF0L:1;
      vuint32_t RF0F:1;
      vuint32_t RF0W:1;
      vuint32_t RF0N:1;
    } B;
  } IR;

  union {                              /* Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t STEE:1;
      vuint32_t FOEE:1;
      vuint32_t ACKEE:1;
      vuint32_t BEE:1;
      vuint32_t CRCEE:1;
      vuint32_t WDIE:1;
      vuint32_t BOE:1;
      vuint32_t EWE:1;
      vuint32_t EPE:1;
      vuint32_t ELOE:1;
      vuint32_t BEUE:1;
      vuint32_t BECE:1;
      vuint32_t DRXE:1;                /* Message stored to Dedicated Rx Buffer Interrupt Enable */
      vuint32_t TOOE:1;
      vuint32_t UMDE:1;
      vuint32_t TSWE:1;
      vuint32_t TEFLE:1;
      vuint32_t TEFFE:1;
      vuint32_t TEFWE:1;
      vuint32_t TEFNE:1;
      vuint32_t TFEE:1;
      vuint32_t TCFE:1;
      vuint32_t TCE:1;
      vuint32_t HPME:1;
      vuint32_t RF1LE:1;
      vuint32_t RF1FE:1;
      vuint32_t RF1WE:1;
      vuint32_t RF1NE:1;
      vuint32_t RF0LE:1;
      vuint32_t RF0FE:1;
      vuint32_t RF0WE:1;
      vuint32_t RF0NE:1;
    } B;
  } IE;

  union {                              /* Interrupt Line Select Register */
    vuint32_t R;
    struct {
      vuint32_t STEL:1;
      vuint32_t FOEL:1;
      vuint32_t ACKEL:1;
      vuint32_t BEL:1;
      vuint32_t CRCEL:1;
      vuint32_t WDIL:1;
      vuint32_t BOL:1;
      vuint32_t EWL:1;
      vuint32_t EPL:1;
      vuint32_t ELOL:1;
      vuint32_t BEUL:1;
      vuint32_t BECL:1;
      vuint32_t DRXL:1;                /* Message stored to Dedicated Rx Buffer Interrupt Line */
      vuint32_t TOOL:1;
      vuint32_t UMDL:1;
      vuint32_t TSWL:1;
      vuint32_t TEFLL:1;
      vuint32_t TEFFL:1;
      vuint32_t TEFWL:1;
      vuint32_t TEFNL:1;
      vuint32_t TFEL:1;
      vuint32_t TCFL:1;
      vuint32_t TCL:1;
      vuint32_t HPML:1;
      vuint32_t RF1LL:1;
      vuint32_t RF1FL:1;
      vuint32_t RF1WL:1;
      vuint32_t RF1NL:1;
      vuint32_t RF0LL:1;
      vuint32_t RF0FL:1;
      vuint32_t RF0WL:1;
      vuint32_t RF0NL:1;
    } B;
  } ILS;

  union {                              /* Interrupt Line Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t EINT1:1;
      vuint32_t EINT0:1;
    } B;
  } ILE;

  uint8_t M_TTCAN_reserved3[32];
  union {                              /* Global Filter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ANFS:2;
      vuint32_t ANFE:2;
      vuint32_t RRFS:1;
      vuint32_t RRFE:1;
    } B;
  } GFC;

  union {                              /* Standard ID Filter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t LSS:8;
      vuint32_t FLSSA:14;
      vuint32_t  :2;
    } B;
  } SIDFC;

  union {                              /* Extended ID Filter Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t LSE:7;
      vuint32_t FLESA:14;
      vuint32_t  :2;
    } B;
  } XIDFC;

  uint8_t M_TTCAN_reserved4[4];
  union {                              /* Extended ID and Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t EIDM:29;
    } B;
  } XIDAM;

  union {                              /* High Priority Message Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FLST:1;
      vuint32_t FIDX:7;
      vuint32_t MSI:2;
      vuint32_t BIDX:6;
    } B;
  } HPMS;

  union {                              /* New Data 1 Register */
    vuint32_t R;
    struct {
      vuint32_t ND1:32;                /* New Data[0:31] */
    } B;
  } NDAT1;

  union {                              /* New Data 2 Register */
    vuint32_t R;
    struct {
      vuint32_t ND2:32;                /* New Data[63:32] */
    } B;
  } NDAT2;

  union {                              /* Rx FIFO 0 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t F0WM:7;
      vuint32_t  :1;
      vuint32_t F0S:7;
      vuint32_t FOSA:14;
      vuint32_t  :2;
    } B;
  } RXF0C;

  union {                              /* Rx FIFO 0 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t RF0L:1;
      vuint32_t F0F:1;
      vuint32_t  :2;
      vuint32_t F0PI:6;
      vuint32_t  :2;
      vuint32_t F0GI:6;
      vuint32_t  :1;
      vuint32_t F0FL:7;
    } B;
  } RXF0S;

  union {                              /* Rx FIFO 0 Acknowledge Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t F0AI:6;
    } B;
  } RXF0A;

  union {                              /* Rx Buffer Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RBSA:14;               /* Rx Buffer Start Address */
      vuint32_t  :2;
    } B;
  } RXBC;

  union {                              /* Rx FIFO 1 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t F1WM:7;
      vuint32_t  :1;
      vuint32_t F1S:7;
      vuint32_t F1SA:14;
      vuint32_t  :2;
    } B;
  } RXF1C;

  union {                              /* Rx FIFO 1 Status Register */
    vuint32_t R;
    struct {
      vuint32_t DMS:2;                 /* Debug Message Status */
      vuint32_t  :4;
      vuint32_t RF1L:1;
      vuint32_t F1F:1;
      vuint32_t  :2;
      vuint32_t F1PI:6;
      vuint32_t  :2;
      vuint32_t F1GI:6;
      vuint32_t  :1;
      vuint32_t F1FL:7;
    } B;
  } RXF1S;

  union {                              /* Rx FIFO 1 Acknowledge register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t F1A1:6;
    } B;
  } RXF1A;

  uint8_t M_TTCAN_reserved5[4];
  union {                              /* Tx Buffer Configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t TFQM:1;
      vuint32_t TFQS:6;
      vuint32_t  :2;
      vuint32_t NDTB:6;
      vuint32_t TBSA:14;
      vuint32_t  :2;
    } B;
  } TXBC;

  union {                              /* Tx FIFO/Queue Status register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t TFQF:1;
      vuint32_t TFQPI:5;
      vuint32_t  :3;
      vuint32_t TFGI:5;
      vuint32_t  :2;
      vuint32_t TFFL:6;
    } B;
  } TXFQS;

  uint8_t M_TTCAN_reserved6[4];
  union {                              /* Tx Buffer Request Pending register */
    vuint32_t R;
    struct {
      vuint32_t TRP:32;
    } B;
  } TXBRP;

  union {                              /* Tx Buffer Add Request register */
    vuint32_t R;
    struct {
      vuint32_t AR:32;
    } B;
  } TXBAR;

  union {                              /* Tx Buffer Cancellation Request register */
    vuint32_t R;
    struct {
      vuint32_t CR:32;
    } B;
  } TXBCR;

  union {                              /* Tx Buffer Transmission Occurred register */
    vuint32_t R;
    struct {
      vuint32_t TO:32;
    } B;
  } TXBTO;

  union {                              /* Tx Buffer Cancellation Finished register */
    vuint32_t R;
    struct {
      vuint32_t CF:32;
    } B;
  } TXBCF;

  union {                              /* Tx Buffer Transmission Interrupt Enable register */
    vuint32_t R;
    struct {
      vuint32_t TIE:32;
    } B;
  } TXBTIE;

  union {                              /* Tx Buffer Cancellation Finished Interrupt Enable register */
    vuint32_t R;
    struct {
      vuint32_t CFIE:32;
    } B;
  } TXBCIE;

  uint8_t M_TTCAN_reserved7[8];
  union {                              /* Tx Event FIFO Configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t EFWM:6;
      vuint32_t  :2;
      vuint32_t EFS:6;
      vuint32_t EFSA:14;
      vuint32_t  :2;
    } B;
  } TXEFC;

  union {                              /* Tx Event FIFO Status register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t TEFL:1;
      vuint32_t EFF:1;
      vuint32_t  :3;
      vuint32_t EFPI:5;
      vuint32_t  :3;
      vuint32_t EFGI:5;
      vuint32_t  :2;
      vuint32_t EFFL:6;
    } B;
  } TXEFS;

  union {                              /* Tx Event FIFO Acknowledge register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t EFAI:5;
    } B;
  } TXEFA;

  uint8_t M_TTCAN_reserved8[4];
  union {                              /* TT Trigger Memory Configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :9;
      vuint32_t TME:7;
      vuint32_t TMSA:14;
      vuint32_t  :2;
    } B;
  } TTTMC;

  union {                              /* TT Reference Message Configuration register */
    vuint32_t R;
    struct {
      vuint32_t RMPS:1;
      vuint32_t XTD:1;
      vuint32_t  :1;
      vuint32_t RID:29;
    } B;
  } TTRMC;

  union {                              /* TT Operation Configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t EVTP:1;
      vuint32_t ECC:1;
      vuint32_t EGTF:1;
      vuint32_t AWL:8;
      vuint32_t EECS:1;
      vuint32_t IRTO:7;
      vuint32_t LDSDL:3;
      vuint32_t TM:1;
      vuint32_t GEN:1;
      vuint32_t  :1;
      vuint32_t OM:2;
    } B;
  } TTOCF;

  union {                              /* TT Matrix Limits register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t ENTT:12;
      vuint32_t  :4;
      vuint32_t TXEW:4;
      vuint32_t CSS:2;                 /* Cycle Start Synchronization */
      vuint32_t CCM:6;
    } B;
  } TTMLM;

  union {                              /* TUR Configuration register */
    vuint32_t R;
    struct {
      vuint32_t ELT:1;
      vuint32_t  :1;
      vuint32_t DC:14;
      vuint32_t NCL:16;
    } B;
  } TURCF;

  union {                              /* TT Operation Control register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LCKC:1;
      vuint32_t  :1;
      vuint32_t ESCN:1;
      vuint32_t NIG:1;
      vuint32_t TMG:1;
      vuint32_t FGP:1;
      vuint32_t GCS:1;
      vuint32_t TTIE:1;                /* Trigger Time Mark Interrupt Pulse Enable */
      vuint32_t TMC:2;
      vuint32_t RTIE:1;
      vuint32_t SWS:2;
      vuint32_t SWP:1;
      vuint32_t ECS:1;
      vuint32_t SGT:1;
    } B;
  } TTOCN;

  union {                              /* TT Global Time Preset register */
    vuint32_t R;
    struct {
      vuint32_t CTP:16;
      vuint32_t TP:16;
    } B;
  } TTGTP;

  union {                              /* TT Time Mark register */
    vuint32_t R;
    struct {
      vuint32_t LCKM:1;
      vuint32_t  :8;
      vuint32_t TICC:7;
      vuint32_t TM:16;
    } B;
  } TTTMK;

  union {                              /* TT Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t CER:1;
      vuint32_t AW:1;
      vuint32_t WT:1;
      vuint32_t IWT:1;
      vuint32_t ELC:1;
      vuint32_t SE2:1;
      vuint32_t SE1:1;
      vuint32_t TXO:1;
      vuint32_t TXU:1;
      vuint32_t GTE:1;
      vuint32_t GTD:1;
      vuint32_t GTW:1;
      vuint32_t SWE:1;
      vuint32_t TTMI:1;
      vuint32_t RTMI:1;
      vuint32_t SOG:1;
      vuint32_t CSM:1;
      vuint32_t SMC:1;
      vuint32_t SBC:1;
    } B;
  } TTIR;

  union {                              /* TT Interrupt Enable register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t CERE:1;
      vuint32_t AWE:1;
      vuint32_t WTE:1;
      vuint32_t IWTE:1;
      vuint32_t ELCE:1;
      vuint32_t SE2E:1;
      vuint32_t SE1E:1;
      vuint32_t TXOE:1;
      vuint32_t TXUE:1;
      vuint32_t GTEE:1;
      vuint32_t GTDE:1;
      vuint32_t GTWE:1;
      vuint32_t SWEE:1;
      vuint32_t TTMIE:1;
      vuint32_t RTMIE:1;
      vuint32_t SOGE:1;
      vuint32_t CSME:1;
      vuint32_t SMCE:1;
      vuint32_t SBCE:1;
    } B;
  } TTIE;

  union {                              /* TT Interrupt Line Select register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t CERL:1;
      vuint32_t AWL:1;
      vuint32_t WTL:1;
      vuint32_t IWTL:1;
      vuint32_t ELCL:1;
      vuint32_t SE2L:1;
      vuint32_t SE1L:1;
      vuint32_t TXOL:1;
      vuint32_t TXUL:1;
      vuint32_t GTEL:1;
      vuint32_t GTDL:1;
      vuint32_t GTWE:1;
      vuint32_t SWEL:1;
      vuint32_t TTMIL:1;
      vuint32_t RTMIL:1;
      vuint32_t SOGL:1;
      vuint32_t CSML:1;
      vuint32_t SMCL:1;
      vuint32_t SBCL:1;
    } B;
  } TTILS;

  union {                              /* TT Operation Status register */
    vuint32_t R;
    struct {
      vuint32_t SPL:1;
      vuint32_t WECS:1;
      vuint32_t AWE:1;
      vuint32_t WFE:1;
      vuint32_t GSI:1;
      vuint32_t TMP:3;
      vuint32_t GFI:1;
      vuint32_t WGTD:1;
      vuint32_t  :6;
      vuint32_t RTO:8;
      vuint32_t QCS:1;
      vuint32_t QGTP:1;
      vuint32_t SYS:2;
      vuint32_t MS:2;
      vuint32_t EL:2;
    } B;
  } TTOST;

  union {                              /* TUR Numerator Actual register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t NAV:18;
    } B;
  } TURNA;

  union {                              /* TT Local and Global Time register */
    vuint32_t R;
    struct {
      vuint32_t GT:16;
      vuint32_t LT:16;
    } B;
  } TTLGT;

  union {                              /* TT Cycle Time and Count register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t CC:6;
      vuint32_t CT:16;
    } B;
  } TTCTC;

  union {                              /* TT Capture Time register */
    vuint32_t R;
    struct {
      vuint32_t SWV:16;
      vuint32_t  :10;
      vuint32_t CCV:6;
    } B;
  } TTCPT;

  union {                              /* TT Cycle Sync Mark register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CSM:16;
    } B;
  } TTCSM;
};


/* ============================================================================
   =============================== Module: PASS ===============================
   ============================================================================ */

struct PASS_tag {
  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t CNS:1;
      vuint32_t JUN:1;
      vuint32_t FBE:1;
      vuint32_t  :26;
      vuint32_t LIFE:3;
    } B;
  } LCSTAT;

  uint8_t PASS_reserved0[4];
  union {                              /* Challenge Selector Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t GRP:2;
    } B;
  } CHSEL;

  uint8_t PASS_reserved1[4];
  union {                              /* Challenge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t CMST:4;
    } B;
  } CSTAT;

  uint8_t PASS_reserved2[12];
  union {                              /* Challenge Input Register */
    vuint32_t R;
    struct {
      vuint32_t PW32:32;
    } B;
  } CIN[8];

  uint8_t PASS_reserved3[144];
  union {                              /* Clock Jitter Enable */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t CJE:1;
    } B;
  } CJE;

  uint8_t PASS_reserved4[44];
  struct {
    union {                            /* Password Group n - Lock 0 Status Register */
      vuint32_t R;
      struct {
        vuint32_t TSLOCK:1;
        vuint32_t ATSL:1;
        vuint32_t LOWLOCK:14;
        vuint32_t MIDLOCK:16;
      } B;
    } LOCK0;
    union {                            /* Password Group n - Lock 1 Status Register */
      vuint32_t R;
      struct {
        vuint32_t  :16;
        vuint32_t HIGHLOCK:16;
      } B;
    } LOCK1;
    union {                            /* Password Group n - Lock 2 Status Register */
      vuint32_t R;
      struct {
        vuint32_t L_256LCK:32;
      } B;
    } LOCK2;
    union {                            /* Password Group n - Lock 3 Status Register */
      vuint32_t R;
      struct {
        vuint32_t PGL:1;
        vuint32_t DBL:1;
        vuint32_t MO:1;
        vuint32_t  :1;
        vuint32_t MSTR:4;
        vuint32_t  :3;
        vuint32_t RL4:1;
        vuint32_t RL3:1;
        vuint32_t RL2:1;
        vuint32_t RL1:1;
        vuint32_t RL0:1;
        vuint32_t U_256LCK:16;
      } B;
    } LOCK3;
  } PG[4];
};


/* ============================================================================
   =============================== Module: PBRIDGE ============================
   ============================================================================ */

struct PBRIDGE_tag {
  union {                              /* Master Privilege Register A */
    vuint32_t R;
    struct {
      vuint32_t MPROT0:4;
      vuint32_t MPROT1:4;
      vuint32_t MPROT2:4;
      vuint32_t MPROT3:4;
      vuint32_t MPROT4:4;
      vuint32_t MPROT5:4;
      vuint32_t MPROT6:4;
      vuint32_t MPROT7:4;
    } B;
  } MPRA;

  union {                              /* Master Privilege Register B */
    vuint32_t R;
    struct {
      vuint32_t MPROT8:4;
      vuint32_t MPROT9:4;
      vuint32_t MPROT10:4;
      vuint32_t MPROT11:4;
      vuint32_t MPROT12:4;
      vuint32_t MPROT13:4;
      vuint32_t MPROT14:4;
      vuint32_t MPROT15:4;
    } B;
  } MPRB;

  uint8_t PBRIDGE_reserved0[248];
  union {                              /* Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t PACRa:4;
      vuint32_t PACRb:4;
      vuint32_t PACRc:4;
      vuint32_t PACRd:4;
      vuint32_t PACRe:4;
      vuint32_t PACRf:4;
      vuint32_t PACRg:4;
      vuint32_t PACRh:4;
    } B;
  } PACR[8];

  uint8_t PBRIDGE_reserved1[32];
  union {                              /* Off-platform Peripheral Access Control Register */
    vuint32_t R;
    struct {
      vuint32_t OPACRa:4;
      vuint32_t OPACRb:4;
      vuint32_t OPACRc:4;
      vuint32_t OPACRd:4;
      vuint32_t OPACRe:4;
      vuint32_t OPACRf:4;
      vuint32_t OPACRg:4;
      vuint32_t OPACRh:4;
    } B;
  } OPACR[32];
};


/* ============================================================================
   =============================== Module: PCM ================================
   ============================================================================ */

struct PCM_tag {
  union {                              /* FEC Burst Optimization Master Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t ACCERR:1;
      vuint32_t WBEN:1;
      vuint32_t RBEN:1;
      vuint32_t FXSBE:8;
    } B;
  } FBOMCR;

  union {                              /* IAHB Burst Enable 1 Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t RSV:3;
      vuint32_t  :5;
      vuint32_t PRE_DMA:1;
      vuint32_t BRE_DMA:1;
      vuint32_t BWE_DMA:1;
      vuint32_t  :5;
      vuint32_t PRE_S0:1;
      vuint32_t BRE_S0:1;
      vuint32_t BWE_S0:1;
      vuint32_t  :5;
      vuint32_t PRE_M3:1;
      vuint32_t BRE_M3:1;
      vuint32_t BWE_M3:1;
    } B;
  } IAHB_BE1;

  union {                              /* IAHB Burst Enable 2 Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t RSV:3;
      vuint32_t  :5;
      vuint32_t PRE_SIPI:1;
      vuint32_t BRE_SIPI:1;
      vuint32_t BWE_SIPI:1;
      vuint32_t  :5;
      vuint32_t PRE_FlexRay:1;
      vuint32_t BRE_FlexRay:1;
      vuint32_t BWE_FlexRay:1;
      vuint32_t  :5;
      vuint32_t PRE_FEC:1;
      vuint32_t BRE_FEC:1;
      vuint32_t BWE_FEC:1;
    } B;
  } IAHB_BE2;
};


/* ============================================================================
   =============================== Module: PFLASH =============================
   ============================================================================ */

struct PFLASH_tag {
  union {                              /* Platform Flash Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t P0_M15PFE:1;
      vuint32_t P0_M14PFE:1;
      vuint32_t P0_M13PFE:1;
      vuint32_t P0_M12PFE:1;
      vuint32_t P0_M11PFE:1;
      vuint32_t P0_M10PFE:1;
      vuint32_t P0_M9PFE:1;
      vuint32_t P0_M8PFE:1;
      vuint32_t P0_M7PFE:1;
      vuint32_t P0_M6PFE:1;
      vuint32_t P0_M5PFE:1;
      vuint32_t P0_M4PFE:1;
      vuint32_t P0_M3PFE:1;
      vuint32_t P0_M2PFE:1;
      vuint32_t P0_M1PFE:1;
      vuint32_t P0_M0PFE:1;
      vuint32_t APC:3;
      vuint32_t RWSC:5;
      vuint32_t  :1;
      vuint32_t P0_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P0_PFLIM:2;
      vuint32_t P0_BFEN:1;
    } B;
  } PFCR1;

  union {                              /* Platform Flash Configuration Register 2 */
    vuint32_t R;
    struct {
      vuint32_t P1_M15PFE:1;
      vuint32_t P1_M14PFE:1;
      vuint32_t P1_M13PFE:1;
      vuint32_t P1_M12PFE:1;
      vuint32_t P1_M11PFE:1;
      vuint32_t P1_M10PFE:1;
      vuint32_t P1_M9PFE:1;
      vuint32_t P1_M8PFE:1;
      vuint32_t P1_M7PFE:1;
      vuint32_t P1_M6PFE:1;
      vuint32_t P1_M5PFE:1;
      vuint32_t P1_M4PFE:1;
      vuint32_t P1_M3PFE:1;
      vuint32_t P1_M2PFE:1;
      vuint32_t P1_M1PFE:1;
      vuint32_t P1_M0PFE:1;
      vuint32_t  :9;
      vuint32_t P1_DPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_IPFEN:1;
      vuint32_t  :1;
      vuint32_t P1_PFLIM:2;
      vuint32_t P1_BFEN:1;
    } B;
  } PFCR2;

  union {                              /* Platform Flash Configuration Register 3 */
    vuint32_t R;
    struct {
      vuint32_t P0_WCFG:2;
      vuint32_t P1_WCFG:2;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t BDRM:1;
      vuint32_t  :3;
      vuint32_t BAF_DIS:1;
      vuint32_t ARBM:2;
      vuint32_t  :2;
      vuint32_t  :11;
      vuint32_t  :1;
    } B;
  } PFCR3;

  union {                              /* Platform Flash Access Protection Register */
    vuint32_t R;
    struct {
      vuint32_t M0AP:2;
      vuint32_t M1AP:2;
      vuint32_t M2AP:2;
      vuint32_t M3AP:2;
      vuint32_t M4AP:2;
      vuint32_t M5AP:2;
      vuint32_t M6AP:2;
      vuint32_t M7AP:2;
      vuint32_t M8AP:2;
      vuint32_t M9AP:2;
      vuint32_t M10AP:2;
      vuint32_t M11AP:2;
      vuint32_t M12AP:2;
      vuint32_t M13AP:2;
      vuint32_t M14AP:2;
      vuint32_t M15AP:2;
    } B;
  } PFAPR;

  union {                              /* Platform Flash Remap Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t SAFE_CAL:1;
      vuint32_t  :3;
      vuint32_t IRMEN:1;
      vuint32_t  :3;
      vuint32_t GRMEN:1;
    } B;
  } PFCRCR;

  union {                              /* Platform Flash Remap Descriptor Enable Register */
    vuint32_t R;
    struct {
      vuint32_t CRD0EN:1;
      vuint32_t CRD1EN:1;
      vuint32_t CRD2EN:1;
      vuint32_t CRD3EN:1;
      vuint32_t CRD4EN:1;
      vuint32_t CRD5EN:1;
      vuint32_t CRD6EN:1;
      vuint32_t CRD7EN:1;
      vuint32_t CRD8EN:1;
      vuint32_t CRD9EN:1;
      vuint32_t CRD10EN:1;
      vuint32_t CRD11EN:1;
      vuint32_t CRD12EN:1;
      vuint32_t CRD13EN:1;
      vuint32_t CRD14EN:1;
      vuint32_t CRD15EN:1;
      vuint32_t CRD16EN:1;
      vuint32_t CRD17EN:1;
      vuint32_t CRD18EN:1;
      vuint32_t CRD19EN:1;
      vuint32_t CRD20EN:1;
      vuint32_t CRD21EN:1;
      vuint32_t CRD22EN:1;
      vuint32_t CRD23EN:1;
      vuint32_t CRD24EN:1;
      vuint32_t CRD25EN:1;
      vuint32_t CRD26EN:1;
      vuint32_t CRD27EN:1;
      vuint32_t CRD28EN:1;
      vuint32_t CRD29EN:1;
      vuint32_t CRD30EN:1;
      vuint32_t CRD31EN:1;
    } B;
  } PFCRDE;

  uint8_t PFLASH_reserved0[232];
  struct {
    union {                            /* Platform Flash Calibration Region Descriptor n Word0 */
      vuint32_t R;
      struct {
        vuint32_t LSTARTADDR:32;
      } B;
    } Word0;
    union {                            /* Platform Flash Calibration Region Descriptor n Word1 */
      vuint32_t R;
      struct {
        vuint32_t PSTARTADDR:32;
      } B;
    } Word1;
    union {                            /* Platform Flash Calibration Region Descriptor n Word2 */
      vuint32_t R;
      struct {
        vuint32_t M0EN:1;
        vuint32_t M1EN:1;
        vuint32_t M2EN:1;
        vuint32_t M3EN:1;
        vuint32_t M4EN:1;
        vuint32_t M5EN:1;
        vuint32_t M6EN:1;
        vuint32_t M7EN:1;
        vuint32_t M8EN:1;
        vuint32_t M9EN:1;
        vuint32_t M10EN:1;
        vuint32_t M11EN:1;
        vuint32_t M12EN:1;
        vuint32_t M13EN:1;
        vuint32_t M14EN:1;
        vuint32_t M15EN:1;
        vuint32_t  :11;
        vuint32_t CRDSize:5;
      } B;
    } Word2;
    uint8_t PFCRD_reserved0[4];
  } PFCRD[32];
};


/* ============================================================================
   =============================== Module: PIT ================================
   ============================================================================ */

struct PIT_tag {
  union {                              /* PIT Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t MDIS_RTI:1;
      vuint32_t MDIS:1;
      vuint32_t FRZ:1;
    } B;
  } MCR;

  uint8_t PIT_reserved0[220];
  union {                              /* PIT Upper Lifetime Timer Register */
    vuint32_t R;
    struct {
      vuint32_t LTH:32;
    } B;
  } LTMR64H;

  union {                              /* PIT Lower Lifetime Timer Register */
    vuint32_t R;
    struct {
      vuint32_t LTL:32;
    } B;
  } LTMR64L;

  uint8_t PIT_reserved1[8];
  union {                              /* PIT RTI Timer Load Value Register */
    vuint32_t R;
    struct {
      vuint32_t TSV:32;
    } B;
  } RTI_LDVAL;

  union {                              /* PIT RTI Current Timer Value Register */
    vuint32_t R;
    struct {
      vuint32_t TVL:32;
    } B;
  } RTI_CVAL;

  union {                              /* PIT RTI Timer Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :29;
      vuint32_t CHN:1;
      vuint32_t TIE:1;
      vuint32_t TEN:1;
    } B;
  } RTI_TCTRL;

  union {                              /* PIT RTI Timer Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;
    } B;
  } RTI_TFLG;

  struct {
    union {                            /* PIT Timer Load Value Register n */
      vuint32_t R;
      struct {
        vuint32_t TSV:32;
      } B;
    } LDVAL;
    union {                            /* PIT Current Timer Value Register n */
      vuint32_t R;
      struct {
        vuint32_t TVL:32;
      } B;
    } CVAL;
    union {                            /* PIT Timer Control Register n */
      vuint32_t R;
      struct {
        vuint32_t  :29;
        vuint32_t CHN:1;
        vuint32_t TIE:1;
        vuint32_t TEN:1;
      } B;
    } TCTRL;
    union {                            /* PIT Timer Flag Register n */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t TIF:1;
      } B;
    } TFLG;
  } TIMER[8];
};


/* ============================================================================
   =============================== Module: PLLDIG =============================
   ============================================================================ */

struct PLLDIG_tag {
  union {                              /* PLLDIG PLL0 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t CLKCFG:2;              /* Clock Configuration */
      vuint32_t EXPDIE:1;              /* External Power Down Cycle Complete indication interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL0CR;

  union {                              /* PLLDIG PLL0 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t EXTPDF:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;                /* Loss-of-lock flag. */
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL0SR;

  union {                              /* PLLDIG PLL0 Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t RFDPHI1:4;             /* PHI1 reduced frequency divider. */
      vuint32_t  :5;
      vuint32_t RFDPHI:6;              /* PHI reduced frequency divider. */
      vuint32_t  :1;
      vuint32_t PREDIV:3;              /* Input clock predivider. */
      vuint32_t  :5;
      vuint32_t MFD:7;                 /* Loop multiplication factor divider. */
    } B;
  } PLL0DV;

  uint8_t PLLDIG_reserved0[20];
  union {                              /* PLLDIG PLL1 Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t  :1;
      vuint32_t CLKCFG:2;              /* Clock Configuration */
      vuint32_t EXPDIE:1;              /* External Power Down Cycle Complete indication interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLIE:1;               /* Loss-of-lock interrupt enable. */
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL1CR;

  union {                              /* PLLDIG PLL1 Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t EXTPDF:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t LOLF:1;                /* Loss-of-lock flag. */
      vuint32_t LOCK:1;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } PLL1SR;

  union {                              /* PLLDIG PLL1 Divider Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t RFDPHI:6;              /* PHI reduced frequency divider. */
      vuint32_t  :5;
      vuint32_t  :4;
      vuint32_t MFD:7;                 /* Loop multiplication factor divider. */
    } B;
  } PLL1DV;

  union {                              /* PLLDIG PLL1 Frequency Modulation Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t MODEN:1;               /* Modulation enable. */
      vuint32_t MODSEL:1;              /* Modulation selection. */
      vuint32_t MODPRD:13;             /* Modulation period. */
      vuint32_t  :1;
      vuint32_t INCSTP:15;             /* Increment step. */
    } B;
  } PLL1FM;

  union {                              /* PLLDIG PLL1 Fractional Divide Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t FDEN:1;                /* Fractional Divide Enable */
      vuint32_t  :12;
      vuint32_t DTHDIS:2;              /* Dither Disable. */
      vuint32_t  :4;
      vuint32_t FRCDIV:12;
    } B;
  } PLL1FD;
};


/* ============================================================================
   =============================== Module: PMCDIG =============================
   ============================================================================ */

struct PMCDIG_tag {
  union {                              /* Supply Gauge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;                   /* Reserved. */
      vuint32_t TS3:1;                 /* TS3 over temperature detect flag. */
      vuint32_t TS2:1;                 /* TS2 over temperature detect flag. */
      vuint32_t TS0:1;                 /* TS0 under temperature detect flag. */
      vuint32_t  :8;
      vuint32_t VD15:1;                /* VD15 high-voltage detect flag. */
      vuint32_t VD14:1;                /* VD14 low-voltage detect flag. */
      vuint32_t VD13:1;                /* VD13 low-voltage detect flag. */
      vuint32_t VD12:1;                /* VD12 high-voltage detect flag. */
      vuint32_t  :1;
      vuint32_t VD10:1;                /* HVD occurrence detected on the high voltage 3.60 V supply. */
      vuint32_t VD9:1;                 /* VD9 low-voltage detect flag. */
      vuint32_t VD8:1;                 /* VD8 high-voltage detect flag. */
      vuint32_t VD7:1;                 /* VD7 high-voltage detect flag. */
      vuint32_t  :2;
      vuint32_t VD4:1;                 /* VD4 low-voltage detect flag. */
      vuint32_t VD3:1;                 /* VD3 low-voltage detect flag. */
      vuint32_t  :3;                   /* Reserved */
    } B;
  } GR_S;

  union {                              /* Pending Gauge Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t VD15_A:1;              /* VD15_A high-voltage detect flag. */
      vuint32_t VD15_C:1;              /* VD15_C high-voltage detect flag. */
      vuint32_t  :1;
      vuint32_t VD14_A:1;              /* VD14_A low-voltage detect flag. */
      vuint32_t VD14_IM:1;             /* VD14_IM low-voltage detect flag. */
      vuint32_t  :2;
      vuint32_t VD13_IM:1;             /* VD13_IM low-voltage detect flag. */
      vuint32_t VD12_F:1;              /* VD12_F high-voltage detect flag. */
      vuint32_t VD10_A:1;              /* VD10_A low-voltage detect flag. */
      vuint32_t VD10_F:1;              /* VD10_F low-voltage detect flag. */
      vuint32_t VD9_O:1;               /* VD9_O low-voltage detect flag. */
      vuint32_t VD9_IF2:1;             /* VD9_IF2 low-voltage detect flag. */
      vuint32_t VD9_IF:1;              /* VD9_IF low-voltage detect flag. */
      vuint32_t VD9_IJ:1;              /* VD9_IJ low-voltage detect flag. */
      vuint32_t VD9_IM:1;              /* VD9_IM low-voltage detect flag. */
      vuint32_t VD9_F:1;               /* VD9_F low-voltage detect flag. */
      vuint32_t VD9_EBI:1;             /* VD9_EBI low-voltage detect flag. */
      vuint32_t VD9_C:1;               /* VD9_C low-voltage detect flag. */
      vuint32_t VD8_C:1;               /* VD8_C high-voltage detect flag. */
      vuint32_t VD8_F:1;               /* VD8_F high-voltage detect flag. */
      vuint32_t VD7_C:1;               /* VD7_C high-voltage detect flag. */
      vuint32_t VD4_C:1;               /* VD4_C low-voltage detect flag. */
      vuint32_t VD3_P:1;               /* VD3_P low-voltage detect flag. */
      vuint32_t VD3_F:1;               /* VD3_F low-voltage detect flag. */
      vuint32_t VD3_C:1;               /* VD3_C low-voltage detect flag. */
    } B;
  } GR_P;

  union {                              /* Interrupt Enable Pending Register */
    vuint32_t R;
    struct {
      vuint32_t IE_EN:1;
      vuint32_t  :5;
      vuint32_t VD15IE_A:1;            /* VD15IE_A Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD15IE_C:1;            /* VD15IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t  :1;
      vuint32_t VD14IE_A:1;            /* VD14IE_A Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD14IE_IM:1;           /* VD14IE_IM Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t  :2;
      vuint32_t VD13IE_IM:1;           /* VD13IE_IM Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD12IE_F:1;            /* VD12IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD10IE_A:1;            /* VD10IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD10IE_F:1;            /* VD10IE_A Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_O:1;             /* VD9IE_O Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_IF2:1;           /* VD9IE_IF2 Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_IF:1;            /* VD9IE_IF Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_IJ:1;            /* VD9IE_IJ Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_IM:1;            /* VD9IE_IM Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_F:1;             /* VD9IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_EBI:1;           /* VD9IE_EBI Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD9IE_C:1;             /* VD9IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD8IE_C:1;             /* VD8IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD8IE_F:1;             /* VD8IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD7IE_C:1;             /* VD7IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD4IE_C:1;             /* VD4IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD3IE_P:1;             /* VD3IE_P Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD3IE_F:1;             /* VD3IE_F Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
      vuint32_t VD3IE_C:1;             /* VD3IE_C Interrupt Enable. This bit determines whether an interrupt is seen by the system when the voltage detect event occurs. */
    } B;
  } IE_P;

  uint8_t PMCDIG_reserved0[36];
  union {                              /* Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t LVD3_P:1;              /* LVD3_P flag. */
      vuint32_t LVD3_F:1;              /* LVD3_F flag. */
      vuint32_t  :5;
      vuint32_t LVD3_C:1;              /* LVD3_C flag. */
    } B;
  } EPR_VD3;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t LVD3_P:1;              /* LVD3_P reset enable. */
      vuint32_t LVD3_F:1;              /* LVD3_F reset enable. */
      vuint32_t  :5;
      vuint32_t LVD3_C:1;              /* LVD3_C reset enable. */
    } B;
  } REE_VD3;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t LVD3_P:1;              /* LVD3_P reset event select. */
      vuint32_t LVD3_F:1;              /* LVD3_F reset event select. */
      vuint32_t  :5;
      vuint32_t LVD3_C:1;              /* LVD3_C reset event select. */
    } B;
  } RES_VD3;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t FEE3_P:1;              /* FEE3_P FCCU event enable. */
      vuint32_t FEE3_F:1;              /* FEE3_F FCCU event enable. */
      vuint32_t  :5;
      vuint32_t FEE3_C:1;              /* FEE3_C FCCU event enable. */
    } B;
  } FEE_VD3;

  union {                              /* LVD108 Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t LVD4_C:1;              /* LVD4_C flag. */
    } B;
  } EPR_VD4;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t LVD4_C:1;              /* LVD4_C reset enable. */
    } B;
  } REE_VD4;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t LVD4_C:1;              /* LVD4_H reset event select. */
    } B;
  } RES_VD4;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t FEE4_C:1;              /* FEE4_C FCCU event enable. */
    } B;
  } FEE_VD4;

  uint8_t PMCDIG_reserved1[32];
  union {                              /* Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :9;
      vuint32_t  :1;
      vuint32_t  :5;
      vuint32_t HVD7_C:1;              /* HVD7_C flag. */
    } B;
  } EPR_VD7;

  union {                              /* Reset Event Enable VD7 Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :9;
      vuint32_t  :1;
      vuint32_t  :5;
      vuint32_t HVD7_C:1;              /* HVD7_C reset enable. */
    } B;
  } REE_VD7;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :9;
      vuint32_t  :1;
      vuint32_t  :5;
      vuint32_t HVD7_C:1;              /* HVD7_C reset event select. */
    } B;
  } RES_VD7;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t  :9;
      vuint32_t  :1;
      vuint32_t  :5;
      vuint32_t FEE7_C:1;              /* FEE7_C FCCU event enable. This bit defines whether an HVD assertion on the supply of the cold point generates an FCCU event. */
    } B;
  } FEE_VD7;

  union {                              /* Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t HVD8_F:1;              /* HVD8_F flag. */
      vuint32_t  :5;                   /* Reserved. */
      vuint32_t HVD8_C:1;              /* HVD8_C flag. */
    } B;
  } EPR_VD8;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t HVD8_F:1;              /* HVD8_F reset enable. */
      vuint32_t  :5;                   /* Reserved. */
      vuint32_t HVD8_C:1;              /* HVD8_C reset enable. */
    } B;
  } REE_VD8;

  union {                              /* Reset Event Select Registerr */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t HVD8_F:1;              /* HVD8_F reset event select */
      vuint32_t  :5;                   /* Reserved. */
      vuint32_t HVD8_C:1;              /* HVD8_C reset event select. */
    } B;
  } RES_VD8;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t FEE8_F:1;              /* FEE8_F FCCU event enable. */
      vuint32_t  :5;
      vuint32_t FEE8_C:1;              /* FEE8_C FCCU event enable. */
    } B;
  } FEE_VD8;

  union {                              /* LVD270 Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t LVD9_O:1;              /* LVD9_O flag. */
      vuint32_t  :2;
      vuint32_t LVD9_IF2:1;            /* LVD9_IF2 flag. */
      vuint32_t LVD9_IF:1;             /* LVD9_IF flag. */
      vuint32_t LVD9_IJ:1;             /* LVD9_IJ flag. */
      vuint32_t LVD9_IM:1;             /* LVD9_IM flag. */
      vuint32_t  :1;
      vuint32_t LVD9_F:1;              /* LVD9_F flag. */
      vuint32_t  :2;
      vuint32_t LVD9_EBI:1;            /* LVD9_EBI flag. */
      vuint32_t  :2;
      vuint32_t LVD9_C:1;              /* LVD9_C flag. */
    } B;
  } EPR_VD9;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t LVD9_O:1;              /* LVD9_O reset enable. */
      vuint32_t  :2;
      vuint32_t LVD9_IF2:1;            /* LVD9_IF2 reset enable. */
      vuint32_t LVD9_IF:1;             /* LVD9_IF reset enable. */
      vuint32_t LVD9_IJ:1;             /* LVD9_IJ reset enable. */
      vuint32_t LVD9_IM:1;             /* LVD9_IM reset enable. */
      vuint32_t  :1;
      vuint32_t LVD9_F:1;              /* LVD9_F reset enable. */
      vuint32_t  :2;
      vuint32_t LVD9_EBI:1;            /* LVD9_EBI reset enable. */
      vuint32_t  :2;
      vuint32_t LVD9_C:1;              /* LVD9_C reset enable. */
    } B;
  } REE_VD9;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t LVD9_IF2:1;            /* LVD9_IF2 reset event select. */
      vuint32_t LVD9_IF:1;             /* LVD9_IF reset event select. */
      vuint32_t  :6;
      vuint32_t LVD9_EBI:1;            /* LVD9_EBI reset event select. */
      vuint32_t  :3;
    } B;
  } RES_VD9;

  union {                              /* FCCU Event Enable VD9 */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t FEE9_O:1;              /* FEE9_O FCCU event enable. */
      vuint32_t  :2;
      vuint32_t FEE9_IF2:1;            /* FEE9_IF2 FCCU event enable. */
      vuint32_t FEE9_IF:1;             /* FEE9_IF FCCU event enable. */
      vuint32_t FEE9_IJ:1;             /* FEE9_IJ FCCU event enable. */
      vuint32_t FEE9_IM:1;             /* FEE9_IM FCCU event enable. */
      vuint32_t  :1;
      vuint32_t FEE9_F:1;              /* FEE9_F FCCU event enable. */
      vuint32_t  :2;
      vuint32_t FEE9_EBI:1;            /* FEE9_EBI FCCU event enable. */
      vuint32_t  :2;
      vuint32_t FEE9_C:1;              /* FEE9_C FCCU event enable. */
    } B;
  } FEE_VD9;

  union {                              /* LVD295 Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD10_A:1;             /* LVD10_A flag. */
      vuint32_t  :8;
      vuint32_t LVD10_F:1;             /* LVD10_F flag. */
      vuint32_t  :6;
    } B;
  } EPR_VD10;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD10_A:1;             /* LVD10_A reset enable. */
      vuint32_t  :8;
      vuint32_t LVD10_F:1;             /* LVD10_F reset enable. */
      vuint32_t  :6;
    } B;
  } REE_VD10;

  uint8_t PMCDIG_reserved2[4];
  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FEE10_A:1;             /* FEE10_A FCCU event enable. */
      vuint32_t  :8;
      vuint32_t FEE10_F:1;             /* FEE10_F FCCU event enable. */
      vuint32_t  :6;
    } B;
  } FEE_VD10;

  uint8_t PMCDIG_reserved3[16];
  union {                              /* HVD360 Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t HVD12_F:1;             /* HVD12_F flag. */
      vuint32_t  :6;
    } B;
  } EPR_VD12;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t HVD12_F:1;             /* HVD12_F reset enable. */
      vuint32_t  :6;
    } B;
  } REE_VD12;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t HVD12_F:1;             /* HVD12_F reset event select. */
      vuint32_t  :6;
    } B;
  } RES_VD12;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :25;
      vuint32_t FEE12_F:1;             /* FEE12_F FCCU event enable. */
      vuint32_t  :6;
    } B;
  } FEE_VD12;

  union {                              /* Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t LVD13_IM:1;            /* LVD13_IM flag. */
      vuint32_t  :8;
    } B;
  } EPR_VD13;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t LVD13_IM:1;            /* LVD13_IM reset enable. */
      vuint32_t  :8;
    } B;
  } REE_VD13;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t LVD13_IM:1;            /* LVD13_IM reset event select. */
      vuint32_t  :8;
    } B;
  } RES_VD13;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :23;
      vuint32_t FEE13_IM:1;            /* FEE13_IM FCCU event enable. */
      vuint32_t  :8;
    } B;
  } FEE_VD13;

  union {                              /* Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD14_A:1;             /* LVD14_A flag. */
      vuint32_t  :6;
      vuint32_t LVD14_IM:1;            /* LVD14_IM flag. */
      vuint32_t  :8;
    } B;
  } EPR_VD14;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD14_A:1;             /* LVD14_A reset enable. */
      vuint32_t  :6;
      vuint32_t LVD14_IM:1;            /* LVD14_IM reset enable. */
      vuint32_t  :8;
    } B;
  } REE_VD14;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LVD14_A:1;             /* LVD14_A reset event select. */
      vuint32_t  :6;
      vuint32_t LVD14_IM:1;            /* LVD14_IM reset event select. */
      vuint32_t  :8;
    } B;
  } RES_VD14;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FEE14_A:1;             /* FEE14_A FCCU event enable. */
      vuint32_t  :6;
      vuint32_t FEE14_IM:1;            /* FEE14_IM FCCU event enable. */
      vuint32_t  :8;
    } B;
  } FEE_VD14;

  union {                              /* Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HVD15_A:1;             /* HVD15_A flag. */
      vuint32_t  :14;
      vuint32_t HVD15_C:1;             /* HVD15_C flag. */
    } B;
  } EPR_VD15;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HVD15_A:1;             /* HVD15_A reset enable. */
      vuint32_t  :14;
      vuint32_t HVD15_C:1;
    } B;
  } REE_VD15;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t HVD15_A:1;             /* HVD15_A reset event select. */
      vuint32_t  :14;
      vuint32_t HVD15_C:1;             /* HVD15_C reset event select. */
    } B;
  } RES_VD15;

  union {                              /* FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t FEE15_A:1;             /* FEE15_A FCCU event enable. */
      vuint32_t  :14;
      vuint32_t FEE15_C:1;             /* FEE15_C FCCU event enable. */
    } B;
  } FEE_VD15;

  uint8_t PMCDIG_reserved4[4];
  union {                              /* Voltage Supply for I/O Segment Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t VSIO_IF2:1;            /* VSIO_IF2 control. */
      vuint32_t VSIO_IF:1;             /* VSIO_IF control. */
      vuint32_t VSIO_IJ:1;             /* VSIO_IJ control. */
      vuint32_t VSIO_IM:1;             /* VSIO_IM control. */
      vuint32_t  :8;
    } B;
  } VSIO;

  uint8_t PMCDIG_reserved5[504];
  union {                              /* Event Pending Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TEMP_3:1;              /* TEMP_3 flag. */
      vuint32_t TEMP_2:1;              /* TEMP_2 flag. */
      vuint32_t  :1;
      vuint32_t TEMP_0:1;              /* TEMP_0 flag. */
    } B;
  } EPR_TD;

  union {                              /* Reset Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TEMP_3:1;              /* TEMP_3 reset enable. */
      vuint32_t TEMP_2:1;              /* TEMP_2 reset enable. */
      vuint32_t  :1;
      vuint32_t TEMP_0:1;              /* TEMP_0 reset enable. */
    } B;
  } REE_TD;

  union {                              /* Reset Event Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t TEMP_3:1;              /* TEMP_3 reset event select. */
      vuint32_t TEMP_2:1;              /* TEMP_2 reset event select. */
      vuint32_t  :1;
      vuint32_t TEMP_0:1;              /* TEMP_0 reset event select. */
    } B;
  } RES_TD;

  union {                              /* Temperature Sensor Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t TS3IE:1;               /* TS3IE Temperature Sensor input 3 Interrupt Enable. */
      vuint32_t TS2IE:1;               /* TS2IE Temperature Sensor input 0 Interrupt Enable. */
      vuint32_t TS0IE:1;               /* TS0IE Temperature Sensor input 0 Interrupt Enable. */
      vuint32_t  :1;
      vuint32_t TRIM_ADJ_OVER:4;       /* Customer adjustable over trim register. */
      vuint32_t  :2;
      vuint32_t TRIM_ADJ_UNDER:4;      /* Customer adjustable trim register. */
      vuint32_t DOUT_EN:1;             /* Digital Output Enable. */
      vuint32_t AOUT_EN:1;             /* Analog Output Enable. */
    } B;
  } CTL_TD;

  uint8_t PMCDIG_reserved6[8];
  union {                              /* Temp Sensor FCCU Event Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FEE_TS3:1;             /* FEE_TS3 Temp Sensor FCCU event enable. */
      vuint32_t FEE_TS2:1;             /* FEE_TS2 Temp Sensor FCCU event enable. */
      vuint32_t  :1;
      vuint32_t FEE_TS0:1;             /* FEE_TS0 Temp Sensor FCCU event enable. */
    } B;
  } FEE_TD;

  uint8_t PMCDIG_reserved7[36];
  union {                              /* Voltage Detect User Mode Test Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t VOLT4_EN:1;            /* VOLT4 enable. */
      vuint32_t VOLT3_EN:1;            /* VOLT3 enable. */
      vuint32_t VOLT2_EN:1;            /* VOLT2 enable. */
      vuint32_t VOLT1_EN:1;            /* VOLT1 enable. */
      vuint32_t  :4;                   /* Reserved. */
      vuint32_t VOLT4:1;               /* VOLT4 flag. */
      vuint32_t VOLT3:1;               /* VOLT3 flag. */
      vuint32_t VOLT2:1;               /* VOLT2 flag. */
      vuint32_t VOLT1:1;               /* VOLT1 flag. */
      vuint32_t  :10;
      vuint32_t VD_UTST:6;             /* Voltage Detect: User Test. */
    } B;
  } VD_UTST;

  union {                              /* ADC Channel Select Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t ADC_CS:6;              /* ADC_CS Channel Select. */
    } B;
  } ADC_CH;

  uint8_t PMCDIG_reserved8[4];
  union {                              /* Voltage Regulator 1.2V Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t VREG1P2_DIS:1;         /* This bit controls if the AUX Regulator (Vreg1p2) is disabled. */
    } B;
  } VREG1P2_CTRL;

  union {                              /* Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;                  /* Reserved. */
      vuint32_t ADC_CHSEL_EN:1;        /* This bit allows the ADC_CS bits int he ADC_CH register to be enabled. */
      vuint32_t USER_SELF_TEST_EN:1;   /* This bit allows the VD_UTST bits int he VD_UTST register to be enabled. */
      vuint32_t  :6;                   /* Reserved. */
      vuint32_t TEST_PIN:1;            /* This bit is indicates the current value of the Test Pin. */
      vuint32_t  :6;                   /* Reserved. */
      vuint32_t SBRAM_BRDET:1;         /* SBRAM_BRDET. */
    } B;
  } MCR;
};


/* ============================================================================
   =============================== Module: PRAMC ==============================
   ============================================================================ */

struct PRAMC_tag {
  union {                              /* Platform RAM Configuration Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t PRI:2;                 /* AHB port arbitration mode. */
      vuint32_t P1_BO_DIS:1;           /* Port p1 read burst optimization disable. */
      vuint32_t P0_BO_DIS:1;           /* Port p0 read burst optimization disable. */
      vuint32_t P1_RB_DIS:1;           /* Port p1 read buffer disable. */
      vuint32_t P0_RB_DIS:1;           /* Port p0 read buffer disable. */
      vuint32_t  :3;
      vuint32_t FT_DIS:1;              /* Flow through disabled. */
    } B;
  } PRCR1;
};


/* ============================================================================
   =============================== Module: PSI5 ===============================
   ============================================================================ */

struct PSI5_tag {
  union {                              /* Global Control Register */
    vuint16_t R;
    struct {
      vuint16_t  :14;
      vuint16_t CTC_GED:1;
      vuint16_t GLOBAL_DISABLE_REQ:1;
    } B;
  } GCR;

  uint8_t PSI5_reserved0[6];
  union {                              /* PSI5 Channel Control Register */
    vuint32_t R;
    struct {
      vuint32_t CTC_GED_SEL:1;
      vuint32_t CTC_ED:1;
      vuint32_t  :1;
      vuint32_t MEM_DEPTH:5;
      vuint32_t  :3;
      vuint32_t ERROR_SELECT4:1;
      vuint32_t ERROR_SELECT3:1;
      vuint32_t ERROR_SELECT2:1;
      vuint32_t ERROR_SELECT1:1;
      vuint32_t ERROR_SELECT0:1;
      vuint32_t  :1;
      vuint32_t GTM_RESET_ASYNC_EN:1;
      vuint32_t  :3;
      vuint32_t DEBUG_EN:1;
      vuint32_t DEBUG_FREEZE_CTRL:1;
      vuint32_t SP_TS_CLK_SEL:1;
      vuint32_t  :2;
      vuint32_t FAST_CLR_SMC:1;
      vuint32_t FAST_CLR_PSI5:1;
      vuint32_t BIT_RATE:1;
      vuint32_t MODE:1;
      vuint32_t PSI5_CH_CONFIG:1;
      vuint32_t PSI5_CH_EN:1;
    } B;
  } CH0_PCCR;

  union {                              /* DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DMA_PM_DS_WM:5;
      vuint32_t  :5;
      vuint32_t IE_DMA_TF_SF:1;
      vuint32_t IE_DMA_TF_PM_DS:1;
      vuint32_t  :5;
      vuint32_t IE_DMA_PM_DS_FIFO_FULL:1;
      vuint32_t IE_DMA_SFUF:1;
      vuint32_t  :1;
      vuint32_t IE_DMA_PM_DS_UF:1;
      vuint32_t  :5;
      vuint32_t DMA_EN_SF:1;
      vuint32_t DMA_PM_DS_CONFIG:2;
    } B;
  } CH0_DCR;

  union {                              /* DMA Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t IS_DMA_TF_SF:1;
      vuint32_t IS_DMA_TF_PM_DS:1;
      vuint32_t  :5;
      vuint32_t IS_DMA_PM_DS_FIFO_FULL:1;
      vuint32_t IS_DMA_SFUF:1;
      vuint32_t  :1;
      vuint32_t IS_DMA_PM_DS_UF:1;
      vuint32_t  :8;
    } B;
  } CH0_DSR;

  union {                              /* General Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t IE_CESM:6;
      vuint32_t IE_STS:1;
      vuint32_t IE_DTS:1;
      vuint32_t IE_DSROW:1;
      vuint32_t IE_BROW:1;
      vuint32_t IE_PROW:1;
      vuint32_t IE_DSRR:1;
      vuint32_t IE_BRR:1;
      vuint32_t IE_PRR:1;
      vuint32_t  :2;
      vuint32_t IE_OWSM:6;
      vuint32_t  :2;
      vuint32_t IE_NVSM:6;
    } B;
  } CH0_GICR;

  union {                              /* New Data Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_ND:32;
    } B;
  } CH0_NDICR;

  union {                              /* Overwrite Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_OW:32;
    } B;
  } CH0_OWICR;

  union {                              /* Error Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_ERROR:32;
    } B;
  } CH0_EICR;

  union {                              /* General Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t IS_DB_FR:1;
      vuint32_t  :1;
      vuint32_t IS_CESM:6;
      vuint32_t IS_STS:1;
      vuint32_t IS_DTS:1;
      vuint32_t IS_DSROW:1;
      vuint32_t IS_BROW:1;
      vuint32_t IS_PROW:1;
      vuint32_t DSR_RDY:1;
      vuint32_t DBR_RDY:1;
      vuint32_t DPR_RDY:1;
      vuint32_t  :2;
      vuint32_t IS_OWSM:6;
      vuint32_t  :2;
      vuint32_t IS_NVSM:6;
    } B;
  } CH0_GISR;

  union {                              /* DMA PSI5 Message Register */
    vuint32_t R;
    struct {
      vuint32_t PSI5_RXDATA:32;
    } B;
  } CH0_DPMR;

  union {                              /* DMA SMC Frame Register */
    vuint32_t R;
    struct {
      vuint32_t SMC_RXDATA:32;
    } B;
  } CH0_DSFR;

  union {                              /* DMA Diagnostic Status Register */
    vuint32_t R;
    struct {
      vuint32_t DDS:32;
    } B;
  } CH0_DDSR;

  union {                              /* PSI5 Message Receive Register Low */
    vuint32_t R;
    struct {
      vuint32_t DATA_REGION:28;
      vuint32_t CRC:3;
      vuint32_t C:1;
    } B;
  } CH0_PMRRL;

  union {                              /* PSI5 Message Receive Register High */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t F:1;
      vuint32_t EM:1;
      vuint32_t E:1;
      vuint32_t T:1;
      vuint32_t SlotCounter:3;
      vuint32_t TimeStampValue:24;
    } B;
  } CH0_PMRRH;

  struct {
    union {                            /* PSI5 Message Register Low i */
      vuint32_t R;
      struct {
        vuint32_t DATA_REGION:28;
        vuint32_t CRCP:3;
        vuint32_t C:1;
      } B;
    } PMRL;
    union {                            /* PSI5 Message Register High i */
      vuint32_t R;
      struct {
        vuint32_t O:1;
        vuint32_t F:1;
        vuint32_t EM:1;
        vuint32_t E:1;
        vuint32_t T:1;
        vuint32_t Slot_Counter:3;
        vuint32_t TimeStampValue:24;
      } B;
    } PMRH;
  } CH0[32];

  union {                              /* SMC Frame Register n */
    vuint32_t R;
    struct {
      vuint32_t SLOT_NO:3;
      vuint32_t CER:1;
      vuint32_t OW:1;
      vuint32_t CRC:6;
      vuint32_t C:1;
      vuint32_t ID:4;
      vuint32_t IDDATA:4;
      vuint32_t DATA:12;
    } B;
  } CH0_SFR[6];

  union {                              /* New Data Status Register */
    vuint32_t R;
    struct {
      vuint32_t NDS:32;
    } B;
  } CH0_NDSR;

  union {                              /* Overwrite Status Register */
    vuint32_t R;
    struct {
      vuint32_t OWS:32;
    } B;
  } CH0_OWSR;

  union {                              /* Error Indication Status Register */
    vuint32_t R;
    struct {
      vuint32_t ERROR:32;
    } B;
  } CH0_EISR;

  union {                              /* Set New Data Status Register */
    vuint32_t R;
    struct {
      vuint32_t SNDS:32;
    } B;
  } CH0_SNDSR;

  union {                              /* Set Overwrite Status Register */
    vuint32_t R;
    struct {
      vuint32_t SOWS:32;
    } B;
  } CH0_SOWSR;

  union {                              /* Set Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t SERROR:32;
    } B;
  } CH0_SEISR;

  union {                              /* Set SMC Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t SCESM:6;
      vuint32_t  :10;
      vuint32_t SOWSM:6;
      vuint32_t  :2;
      vuint32_t SNVSM:6;
    } B;
  } CH0_SSESR;

  union {                              /* Sync Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t STSV:24;
    } B;
  } CH0_STSRR;

  union {                              /* Data Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SLOT_COUNTER:3;
      vuint32_t DTSV:24;
    } B;
  } CH0_DTSRR;

  union {                              /* Slot n Frame Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SLOT_EN:1;
      vuint32_t TS_CAPT:1;
      vuint32_t  :1;
      vuint32_t SMCL:1;
      vuint32_t  :9;
      vuint32_t DRL:5;
      vuint32_t CRCP:1;
    } B;
  } CH0_SFCR[6];

  union {                              /* Slot 1 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S1SBT:15;
    } B;
  } CH0_S1SBR;

  union {                              /* Slot 2 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S2SBT:15;
    } B;
  } CH0_S2SBR;

  union {                              /* Slot 3 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S3SBT:15;
    } B;
  } CH0_S3SBR;

  union {                              /* Slot 4 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S4SBT:15;
    } B;
  } CH0_S4SBR;

  union {                              /* Slot 5 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S5SBT:15;
    } B;
  } CH0_S5SBR;

  union {                              /* Slot 6 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S6SBT:15;
    } B;
  } CH0_S6SBR;

  union {                              /* Slot n End Boundary Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SLOT_NO:3;
      vuint32_t  :1;
      vuint32_t SnEBT:15;
    } B;
  } CH0_SnEBR;

  union {                              /* Data Output Block Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t DATA_LENGTH:6;
      vuint16_t DBR_RST:1;
      vuint16_t DSR_RST:1;
      vuint16_t CMD_TYPE:3;
      vuint16_t DEFAULT_SYNC:1;
      vuint16_t GTM_TRIG_SEL:1;
      vuint16_t SP_PULSE_SEL:1;
      vuint16_t OP_SEL:1;
      vuint16_t SW_READY:1;
    } B;
  } CH0_DOBCR;

  union {                              /* Manchestor Decoder Disable Offset */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t MDDIS_OFF:7;
    } B;
  } CH0_MDDIS_OFF;

  union {                              /* Pulse Width for Data Bit Value 0 */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t Pulse_Width0:7;
    } B;
  } CH0_PW0D;

  union {                              /* Pulse Width for Data Bit Value 1 */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t Pulse_Width1:7;
    } B;
  } CH0_PW1D;

  union {                              /* Counter Target Pulse Register */
    vuint16_t R;
    struct {
      vuint16_t CTPR:16;
    } B;
  } CH0_CTPR;

  union {                              /* Counter Initialize Pulse Register */
    vuint16_t R;
    struct {
      vuint16_t CIPR:16;
    } B;
  } CH0_CIPR;

  union {                              /* Data Preparation Register Low */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DPR:24;
    } B;
  } CH0_DPRL;

  union {                              /* Data Preparation Register High */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } CH0_DPRH;

  union {                              /* Data Buffer Register Low */
    vuint32_t R;
    struct {
      vuint32_t DBR:32;
    } B;
  } CH0_DBRL;

  union {                              /* Data Buffer Register High */
    vuint32_t R;
    struct {
      vuint32_t DBR:32;
    } B;
  } CH0_DBRH;

  union {                              /* Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DSR:32;
    } B;
  } CH0_DSRL;

  union {                              /* Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t DSR:32;
    } B;
  } CH0_DSRH;

  uint8_t PSI5_reserved1[4];
  union {                              /* PSI5 Channel Control Register */
    vuint32_t R;
    struct {
      vuint32_t CTC_GED_SEL:1;
      vuint32_t CTC_ED:1;
      vuint32_t  :1;
      vuint32_t MEM_DEPTH:5;
      vuint32_t  :3;
      vuint32_t ERROR_SELECT4:1;
      vuint32_t ERROR_SELECT3:1;
      vuint32_t ERROR_SELECT2:1;
      vuint32_t ERROR_SELECT1:1;
      vuint32_t ERROR_SELECT0:1;
      vuint32_t  :1;
      vuint32_t GTM_RESET_ASYNC_EN:1;
      vuint32_t  :3;
      vuint32_t DEBUG_EN:1;
      vuint32_t DEBUG_FREEZE_CTRL:1;
      vuint32_t SP_TS_CLK_SEL:1;
      vuint32_t  :2;
      vuint32_t FAST_CLR_SMC:1;
      vuint32_t FAST_CLR_PSI5:1;
      vuint32_t BIT_RATE:1;
      vuint32_t MODE:1;
      vuint32_t PSI5_CH_CONFIG:1;
      vuint32_t PSI5_CH_EN:1;
    } B;
  } CH1_PCCR;

  union {                              /* DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DMA_PM_DS_WM:5;
      vuint32_t  :5;
      vuint32_t IE_DMA_TF_SF:1;
      vuint32_t IE_DMA_TF_PM_DS:1;
      vuint32_t  :5;
      vuint32_t IE_DMA_PM_DS_FIFO_FULL:1;
      vuint32_t IE_DMA_SFUF:1;
      vuint32_t  :1;
      vuint32_t IE_DMA_PM_DS_UF:1;
      vuint32_t  :5;
      vuint32_t DMA_EN_SF:1;
      vuint32_t DMA_PM_DS_CONFIG:2;
    } B;
  } CH1_DCR;

  union {                              /* DMA Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t IS_DMA_TF_SF:1;
      vuint32_t IS_DMA_TF_PM_DS:1;
      vuint32_t  :5;
      vuint32_t IS_DMA_PM_DS_FIFO_FULL:1;
      vuint32_t IS_DMA_SFUF:1;
      vuint32_t  :1;
      vuint32_t IS_DMA_PM_DS_UF:1;
      vuint32_t  :8;
    } B;
  } CH1_DSR;

  union {                              /* General Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t IE_CESM:6;
      vuint32_t IE_STS:1;
      vuint32_t IE_DTS:1;
      vuint32_t IE_DSROW:1;
      vuint32_t IE_BROW:1;
      vuint32_t IE_PROW:1;
      vuint32_t IE_DSRR:1;
      vuint32_t IE_BRR:1;
      vuint32_t IE_PRR:1;
      vuint32_t  :2;
      vuint32_t IE_OWSM:6;
      vuint32_t  :2;
      vuint32_t IE_NVSM:6;
    } B;
  } CH1_GICR;

  union {                              /* New Data Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_ND:32;
    } B;
  } CH1_NDICR;

  union {                              /* Overwrite Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_OW:32;
    } B;
  } CH1_OWICR;

  union {                              /* Error Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_ERROR:32;
    } B;
  } CH1_EICR;

  union {                              /* General Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t IS_DB_FR:1;
      vuint32_t  :1;
      vuint32_t IS_CESM:6;
      vuint32_t IS_STS:1;
      vuint32_t IS_DTS:1;
      vuint32_t IS_DSROW:1;
      vuint32_t IS_BROW:1;
      vuint32_t IS_PROW:1;
      vuint32_t DSR_RDY:1;
      vuint32_t DBR_RDY:1;
      vuint32_t DPR_RDY:1;
      vuint32_t  :2;
      vuint32_t IS_OWSM:6;
      vuint32_t  :2;
      vuint32_t IS_NVSM:6;
    } B;
  } CH1_GISR;

  union {                              /* DMA PSI5 Message Register */
    vuint32_t R;
    struct {
      vuint32_t PSI5_RXDATA:32;
    } B;
  } CH1_DPMR;

  union {                              /* DMA SMC Frame Register */
    vuint32_t R;
    struct {
      vuint32_t SMC_RXDATA:32;
    } B;
  } CH1_DSFR;

  union {                              /* DMA Diagnostic Status Register */
    vuint32_t R;
    struct {
      vuint32_t DDS:32;
    } B;
  } CH1_DDSR;

  union {                              /* PSI5 Message Receive Register Low */
    vuint32_t R;
    struct {
      vuint32_t DATA_REGION:28;
      vuint32_t CRC:3;
      vuint32_t C:1;
    } B;
  } CH1_PMRRL;

  union {                              /* PSI5 Message Receive Register High */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t F:1;
      vuint32_t EM:1;
      vuint32_t E:1;
      vuint32_t T:1;
      vuint32_t SlotCounter:3;
      vuint32_t TimeStampValue:24;
    } B;
  } CH1_PMRRH;

  struct {
    union {                            /* PSI5 Message Register Low i */
      vuint32_t R;
      struct {
        vuint32_t DATA_REGION:28;
        vuint32_t CRCP:3;
        vuint32_t C:1;
      } B;
    } PMRL;
    union {                            /* PSI5 Message Register High i */
      vuint32_t R;
      struct {
        vuint32_t O:1;
        vuint32_t F:1;
        vuint32_t EM:1;
        vuint32_t E:1;
        vuint32_t T:1;
        vuint32_t Slot_Counter:3;
        vuint32_t TimeStampValue:24;
      } B;
    } PMRH;
  } CH1[32];

  union {                              /* SMC Frame Register n */
    vuint32_t R;
    struct {
      vuint32_t SLOT_NO:3;
      vuint32_t CER:1;
      vuint32_t OW:1;
      vuint32_t CRC:6;
      vuint32_t C:1;
      vuint32_t ID:4;
      vuint32_t IDDATA:4;
      vuint32_t DATA:12;
    } B;
  } CH1_SFR[6];

  union {                              /* New Data Status Register */
    vuint32_t R;
    struct {
      vuint32_t NDS:32;
    } B;
  } CH1_NDSR;

  union {                              /* Overwrite Status Register */
    vuint32_t R;
    struct {
      vuint32_t OWS:32;
    } B;
  } CH1_OWSR;

  union {                              /* Error Indication Status Register */
    vuint32_t R;
    struct {
      vuint32_t ERROR:32;
    } B;
  } CH1_EISR;

  union {                              /* Set New Data Status Register */
    vuint32_t R;
    struct {
      vuint32_t SNDS:32;
    } B;
  } CH1_SNDSR;

  union {                              /* Set Overwrite Status Register */
    vuint32_t R;
    struct {
      vuint32_t SOWS:32;
    } B;
  } CH1_SOWSR;

  union {                              /* Set Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t SERROR:32;
    } B;
  } CH1_SEISR;

  union {                              /* Set SMC Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t SCESM:6;
      vuint32_t  :10;
      vuint32_t SOWSM:6;
      vuint32_t  :2;
      vuint32_t SNVSM:6;
    } B;
  } CH1_SSESR;

  union {                              /* Sync Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t STSV:24;
    } B;
  } CH1_STSRR;

  union {                              /* Data Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SLOT_COUNTER:3;
      vuint32_t DTSV:24;
    } B;
  } CH1_DTSRR;

  union {                              /* Slot n Frame Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SLOT_EN:1;             /* SLOT_EN */
      vuint32_t TS_CAPT:1;             /* TS_CAPT */
      vuint32_t  :1;
      vuint32_t SMCL:1;
      vuint32_t  :9;
      vuint32_t DRL:5;
      vuint32_t CRCP:1;                /* CRCP */
    } B;
  } CH1_SFCR[6];

  union {                              /* Slot 1 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S1SBT:15;
    } B;
  } CH1_S1SBR;

  union {                              /* Slot 2 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S2SBT:15;
    } B;
  } CH1_S2SBR;

  union {                              /* Slot 3 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S3SBT:15;
    } B;
  } CH1_S3SBR;

  union {                              /* Slot 4 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S4SBT:15;
    } B;
  } CH1_S4SBR;

  union {                              /* Slot 5 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S5SBT:15;
    } B;
  } CH1_S5SBR;

  union {                              /* Slot 6 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S6SBT:15;
    } B;
  } CH1_S6SBR;

  union {                              /* Slot n End Boundary Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SLOT_NO:3;
      vuint32_t  :1;
      vuint32_t SnEBT:15;
    } B;
  } CH1_SnEBR;

  union {                              /* Data Output Block Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t DATA_LENGTH:6;
      vuint16_t DBR_RST:1;
      vuint16_t DSR_RST:1;
      vuint16_t CMD_TYPE:3;
      vuint16_t DEFAULT_SYNC:1;
      vuint16_t GTM_TRIG_SEL:1;
      vuint16_t SP_PULSE_SEL:1;
      vuint16_t OP_SEL:1;
      vuint16_t SW_READY:1;
    } B;
  } CH1_DOBCR;

  union {                              /* Manchestor Decoder Disable Offset */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t MDDIS_OFF:7;
    } B;
  } CH1_MDDIS_OFF;

  union {                              /* Pulse Width for Data Bit Value 0 */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t Pulse_Width0:7;
    } B;
  } CH1_PW0D;

  union {                              /* Pulse Width for Data Bit Value 1 */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t Pulse_Width1:7;
    } B;
  } CH1_PW1D;

  union {                              /* Counter Target Pulse Register */
    vuint16_t R;
    struct {
      vuint16_t CTPR:16;
    } B;
  } CH1_CTPR;

  union {                              /* Counter Initialize Pulse Register */
    vuint16_t R;
    struct {
      vuint16_t CIPR:16;
    } B;
  } CH1_CIPR;

  union {                              /* Data Preparation Register Low */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DPR:24;
    } B;
  } CH1_DPRL;

  union {                              /* Data Preparation Register High */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } CH1_DPRH;

  union {                              /* Data Buffer Register Low */
    vuint32_t R;
    struct {
      vuint32_t DBR:32;
    } B;
  } CH1_DBRL;

  union {                              /* Data Buffer Register High */
    vuint32_t R;
    struct {
      vuint32_t DBR:32;
    } B;
  } CH1_DBRH;

  union {                              /* Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DSR:32;
    } B;
  } CH1_DSRL;

  union {                              /* Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t DSR:32;
    } B;
  } CH1_DSRH;

  uint8_t PSI5_reserved2[4];
  union {                              /* PSI5 Channel Control Register */
    vuint32_t R;
    struct {
      vuint32_t CTC_GED_SEL:1;
      vuint32_t CTC_ED:1;
      vuint32_t  :1;
      vuint32_t MEM_DEPTH:5;
      vuint32_t  :3;
      vuint32_t ERROR_SELECT4:1;
      vuint32_t ERROR_SELECT3:1;
      vuint32_t ERROR_SELECT2:1;
      vuint32_t ERROR_SELECT1:1;
      vuint32_t ERROR_SELECT0:1;
      vuint32_t  :1;
      vuint32_t GTM_RESET_ASYNC_EN:1;
      vuint32_t  :3;
      vuint32_t DEBUG_EN:1;
      vuint32_t DEBUG_FREEZE_CTRL:1;
      vuint32_t SP_TS_CLK_SEL:1;
      vuint32_t  :2;
      vuint32_t FAST_CLR_SMC:1;
      vuint32_t FAST_CLR_PSI5:1;
      vuint32_t BIT_RATE:1;
      vuint32_t MODE:1;
      vuint32_t PSI5_CH_CONFIG:1;
      vuint32_t PSI5_CH_EN:1;
    } B;
  } CH2_PCCR;

  union {                              /* DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t DMA_PM_DS_WM:5;
      vuint32_t  :5;
      vuint32_t IE_DMA_TF_SF:1;
      vuint32_t IE_DMA_TF_PM_DS:1;
      vuint32_t  :5;
      vuint32_t IE_DMA_PM_DS_FIFO_FULL:1;
      vuint32_t IE_DMA_SFUF:1;
      vuint32_t  :1;
      vuint32_t IE_DMA_PM_DS_UF:1;
      vuint32_t  :5;
      vuint32_t DMA_EN_SF:1;
      vuint32_t DMA_PM_DS_CONFIG:2;
    } B;
  } CH2_DCR;

  union {                              /* DMA Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t IS_DMA_TF_SF:1;
      vuint32_t IS_DMA_TF_PM_DS:1;
      vuint32_t  :5;
      vuint32_t IS_DMA_PM_DS_FIFO_FULL:1;
      vuint32_t IS_DMA_SFUF:1;
      vuint32_t  :1;
      vuint32_t IS_DMA_PM_DS_UF:1;
      vuint32_t  :8;
    } B;
  } CH2_DSR;

  union {                              /* General Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t IE_CESM:6;
      vuint32_t IE_STS:1;
      vuint32_t IE_DTS:1;
      vuint32_t IE_DSROW:1;
      vuint32_t IE_BROW:1;
      vuint32_t IE_PROW:1;
      vuint32_t IE_DSRR:1;
      vuint32_t IE_BRR:1;
      vuint32_t IE_PRR:1;
      vuint32_t  :2;
      vuint32_t IE_OWSM:6;
      vuint32_t  :2;
      vuint32_t IE_NVSM:6;
    } B;
  } CH2_GICR;

  union {                              /* New Data Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_ND:32;
    } B;
  } CH2_NDICR;

  union {                              /* Overwrite Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_OW:32;
    } B;
  } CH2_OWICR;

  union {                              /* Error Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t IE_ERROR:32;
    } B;
  } CH2_EICR;

  union {                              /* General Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t IS_DB_FR:1;
      vuint32_t  :1;
      vuint32_t IS_CESM:6;
      vuint32_t IS_STS:1;
      vuint32_t IS_DTS:1;
      vuint32_t IS_DSROW:1;
      vuint32_t IS_BROW:1;
      vuint32_t IS_PROW:1;
      vuint32_t DSR_RDY:1;
      vuint32_t DBR_RDY:1;
      vuint32_t DPR_RDY:1;
      vuint32_t  :2;
      vuint32_t IS_OWSM:6;
      vuint32_t  :2;
      vuint32_t IS_NVSM:6;
    } B;
  } CH2_GISR;

  union {                              /* DMA PSI5 Message Register */
    vuint32_t R;
    struct {
      vuint32_t PSI5_RXDATA:32;
    } B;
  } CH2_DPMR;

  union {                              /* DMA SMC Frame Register */
    vuint32_t R;
    struct {
      vuint32_t SMC_RXDATA:32;
    } B;
  } CH2_DSFR;

  union {                              /* DMA Diagnostic Status Register */
    vuint32_t R;
    struct {
      vuint32_t DDS:32;
    } B;
  } CH2_DDSR;

  union {                              /* PSI5 Message Receive Register Low */
    vuint32_t R;
    struct {
      vuint32_t DATA_REGION:28;
      vuint32_t CRC:3;
      vuint32_t C:1;
    } B;
  } CH2_PMRRL;

  union {                              /* PSI5 Message Receive Register High */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t F:1;
      vuint32_t EM:1;
      vuint32_t E:1;
      vuint32_t T:1;
      vuint32_t SlotCounter:3;
      vuint32_t TimeStampValue:24;
    } B;
  } CH2_PMRRH;

  struct {
    union {                            /* PSI5 Message Register Low i */
      vuint32_t R;
      struct {
        vuint32_t DATA_REGION:28;
        vuint32_t CRCP:3;
        vuint32_t C:1;
      } B;
    } PMRL;
    union {                            /* PSI5 Message Register High i */
      vuint32_t R;
      struct {
        vuint32_t O:1;
        vuint32_t F:1;
        vuint32_t EM:1;
        vuint32_t E:1;
        vuint32_t T:1;
        vuint32_t Slot_Counter:3;
        vuint32_t TimeStampValue:24;
      } B;
    } PMRH;
  } CH2[32];

  union {                              /* SMC Frame Register n */
    vuint32_t R;
    struct {
      vuint32_t SLOT_NO:3;
      vuint32_t CER:1;
      vuint32_t OW:1;
      vuint32_t CRC:6;
      vuint32_t C:1;
      vuint32_t ID:4;
      vuint32_t IDDATA:4;
      vuint32_t DATA:12;
    } B;
  } CH2_SFR[6];

  union {                              /* New Data Status Register */
    vuint32_t R;
    struct {
      vuint32_t NDS:32;
    } B;
  } CH2_NDSR;

  union {                              /* Overwrite Status Register */
    vuint32_t R;
    struct {
      vuint32_t OWS:32;
    } B;
  } CH2_OWSR;

  union {                              /* Error Indication Status Register */
    vuint32_t R;
    struct {
      vuint32_t ERROR:32;
    } B;
  } CH2_EISR;

  union {                              /* Set New Data Status Register */
    vuint32_t R;
    struct {
      vuint32_t SNDS:32;
    } B;
  } CH2_SNDSR;

  union {                              /* Set Overwrite Status Register */
    vuint32_t R;
    struct {
      vuint32_t SOWS:32;
    } B;
  } CH2_SOWSR;

  union {                              /* Set Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t SERROR:32;
    } B;
  } CH2_SEISR;

  union {                              /* Set SMC Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t SCESM:6;
      vuint32_t  :10;
      vuint32_t SOWSM:6;
      vuint32_t  :2;
      vuint32_t SNVSM:6;
    } B;
  } CH2_SSESR;

  union {                              /* Sync Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t STSV:24;
    } B;
  } CH2_STSRR;

  union {                              /* Data Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t SLOT_COUNTER:3;
      vuint32_t DTSV:24;
    } B;
  } CH2_DTSRR;

  union {                              /* Slot n Frame Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SLOT_EN:1;
      vuint32_t TS_CAPT:1;
      vuint32_t  :1;
      vuint32_t SMCL:1;
      vuint32_t  :9;
      vuint32_t DRL:5;
      vuint32_t CRCP:1;
    } B;
  } CH2_SFCR[6];

  union {                              /* Slot 1 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S1SBT:15;
    } B;
  } CH2_S1SBR;

  union {                              /* Slot 2 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S2SBT:15;
    } B;
  } CH2_S2SBR;

  union {                              /* Slot 3 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S3SBT:15;
    } B;
  } CH2_S3SBR;

  union {                              /* Slot 4 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S4SBT:15;
    } B;
  } CH2_S4SBR;

  union {                              /* Slot 5 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S5SBT:15;
    } B;
  } CH2_S5SBR;

  union {                              /* Slot 6 Start Boundary Register */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t S6SBT:15;
    } B;
  } CH2_S6SBR;

  union {                              /* Slot n End Boundary Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t SLOT_NO:3;
      vuint32_t  :1;
      vuint32_t SnEBT:15;
    } B;
  } CH2_SnEBR;

  union {                              /* Data Output Block Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t DATA_LENGTH:6;
      vuint16_t DBR_RST:1;
      vuint16_t DSR_RST:1;
      vuint16_t CMD_TYPE:3;
      vuint16_t DEFAULT_SYNC:1;
      vuint16_t GTM_TRIG_SEL:1;
      vuint16_t SP_PULSE_SEL:1;
      vuint16_t OP_SEL:1;
      vuint16_t SW_READY:1;
    } B;
  } CH2_DOBCR;

  union {                              /* Manchestor Decoder Disable Offset */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t MDDIS_OFF:7;
    } B;
  } CH2_MDDIS_OFF;

  union {                              /* Pulse Width for Data Bit Value 0 */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t Pulse_Width0:7;
    } B;
  } CH2_PW0D;

  union {                              /* Pulse Width for Data Bit Value 1 */
    vuint16_t R;
    struct {
      vuint16_t  :9;
      vuint16_t Pulse_Width1:7;
    } B;
  } CH2_PW1D;

  union {                              /* Counter Target Pulse Register */
    vuint16_t R;
    struct {
      vuint16_t CTPR:16;
    } B;
  } CH2_CTPR;

  union {                              /* Counter Initialize Pulse Register */
    vuint16_t R;
    struct {
      vuint16_t CIPR:16;
    } B;
  } CH2_CIPR;

  union {                              /* Data Preparation Register Low */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DPR:24;
    } B;
  } CH2_DPRL;

  union {                              /* Data Preparation Register High */
    vuint32_t R;
    struct {
      vuint32_t  :32;
    } B;
  } CH2_DPRH;

  union {                              /* Data Buffer Register Low */
    vuint32_t R;
    struct {
      vuint32_t DBR:32;
    } B;
  } CH2_DBRL;

  union {                              /* Data Buffer Register High */
    vuint32_t R;
    struct {
      vuint32_t DBR:32;
    } B;
  } CH2_DBRH;

  union {                              /* Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DSR:32;
    } B;
  } CH2_DSRL;

  union {                              /* Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t DSR:32;
    } B;
  } CH2_DSRH;
};


/* ============================================================================
   =============================== Module: PSI5S ==============================
   ============================================================================ */

struct PSI5S_tag {
  union {                              /* PSI5-S LIN Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :19;
      vuint32_t AUTOWU:1;
      vuint32_t  :4;
      vuint32_t  :1;
      vuint32_t SLFM:1;
      vuint32_t LBKM:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t RBLM:1;
      vuint32_t SLEEP:1;
      vuint32_t INIT:1;
    } B;
  } LINCR1;

  union {                              /* PSI5-S LIN Interrupt enable register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZIE:1;
      vuint32_t OCIE:1;
      vuint32_t  :5;
      vuint32_t FEIE:1;
      vuint32_t BOIE:1;
      vuint32_t  :1;
      vuint32_t WUIE:1;
      vuint32_t  :1;
      vuint32_t TOIE:1;
      vuint32_t DRIE:1;
      vuint32_t DTIE:1;
      vuint32_t  :1;
    } B;
  } LINIER;

  union {                              /* PSI5-S LIN Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t LINS3:1;
      vuint32_t LINS2:1;
      vuint32_t LINS1:1;
      vuint32_t LINS0:1;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :6;
    } B;
  } LINSR;

  uint8_t PSI5S_reserved0[4];
  union {                              /* PSI5-S UART Mode Control Register */
    vuint32_t R;
    struct {
      vuint32_t MIS:1;
      vuint32_t CSP:3;
      vuint32_t OSR:4;
      vuint32_t ROSE:1;
      vuint32_t NEF:3;
      vuint32_t PCE_TXDTU:1;
      vuint32_t SBUR:2;
      vuint32_t WLS:1;
      vuint32_t TDFLTFC:3;
      vuint32_t RDFLRFC:3;
      vuint32_t RFBM:1;
      vuint32_t TFBM:1;
      vuint32_t WL1:1;
      vuint32_t PC1:1;
      vuint32_t RxEn:1;
      vuint32_t TxEn:1;
      vuint32_t PC0:1;
      vuint32_t PCE_Rx:1;
      vuint32_t WL0:1;
      vuint32_t UART:1;
    } B;
  } UARTCR;

  union {                              /* PSI5-S UART Mode Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SZF:1;
      vuint32_t OCF:1;
      vuint32_t PE3:1;
      vuint32_t PE2:1;
      vuint32_t PE1:1;
      vuint32_t PE0:1;
      vuint32_t RMB:1;
      vuint32_t FEF:1;
      vuint32_t BOF:1;
      vuint32_t RDI:1;
      vuint32_t WUF:1;
      vuint32_t RFNE:1;
      vuint32_t TO:1;
      vuint32_t DRF:1;
      vuint32_t DTF:1;
      vuint32_t NF:1;
    } B;
  } UARTSR;

  uint8_t PSI5S_reserved1[12];
  union {                              /* PSI5-S LIN Fractional Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t FBR:4;
    } B;
  } LINFBRR;

  union {                              /* PSI5-S LIN Integer Baud Rate Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t IBR:20;
    } B;
  } LINIBRR;

  uint8_t PSI5S_reserved2[4];
  union {                              /* PSI5-S LIN Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :17;
      vuint32_t  :1;
      vuint32_t  :4;
      vuint32_t ABRQ:1;
      vuint32_t  :9;
    } B;
  } LINCR2;

  uint8_t PSI5S_reserved3[4];
  union {                              /* PSI5-S Buffer Data Register Least Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA_TX3:8;
      vuint32_t DATA_TX2:8;
      vuint32_t DATA_TX1:8;
      vuint32_t DATA_TX0:8;
    } B;
  } BDRL;

  union {                              /* PSI5-S Buffer Data Register Most Significant */
    vuint32_t R;
    struct {
      vuint32_t DATA_RX3:8;
      vuint32_t DATA_RX2:8;
      vuint32_t DATA_RX1:8;
      vuint32_t DATA_RX0:8;
    } B;
  } BDRM;

  uint8_t PSI5S_reserved4[12];
  union {                              /* PSI5-S Global Control register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDFBM:1;
      vuint32_t RDFBM:1;
      vuint32_t TDLIS:1;
      vuint32_t RDLIS:1;
      vuint32_t STOP:1;
      vuint32_t SR:1;
    } B;
  } GCR;

  union {                              /* PSI5-S UART Preset Timeout Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t PTO:12;
    } B;
  } UARTPTO;

  union {                              /* UPSI5-S ART Current Timeout register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t CTO:12;
    } B;
  } UARTCTO;

  union {                              /* DMA Tx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t DTE0:1;
    } B;
  } DMATXE;

  union {                              /* DMA Rx Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t DRE0:1;
    } B;
  } DMARXE;

  union {                              /* PSI5-S UART Tx Idle Delay Time Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t IFD:5;
      vuint32_t EN:1;
    } B;
  } PTD;

  uint8_t PSI5S_reserved5[80];
  union {                              /* PSI5-S Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t DIRCMD_LEN:2;
      vuint32_t  :1;
      vuint32_t IE_DIRCMD_RDY:1;
      vuint32_t  :1;
      vuint32_t DEBUG_EN:1;
      vuint32_t GTM_TRIG_SEL:2;
      vuint32_t GL_DDSR_TRIG:1;
      vuint32_t GL_MODETR_DONE_EN:1;
      vuint32_t MRU_ERR_EN:1;
      vuint32_t TSCS_B:1;
      vuint32_t TSCS_A:1;
      vuint32_t CLR_CNTR_B:1;
      vuint32_t CLR_CNTR_A:1;
      vuint32_t CLRTSCNT_G:1;
      vuint32_t CLRTSCNT_G_L:1;
      vuint32_t TSCNT_EN_B:1;
      vuint32_t TSCNT_EN_A:1;
      vuint32_t TSCNTEN_G:1;
      vuint32_t TSCNTEN_G_L:1;
      vuint32_t GLOBAL_MODE:3;
    } B;
  } GLCR;

  union {                              /* PSI5-S Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t DIRCMD_RDY:1;
      vuint32_t  :4;
      vuint32_t GL_MODETR_DONE:1;
      vuint32_t MRU_ERR:1;
      vuint32_t  :7;
      vuint32_t FID:3;
      vuint32_t CHID:3;
    } B;
  } GLSR;

  union {                              /* PSI5-S CHANNEL_BASE_ADDRESS */
    vuint32_t R;
    struct {
      vuint32_t MAILBOX_BASE_ADDR:32;
    } B;
  } CH_BASE_ADDR;

  union {                              /* PSI5-S MRU OUTPUT BUFFER2 REGISTER0 */
    vuint32_t R;
    struct {
      vuint32_t CHANNEL_SPECIFIC_MAILBOX_ADDR:32;
    } B;
  } MRU_BUF2_REG0;

  union {                              /* PSI5-S MRU OUTPUT BUFFER2 REGISTER1 */
    vuint32_t R;
    struct {
      vuint32_t DCI:4;
      vuint32_t  :1;
      vuint32_t R_UVL_ERR:1;
      vuint32_t N_ERR:1;
      vuint32_t CHID:3;
      vuint32_t FID:3;
      vuint32_t R_OVL_ERR:1;
      vuint32_t F_WD_ERR:1;
      vuint32_t SCI_O_ERR:1;
      vuint32_t SCI_F_ERR:1;
      vuint32_t SCI_P_ERR:1;
      vuint32_t HD_ERR:1;
      vuint32_t ERR:2;
      vuint32_t CRC_ERR_P_ERR:1;
      vuint32_t CRC:3;
      vuint32_t XCRC_ERR:1;
      vuint32_t XCRC:6;
    } B;
  } MRU_BUF2_REG1;

  union {                              /* PSI5-S MRU OUTPUT BUFFER2 REGISTER2 */
    vuint32_t R;
    struct {
      vuint32_t DCI:4;
      vuint32_t PS_DATA:28;
    } B;
  } MRU_BUF2_REG2;

  union {                              /* PSI5-S MRU OUTPUT BUFFER2 REGISTER3 */
    vuint32_t R;
    struct {
      vuint32_t DCI:4;
      vuint32_t  :4;
      vuint32_t TIMESTAMP:24;
    } B;
  } MRU_BUF2_REG3;

  union {                              /* PSI5-S Clock Divider "0" for WatchDog and DownStream Data Shift Register Trigger Counters. Used for Channel1 and Channel2 */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t WD_CLKDIV0:10;
      vuint32_t  :6;
      vuint32_t DDTRIG_CLKDIV0:10;
    } B;
  } WD_DDTRIG_CLKDIV0;

  union {                              /* PSI5-S Clock Divider "1" for WatchDog and DownStream Data Shift Register Trigger Counters. Used for Channel3 and Channel4 */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t WD_CLKDIV1:10;
      vuint32_t  :6;
      vuint32_t DDTRIG_CLKDIV1:10;
    } B;
  } WD_DDTRIG_CLKDIV1;

  union {                              /* PSI5-S Clock Divider "2" for WatchDog and DownStream Data Shift Register Trigger Counters. Used for Channel5 and Channel6 */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t WD_CLKDIV2:10;
      vuint32_t  :6;
      vuint32_t DDTRIG_CLKDIV2:10;
    } B;
  } WD_DDTRIG_CLKDIV2;

  union {                              /* PSI5-S Clock Divider "3" for WatchDog and DownStream Data Shift Register Trigger Counters. Used for Channel7 */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t WD_CLKDIV3:10;
      vuint32_t  :6;
      vuint32_t DDTRIG_CLKDIV3:10;
    } B;
  } WD_DDTRIG_CLKDIV3;

  union {                              /* PSI5-S Mbox Status Irq */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t MBOX_CH7:1;
      vuint32_t MBOX_CH6:1;
      vuint32_t MBOX_CH5:1;
      vuint32_t MBOX_CH4:1;
      vuint32_t MBOX_CH3:1;
      vuint32_t MBOX_CH2:1;
      vuint32_t MBOX_CH1:1;
      vuint32_t MBOX_CH0:1;
    } B;
  } MBOX_SR_IRQ;

  union {                              /* PSI5-S Error Status Irq */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t R_UVL_ERR:1;
      vuint32_t N_ERR:1;
      vuint32_t R_OVL_ERR:1;
      vuint32_t F_WD_ERR:1;
      vuint32_t SCI_O_ERR:1;
      vuint32_t SCI_F_ERR:1;
      vuint32_t SCI_P_ERR:1;
      vuint32_t HD_ERR:1;
      vuint32_t CRC_ERR_P_ERR:1;
      vuint32_t XCRC_ERR:1;
    } B;
  } ERR_SR_IRQ;

  struct {
    union {                            /* PSI5-S Mailbox select IRQ[irq_n] */
      vuint32_t R;
      struct {
        vuint32_t  :24;
        vuint32_t MBOX_CH7_SEL:1;
        vuint32_t MBOX_CH6_SEL:1;
        vuint32_t MBOX_CH5_SEL:1;
        vuint32_t MBOX_CH4_SEL:1;
        vuint32_t MBOX_CH3_SEL:1;
        vuint32_t MBOX_CH2_SEL:1;
        vuint32_t MBOX_CH1_SEL:1;
        vuint32_t MBOX_CH0_SEL:1;
      } B;
    } MBOX;
    union {                            /* PSI5-S Error Select IRQ[iq_n] */
      vuint32_t R;
      struct {
        vuint32_t  :22;
        vuint32_t R_UVL_ERR_SEL:1;
        vuint32_t N_ERR_SEL:1;
        vuint32_t R_OVL_ERR_SEL:1;
        vuint32_t F_WD_ERR_SEL:1;
        vuint32_t SCI_O_ERR_SEL:1;
        vuint32_t SCI_F_ERR_SEL:1;
        vuint32_t SCI_P_ERR_SEL:1;
        vuint32_t HD_ERR_SEL:1;
        vuint32_t CRC_ERR_SEL:1;
        vuint32_t XCRC_ERR_SEL:1;
      } B;
    } ERR;
  } SEL_IRQ[8];

  union {                              /* PSI5-S Watchdog Error Status and Watchdog Timestamp status register */
    vuint32_t R;
    struct {
      vuint32_t F_WD_ERR_STATUS:7;
      vuint32_t  :1;
      vuint32_t WDTS_STATUS:24;
    } B;
  } WDGTSSR;

  uint8_t PSI5S_reserved6[64];
  union {                              /* PSI5-S channel 0 message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t F0_BYTE:3;
      vuint32_t  :2;
      vuint32_t TIMESTAMP_A_B_SEL:1;
      vuint32_t  :1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t  :2;
    } B;
  } MSGA_CH0;

  union {                              /* PSI5-S channel 0 message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH0;

  uint8_t PSI5S_reserved7[4];
  union {                              /* PSI5-S Mailbox status register channel0 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH0;

  uint8_t PSI5S_reserved8[20];
  union {                              /* PSI5-S channel message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t L_PC_EN:1;
      vuint32_t F5_BYTE:3;
      vuint32_t L_PC5:1;
      vuint32_t F4_BYTE:3;
      vuint32_t L_PC4:1;
      vuint32_t F3_BYTE:3;
      vuint32_t L_PC3:1;
      vuint32_t F2_BYTE:3;
      vuint32_t L_PC2:1;
      vuint32_t F1_BYTE:3;
      vuint32_t L_PC1:1;
      vuint32_t F0_BYTE:3;
      vuint32_t L_PC0:1;
      vuint32_t MODE:1;
      vuint32_t TIME_STAMP_A_B_SEL:1;
      vuint32_t TMSG_TCMD:1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t G_PC:1;
      vuint32_t CH_EN:1;
    } B;
  } MSGA_CH1;

  union {                              /* PSI5-S channel message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t F5_payload:5;
      vuint32_t F4_payload:5;
      vuint32_t F3_payload:5;
      vuint32_t F2_payload:5;
      vuint32_t F1_payload:5;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH1;

  uint8_t PSI5S_reserved9[4];
  union {                              /* PSI5-S Mailbox status register channel */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F5_ERR:1;
      vuint32_t F5_OV:1;
      vuint32_t F5_READ:1;
      vuint32_t F4_ERR:1;
      vuint32_t F4_OV:1;
      vuint32_t F4_READ:1;
      vuint32_t F3_ERR:1;
      vuint32_t F3_OV:1;
      vuint32_t F3_READ:1;
      vuint32_t F2_ERR:1;
      vuint32_t F2_OV:1;
      vuint32_t F2_READ:1;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH1;

  union {                              /* PSI5-S channel watchdog configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDRST:1;
      vuint32_t WDCS:1;
      vuint32_t WDEN:1;
      vuint32_t  :1;
      vuint32_t WD_TO:24;
    } B;
  } WD_CFGR_CH1;

  union {                              /* PSI5-S DDSR Trigger offset register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_OFFR:16;
    } B;
  } DDTRIG_OFFR_CH1;

  union {                              /* PSI5-S DDSR Trigger period register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_PERR:16;
    } B;
  } DDTRIG_PERR_CH1;

  union {                              /* PSI5-S ECU to Sensor Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t CMD:5;
      vuint32_t  :1;
      vuint32_t ACMD:5;
      vuint32_t  :2;
      vuint32_t CH_TRIG:1;
      vuint32_t GL_TRIG_SEL:1;
      vuint32_t DEFAULT_SYNC:1;
      vuint32_t DDSR_SHIFT_SEL:1;
      vuint32_t DDSR_CLR:1;
      vuint32_t DDSR_CLK_SEL:1;
      vuint32_t CMDTR_SW_CTRL:1;
      vuint32_t  :1;
      vuint32_t SYNCHRO_OVF_IE:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT_IE:1;
      vuint32_t CMDPR_BZY_IE:1;
      vuint32_t DDSR_RDY_IE:1;
      vuint32_t  :2;
      vuint32_t CMD_TYPE:3;
    } B;
  } E2SCR_CH1;

  union {                              /* PSI5-S ECU to Sensor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t SYCHRO_OVF:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT:1;
      vuint32_t CMDPR_BZY:1;
      vuint32_t DDSR_RDY:1;
      vuint32_t  :5;
    } B;
  } E2SSR_CH1;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DDSR_H:11;
    } B;
  } DDSR_H_CH1;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DDSR_L1:8;
      vuint32_t DDSR_L2:24;
    } B;
  } DDSR_L_CH1;

  uint8_t PSI5S_reserved10[16];
  union {                              /* PSI5-S channel message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t L_PC_EN:1;
      vuint32_t F5_BYTE:3;
      vuint32_t L_PC5:1;
      vuint32_t F4_BYTE:3;
      vuint32_t L_PC4:1;
      vuint32_t F3_BYTE:3;
      vuint32_t L_PC3:1;
      vuint32_t F2_BYTE:3;
      vuint32_t L_PC2:1;
      vuint32_t F1_BYTE:3;
      vuint32_t L_PC1:1;
      vuint32_t F0_BYTE:3;
      vuint32_t L_PC0:1;
      vuint32_t MODE:1;
      vuint32_t TIME_STAMP_A_B_SEL:1;
      vuint32_t TMSG_TCMD:1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t G_PC:1;
      vuint32_t CH_EN:1;
    } B;
  } MSGA_CH2;

  union {                              /* PSI5-S channel message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t F5_payload:5;
      vuint32_t F4_payload:5;
      vuint32_t F3_payload:5;
      vuint32_t F2_payload:5;
      vuint32_t F1_payload:5;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH2;

  uint8_t PSI5S_reserved11[4];
  union {                              /* PSI5-S Mailbox status register channel */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F5_ERR:1;
      vuint32_t F5_OV:1;
      vuint32_t F5_READ:1;
      vuint32_t F4_ERR:1;
      vuint32_t F4_OV:1;
      vuint32_t F4_READ:1;
      vuint32_t F3_ERR:1;
      vuint32_t F3_OV:1;
      vuint32_t F3_READ:1;
      vuint32_t F2_ERR:1;
      vuint32_t F2_OV:1;
      vuint32_t F2_READ:1;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH2;

  union {                              /* PSI5-S channel watchdog configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDRST:1;
      vuint32_t WDCS:1;
      vuint32_t WDEN:1;
      vuint32_t  :1;
      vuint32_t WD_TO:24;
    } B;
  } WD_CFGR_CH2;

  union {                              /* PSI5-S DDSR Trigger offset register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_OFFR:16;
    } B;
  } DDTRIG_OFFR_CH2;

  union {                              /* PSI5-S DDSR Trigger period register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_PERR:16;
    } B;
  } DDTRIG_PERR_CH2;

  union {                              /* PSI5-S ECU to Sensor Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t CMD:5;
      vuint32_t  :1;
      vuint32_t ACMD:5;
      vuint32_t  :2;
      vuint32_t CH_TRIG:1;
      vuint32_t GL_TRIG_SEL:1;
      vuint32_t DEFAULT_SYNC:1;
      vuint32_t DDSR_SHIFT_SEL:1;
      vuint32_t DDSR_CLR:1;
      vuint32_t DDSR_CLK_SEL:1;
      vuint32_t CMDTR_SW_CTRL:1;
      vuint32_t  :1;
      vuint32_t SYNCHRO_OVF_IE:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT_IE:1;
      vuint32_t CMDPR_BZY_IE:1;
      vuint32_t DDSR_RDY_IE:1;
      vuint32_t  :2;
      vuint32_t CMD_TYPE:3;
    } B;
  } E2SCR_CH2;

  union {                              /* PSI5-S ECU to Sensor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t SYCHRO_OVF:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT:1;
      vuint32_t CMDPR_BZY:1;
      vuint32_t DDSR_RDY:1;
      vuint32_t  :5;
    } B;
  } E2SSR_CH2;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DDSR_H:11;
    } B;
  } DDSR_H_CH2;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DDSR_L1:8;
      vuint32_t DDSR_L2:24;
    } B;
  } DDSR_L_CH2;

  uint8_t PSI5S_reserved12[16];
  union {                              /* PSI5-S channel message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t L_PC_EN:1;
      vuint32_t F5_BYTE:3;
      vuint32_t L_PC5:1;
      vuint32_t F4_BYTE:3;
      vuint32_t L_PC4:1;
      vuint32_t F3_BYTE:3;
      vuint32_t L_PC3:1;
      vuint32_t F2_BYTE:3;
      vuint32_t L_PC2:1;
      vuint32_t F1_BYTE:3;
      vuint32_t L_PC1:1;
      vuint32_t F0_BYTE:3;
      vuint32_t L_PC0:1;
      vuint32_t MODE:1;
      vuint32_t TIME_STAMP_A_B_SEL:1;
      vuint32_t TMSG_TCMD:1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t G_PC:1;
      vuint32_t CH_EN:1;
    } B;
  } MSGA_CH3;

  union {                              /* PSI5-S channel message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t F5_payload:5;
      vuint32_t F4_payload:5;
      vuint32_t F3_payload:5;
      vuint32_t F2_payload:5;
      vuint32_t F1_payload:5;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH3;

  uint8_t PSI5S_reserved13[4];
  union {                              /* PSI5-S Mailbox status register channel */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F5_ERR:1;
      vuint32_t F5_OV:1;
      vuint32_t F5_READ:1;
      vuint32_t F4_ERR:1;
      vuint32_t F4_OV:1;
      vuint32_t F4_READ:1;
      vuint32_t F3_ERR:1;
      vuint32_t F3_OV:1;
      vuint32_t F3_READ:1;
      vuint32_t F2_ERR:1;
      vuint32_t F2_OV:1;
      vuint32_t F2_READ:1;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH3;

  union {                              /* PSI5-S channel watchdog configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDRST:1;
      vuint32_t WDCS:1;
      vuint32_t WDEN:1;
      vuint32_t  :1;
      vuint32_t WD_TO:24;
    } B;
  } WD_CFGR_CH3;

  union {                              /* PSI5-S DDSR Trigger offset register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_OFFR:16;
    } B;
  } DDTRIG_OFFR_CH3;

  union {                              /* PSI5-S DDSR Trigger period register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_PERR:16;
    } B;
  } DDTRIG_PERR_CH3;

  union {                              /* PSI5-S ECU to Sensor Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t CMD:5;
      vuint32_t  :1;
      vuint32_t ACMD:5;
      vuint32_t  :2;
      vuint32_t CH_TRIG:1;
      vuint32_t GL_TRIG_SEL:1;
      vuint32_t DEFAULT_SYNC:1;
      vuint32_t DDSR_SHIFT_SEL:1;
      vuint32_t DDSR_CLR:1;
      vuint32_t DDSR_CLK_SEL:1;
      vuint32_t CMDTR_SW_CTRL:1;
      vuint32_t  :1;
      vuint32_t SYNCHRO_OVF_IE:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT_IE:1;
      vuint32_t CMDPR_BZY_IE:1;
      vuint32_t DDSR_RDY_IE:1;
      vuint32_t  :2;
      vuint32_t CMD_TYPE:3;
    } B;
  } E2SCR_CH3;

  union {                              /* PSI5-S ECU to Sensor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t SYCHRO_OVF:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT:1;
      vuint32_t CMDPR_BZY:1;
      vuint32_t DDSR_RDY:1;
      vuint32_t  :5;
    } B;
  } E2SSR_CH3;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DDSR_H:11;
    } B;
  } DDSR_H_CH3;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DDSR_L1:8;
      vuint32_t DDSR_L2:24;
    } B;
  } DDSR_L_CH3;

  uint8_t PSI5S_reserved14[16];
  union {                              /* PSI5-S channel message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t L_PC_EN:1;
      vuint32_t F5_BYTE:3;
      vuint32_t L_PC5:1;
      vuint32_t F4_BYTE:3;
      vuint32_t L_PC4:1;
      vuint32_t F3_BYTE:3;
      vuint32_t L_PC3:1;
      vuint32_t F2_BYTE:3;
      vuint32_t L_PC2:1;
      vuint32_t F1_BYTE:3;
      vuint32_t L_PC1:1;
      vuint32_t F0_BYTE:3;
      vuint32_t L_PC0:1;
      vuint32_t MODE:1;
      vuint32_t TIME_STAMP_A_B_SEL:1;
      vuint32_t TMSG_TCMD:1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t G_PC:1;
      vuint32_t CH_EN:1;
    } B;
  } MSGA_CH4;

  union {                              /* PSI5-S channel message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t F5_payload:5;
      vuint32_t F4_payload:5;
      vuint32_t F3_payload:5;
      vuint32_t F2_payload:5;
      vuint32_t F1_payload:5;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH4;

  uint8_t PSI5S_reserved15[4];
  union {                              /* PSI5-S Mailbox status register channel */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F5_ERR:1;
      vuint32_t F5_OV:1;
      vuint32_t F5_READ:1;
      vuint32_t F4_ERR:1;
      vuint32_t F4_OV:1;
      vuint32_t F4_READ:1;
      vuint32_t F3_ERR:1;
      vuint32_t F3_OV:1;
      vuint32_t F3_READ:1;
      vuint32_t F2_ERR:1;
      vuint32_t F2_OV:1;
      vuint32_t F2_READ:1;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH4;

  union {                              /* PSI5-S channel watchdog configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDRST:1;
      vuint32_t WDCS:1;
      vuint32_t WDEN:1;
      vuint32_t  :1;
      vuint32_t WD_TO:24;
    } B;
  } WD_CFGR_CH4;

  union {                              /* PSI5-S DDSR Trigger offset register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_OFFR:16;
    } B;
  } DDTRIG_OFFR_CH4;

  union {                              /* PSI5-S DDSR Trigger period register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_PERR:16;
    } B;
  } DDTRIG_PERR_CH4;

  union {                              /* PSI5-S ECU to Sensor Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t CMD:5;
      vuint32_t  :1;
      vuint32_t ACMD:5;
      vuint32_t  :2;
      vuint32_t CH_TRIG:1;
      vuint32_t GL_TRIG_SEL:1;
      vuint32_t DEFAULT_SYNC:1;
      vuint32_t DDSR_SHIFT_SEL:1;
      vuint32_t DDSR_CLR:1;
      vuint32_t DDSR_CLK_SEL:1;
      vuint32_t CMDTR_SW_CTRL:1;
      vuint32_t  :1;
      vuint32_t SYNCHRO_OVF_IE:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT_IE:1;
      vuint32_t CMDPR_BZY_IE:1;
      vuint32_t DDSR_RDY_IE:1;
      vuint32_t  :2;
      vuint32_t CMD_TYPE:3;
    } B;
  } E2SCR_CH4;

  union {                              /* PSI5-S ECU to Sensor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t SYCHRO_OVF:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT:1;
      vuint32_t CMDPR_BZY:1;
      vuint32_t DDSR_RDY:1;
      vuint32_t  :5;
    } B;
  } E2SSR_CH4;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DDSR_H:11;
    } B;
  } DDSR_H_CH4;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DDSR_L1:8;
      vuint32_t DDSR_L2:24;
    } B;
  } DDSR_L_CH4;

  uint8_t PSI5S_reserved16[16];
  union {                              /* PSI5-S channel message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t L_PC_EN:1;
      vuint32_t F5_BYTE:3;
      vuint32_t L_PC5:1;
      vuint32_t F4_BYTE:3;
      vuint32_t L_PC4:1;
      vuint32_t F3_BYTE:3;
      vuint32_t L_PC3:1;
      vuint32_t F2_BYTE:3;
      vuint32_t L_PC2:1;
      vuint32_t F1_BYTE:3;
      vuint32_t L_PC1:1;
      vuint32_t F0_BYTE:3;
      vuint32_t L_PC0:1;
      vuint32_t MODE:1;
      vuint32_t TIME_STAMP_A_B_SEL:1;
      vuint32_t TMSG_TCMD:1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t G_PC:1;
      vuint32_t CH_EN:1;
    } B;
  } MSGA_CH5;

  union {                              /* PSI5-S channel message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t F5_payload:5;
      vuint32_t F4_payload:5;
      vuint32_t F3_payload:5;
      vuint32_t F2_payload:5;
      vuint32_t F1_payload:5;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH5;

  uint8_t PSI5S_reserved17[4];
  union {                              /* PSI5-S Mailbox status register channel */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F5_ERR:1;
      vuint32_t F5_OV:1;
      vuint32_t F5_READ:1;
      vuint32_t F4_ERR:1;
      vuint32_t F4_OV:1;
      vuint32_t F4_READ:1;
      vuint32_t F3_ERR:1;
      vuint32_t F3_OV:1;
      vuint32_t F3_READ:1;
      vuint32_t F2_ERR:1;
      vuint32_t F2_OV:1;
      vuint32_t F2_READ:1;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH5;

  union {                              /* PSI5-S channel watchdog configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDRST:1;
      vuint32_t WDCS:1;
      vuint32_t WDEN:1;
      vuint32_t  :1;
      vuint32_t WD_TO:24;
    } B;
  } WD_CFGR_CH5;

  union {                              /* PSI5-S DDSR Trigger offset register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_OFFR:16;
    } B;
  } DDTRIG_OFFR_CH5;

  union {                              /* PSI5-S DDSR Trigger period register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_PERR:16;
    } B;
  } DDTRIG_PERR_CH5;

  union {                              /* PSI5-S ECU to Sensor Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t CMD:5;
      vuint32_t  :1;
      vuint32_t ACMD:5;
      vuint32_t  :2;
      vuint32_t CH_TRIG:1;
      vuint32_t GL_TRIG_SEL:1;
      vuint32_t DEFAULT_SYNC:1;
      vuint32_t DDSR_SHIFT_SEL:1;
      vuint32_t DDSR_CLR:1;
      vuint32_t DDSR_CLK_SEL:1;
      vuint32_t CMDTR_SW_CTRL:1;
      vuint32_t  :1;
      vuint32_t SYNCHRO_OVF_IE:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT_IE:1;
      vuint32_t CMDPR_BZY_IE:1;
      vuint32_t DDSR_RDY_IE:1;
      vuint32_t  :2;
      vuint32_t CMD_TYPE:3;
    } B;
  } E2SCR_CH5;

  union {                              /* PSI5-S ECU to Sensor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t SYCHRO_OVF:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT:1;
      vuint32_t CMDPR_BZY:1;
      vuint32_t DDSR_RDY:1;
      vuint32_t  :5;
    } B;
  } E2SSR_CH5;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DDSR_H:11;
    } B;
  } DDSR_H_CH5;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DDSR_L1:8;
      vuint32_t DDSR_L2:24;
    } B;
  } DDSR_L_CH5;

  uint8_t PSI5S_reserved18[16];
  union {                              /* PSI5-S channel message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t L_PC_EN:1;
      vuint32_t F5_BYTE:3;
      vuint32_t L_PC5:1;
      vuint32_t F4_BYTE:3;
      vuint32_t L_PC4:1;
      vuint32_t F3_BYTE:3;
      vuint32_t L_PC3:1;
      vuint32_t F2_BYTE:3;
      vuint32_t L_PC2:1;
      vuint32_t F1_BYTE:3;
      vuint32_t L_PC1:1;
      vuint32_t F0_BYTE:3;
      vuint32_t L_PC0:1;
      vuint32_t MODE:1;
      vuint32_t TIME_STAMP_A_B_SEL:1;
      vuint32_t TMSG_TCMD:1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t G_PC:1;
      vuint32_t CH_EN:1;
    } B;
  } MSGA_CH6;

  union {                              /* PSI5-S channel message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t F5_payload:5;
      vuint32_t F4_payload:5;
      vuint32_t F3_payload:5;
      vuint32_t F2_payload:5;
      vuint32_t F1_payload:5;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH6;

  uint8_t PSI5S_reserved19[4];
  union {                              /* PSI5-S Mailbox status register channel */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F5_ERR:1;
      vuint32_t F5_OV:1;
      vuint32_t F5_READ:1;
      vuint32_t F4_ERR:1;
      vuint32_t F4_OV:1;
      vuint32_t F4_READ:1;
      vuint32_t F3_ERR:1;
      vuint32_t F3_OV:1;
      vuint32_t F3_READ:1;
      vuint32_t F2_ERR:1;
      vuint32_t F2_OV:1;
      vuint32_t F2_READ:1;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH6;

  union {                              /* PSI5-S channel watchdog configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDRST:1;
      vuint32_t WDCS:1;
      vuint32_t WDEN:1;
      vuint32_t  :1;
      vuint32_t WD_TO:24;
    } B;
  } WD_CFGR_CH6;

  union {                              /* PSI5-S DDSR Trigger offset register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_OFFR:16;
    } B;
  } DDTRIG_OFFR_CH6;

  union {                              /* PSI5-S DDSR Trigger period register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_PERR:16;
    } B;
  } DDTRIG_PERR_CH6;

  union {                              /* PSI5-S ECU to Sensor Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t CMD:5;
      vuint32_t  :1;
      vuint32_t ACMD:5;
      vuint32_t  :2;
      vuint32_t CH_TRIG:1;
      vuint32_t GL_TRIG_SEL:1;
      vuint32_t DEFAULT_SYNC:1;
      vuint32_t DDSR_SHIFT_SEL:1;
      vuint32_t DDSR_CLR:1;
      vuint32_t DDSR_CLK_SEL:1;
      vuint32_t CMDTR_SW_CTRL:1;
      vuint32_t  :1;
      vuint32_t SYNCHRO_OVF_IE:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT_IE:1;
      vuint32_t CMDPR_BZY_IE:1;
      vuint32_t DDSR_RDY_IE:1;
      vuint32_t  :2;
      vuint32_t CMD_TYPE:3;
    } B;
  } E2SCR_CH6;

  union {                              /* PSI5-S ECU to Sensor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t SYCHRO_OVF:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT:1;
      vuint32_t CMDPR_BZY:1;
      vuint32_t DDSR_RDY:1;
      vuint32_t  :5;
    } B;
  } E2SSR_CH6;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DDSR_H:11;
    } B;
  } DDSR_H_CH6;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DDSR_L1:8;
      vuint32_t DDSR_L2:24;
    } B;
  } DDSR_L_CH6;

  uint8_t PSI5S_reserved20[16];
  union {                              /* PSI5-S channel message configuration register A */
    vuint32_t R;
    struct {
      vuint32_t L_PC_EN:1;
      vuint32_t F5_BYTE:3;
      vuint32_t L_PC5:1;
      vuint32_t F4_BYTE:3;
      vuint32_t L_PC4:1;
      vuint32_t F3_BYTE:3;
      vuint32_t L_PC3:1;
      vuint32_t F2_BYTE:3;
      vuint32_t L_PC2:1;
      vuint32_t F1_BYTE:3;
      vuint32_t L_PC1:1;
      vuint32_t F0_BYTE:3;
      vuint32_t L_PC0:1;
      vuint32_t MODE:1;
      vuint32_t TIME_STAMP_A_B_SEL:1;
      vuint32_t TMSG_TCMD:1;
      vuint32_t TSBUF_CLR:1;
      vuint32_t TSBUF_EN:1;
      vuint32_t G_PC:1;
      vuint32_t CH_EN:1;
    } B;
  } MSGA_CH7;

  union {                              /* PSI5-S channel message configuration register B */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t F5_payload:5;
      vuint32_t F4_payload:5;
      vuint32_t F3_payload:5;
      vuint32_t F2_payload:5;
      vuint32_t F1_payload:5;
      vuint32_t F0_payload:5;
    } B;
  } MSGB_CH7;

  uint8_t PSI5S_reserved21[4];
  union {                              /* PSI5-S Mailbox status register channel */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t F5_ERR:1;
      vuint32_t F5_OV:1;
      vuint32_t F5_READ:1;
      vuint32_t F4_ERR:1;
      vuint32_t F4_OV:1;
      vuint32_t F4_READ:1;
      vuint32_t F3_ERR:1;
      vuint32_t F3_OV:1;
      vuint32_t F3_READ:1;
      vuint32_t F2_ERR:1;
      vuint32_t F2_OV:1;
      vuint32_t F2_READ:1;
      vuint32_t F1_ERR:1;
      vuint32_t F1_OV:1;
      vuint32_t F1_READ:1;
      vuint32_t F0_ERR:1;
      vuint32_t F0_OV:1;
      vuint32_t F0_READ:1;
    } B;
  } MBOX_SR_CH7;

  union {                              /* PSI5-S channel watchdog configuration register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t WDRST:1;
      vuint32_t WDCS:1;
      vuint32_t WDEN:1;
      vuint32_t  :1;
      vuint32_t WD_TO:24;
    } B;
  } WD_CFGR_CH7;

  union {                              /* PSI5-S DDSR Trigger offset register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_OFFR:16;
    } B;
  } DDTRIG_OFFR_CH7;

  union {                              /* PSI5-S DDSR Trigger period register channel */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t DDTRIG_PERR:16;
    } B;
  } DDTRIG_PERR_CH7;

  union {                              /* PSI5-S ECU to Sensor Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t CMD:5;
      vuint32_t  :1;
      vuint32_t ACMD:5;
      vuint32_t  :2;
      vuint32_t CH_TRIG:1;
      vuint32_t GL_TRIG_SEL:1;
      vuint32_t DEFAULT_SYNC:1;
      vuint32_t DDSR_SHIFT_SEL:1;
      vuint32_t DDSR_CLR:1;
      vuint32_t DDSR_CLK_SEL:1;
      vuint32_t CMDTR_SW_CTRL:1;
      vuint32_t  :1;
      vuint32_t SYNCHRO_OVF_IE:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT_IE:1;
      vuint32_t CMDPR_BZY_IE:1;
      vuint32_t DDSR_RDY_IE:1;
      vuint32_t  :2;
      vuint32_t CMD_TYPE:3;
    } B;
  } E2SCR_CH7;

  union {                              /* PSI5-S ECU to Sensor Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t SYCHRO_OVF:1;
      vuint32_t  :1;
      vuint32_t CMDTR_NWRT:1;
      vuint32_t CMDPR_BZY:1;
      vuint32_t DDSR_RDY:1;
      vuint32_t  :5;
    } B;
  } E2SSR_CH7;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register High */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t DDSR_H:11;
    } B;
  } DDSR_H_CH7;

  union {                              /* PSI5-S channel1 ECU to Sensor Downstream Data Shift Register Low */
    vuint32_t R;
    struct {
      vuint32_t DDSR_L1:8;
      vuint32_t DDSR_L2:24;
    } B;
  } DDSR_L_CH7;
};


/* ============================================================================
   =============================== Module: REG_PROT ===========================
   ============================================================================ */

struct REG_PROT_tag {
  uint8_t REG_PROT_reserved0[14336];
  union {                              /* Soft Lock Bit Register n */
    vuint8_t R;
    struct {
      vuint8_t WE0:1;                  /* Write Enable Bits for Soft Lock Bits (SLB) */
      vuint8_t WE1:1;                  /* Write Enable Bits for Soft Lock Bits (SLB) */
      vuint8_t WE2:1;                  /* Write Enable Bits for Soft Lock Bits (SLB) */
      vuint8_t WE3:1;                  /* Write Enable Bits for Soft Lock Bits (SLB) */
      vuint8_t SLB0:1;                 /* Soft Lock Bits for one MRn register */
      vuint8_t SLB1:1;                 /* Soft Lock Bits for one MRn register */
      vuint8_t SLB2:1;                 /* Soft Lock Bits for one MRn register */
      vuint8_t SLB3:1;                 /* Soft Lock Bits for one MRn register */
    } B;
  } SLBRn;

  uint8_t REG_PROT_reserved1[2043];
  union {                              /* Global Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t HLB:1;                 /* Hard Lock Bit */
      vuint32_t  :7;
      vuint32_t UAA:1;                 /* User Access Allowed. */
      vuint32_t  :23;
    } B;
  } GCR;
};


/* ============================================================================
   =============================== Module: SARADC =============================
   ============================================================================ */

struct SARADC_tag {
  union {                              /* Main Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t OWREN:1;
      vuint32_t WLSIDE:1;
      vuint32_t MODE:1;
      vuint32_t  :1;
      vuint32_t NSTART:1;
      vuint32_t NTRGEN:1;
      vuint32_t NEDGESEL:2;
      vuint32_t JSTART:1;
      vuint32_t JTRGEN:1;
      vuint32_t JEDGESEL:2;
      vuint32_t JTRGSEQ:1;
      vuint32_t  :1;
      vuint32_t  :2;
      vuint32_t WTRIGOUT:1;
      vuint32_t  :3;
      vuint32_t JTRGSEL:4;
      vuint32_t ABORTCHAIN:1;
      vuint32_t ABORT:1;
      vuint32_t  :1;
      vuint32_t FRZ:1;
      vuint32_t  :2;
      vuint32_t EDCSELF:1;
      vuint32_t PWDN:1;
    } B;
  } MCR;

  union {                              /* Main Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t NSTART:1;
      vuint32_t  :3;
      vuint32_t JSTART:1;
      vuint32_t  :4;
      vuint32_t JABORTCHAIN:1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t CHADDR:8;
      vuint32_t  :5;
      vuint32_t ADCSTATUS:3;
    } B;
  } MSR;

  uint8_t SARADC_reserved0[8];
  union {                              /* Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t JEOC:1;
      vuint32_t JECH:1;
      vuint32_t NEOC:1;
      vuint32_t NECH:1;
    } B;
  } ISR;

  union {                              /* Internal channel Interrupt Pending Register */
    vuint32_t R;
    struct {
      vuint32_t EOC_CHx:32;
    } B;
  } ICIPR[3];

  union {                              /* Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t  :1;
      vuint32_t MSKJEOC:1;
      vuint32_t MSKJECH:1;
      vuint32_t MSKNEOC:1;
      vuint32_t MSKNECH:1;
    } B;
  } IMR;

  union {                              /* Internal Channel Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t IM_CHx:32;
    } B;
  } ICIMR[3];

  union {                              /* Watchdog Threshold Interrupt Status Register */
    vuint32_t R;
    struct {
      vuint32_t WDG15H:1;
      vuint32_t WDG15L:1;
      vuint32_t WDG14H:1;
      vuint32_t WDG14L:1;
      vuint32_t WDG13H:1;
      vuint32_t WDG13L:1;
      vuint32_t WDG12H:1;
      vuint32_t WDG12L:1;
      vuint32_t WDG11H:1;
      vuint32_t WDG11L:1;
      vuint32_t WDG10H:1;
      vuint32_t WDG10L:1;
      vuint32_t WDG9H:1;
      vuint32_t WDG9L:1;
      vuint32_t WDG8H:1;
      vuint32_t WDG8L:1;
      vuint32_t WDG7H:1;
      vuint32_t WDG7L:1;
      vuint32_t WDG6H:1;
      vuint32_t WDG6L:1;
      vuint32_t WDG5H:1;
      vuint32_t WDG5L:1;
      vuint32_t WDG4H:1;
      vuint32_t WDG4L:1;
      vuint32_t WDG3H:1;
      vuint32_t WDG3L:1;
      vuint32_t WDG2H:1;
      vuint32_t WDG2L:1;
      vuint32_t WDG1H:1;
      vuint32_t WDG1L:1;
      vuint32_t WDG0H:1;
      vuint32_t WDG0L:1;
    } B;
  } WTISR;

  union {                              /* Watchdog Threshold Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t MSKWDG15H:1;
      vuint32_t MSKWDG15L:1;
      vuint32_t MSKWDG14H:1;
      vuint32_t MSKWDG14L:1;
      vuint32_t MSKWDG13H:1;
      vuint32_t MSKWDG13L:1;
      vuint32_t MSKWDG12H:1;
      vuint32_t MSKWDG12L:1;
      vuint32_t MSKWDG11H:1;
      vuint32_t MSKWDG11L:1;
      vuint32_t MSKWDG10H:1;
      vuint32_t MSKWDG10L:1;
      vuint32_t MSKWDG9H:1;
      vuint32_t MSKWDG9L:1;
      vuint32_t MSKWDG8H:1;
      vuint32_t MSKWDG8L:1;
      vuint32_t MSKWDG7H:1;
      vuint32_t MSKWDG7L:1;
      vuint32_t MSKWDG6H:1;
      vuint32_t MSKWDG6L:1;
      vuint32_t MSKWDG5H:1;
      vuint32_t MSKWDG5L:1;
      vuint32_t MSKWDG4H:1;
      vuint32_t MSKWDG4L:1;
      vuint32_t MSKWDG3H:1;
      vuint32_t MSKWDG3L:1;
      vuint32_t MSKWDG2H:1;
      vuint32_t MSKWDG2L:1;
      vuint32_t MSKWDG1H:1;
      vuint32_t MSKWDG1L:1;
      vuint32_t MSKWDG0H:1;
      vuint32_t MSKWDG0L:1;
    } B;
  } WTIMR;

  uint8_t SARADC_reserved1[8];
  union {                              /* DMA Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t DCLR:1;
      vuint32_t DMAEN:1;
    } B;
  } DMAE;

  union {                              /* Internal Channel DMA Select Register */
    vuint32_t R;
    struct {
      vuint32_t DS_CHx:32;
    } B;
  } ICDSR[3];

  uint8_t SARADC_reserved2[16];
  union {                              /* Watchdog Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t  :4;
      vuint32_t THRH:12;
      vuint32_t  :4;
      vuint32_t THRL:12;
    } B;
  } WTHRHLR[4];

  uint8_t SARADC_reserved3[36];
  union {                              /* Conversion Timing Register */
    vuint32_t R;
    struct {
      vuint32_t CRES:1;
      vuint32_t  :19;
      vuint32_t PRECHG:4;
      vuint32_t INPSAMP:8;
    } B;
  } CTR[4];

  union {                              /* Internal Channel Normal Conversion Mask Register */
    vuint32_t R;
    struct {
      vuint32_t NCE_CHx:32;
    } B;
  } ICNCMR[3];

  uint8_t SARADC_reserved4[4];
  union {                              /* Internal Channel Injected Conversion Mask Register */
    vuint32_t R;
    struct {
      vuint32_t JCE_CH:32;
    } B;
  } ICJCMR[3];

  uint8_t SARADC_reserved5[8];
  union {                              /* Power Down Exit Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t PDED:8;
    } B;
  } PDEDR;

  uint8_t SARADC_reserved6[52];
  union {                              /* Internal Channel Data Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t REFSEL:1;
      vuint32_t  :2;
      vuint32_t PCE:1;
      vuint32_t  :1;
      vuint32_t CTSEL:2;
      vuint32_t  :4;
      vuint32_t VALID:1;
      vuint32_t OVERW:1;
      vuint32_t RESULT:2;
      vuint32_t CDATA:16;
    } B;
  } ICDR[96];

  uint8_t SARADC_reserved7[48];
  union {                              /* Internal Channel Watchdog Selection Register */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CH7:4;
      vuint32_t WSEL_CH6:4;
      vuint32_t WSEL_CH5:4;
      vuint32_t WSEL_CH4:4;
      vuint32_t WSEL_CH3:4;
      vuint32_t WSEL_CH2:4;
      vuint32_t WSEL_CH1:4;
      vuint32_t WSEL_CH0:4;
    } B;
  } ICWSELR[12];

  union {                              /* Internal Channel Watchdog Enable Register */
    vuint32_t R;
    struct {
      vuint32_t WEN_CHx:32;
    } B;
  } ICWENR[3];

  uint8_t SARADC_reserved8[4];
  union {                              /* Internal Channel Analog Watchdog Out of Range register */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CHx:32;
    } B;
  } ICAWORR[3];

  uint8_t SARADC_reserved9[260];
  union {                              /* Test Channel Interrupt Pending Register */
    vuint32_t R;
    struct {
      vuint32_t EOC_CHx:32;
    } B;
  } TCIPR;

  union {                              /* Test Channel Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t IM_CHx:32;
    } B;
  } TCIMR;

  union {                              /* Test Channel DMA Select Register */
    vuint32_t R;
    struct {
      vuint32_t DS_CHx:32;
    } B;
  } TCDSR;

  union {                              /* Test Channel Normal Conversion Mask Register */
    vuint32_t R;
    struct {
      vuint32_t NCE_CHx:32;
    } B;
  } TCNCMR;

  union {                              /* Test Channel Injected Conversion Mask Register */
    vuint32_t R;
    struct {
      vuint32_t JCE_CHx:32;
    } B;
  } TCJCMR;

  union {                              /* Test Channel Watchdog Selection Register */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CHa:4;
      vuint32_t WSEL_CHb:4;
      vuint32_t WSEL_CHc:4;
      vuint32_t WSEL_CHd:4;
      vuint32_t WSEL_CHe:4;
      vuint32_t WSEL_CHf:4;
      vuint32_t WSEL_CHg:4;
      vuint32_t WSEL_CHh:4;
    } B;
  } TCWSELR[4];

  union {                              /* Test Channel Watchdog Enable Register */
    vuint32_t R;
    struct {
      vuint32_t WEN_CHx:32;
    } B;
  } TCWENR;

  union {                              /* Test Channel Analog Watchdog Out of Range Register */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CHx:32;
    } B;
  } TCAWORR;

  uint8_t SARADC_reserved10[4];
  union {                              /* Test Channel Connection with Analog Pin Register */
    vuint32_t R;
    struct {
      vuint32_t ESIC_TCH3:1;
      vuint32_t ICSEL_TCH3:7;
      vuint32_t ESIC_TCH2:1;
      vuint32_t ICSEL_TCH2:7;
      vuint32_t ESIC_TCH1:1;
      vuint32_t ICSEL_TCH1:7;
      vuint32_t ESIC_TCH0:1;
      vuint32_t ICSEL_TCH0:7;
    } B;
  } TCCAPR[8];

  union {                              /* Test Channel Data Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t REFSEL:1;
      vuint32_t  :2;
      vuint32_t PCE:1;
      vuint32_t  :1;
      vuint32_t CTSEL:2;
      vuint32_t  :4;
      vuint32_t VALID:1;
      vuint32_t OVERW:1;
      vuint32_t RESULT:2;
      vuint32_t CDATA:16;
    } B;
  } TCDR[32];

  uint8_t SARADC_reserved11[48];
  union {                              /* External Channel Decode Signals Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t DSD:12;
    } B;
  } ECDSDR;

  uint8_t SARADC_reserved12[12];
  union {                              /* External Channel Interrupt Pending Register */
    vuint32_t R;
    struct {
      vuint32_t EOC_CHx:32;
    } B;
  } ECIPR[4];

  union {                              /* External Channel Interrupt Mask Register */
    vuint32_t R;
    struct {
      vuint32_t IM_CHx:32;
    } B;
  } ECIMR[4];

  union {                              /* External Channel DMA Select Register */
    vuint32_t R;
    struct {
      vuint32_t DS_CHx:32;
    } B;
  } ECDSR[4];

  union {                              /* External Channel Normal Conversion Mask Register */
    vuint32_t R;
    struct {
      vuint32_t NCE_CHx:32;
    } B;
  } ECNCMR[4];

  union {                              /* External Channel Injected Conversion Mask Register */
    vuint32_t R;
    struct {
      vuint32_t JCE_CHx:32;
    } B;
  } ECJCMR[4];

  union {                              /* External Channel Watchdog Selection Register */
    vuint32_t R;
    struct {
      vuint32_t WSEL_CHa:4;
      vuint32_t WSEL_CHb:4;
      vuint32_t WSEL_CHc:4;
      vuint32_t WSEL_CHd:4;
      vuint32_t WSEL_CHe:4;
      vuint32_t WSEL_CHf:4;
      vuint32_t WSEL_CHg:4;
      vuint32_t WSEL_CHh:4;
    } B;
  } ECWSELR[16];

  union {                              /* External Channel Watchdog Enable Register */
    vuint32_t R;
    struct {
      vuint32_t WEN_CHx:32;
    } B;
  } ECWENR[4];

  union {                              /* External Channel Analog Watchdog Out of Range register */
    vuint32_t R;
    struct {
      vuint32_t AWOR_CHx:32;
    } B;
  } ECAWORR[4];

  union {                              /* External Channel Mapping to Internal Channel Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t ICSEL_ECH152_159:7;
      vuint32_t  :1;
      vuint32_t ICSEL_ECH144_151:7;
      vuint32_t  :1;
      vuint32_t ICSEL_ECH136_143:7;
      vuint32_t  :1;
      vuint32_t ICSEL_ECH128_135:7;
    } B;
  } ECMICR[4];

  union {                              /* External Channel Data Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t REFSEL:1;
      vuint32_t  :2;
      vuint32_t PCE:1;
      vuint32_t  :1;
      vuint32_t CTSEL:2;
      vuint32_t  :4;
      vuint32_t VALID:1;
      vuint32_t OVERW:1;
      vuint32_t RESULT:2;
      vuint32_t CDATA:16;
    } B;
  } ECDR[128];
};


/* ============================================================================
   =============================== Module: SDADC ==============================
   ============================================================================ */

struct SDADC_tag {
  union {                              /* Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :3;
      vuint32_t PDR:5;
      vuint32_t  :1;
      vuint32_t PGAN:3;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t EMSEL:1;
      vuint32_t HPFEN:1;
      vuint32_t WDGEN:1;
      vuint32_t TRIGEDSEL:2;
      vuint32_t TRIGEN:1;
      vuint32_t TRIGSEL:4;
      vuint32_t FRZ:1;
      vuint32_t  :2;
      vuint32_t VCOMSEL:1;
      vuint32_t WRMODE:1;
      vuint32_t GECEN:1;               /* Accurate Gain Error Mode Enable */
      vuint32_t MODE:1;
      vuint32_t EN:1;
    } B;
  } MCR;

  union {                              /* Channel Selection Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t BIASEN:8;
      vuint32_t  :5;
      vuint32_t ANCHSEL_WRAP:3;
      vuint32_t  :5;
      vuint32_t ANCHSEL:3;
    } B;
  } CSR;

  union {                              /* Reset Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t RESET_KEY:16;
    } B;
  } RKR;

  union {                              /* Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :13;
      vuint32_t ANCHSEL_CNT:3;
      vuint32_t  :7;
      vuint32_t DFEF:1;
      vuint32_t  :3;
      vuint32_t WTHH:1;
      vuint32_t WTHL:1;
      vuint32_t CDVF:1;
      vuint32_t DFORF:1;
      vuint32_t DFFF:1;
    } B;
  } SFR;

  union {                              /* Request Select and Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t WTHDIRS:1;
      vuint32_t DFFDIRS:1;
      vuint32_t GDIGE:1;
      vuint32_t  :11;
      vuint32_t WTHDIRE:1;
      vuint32_t CDVEE:1;
      vuint32_t DFORIE:1;
      vuint32_t DFFDIRE:1;
    } B;
  } RSER;

  union {                              /* Output Settling Delay Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t OSD:8;
    } B;
  } OSDR;

  union {                              /* FIFO Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t FRST:1;
      vuint32_t  :3;
      vuint32_t FTHLD:5;
      vuint32_t  :4;
      vuint32_t FOWEN:1;
      vuint32_t FSIZE:2;
      vuint32_t FE:1;
    } B;
  } FCR;

  union {                              /* Software Trigger Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t ST_KEY:16;
    } B;
  } STKR;

  union {                              /* Converted Data Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CDATA:16;
    } B;
  } CDR;

  union {                              /* WDG Threshold Register */
    vuint32_t R;
    struct {
      vuint32_t THRH:16;
      vuint32_t THRL:16;
    } B;
  } WTHHLR;
};


/* ============================================================================
   =============================== Module: SEMA42 =============================
   ============================================================================ */

struct SEMA42_tag {
  union {                              /* Gate Register */
    vuint8_t R;
    struct {
      vuint8_t  :4;
      vuint8_t GTFSM:4;                /* [BLG_SEMA42_0001] [Covers: ADD06.057] Gate Finite State Machine. [end] */
    } B;
  } GATE[16];

  uint8_t SEMA42_reserved0[48];
  union {
    union {                            /* Reset Gate Read */
      vuint16_t R;
      struct {
        vuint16_t  :2;
        vuint16_t RSTGSM:2;
        vuint16_t RSTGMS:4;
        vuint16_t RSTGTN:8;
      } B;
    } R;
    union {                            /* Reset Gate Write */
      vuint16_t R;
      struct {
        vuint16_t RSTGDP:8;
        vuint16_t RSTGTN:8;
      } B;
    } W;
  } RSTGT;
};


/* ============================================================================
   =============================== Module: SIPI ===============================
   ============================================================================ */

struct SIPI_tag {
  union {                              /* SIPI Channel Control Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;                  /* Streaming Transfer. */
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;                 /* Read Request Transfer. */
      vuint32_t WRT:1;                 /* Write Request Transfer. */
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR0;

  union {                              /* SIPI Channel Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR0;

  uint8_t SIPI_reserved0[4];
  union {                              /* SIPI Channel Interrupt Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;                /* Write Acknowledge Interrupt Enable. */
      vuint32_t RAIE:1;                /* Read Answer Interrupt Enable. */
      vuint32_t TCIE:1;                /* Trigger Command Interrupt Enable. */
      vuint32_t TOIE:1;                /* Timeout Error Interrupt Enabled. */
      vuint32_t TIDIE:1;               /* Transaction ID Error Interrupt Enable. */
      vuint32_t ACKIE:1;               /* Acknowledge Error Interrupt Enable. */
    } B;
  } CIR0;

  union {                              /* SIPI Channel Timeout Register 0 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR0;

  union {                              /* SIPI Channel CRC Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC0;

  union {                              /* SIPI Channel Address Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR0;

  union {                              /* SIPI Channel Data Register 0 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR0;

  union {                              /* SIPI Channel Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;
      vuint32_t WRT:1;                 /* Write Request Transfer. */
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR1;

  union {                              /* SIPI Channel Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR1;

  uint8_t SIPI_reserved1[4];
  union {                              /* SIPI Channel Interrupt Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR1;

  union {                              /* SIPI Channel Timeout Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR1;

  union {                              /* SIPI Channel CRC Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC1;

  union {                              /* SIPI Channel Address Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR1;

  union {                              /* SIPI Channel Data Register 1 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR1;

  union {                              /* SIPI Channel Control Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;                 /* Read Request Transfer. */
      vuint32_t WRT:1;
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR2;

  union {                              /* SIPI Channel Status Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR2;

  uint8_t SIPI_reserved2[4];
  union {                              /* SIPI Channel Interrupt Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR2;

  union {                              /* SIPI Channel Timeout Register 2 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;
    } B;
  } CTOR2;

  union {                              /* SIPI Channel CRC Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC2;

  union {                              /* SIPI Channel Address Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR2;

  union {                              /* SIPI Channel Data Register 2 */
    vuint32_t R;
    struct {
      vuint32_t CDR2:32;
    } B;
  } CDR2[8];

  union {                              /* SIPI Channel Control Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :15;
      vuint32_t TC:1;                  /* Send Trigger Command. */
      vuint32_t  :8;
      vuint32_t WL:2;                  /* Word Length Transfer. */
      vuint32_t CHEN:1;                /* Channel Enable. */
      vuint32_t ST:1;                  /* Streaming Transfer. */
      vuint32_t IDT:1;                 /* ID Read Request Transfer. */
      vuint32_t RRT:1;                 /* Read Request Transfer. */
      vuint32_t WRT:1;                 /* Write Request Transfer. */
      vuint32_t DEN:1;                 /* DMA Enable. */
    } B;
  } CCR3;

  union {                              /* SIPI Channel Status Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t RAR:1;
      vuint32_t TID:3;                 /* Transaction ID of transmitted frame. */
      vuint32_t ACKR:1;
      vuint32_t CB:1;                  /* Channel Busy. */
      vuint32_t  :2;
    } B;
  } CSR3;

  uint8_t SIPI_reserved3[4];
  union {                              /* SIPI Channel Interrupt Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t WAIE:1;
      vuint32_t RAIE:1;
      vuint32_t TCIE:1;
      vuint32_t TOIE:1;
      vuint32_t TIDIE:1;
      vuint32_t ACKIE:1;
    } B;
  } CIR3;

  union {                              /* SIPI Channel Timeout Register 3 */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t TOR:8;                 /* Timeout value for transmitted requests. */
    } B;
  } CTOR3;

  union {                              /* SIPI Channel CRC Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CRCI:16;
      vuint32_t CRCT:16;
    } B;
  } CCRC3;

  union {                              /* SIPI Channel Address Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CAR:32;
    } B;
  } CAR3;

  union {                              /* SIPI Channel Data Register 3 */
    vuint32_t R;
    struct {
      vuint32_t CDR:32;
    } B;
  } CDR3;

  union {                              /* SIPI Module Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t FRZ:1;                 /* Freeze Enable */
      vuint32_t  :1;
      vuint32_t HALT:1;                /* Halt Mode Enable */
      vuint32_t  :2;
      vuint32_t PRSCLR:11;             /* Timeout counter prescaler */
      vuint32_t AID:2;                 /* Address Increment/Decrement */
      vuint32_t  :3;
      vuint32_t CRCIE:1;               /* CRC Error Interrupt Enable */
      vuint32_t MCRIE:1;               /* Max Count Reached Interrupt Enable */
      vuint32_t  :4;
      vuint32_t CHNSB:1;               /* Channel coding select bit. */
      vuint32_t TEN:1;                 /* Target Enable */
      vuint32_t INIT:1;                /* Initialization Mode */
      vuint32_t MOEN:1;                /* Module Enable */
      vuint32_t SR:1;                  /* Soft Reset */
    } B;
  } MCR;

  union {                              /* SIPI Status Register */
    vuint32_t R;
    struct {
      vuint32_t FRZACK:1;
      vuint32_t LPMACK:1;              /* Low Power Mode Acknowledge. */
      vuint32_t  :19;
      vuint32_t GCRCE:1;
      vuint32_t MCR:1;                 /* Maximum Count Reached. */
      vuint32_t  :1;
      vuint32_t TE:4;
      vuint32_t STATE:4;
    } B;
  } SR;

  union {                              /* SIPI Max Count Register */
    vuint32_t R;
    struct {
      vuint32_t MXCNT:30;
      vuint32_t  :2;
    } B;
  } MAXCR;

  union {                              /* SIPI Address Reload Register */
    vuint32_t R;
    struct {
      vuint32_t ADRLD:30;
      vuint32_t  :2;
    } B;
  } ARR;

  union {                              /* SIPI Address Count Register */
    vuint32_t R;
    struct {
      vuint32_t ADCNT:30;              /* Feflects the count value of address counter at target node. */
      vuint32_t  :2;
    } B;
  } ACR;

  union {                              /* SIPI Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :5;
      vuint32_t TOE3:1;
      vuint32_t TIDE3:1;
      vuint32_t ACKE3:1;
      vuint32_t  :5;
      vuint32_t TOE2:1;
      vuint32_t TIDE2:1;
      vuint32_t ACKE2:1;
      vuint32_t  :5;
      vuint32_t TOE1:1;
      vuint32_t TIDE1:1;
      vuint32_t ACKE1:1;
      vuint32_t  :5;
      vuint32_t TOE0:1;
      vuint32_t TIDE0:1;
      vuint32_t ACKE0:1;
    } B;
  } ERR;
};


/* ============================================================================
   =============================== Module: SIUL2 ==============================
   ============================================================================ */

struct SIUL2_tag {
  uint8_t SIUL2_reserved0[4];
  union {                              /* MCU ID Register #1 */
    vuint32_t R;
    struct {
      vuint32_t PARTNUM:16;
      vuint32_t ED:1;
      vuint32_t PKG:5;
      vuint32_t  :2;
      vuint32_t MAJOR_MASK:4;
      vuint32_t MINOR_MASK:4;
    } B;
  } MIDR1;

  union {                              /* MCU ID Register #2 */
    vuint32_t R;
    struct {
      vuint32_t SF:1;
      vuint32_t FLASH_SIZE_1:4;
      vuint32_t FLASH_SIZE_2:4;
      vuint32_t  :7;
      vuint32_t FAMILYNUM:8;
      vuint32_t  :8;
    } B;
  } MIDR2;

  uint8_t SIUL2_reserved1[4];
  union {                              /* DMA/Interrupt Status Flag Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t EIF11:1;
      vuint32_t EIF10:1;
      vuint32_t EIF9:1;
      vuint32_t EIF8:1;
      vuint32_t  :2;
      vuint32_t EIF5:1;
      vuint32_t EIF4:1;
      vuint32_t EIF3:1;
      vuint32_t EIF2:1;
      vuint32_t EIF1:1;
      vuint32_t EIF0:1;
    } B;
  } DISR0;

  uint8_t SIUL2_reserved2[4];
  union {                              /* DMA/Interrupt Request Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t EIRE11:1;
      vuint32_t EIRE10:1;
      vuint32_t EIRE9:1;
      vuint32_t EIRE8:1;
      vuint32_t  :2;
      vuint32_t EIRE5:1;
      vuint32_t EIRE4:1;
      vuint32_t EIRE3:1;
      vuint32_t EIRE2:1;
      vuint32_t EIRE1:1;
      vuint32_t EIRE0:1;
    } B;
  } DIRER0;

  uint8_t SIUL2_reserved3[4];
  union {                              /* DMA/Interrupt Request Select Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t DIRS11:1;
      vuint32_t DIRS10:1;
      vuint32_t DIRS9:1;
      vuint32_t DIRS8:1;
      vuint32_t  :2;
      vuint32_t DIRS5:1;
      vuint32_t DIRS4:1;
      vuint32_t DIRS3:1;
      vuint32_t DIRS2:1;
      vuint32_t DIRS1:1;
      vuint32_t DIRS0:1;
    } B;
  } DIRSR0;

  uint8_t SIUL2_reserved4[4];
  union {                              /* Interrupt Rising-Edge Event Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t IREE11:1;
      vuint32_t IREE10:1;
      vuint32_t IREE9:1;
      vuint32_t IREE8:1;
      vuint32_t  :2;
      vuint32_t IREE5:1;
      vuint32_t IREE4:1;
      vuint32_t IREE3:1;
      vuint32_t IREE2:1;
      vuint32_t IREE1:1;
      vuint32_t IREE0:1;
    } B;
  } IREER0;

  uint8_t SIUL2_reserved5[4];
  union {                              /* Interrupt Falling-Edge Event Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t IFEE11:1;
      vuint32_t IFEE10:1;
      vuint32_t IFEE9:1;
      vuint32_t IFEE8:1;
      vuint32_t  :2;
      vuint32_t IFEE5:1;
      vuint32_t IFEE4:1;
      vuint32_t IFEE3:1;
      vuint32_t IFEE2:1;
      vuint32_t IFEE1:1;
      vuint32_t IFEE0:1;
    } B;
  } IFEER0;

  uint8_t SIUL2_reserved6[4];
  union {                              /* Interrupt Filter Enable Register0 */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t IFE11:1;
      vuint32_t IFE10:1;
      vuint32_t IFE9:1;
      vuint32_t IFE8:1;
      vuint32_t  :2;
      vuint32_t IFE5:1;
      vuint32_t IFE4:1;
      vuint32_t IFE3:1;
      vuint32_t IFE2:1;
      vuint32_t IFE1:1;
      vuint32_t IFE0:1;
    } B;
  } IFER0;

  uint8_t SIUL2_reserved7[4];
  union {                              /* Interrupt Filter Maximum Counter Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t MAXCNTx:4;
    } B;
  } IFMCR[32];

  union {                              /* Interrupt Filter Clock Prescaler */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t IFCP:4;
    } B;
  } IFCPR;

  uint8_t SIUL2_reserved8[60];
  union {                              /* SoC Configuration Register0 */
    vuint32_t R;
    struct {
      vuint32_t FEC_MODE:1;
      vuint32_t  :7;
      vuint32_t ESR0_ASSERT:1;
      vuint32_t  :23;
    } B;
  } SCR0;

  uint8_t SIUL2_reserved9[316];
  union {                              /* I/O Pin Multiplexed Signal Configuration Registers */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t OERC:3;
      vuint32_t  :1;
      vuint32_t ODC:3;
      vuint32_t SMC:1;
      vuint32_t APC:1;
      vuint32_t ILS:2;
      vuint32_t IBE:1;
      vuint32_t HYS:1;
      vuint32_t WPDE:1;
      vuint32_t WPUE:1;
      vuint32_t INV:1;
      vuint32_t  :7;
      vuint32_t SSS:8;
    } B;
  } MSCR_IO[512];

  union {                              /* Multiplexed Signal Configuration Register for Multiplexed Input Selection */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t INV:1;
      vuint32_t  :7;
      vuint32_t SSS:8;
    } B;
  } MSCR_MUX[512];

  uint8_t SIUL2_reserved10[192];
  union {                              /* GPIO Pad Data Out Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDO:1;
    } B;
  } GPDO[512];

  union {                              /* GPIO Pad Data In Register */
    vuint8_t R;
    struct {
      vuint8_t  :7;
      vuint8_t PDI:1;
    } B;
  } GPDI[512];

  union {                              /* Parallel GPIO Pad Data Out Register */
    vuint16_t R;
    struct {
      vuint16_t PPDO:16;
    } B;
  } PGPDO[32];

  union {                              /* Parallel GPIO Pad Data In Register */
    vuint16_t R;
    struct {
      vuint16_t PPDI:16;
    } B;
  } PGPDI[32];

  union {                              /* Masked Parallel GPIO Pad Data Out Register */
    vuint32_t R;
    struct {
      vuint32_t MASK:16;
      vuint32_t MPPDO:16;
    } B;
  } MPGPDO[32];
};


/* ============================================================================
   =============================== Module: SMPU ===============================
   ============================================================================ */

struct SMPU_tag {
  union {                              /* Control/Error Status Register 0 */
    vuint32_t R;
    struct {
      vuint32_t MERR:16;
      vuint32_t  :1;
      vuint32_t  :11;
      vuint32_t HRL:3;
      vuint32_t GVLD:1;
    } B;
  } CESR0;

  union {                              /* Control/Error Status Register 1 */
    vuint32_t R;
    struct {
      vuint32_t MEOVR:16;
      vuint32_t  :1;
      vuint32_t  :11;
      vuint32_t NRGD:4;
    } B;
  } CESR1;

  uint8_t SMPU_reserved0[248];
  struct {
    union {                            /* Error Address Register, Bus Master n */
      vuint32_t R;
      struct {
        vuint32_t EADDR:32;
      } B;
    } EAR;
    union {                            /* Error Detail Register, Bus Master n */
      vuint32_t R;
      struct {
        vuint32_t EACD:24;
        vuint32_t  :1;
        vuint32_t EATTR:2;
        vuint32_t ERW:1;
        vuint32_t EMN:4;
      } B;
    } EDR;
  } ERROR[16];

  uint8_t SMPU_reserved1[640];
  struct {
    union {                            /* Region Descriptor n, Word 0 */
      vuint32_t R;
      struct {
        vuint32_t SRTADDR:32;
      } B;
    } WORD0;
    union {                            /* Region Descriptor n, Word 1 */
      vuint32_t R;
      struct {
        vuint32_t ENDADDR:32;
      } B;
    } WORD1;
    union {                            /* Region Descriptor n, Word 2 Format 0 */
      vuint32_t R;
      struct {
        vuint32_t M0P:2;
        vuint32_t M1P:2;
        vuint32_t M2P:2;
        vuint32_t M3P:2;
        vuint32_t M4P:2;
        vuint32_t M5P:2;
        vuint32_t M6P:2;
        vuint32_t M7P:2;
        vuint32_t M8P:2;
        vuint32_t M9P:2;
        vuint32_t M10P:2;
        vuint32_t M11P:2;
        vuint32_t M12P:2;
        vuint32_t M13P:2;
        vuint32_t M14P:2;
        vuint32_t M15P:2;
      } B;
    } WORD2;
    union {                            /* Region Descriptor n, Word 3 */
      vuint32_t R;
      struct {
        vuint32_t  :27;
        vuint32_t FMT:1;
        vuint32_t RO:1;
        vuint32_t  :1;
        vuint32_t CI:1;
        vuint32_t VLD:1;
      } B;
    } WORD3;
  } RGD[12];
};


/* ============================================================================
   =============================== Module: SRX ================================
   ============================================================================ */

struct SRX_tag {
  union {                              /* Global Control Register */
    vuint32_t R;
    struct {
      vuint32_t TSPRSC:8;
      vuint32_t  :8;
      vuint32_t  :1;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t  :1;
      vuint32_t FAST_CLR:1;
      vuint32_t  :1;
      vuint32_t DBG_FRZ:1;
      vuint32_t  :1;
      vuint32_t SENT_EN:1;
    } B;
  } GBL_CTRL;

  union {                              /* Channel Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t EN_CH:8;
    } B;
  } CHNL_EN;

  union {                              /* Global Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t FMDU:1;
      vuint32_t SMDU:1;
      vuint32_t  :8;
    } B;
  } GBL_STATUS;

  union {                              /* Fast Message Ready Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t F_RDY:8;
    } B;
  } FMSG_RDY;

  union {                              /* Slow Serial Message Ready Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t S_RDY:8;
    } B;
  } SMSG_RDY;

  uint8_t SRX_reserved0[4];
  union {                              /* Data Control Register 1 */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t NIBBCH0:3;
      vuint32_t  :1;
      vuint32_t NIBBCH1:3;
      vuint32_t  :1;
      vuint32_t NIBBCH2:3;
      vuint32_t  :1;
      vuint32_t NIBBCH3:3;
      vuint32_t  :1;
      vuint32_t NIBBCH4:3;
      vuint32_t  :1;
      vuint32_t NIBBCH5:3;
      vuint32_t  :1;
      vuint32_t NIBBCH6:3;
      vuint32_t  :1;
      vuint32_t NIBBCH7:3;
    } B;
  } DATA_CTRL1;

  uint8_t SRX_reserved1[12];
  union {                              /* Fast Message DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t FDMA_EN:8;
    } B;
  } FDMA_CTRL;

  union {                              /* Slow Serial Message DMA Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SDMA_EN:8;
    } B;
  } SDMA_CTRL;

  uint8_t SRX_reserved2[4];
  union {                              /* Fast Message Ready Interrupt Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t FRDY_IE:8;
    } B;
  } FRDY_IE;

  union {                              /* Slow Serial Message Ready Interrupt Enable Register */
    vuint32_t R;
    struct {
      vuint32_t  :24;
      vuint32_t SRDY_IE:8;
    } B;
  } SRDY_IE;

  uint8_t SRX_reserved3[4];
  union {                              /* DMA Fast Message Data Read Register */
    vuint32_t R;
    struct {
      vuint32_t CHNUM:4;
      vuint32_t SCNIB:4;
      vuint32_t DNIB1:4;
      vuint32_t DNIB2:4;
      vuint32_t DNIB3:4;
      vuint32_t DNIB4:4;
      vuint32_t DNIB5:4;
      vuint32_t DNIB6:4;
    } B;
  } DMA_FMSG_DATA;

  union {                              /* DMA Fast Message CRC Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :12;
      vuint32_t CRC4b:4;
      vuint32_t  :16;
    } B;
  } DMA_FMSG_CRC;

  union {                              /* DMA Fast Message Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t TS:32;
    } B;
  } DMA_FMSG_TS;

  uint8_t SRX_reserved4[4];
  union {                              /* DMA Slow Serial Message Bit3 Read Register */
    vuint32_t R;
    struct {
      vuint32_t CHNUM:4;
      vuint32_t TYPE:1;
      vuint32_t  :16;
      vuint32_t CFG:1;
      vuint32_t ID7_4_D3_0:4;
      vuint32_t  :1;
      vuint32_t ID3_0_DATA15_12:4;
      vuint32_t  :1;
    } B;
  } DMA_SMSG_BIT3;

  union {                              /* DMA Slow Serial Message Bit2 Read Register */
    vuint32_t R;
    struct {
      vuint32_t  :10;
      vuint32_t SMCRC:6;
      vuint32_t  :4;
      vuint32_t DATA:12;
    } B;
  } DMA_SMSG_BIT2;

  union {                              /* DMA Slow Serial Message Time Stamp Read Register */
    vuint32_t R;
    struct {
      vuint32_t TS:32;
    } B;
  } DMA_SMSG_TS;

  uint8_t SRX_reserved5[4];
  struct {
    union {                            /* Channel 'n' Clock Control Register (n = 0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t CM_PRSC:15;
        vuint32_t COMP_EN:1;
        vuint32_t  :1;
        vuint32_t PRSC:14;
      } B;
    } CLK_CTRL;
    union {                            /* Channel 'n' Status Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t BUS_IDLE:1;
        vuint32_t  :3;
        vuint32_t CAL_RESYNC:1;
        vuint32_t CAL_20_25:1;
        vuint32_t SMSG_OFLW:1;
        vuint32_t FMSG_OFLW:1;
        vuint32_t  :1;
        vuint32_t PP_DIAG_ERR:1;
        vuint32_t CAL_LEN_ERR:1;
        vuint32_t CAL_DIAG_ERR:1;
        vuint32_t NIB_VAL_ERR:1;
        vuint32_t SMSG_CRC_ERR:1;
        vuint32_t FMSG_CRC_ERR:1;
        vuint32_t NUM_EDGES_ERR:1;
        vuint32_t  :16;
      } B;
    } STATUS;
    union {                            /* Channel 'n' Configuration Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t BUS_IDLE_CNT:4;
        vuint32_t IE_CAL_RESYNC:1;
        vuint32_t IE_CAL_20_25:1;
        vuint32_t IE_SMSG_OFLW:1;
        vuint32_t IE_FMSG_OFLW:1;
        vuint32_t FCRC_CHK_OFF:1;
        vuint32_t IE_PP_DIAG_ERR:1;
        vuint32_t IE_CAL_LEN_ERR:1;
        vuint32_t IE_CAL_DIAG_ERR:1;
        vuint32_t IE_NIB_VAL_ERR:1;
        vuint32_t IE_SMSG_CRC_ERR:1;
        vuint32_t IE_FMSG_CRC_ERR:1;
        vuint32_t IE_NUM_EDGES_ERR:1;
        vuint32_t DCHNG_INT:1;
        vuint32_t CAL_RNG:1;
        vuint32_t PP_CHKSEL:1;
        vuint32_t FCRC_TYPE:1;
        vuint32_t FCRC_SC_EN:1;
        vuint32_t SCRC_TYPE:1;
        vuint32_t PAUSE_EN:1;
        vuint32_t SUCC_CAL_CHK:1;
        vuint32_t FIL_CNT:8;
      } B;
    } CONFIG;
    uint8_t CH_reserved0[4];
  } CH[8];

  uint8_t SRX_reserved6[128];
  struct {
    union {                            /* Channel 'n' Fast Message Data Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t CHNUM:4;
        vuint32_t SCNIB:4;
        vuint32_t DNIB1:4;
        vuint32_t DNIB2:4;
        vuint32_t DNIB3:4;
        vuint32_t DNIB4:4;
        vuint32_t DNIB5:4;
        vuint32_t DNIB6:4;
      } B;
    } FMSG_DATA;
    union {                            /* Channel 'n' Fast Message CRC Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :12;
        vuint32_t CRC4b:4;
        vuint32_t  :16;
      } B;
    } FMSG_CRC;
    union {                            /* Channel 'n' Fast Message Time Stamp Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t TS:32;
      } B;
    } FMSG_TS;
    union {                            /* Channel 'n' Serial Message Read Register (Bit 3) (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t CHNUM:4;
        vuint32_t TYPE:1;
        vuint32_t  :16;
        vuint32_t CFG:1;
        vuint32_t ID7_4_ID3_0:4;
        vuint32_t  :1;
        vuint32_t ID3_0_DATA15_12:4;
        vuint32_t  :1;
      } B;
    } SMSG_BIT3;
    union {                            /* Channel 'n' Serial Message Read Register (Bit 2)(n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t  :10;
        vuint32_t SMCRC:6;
        vuint32_t  :4;
        vuint32_t DATA:12;
      } B;
    } SMSG_BIT2;
    union {                            /* Channel 'n' Serial Message Time Stamp Read Register (n=0 to (CH-1)) */
      vuint32_t R;
      struct {
        vuint32_t TS:32;
      } B;
    } SMSG_TS;
  } CHANNEL[8];
};


/* ============================================================================
   =============================== Module: SSCM ===============================
   ============================================================================ */

struct SSCM_tag {
  union {                              /* SSCM System Status */
    vuint16_t R;
    struct {
      vuint16_t  :1;
      vuint16_t CER:1;                 /* Configuration Error */
      vuint16_t  :1;
      vuint16_t NXEN1:1;               /* Processor 1 Nexus enable status */
      vuint16_t NXEN:1;                /* Processor 0 Nexus enable status */
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t BMODE:3;               /* Device Boot Mode */
      vuint16_t VLE:1;                 /* Variable Length Instruction Mode */
      vuint16_t  :1;
      vuint16_t  :1;
      vuint16_t  :2;
    } B;
  } STATUS;

  union {                              /* SSCM System Memory and ID Register */
    vuint16_t R;
    struct {
      vuint16_t JPIN:10;
      vuint16_t  :1;
      vuint16_t MREV:4;                /* Minor Mask Revision */
      vuint16_t  :1;
    } B;
  } MEMCONFIG;

  uint8_t SSCM_reserved0[2];
  union {                              /* SSCM Error Configuration Register */
    vuint16_t R;
    struct {
      vuint16_t  :14;
      vuint16_t PAE:1;                 /* Peripheral Bus Abort Enable. */
      vuint16_t RAE:1;                 /* Register Bus Abort Enable. */
    } B;
  } ERROR;

  uint8_t SSCM_reserved1[24];
  union {                              /* SSCM HSM and User Option Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :28;
      vuint32_t HSB:3;                 /* HSM Boot Configuration */
      vuint32_t HSE:1;                 /* HSM Enabled */
    } B;
  } UOPS;

  uint8_t SSCM_reserved2[4];
  union {                              /* Processor Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t SADR:32;               /* Processor Start Address */
    } B;
  } PSA;

  uint8_t SSCM_reserved3[4];
  union {                              /* SSCM HSM Start Address Register */
    vuint32_t R;
    struct {
      vuint32_t HADR:32;               /* HSM Start Address */
    } B;
  } HSA;

  union {                              /* Life Cycle Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t LC:3;                  /* Life Cycle */
    } B;
  } LCSTAT;
};


/* ============================================================================
   =============================== Module: STCU2 ==============================
   ============================================================================ */

struct STCU2_tag {
  union {                              /* STCU2 Run Register */
    vuint32_t R;
    struct {
      vuint32_t  :21;
      vuint32_t BYP:1;
      vuint32_t MBPLLEN:1;
      vuint32_t LBPLLEN:1;
      vuint32_t  :7;
      vuint32_t RUN:1;
    } B;
  } RUN;

  union {                              /* STCU2 Run Software Register */
    vuint32_t R;
    struct {
      vuint32_t  :20;
      vuint32_t MBIE:1;
      vuint32_t LBIE:1;
      vuint32_t MBSWPLLEN:1;
      vuint32_t LBSWPLLEN:1;
      vuint32_t  :6;
      vuint32_t RUNSW_ABORT:1;
      vuint32_t RUNSW:1;
    } B;
  } RUNSW;

  union {                              /* STCU2 SK Code Register */
    vuint32_t R;
    struct {
      vuint32_t SKC:32;
    } B;
  } SKC;

  union {                              /* STCU2 Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :1;
      vuint32_t PTR:7;
      vuint32_t LB_DELAY:8;
      vuint32_t  :7;
      vuint32_t WRP:1;
      vuint32_t  :2;
      vuint32_t CRCEN:1;
      vuint32_t PMOSEN:1;
      vuint32_t MBU:1;
      vuint32_t CLK_CFG:3;
    } B;
  } CFG;

  union {                              /* STCU2 PLL Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t  :2;
      vuint32_t PLLODF:6;
      vuint32_t  :5;
      vuint32_t PLLIDF:3;
      vuint32_t  :9;
      vuint32_t PLLLDF:7;
    } B;
  } PLL_CFG;

  union {                              /* STCU2 Watchdog Register Granularity */
    vuint32_t R;
    struct {
      vuint32_t WDGEOC:32;
    } B;
  } WDG;

  union {                              /* STCU2 Interrupt Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :30;
      vuint32_t MBIFLG:1;
      vuint32_t LBIFLG:1;
    } B;
  } INT_FLG;

  union {                              /* STCU2 CRC Expected Status Register */
    vuint32_t R;
    struct {
      vuint32_t CRCE:32;
    } B;
  } CRCE;

  union {                              /* STCU2 CRC Read Status Register */
    vuint32_t R;
    struct {
      vuint32_t CRCR:32;
    } B;
  } CRCR;

  union {                              /* STCU2 Error Register */
    vuint32_t R;
    struct {
      vuint32_t  :6;
      vuint32_t ABORTHW:1;
      vuint32_t ABORTSW:1;
      vuint32_t  :3;
      vuint32_t LOCKESW:1;
      vuint32_t WDTOSW:1;
      vuint32_t CRCSSW:1;
      vuint32_t ENGESW:1;
      vuint32_t INVPSW:1;
      vuint32_t  :6;
      vuint32_t UFSF:1;
      vuint32_t RFSF:1;
      vuint32_t  :3;
      vuint32_t LOCKE:1;
      vuint32_t WDTO:1;
      vuint32_t CRCS:1;
      vuint32_t ENGE:1;
      vuint32_t INVP:1;
    } B;
  } ERR_STAT;

  union {                              /* STCU2 Error FM Register */
    vuint32_t R;
    struct {
      vuint32_t  :27;
      vuint32_t LOCKEUFM:1;
      vuint32_t WDTOUFM:1;
      vuint32_t CRCSUFM:1;
      vuint32_t ENGEUFM:1;
      vuint32_t INVPUFM:1;
    } B;
  } ERR_FM;

  union {                              /* STCU2 Off-Line LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t LBS9:1;
      vuint32_t LBS8:1;
      vuint32_t LBS7:1;
      vuint32_t LBS6:1;
      vuint32_t LBS5:1;
      vuint32_t LBS4:1;
      vuint32_t LBS3:1;
      vuint32_t LBS2:1;
      vuint32_t LBS1:1;
      vuint32_t LBS0:1;
    } B;
  } LBS;

  union {                              /* STCU2 Off-Line LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t LBE9:1;
      vuint32_t LBE8:1;
      vuint32_t LBE7:1;
      vuint32_t LBE6:1;
      vuint32_t LBE5:1;
      vuint32_t LBE4:1;
      vuint32_t LBE3:1;
      vuint32_t LBE2:1;
      vuint32_t LBE1:1;
      vuint32_t LBE0:1;
    } B;
  } LBE;

  union {                              /* STCU2 On-Line LBIST Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t LBSSW9:1;
      vuint32_t LBSSW8:1;
      vuint32_t LBSSW7:1;
      vuint32_t LBSSW6:1;
      vuint32_t LBSSW5:1;
      vuint32_t LBSSW4:1;
      vuint32_t LBSSW3:1;
      vuint32_t LBSSW2:1;
      vuint32_t LBSSW1:1;
      vuint32_t LBSSW0:1;
    } B;
  } LBSSW;

  union {                              /* STCU2 On-Line LBIST End Flag Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t LBESW9:1;
      vuint32_t LBESW8:1;
      vuint32_t LBESW7:1;
      vuint32_t LBESW6:1;
      vuint32_t LBESW5:1;
      vuint32_t LBESW4:1;
      vuint32_t LBESW3:1;
      vuint32_t LBESW2:1;
      vuint32_t LBESW1:1;
      vuint32_t LBESW0:1;
    } B;
  } LBESW;

  union {                              /* STCU2 On-Line LBIST Reset Management */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t LBRMSW9:1;
      vuint32_t LBRMSW8:1;
      vuint32_t LBRMSW7:1;
      vuint32_t LBRMSW6:1;
      vuint32_t LBRMSW5:1;
      vuint32_t LBRMSW4:1;
      vuint32_t LBRMSW3:1;
      vuint32_t LBRMSW2:1;
      vuint32_t LBRMSW1:1;
      vuint32_t LBRMSW0:1;
    } B;
  } LBRMSW;

  union {                              /* STCU2 LBIST Unrecoverable FM Register */
    vuint32_t R;
    struct {
      vuint32_t  :22;
      vuint32_t LBUFM9:1;
      vuint32_t LBUFM8:1;
      vuint32_t LBUFM7:1;
      vuint32_t LBUFM6:1;
      vuint32_t LBUFM5:1;
      vuint32_t LBUFM4:1;
      vuint32_t LBUFM3:1;
      vuint32_t LBUFM2:1;
      vuint32_t LBUFM1:1;
      vuint32_t LBUFM0:1;
    } B;
  } LBUFM;

  union {                              /* STCU2 Off-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBS31:1;
      vuint32_t MBS30:1;
      vuint32_t MBS29:1;
      vuint32_t MBS28:1;
      vuint32_t MBS27:1;
      vuint32_t MBS26:1;
      vuint32_t MBS25:1;
      vuint32_t MBS24:1;
      vuint32_t MBS23:1;
      vuint32_t MBS22:1;
      vuint32_t MBS21:1;
      vuint32_t MBS20:1;
      vuint32_t MBS19:1;
      vuint32_t MBS18:1;
      vuint32_t MBS17:1;
      vuint32_t MBS16:1;
      vuint32_t MBS15:1;
      vuint32_t MBS14:1;
      vuint32_t MBS13:1;
      vuint32_t MBS12:1;
      vuint32_t MBS11:1;
      vuint32_t MBS10:1;
      vuint32_t MBS9:1;
      vuint32_t MBS8:1;
      vuint32_t MBS7:1;
      vuint32_t MBS6:1;
      vuint32_t MBS5:1;
      vuint32_t MBS4:1;
      vuint32_t MBS3:1;
      vuint32_t MBS2:1;
      vuint32_t MBS1:1;
      vuint32_t MBS0:1;
    } B;
  } MBSL;

  union {                              /* STCU2 Off-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBS63:1;
      vuint32_t MBS62:1;
      vuint32_t MBS61:1;
      vuint32_t MBS60:1;
      vuint32_t MBS59:1;
      vuint32_t MBS58:1;
      vuint32_t MBS57:1;
      vuint32_t MBS56:1;
      vuint32_t MBS55:1;
      vuint32_t MBS54:1;
      vuint32_t MBS53:1;
      vuint32_t MBS52:1;
      vuint32_t MBS51:1;
      vuint32_t MBS50:1;
      vuint32_t MBS49:1;
      vuint32_t MBS48:1;
      vuint32_t MBS47:1;
      vuint32_t MBS46:1;
      vuint32_t MBS45:1;
      vuint32_t MBS44:1;
      vuint32_t MBS43:1;
      vuint32_t MBS42:1;
      vuint32_t MBS41:1;
      vuint32_t MBS40:1;
      vuint32_t MBS39:1;
      vuint32_t MBS38:1;
      vuint32_t MBS37:1;
      vuint32_t MBS36:1;
      vuint32_t MBS35:1;
      vuint32_t MBS34:1;
      vuint32_t MBS33:1;
      vuint32_t MBS32:1;
    } B;
  } MBSM;

  union {                              /* STCU2 Off-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t MBS77:1;
      vuint32_t MBS76:1;
      vuint32_t MBS75:1;
      vuint32_t MBS74:1;
      vuint32_t MBS73:1;
      vuint32_t MBS72:1;
      vuint32_t MBS71:1;
      vuint32_t MBS70:1;
      vuint32_t MBS69:1;
      vuint32_t MBS68:1;
      vuint32_t MBS67:1;
      vuint32_t MBS66:1;
      vuint32_t MBS65:1;
      vuint32_t MBS64:1;
    } B;
  } MBSH;

  union {                              /* STCU2 Off-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBE31:1;
      vuint32_t MBE30:1;
      vuint32_t MBE29:1;
      vuint32_t MBE28:1;
      vuint32_t MBE27:1;
      vuint32_t MBE26:1;
      vuint32_t MBE25:1;
      vuint32_t MBE24:1;
      vuint32_t MBE23:1;
      vuint32_t MBE22:1;
      vuint32_t MBE21:1;
      vuint32_t MBE20:1;
      vuint32_t MBE19:1;
      vuint32_t MBE18:1;
      vuint32_t MBE17:1;
      vuint32_t MBE16:1;
      vuint32_t MBE15:1;
      vuint32_t MBE14:1;
      vuint32_t MBE13:1;
      vuint32_t MBE12:1;
      vuint32_t MBE11:1;
      vuint32_t MBE10:1;
      vuint32_t MBE9:1;
      vuint32_t MBE8:1;
      vuint32_t MBE7:1;
      vuint32_t MBE6:1;
      vuint32_t MBE5:1;
      vuint32_t MBE4:1;
      vuint32_t MBE3:1;
      vuint32_t MBE2:1;
      vuint32_t MBE1:1;
      vuint32_t MBE0:1;
    } B;
  } MBEL;

  union {                              /* STCU2 Off-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBE63:1;
      vuint32_t MBE62:1;
      vuint32_t MBE61:1;
      vuint32_t MBE60:1;
      vuint32_t MBE59:1;
      vuint32_t MBE58:1;
      vuint32_t MBE57:1;
      vuint32_t MBE56:1;
      vuint32_t MBE55:1;
      vuint32_t MBE54:1;
      vuint32_t MBE53:1;
      vuint32_t MBE52:1;
      vuint32_t MBE51:1;
      vuint32_t MBE50:1;
      vuint32_t MBE49:1;
      vuint32_t MBE48:1;
      vuint32_t MBE47:1;
      vuint32_t MBE46:1;
      vuint32_t MBE45:1;
      vuint32_t MBE44:1;
      vuint32_t MBE43:1;
      vuint32_t MBE42:1;
      vuint32_t MBE41:1;
      vuint32_t MBE40:1;
      vuint32_t MBE39:1;
      vuint32_t MBE38:1;
      vuint32_t MBE37:1;
      vuint32_t MBE36:1;
      vuint32_t MBE35:1;
      vuint32_t MBE34:1;
      vuint32_t MBE33:1;
      vuint32_t MBE32:1;
    } B;
  } MBEM;

  union {                              /* STCU2 Off-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t MBE77:1;
      vuint32_t MBE76:1;
      vuint32_t MBE75:1;
      vuint32_t MBE74:1;
      vuint32_t MBE73:1;
      vuint32_t MBE72:1;
      vuint32_t MBE71:1;
      vuint32_t MBE70:1;
      vuint32_t MBE69:1;
      vuint32_t MBE68:1;
      vuint32_t MBE67:1;
      vuint32_t MBE66:1;
      vuint32_t MBE65:1;
      vuint32_t MBE64:1;
    } B;
  } MBEH;

  union {                              /* STCU2 On-Line MBIST Status Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW31:1;
      vuint32_t MBSSW30:1;
      vuint32_t MBSSW29:1;
      vuint32_t MBSSW28:1;
      vuint32_t MBSSW27:1;
      vuint32_t MBSSW26:1;
      vuint32_t MBSSW25:1;
      vuint32_t MBSSW24:1;
      vuint32_t MBSSW23:1;
      vuint32_t MBSSW22:1;
      vuint32_t MBSSW21:1;
      vuint32_t MBSSW20:1;
      vuint32_t MBSSW19:1;
      vuint32_t MBSSW18:1;
      vuint32_t MBSSW17:1;
      vuint32_t MBSSW16:1;
      vuint32_t MBSSW15:1;
      vuint32_t MBSSW14:1;
      vuint32_t MBSSW13:1;
      vuint32_t MBSSW12:1;
      vuint32_t MBSSW11:1;
      vuint32_t MBSSW10:1;
      vuint32_t MBSSW9:1;
      vuint32_t MBSSW8:1;
      vuint32_t MBSSW7:1;
      vuint32_t MBSSW6:1;
      vuint32_t MBSSW5:1;
      vuint32_t MBSSW4:1;
      vuint32_t MBSSW3:1;
      vuint32_t MBSSW2:1;
      vuint32_t MBSSW1:1;
      vuint32_t MBSSW0:1;
    } B;
  } MBSLSW;

  union {                              /* STCU2 On-Line MBIST Status Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBSSW63:1;
      vuint32_t MBSSW62:1;
      vuint32_t MBSSW61:1;
      vuint32_t MBSSW60:1;
      vuint32_t MBSSW59:1;
      vuint32_t MBSSW58:1;
      vuint32_t MBSSW57:1;
      vuint32_t MBSSW56:1;
      vuint32_t MBSSW55:1;
      vuint32_t MBSSW54:1;
      vuint32_t MBSSW53:1;
      vuint32_t MBSSW52:1;
      vuint32_t MBSSW51:1;
      vuint32_t MBSSW50:1;
      vuint32_t MBSSW49:1;
      vuint32_t MBSSW48:1;
      vuint32_t MBSSW47:1;
      vuint32_t MBSSW46:1;
      vuint32_t MBSSW45:1;
      vuint32_t MBSSW44:1;
      vuint32_t MBSSW43:1;
      vuint32_t MBSSW42:1;
      vuint32_t MBSSW41:1;
      vuint32_t MBSSW40:1;
      vuint32_t MBSSW39:1;
      vuint32_t MBSSW38:1;
      vuint32_t MBSSW37:1;
      vuint32_t MBSSW36:1;
      vuint32_t MBSSW35:1;
      vuint32_t MBSSW34:1;
      vuint32_t MBSSW33:1;
      vuint32_t MBSSW32:1;
    } B;
  } MBSMSW;

  union {                              /* STCU2 On-Line MBIST Status High Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t MBSSW77:1;
      vuint32_t MBSSW76:1;
      vuint32_t MBSSW75:1;
      vuint32_t MBSSW74:1;
      vuint32_t MBSSW73:1;
      vuint32_t MBSSW72:1;
      vuint32_t MBSSW71:1;
      vuint32_t MBSSW70:1;
      vuint32_t MBSSW69:1;
      vuint32_t MBSSW68:1;
      vuint32_t MBSSW67:1;
      vuint32_t MBSSW66:1;
      vuint32_t MBSSW65:1;
      vuint32_t MBSSW64:1;
    } B;
  } MBSHSW;

  union {                              /* STCU2 On-Line MBIST End Flag Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW31:1;
      vuint32_t MBESW30:1;
      vuint32_t MBESW29:1;
      vuint32_t MBESW28:1;
      vuint32_t MBESW27:1;
      vuint32_t MBESW26:1;
      vuint32_t MBESW25:1;
      vuint32_t MBESW24:1;
      vuint32_t MBESW23:1;
      vuint32_t MBESW22:1;
      vuint32_t MBESW21:1;
      vuint32_t MBESW20:1;
      vuint32_t MBESW19:1;
      vuint32_t MBESW18:1;
      vuint32_t MBESW17:1;
      vuint32_t MBESW16:1;
      vuint32_t MBESW15:1;
      vuint32_t MBESW14:1;
      vuint32_t MBESW13:1;
      vuint32_t MBESW12:1;
      vuint32_t MBESW11:1;
      vuint32_t MBESW10:1;
      vuint32_t MBESW9:1;
      vuint32_t MBESW8:1;
      vuint32_t MBESW7:1;
      vuint32_t MBESW6:1;
      vuint32_t MBESW5:1;
      vuint32_t MBESW4:1;
      vuint32_t MBESW3:1;
      vuint32_t MBESW2:1;
      vuint32_t MBESW1:1;
      vuint32_t MBESW0:1;
    } B;
  } MBELSW;

  union {                              /* STCU2 On-Line MBIST End Flag Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBESW63:1;
      vuint32_t MBESW62:1;
      vuint32_t MBESW61:1;
      vuint32_t MBESW60:1;
      vuint32_t MBESW59:1;
      vuint32_t MBESW58:1;
      vuint32_t MBESW57:1;
      vuint32_t MBESW56:1;
      vuint32_t MBESW55:1;
      vuint32_t MBESW54:1;
      vuint32_t MBESW53:1;
      vuint32_t MBESW52:1;
      vuint32_t MBESW51:1;
      vuint32_t MBESW50:1;
      vuint32_t MBESW49:1;
      vuint32_t MBESW48:1;
      vuint32_t MBESW47:1;
      vuint32_t MBESW46:1;
      vuint32_t MBESW45:1;
      vuint32_t MBESW44:1;
      vuint32_t MBESW43:1;
      vuint32_t MBESW42:1;
      vuint32_t MBESW41:1;
      vuint32_t MBESW40:1;
      vuint32_t MBESW39:1;
      vuint32_t MBESW38:1;
      vuint32_t MBESW37:1;
      vuint32_t MBESW36:1;
      vuint32_t MBESW35:1;
      vuint32_t MBESW34:1;
      vuint32_t MBESW33:1;
      vuint32_t MBESW32:1;
    } B;
  } MBEMSW;

  union {                              /* STCU2 On-Line MBIST End Flag High Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t MBESW77:1;
      vuint32_t MBESW76:1;
      vuint32_t MBESW75:1;
      vuint32_t MBESW74:1;
      vuint32_t MBESW73:1;
      vuint32_t MBESW72:1;
      vuint32_t MBESW71:1;
      vuint32_t MBESW70:1;
      vuint32_t MBESW69:1;
      vuint32_t MBESW68:1;
      vuint32_t MBESW67:1;
      vuint32_t MBESW66:1;
      vuint32_t MBESW65:1;
      vuint32_t MBESW64:1;
    } B;
  } MBEHSW;

  union {                              /* STCU2 MBIST Unrecoverable FM Low Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM31:1;
      vuint32_t MBUFM30:1;
      vuint32_t MBUFM29:1;
      vuint32_t MBUFM28:1;
      vuint32_t MBUFM27:1;
      vuint32_t MBUFM26:1;
      vuint32_t MBUFM25:1;
      vuint32_t MBUFM24:1;
      vuint32_t MBUFM23:1;
      vuint32_t MBUFM22:1;
      vuint32_t MBUFM21:1;
      vuint32_t MBUFM20:1;
      vuint32_t MBUFM19:1;
      vuint32_t MBUFM18:1;
      vuint32_t MBUFM17:1;
      vuint32_t MBUFM16:1;
      vuint32_t MBUFM15:1;
      vuint32_t MBUFM14:1;
      vuint32_t MBUFM13:1;
      vuint32_t MBUFM12:1;
      vuint32_t MBUFM11:1;
      vuint32_t MBUFM10:1;
      vuint32_t MBUFM9:1;
      vuint32_t MBUFM8:1;
      vuint32_t MBUFM7:1;
      vuint32_t MBUFM6:1;
      vuint32_t MBUFM5:1;
      vuint32_t MBUFM4:1;
      vuint32_t MBUFM3:1;
      vuint32_t MBUFM2:1;
      vuint32_t MBUFM1:1;
      vuint32_t MBUFM0:1;
    } B;
  } MBUFML;

  union {                              /* STCU2 MBIST Unrecoverable FM Medium Register */
    vuint32_t R;
    struct {
      vuint32_t MBUFM63:1;
      vuint32_t MBUFM62:1;
      vuint32_t MBUFM61:1;
      vuint32_t MBUFM60:1;
      vuint32_t MBUFM59:1;
      vuint32_t MBUFM58:1;
      vuint32_t MBUFM57:1;
      vuint32_t MBUFM56:1;
      vuint32_t MBUFM55:1;
      vuint32_t MBUFM54:1;
      vuint32_t MBUFM53:1;
      vuint32_t MBUFM52:1;
      vuint32_t MBUFM51:1;
      vuint32_t MBUFM50:1;
      vuint32_t MBUFM49:1;
      vuint32_t MBUFM48:1;
      vuint32_t MBUFM47:1;
      vuint32_t MBUFM46:1;
      vuint32_t MBUFM45:1;
      vuint32_t MBUFM44:1;
      vuint32_t MBUFM43:1;
      vuint32_t MBUFM42:1;
      vuint32_t MBUFM41:1;
      vuint32_t MBUFM40:1;
      vuint32_t MBUFM39:1;
      vuint32_t MBUFM38:1;
      vuint32_t MBUFM37:1;
      vuint32_t MBUFM36:1;
      vuint32_t MBUFM35:1;
      vuint32_t MBUFM34:1;
      vuint32_t MBUFM33:1;
      vuint32_t MBUFM32:1;
    } B;
  } MBUFMM;

  union {                              /* STCU2 MBIST Unrecoverable FM High Register */
    vuint32_t R;
    struct {
      vuint32_t  :18;
      vuint32_t MBUFM77:1;
      vuint32_t MBUFM76:1;
      vuint32_t MBUFM75:1;
      vuint32_t MBUFM74:1;
      vuint32_t MBUFM73:1;
      vuint32_t MBUFM72:1;
      vuint32_t MBUFM71:1;
      vuint32_t MBUFM70:1;
      vuint32_t MBUFM69:1;
      vuint32_t MBUFM68:1;
      vuint32_t MBUFM67:1;
      vuint32_t MBUFM66:1;
      vuint32_t MBUFM65:1;
      vuint32_t MBUFM64:1;
    } B;
  } MBUFMH;

  uint8_t STCU2_reserved0[128];
  struct {
    union {                            /* STCU2 LBIST Control Register */
      vuint32_t R;
      struct {
        vuint32_t CSM:1;
        vuint32_t PTR:7;
        vuint32_t  :4;
        vuint32_t PRPGEN:1;
        vuint32_t SHS:3;
        vuint32_t SCEN_OFF:4;
        vuint32_t SCEN_ON:4;
        vuint32_t  :4;
        vuint32_t PFT:1;
        vuint32_t CWS:3;
      } B;
    } LB_CTRL;
    union {                            /* STCU2 LBIST PC Stop Register */
      vuint32_t R;
      struct {
        vuint32_t  :6;
        vuint32_t PCS:26;
      } B;
    } LB_PCS;
    union {                            /* STCU2 LBIST PRPG Low Register */
      vuint32_t R;
      struct {
        vuint32_t PRPGx:32;
      } B;
    } LB_PRPGL;
    union {                            /* STCU2 LBIST PRPG High Register */
      vuint32_t R;
      struct {
        vuint32_t PRPGx:32;
      } B;
    } LB_PRPGH;
    union {                            /* STCU2 Off-Line LBIST MISR Expected Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISREx:32;
      } B;
    } LB_MISREL;
    union {                            /* STCU2 Off-Line LBIST MISR Expected High Register */
      vuint32_t R;
      struct {
        vuint32_t MISREx:32;
      } B;
    } LB_MISREH;
    union {                            /* STCU2 Off-Line LBIST MISR Read Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRx:32;
      } B;
    } LB_MISRRL;
    union {                            /* STCU2 Off-Line LBIST MISR Read High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRx:32;
      } B;
    } LB_MISRRH;
    union {                            /* STCU2 On-Line LBIST MISR Expected Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } LB_MISRELSW;
    union {                            /* STCU2 On-Line LBIST MISR Expected High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRESWx:32;
      } B;
    } LB_MISREHSW;
    union {                            /* STCU2 On-Line LBIST MISR Read Low Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;
      } B;
    } LB_MISRRLSW;
    union {                            /* STCU2 On-Line LBIST MISR Read High Register */
      vuint32_t R;
      struct {
        vuint32_t MISRRSWx:32;
      } B;
    } LB_MISRRHSW;
    uint8_t LB_reserved0[16];
  } LB[10];

  uint8_t STCU2_reserved1[640];
  union {                              /* STCU2 MBIST Control Register */
    vuint32_t R;
    struct {
      vuint32_t CSM:1;
      vuint32_t PTR:7;
      vuint32_t  :24;
    } B;
  } MB_CTRL[78];
};


/* ============================================================================
   =============================== Module: STM ================================
   ============================================================================ */

struct STM_tag {
  union {                              /* STM Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t CPS:8;                 /* Counter Prescaler. */
      vuint32_t  :6;
      vuint32_t FRZ:1;                 /* Freeze. */
      vuint32_t TEN:1;                 /* Timer counter Enabled. */
    } B;
  } CR;

  union {                              /* STM Count Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;                /* Timer count value used as the time base for all channels. */
    } B;
  } CNT;

  uint8_t STM_reserved0[8];
  struct {
    union {                            /* STM Channel Control Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CEN:1;               /* Channel Enable */
      } B;
    } CCR;
    union {                            /* STM Channel Interrupt Register */
      vuint32_t R;
      struct {
        vuint32_t  :31;
        vuint32_t CIF:1;               /* Channel Interrupt Flag */
      } B;
    } CIR;
    union {                            /* STM Channel Compare Register */
      vuint32_t R;
      struct {
        vuint32_t CMP:32;              /* Compare value for channel n. */
      } B;
    } CMP;
    uint8_t CHANNEL_reserved0[4];
  } CHANNEL[4];
};


/* ============================================================================
   =============================== Module: SWT ================================
   ============================================================================ */

struct SWT_tag {
  union {                              /* SWT Control Register */
    vuint32_t R;
    struct {
      vuint32_t MAP0:1;
      vuint32_t MAP1:1;
      vuint32_t MAP2:1;
      vuint32_t MAP3:1;
      vuint32_t MAP4:1;
      vuint32_t MAP5:1;
      vuint32_t MAP6:1;
      vuint32_t MAP7:1;
      vuint32_t  :13;
      vuint32_t SMD:2;                 /* Service Mode. */
      vuint32_t RIA:1;
      vuint32_t WND:1;
      vuint32_t ITR:1;
      vuint32_t HLK:1;
      vuint32_t SLK:1;
      vuint32_t  :1;                   /* Reserved. */
      vuint32_t STP:1;
      vuint32_t FRZ:1;
      vuint32_t WEN:1;
    } B;
  } CR;

  union {                              /* SWT Interrupt Register */
    vuint32_t R;
    struct {
      vuint32_t  :31;
      vuint32_t TIF:1;
    } B;
  } IR;

  union {                              /* SWT Time-out Register */
    vuint32_t R;
    struct {
      vuint32_t WTO:32;
    } B;
  } TO;

  union {                              /* SWT Window Register */
    vuint32_t R;
    struct {
      vuint32_t WST:32;
    } B;
  } WN;

  union {                              /* SWT Service Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t WSC:16;
    } B;
  } SR;

  union {                              /* SWT Counter Output Register */
    vuint32_t R;
    struct {
      vuint32_t CNT:32;
    } B;
  } CO;

  union {                              /* SWT Service Key Register */
    vuint32_t R;
    struct {
      vuint32_t  :16;
      vuint32_t SK:16;                 /* Service Key. */
    } B;
  } SK;
};


/* ============================================================================
   =============================== Module: TDM ================================
   ============================================================================ */

struct TDM_tag {
  union {                              /* TDR Status Register */
    vuint32_t R;
    struct {
      vuint32_t  :26;
      vuint32_t TDRSR5:1;
      vuint32_t TDRSR4:1;
      vuint32_t TDRSR3:1;
      vuint32_t TDRSR2:1;
      vuint32_t TDRSR1:1;
      vuint32_t TDRSR0:1;
    } B;
  } TDRSR;

  union {                              /* Last Flash Programmed Address Register */
    vuint32_t R;
    struct {
      vuint32_t  :8;
      vuint32_t LFPAR:24;
    } B;
  } LFPAR;

  union {                              /* Diary Base Address */
    vuint32_t R;
    struct {
      vuint32_t DBA:32;
    } B;
  } DBA;

  uint8_t TDM_reserved0[4];
  union {                              /* Software Tamper Override Key Region */
    vuint32_t R;
    struct {
      vuint32_t STO_KEY:32;
    } B;
  } STO_KEY[6];
};


/* ============================================================================
   =============================== Module: WKPU ===============================
   ============================================================================ */

struct WKPU_tag {
  union {                              /* NMI Status Flag Register */
    vuint32_t R;
    struct {
      vuint32_t NIF0:1;                /* NMI Status Flag 0 (safety core) */
      vuint32_t NOVF0:1;               /* NMI Overrun Status Flag 0 (safety core) */
      vuint32_t  :6;
      vuint32_t NIF1:1;                /* NMI Status Flag 1 (main core) */
      vuint32_t NOVF1:1;               /* NMI Overrun Status Flag 1 (main core) */
      vuint32_t  :6;
      vuint32_t NIF2:1;                /* NMI Status Flag 2 (IOP) */
      vuint32_t NOVF2:1;               /* NMI Overrun Status Flag 2 (IOP) */
      vuint32_t  :6;
      vuint32_t RIF:1;                 /* Reset Status Flag */
      vuint32_t ROVF:1;                /* Reset Overrun Status Flag */
      vuint32_t  :6;
    } B;
  } NSR;

  uint8_t WKPU_reserved0[4];
  union {                              /* NMI Configuration Register */
    vuint32_t R;
    struct {
      vuint32_t NLOCK0:1;              /* NMI Configuration Lock Register 0 */
      vuint32_t NDSS0:2;               /* NMI Destination Source Select 0 */
      vuint32_t NWRE0:1;               /* NMI Wakeup Request Enable 0 */
      vuint32_t  :1;
      vuint32_t NREE0:1;               /* NMI Rising-edge Events Enable 0 */
      vuint32_t NFEE0:1;               /* NMI Falling-edge Events Enable 0 */
      vuint32_t NFE0:1;                /* NMI Filter Enable */
      vuint32_t NLOCK1:1;              /* NMI Configuration Lock Register 1 */
      vuint32_t NDSS1:2;               /* NMI Destination Source Select 1 */
      vuint32_t NWRE1:1;               /* NMI Wakeup Request Enable 1 */
      vuint32_t  :1;
      vuint32_t NREE1:1;               /* NMI Rising-edge Events Enable 1 */
      vuint32_t NFEE1:1;               /* NMI Falling-edge Events Enable 1 */
      vuint32_t  :1;
      vuint32_t NLOCK2:1;              /* NMI Configuration Lock Register 2 */
      vuint32_t NDSS2:2;               /* NMI Destination Source Select 2 */
      vuint32_t NWRE2:1;               /* NMI Wakeup Request Enable 2 */
      vuint32_t  :1;
      vuint32_t NREE2:1;               /* NMI Rising-edge Events Enable 2 */
      vuint32_t NFEE2:1;               /* NMI Falling-edge Events Enable 2 */
      vuint32_t  :1;
      vuint32_t RLOCK:1;               /* Reset Configuration Lock Register */
      vuint32_t RDSS:2;                /* Reset Destination Source Select */
      vuint32_t RWRE:1;                /* Reset Wakeup Request Enable */
      vuint32_t  :1;
      vuint32_t RREE:1;                /* Reset Rising-edge Events Enable */
      vuint32_t RFEE:1;                /* Reset Falling-edge Events Enable */
      vuint32_t  :1;
    } B;
  } NCR;
};


/* ============================================================================
   =============================== Module: XBAR ===============================
   ============================================================================ */

struct XBAR_tag {
  struct {
    union {                            /* XBAR Priority Registers Slave */
      vuint32_t R;
      struct {
        vuint32_t  :1;
        vuint32_t M7:3;
        vuint32_t  :1;
        vuint32_t M6:3;
        vuint32_t  :1;
        vuint32_t M5:3;
        vuint32_t  :1;
        vuint32_t M4:3;
        vuint32_t  :1;
        vuint32_t M3:3;
        vuint32_t  :1;
        vuint32_t M2:3;
        vuint32_t  :1;
        vuint32_t M1:3;
        vuint32_t  :1;
        vuint32_t M0:3;
      } B;
    } PRS;
    uint8_t PORT_reserved0[12];
    union {                            /* XBAR Control Register */
      vuint32_t R;
      struct {
        vuint32_t RO:1;
        vuint32_t HRP:1;
        vuint32_t  :6;
        vuint32_t HPEx:8;              /* High Priority Enable */
        vuint32_t  :6;
        vuint32_t ARB:2;
        vuint32_t  :2;
        vuint32_t PCTL:2;
        vuint32_t  :1;
        vuint32_t PARK:3;
      } B;
    } CRS;
    uint8_t PORT_reserved1[236];
  } PORT[8];
};


/* ============================================================================
   =============================== Module: XBIC ===============================
   ============================================================================ */

struct XBIC_tag {
  union {                              /* XBIC Module Control Register */
    vuint32_t R;
    struct {
      vuint32_t SE0:1;
      vuint32_t SE1:1;
      vuint32_t SE2:1;
      vuint32_t SE3:1;
      vuint32_t SE4:1;
      vuint32_t SE5:1;
      vuint32_t SE6:1;
      vuint32_t SE7:1;
      vuint32_t ME0:1;
      vuint32_t ME1:1;
      vuint32_t ME2:1;
      vuint32_t ME3:1;
      vuint32_t ME4:1;
      vuint32_t ME5:1;
      vuint32_t ME6:1;
      vuint32_t ME7:1;
      vuint32_t  :16;
    } B;
  } MCR;

  union {                              /* XBIC Error Injection Register */
    vuint32_t R;
    struct {
      vuint32_t EIE:1;
      vuint32_t  :16;
      vuint32_t SLV:3;
      vuint32_t MST:4;
      vuint32_t SYN:8;
    } B;
  } EIR;

  union {                              /* XBIC Error Status Register */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t DPSE0:1;
      vuint32_t DPSE1:1;
      vuint32_t DPSE2:1;
      vuint32_t DPSE3:1;
      vuint32_t DPSE4:1;
      vuint32_t DPSE5:1;
      vuint32_t DPSE6:1;
      vuint32_t DPSE7:1;
      vuint32_t DPME0:1;
      vuint32_t DPME1:1;
      vuint32_t DPME2:1;
      vuint32_t DPME3:1;
      vuint32_t DPME4:1;
      vuint32_t DPME5:1;
      vuint32_t DPME6:1;
      vuint32_t DPME7:1;
      vuint32_t SLV:3;
      vuint32_t MST:4;
      vuint32_t SYN:8;
    } B;
  } ESR;

  union {                              /* XBIC Error Address Register */
    vuint32_t R;
    struct {
      vuint32_t ADDR:32;
    } B;
  } EAR;
};


/* ============================================================================
   =============================== Module: XOSC ===============================
   ============================================================================ */

struct XOSC_tag {
  union {                              /* XOSC Control Register */
    vuint32_t R;
    struct {
      vuint32_t OSCBYP:1;
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t EOCV:8;                /* End of Count Value */
      vuint32_t M_OSC:1;               /* Crystal oscillator clock interrupt mask */
      vuint32_t  :2;
      vuint32_t  :5;
      vuint32_t I_OSC:1;
      vuint32_t  :5;
      vuint32_t  :1;
      vuint32_t  :1;
    } B;
  } CTL;
};


/* ============================================================================
   =============================== Module: eDMA ===============================
   ============================================================================ */

struct eDMA_tag {
  union {                              /* Control Register */
    vuint32_t R;
    struct {
      vuint32_t  :14;
      vuint32_t CX:1;
      vuint32_t ECX:1;
      vuint32_t GRP3PRI:2;
      vuint32_t GRP2PRI:2;
      vuint32_t GRP1PRI:2;
      vuint32_t GRP0PRI:2;
      vuint32_t EMLM:1;
      vuint32_t CLM:1;
      vuint32_t HALT:1;
      vuint32_t HOE:1;
      vuint32_t ERGA:1;
      vuint32_t ERCA:1;
      vuint32_t EDBG:1;
      vuint32_t  :1;
    } B;
  } CR;

  union {                              /* Error Status */
    vuint32_t R;
    struct {
      vuint32_t VLD:1;
      vuint32_t  :13;
      vuint32_t UCE:1;
      vuint32_t ECX:1;
      vuint32_t GPE:1;
      vuint32_t CPE:1;
      vuint32_t ERRCHN:6;
      vuint32_t SAE:1;
      vuint32_t SOE:1;
      vuint32_t DAE:1;
      vuint32_t DOE:1;
      vuint32_t NCE:1;
      vuint32_t SGE:1;
      vuint32_t SBE:1;
      vuint32_t DBE:1;
    } B;
  } ES;

  union {                              /* Enable Request Register High */
    vuint32_t R;
    struct {
      vuint32_t ERQ63:1;
      vuint32_t ERQ62:1;
      vuint32_t ERQ61:1;
      vuint32_t ERQ60:1;
      vuint32_t ERQ59:1;
      vuint32_t ERQ58:1;
      vuint32_t ERQ57:1;
      vuint32_t ERQ56:1;
      vuint32_t ERQ55:1;
      vuint32_t ERQ54:1;
      vuint32_t ERQ53:1;
      vuint32_t ERQ52:1;
      vuint32_t ERQ51:1;
      vuint32_t ERQ50:1;
      vuint32_t ERQ49:1;
      vuint32_t ERQ48:1;
      vuint32_t ERQ47:1;
      vuint32_t ERQ46:1;
      vuint32_t ERQ45:1;
      vuint32_t ERQ44:1;
      vuint32_t ERQ43:1;
      vuint32_t ERQ42:1;
      vuint32_t ERQ41:1;
      vuint32_t ERQ40:1;
      vuint32_t ERQ39:1;
      vuint32_t ERQ38:1;
      vuint32_t ERQ37:1;
      vuint32_t ERQ36:1;
      vuint32_t ERQ35:1;
      vuint32_t ERQ34:1;
      vuint32_t ERQ33:1;
      vuint32_t ERQ32:1;
    } B;
  } ERQH;

  union {                              /* Enable Request Register Low */
    vuint32_t R;
    struct {
      vuint32_t ERQ31:1;
      vuint32_t ERQ30:1;
      vuint32_t ERQ29:1;
      vuint32_t ERQ28:1;
      vuint32_t ERQ27:1;
      vuint32_t ERQ26:1;
      vuint32_t ERQ25:1;
      vuint32_t ERQ24:1;
      vuint32_t ERQ23:1;
      vuint32_t ERQ22:1;
      vuint32_t ERQ21:1;
      vuint32_t ERQ20:1;
      vuint32_t ERQ19:1;
      vuint32_t ERQ18:1;
      vuint32_t ERQ17:1;
      vuint32_t ERQ16:1;
      vuint32_t ERQ15:1;
      vuint32_t ERQ14:1;
      vuint32_t ERQ13:1;
      vuint32_t ERQ12:1;
      vuint32_t ERQ11:1;
      vuint32_t ERQ10:1;
      vuint32_t ERQ9:1;
      vuint32_t ERQ8:1;
      vuint32_t ERQ7:1;
      vuint32_t ERQ6:1;
      vuint32_t ERQ5:1;
      vuint32_t ERQ4:1;
      vuint32_t ERQ3:1;
      vuint32_t ERQ2:1;
      vuint32_t ERQ1:1;
      vuint32_t ERQ0:1;
    } B;
  } ERQL;

  union {                              /* Enable Error Interrupt Register High */
    vuint32_t R;
    struct {
      vuint32_t EEI63:1;
      vuint32_t EEI62:1;
      vuint32_t EEI61:1;
      vuint32_t EEI60:1;
      vuint32_t EEI59:1;
      vuint32_t EEI58:1;
      vuint32_t EEI57:1;
      vuint32_t EEI56:1;
      vuint32_t EEI55:1;
      vuint32_t EEI54:1;
      vuint32_t EEI53:1;
      vuint32_t EEI52:1;
      vuint32_t EEI51:1;
      vuint32_t EEI50:1;
      vuint32_t EEI49:1;
      vuint32_t EEI48:1;
      vuint32_t EEI47:1;
      vuint32_t EEI46:1;
      vuint32_t EEI45:1;
      vuint32_t EEI44:1;
      vuint32_t EEI43:1;
      vuint32_t EEI42:1;
      vuint32_t EEI41:1;
      vuint32_t EEI40:1;
      vuint32_t EEI39:1;
      vuint32_t EEI38:1;
      vuint32_t EEI37:1;
      vuint32_t EEI36:1;
      vuint32_t EEI35:1;
      vuint32_t EEI34:1;
      vuint32_t EEI33:1;
      vuint32_t EEI32:1;
    } B;
  } EEIH;

  union {                              /* Enable Error Interrupt Register Low */
    vuint32_t R;
    struct {
      vuint32_t EEI31:1;
      vuint32_t EEI30:1;
      vuint32_t EEI29:1;
      vuint32_t EEI28:1;
      vuint32_t EEI27:1;
      vuint32_t EEI26:1;
      vuint32_t EEI25:1;
      vuint32_t EEI24:1;
      vuint32_t EEI23:1;
      vuint32_t EEI22:1;
      vuint32_t EEI21:1;
      vuint32_t EEI20:1;
      vuint32_t EEI19:1;
      vuint32_t EEI18:1;
      vuint32_t EEI17:1;
      vuint32_t EEI16:1;
      vuint32_t EEI15:1;
      vuint32_t EEI14:1;
      vuint32_t EEI13:1;
      vuint32_t EEI12:1;
      vuint32_t EEI11:1;
      vuint32_t EEI10:1;
      vuint32_t EEI9:1;
      vuint32_t EEI8:1;
      vuint32_t EEI7:1;
      vuint32_t EEI6:1;
      vuint32_t EEI5:1;
      vuint32_t EEI4:1;
      vuint32_t EEI3:1;
      vuint32_t EEI2:1;
      vuint32_t EEI1:1;
      vuint32_t EEI0:1;
    } B;
  } EEIL;

  union {                              /* Set Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t SAER:1;
      vuint8_t SERQ:6;
    } B;
  } SERQ;

  union {                              /* Clear Enable Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t CAER:1;
      vuint8_t CERQ:6;
    } B;
  } CERQ;

  union {                              /* Set Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t SAEE:1;
      vuint8_t SEEI:6;
    } B;
  } SEEI;

  union {                              /* Clear Enable Error Interrupt Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t CAEE:1;
      vuint8_t CEEI:6;
    } B;
  } CEEI;

  union {                              /* Clear Interrupt Request Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t CAIR:1;
      vuint8_t CINT:6;
    } B;
  } CINT;

  union {                              /* Clear Error Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t CAEI:1;
      vuint8_t CERR:6;
    } B;
  } CERR;

  union {                              /* Set START Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t SAST:1;
      vuint8_t SSRT:6;
    } B;
  } SSRT;

  union {                              /* Clear DONE Status Bit Register */
    vuint8_t R;
    struct {
      vuint8_t NOP:1;
      vuint8_t CADN:1;
      vuint8_t CDNE:6;
    } B;
  } CDNE;

  union {                              /* Interrupt Request Register High */
    vuint32_t R;
    struct {
      vuint32_t INT63:1;
      vuint32_t INT62:1;
      vuint32_t INT61:1;
      vuint32_t INT60:1;
      vuint32_t INT59:1;
      vuint32_t INT58:1;
      vuint32_t INT57:1;
      vuint32_t INT56:1;
      vuint32_t INT55:1;
      vuint32_t INT54:1;
      vuint32_t INT53:1;
      vuint32_t INT52:1;
      vuint32_t INT51:1;
      vuint32_t INT50:1;
      vuint32_t INT49:1;
      vuint32_t INT48:1;
      vuint32_t INT47:1;
      vuint32_t INT46:1;
      vuint32_t INT45:1;
      vuint32_t INT44:1;
      vuint32_t INT43:1;
      vuint32_t INT42:1;
      vuint32_t INT41:1;
      vuint32_t INT40:1;
      vuint32_t INT39:1;
      vuint32_t INT38:1;
      vuint32_t INT37:1;
      vuint32_t INT36:1;
      vuint32_t INT35:1;
      vuint32_t INT34:1;
      vuint32_t INT33:1;
      vuint32_t INT32:1;
    } B;
  } INTH;

  union {                              /* Interrupt Request Register Low */
    vuint32_t R;
    struct {
      vuint32_t INT31:1;
      vuint32_t INT30:1;
      vuint32_t INT29:1;
      vuint32_t INT28:1;
      vuint32_t INT27:1;
      vuint32_t INT26:1;
      vuint32_t INT25:1;
      vuint32_t INT24:1;
      vuint32_t INT23:1;
      vuint32_t INT22:1;
      vuint32_t INT21:1;
      vuint32_t INT20:1;
      vuint32_t INT19:1;
      vuint32_t INT18:1;
      vuint32_t INT17:1;
      vuint32_t INT16:1;
      vuint32_t INT15:1;
      vuint32_t INT14:1;
      vuint32_t INT13:1;
      vuint32_t INT12:1;
      vuint32_t INT11:1;
      vuint32_t INT10:1;
      vuint32_t INT9:1;
      vuint32_t INT8:1;
      vuint32_t INT7:1;
      vuint32_t INT6:1;
      vuint32_t INT5:1;
      vuint32_t INT4:1;
      vuint32_t INT3:1;
      vuint32_t INT2:1;
      vuint32_t INT1:1;
      vuint32_t INT0:1;
    } B;
  } INTL;

  union {                              /* Error Register High */
    vuint32_t R;
    struct {
      vuint32_t ERR63:1;
      vuint32_t ERR62:1;
      vuint32_t ERR61:1;
      vuint32_t ERR60:1;
      vuint32_t ERR59:1;
      vuint32_t ERR58:1;
      vuint32_t ERR57:1;
      vuint32_t ERR56:1;
      vuint32_t ERR55:1;
      vuint32_t ERR54:1;
      vuint32_t ERR53:1;
      vuint32_t ERR52:1;
      vuint32_t ERR51:1;
      vuint32_t ERR50:1;
      vuint32_t ERR49:1;
      vuint32_t ERR48:1;
      vuint32_t ERR47:1;
      vuint32_t ERR46:1;
      vuint32_t ERR45:1;
      vuint32_t ERR44:1;
      vuint32_t ERR43:1;
      vuint32_t ERR42:1;
      vuint32_t ERR41:1;
      vuint32_t ERR40:1;
      vuint32_t ERR39:1;
      vuint32_t ERR38:1;
      vuint32_t ERR37:1;
      vuint32_t ERR36:1;
      vuint32_t ERR35:1;
      vuint32_t ERR34:1;
      vuint32_t ERR33:1;
      vuint32_t ERR32:1;
    } B;
  } ERRH;

  union {                              /* Error Register Low */
    vuint32_t R;
    struct {
      vuint32_t ERR31:1;
      vuint32_t ERR30:1;
      vuint32_t ERR29:1;
      vuint32_t ERR28:1;
      vuint32_t ERR27:1;
      vuint32_t ERR26:1;
      vuint32_t ERR25:1;
      vuint32_t ERR24:1;
      vuint32_t ERR23:1;
      vuint32_t ERR22:1;
      vuint32_t ERR21:1;
      vuint32_t ERR20:1;
      vuint32_t ERR19:1;
      vuint32_t ERR18:1;
      vuint32_t ERR17:1;
      vuint32_t ERR16:1;
      vuint32_t ERR15:1;
      vuint32_t ERR14:1;
      vuint32_t ERR13:1;
      vuint32_t ERR12:1;
      vuint32_t ERR11:1;
      vuint32_t ERR10:1;
      vuint32_t ERR9:1;
      vuint32_t ERR8:1;
      vuint32_t ERR7:1;
      vuint32_t ERR6:1;
      vuint32_t ERR5:1;
      vuint32_t ERR4:1;
      vuint32_t ERR3:1;
      vuint32_t ERR2:1;
      vuint32_t ERR1:1;
      vuint32_t ERR0:1;
    } B;
  } ERRL;

  union {                              /* Hardware Request Status Register High */
    vuint32_t R;
    struct {
      vuint32_t HRS63:1;
      vuint32_t HRS62:1;
      vuint32_t HRS61:1;
      vuint32_t HRS60:1;
      vuint32_t HRS59:1;
      vuint32_t HRS58:1;
      vuint32_t HRS57:1;
      vuint32_t HRS56:1;
      vuint32_t HRS55:1;
      vuint32_t HRS54:1;
      vuint32_t HRS53:1;
      vuint32_t HRS52:1;
      vuint32_t HRS51:1;
      vuint32_t HRS50:1;
      vuint32_t HRS49:1;
      vuint32_t HRS48:1;
      vuint32_t HRS47:1;
      vuint32_t HRS46:1;
      vuint32_t HRS45:1;
      vuint32_t HRS44:1;
      vuint32_t HRS43:1;
      vuint32_t HRS42:1;
      vuint32_t HRS41:1;
      vuint32_t HRS40:1;
      vuint32_t HRS39:1;
      vuint32_t HRS38:1;
      vuint32_t HRS37:1;
      vuint32_t HRS36:1;
      vuint32_t HRS35:1;
      vuint32_t HRS34:1;
      vuint32_t HRS33:1;
      vuint32_t HRS32:1;
    } B;
  } HRSH;

  union {                              /* Hardware Request Status Register Low */
    vuint32_t R;
    struct {
      vuint32_t HRS31:1;
      vuint32_t HRS30:1;
      vuint32_t HRS29:1;
      vuint32_t HRS28:1;
      vuint32_t HRS27:1;
      vuint32_t HRS26:1;
      vuint32_t HRS25:1;
      vuint32_t HRS24:1;
      vuint32_t HRS23:1;
      vuint32_t HRS22:1;
      vuint32_t HRS21:1;
      vuint32_t HRS20:1;
      vuint32_t HRS19:1;
      vuint32_t HRS18:1;
      vuint32_t HRS17:1;
      vuint32_t HRS16:1;
      vuint32_t HRS15:1;
      vuint32_t HRS14:1;
      vuint32_t HRS13:1;
      vuint32_t HRS12:1;
      vuint32_t HRS11:1;
      vuint32_t HRS10:1;
      vuint32_t HRS9:1;
      vuint32_t HRS8:1;
      vuint32_t HRS7:1;
      vuint32_t HRS6:1;
      vuint32_t HRS5:1;
      vuint32_t HRS4:1;
      vuint32_t HRS3:1;
      vuint32_t HRS2:1;
      vuint32_t HRS1:1;
      vuint32_t HRS0:1;
    } B;
  } HRSL;

  uint8_t eDMA_reserved0[200];
  union {                              /* Channel Priority Register */
    vuint8_t R;
    struct {
      vuint8_t ECP:1;
      vuint8_t DPA:1;
      vuint8_t GRPPRI:2;
      vuint8_t CHPRI:4;
    } B;
  } DCHPRI[64];

  union {                              /* Channel Master ID Register */
    vuint8_t R;
    struct {
      vuint8_t EMI:1;
      vuint8_t PAL:1;
      vuint8_t  :2;
      vuint8_t MID:4;
    } B;
  } DCHMID[64];

  uint8_t eDMA_reserved1[3712];
  struct {
    union {                            /* TCD Source Address */
      vuint32_t R;
      struct {
        vuint32_t SADDR:32;
      } B;
    } SADDR;
    union {                            /* TCD Transfer Attributes */
      vuint16_t R;
      struct {
        vuint16_t SMOD:5;
        vuint16_t SSIZE:3;
        vuint16_t DMOD:5;
        vuint16_t DSIZE:3;
      } B;
    } ATTR;
    union {                            /* TCD Signed Source Address Offset */
      vuint16_t R;
      struct {
        vuint16_t SOFF:16;
      } B;
    } SOFF;
    union {
      union {                          /* TCD Minor Byte Count Minor Loop Disabled */
        vuint32_t R;
        struct {
          vuint32_t NBYTES:32;
        } B;
      } MLNO;
      union {                          /* TCD Signed Minor Loop Offset Minor Loop Enabled and Offset Disabled */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;
          vuint32_t DMLOE:1;
          vuint32_t NBYTES:30;
        } B;
      } MLOFFNO;
      union {                          /* TCD Signed Minor Loop Offset Minor Loop and Offset Enabled */
        vuint32_t R;
        struct {
          vuint32_t SMLOE:1;
          vuint32_t DMLOE:1;
          vuint32_t MLOFF:20;
          vuint32_t NBYTES:10;
        } B;
      } MLOFFYES;
    } NBYTES;
    union {                            /* TCD Last Source Address Adjustment */
      vuint32_t R;
      struct {
        vuint32_t SLAST:32;
      } B;
    } SLAST;
    union {                            /* TCD Destination Address */
      vuint32_t R;
      struct {
        vuint32_t DADDR:32;
      } B;
    } DADDR;
    union {
      union {                          /* TCD Current Minor Loop Link, Major Loop Count Channel Linking Disabled */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;
          vuint16_t CITER:15;
        } B;
      } ELINKNO;
      union {                          /* TCD Current Minor Loop Link, Major Loop Count Channel Linking Enabled */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;
          vuint16_t LINKCH:6;
          vuint16_t CITER:9;
        } B;
      } ELINKYES;
    } CITER;
    union {                            /* TCD Signed Destination Address Offset */
      vuint16_t R;
      struct {
        vuint16_t DOFF:16;
      } B;
    } DOFF;
    union {                            /* TCD Last Destination Address Adjustment/Scatter Gather Address */
      vuint32_t R;
      struct {
        vuint32_t DLASTSGA:32;
      } B;
    } DLASTSGA;
    union {
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count Channel Linking Disabled */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;
          vuint16_t BITER:15;
        } B;
      } ELINKNO;
      union {                          /* TCD Beginning Minor Loop Link, Major Loop Count Channel Linking Enabled */
        vuint16_t R;
        struct {
          vuint16_t ELINK:1;
          vuint16_t LINKCH:6;
          vuint16_t BITER:9;
        } B;
      } ELINKYES;
    } BITER;
    union {                            /* TCD Control and Status */
      vuint16_t R;
      struct {
        vuint16_t BWC:2;
        vuint16_t MAJORLINKCH:6;
        vuint16_t DONE:1;
        vuint16_t ACTIVE:1;
        vuint16_t MAJORELINK:1;
        vuint16_t ESG:1;
        vuint16_t DREQ:1;
        vuint16_t INTHALF:1;
        vuint16_t INTMAJOR:1;
        vuint16_t START:1;
      } B;
    } CSR;
  } TCD[64];
};

#define SRAM0_START 0x40000000UL;
#define C55FMC (*(volatile struct C55FMC_tag *) 0xFFFE0000UL)
#define CMU_ADCSAR (*(volatile struct CMU_tag *) 0xFBFB0340UL)
#define CMU_ADCSD (*(volatile struct CMU_tag *) 0xFBFB0300UL)
#define CMU_CLKOUT (*(volatile struct CMU_tag *) 0xFBFB04C0UL)
#define CMU_CORE (*(volatile struct CMU_tag *) 0xFBFB0480UL)
#define CMU_FXBAR (*(volatile struct CMU_tag *) 0xFBFB0200UL)
#define CMU_PBRIDGE (*(volatile struct CMU_tag *) 0xFBFB0280UL)
#define CMU_PER (*(volatile struct CMU_tag *) 0xFBFB02C0UL)
#define CMU_PLL (*(volatile struct CMU_tag *) 0xFFFB0200UL)
#define CMU_PSI5_1US (*(volatile struct CMU_tag *) 0xFBFB0440UL)
#define CMU_PSI5_F125 (*(volatile struct CMU_tag *) 0xFBFB0400UL)
#define CMU_PSI5_F189 (*(volatile struct CMU_tag *) 0xFBFB03C0UL)
#define CMU_SENT (*(volatile struct CMU_tag *) 0xFBFB0380UL)
#define CMU_SXBAR (*(volatile struct CMU_tag *) 0xFBFB0240UL)
#define CRC_0 (*(volatile struct CRC_tag *) 0xFFF64000UL)
#define CRC_1 (*(volatile struct CRC_tag *) 0xFBF64000UL)
#define DMAMUX_0 (*(volatile struct DMAMUX_tag *) 0xFFF6C000UL)
#define DMAMUX_1 (*(volatile struct DMAMUX_tag *) 0xFFF6C200UL)
#define DMAMUX_2 (*(volatile struct DMAMUX_tag *) 0xFFF6C400UL)
#define DMAMUX_3 (*(volatile struct DMAMUX_tag *) 0xFFF6C600UL)
#define DMAMUX_4 (*(volatile struct DMAMUX_tag *) 0xFFF6C800UL)
#define DMAMUX_5 (*(volatile struct DMAMUX_tag *) 0xFFF6CA00UL)
#define DMAMUX_6 (*(volatile struct DMAMUX_tag *) 0xFFF6CC00UL)
#define DMAMUX_7 (*(volatile struct DMAMUX_tag *) 0xFFF6CE00UL)
#define DMAMUX_8 (*(volatile struct DMAMUX_tag *) 0xFFF6D000UL)
#define DMAMUX_9 (*(volatile struct DMAMUX_tag *) 0xFFF6D200UL)
#define DSPI_0 (*(volatile struct DSPI_tag *) 0xFFE70000UL)
#define DSPI_1 (*(volatile struct DSPI_tag *) 0xFFE74000UL)
#define DSPI_12 (*(volatile struct DSPI_tag *) 0xFFE88000UL)
#define DSPI_2 (*(volatile struct DSPI_tag *) 0xFBE70000UL)
#define DSPI_3 (*(volatile struct DSPI_tag *) 0xFBE74000UL)
#define DSPI_4 (*(volatile struct DSPI_tag *) 0xFFE78000UL)
#define DSPI_5 (*(volatile struct DSPI_tag *) 0xFBE78000UL)
#define DSPI_6 (*(volatile struct DSPI_tag *) 0xFFE7C000UL)
#define DTS (*(volatile struct DTS_tag *) 0xFFF38000UL)
#define EBI (*(volatile struct EBI_tag *) 0xFFFF0000UL)
#define FCCU (*(volatile struct FCCU_tag *) 0xFBF58000UL)
#define FEC (*(volatile struct FEC_tag *) 0xFC0B0000UL)
#define FR_0 (*(volatile struct FR_tag *) 0xFFE50000UL)
#define FR_1 (*(volatile struct FR_tag *) 0xFBE50000UL)
#define GTM (*(volatile struct GTM_tag *) 0xFFD00000UL)
#define GTMINT (*(volatile struct GTMINT_tag *) 0xFFD00000UL)
#define GTM_AFD_0 (*(volatile struct GTM_AFD_tag *) 0xFFD18000UL)
#define GTM_AFD_1 (*(volatile struct GTM_AFD_tag *) 0xFFD1C000UL)
#define GTM_ARU (*(volatile struct GTM_ARU_tag *) 0xFFD00280UL)
#define GTM_ATOM_0 (*(volatile struct GTM_ATOM_tag *) 0xFFD0D000UL)
#define GTM_ATOM_1 (*(volatile struct GTM_ATOM_tag *) 0xFFD0D800UL)
#define GTM_ATOM_2 (*(volatile struct GTM_ATOM_tag *) 0xFFD0E000UL)
#define GTM_ATOM_3 (*(volatile struct GTM_ATOM_tag *) 0xFFD0E800UL)
#define GTM_ATOM_4 (*(volatile struct GTM_ATOM_tag *) 0xFFD0F000UL)
#define GTM_ATOM_5 (*(volatile struct GTM_ATOM_tag *) 0xFFD0F800UL)
#define GTM_ATOM_6 (*(volatile struct GTM_ATOM_tag *) 0xFFD10000UL)
#define GTM_ATOM_7 (*(volatile struct GTM_ATOM_tag *) 0xFFD10800UL)
#define GTM_ATOM_8 (*(volatile struct GTM_ATOM_tag *) 0xFFD11000UL)
#define GTM_BRC (*(volatile struct GTM_BRC_tag *) 0xFFD00400UL)
#define GTM_CMP (*(volatile struct GTM_CMP_tag *) 0xFFD00200UL)
#define GTM_CMU (*(volatile struct GTM_CMU_tag *) 0xFFD00300UL)
#define GTM_DPLL (*(volatile struct GTM_DPLL_tag *) 0xFFD28000UL)
#define GTM_F2A_0 (*(volatile struct GTM_F2A_tag *) 0xFFD18080UL)
#define GTM_F2A_1 (*(volatile struct GTM_F2A_tag *) 0xFFD1C080UL)
#define GTM_FIFO_0 (*(volatile struct GTM_FIFO_tag *) 0xFFD18400UL)
#define GTM_FIFO_1 (*(volatile struct GTM_FIFO_tag *) 0xFFD1C400UL)
#define GTM_ICM (*(volatile struct GTM_ICM_tag *) 0xFFD00600UL)
#define GTM_MAP (*(volatile struct GTM_MAP_tag *) 0xFFD00F00UL)
#define GTM_MCFG (*(volatile struct GTM_MCFG_tag *) 0xFFD00F40UL)
#define GTM_MCS_0 (*(volatile struct GTM_MCS_tag *) 0xFFD30000UL)
#define GTM_MCS_1 (*(volatile struct GTM_MCS_tag *) 0xFFD31000UL)
#define GTM_MCS_2 (*(volatile struct GTM_MCS_tag *) 0xFFD32000UL)
#define GTM_MCS_3 (*(volatile struct GTM_MCS_tag *) 0xFFD33000UL)
#define GTM_MCS_4 (*(volatile struct GTM_MCS_tag *) 0xFFD34000UL)
#define GTM_MCS_5 (*(volatile struct GTM_MCS_tag *) 0xFFD35000UL)
#define GTM_MON (*(volatile struct GTM_MON_tag *) 0xFFD00180UL)
#define GTM_SPE_0 (*(volatile struct GTM_SPE_tag *) 0xFFD00800UL)
#define GTM_SPE_1 (*(volatile struct GTM_SPE_tag *) 0xFFD00880UL)
#define GTM_SPE_2 (*(volatile struct GTM_SPE_tag *) 0xFFD00900UL)
#define GTM_SPE_3 (*(volatile struct GTM_SPE_tag *) 0xFFD00980UL)
#define GTM_TBU (*(volatile struct GTM_TBU_tag *) 0xFFD00100UL)
#define GTM_TIM_0 (*(volatile struct GTM_TIM_tag *) 0xFFD01000UL)
#define GTM_TIM_1 (*(volatile struct GTM_TIM_tag *) 0xFFD01800UL)
#define GTM_TIM_2 (*(volatile struct GTM_TIM_tag *) 0xFFD02000UL)
#define GTM_TIM_3 (*(volatile struct GTM_TIM_tag *) 0xFFD02800UL)
#define GTM_TIM_4 (*(volatile struct GTM_TIM_tag *) 0xFFD03000UL)
#define GTM_TIM_5 (*(volatile struct GTM_TIM_tag *) 0xFFD03800UL)
#define GTM_TOM_0 (*(volatile struct GTM_TOM_tag *) 0xFFD08000UL)
#define GTM_TOM_1 (*(volatile struct GTM_TOM_tag *) 0xFFD08800UL)
#define GTM_TOM_2 (*(volatile struct GTM_TOM_tag *) 0xFFD09000UL)
#define GTM_TOM_3 (*(volatile struct GTM_TOM_tag *) 0xFFD09800UL)
#define GTM_TOM_4 (*(volatile struct GTM_TOM_tag *) 0xFFD0A000UL)
#define I2C_0 (*(volatile struct I2C_tag *) 0xFFE68000UL)
#define I2C_1 (*(volatile struct I2C_tag *) 0xFBE68000UL)
#define IMA (*(volatile struct IMA_tag *) 0xFFF54000UL)
#define INTC_0 (*(volatile struct INTC_tag *) 0xFC040000UL)
#define IRCOSC (*(volatile struct IRCOSC_tag *) 0xFFFB0000UL)
#define JDC (*(volatile struct JDC_tag *) 0xFFF3C000UL)
#define JTAGM (*(volatile struct JTAGM_tag *) 0xFFF48000UL)
#define LFAST_0 (*(volatile struct LFAST_tag *) 0xFFFD8000UL)
#define LINFlexD_0 (*(volatile struct LINFlexD_tag *) 0xFFE8C000UL)
#define LINFlexD_1 (*(volatile struct LINFlexD_tag *) 0xFFE90000UL)
#define LINFlexD_14 (*(volatile struct LINFlexD_tag *) 0xFFEA8000UL)
#define LINFlexD_15 (*(volatile struct LINFlexD_tag *) 0xFBEA8000UL)
#define LINFlexD_16 (*(volatile struct LINFlexD_tag *) 0xFFEAC000UL)
#define LINFlexD_2 (*(volatile struct LINFlexD_tag *) 0xFBE8C000UL)
#define MC_CGM (*(volatile struct MC_CGM_tag *) 0xFFFB0000UL)
#define MC_ME (*(volatile struct MC_ME_tag *) 0xFFFB8000UL)
#define MC_PCU (*(volatile struct MC_PCU_tag *) 0xFFFA0000UL)
#define MC_RGM (*(volatile struct MC_RGM_tag *) 0xFFFA8000UL)
#define MEMU (*(volatile struct MEMU_tag *) 0xFFF50000UL)
#define M_CAN_1 (*(volatile struct M_CAN_tag *) 0xFFEE4000UL)
#define M_CAN_2 (*(volatile struct M_CAN_tag *) 0xFFEE8000UL)
#define M_CAN_3 (*(volatile struct M_CAN_tag *) 0xFFEEC000UL)
#define M_CAN_4 (*(volatile struct M_CAN_tag *) 0xFFEF0000UL)
#define M_TTCAN (*(volatile struct M_TTCAN_tag *) 0xFFEDC000UL)
#define PASS (*(volatile struct PASS_tag *) 0xFFFF4000UL)
#define PBRIDGE_A (*(volatile struct PBRIDGE_tag *) 0xFC000000UL)
#define PBRIDGE_B (*(volatile struct PBRIDGE_tag *) 0xF8000000UL)
#define PCM (*(volatile struct PCM_tag *) 0xFC028000UL)
#define PFLASH (*(volatile struct PFLASH_tag *) 0xFC030000UL)
#define PIT_0 (*(volatile struct PIT_tag *) 0xFFF84000UL)
#define PIT_1 (*(volatile struct PIT_tag *) 0xFFF80000UL)
#define PLLDIG (*(volatile struct PLLDIG_tag *) 0xFFFB0100UL)
#define PMCDIG (*(volatile struct PMCDIG_tag *) 0xFFFA0400UL)
#define PRAMC (*(volatile struct PRAMC_tag *) 0xFC020000UL)
#define PSI5_0 (*(volatile struct PSI5_tag *) 0xFFE40000UL)
#define PSI5_1 (*(volatile struct PSI5_tag *) 0xFBE40000UL)
#define PSI5S (*(volatile struct PSI5S_tag *) 0xFBF74000UL)
#define REG_PROT (*(volatile struct REG_PROT_tag *) 0UL)
#define SARADC_0 (*(volatile struct SARADC_tag *) 0xFFE00000UL)
#define SARADC_1 (*(volatile struct SARADC_tag *) 0xFBE04000UL)
#define SARADC_10 (*(volatile struct SARADC_tag *) 0xFBE28000UL)
#define SARADC_2 (*(volatile struct SARADC_tag *) 0xFBE08000UL)
#define SARADC_3 (*(volatile struct SARADC_tag *) 0xFBE0C000UL)
#define SARADC_4 (*(volatile struct SARADC_tag *) 0xFFE10000UL)
#define SARADC_5 (*(volatile struct SARADC_tag *) 0xFBE14000UL)
#define SARADC_6 (*(volatile struct SARADC_tag *) 0xFBE18000UL)
#define SARADC_7 (*(volatile struct SARADC_tag *) 0xFBE1C000UL)
#define SARADC_8 (*(volatile struct SARADC_tag *) 0xFBE20000UL)
#define SARADC_9 (*(volatile struct SARADC_tag *) 0xFBE24000UL)
#define SARADC_B (*(volatile struct SARADC_tag *) 0xFFE3C000UL)
#define SDADC_0 (*(volatile struct SDADC_tag *) 0xFFF0C000UL)
#define SDADC_1 (*(volatile struct SDADC_tag *) 0xFBF0C000UL)
#define SDADC_2 (*(volatile struct SDADC_tag *) 0xFFF10000UL)
#define SDADC_3 (*(volatile struct SDADC_tag *) 0xFBF10000UL)
#define SDADC_4 (*(volatile struct SDADC_tag *) 0xFFF14000UL)
#define SDADC_5 (*(volatile struct SDADC_tag *) 0xFBF14000UL)
#define SDADC_6 (*(volatile struct SDADC_tag *) 0xFFF18000UL)
#define SDADC_7 (*(volatile struct SDADC_tag *) 0xFBF18000UL)
#define SDADC_8 (*(volatile struct SDADC_tag *) 0xFFF1C000UL)
#define SDADC_9 (*(volatile struct SDADC_tag *) 0xFBF1C000UL)
#define SEMA42 (*(volatile struct SEMA42_tag *) 0xFC03C000UL)
#define SIPI_0 (*(volatile struct SIPI_tag *) 0xFFFD0000UL)
#define SIPI_1 (*(volatile struct SIPI_tag *) 0xFFFD4000UL)
#define SIUL2 (*(volatile struct SIUL2_tag *) 0xFFFC0000UL)
#define SMPU_0 (*(volatile struct SMPU_tag *) 0xFC010000UL)
#define SMPU_1 (*(volatile struct SMPU_tag *) 0xFC014000UL)
#define SRX_0 (*(volatile struct SRX_tag *) 0xFFE5C000UL)
#define SRX_1 (*(volatile struct SRX_tag *) 0xFBE5C000UL)
#define SSCM (*(volatile struct SSCM_tag *) 0xFFFF8000UL)
#define STCU2 (*(volatile struct STCU2_tag *) 0xFFF44000UL)
#define STM_0 (*(volatile struct STM_tag *) 0xFC068000UL)
#define STM_1 (*(volatile struct STM_tag *) 0xFC06C000UL)
#define STM_2 (*(volatile struct STM_tag *) 0xFC070000UL)
#define SWT_0 (*(volatile struct SWT_tag *) 0xFC050000UL)
#define SWT_1 (*(volatile struct SWT_tag *) 0xFC054000UL)
#define SWT_2 (*(volatile struct SWT_tag *) 0xFC058000UL)
#define SWT_3 (*(volatile struct SWT_tag *) 0xFC05C000UL)
#define TDM (*(volatile struct TDM_tag *) 0xFFF34000UL)
#define WKPU (*(volatile struct WKPU_tag *) 0xFFF98000UL)
#define XBAR_0 (*(volatile struct XBAR_tag *) 0xFC004000UL)
#define XBAR_1 (*(volatile struct XBAR_tag *) 0xFC008000UL)
#define XBIC_0 (*(volatile struct XBIC_tag *) 0xFC018000UL)
#define XBIC_1 (*(volatile struct XBIC_tag *) 0xFC01C000UL)
#define XOSC (*(volatile struct XOSC_tag *) 0xFFFB0080UL)
#define eDMA_0 (*(volatile struct eDMA_tag *) 0xFC0A0000UL)
#define eDMA_1 (*(volatile struct eDMA_tag *) 0xFC0A4000UL)

/* C55FMC */
#define C55FMC_MCR           C55FMC.MCR.R                  /* Module Configuration Register */
#define C55FMC_MCRA          C55FMC.MCRA.R                 /* Alternate Module Configuration Register */
#define C55FMC_MCRE          C55FMC.MCRE.R                 /* Extended Module Configuration Register */
#define C55FMC_LOCK0         C55FMC.LOCK0.R                /* Lock 0 register */
#define C55FMC_LOCK1         C55FMC.LOCK1.R                /* Lock 1 register */
#define C55FMC_LOCK2         C55FMC.LOCK2.R                /* Lock 2 register */
#define C55FMC_LOCK3         C55FMC.LOCK3.R                /* Lock 3 register */
#define C55FMC_LOCK0A        C55FMC.LOCK0A.R               /* Alternate Lock 0 register */
#define C55FMC_LOCK1A        C55FMC.LOCK1A.R               /* Alternate Lock 1 register */
#define C55FMC_SEL0          C55FMC.SEL0.R                 /* Select 0 register */
#define C55FMC_SEL1          C55FMC.SEL1.R                 /* Select 1 register */
#define C55FMC_SEL2          C55FMC.SEL2.R                 /* Select 2 register */
#define C55FMC_SEL3          C55FMC.SEL3.R                 /* Select 3 register */
#define C55FMC_ADR           C55FMC.ADR.R                  /* Address register */
#define C55FMC_UT0           C55FMC.UT0.R                  /* UTest 0 register */
#define C55FMC_UM0           C55FMC.UM[0].R                /* UMISR register */
#define C55FMC_UM1           C55FMC.UM[1].R                /* UMISR register */
#define C55FMC_UM2           C55FMC.UM[2].R                /* UMISR register */
#define C55FMC_UM3           C55FMC.UM[3].R                /* UMISR register */
#define C55FMC_UM4           C55FMC.UM[4].R                /* UMISR register */
#define C55FMC_UM5           C55FMC.UM[5].R                /* UMISR register */
#define C55FMC_UM6           C55FMC.UM[6].R                /* UMISR register */
#define C55FMC_UM7           C55FMC.UM[7].R                /* UMISR register */
#define C55FMC_UM8           C55FMC.UM[8].R                /* UMISR register */
#define C55FMC_UM9           C55FMC.UM9.R                  /* UMISR register */
#define C55FMC_OPP0          C55FMC.OPP0.R                 /* Over-Program Protection 0 register */
#define C55FMC_OPP1          C55FMC.OPP1.R                 /* Over-Program Protection 1 register */
#define C55FMC_OPP2          C55FMC.OPP2.R                 /* Over-Program Protection 2 register */
#define C55FMC_OPP3          C55FMC.OPP3.R                 /* Over-Program Protection 3 register */
#define C55FMC_TMD           C55FMC.TMD.R                  /* Test Mode Disable Password Check register */

/* CMU */
#define CMU_ADCSAR_CSR       CMU_ADCSAR.CSR.R              /* CMU Control Status Register */
#define CMU_ADCSAR_FDR       CMU_ADCSAR.FDR.R              /* CMU Frequency Display Register */
#define CMU_ADCSAR_HFREFR    CMU_ADCSAR.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_ADCSAR_LFREFR    CMU_ADCSAR.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ADCSAR_ISR       CMU_ADCSAR.ISR.R              /* CMU Interrupt Status Register */
#define CMU_ADCSAR_MDR       CMU_ADCSAR.MDR.R              /* CMU Measurement Duration Register */

/* CMU */
#define CMU_ADCSD_CSR        CMU_ADCSD.CSR.R               /* CMU Control Status Register */
#define CMU_ADCSD_FDR        CMU_ADCSD.FDR.R               /* CMU Frequency Display Register */
#define CMU_ADCSD_HFREFR     CMU_ADCSD.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_LFREFR     CMU_ADCSD.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_ADCSD_ISR        CMU_ADCSD.ISR.R               /* CMU Interrupt Status Register */
#define CMU_ADCSD_MDR        CMU_ADCSD.MDR.R               /* CMU Measurement Duration Register */

/* CMU */
#define CMU_CLKOUT_CSR       CMU_CLKOUT.CSR.R              /* CMU Control Status Register */
#define CMU_CLKOUT_FDR       CMU_CLKOUT.FDR.R              /* CMU Frequency Display Register */
#define CMU_CLKOUT_HFREFR    CMU_CLKOUT.HFREFR.R           /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_LFREFR    CMU_CLKOUT.LFREFR.R           /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_CLKOUT_ISR       CMU_CLKOUT.ISR.R              /* CMU Interrupt Status Register */
#define CMU_CLKOUT_MDR       CMU_CLKOUT.MDR.R              /* CMU Measurement Duration Register */

/* CMU */
#define CMU_CORE_CSR         CMU_CORE.CSR.R                /* CMU Control Status Register */
#define CMU_CORE_FDR         CMU_CORE.FDR.R                /* CMU Frequency Display Register */
#define CMU_CORE_HFREFR      CMU_CORE.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_CORE_LFREFR      CMU_CORE.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_CORE_ISR         CMU_CORE.ISR.R                /* CMU Interrupt Status Register */
#define CMU_CORE_MDR         CMU_CORE.MDR.R                /* CMU Measurement Duration Register */

/* CMU */
#define CMU_FXBAR_CSR        CMU_FXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_FXBAR_FDR        CMU_FXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_FXBAR_HFREFR     CMU_FXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_LFREFR     CMU_FXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_FXBAR_ISR        CMU_FXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_FXBAR_MDR        CMU_FXBAR.MDR.R               /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PBRIDGE_CSR      CMU_PBRIDGE.CSR.R             /* CMU Control Status Register */
#define CMU_PBRIDGE_FDR      CMU_PBRIDGE.FDR.R             /* CMU Frequency Display Register */
#define CMU_PBRIDGE_HFREFR   CMU_PBRIDGE.HFREFR.R          /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PBRIDGE_LFREFR   CMU_PBRIDGE.LFREFR.R          /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PBRIDGE_ISR      CMU_PBRIDGE.ISR.R             /* CMU Interrupt Status Register */
#define CMU_PBRIDGE_MDR      CMU_PBRIDGE.MDR.R             /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PER_CSR          CMU_PER.CSR.R                 /* CMU Control Status Register */
#define CMU_PER_FDR          CMU_PER.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PER_HFREFR       CMU_PER.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PER_LFREFR       CMU_PER.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PER_ISR          CMU_PER.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PER_MDR          CMU_PER.MDR.R                 /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PLL_CSR          CMU_PLL.CSR.R                 /* CMU Control Status Register */
#define CMU_PLL_FDR          CMU_PLL.FDR.R                 /* CMU Frequency Display Register */
#define CMU_PLL_HFREFR       CMU_PLL.HFREFR.R              /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PLL_LFREFR       CMU_PLL.LFREFR.R              /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PLL_ISR          CMU_PLL.ISR.R                 /* CMU Interrupt Status Register */
#define CMU_PLL_MDR          CMU_PLL.MDR.R                 /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PSI5_1US_CSR     CMU_PSI5_1US.CSR.R            /* CMU Control Status Register */
#define CMU_PSI5_1US_FDR     CMU_PSI5_1US.FDR.R            /* CMU Frequency Display Register */
#define CMU_PSI5_1US_HFREFR  CMU_PSI5_1US.HFREFR.R         /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PSI5_1US_LFREFR  CMU_PSI5_1US.LFREFR.R         /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PSI5_1US_ISR     CMU_PSI5_1US.ISR.R            /* CMU Interrupt Status Register */
#define CMU_PSI5_1US_MDR     CMU_PSI5_1US.MDR.R            /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PSI5_F125_CSR    CMU_PSI5_F125.CSR.R           /* CMU Control Status Register */
#define CMU_PSI5_F125_FDR    CMU_PSI5_F125.FDR.R           /* CMU Frequency Display Register */
#define CMU_PSI5_F125_HFREFR CMU_PSI5_F125.HFREFR.R        /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F125_LFREFR CMU_PSI5_F125.LFREFR.R        /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F125_ISR    CMU_PSI5_F125.ISR.R           /* CMU Interrupt Status Register */
#define CMU_PSI5_F125_MDR    CMU_PSI5_F125.MDR.R           /* CMU Measurement Duration Register */

/* CMU */
#define CMU_PSI5_F189_CSR    CMU_PSI5_F189.CSR.R           /* CMU Control Status Register */
#define CMU_PSI5_F189_FDR    CMU_PSI5_F189.FDR.R           /* CMU Frequency Display Register */
#define CMU_PSI5_F189_HFREFR CMU_PSI5_F189.HFREFR.R        /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F189_LFREFR CMU_PSI5_F189.LFREFR.R        /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_PSI5_F189_ISR    CMU_PSI5_F189.ISR.R           /* CMU Interrupt Status Register */
#define CMU_PSI5_F189_MDR    CMU_PSI5_F189.MDR.R           /* CMU Measurement Duration Register */

/* CMU */
#define CMU_SENT_CSR         CMU_SENT.CSR.R                /* CMU Control Status Register */
#define CMU_SENT_FDR         CMU_SENT.FDR.R                /* CMU Frequency Display Register */
#define CMU_SENT_HFREFR      CMU_SENT.HFREFR.R             /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SENT_LFREFR      CMU_SENT.LFREFR.R             /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SENT_ISR         CMU_SENT.ISR.R                /* CMU Interrupt Status Register */
#define CMU_SENT_MDR         CMU_SENT.MDR.R                /* CMU Measurement Duration Register */

/* CMU */
#define CMU_SXBAR_CSR        CMU_SXBAR.CSR.R               /* CMU Control Status Register */
#define CMU_SXBAR_FDR        CMU_SXBAR.FDR.R               /* CMU Frequency Display Register */
#define CMU_SXBAR_HFREFR     CMU_SXBAR.HFREFR.R            /* CMU High Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_LFREFR     CMU_SXBAR.LFREFR.R            /* CMU Low Frequency Reference Register CLKMN1 */
#define CMU_SXBAR_ISR        CMU_SXBAR.ISR.R               /* CMU Interrupt Status Register */
#define CMU_SXBAR_MDR        CMU_SXBAR.MDR.R               /* CMU Measurement Duration Register */

/* CRC */
#define CRC_0_CFG            CRC_0.CFG.R                   /* Configuration Register */
#define CRC_0_INP            CRC_0.INP.R                   /* Input Register */
#define CRC_0_CSTAT          CRC_0.CSTAT.R                 /* Current Status Register */
#define CRC_0_OUTP           CRC_0.OUTP.R                  /* Output Register */

/* CRC */
#define CRC_1_CFG            CRC_1.CFG.R                   /* Configuration Register */
#define CRC_1_INP            CRC_1.INP.R                   /* Input Register */
#define CRC_1_CSTAT          CRC_1.CSTAT.R                 /* Current Status Register */
#define CRC_1_OUTP           CRC_1.OUTP.R                  /* Output Register */

/* DMAMUX */
#define DMAMUX_0_CHCFG0      DMAMUX_0.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG1      DMAMUX_0.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG2      DMAMUX_0.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG3      DMAMUX_0.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG4      DMAMUX_0.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG5      DMAMUX_0.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG6      DMAMUX_0.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG7      DMAMUX_0.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG8      DMAMUX_0.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG9      DMAMUX_0.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_0_CHCFG10     DMAMUX_0.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG11     DMAMUX_0.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG12     DMAMUX_0.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG13     DMAMUX_0.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG14     DMAMUX_0.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_0_CHCFG15     DMAMUX_0.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_1_CHCFG0      DMAMUX_1.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG1      DMAMUX_1.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG2      DMAMUX_1.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG3      DMAMUX_1.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG4      DMAMUX_1.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG5      DMAMUX_1.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG6      DMAMUX_1.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG7      DMAMUX_1.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG8      DMAMUX_1.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG9      DMAMUX_1.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_1_CHCFG10     DMAMUX_1.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG11     DMAMUX_1.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG12     DMAMUX_1.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG13     DMAMUX_1.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG14     DMAMUX_1.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_1_CHCFG15     DMAMUX_1.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_2_CHCFG0      DMAMUX_2.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG1      DMAMUX_2.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG2      DMAMUX_2.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG3      DMAMUX_2.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG4      DMAMUX_2.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG5      DMAMUX_2.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG6      DMAMUX_2.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG7      DMAMUX_2.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG8      DMAMUX_2.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG9      DMAMUX_2.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_2_CHCFG10     DMAMUX_2.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG11     DMAMUX_2.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG12     DMAMUX_2.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG13     DMAMUX_2.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG14     DMAMUX_2.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_2_CHCFG15     DMAMUX_2.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_3_CHCFG0      DMAMUX_3.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG1      DMAMUX_3.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG2      DMAMUX_3.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG3      DMAMUX_3.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG4      DMAMUX_3.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG5      DMAMUX_3.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG6      DMAMUX_3.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG7      DMAMUX_3.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG8      DMAMUX_3.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG9      DMAMUX_3.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_3_CHCFG10     DMAMUX_3.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG11     DMAMUX_3.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG12     DMAMUX_3.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG13     DMAMUX_3.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG14     DMAMUX_3.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_3_CHCFG15     DMAMUX_3.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_4_CHCFG0      DMAMUX_4.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG1      DMAMUX_4.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG2      DMAMUX_4.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG3      DMAMUX_4.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG4      DMAMUX_4.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG5      DMAMUX_4.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG6      DMAMUX_4.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG7      DMAMUX_4.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG8      DMAMUX_4.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG9      DMAMUX_4.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_4_CHCFG10     DMAMUX_4.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG11     DMAMUX_4.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG12     DMAMUX_4.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG13     DMAMUX_4.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG14     DMAMUX_4.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_4_CHCFG15     DMAMUX_4.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_5_CHCFG0      DMAMUX_5.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG1      DMAMUX_5.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG2      DMAMUX_5.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG3      DMAMUX_5.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG4      DMAMUX_5.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG5      DMAMUX_5.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG6      DMAMUX_5.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG7      DMAMUX_5.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG8      DMAMUX_5.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG9      DMAMUX_5.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_5_CHCFG10     DMAMUX_5.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG11     DMAMUX_5.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG12     DMAMUX_5.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG13     DMAMUX_5.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG14     DMAMUX_5.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_5_CHCFG15     DMAMUX_5.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_6_CHCFG0      DMAMUX_6.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG1      DMAMUX_6.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG2      DMAMUX_6.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG3      DMAMUX_6.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG4      DMAMUX_6.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG5      DMAMUX_6.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG6      DMAMUX_6.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG7      DMAMUX_6.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG8      DMAMUX_6.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG9      DMAMUX_6.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_6_CHCFG10     DMAMUX_6.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG11     DMAMUX_6.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG12     DMAMUX_6.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG13     DMAMUX_6.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG14     DMAMUX_6.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_6_CHCFG15     DMAMUX_6.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_7_CHCFG0      DMAMUX_7.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG1      DMAMUX_7.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG2      DMAMUX_7.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG3      DMAMUX_7.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG4      DMAMUX_7.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG5      DMAMUX_7.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG6      DMAMUX_7.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG7      DMAMUX_7.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG8      DMAMUX_7.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG9      DMAMUX_7.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_7_CHCFG10     DMAMUX_7.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG11     DMAMUX_7.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG12     DMAMUX_7.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG13     DMAMUX_7.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG14     DMAMUX_7.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_7_CHCFG15     DMAMUX_7.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_8_CHCFG0      DMAMUX_8.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG1      DMAMUX_8.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG2      DMAMUX_8.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG3      DMAMUX_8.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG4      DMAMUX_8.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG5      DMAMUX_8.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG6      DMAMUX_8.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG7      DMAMUX_8.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG8      DMAMUX_8.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG9      DMAMUX_8.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_8_CHCFG10     DMAMUX_8.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG11     DMAMUX_8.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG12     DMAMUX_8.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG13     DMAMUX_8.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG14     DMAMUX_8.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_8_CHCFG15     DMAMUX_8.CHCFG[15].R          /* Channel Configuration register */

/* DMAMUX */
#define DMAMUX_9_CHCFG0      DMAMUX_9.CHCFG[0].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG1      DMAMUX_9.CHCFG[1].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG2      DMAMUX_9.CHCFG[2].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG3      DMAMUX_9.CHCFG[3].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG4      DMAMUX_9.CHCFG[4].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG5      DMAMUX_9.CHCFG[5].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG6      DMAMUX_9.CHCFG[6].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG7      DMAMUX_9.CHCFG[7].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG8      DMAMUX_9.CHCFG[8].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG9      DMAMUX_9.CHCFG[9].R           /* Channel Configuration register */
#define DMAMUX_9_CHCFG10     DMAMUX_9.CHCFG[10].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG11     DMAMUX_9.CHCFG[11].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG12     DMAMUX_9.CHCFG[12].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG13     DMAMUX_9.CHCFG[13].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG14     DMAMUX_9.CHCFG[14].R          /* Channel Configuration register */
#define DMAMUX_9_CHCFG15     DMAMUX_9.CHCFG[15].R          /* Channel Configuration register */

/* DSPI */
#define DSPI_0_MCR           DSPI_0.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_0_TCR           DSPI_0.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_0_CTAR0         DSPI_0.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR1         DSPI_0.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR2         DSPI_0.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR3         DSPI_0.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR4         DSPI_0.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR5         DSPI_0.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR6         DSPI_0.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR7         DSPI_0.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_0_CTAR_SLAVE0   DSPI_0.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_CTAR_SLAVE1   DSPI_0.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_0_SR            DSPI_0.SR.R                   /* DSPI Status Register */
#define DSPI_0_RSER          DSPI_0.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_0_PUSHR         DSPI_0.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_0_PUSHR_SLAVE   DSPI_0.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_0_POPR          DSPI_0.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_0_TXFR0         DSPI_0.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_TXFR1         DSPI_0.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_TXFR2         DSPI_0.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_TXFR3         DSPI_0.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_0_RXFR0         DSPI_0.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_RXFR1         DSPI_0.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_RXFR2         DSPI_0.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_RXFR3         DSPI_0.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_0_DSICR0        DSPI_0.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_0_SDR0          DSPI_0.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_0_ASDR0         DSPI_0.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_0_COMPR0        DSPI_0.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_0_DDR0          DSPI_0.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_0_DSICR1        DSPI_0.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_0_SSR0          DSPI_0.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_0_PISR0         DSPI_0.PISR0.R                /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_0_PISR1         DSPI_0.PISR1.R                /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_0_PISR2         DSPI_0.PISR2.R                /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_0_PISR3         DSPI_0.PISR3.R                /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_0_DIMR0         DSPI_0.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_0_DPIR0         DSPI_0.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_0_SDR1          DSPI_0.SDR1.R                 /* DSPI DSI Serialization Data Register 1 */
#define DSPI_0_ASDR1         DSPI_0.ASDR1.R                /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_0_COMPR1        DSPI_0.COMPR1.R               /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_0_DDR1          DSPI_0.DDR1.R                 /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_0_SSR1          DSPI_0.SSR1.R                 /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_0_PISR4         DSPI_0.PISR4.R                /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_0_PISR5         DSPI_0.PISR5.R                /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_0_PISR6         DSPI_0.PISR6.R                /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_0_PISR7         DSPI_0.PISR7.R                /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_0_DIMR1         DSPI_0.DIMR1.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_0_DPIR1         DSPI_0.DPIR1.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_0_CTARE0        DSPI_0.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE1        DSPI_0.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE2        DSPI_0.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE3        DSPI_0.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE4        DSPI_0.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE5        DSPI_0.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE6        DSPI_0.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_CTARE7        DSPI_0.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_0_SREX          DSPI_0.SREX.R                 /* DSPI Status Register Extended */

/* DSPI */
#define DSPI_1_MCR           DSPI_1.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_1_TCR           DSPI_1.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_1_CTAR0         DSPI_1.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR1         DSPI_1.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR2         DSPI_1.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR3         DSPI_1.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR4         DSPI_1.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR5         DSPI_1.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR6         DSPI_1.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR7         DSPI_1.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_1_CTAR_SLAVE0   DSPI_1.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_CTAR_SLAVE1   DSPI_1.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_1_SR            DSPI_1.SR.R                   /* DSPI Status Register */
#define DSPI_1_RSER          DSPI_1.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_1_PUSHR         DSPI_1.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_1_PUSHR_SLAVE   DSPI_1.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_1_POPR          DSPI_1.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_1_TXFR0         DSPI_1.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_TXFR1         DSPI_1.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_TXFR2         DSPI_1.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_TXFR3         DSPI_1.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_1_RXFR0         DSPI_1.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_RXFR1         DSPI_1.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_RXFR2         DSPI_1.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_RXFR3         DSPI_1.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_1_DSICR0        DSPI_1.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_1_SDR0          DSPI_1.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_1_ASDR0         DSPI_1.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_1_COMPR0        DSPI_1.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_1_DDR0          DSPI_1.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_1_DSICR1        DSPI_1.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_1_SSR0          DSPI_1.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_1_PISR0         DSPI_1.PISR0.R                /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_1_PISR1         DSPI_1.PISR1.R                /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_1_PISR2         DSPI_1.PISR2.R                /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_1_PISR3         DSPI_1.PISR3.R                /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_1_DIMR0         DSPI_1.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_1_DPIR0         DSPI_1.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_1_SDR1          DSPI_1.SDR1.R                 /* DSPI DSI Serialization Data Register 1 */
#define DSPI_1_ASDR1         DSPI_1.ASDR1.R                /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_1_COMPR1        DSPI_1.COMPR1.R               /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_1_DDR1          DSPI_1.DDR1.R                 /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_1_SSR1          DSPI_1.SSR1.R                 /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_1_PISR4         DSPI_1.PISR4.R                /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_1_PISR5         DSPI_1.PISR5.R                /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_1_PISR6         DSPI_1.PISR6.R                /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_1_PISR7         DSPI_1.PISR7.R                /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_1_DIMR1         DSPI_1.DIMR1.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_1_DPIR1         DSPI_1.DPIR1.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_1_CTARE0        DSPI_1.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE1        DSPI_1.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE2        DSPI_1.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE3        DSPI_1.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE4        DSPI_1.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE5        DSPI_1.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE6        DSPI_1.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_CTARE7        DSPI_1.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_1_SREX          DSPI_1.SREX.R                 /* DSPI Status Register Extended */

/* DSPI */
#define DSPI_12_MCR          DSPI_12.MCR.R                 /* DSPI Module Configuration Register */
#define DSPI_12_TCR          DSPI_12.TCR.R                 /* DSPI Transfer Count Register */
#define DSPI_12_CTAR0        DSPI_12.MODE.CTAR[0].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR1        DSPI_12.MODE.CTAR[1].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR2        DSPI_12.MODE.CTAR[2].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR3        DSPI_12.MODE.CTAR[3].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR4        DSPI_12.MODE.CTAR[4].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR5        DSPI_12.MODE.CTAR[5].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR6        DSPI_12.MODE.CTAR[6].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR7        DSPI_12.MODE.CTAR[7].R        /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_12_CTAR_SLAVE0  DSPI_12.MODE.CTAR_SLAVE[0].R  /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_12_CTAR_SLAVE1  DSPI_12.MODE.CTAR_SLAVE[1].R  /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_12_SR           DSPI_12.SR.R                  /* DSPI Status Register */
#define DSPI_12_RSER         DSPI_12.RSER.R                /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_12_PUSHR        DSPI_12.PUSHR.PUSHR.R         /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_12_PUSHR_SLAVE  DSPI_12.PUSHR.PUSHR_SLAVE.R   /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_12_POPR         DSPI_12.POPR.R                /* DSPI POP FIFO Register */
#define DSPI_12_TXFR0        DSPI_12.TXFR[0].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_TXFR1        DSPI_12.TXFR[1].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_TXFR2        DSPI_12.TXFR[2].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_TXFR3        DSPI_12.TXFR[3].R             /* DSPI Transmit FIFO Registers */
#define DSPI_12_RXFR0        DSPI_12.RXFR[0].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_RXFR1        DSPI_12.RXFR[1].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_RXFR2        DSPI_12.RXFR[2].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_RXFR3        DSPI_12.RXFR[3].R             /* DSPI Receive FIFO Registers */
#define DSPI_12_DSICR0       DSPI_12.DSICR0.R              /* DSPI DSI Configuration Register 0 */
#define DSPI_12_SDR0         DSPI_12.SDR0.R                /* DSPI DSI Serialization Data Register 0 */
#define DSPI_12_ASDR0        DSPI_12.ASDR0.R               /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_12_COMPR0       DSPI_12.COMPR0.R              /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_12_DDR0         DSPI_12.DDR0.R                /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_12_DSICR1       DSPI_12.DSICR1.R              /* DSPI DSI Configuration Register 1 */
#define DSPI_12_SSR0         DSPI_12.SSR0.R                /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_12_PISR0        DSPI_12.PISR0.R               /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_12_PISR1        DSPI_12.PISR1.R               /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_12_PISR2        DSPI_12.PISR2.R               /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_12_PISR3        DSPI_12.PISR3.R               /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_12_DIMR0        DSPI_12.DIMR0.R               /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_12_DPIR0        DSPI_12.DPIR0.R               /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_12_SDR1         DSPI_12.SDR1.R                /* DSPI DSI Serialization Data Register 1 */
#define DSPI_12_ASDR1        DSPI_12.ASDR1.R               /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_12_COMPR1       DSPI_12.COMPR1.R              /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_12_DDR1         DSPI_12.DDR1.R                /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_12_SSR1         DSPI_12.SSR1.R                /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_12_PISR4        DSPI_12.PISR4.R               /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_12_PISR5        DSPI_12.PISR5.R               /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_12_PISR6        DSPI_12.PISR6.R               /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_12_PISR7        DSPI_12.PISR7.R               /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_12_DIMR1        DSPI_12.DIMR1.R               /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_12_DPIR1        DSPI_12.DPIR1.R               /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_12_CTARE0       DSPI_12.CTARE[0].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE1       DSPI_12.CTARE[1].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE2       DSPI_12.CTARE[2].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE3       DSPI_12.CTARE[3].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE4       DSPI_12.CTARE[4].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE5       DSPI_12.CTARE[5].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE6       DSPI_12.CTARE[6].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_CTARE7       DSPI_12.CTARE[7].R            /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_12_SREX         DSPI_12.SREX.R                /* DSPI Status Register Extended */

/* DSPI */
#define DSPI_2_MCR           DSPI_2.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_2_TCR           DSPI_2.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_2_CTAR0         DSPI_2.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR1         DSPI_2.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR2         DSPI_2.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR3         DSPI_2.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR4         DSPI_2.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR5         DSPI_2.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR6         DSPI_2.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR7         DSPI_2.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_2_CTAR_SLAVE0   DSPI_2.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_CTAR_SLAVE1   DSPI_2.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_2_SR            DSPI_2.SR.R                   /* DSPI Status Register */
#define DSPI_2_RSER          DSPI_2.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_2_PUSHR         DSPI_2.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_2_PUSHR_SLAVE   DSPI_2.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_2_POPR          DSPI_2.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_2_TXFR0         DSPI_2.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_TXFR1         DSPI_2.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_TXFR2         DSPI_2.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_TXFR3         DSPI_2.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_2_RXFR0         DSPI_2.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_RXFR1         DSPI_2.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_RXFR2         DSPI_2.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_RXFR3         DSPI_2.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_2_DSICR0        DSPI_2.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_2_SDR0          DSPI_2.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_2_ASDR0         DSPI_2.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_2_COMPR0        DSPI_2.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_2_DDR0          DSPI_2.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_2_DSICR1        DSPI_2.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_2_SSR0          DSPI_2.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_2_PISR0         DSPI_2.PISR0.R                /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_2_PISR1         DSPI_2.PISR1.R                /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_2_PISR2         DSPI_2.PISR2.R                /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_2_PISR3         DSPI_2.PISR3.R                /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_2_DIMR0         DSPI_2.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_2_DPIR0         DSPI_2.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_2_SDR1          DSPI_2.SDR1.R                 /* DSPI DSI Serialization Data Register 1 */
#define DSPI_2_ASDR1         DSPI_2.ASDR1.R                /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_2_COMPR1        DSPI_2.COMPR1.R               /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_2_DDR1          DSPI_2.DDR1.R                 /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_2_SSR1          DSPI_2.SSR1.R                 /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_2_PISR4         DSPI_2.PISR4.R                /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_2_PISR5         DSPI_2.PISR5.R                /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_2_PISR6         DSPI_2.PISR6.R                /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_2_PISR7         DSPI_2.PISR7.R                /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_2_DIMR1         DSPI_2.DIMR1.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_2_DPIR1         DSPI_2.DPIR1.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_2_CTARE0        DSPI_2.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE1        DSPI_2.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE2        DSPI_2.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE3        DSPI_2.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE4        DSPI_2.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE5        DSPI_2.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE6        DSPI_2.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_CTARE7        DSPI_2.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_2_SREX          DSPI_2.SREX.R                 /* DSPI Status Register Extended */

/* DSPI */
#define DSPI_3_MCR           DSPI_3.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_3_TCR           DSPI_3.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_3_CTAR0         DSPI_3.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR1         DSPI_3.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR2         DSPI_3.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR3         DSPI_3.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR4         DSPI_3.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR5         DSPI_3.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR6         DSPI_3.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR7         DSPI_3.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_3_CTAR_SLAVE0   DSPI_3.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_CTAR_SLAVE1   DSPI_3.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_3_SR            DSPI_3.SR.R                   /* DSPI Status Register */
#define DSPI_3_RSER          DSPI_3.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_3_PUSHR         DSPI_3.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_3_PUSHR_SLAVE   DSPI_3.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_3_POPR          DSPI_3.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_3_TXFR0         DSPI_3.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_TXFR1         DSPI_3.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_TXFR2         DSPI_3.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_TXFR3         DSPI_3.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_3_RXFR0         DSPI_3.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_RXFR1         DSPI_3.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_RXFR2         DSPI_3.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_RXFR3         DSPI_3.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_3_DSICR0        DSPI_3.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_3_SDR0          DSPI_3.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_3_ASDR0         DSPI_3.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_3_COMPR0        DSPI_3.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_3_DDR0          DSPI_3.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_3_DSICR1        DSPI_3.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_3_SSR0          DSPI_3.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_3_PISR0         DSPI_3.PISR0.R                /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_3_PISR1         DSPI_3.PISR1.R                /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_3_PISR2         DSPI_3.PISR2.R                /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_3_PISR3         DSPI_3.PISR3.R                /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_3_DIMR0         DSPI_3.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_3_DPIR0         DSPI_3.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_3_SDR1          DSPI_3.SDR1.R                 /* DSPI DSI Serialization Data Register 1 */
#define DSPI_3_ASDR1         DSPI_3.ASDR1.R                /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_3_COMPR1        DSPI_3.COMPR1.R               /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_3_DDR1          DSPI_3.DDR1.R                 /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_3_SSR1          DSPI_3.SSR1.R                 /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_3_PISR4         DSPI_3.PISR4.R                /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_3_PISR5         DSPI_3.PISR5.R                /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_3_PISR6         DSPI_3.PISR6.R                /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_3_PISR7         DSPI_3.PISR7.R                /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_3_DIMR1         DSPI_3.DIMR1.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_3_DPIR1         DSPI_3.DPIR1.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_3_CTARE0        DSPI_3.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE1        DSPI_3.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE2        DSPI_3.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE3        DSPI_3.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE4        DSPI_3.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE5        DSPI_3.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE6        DSPI_3.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_CTARE7        DSPI_3.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_3_SREX          DSPI_3.SREX.R                 /* DSPI Status Register Extended */

/* DSPI */
#define DSPI_4_MCR           DSPI_4.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_4_TCR           DSPI_4.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_4_CTAR0         DSPI_4.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR1         DSPI_4.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR2         DSPI_4.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR3         DSPI_4.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR4         DSPI_4.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR5         DSPI_4.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR6         DSPI_4.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR7         DSPI_4.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_4_CTAR_SLAVE0   DSPI_4.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_CTAR_SLAVE1   DSPI_4.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_4_SR            DSPI_4.SR.R                   /* DSPI Status Register */
#define DSPI_4_RSER          DSPI_4.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_4_PUSHR         DSPI_4.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_4_PUSHR_SLAVE   DSPI_4.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_4_POPR          DSPI_4.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_4_TXFR0         DSPI_4.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_TXFR1         DSPI_4.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_TXFR2         DSPI_4.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_TXFR3         DSPI_4.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_4_RXFR0         DSPI_4.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_RXFR1         DSPI_4.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_RXFR2         DSPI_4.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_RXFR3         DSPI_4.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_4_DSICR0        DSPI_4.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_4_SDR0          DSPI_4.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_4_ASDR0         DSPI_4.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_4_COMPR0        DSPI_4.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_4_DDR0          DSPI_4.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_4_DSICR1        DSPI_4.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_4_SSR0          DSPI_4.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_4_PISR0         DSPI_4.PISR0.R                /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_4_PISR1         DSPI_4.PISR1.R                /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_4_PISR2         DSPI_4.PISR2.R                /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_4_PISR3         DSPI_4.PISR3.R                /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_4_DIMR0         DSPI_4.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_4_DPIR0         DSPI_4.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_4_SDR1          DSPI_4.SDR1.R                 /* DSPI DSI Serialization Data Register 1 */
#define DSPI_4_ASDR1         DSPI_4.ASDR1.R                /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_4_COMPR1        DSPI_4.COMPR1.R               /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_4_DDR1          DSPI_4.DDR1.R                 /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_4_SSR1          DSPI_4.SSR1.R                 /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_4_PISR4         DSPI_4.PISR4.R                /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_4_PISR5         DSPI_4.PISR5.R                /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_4_PISR6         DSPI_4.PISR6.R                /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_4_PISR7         DSPI_4.PISR7.R                /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_4_DIMR1         DSPI_4.DIMR1.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_4_DPIR1         DSPI_4.DPIR1.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_4_CTARE0        DSPI_4.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE1        DSPI_4.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE2        DSPI_4.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE3        DSPI_4.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE4        DSPI_4.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE5        DSPI_4.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE6        DSPI_4.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_CTARE7        DSPI_4.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_4_SREX          DSPI_4.SREX.R                 /* DSPI Status Register Extended */

/* DSPI */
#define DSPI_5_MCR           DSPI_5.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_5_TCR           DSPI_5.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_5_CTAR0         DSPI_5.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR1         DSPI_5.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR2         DSPI_5.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR3         DSPI_5.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR4         DSPI_5.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR5         DSPI_5.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR6         DSPI_5.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR7         DSPI_5.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_5_CTAR_SLAVE0   DSPI_5.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_5_CTAR_SLAVE1   DSPI_5.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_5_SR            DSPI_5.SR.R                   /* DSPI Status Register */
#define DSPI_5_RSER          DSPI_5.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_5_PUSHR         DSPI_5.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_5_PUSHR_SLAVE   DSPI_5.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_5_POPR          DSPI_5.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_5_TXFR0         DSPI_5.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_TXFR1         DSPI_5.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_TXFR2         DSPI_5.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_TXFR3         DSPI_5.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_5_RXFR0         DSPI_5.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_RXFR1         DSPI_5.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_RXFR2         DSPI_5.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_RXFR3         DSPI_5.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_5_DSICR0        DSPI_5.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_5_SDR0          DSPI_5.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_5_ASDR0         DSPI_5.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_5_COMPR0        DSPI_5.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_5_DDR0          DSPI_5.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_5_DSICR1        DSPI_5.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_5_SSR0          DSPI_5.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_5_PISR0         DSPI_5.PISR0.R                /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_5_PISR1         DSPI_5.PISR1.R                /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_5_PISR2         DSPI_5.PISR2.R                /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_5_PISR3         DSPI_5.PISR3.R                /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_5_DIMR0         DSPI_5.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_5_DPIR0         DSPI_5.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_5_SDR1          DSPI_5.SDR1.R                 /* DSPI DSI Serialization Data Register 1 */
#define DSPI_5_ASDR1         DSPI_5.ASDR1.R                /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_5_COMPR1        DSPI_5.COMPR1.R               /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_5_DDR1          DSPI_5.DDR1.R                 /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_5_SSR1          DSPI_5.SSR1.R                 /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_5_PISR4         DSPI_5.PISR4.R                /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_5_PISR5         DSPI_5.PISR5.R                /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_5_PISR6         DSPI_5.PISR6.R                /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_5_PISR7         DSPI_5.PISR7.R                /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_5_DIMR1         DSPI_5.DIMR1.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_5_DPIR1         DSPI_5.DPIR1.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_5_CTARE0        DSPI_5.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE1        DSPI_5.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE2        DSPI_5.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE3        DSPI_5.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE4        DSPI_5.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE5        DSPI_5.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE6        DSPI_5.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_CTARE7        DSPI_5.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_5_SREX          DSPI_5.SREX.R                 /* DSPI Status Register Extended */

/* DSPI */
#define DSPI_6_MCR           DSPI_6.MCR.R                  /* DSPI Module Configuration Register */
#define DSPI_6_TCR           DSPI_6.TCR.R                  /* DSPI Transfer Count Register */
#define DSPI_6_CTAR0         DSPI_6.MODE.CTAR[0].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR1         DSPI_6.MODE.CTAR[1].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR2         DSPI_6.MODE.CTAR[2].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR3         DSPI_6.MODE.CTAR[3].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR4         DSPI_6.MODE.CTAR[4].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR5         DSPI_6.MODE.CTAR[5].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR6         DSPI_6.MODE.CTAR[6].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR7         DSPI_6.MODE.CTAR[7].R         /* DSPI Clock and Transfer Attributes Register (In Master Mode) */
#define DSPI_6_CTAR_SLAVE0   DSPI_6.MODE.CTAR_SLAVE[0].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_6_CTAR_SLAVE1   DSPI_6.MODE.CTAR_SLAVE[1].R   /* DSPI Clock and Transfer Attributes Register (In Slave Mode) */
#define DSPI_6_SR            DSPI_6.SR.R                   /* DSPI Status Register */
#define DSPI_6_RSER          DSPI_6.RSER.R                 /* DSPI DMA/Interrupt Request Select and Enable Register */
#define DSPI_6_PUSHR         DSPI_6.PUSHR.PUSHR.R          /* DSPI PUSH FIFO Register In Master Mode */
#define DSPI_6_PUSHR_SLAVE   DSPI_6.PUSHR.PUSHR_SLAVE.R    /* DSPI PUSH FIFO Register In Slave Mode */
#define DSPI_6_POPR          DSPI_6.POPR.R                 /* DSPI POP FIFO Register */
#define DSPI_6_TXFR0         DSPI_6.TXFR[0].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_TXFR1         DSPI_6.TXFR[1].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_TXFR2         DSPI_6.TXFR[2].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_TXFR3         DSPI_6.TXFR[3].R              /* DSPI Transmit FIFO Registers */
#define DSPI_6_RXFR0         DSPI_6.RXFR[0].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_RXFR1         DSPI_6.RXFR[1].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_RXFR2         DSPI_6.RXFR[2].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_RXFR3         DSPI_6.RXFR[3].R              /* DSPI Receive FIFO Registers */
#define DSPI_6_DSICR0        DSPI_6.DSICR0.R               /* DSPI DSI Configuration Register 0 */
#define DSPI_6_SDR0          DSPI_6.SDR0.R                 /* DSPI DSI Serialization Data Register 0 */
#define DSPI_6_ASDR0         DSPI_6.ASDR0.R                /* DSPI DSI Alternate Serialization Data Register 0 */
#define DSPI_6_COMPR0        DSPI_6.COMPR0.R               /* DSPI DSI Transmit Comparison Register 0 */
#define DSPI_6_DDR0          DSPI_6.DDR0.R                 /* DSPI DSI Deserialization Data Register 0 */
#define DSPI_6_DSICR1        DSPI_6.DSICR1.R               /* DSPI DSI Configuration Register 1 */
#define DSPI_6_SSR0          DSPI_6.SSR0.R                 /* DSPI DSI Serialization Source Select Register 0 */
#define DSPI_6_PISR0         DSPI_6.PISR0.R                /* DSPI DSI Parallel Input Select Register 0 */
#define DSPI_6_PISR1         DSPI_6.PISR1.R                /* DSPI DSI Parallel Input Select Register 1 */
#define DSPI_6_PISR2         DSPI_6.PISR2.R                /* DSPI DSI Parallel Input Select Register 2 */
#define DSPI_6_PISR3         DSPI_6.PISR3.R                /* DSPI DSI Parallel Input Select Register 3 */
#define DSPI_6_DIMR0         DSPI_6.DIMR0.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 0 */
#define DSPI_6_DPIR0         DSPI_6.DPIR0.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 0 */
#define DSPI_6_SDR1          DSPI_6.SDR1.R                 /* DSPI DSI Serialization Data Register 1 */
#define DSPI_6_ASDR1         DSPI_6.ASDR1.R                /* DSPI DSI Alternate Serialization Data Register 1 */
#define DSPI_6_COMPR1        DSPI_6.COMPR1.R               /* DSPI DSI Transmit Comparison Register 1 */
#define DSPI_6_DDR1          DSPI_6.DDR1.R                 /* DSPI DSI Deserialization Data Register 1 */
#define DSPI_6_SSR1          DSPI_6.SSR1.R                 /* DSPI DSI Serialization Source Select Register 1 */
#define DSPI_6_PISR4         DSPI_6.PISR4.R                /* DSPI DSI Parallel Input Select Register 4 */
#define DSPI_6_PISR5         DSPI_6.PISR5.R                /* DSPI DSI Parallel Input Select Register 5 */
#define DSPI_6_PISR6         DSPI_6.PISR6.R                /* DSPI DSI Parallel Input Select Register 6 */
#define DSPI_6_PISR7         DSPI_6.PISR7.R                /* DSPI DSI Parallel Input Select Register 7 */
#define DSPI_6_DIMR1         DSPI_6.DIMR1.R                /* DSPI DSI Deserialized Data Interrupt Mask Register 1 */
#define DSPI_6_DPIR1         DSPI_6.DPIR1.R                /* DSPI DSI Deserialized Data Polarity Interrupt Register 1 */
#define DSPI_6_CTARE0        DSPI_6.CTARE[0].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE1        DSPI_6.CTARE[1].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE2        DSPI_6.CTARE[2].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE3        DSPI_6.CTARE[3].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE4        DSPI_6.CTARE[4].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE5        DSPI_6.CTARE[5].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE6        DSPI_6.CTARE[6].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_CTARE7        DSPI_6.CTARE[7].R             /* DSPI Clock and Transfer Attributes Register Extended */
#define DSPI_6_SREX          DSPI_6.SREX.R                 /* DSPI Status Register Extended */

/* DTS */
#define DTS_ENABLE           DTS.ENABLE.R                  /* Output Enable Register */
#define DTS_STARTUP          DTS.STARTUP.R                 /* Startup Register */
#define DTS_SEMAPHORE        DTS.SEMAPHORE.R               /* Semaphore Register */
#define DTS_SEMAPHORE_B      DTS.SEMAPHORE_B.R             /* Semaphore Extension */

/* EBI */
#define EBI_MCR              EBI.MCR.R                     /* Module Configuration Register */
#define EBI_BR0              EBI.BR0.R                     /* Base Register Bank */
#define EBI_OR0              EBI.OR0.R                     /* Option Register Bank */
#define EBI_BR1              EBI.BR1.R                     /* Base Register Bank */
#define EBI_OR1              EBI.OR1.R                     /* Option Register Bank */
#define EBI_BR2              EBI.BR2.R                     /* Base Register Bank */
#define EBI_OR2              EBI.OR2.R                     /* Option Register Bank */
#define EBI_BR3              EBI.BR3.R                     /* Base Register Bank */
#define EBI_OR3              EBI.OR3.R                     /* Option Register Bank */

/* FCCU */
#define FCCU_CTRL            FCCU.CTRL.R                   /* Control Register */
#define FCCU_CTRLK           FCCU.CTRLK.R                  /* CTRL Key Register */
#define FCCU_CFG             FCCU.CFG.R                    /* Configuration Register */
#define FCCU_RF_CFG0         FCCU.RF_CFG[0].R              /* RF Configuration Register */
#define FCCU_RF_CFG1         FCCU.RF_CFG[1].R              /* RF Configuration Register */
#define FCCU_RF_CFG2         FCCU.RF_CFG[2].R              /* RF Configuration Register */
#define FCCU_RF_CFG3         FCCU.RF_CFG[3].R              /* RF Configuration Register */
#define FCCU_RFS_CFG0        FCCU.RFS_CFG[0].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG1        FCCU.RFS_CFG[1].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG2        FCCU.RFS_CFG[2].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG3        FCCU.RFS_CFG[3].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG4        FCCU.RFS_CFG[4].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG5        FCCU.RFS_CFG[5].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG6        FCCU.RFS_CFG[6].R             /* RFS Configuration Register */
#define FCCU_RFS_CFG7        FCCU.RFS_CFG[7].R             /* RFS Configuration Register */
#define FCCU_RF_S0           FCCU.RF_S[0].R                /* UF Status Register */
#define FCCU_RF_S1           FCCU.RF_S[1].R                /* UF Status Register */
#define FCCU_RF_S2           FCCU.RF_S[2].R                /* UF Status Register */
#define FCCU_RF_S3           FCCU.RF_S[3].R                /* UF Status Register */
#define FCCU_RFK             FCCU.RFK.R                    /* RF Key Register */
#define FCCU_RF_E0           FCCU.RF_E[0].R                /* RF Enable Register */
#define FCCU_RF_E1           FCCU.RF_E[1].R                /* RF Enable Register */
#define FCCU_RF_E2           FCCU.RF_E[2].R                /* RF Enable Register */
#define FCCU_RF_E3           FCCU.RF_E[3].R                /* RF Enable Register */
#define FCCU_RF_TOE0         FCCU.RF_TOE[0].R              /* RF Time-out Enable Register */
#define FCCU_RF_TOE1         FCCU.RF_TOE[1].R              /* RF Time-out Enable Register */
#define FCCU_RF_TOE2         FCCU.RF_TOE[2].R              /* RF Time-out Enable Register */
#define FCCU_RF_TOE3         FCCU.RF_TOE[3].R              /* RF Time-out Enable Register */
#define FCCU_RF_TO           FCCU.RF_TO.R                  /* RF Time-out Register */
#define FCCU_CFG_TO          FCCU.CFG_TO.R                 /* CFG Timeout Register */
#define FCCU_EINOUT          FCCU.EINOUT.R                 /* IO Control Register */
#define FCCU_STAT            FCCU.STAT.R                   /* Status Register */
#define FCCU_N2AF_STATUS     FCCU.N2AF_STATUS.R            /* NA Freeze Status Register */
#define FCCU_A2FF_STATUS     FCCU.A2FF_STATUS.R            /* AF Freeze Status Register */
#define FCCU_N2FF_STATUS     FCCU.N2FF_STATUS.R            /* NF Freeze Status Register */
#define FCCU_F2A_STATUS      FCCU.F2A_STATUS.R             /* FA Freeze Status Register */
#define FCCU_RFF             FCCU.RFF.R                    /* RF Fake Register */
#define FCCU_IRQ_STAT        FCCU.IRQ_STAT.R               /* IRQ Status Register */
#define FCCU_IRQ_EN          FCCU.IRQ_EN.R                 /* IRQ Enable Register */
#define FCCU_XTMR            FCCU.XTMR.R                   /* XTMR Register */
#define FCCU_MCS             FCCU.MCS.R                    /* MCS Register */
#define FCCU_TRANS_LOCK      FCCU.TRANS_LOCK.R             /* Transient Lock Register */
#define FCCU_PERMNT_LOCK     FCCU.PERMNT_LOCK.R            /* Permanent Lock Register */
#define FCCU_DELTA_T         FCCU.DELTA_T.R                /* Delta T Register */
#define FCCU_IRQ_ALARM_EN0   FCCU.IRQ_ALARM_EN[0].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN1   FCCU.IRQ_ALARM_EN[1].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN2   FCCU.IRQ_ALARM_EN[2].R        /* IRQ Alarm Enable Register */
#define FCCU_IRQ_ALARM_EN3   FCCU.IRQ_ALARM_EN[3].R        /* IRQ Alarm Enable Register */
#define FCCU_NMI_EN0         FCCU.NMI_EN[0].R              /* NMI Enable Register */
#define FCCU_NMI_EN1         FCCU.NMI_EN[1].R              /* NMI Enable Register */
#define FCCU_NMI_EN2         FCCU.NMI_EN[2].R              /* NMI Enable Register */
#define FCCU_NMI_EN3         FCCU.NMI_EN[3].R              /* NMI Enable Register */
#define FCCU_EOUT_SIG_EN0    FCCU.EOUT_SIG_EN[0].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN1    FCCU.EOUT_SIG_EN[1].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN2    FCCU.EOUT_SIG_EN[2].R         /* EOUT Signaling Enable Register */
#define FCCU_EOUT_SIG_EN3    FCCU.EOUT_SIG_EN[3].R         /* EOUT Signaling Enable Register */

/* FEC */
#define FEC_EIR              FEC.EIR.R                     /* Interrupt Event Register */
#define FEC_EIMR             FEC.EIMR.R                    /* Interrupt Mask Register */
#define FEC_RDAR             FEC.RDAR.R                    /* Receive Descriptor Active Register */
#define FEC_TDAR             FEC.TDAR.R                    /* Transmit Descriptor Active Register */
#define FEC_ECR              FEC.ECR.R                     /* Ethernet Control Register */
#define FEC_MMFR             FEC.MMFR.R                    /* MII Management Frame Register */
#define FEC_MSCR             FEC.MSCR.R                    /* MII Speed Control Register */
#define FEC_MIBC             FEC.MIBC.R                    /* MIB Control Register */
#define FEC_RCR              FEC.RCR.R                     /* Receive Control Register */
#define FEC_TCR              FEC.TCR.R                     /* Transmit Control Register */
#define FEC_PALR             FEC.PALR.R                    /* Physical Address Low Register */
#define FEC_PAUR             FEC.PAUR.R                    /* Physical Address High Register and Type Field */
#define FEC_OPD              FEC.OPD.R                     /* Opcode/Pause Duration */
#define FEC_IAUR             FEC.IAUR.R                    /* Descriptor Individual Upper Address Register */
#define FEC_IALR             FEC.IALR.R                    /* Descriptor Individual Lower Address Register */
#define FEC_GAUR             FEC.GAUR.R                    /* Descriptor Group Upper Address Register */
#define FEC_GALR             FEC.GALR.R                    /* Descriptor Group Lower Address Register */
#define FEC_TFWR             FEC.TFWR.R                    /* Transmit FIFO Watermark */
#define FEC_FRBR             FEC.FRBR.R                    /* FIFO Receive Bound Register */
#define FEC_FRSR             FEC.FRSR.R                    /* FIFO Receive Start Register */
#define FEC_ERDSR            FEC.ERDSR.R                   /* Receive Descriptor Ring Start Register */
#define FEC_ETDSR            FEC.ETDSR.R                   /* Transmit Buffer Descriptor Ring Start Register */
#define FEC_EMRBR            FEC.EMRBR.R                   /* Receive Buffer Size Register */
#define FEC_RMON_T_DROP      FEC.RMON_T_DROP.R             /* Count of frames not counted correctly */
#define FEC_RMON_T_PACKETS   FEC.RMON_T_PACKETS.R          /* RMON Tx packet count */
#define FEC_RMON_T_BC_PKT    FEC.RMON_T_BC_PKT.R           /* RMON Tx broadcast packets */
#define FEC_RMON_T_MC_PKT    FEC.RMON_T_MC_PKT.R           /* RMON Tx multicast packets */
#define FEC_RMON_T_CRC_ALIGN FEC.RMON_T_CRC_ALIGN.R        /* RMON Tx packets with CRC/align error */
#define FEC_RMON_T_UNDERSIZE FEC.RMON_T_UNDERSIZE.R        /* RMON Tx packets < 64 bytes, good CRC */
#define FEC_RMON_T_OVERSIZE  FEC.RMON_T_OVERSIZE.R         /* RMON Tx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_T_FRAG      FEC.RMON_T_FRAG.R             /* RMON Tx packets < 64 bytes, bad CRC */
#define FEC_RMON_T_JAB       FEC.RMON_T_JAB.R              /* RMON Tx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_T_COL       FEC.RMON_T_COL.R              /* RMON Tx collision count */
#define FEC_RMON_T_P64       FEC.RMON_T_P64.R              /* RMON Tx 64 byte packets */
#define FEC_RMON_T_P65TO127  FEC.RMON_T_P65TO127.R         /* RMON Tx 65 to 127 byte packets */
#define FEC_RMON_T_P128TO255 FEC.RMON_T_P128TO255.R        /* RMON Tx 128 to 255 byte packets */
#define FEC_RMON_T_P256TO511 FEC.RMON_T_P256TO511.R        /* RMON Tx 256 to 511 byte packets */
#define FEC_RMON_T_P512TO1023 FEC.RMON_T_P512TO1023.R      /* RMON Tx 512 to 1023 byte packets */
#define FEC_RMON_T_P1024TO2047 FEC.RMON_T_P1024TO2047.R    /* RMON Tx 1024 to 2047 byte packets */
#define FEC_RMON_T_P_GTE2048 FEC.RMON_T_P_GTE2048.R        /* RMON Tx packets with > 2048 bytes */
#define FEC_RMON_T_OCTETS    FEC.RMON_T_OCTETS.R           /* RMON Tx Octets */
#define FEC_IEEE_T_DROP      FEC.IEEE_T_DROP.R             /* Count of transmitted frames not counted correctly */
#define FEC_IEEE_T_FRAME_OK  FEC.IEEE_T_FRAME_OK.R         /* Frames transmitted OK */
#define FEC_IEEE_T_1COL      FEC.IEEE_T_1COL.R             /* Frames transmitted with single collision */
#define FEC_IEEE_T_MCOL      FEC.IEEE_T_MCOL.R             /* Frames transmitted with multiple collisions */
#define FEC_IEEE_T_DEF       FEC.IEEE_T_DEF.R              /* Frames transmitted after deferral delay */
#define FEC_IEEE_T_LCOL      FEC.IEEE_T_LCOL.R             /* Frames transmitted with late collision */
#define FEC_IEEE_T_EXCOL     FEC.IEEE_T_EXCOL.R            /* Frames transmitted with excessive collisions */
#define FEC_IEEE_T_MACERR    FEC.IEEE_T_MACERR.R           /* Frames transmitted with Tx FIFO underrun */
#define FEC_IEEE_T_CSERR     FEC.IEEE_T_CSERR.R            /* Frames transmitted with carrier sense error */
#define FEC_IEEE_T_SQE       FEC.IEEE_T_SQE.R              /* Frames transmitted with SQE error */
#define FEC_IEEE_T_FDXFC     FEC.IEEE_T_FDXFC.R            /* Flow control pause frames transmitted */
#define FEC_IEEE_T_OCTETS_OK FEC.IEEE_T_OCTETS_OK.R        /* Octet count for frames transmitted without error */
#define FEC_RMON_R_DROP      FEC.RMON_R_DROP.R             /* Count of received frames not counted correctly */
#define FEC_RMON_R_PACKETS   FEC.RMON_R_PACKETS.R          /* RMON Rx packet count */
#define FEC_RMON_R_BC_PKT    FEC.RMON_R_BC_PKT.R           /* RMON Rx broadcast packets */
#define FEC_RMON_R_MC_PKT    FEC.RMON_R_MC_PKT.R           /* RMON Rx multicast packets */
#define FEC_RMON_R_CRC_ALIGN FEC.RMON_R_CRC_ALIGN.R        /* RMON Rx packets with CRC/Align error */
#define FEC_RMON_R_UNDERSIZE FEC.RMON_R_UNDERSIZE.R        /* RMON Rx packets < 64 bytes, good CRC */
#define FEC_RMON_R_OVERSIZE  FEC.RMON_R_OVERSIZE.R         /* RMON Rx packets > MAX_FL bytes, good CRC */
#define FEC_RMON_R_FRAG      FEC.RMON_R_FRAG.R             /* RMON Rx packets < 64 bytes, bad CRC */
#define FEC_RMON_R_JAB       FEC.RMON_R_JAB.R              /* RMON Rx packets > MAX_FL bytes, bad CRC */
#define FEC_RMON_R_RESVD_0   FEC.RMON_R_RESVD_0.R          /* Reserved */
#define FEC_RMON_R_P64       FEC.RMON_R_P64.R              /* RMON Rx 64 byte packets */
#define FEC_RMON_R_P65TO127  FEC.RMON_R_P65TO127.R         /* RMON Rx 65 to 127 byte packets */
#define FEC_RMON_R_P128TO255 FEC.RMON_R_P128TO255.R        /* RMON Rx 128 to 255 byte packets */
#define FEC_RMON_R_P256TO511 FEC.RMON_R_P256TO511.R        /* RMON Rx 256 to 511 byte packets */
#define FEC_RMON_R_P512TO1023 FEC.RMON_R_P512TO1023.R      /* RMON Rx 512 to 1023 byte packets */
#define FEC_RMON_R_P1024TO2047 FEC.RMON_R_P1024TO2047.R    /* RMON Rx 1024 to 2047 byte packets */
#define FEC_RMON_R_P_GTE2048 FEC.RMON_R_P_GTE2048.R        /* RMON Rx packets with > 2048 bytes */
#define FEC_RMON_R_OCTETS    FEC.RMON_R_OCTETS.R           /* RMON Rx octets */
#define FEC_IEEE_R_DROP      FEC.IEEE_R_DROP.R             /* Count of received frames not counted correctly */
#define FEC_IEEE_R_FRAME_OK  FEC.IEEE_R_FRAME_OK.R         /* Frames received OK */
#define FEC_IEEE_R_CRC       FEC.IEEE_R_CRC.R              /* Frames received with CRC error */
#define FEC_IEEE_R_ALIGN     FEC.IEEE_R_ALIGN.R            /* Frames received with alignment error */
#define FEC_IEEE_R_MACERR    FEC.IEEE_R_MACERR.R           /* Receive FIFO overflow count */
#define FEC_IEEE_R_FDXFC     FEC.IEEE_R_FDXFC.R            /* Flow control pause frames received */
#define FEC_IEEE_R_OCTETS_OK FEC.IEEE_R_OCTETS_OK.R        /* Octet count for frames received without error */

/* FR */
#define FR_0_MVR             FR_0.MVR.R                    /* Module Version Register */
#define FR_0_MCR             FR_0.MCR.R                    /* Module Configuration Register */
#define FR_0_SYMBADHR        FR_0.SYMBADHR.R               /* System Memory Base Address High Register */
#define FR_0_SYMBADLR        FR_0.SYMBADLR.R               /* System Memory Base Address Low Register */
#define FR_0_STBSCR          FR_0.STBSCR.R                 /* Strobe Signal Control Register */
#define FR_0_MBDSR           FR_0.MBDSR.R                  /* Message Buffer Data Size Register */
#define FR_0_MBSSUTR         FR_0.MBSSUTR.R                /* Message Buffer Segment Size and Utilization Register */
#define FR_0_PEDRAR          FR_0.PEDRAR.R                 /* PE DRAM Access Register */
#define FR_0_PEDRDR          FR_0.PEDRDR.R                 /* PE DRAM Data Register */
#define FR_0_POCR            FR_0.POCR.R                   /* Protocol Operation Control Register */
#define FR_0_GIFER           FR_0.GIFER.R                  /* Global Interrupt Flag and Enable Register */
#define FR_0_PIFR0           FR_0.PIFR0.R                  /* Protocol Interrupt Flag Register 0 */
#define FR_0_PIFR1           FR_0.PIFR1.R                  /* Protocol Interrupt Flag Register 1 */
#define FR_0_PIER0           FR_0.PIER0.R                  /* Protocol Interrupt Enable Register 0 */
#define FR_0_PIER1           FR_0.PIER1.R                  /* Protocol Interrupt Enable Register 1 */
#define FR_0_CHIERFR         FR_0.CHIERFR.R                /* CHI Error Flag Register */
#define FR_0_MBIVEC          FR_0.MBIVEC.R                 /* Message Buffer Interrupt Vector Register */
#define FR_0_CASERCR         FR_0.CASERCR.R                /* Channel A Status Error Counter Register */
#define FR_0_CBSERCR         FR_0.CBSERCR.R                /* Channel B Status Error Counter Register */
#define FR_0_PSR0            FR_0.PSR0.R                   /* Protocol Status Register 0 */
#define FR_0_PSR1            FR_0.PSR1.R                   /* Protocol Status Register 1 */
#define FR_0_PSR2            FR_0.PSR2.R                   /* Protocol Status Register 2 */
#define FR_0_PSR3            FR_0.PSR3.R                   /* Protocol Status Register 3 */
#define FR_0_MTCTR           FR_0.MTCTR.R                  /* Macrotick Counter Register */
#define FR_0_CYCTR           FR_0.CYCTR.R                  /* Cycle Counter Register */
#define FR_0_SLTCTAR         FR_0.SLTCTAR.R                /* Slot Counter Channel A Register */
#define FR_0_SLTCTBR         FR_0.SLTCTBR.R                /* Slot Counter Channel B Register */
#define FR_0_RTCORVR         FR_0.RTCORVR.R                /* Rate Correction Value Register */
#define FR_0_OFCORVR         FR_0.OFCORVR.R                /* Offset Correction Value Register */
#define FR_0_CIFR            FR_0.CIFR.R                   /* Combined Interrupt Flag Register */
#define FR_0_SYMATOR         FR_0.SYMATOR.R                /* System Memory Access Time-Out Register */
#define FR_0_SFCNTR          FR_0.SFCNTR.R                 /* Sync Frame Counter Register */
#define FR_0_SFTOR           FR_0.SFTOR.R                  /* Sync Frame Table Offset Register */
#define FR_0_SFTCCSR         FR_0.SFTCCSR.R                /* Sync Frame Table Configuration, Control, Status Register */
#define FR_0_SFIDRFR         FR_0.SFIDRFR.R                /* Sync Frame ID Rejection Filter Register */
#define FR_0_SFIDAFVR        FR_0.SFIDAFVR.R               /* Sync Frame ID Acceptance Filter Value Register */
#define FR_0_SFIDAFMR        FR_0.SFIDAFMR.R               /* Sync Frame ID Acceptance Filter Mask Register */
#define FR_0_NMVR0           FR_0.NMVR[0].R                /* Network Management Vector Register */
#define FR_0_NMVR1           FR_0.NMVR[1].R                /* Network Management Vector Register */
#define FR_0_NMVR2           FR_0.NMVR[2].R                /* Network Management Vector Register */
#define FR_0_NMVR3           FR_0.NMVR[3].R                /* Network Management Vector Register */
#define FR_0_NMVR4           FR_0.NMVR[4].R                /* Network Management Vector Register */
#define FR_0_NMVR5           FR_0.NMVR[5].R                /* Network Management Vector Register */
#define FR_0_NMVLR           FR_0.NMVLR.R                  /* Network Management Vector Length Register */
#define FR_0_TICCR           FR_0.TICCR.R                  /* Timer Configuration and Control Register */
#define FR_0_TI1CYSR         FR_0.TI1CYSR.R                /* Timer 1 Cycle Set Register */
#define FR_0_TI1MTOR         FR_0.TI1MTOR.R                /* Timer 1 Macrotick Offset Register */
#define FR_0_TI2CR0_ABS      FR_0.TI2CR0.ABS.R             /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
#define FR_0_TI2CR0_REL      FR_0.TI2CR0.REL.R             /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
#define FR_0_TI2CR1_ABS      FR_0.TI2CR1.ABS.R             /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
#define FR_0_TI2CR1_REL      FR_0.TI2CR1.REL.R             /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
#define FR_0_SSSR            FR_0.SSSR.R                   /* Slot Status Selection Register */
#define FR_0_SSCCR           FR_0.SSCCR.R                  /* Slot Status Counter Condition Register */
#define FR_0_SSR0            FR_0.SSR[0].R                 /* Slot Status Register */
#define FR_0_SSR1            FR_0.SSR[1].R                 /* Slot Status Register */
#define FR_0_SSR2            FR_0.SSR[2].R                 /* Slot Status Register */
#define FR_0_SSR3            FR_0.SSR[3].R                 /* Slot Status Register */
#define FR_0_SSR4            FR_0.SSR[4].R                 /* Slot Status Register */
#define FR_0_SSR5            FR_0.SSR[5].R                 /* Slot Status Register */
#define FR_0_SSR6            FR_0.SSR[6].R                 /* Slot Status Register */
#define FR_0_SSR7            FR_0.SSR[7].R                 /* Slot Status Register */
#define FR_0_SSCR0           FR_0.SSCR[0].R                /* Slot Status Counter Register */
#define FR_0_SSCR1           FR_0.SSCR[1].R                /* Slot Status Counter Register */
#define FR_0_SSCR2           FR_0.SSCR[2].R                /* Slot Status Counter Register */
#define FR_0_SSCR3           FR_0.SSCR[3].R                /* Slot Status Counter Register */
#define FR_0_MTSACFR         FR_0.MTSACFR.R                /* MTS A Configuration Register */
#define FR_0_MTSBCFR         FR_0.MTSBCFR.R                /* MTS B Configuration Register */
#define FR_0_RSBIR           FR_0.RSBIR.R                  /* Receive Shadow Buffer Index Register */
#define FR_0_RFWMSR          FR_0.RFWMSR.R                 /* Receive FIFO Watermark and Selection Register */
#define FR_0_RFSIR           FR_0.RFSIR.R                  /* Receive FIFO Start Index Register */
#define FR_0_RFDSR           FR_0.RFDSR.R                  /* Receive FIFO Depth and Size Register */
#define FR_0_RFARIR          FR_0.RFARIR.R                 /* Receive FIFO A Read Index Register */
#define FR_0_RFBRIR          FR_0.RFBRIR.R                 /* Receive FIFO B Read Index Register */
#define FR_0_RFMIDAFVR       FR_0.RFMIDAFVR.R              /* Receive FIFO Message ID Acceptance Filter Value Register */
#define FR_0_RFMIDAFMR       FR_0.RFMIDAFMR.R              /* Receive FIFO Message ID Acceptance Filter Mask Register */
#define FR_0_RFFIDRFVR       FR_0.RFFIDRFVR.R              /* Receive FIFO Frame ID Rejection Filter Value Register */
#define FR_0_RFFIDRFMR       FR_0.RFFIDRFMR.R              /* Receive FIFO Frame ID Rejection Filter Mask Register */
#define FR_0_RFRFCFR         FR_0.RFRFCFR.R                /* Receive FIFO Range Filter Configuration Register */
#define FR_0_RFRFCTR         FR_0.RFRFCTR.R                /* Receive FIFO Range Filter Control Register */
#define FR_0_LDTXSLAR        FR_0.LDTXSLAR.R               /* Last Dynamic Transmit Slot Channel A Register */
#define FR_0_LDTXSLBR        FR_0.LDTXSLBR.R               /* Last Dynamic Transmit Slot Channel B Register */
#define FR_0_PCR0            FR_0.PCR0.R                   /* Protocol Configuration Register 0 */
#define FR_0_PCR1            FR_0.PCR1.R                   /* Protocol Configuration Register 1 */
#define FR_0_PCR2            FR_0.PCR2.R                   /* Protocol Configuration Register 2 */
#define FR_0_PCR3            FR_0.PCR3.R                   /* Protocol Configuration Register 3 */
#define FR_0_PCR4            FR_0.PCR4.R                   /* Protocol Configuration Register 4 */
#define FR_0_PCR5            FR_0.PCR5.R                   /* Protocol Configuration Register 5 */
#define FR_0_PCR6            FR_0.PCR6.R                   /* Protocol Configuration Register 6 */
#define FR_0_PCR7            FR_0.PCR7.R                   /* Protocol Configuration Register 7 */
#define FR_0_PCR8            FR_0.PCR8.R                   /* Protocol Configuration Register 8 */
#define FR_0_PCR9            FR_0.PCR9.R                   /* Protocol Configuration Register 9 */
#define FR_0_PCR10           FR_0.PCR10.R                  /* Protocol Configuration Register 10 */
#define FR_0_PCR11           FR_0.PCR11.R                  /* Protocol Configuration Register 11 */
#define FR_0_PCR12           FR_0.PCR12.R                  /* Protocol Configuration Register 12 */
#define FR_0_PCR13           FR_0.PCR13.R                  /* Protocol Configuration Register 13 */
#define FR_0_PCR14           FR_0.PCR14.R                  /* Protocol Configuration Register 14 */
#define FR_0_PCR15           FR_0.PCR15.R                  /* Protocol Configuration Register 15 */
#define FR_0_PCR16           FR_0.PCR16.R                  /* Protocol Configuration Register 16 */
#define FR_0_PCR17           FR_0.PCR17.R                  /* Protocol Configuration Register 17 */
#define FR_0_PCR18           FR_0.PCR18.R                  /* Protocol Configuration Register 18 */
#define FR_0_PCR19           FR_0.PCR19.R                  /* Protocol Configuration Register 19 */
#define FR_0_PCR20           FR_0.PCR20.R                  /* Protocol Configuration Register 20 */
#define FR_0_PCR21           FR_0.PCR21.R                  /* Protocol Configuration Register 21 */
#define FR_0_PCR22           FR_0.PCR22.R                  /* Protocol Configuration Register 22 */
#define FR_0_PCR23           FR_0.PCR23.R                  /* Protocol Configuration Register 23 */
#define FR_0_PCR24           FR_0.PCR24.R                  /* Protocol Configuration Register 24 */
#define FR_0_PCR25           FR_0.PCR25.R                  /* Protocol Configuration Register 25 */
#define FR_0_PCR26           FR_0.PCR26.R                  /* Protocol Configuration Register 26 */
#define FR_0_PCR27           FR_0.PCR27.R                  /* Protocol Configuration Register 27 */
#define FR_0_PCR28           FR_0.PCR28.R                  /* Protocol Configuration Register 28 */
#define FR_0_PCR29           FR_0.PCR29.R                  /* Protocol Configuration Register 29 */
#define FR_0_PCR30           FR_0.PCR30.R                  /* Protocol Configuration Register 30 */
#define FR_0_STPWR           FR_0.STPWR.R                  /* StopWatch Count Register */
#define FR_0_PEOER           FR_0.PEOER.R                  /* Protocol Event Output Enable and StopWatch Control Register */
#define FR_0_RFSDOR          FR_0.RFSDOR.R                 /* Receive FIFO Start Data Offset Register */
#define FR_0_RFSYMBADHR      FR_0.RFSYMBADHR.R             /* Receive FIFO System Memory Base Address High Register */
#define FR_0_RFSYMBADLR      FR_0.RFSYMBADLR.R             /* Receive FIFO System Memory Base Address Low Register */
#define FR_0_RFPTR           FR_0.RFPTR.R                  /* Receive FIFO Periodic Timer Register */
#define FR_0_RFFLPCR         FR_0.RFFLPCR.R                /* Receive FIFO Fill Level and POP Count Register */
#define FR_0_EEIFER          FR_0.EEIFER.R                 /* ECC Error Interrupt Flag and Enable Register */
#define FR_0_EERICR          FR_0.EERICR.R                 /* ECC Error Report and Injection Control Register */
#define FR_0_EERAR           FR_0.EERAR.R                  /* ECC Error Report Address Register */
#define FR_0_EERDR           FR_0.EERDR.R                  /* ECC Error Report Data Register */
#define FR_0_EERCR           FR_0.EERCR.R                  /* ECC Error Report Code Register */
#define FR_0_EEIAR           FR_0.EEIAR.R                  /* ECC Error Injection Address Register */
#define FR_0_EEIDR           FR_0.EEIDR.R                  /* ECC Error Injection Data Register */
#define FR_0_EEICR           FR_0.EEICR.R                  /* ECC Error Injection Code Register */
#define FR_0_MBCCSR0         FR_0.MB[0].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR0         FR_0.MB[0].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR0         FR_0.MB[0].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR0         FR_0.MB[0].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR1         FR_0.MB[1].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR1         FR_0.MB[1].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR1         FR_0.MB[1].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR1         FR_0.MB[1].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR2         FR_0.MB[2].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR2         FR_0.MB[2].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR2         FR_0.MB[2].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR2         FR_0.MB[2].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR3         FR_0.MB[3].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR3         FR_0.MB[3].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR3         FR_0.MB[3].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR3         FR_0.MB[3].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR4         FR_0.MB[4].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR4         FR_0.MB[4].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR4         FR_0.MB[4].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR4         FR_0.MB[4].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR5         FR_0.MB[5].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR5         FR_0.MB[5].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR5         FR_0.MB[5].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR5         FR_0.MB[5].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR6         FR_0.MB[6].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR6         FR_0.MB[6].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR6         FR_0.MB[6].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR6         FR_0.MB[6].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR7         FR_0.MB[7].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR7         FR_0.MB[7].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR7         FR_0.MB[7].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR7         FR_0.MB[7].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR8         FR_0.MB[8].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR8         FR_0.MB[8].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR8         FR_0.MB[8].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR8         FR_0.MB[8].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR9         FR_0.MB[9].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR9         FR_0.MB[9].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR9         FR_0.MB[9].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR9         FR_0.MB[9].IDXR.R             /* Message Buffer Index Register */
#define FR_0_MBCCSR10        FR_0.MB[10].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR10        FR_0.MB[10].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR10        FR_0.MB[10].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR10        FR_0.MB[10].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR11        FR_0.MB[11].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR11        FR_0.MB[11].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR11        FR_0.MB[11].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR11        FR_0.MB[11].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR12        FR_0.MB[12].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR12        FR_0.MB[12].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR12        FR_0.MB[12].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR12        FR_0.MB[12].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR13        FR_0.MB[13].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR13        FR_0.MB[13].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR13        FR_0.MB[13].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR13        FR_0.MB[13].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR14        FR_0.MB[14].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR14        FR_0.MB[14].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR14        FR_0.MB[14].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR14        FR_0.MB[14].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR15        FR_0.MB[15].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR15        FR_0.MB[15].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR15        FR_0.MB[15].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR15        FR_0.MB[15].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR16        FR_0.MB[16].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR16        FR_0.MB[16].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR16        FR_0.MB[16].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR16        FR_0.MB[16].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR17        FR_0.MB[17].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR17        FR_0.MB[17].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR17        FR_0.MB[17].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR17        FR_0.MB[17].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR18        FR_0.MB[18].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR18        FR_0.MB[18].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR18        FR_0.MB[18].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR18        FR_0.MB[18].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR19        FR_0.MB[19].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR19        FR_0.MB[19].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR19        FR_0.MB[19].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR19        FR_0.MB[19].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR20        FR_0.MB[20].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR20        FR_0.MB[20].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR20        FR_0.MB[20].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR20        FR_0.MB[20].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR21        FR_0.MB[21].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR21        FR_0.MB[21].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR21        FR_0.MB[21].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR21        FR_0.MB[21].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR22        FR_0.MB[22].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR22        FR_0.MB[22].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR22        FR_0.MB[22].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR22        FR_0.MB[22].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR23        FR_0.MB[23].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR23        FR_0.MB[23].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR23        FR_0.MB[23].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR23        FR_0.MB[23].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR24        FR_0.MB[24].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR24        FR_0.MB[24].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR24        FR_0.MB[24].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR24        FR_0.MB[24].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR25        FR_0.MB[25].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR25        FR_0.MB[25].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR25        FR_0.MB[25].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR25        FR_0.MB[25].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR26        FR_0.MB[26].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR26        FR_0.MB[26].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR26        FR_0.MB[26].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR26        FR_0.MB[26].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR27        FR_0.MB[27].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR27        FR_0.MB[27].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR27        FR_0.MB[27].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR27        FR_0.MB[27].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR28        FR_0.MB[28].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR28        FR_0.MB[28].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR28        FR_0.MB[28].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR28        FR_0.MB[28].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR29        FR_0.MB[29].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR29        FR_0.MB[29].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR29        FR_0.MB[29].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR29        FR_0.MB[29].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR30        FR_0.MB[30].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR30        FR_0.MB[30].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR30        FR_0.MB[30].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR30        FR_0.MB[30].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR31        FR_0.MB[31].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR31        FR_0.MB[31].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR31        FR_0.MB[31].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR31        FR_0.MB[31].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR32        FR_0.MB[32].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR32        FR_0.MB[32].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR32        FR_0.MB[32].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR32        FR_0.MB[32].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR33        FR_0.MB[33].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR33        FR_0.MB[33].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR33        FR_0.MB[33].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR33        FR_0.MB[33].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR34        FR_0.MB[34].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR34        FR_0.MB[34].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR34        FR_0.MB[34].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR34        FR_0.MB[34].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR35        FR_0.MB[35].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR35        FR_0.MB[35].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR35        FR_0.MB[35].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR35        FR_0.MB[35].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR36        FR_0.MB[36].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR36        FR_0.MB[36].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR36        FR_0.MB[36].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR36        FR_0.MB[36].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR37        FR_0.MB[37].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR37        FR_0.MB[37].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR37        FR_0.MB[37].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR37        FR_0.MB[37].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR38        FR_0.MB[38].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR38        FR_0.MB[38].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR38        FR_0.MB[38].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR38        FR_0.MB[38].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR39        FR_0.MB[39].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR39        FR_0.MB[39].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR39        FR_0.MB[39].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR39        FR_0.MB[39].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR40        FR_0.MB[40].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR40        FR_0.MB[40].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR40        FR_0.MB[40].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR40        FR_0.MB[40].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR41        FR_0.MB[41].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR41        FR_0.MB[41].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR41        FR_0.MB[41].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR41        FR_0.MB[41].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR42        FR_0.MB[42].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR42        FR_0.MB[42].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR42        FR_0.MB[42].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR42        FR_0.MB[42].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR43        FR_0.MB[43].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR43        FR_0.MB[43].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR43        FR_0.MB[43].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR43        FR_0.MB[43].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR44        FR_0.MB[44].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR44        FR_0.MB[44].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR44        FR_0.MB[44].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR44        FR_0.MB[44].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR45        FR_0.MB[45].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR45        FR_0.MB[45].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR45        FR_0.MB[45].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR45        FR_0.MB[45].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR46        FR_0.MB[46].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR46        FR_0.MB[46].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR46        FR_0.MB[46].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR46        FR_0.MB[46].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR47        FR_0.MB[47].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR47        FR_0.MB[47].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR47        FR_0.MB[47].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR47        FR_0.MB[47].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR48        FR_0.MB[48].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR48        FR_0.MB[48].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR48        FR_0.MB[48].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR48        FR_0.MB[48].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR49        FR_0.MB[49].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR49        FR_0.MB[49].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR49        FR_0.MB[49].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR49        FR_0.MB[49].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR50        FR_0.MB[50].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR50        FR_0.MB[50].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR50        FR_0.MB[50].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR50        FR_0.MB[50].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR51        FR_0.MB[51].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR51        FR_0.MB[51].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR51        FR_0.MB[51].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR51        FR_0.MB[51].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR52        FR_0.MB[52].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR52        FR_0.MB[52].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR52        FR_0.MB[52].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR52        FR_0.MB[52].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR53        FR_0.MB[53].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR53        FR_0.MB[53].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR53        FR_0.MB[53].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR53        FR_0.MB[53].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR54        FR_0.MB[54].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR54        FR_0.MB[54].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR54        FR_0.MB[54].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR54        FR_0.MB[54].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR55        FR_0.MB[55].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR55        FR_0.MB[55].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR55        FR_0.MB[55].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR55        FR_0.MB[55].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR56        FR_0.MB[56].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR56        FR_0.MB[56].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR56        FR_0.MB[56].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR56        FR_0.MB[56].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR57        FR_0.MB[57].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR57        FR_0.MB[57].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR57        FR_0.MB[57].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR57        FR_0.MB[57].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR58        FR_0.MB[58].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR58        FR_0.MB[58].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR58        FR_0.MB[58].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR58        FR_0.MB[58].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR59        FR_0.MB[59].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR59        FR_0.MB[59].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR59        FR_0.MB[59].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR59        FR_0.MB[59].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR60        FR_0.MB[60].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR60        FR_0.MB[60].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR60        FR_0.MB[60].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR60        FR_0.MB[60].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR61        FR_0.MB[61].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR61        FR_0.MB[61].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR61        FR_0.MB[61].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR61        FR_0.MB[61].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR62        FR_0.MB[62].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR62        FR_0.MB[62].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR62        FR_0.MB[62].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR62        FR_0.MB[62].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR63        FR_0.MB[63].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR63        FR_0.MB[63].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR63        FR_0.MB[63].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR63        FR_0.MB[63].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR64        FR_0.MB[64].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR64        FR_0.MB[64].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR64        FR_0.MB[64].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR64        FR_0.MB[64].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR65        FR_0.MB[65].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR65        FR_0.MB[65].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR65        FR_0.MB[65].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR65        FR_0.MB[65].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR66        FR_0.MB[66].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR66        FR_0.MB[66].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR66        FR_0.MB[66].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR66        FR_0.MB[66].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR67        FR_0.MB[67].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR67        FR_0.MB[67].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR67        FR_0.MB[67].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR67        FR_0.MB[67].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR68        FR_0.MB[68].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR68        FR_0.MB[68].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR68        FR_0.MB[68].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR68        FR_0.MB[68].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR69        FR_0.MB[69].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR69        FR_0.MB[69].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR69        FR_0.MB[69].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR69        FR_0.MB[69].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR70        FR_0.MB[70].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR70        FR_0.MB[70].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR70        FR_0.MB[70].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR70        FR_0.MB[70].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR71        FR_0.MB[71].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR71        FR_0.MB[71].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR71        FR_0.MB[71].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR71        FR_0.MB[71].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR72        FR_0.MB[72].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR72        FR_0.MB[72].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR72        FR_0.MB[72].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR72        FR_0.MB[72].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR73        FR_0.MB[73].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR73        FR_0.MB[73].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR73        FR_0.MB[73].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR73        FR_0.MB[73].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR74        FR_0.MB[74].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR74        FR_0.MB[74].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR74        FR_0.MB[74].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR74        FR_0.MB[74].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR75        FR_0.MB[75].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR75        FR_0.MB[75].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR75        FR_0.MB[75].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR75        FR_0.MB[75].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR76        FR_0.MB[76].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR76        FR_0.MB[76].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR76        FR_0.MB[76].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR76        FR_0.MB[76].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR77        FR_0.MB[77].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR77        FR_0.MB[77].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR77        FR_0.MB[77].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR77        FR_0.MB[77].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR78        FR_0.MB[78].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR78        FR_0.MB[78].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR78        FR_0.MB[78].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR78        FR_0.MB[78].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR79        FR_0.MB[79].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR79        FR_0.MB[79].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR79        FR_0.MB[79].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR79        FR_0.MB[79].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR80        FR_0.MB[80].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR80        FR_0.MB[80].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR80        FR_0.MB[80].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR80        FR_0.MB[80].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR81        FR_0.MB[81].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR81        FR_0.MB[81].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR81        FR_0.MB[81].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR81        FR_0.MB[81].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR82        FR_0.MB[82].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR82        FR_0.MB[82].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR82        FR_0.MB[82].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR82        FR_0.MB[82].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR83        FR_0.MB[83].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR83        FR_0.MB[83].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR83        FR_0.MB[83].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR83        FR_0.MB[83].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR84        FR_0.MB[84].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR84        FR_0.MB[84].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR84        FR_0.MB[84].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR84        FR_0.MB[84].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR85        FR_0.MB[85].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR85        FR_0.MB[85].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR85        FR_0.MB[85].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR85        FR_0.MB[85].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR86        FR_0.MB[86].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR86        FR_0.MB[86].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR86        FR_0.MB[86].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR86        FR_0.MB[86].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR87        FR_0.MB[87].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR87        FR_0.MB[87].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR87        FR_0.MB[87].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR87        FR_0.MB[87].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR88        FR_0.MB[88].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR88        FR_0.MB[88].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR88        FR_0.MB[88].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR88        FR_0.MB[88].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR89        FR_0.MB[89].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR89        FR_0.MB[89].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR89        FR_0.MB[89].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR89        FR_0.MB[89].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR90        FR_0.MB[90].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR90        FR_0.MB[90].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR90        FR_0.MB[90].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR90        FR_0.MB[90].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR91        FR_0.MB[91].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR91        FR_0.MB[91].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR91        FR_0.MB[91].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR91        FR_0.MB[91].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR92        FR_0.MB[92].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR92        FR_0.MB[92].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR92        FR_0.MB[92].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR92        FR_0.MB[92].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR93        FR_0.MB[93].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR93        FR_0.MB[93].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR93        FR_0.MB[93].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR93        FR_0.MB[93].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR94        FR_0.MB[94].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR94        FR_0.MB[94].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR94        FR_0.MB[94].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR94        FR_0.MB[94].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR95        FR_0.MB[95].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR95        FR_0.MB[95].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR95        FR_0.MB[95].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR95        FR_0.MB[95].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR96        FR_0.MB[96].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR96        FR_0.MB[96].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR96        FR_0.MB[96].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR96        FR_0.MB[96].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR97        FR_0.MB[97].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR97        FR_0.MB[97].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR97        FR_0.MB[97].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR97        FR_0.MB[97].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR98        FR_0.MB[98].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR98        FR_0.MB[98].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR98        FR_0.MB[98].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR98        FR_0.MB[98].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR99        FR_0.MB[99].CCSR.R            /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR99        FR_0.MB[99].CCFR.R            /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR99        FR_0.MB[99].FIDR.R            /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR99        FR_0.MB[99].IDXR.R            /* Message Buffer Index Register */
#define FR_0_MBCCSR100       FR_0.MB[100].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR100       FR_0.MB[100].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR100       FR_0.MB[100].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR100       FR_0.MB[100].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR101       FR_0.MB[101].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR101       FR_0.MB[101].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR101       FR_0.MB[101].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR101       FR_0.MB[101].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR102       FR_0.MB[102].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR102       FR_0.MB[102].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR102       FR_0.MB[102].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR102       FR_0.MB[102].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR103       FR_0.MB[103].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR103       FR_0.MB[103].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR103       FR_0.MB[103].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR103       FR_0.MB[103].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR104       FR_0.MB[104].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR104       FR_0.MB[104].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR104       FR_0.MB[104].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR104       FR_0.MB[104].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR105       FR_0.MB[105].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR105       FR_0.MB[105].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR105       FR_0.MB[105].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR105       FR_0.MB[105].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR106       FR_0.MB[106].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR106       FR_0.MB[106].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR106       FR_0.MB[106].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR106       FR_0.MB[106].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR107       FR_0.MB[107].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR107       FR_0.MB[107].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR107       FR_0.MB[107].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR107       FR_0.MB[107].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR108       FR_0.MB[108].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR108       FR_0.MB[108].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR108       FR_0.MB[108].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR108       FR_0.MB[108].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR109       FR_0.MB[109].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR109       FR_0.MB[109].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR109       FR_0.MB[109].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR109       FR_0.MB[109].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR110       FR_0.MB[110].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR110       FR_0.MB[110].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR110       FR_0.MB[110].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR110       FR_0.MB[110].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR111       FR_0.MB[111].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR111       FR_0.MB[111].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR111       FR_0.MB[111].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR111       FR_0.MB[111].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR112       FR_0.MB[112].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR112       FR_0.MB[112].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR112       FR_0.MB[112].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR112       FR_0.MB[112].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR113       FR_0.MB[113].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR113       FR_0.MB[113].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR113       FR_0.MB[113].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR113       FR_0.MB[113].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR114       FR_0.MB[114].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR114       FR_0.MB[114].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR114       FR_0.MB[114].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR114       FR_0.MB[114].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR115       FR_0.MB[115].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR115       FR_0.MB[115].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR115       FR_0.MB[115].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR115       FR_0.MB[115].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR116       FR_0.MB[116].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR116       FR_0.MB[116].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR116       FR_0.MB[116].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR116       FR_0.MB[116].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR117       FR_0.MB[117].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR117       FR_0.MB[117].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR117       FR_0.MB[117].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR117       FR_0.MB[117].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR118       FR_0.MB[118].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR118       FR_0.MB[118].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR118       FR_0.MB[118].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR118       FR_0.MB[118].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR119       FR_0.MB[119].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR119       FR_0.MB[119].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR119       FR_0.MB[119].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR119       FR_0.MB[119].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR120       FR_0.MB[120].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR120       FR_0.MB[120].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR120       FR_0.MB[120].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR120       FR_0.MB[120].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR121       FR_0.MB[121].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR121       FR_0.MB[121].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR121       FR_0.MB[121].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR121       FR_0.MB[121].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR122       FR_0.MB[122].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR122       FR_0.MB[122].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR122       FR_0.MB[122].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR122       FR_0.MB[122].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR123       FR_0.MB[123].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR123       FR_0.MB[123].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR123       FR_0.MB[123].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR123       FR_0.MB[123].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR124       FR_0.MB[124].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR124       FR_0.MB[124].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR124       FR_0.MB[124].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR124       FR_0.MB[124].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR125       FR_0.MB[125].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR125       FR_0.MB[125].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR125       FR_0.MB[125].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR125       FR_0.MB[125].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR126       FR_0.MB[126].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR126       FR_0.MB[126].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR126       FR_0.MB[126].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR126       FR_0.MB[126].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBCCSR127       FR_0.MB[127].CCSR.R           /* Message Buffer Configuration, Control, Status Register */
#define FR_0_MBCCFR127       FR_0.MB[127].CCFR.R           /* Message Buffer Cycle Counter Filter Register */
#define FR_0_MBFIDR127       FR_0.MB[127].FIDR.R           /* Message Buffer Frame ID Register */
#define FR_0_MBIDXR127       FR_0.MB[127].IDXR.R           /* Message Buffer Index Register */
#define FR_0_MBDOR0          FR_0.MBDOR[0].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR1          FR_0.MBDOR[1].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR2          FR_0.MBDOR[2].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR3          FR_0.MBDOR[3].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR4          FR_0.MBDOR[4].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR5          FR_0.MBDOR[5].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR6          FR_0.MBDOR[6].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR7          FR_0.MBDOR[7].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR8          FR_0.MBDOR[8].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR9          FR_0.MBDOR[9].R               /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR10         FR_0.MBDOR[10].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR11         FR_0.MBDOR[11].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR12         FR_0.MBDOR[12].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR13         FR_0.MBDOR[13].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR14         FR_0.MBDOR[14].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR15         FR_0.MBDOR[15].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR16         FR_0.MBDOR[16].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR17         FR_0.MBDOR[17].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR18         FR_0.MBDOR[18].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR19         FR_0.MBDOR[19].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR20         FR_0.MBDOR[20].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR21         FR_0.MBDOR[21].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR22         FR_0.MBDOR[22].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR23         FR_0.MBDOR[23].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR24         FR_0.MBDOR[24].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR25         FR_0.MBDOR[25].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR26         FR_0.MBDOR[26].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR27         FR_0.MBDOR[27].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR28         FR_0.MBDOR[28].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR29         FR_0.MBDOR[29].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR30         FR_0.MBDOR[30].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR31         FR_0.MBDOR[31].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR32         FR_0.MBDOR[32].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR33         FR_0.MBDOR[33].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR34         FR_0.MBDOR[34].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR35         FR_0.MBDOR[35].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR36         FR_0.MBDOR[36].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR37         FR_0.MBDOR[37].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR38         FR_0.MBDOR[38].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR39         FR_0.MBDOR[39].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR40         FR_0.MBDOR[40].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR41         FR_0.MBDOR[41].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR42         FR_0.MBDOR[42].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR43         FR_0.MBDOR[43].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR44         FR_0.MBDOR[44].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR45         FR_0.MBDOR[45].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR46         FR_0.MBDOR[46].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR47         FR_0.MBDOR[47].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR48         FR_0.MBDOR[48].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR49         FR_0.MBDOR[49].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR50         FR_0.MBDOR[50].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR51         FR_0.MBDOR[51].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR52         FR_0.MBDOR[52].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR53         FR_0.MBDOR[53].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR54         FR_0.MBDOR[54].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR55         FR_0.MBDOR[55].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR56         FR_0.MBDOR[56].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR57         FR_0.MBDOR[57].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR58         FR_0.MBDOR[58].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR59         FR_0.MBDOR[59].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR60         FR_0.MBDOR[60].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR61         FR_0.MBDOR[61].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR62         FR_0.MBDOR[62].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR63         FR_0.MBDOR[63].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR64         FR_0.MBDOR[64].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR65         FR_0.MBDOR[65].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR66         FR_0.MBDOR[66].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR67         FR_0.MBDOR[67].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR68         FR_0.MBDOR[68].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR69         FR_0.MBDOR[69].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR70         FR_0.MBDOR[70].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR71         FR_0.MBDOR[71].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR72         FR_0.MBDOR[72].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR73         FR_0.MBDOR[73].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR74         FR_0.MBDOR[74].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR75         FR_0.MBDOR[75].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR76         FR_0.MBDOR[76].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR77         FR_0.MBDOR[77].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR78         FR_0.MBDOR[78].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR79         FR_0.MBDOR[79].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR80         FR_0.MBDOR[80].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR81         FR_0.MBDOR[81].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR82         FR_0.MBDOR[82].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR83         FR_0.MBDOR[83].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR84         FR_0.MBDOR[84].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR85         FR_0.MBDOR[85].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR86         FR_0.MBDOR[86].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR87         FR_0.MBDOR[87].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR88         FR_0.MBDOR[88].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR89         FR_0.MBDOR[89].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR90         FR_0.MBDOR[90].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR91         FR_0.MBDOR[91].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR92         FR_0.MBDOR[92].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR93         FR_0.MBDOR[93].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR94         FR_0.MBDOR[94].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR95         FR_0.MBDOR[95].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR96         FR_0.MBDOR[96].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR97         FR_0.MBDOR[97].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR98         FR_0.MBDOR[98].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR99         FR_0.MBDOR[99].R              /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR100        FR_0.MBDOR[100].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR101        FR_0.MBDOR[101].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR102        FR_0.MBDOR[102].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR103        FR_0.MBDOR[103].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR104        FR_0.MBDOR[104].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR105        FR_0.MBDOR[105].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR106        FR_0.MBDOR[106].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR107        FR_0.MBDOR[107].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR108        FR_0.MBDOR[108].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR109        FR_0.MBDOR[109].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR110        FR_0.MBDOR[110].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR111        FR_0.MBDOR[111].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR112        FR_0.MBDOR[112].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR113        FR_0.MBDOR[113].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR114        FR_0.MBDOR[114].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR115        FR_0.MBDOR[115].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR116        FR_0.MBDOR[116].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR117        FR_0.MBDOR[117].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR118        FR_0.MBDOR[118].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR119        FR_0.MBDOR[119].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR120        FR_0.MBDOR[120].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR121        FR_0.MBDOR[121].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR122        FR_0.MBDOR[122].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR123        FR_0.MBDOR[123].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR124        FR_0.MBDOR[124].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR125        FR_0.MBDOR[125].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR126        FR_0.MBDOR[126].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR127        FR_0.MBDOR[127].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR128        FR_0.MBDOR[128].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR129        FR_0.MBDOR[129].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR130        FR_0.MBDOR[130].R             /* Message Buffer Data Field Offset Register */
#define FR_0_MBDOR131        FR_0.MBDOR[131].R             /* Message Buffer Data Field Offset Register */
#define FR_0_LEETR0          FR_0.LEETR[0].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR1          FR_0.LEETR[1].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR2          FR_0.LEETR[2].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR3          FR_0.LEETR[3].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR4          FR_0.LEETR[4].R               /* LRAM ECC Error Test Register */
#define FR_0_LEETR5          FR_0.LEETR[5].R               /* LRAM ECC Error Test Register */

/* FR */
#define FR_1_MVR             FR_1.MVR.R                    /* Module Version Register */
#define FR_1_MCR             FR_1.MCR.R                    /* Module Configuration Register */
#define FR_1_SYMBADHR        FR_1.SYMBADHR.R               /* System Memory Base Address High Register */
#define FR_1_SYMBADLR        FR_1.SYMBADLR.R               /* System Memory Base Address Low Register */
#define FR_1_STBSCR          FR_1.STBSCR.R                 /* Strobe Signal Control Register */
#define FR_1_MBDSR           FR_1.MBDSR.R                  /* Message Buffer Data Size Register */
#define FR_1_MBSSUTR         FR_1.MBSSUTR.R                /* Message Buffer Segment Size and Utilization Register */
#define FR_1_PEDRAR          FR_1.PEDRAR.R                 /* PE DRAM Access Register */
#define FR_1_PEDRDR          FR_1.PEDRDR.R                 /* PE DRAM Data Register */
#define FR_1_POCR            FR_1.POCR.R                   /* Protocol Operation Control Register */
#define FR_1_GIFER           FR_1.GIFER.R                  /* Global Interrupt Flag and Enable Register */
#define FR_1_PIFR0           FR_1.PIFR0.R                  /* Protocol Interrupt Flag Register 0 */
#define FR_1_PIFR1           FR_1.PIFR1.R                  /* Protocol Interrupt Flag Register 1 */
#define FR_1_PIER0           FR_1.PIER0.R                  /* Protocol Interrupt Enable Register 0 */
#define FR_1_PIER1           FR_1.PIER1.R                  /* Protocol Interrupt Enable Register 1 */
#define FR_1_CHIERFR         FR_1.CHIERFR.R                /* CHI Error Flag Register */
#define FR_1_MBIVEC          FR_1.MBIVEC.R                 /* Message Buffer Interrupt Vector Register */
#define FR_1_CASERCR         FR_1.CASERCR.R                /* Channel A Status Error Counter Register */
#define FR_1_CBSERCR         FR_1.CBSERCR.R                /* Channel B Status Error Counter Register */
#define FR_1_PSR0            FR_1.PSR0.R                   /* Protocol Status Register 0 */
#define FR_1_PSR1            FR_1.PSR1.R                   /* Protocol Status Register 1 */
#define FR_1_PSR2            FR_1.PSR2.R                   /* Protocol Status Register 2 */
#define FR_1_PSR3            FR_1.PSR3.R                   /* Protocol Status Register 3 */
#define FR_1_MTCTR           FR_1.MTCTR.R                  /* Macrotick Counter Register */
#define FR_1_CYCTR           FR_1.CYCTR.R                  /* Cycle Counter Register */
#define FR_1_SLTCTAR         FR_1.SLTCTAR.R                /* Slot Counter Channel A Register */
#define FR_1_SLTCTBR         FR_1.SLTCTBR.R                /* Slot Counter Channel B Register */
#define FR_1_RTCORVR         FR_1.RTCORVR.R                /* Rate Correction Value Register */
#define FR_1_OFCORVR         FR_1.OFCORVR.R                /* Offset Correction Value Register */
#define FR_1_CIFR            FR_1.CIFR.R                   /* Combined Interrupt Flag Register */
#define FR_1_SYMATOR         FR_1.SYMATOR.R                /* System Memory Access Time-Out Register */
#define FR_1_SFCNTR          FR_1.SFCNTR.R                 /* Sync Frame Counter Register */
#define FR_1_SFTOR           FR_1.SFTOR.R                  /* Sync Frame Table Offset Register */
#define FR_1_SFTCCSR         FR_1.SFTCCSR.R                /* Sync Frame Table Configuration, Control, Status Register */
#define FR_1_SFIDRFR         FR_1.SFIDRFR.R                /* Sync Frame ID Rejection Filter Register */
#define FR_1_SFIDAFVR        FR_1.SFIDAFVR.R               /* Sync Frame ID Acceptance Filter Value Register */
#define FR_1_SFIDAFMR        FR_1.SFIDAFMR.R               /* Sync Frame ID Acceptance Filter Mask Register */
#define FR_1_NMVR0           FR_1.NMVR[0].R                /* Network Management Vector Register */
#define FR_1_NMVR1           FR_1.NMVR[1].R                /* Network Management Vector Register */
#define FR_1_NMVR2           FR_1.NMVR[2].R                /* Network Management Vector Register */
#define FR_1_NMVR3           FR_1.NMVR[3].R                /* Network Management Vector Register */
#define FR_1_NMVR4           FR_1.NMVR[4].R                /* Network Management Vector Register */
#define FR_1_NMVR5           FR_1.NMVR[5].R                /* Network Management Vector Register */
#define FR_1_NMVLR           FR_1.NMVLR.R                  /* Network Management Vector Length Register */
#define FR_1_TICCR           FR_1.TICCR.R                  /* Timer Configuration and Control Register */
#define FR_1_TI1CYSR         FR_1.TI1CYSR.R                /* Timer 1 Cycle Set Register */
#define FR_1_TI1MTOR         FR_1.TI1MTOR.R                /* Timer 1 Macrotick Offset Register */
#define FR_1_TI2CR0_ABS      FR_1.TI2CR0.ABS.R             /* Timer 2 Configuration Register 0 (Absolute Timer Configuration) */
#define FR_1_TI2CR0_REL      FR_1.TI2CR0.REL.R             /* Timer 2 Configuration Register 0 (Relative Timer Configuration) */
#define FR_1_TI2CR1_ABS      FR_1.TI2CR1.ABS.R             /* Timer 2 Configuration Register 1 (Absolute Timer Configuration) */
#define FR_1_TI2CR1_REL      FR_1.TI2CR1.REL.R             /* Timer 2 Configuration Register 1 (Relative Timer Configuration) */
#define FR_1_SSSR            FR_1.SSSR.R                   /* Slot Status Selection Register */
#define FR_1_SSCCR           FR_1.SSCCR.R                  /* Slot Status Counter Condition Register */
#define FR_1_SSR0            FR_1.SSR[0].R                 /* Slot Status Register */
#define FR_1_SSR1            FR_1.SSR[1].R                 /* Slot Status Register */
#define FR_1_SSR2            FR_1.SSR[2].R                 /* Slot Status Register */
#define FR_1_SSR3            FR_1.SSR[3].R                 /* Slot Status Register */
#define FR_1_SSR4            FR_1.SSR[4].R                 /* Slot Status Register */
#define FR_1_SSR5            FR_1.SSR[5].R                 /* Slot Status Register */
#define FR_1_SSR6            FR_1.SSR[6].R                 /* Slot Status Register */
#define FR_1_SSR7            FR_1.SSR[7].R                 /* Slot Status Register */
#define FR_1_SSCR0           FR_1.SSCR[0].R                /* Slot Status Counter Register */
#define FR_1_SSCR1           FR_1.SSCR[1].R                /* Slot Status Counter Register */
#define FR_1_SSCR2           FR_1.SSCR[2].R                /* Slot Status Counter Register */
#define FR_1_SSCR3           FR_1.SSCR[3].R                /* Slot Status Counter Register */
#define FR_1_MTSACFR         FR_1.MTSACFR.R                /* MTS A Configuration Register */
#define FR_1_MTSBCFR         FR_1.MTSBCFR.R                /* MTS B Configuration Register */
#define FR_1_RSBIR           FR_1.RSBIR.R                  /* Receive Shadow Buffer Index Register */
#define FR_1_RFWMSR          FR_1.RFWMSR.R                 /* Receive FIFO Watermark and Selection Register */
#define FR_1_RFSIR           FR_1.RFSIR.R                  /* Receive FIFO Start Index Register */
#define FR_1_RFDSR           FR_1.RFDSR.R                  /* Receive FIFO Depth and Size Register */
#define FR_1_RFARIR          FR_1.RFARIR.R                 /* Receive FIFO A Read Index Register */
#define FR_1_RFBRIR          FR_1.RFBRIR.R                 /* Receive FIFO B Read Index Register */
#define FR_1_RFMIDAFVR       FR_1.RFMIDAFVR.R              /* Receive FIFO Message ID Acceptance Filter Value Register */
#define FR_1_RFMIDAFMR       FR_1.RFMIDAFMR.R              /* Receive FIFO Message ID Acceptance Filter Mask Register */
#define FR_1_RFFIDRFVR       FR_1.RFFIDRFVR.R              /* Receive FIFO Frame ID Rejection Filter Value Register */
#define FR_1_RFFIDRFMR       FR_1.RFFIDRFMR.R              /* Receive FIFO Frame ID Rejection Filter Mask Register */
#define FR_1_RFRFCFR         FR_1.RFRFCFR.R                /* Receive FIFO Range Filter Configuration Register */
#define FR_1_RFRFCTR         FR_1.RFRFCTR.R                /* Receive FIFO Range Filter Control Register */
#define FR_1_LDTXSLAR        FR_1.LDTXSLAR.R               /* Last Dynamic Transmit Slot Channel A Register */
#define FR_1_LDTXSLBR        FR_1.LDTXSLBR.R               /* Last Dynamic Transmit Slot Channel B Register */
#define FR_1_PCR0            FR_1.PCR0.R                   /* Protocol Configuration Register 0 */
#define FR_1_PCR1            FR_1.PCR1.R                   /* Protocol Configuration Register 1 */
#define FR_1_PCR2            FR_1.PCR2.R                   /* Protocol Configuration Register 2 */
#define FR_1_PCR3            FR_1.PCR3.R                   /* Protocol Configuration Register 3 */
#define FR_1_PCR4            FR_1.PCR4.R                   /* Protocol Configuration Register 4 */
#define FR_1_PCR5            FR_1.PCR5.R                   /* Protocol Configuration Register 5 */
#define FR_1_PCR6            FR_1.PCR6.R                   /* Protocol Configuration Register 6 */
#define FR_1_PCR7            FR_1.PCR7.R                   /* Protocol Configuration Register 7 */
#define FR_1_PCR8            FR_1.PCR8.R                   /* Protocol Configuration Register 8 */
#define FR_1_PCR9            FR_1.PCR9.R                   /* Protocol Configuration Register 9 */
#define FR_1_PCR10           FR_1.PCR10.R                  /* Protocol Configuration Register 10 */
#define FR_1_PCR11           FR_1.PCR11.R                  /* Protocol Configuration Register 11 */
#define FR_1_PCR12           FR_1.PCR12.R                  /* Protocol Configuration Register 12 */
#define FR_1_PCR13           FR_1.PCR13.R                  /* Protocol Configuration Register 13 */
#define FR_1_PCR14           FR_1.PCR14.R                  /* Protocol Configuration Register 14 */
#define FR_1_PCR15           FR_1.PCR15.R                  /* Protocol Configuration Register 15 */
#define FR_1_PCR16           FR_1.PCR16.R                  /* Protocol Configuration Register 16 */
#define FR_1_PCR17           FR_1.PCR17.R                  /* Protocol Configuration Register 17 */
#define FR_1_PCR18           FR_1.PCR18.R                  /* Protocol Configuration Register 18 */
#define FR_1_PCR19           FR_1.PCR19.R                  /* Protocol Configuration Register 19 */
#define FR_1_PCR20           FR_1.PCR20.R                  /* Protocol Configuration Register 20 */
#define FR_1_PCR21           FR_1.PCR21.R                  /* Protocol Configuration Register 21 */
#define FR_1_PCR22           FR_1.PCR22.R                  /* Protocol Configuration Register 22 */
#define FR_1_PCR23           FR_1.PCR23.R                  /* Protocol Configuration Register 23 */
#define FR_1_PCR24           FR_1.PCR24.R                  /* Protocol Configuration Register 24 */
#define FR_1_PCR25           FR_1.PCR25.R                  /* Protocol Configuration Register 25 */
#define FR_1_PCR26           FR_1.PCR26.R                  /* Protocol Configuration Register 26 */
#define FR_1_PCR27           FR_1.PCR27.R                  /* Protocol Configuration Register 27 */
#define FR_1_PCR28           FR_1.PCR28.R                  /* Protocol Configuration Register 28 */
#define FR_1_PCR29           FR_1.PCR29.R                  /* Protocol Configuration Register 29 */
#define FR_1_PCR30           FR_1.PCR30.R                  /* Protocol Configuration Register 30 */
#define FR_1_STPWR           FR_1.STPWR.R                  /* StopWatch Count Register */
#define FR_1_PEOER           FR_1.PEOER.R                  /* Protocol Event Output Enable and StopWatch Control Register */
#define FR_1_RFSDOR          FR_1.RFSDOR.R                 /* Receive FIFO Start Data Offset Register */
#define FR_1_RFSYMBADHR      FR_1.RFSYMBADHR.R             /* Receive FIFO System Memory Base Address High Register */
#define FR_1_RFSYMBADLR      FR_1.RFSYMBADLR.R             /* Receive FIFO System Memory Base Address Low Register */
#define FR_1_RFPTR           FR_1.RFPTR.R                  /* Receive FIFO Periodic Timer Register */
#define FR_1_RFFLPCR         FR_1.RFFLPCR.R                /* Receive FIFO Fill Level and POP Count Register */
#define FR_1_EEIFER          FR_1.EEIFER.R                 /* ECC Error Interrupt Flag and Enable Register */
#define FR_1_EERICR          FR_1.EERICR.R                 /* ECC Error Report and Injection Control Register */
#define FR_1_EERAR           FR_1.EERAR.R                  /* ECC Error Report Address Register */
#define FR_1_EERDR           FR_1.EERDR.R                  /* ECC Error Report Data Register */
#define FR_1_EERCR           FR_1.EERCR.R                  /* ECC Error Report Code Register */
#define FR_1_EEIAR           FR_1.EEIAR.R                  /* ECC Error Injection Address Register */
#define FR_1_EEIDR           FR_1.EEIDR.R                  /* ECC Error Injection Data Register */
#define FR_1_EEICR           FR_1.EEICR.R                  /* ECC Error Injection Code Register */
#define FR_1_MBCCSR0         FR_1.MB[0].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_1_MBCCFR0         FR_1.MB[0].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_1_MBFIDR0         FR_1.MB[0].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_1_MBIDXR0         FR_1.MB[0].IDXR.R             /* Message Buffer Index Register */
#define FR_1_MBCCSR1         FR_1.MB[1].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_1_MBCCFR1         FR_1.MB[1].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_1_MBFIDR1         FR_1.MB[1].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_1_MBIDXR1         FR_1.MB[1].IDXR.R             /* Message Buffer Index Register */
#define FR_1_MBCCSR2         FR_1.MB[2].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_1_MBCCFR2         FR_1.MB[2].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_1_MBFIDR2         FR_1.MB[2].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_1_MBIDXR2         FR_1.MB[2].IDXR.R             /* Message Buffer Index Register */
#define FR_1_MBCCSR3         FR_1.MB[3].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_1_MBCCFR3         FR_1.MB[3].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_1_MBFIDR3         FR_1.MB[3].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_1_MBIDXR3         FR_1.MB[3].IDXR.R             /* Message Buffer Index Register */
#define FR_1_MBCCSR4         FR_1.MB[4].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_1_MBCCFR4         FR_1.MB[4].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_1_MBFIDR4         FR_1.MB[4].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_1_MBIDXR4         FR_1.MB[4].IDXR.R             /* Message Buffer Index Register */
#define FR_1_MBCCSR5         FR_1.MB[5].CCSR.R             /* Message Buffer Configuration, Control, Status Register */
#define FR_1_MBCCFR5         FR_1.MB[5].CCFR.R             /* Message Buffer Cycle Counter Filter Register */
#define FR_1_MBFIDR5         FR_1.MB[5].FIDR.R             /* Message Buffer Frame ID Register */
#define FR_1_MBIDXR5         FR_1