/* ========================================================================== */
/*   FIR 10 TAP Filter using LSP Intrinsics                                   */
/*   A Turner & I Howie                                                       */
/*   12/4/13                                                                  */
/*                                                                            */
/* ========================================================================== */



#include "dsp_filter.h"
#include <lsp.h>
#include "../headers/typedefs.h"

/*----------------------------------------------------------------------------------------------*/
/* FIR input, output vectors and coeficcients */   
 






//fir_frac16_c(uint16_t N, uint16_t ntaps,uint16_t *x,uint16_t *y, int16_t *h)

void fir_frac16_LSP_Intrinsic(uint16_t N, int16_t *x_ptr, int16_t *y_ptr, int16_t *h_ptr)
{
__lsp32_16__ InputVector0, InputVector1, InputVector2, InputVector3, InputVector4, InputVector5;

__lsp32_16__ Coeff1, Coeff2, Coeff3, Coeff4, Coeff5, Coeff6, Coeff7, Coeff8, Coeff9, Coeff10;

__lsp64_32__ Accumulating_Product;
int n = 0;
//Load the coefficients in to registers
Coeff1  = __lsp_create_32_16(h_ptr[0], h_ptr[0]);
Coeff2  = __lsp_create_32_16(h_ptr[1], h_ptr[1]);
Coeff3  = __lsp_create_32_16(h_ptr[2], h_ptr[2]);
Coeff4  = __lsp_create_32_16(h_ptr[3], h_ptr[3]);
Coeff5  = __lsp_create_32_16(h_ptr[4], h_ptr[4]);
Coeff6  = __lsp_create_32_16(h_ptr[5], h_ptr[5]);
Coeff7  = __lsp_create_32_16(h_ptr[6], h_ptr[6]);
Coeff8  = __lsp_create_32_16(h_ptr[7], h_ptr[7]);
Coeff9  = __lsp_create_32_16(h_ptr[8], h_ptr[8]);
Coeff10  = __lsp_create_32_16(h_ptr[9], h_ptr[9]);
//Clear the accumulator
//__ev_set_acc_u64(0);

//Load the first set of data to be processed
InputVector0  = __lsp_create_32_16(x_ptr[n+0], x_ptr[n+1]) ;
InputVector1  = __lsp_create_32_16(x_ptr[n+2], x_ptr[n+3]) ;
InputVector2  = __lsp_create_32_16(x_ptr[n+4], x_ptr[n+5]) ;
InputVector3  = __lsp_create_32_16(x_ptr[n+6], x_ptr[n+7]) ;
InputVector4  = __lsp_create_32_16(x_ptr[n+8], x_ptr[n+9]) ; 
for (n=0; n<N; n+=2)
{ 
InputVector5  = __lsp_create_32_16(x_ptr[n+10],x_ptr[n+11]) ;
  
Accumulating_Product = __zvmhulsf(InputVector0, Coeff10) ;
Accumulating_Product = __zvmhulsfaas(Accumulating_Product, InputVector1, Coeff8) ;
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector2, Coeff6) ;
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector3, Coeff4) ;
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector4, Coeff2) ;
InputVector0 = __zvmergelohih(InputVector0, InputVector1); 
InputVector1 = __zvmergelohih(InputVector1, InputVector2); 
InputVector2 = __zvmergelohih(InputVector2, InputVector3); 
InputVector3 = __zvmergelohih(InputVector3, InputVector4); 
InputVector4 = __zvmergelohih(InputVector4, InputVector5);
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector0, Coeff9);
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector1, Coeff7);
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector2, Coeff5);
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector3, Coeff3);
Accumulating_Product = __zvmhulsfaas(Accumulating_Product,InputVector4, Coeff1);

 __zstwhed  (Accumulating_Product, y_ptr,0);
 y_ptr =y_ptr+2;



InputVector0 = __zvmergelohih(InputVector0, InputVector1); 
InputVector1 = __zvmergelohih(InputVector1, InputVector2); 
InputVector2 = __zvmergelohih(InputVector2, InputVector3); 
InputVector3 = __zvmergehiloh(InputVector3, InputVector4); 
InputVector4 = InputVector5;
}
}

