/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file pdb.h
 *
 * @author  
 *
 * @version 2.0
 *
 * @date Apr-30-2013
 *
 * @brief Functions to enable PDB on Kinetis
 *
 *****************************************************************************/
#ifndef _PDB_H_
#define _PDB_H_

/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "derivative.h"
#include "fsl_types.h"

/*****************************************************************************************************
* Globals
*****************************************************************************************************/
extern unsigned char gu8Pdb0Status;

/*****************************************************************************************************
* Type definitions
*****************************************************************************************************/
typedef struct 
{
  unsigned int u32PreescalerTrigger;
  unsigned int u32IrqContinuousDma;
  unsigned short u16PdbModulo;
  unsigned short u16PdbIdly;
  unsigned short u16Adc0ADelay;
  unsigned short u16Adc0BDelay;
  unsigned short u16Adc1ADelay;
  unsigned short u16Adc1BDelay;
  unsigned short u16Dac0Delay;
  unsigned short u16Dac1Delay;
}tPDB;

typedef enum{
  PDB_OK,
  PDB_ERR
}PDB_STATUS;

/*****************************************************************************************************
* Definition of project wide MACROS / #DEFINE-CONSTANTS 
*****************************************************************************************************/
/***************** u32PreescalerTrigger options *******************************/

/* Preescaler Options */
#define PDB_PSL_1     PDB_SC_PRESCALER(0)  |  PDB_SC_MULT(0)
#define PDB_PSL_2     PDB_SC_PRESCALER(1)  |  PDB_SC_MULT(0)
#define PDB_PSL_4     PDB_SC_PRESCALER(2)  |  PDB_SC_MULT(0)
#define PDB_PSL_8     PDB_SC_PRESCALER(3)  |  PDB_SC_MULT(0)
#define PDB_PSL_10    PDB_SC_PRESCALER(0)  |  PDB_SC_MULT(1)
#define PDB_PSL_16    PDB_SC_PRESCALER(4)  |  PDB_SC_MULT(0)
#define PDB_PSL_20    PDB_SC_PRESCALER(1)  |  PDB_SC_MULT(1)
#define PDB_PSL_32    PDB_SC_PRESCALER(5)  |  PDB_SC_MULT(0)
#define PDB_PSL_40    PDB_SC_PRESCALER(2)  |  PDB_SC_MULT(1)
#define PDB_PSL_64    PDB_SC_PRESCALER(6)  |  PDB_SC_MULT(0)
#define PDB_PSL_80    PDB_SC_PRESCALER(3)  |  PDB_SC_MULT(1)
#define PDB_PSL_128   PDB_SC_PRESCALER(7)  |  PDB_SC_MULT(0)
#define PDB_PSL_160   PDB_SC_PRESCALER(4)  |  PDB_SC_MULT(1)
#define PDB_PSL_320   PDB_SC_PRESCALER(5)  |  PDB_SC_MULT(1)
#define PDB_PSL_640   PDB_SC_PRESCALER(6)  |  PDB_SC_MULT(1)
#define PDB_PSL_1280  PDB_SC_PRESCALER(7)  |  PDB_SC_MULT(1)
#define PDB_PSL_2560  PDB_SC_PRESCALER(7)  |  PDB_SC_MULT(2)
#define PDB_PSL_5120  PDB_SC_PRESCALER(7)  |  PDB_SC_MULT(3)

/* Trigger options */
#define PDB_HW_EXT       PDB_SC_TRGSEL(0)
#define PDB_HW_CMP0      PDB_SC_TRGSEL(1)
#define PDB_HW_CMP1      PDB_SC_TRGSEL(2)
#define PDB_HW_CMP2      PDB_SC_TRGSEL(3)
#define PDB_HW_PIT0      PDB_SC_TRGSEL(4)
#define PDB_HW_PIT1      PDB_SC_TRGSEL(5)
#define PDB_HW_PIT2      PDB_SC_TRGSEL(6)
#define PDB_HW_PIT3      PDB_SC_TRGSEL(7)
#define PDB_HW_FTM0      PDB_SC_TRGSEL(8)
#define PDB_HW_FTM1      PDB_SC_TRGSEL(9)
#define PDB_HW_FTM2      PDB_SC_TRGSEL(10)
#define PDB_HW_RTCALM    PDB_SC_TRGSEL(12)
#define PDB_HW_RTCSEC    PDB_SC_TRGSEL(13)
#define PDB_HW_LPTM      PDB_SC_TRGSEL(14)
#define PDB_SW           PDB_SC_TRGSEL(15)

/******************** u32IrqContinuousDma ************************************/
/* IRQ options */
#define PDB_IRQ_NONE                    0
#define PDB_IRQ_PDB                     PDB_SC_PDBIE_MASK
#define PDB_IRQ_ERROR                   PDB_SC_PDBEIE_MASK

/* Continuous mode options */
#define PDB_ONESHOT_MODE 		0
#define PDB_CONTINUOUS_MODE		PDB_SC_CONT_MASK

/* DMA options */
#define PDB_DMA_DISABLE                 0
#define PDB_DMA_ENABLE                  PDB_SC_DMAEN_MASK

/******************************************************************************
* Interrupt auxiliary macros
******************************************************************************/
#define PDB_INTERRUPT_EVENT 	EVENT(gu8Pdb0Status,0)
#define PDB_INTERRUPT_CLEAR 	CLEAR(gu8Pdb0Status,0)
#define PDB_INTERRUPT		COMPARE(gu8Pdb0Status,0)

/*****************************************************************************
* Auxiliary macros
*****************************************************************************/
#define PDB_SW_TRIGGER		PDB0_SC |= PDB_SC_SWTRIG_MASK;

/*****************************************************************************************************
* Declaration of project wide FUNCTIONS
*****************************************************************************************************/
unsigned char u8PdbInit (tPDB InitParam);
unsigned char u8PdbDeinit (void);
extern void vfnPdbIsr (void);


#endif /* _PDB_H_ */

