/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************//*!
*
* @file opamp.h
*
* @author  
*
* @version 2.0
*
* @date Apr-19-2013
*
* @brief OpAmp drivers for Kinetis
*
*****************************************************************************/

#ifndef _OPAMP_H_
#define _OPAMP_H_

/****************************************************************************
* Header files
****************************************************************************/
#include "derivative.h"

/***************************************************************************
* User definitions
***************************************************************************/

/* OpAmp Modules */
#define OPAMP0  OPAMP0_BASE_PTR
#define OPAMP1  OPAMP1_BASE_PTR

/* Low Power - Operation Mode */
#define OPAMP_LOWPOWER                  OPAMP_C0_LPEN_MASK
#define OPAMP_HIGHSPEED                 0
/* Modes*/
#define OPAMP_BUFFER                    OPAMP_C0_MODE(0)
#define OPAMP_GENERAL_PURPOSE           OPAMP_C0_MODE(2)
#define OPAMP_INVERTING                 OPAMP_C0_MODE(1)
#define OPAMP_NON_INVERTING             OPAMP_C0_MODE(3)

/* OpAmp gains */
/* Inverting gains */
#define OP_IGAIN_1               0x02	
#define OP_IGAIN_2               0x01
#define OP_IGAIN_3               0x03
#define OP_IGAIN_4               0x08
#define OP_IGAIN_5               0x0A
#define OP_IGAIN_6               0x09
#define OP_IGAIN_7               0x0B
#define OP_IGAIN_8               0x04
#define OP_IGAIN_9               0x06
#define OP_IGAIN_10              0x05
#define OP_IGAIN_11              0x07
#define OP_IGAIN_12              0x0C
#define OP_IGAIN_13              0x0E
#define OP_IGAIN_14              0x0D
#define OP_IGAIN_15              0x0F
#define OP_IGAIN_16              0x1D
#define OP_IGAIN_17              0x3F

/* Non-inverting gains*/
#define OP_NIGAIN_2               0x02	
#define OP_NIGAIN_3               0x01
#define OP_NIGAIN_4               0x03
#define OP_NIGAIN_5               0x08
#define OP_NIGAIN_6               0x0A
#define OP_NIGAIN_7               0x09
#define OP_NIGAIN_8               0x0B
#define OP_NIGAIN_9               0x04
#define OP_NIGAIN_10              0x06
#define OP_NIGAIN_11              0x05
#define OP_NIGAIN_12              0x07
#define OP_NIGAIN_13              0x0C
#define OP_NIGAIN_14              0x0E
#define OP_NIGAIN_15              0x0D
#define OP_NIGAIN_16              0x0F
#define OP_NIGAIN_17              0x1D
#define OP_NIGAIN_18              0x3F

/* Amppsel - Ampnsel inputs */
/* OpAmp0 positive input options */
#define OP0_PSEL_OP0_DP0        OPAMP_C2_AMPPSEL(0)    
#define OP0_PSEL_OP0_OUT        OPAMP_C2_AMPPSEL(1)
#define OP0_PSEL_OP1_OUT        OPAMP_C2_AMPPSEL(2)
#define OP0_PSEL_CMP0_DACOUT    OPAMP_C2_AMPPSEL(3)
#define OP0_PSEL_DAC0           OPAMP_C2_AMPPSEL(4)
#define OP0_PSEL_DAC1           OPAMP_C2_AMPPSEL(5)
#define OP0_PSEL_VDD            OPAMP_C2_AMPPSEL(6)
#define OP0_PSEL_GND            OPAMP_C2_AMPPSEL(7)

/* OpAmp0 negative input options */
#define OP0_NSEL_OP0_DM0        OPAMP_C2_AMPNSEL(0)    
#define OP0_NSEL_OP1_OUT        OPAMP_C2_AMPNSEL(2)
#define OP0_NSEL_CMP0_DACOUT    OPAMP_C2_AMPNSEL(3)
#define OP0_NSEL_DAC0           OPAMP_C2_AMPNSEL(4)
#define OP0_NSEL_DAC1           OPAMP_C2_AMPNSEL(5)
#define OP0_NSEL_VDD            OPAMP_C2_AMPNSEL(6)
#define OP0_NSEL_GND            OPAMP_C2_AMPNSEL(7)

/* OpAmp1 positive input options */
#define OP1_PSEL_OP1_DP0        OPAMP_C2_AMPPSEL(0)    
#define OP1_PSEL_OP0_OUT        OPAMP_C2_AMPPSEL(1)
#define OP1_PSEL_OP1_OUT        OPAMP_C2_AMPPSEL(2)
#define OP1_PSEL_CMP0_DACOUT    OPAMP_C2_AMPPSEL(3)
#define OP1_PSEL_DAC0           OPAMP_C2_AMPPSEL(4)
#define OP1_PSEL_DAC1           OPAMP_C2_AMPPSEL(5)
#define OP1_PSEL_VDD            OPAMP_C2_AMPPSEL(6)
#define OP1_PSEL_GND            OPAMP_C2_AMPPSEL(7)

/* OpAmp1 negative input options */
#define OP1_NSEL_OP1_DM0        OPAMP_C2_AMPNSEL(0)
#define OP1_NSEL_OP0_OUT        OPAMP_C2_AMPNSEL(1)    
#define OP1_NSEL_OP1_DM1        OPAMP_C2_AMPNSEL(2)
#define OP1_NSEL_CMP0_DACOUT    OPAMP_C2_AMPNSEL(3)
#define OP1_NSEL_DAC0           OPAMP_C2_AMPNSEL(4)
#define OP1_NSEL_TRI0_OUT       OPAMP_C2_AMPNSEL(5)
#define OP1_NSEL_VDD            OPAMP_C2_AMPNSEL(6)
#define OP1_NSEL_GND            OPAMP_C2_AMPNSEL(7)

/***************************************************************************
* Type definitions
****************************************************************************/
typedef struct{
  OPAMP_MemMapPtr     OpAmpModule;
  unsigned char       u8LowpowerOpmode;
  unsigned char       u8Gain;
  unsigned char       u8AmppselAmpnsel;
}tOPAMP;

/***************************************************************************
* Function prototypes
***************************************************************************/
void vfnOpAmpInit(tOPAMP OpConfig);
void vfnOpAmpChangeGain (tOPAMP OpConfig, unsigned char u8Gain);

#endif
