/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2013 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file lptmr.h
 *
 * @author  
 *
 * @version 2.0
 *
 * @date Apr-19-2013
 *
 * @brief Low Power Timer driver functions
 *
 *****************************************************************************/

#ifndef __LPTMR_H__
#define __LPTMR_H__

/*******************************************************************
*                           Header Files
********************************************************************/
#include "derivative.h"

/*******************************************************************
*                             Globals
********************************************************************/
extern unsigned char u8LptStatus;

#define LPT_INTERRUPT_EVENT		EVENT(u8LptStatus,0)
#define LPT_INTERRUPT	        COMPARE(u8LptStatus,0)
#define LPT_INTERRUPT_CLEAR		CLEAR(u8LptStatus,0)

/*******************************************************************
*                              Types
********************************************************************/

typedef enum
{
 LPT_PRE_1,
 LPT_PRE_2,
 LPT_PRE_4,
 LPT_PRE_8,
 LPT_PRE_16,
 LPT_PRE_32,
 LPT_PRE_64,
 LPT_PRE_128,
 LPT_PRE_256,
 LPT_PRE_512,
 LPT_PRE_1024,
 LPT_PRE_2048,
 LPT_PRE_4096,
 LPT_PRE_8192,
 LPT_PRE_16384,
 LPT_PRE_32768,
 LPT_PRE_65536 
}LPT_PRESCALER_VALUES;

typedef enum
{
 LPT_CLK_MCGIRCLK,
 LPT_CLK_LPO,
 LPT_CLK_ERCLK32K,
 LPT_CLK_OSCERCLK 
}LPT_CLOCK_SOURCES;

/*******************************************************************
* Function prototypes
********************************************************************/
void vfnTimeDelayms(unsigned short u16CountVal);
void vfnLptTimerInit(unsigned short u16CompareVal, unsigned char u8ClkSource, unsigned char u8Prescaler, unsigned char u8IntEn);
void vfnLptTimerDeinit(void);
extern void vfnLptTimerIsr(void);

/********************************************************************/

#endif /* __LPTMR_H__ */
