/****************************************************************************************************/
/**
\file       dma.c
\author     Freescale Semiconductor
\date		June 2012	        
*/
/****************************************************************************************************/
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.  	  */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end 	  */
/* product.                                                                                      	  */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/


/*****************************************************************************************************
* Include files
*****************************************************************************************************/
#include "dma.h"
#include "adc.h"
/*****************************************************************************************************
* Declaration of module wide FUNCTIONs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide MACROs / #DEFINE-CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Declaration of module wide TYPEs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Definition of module wide VARIABLEs - NOT for use in other modules
*****************************************************************************************************/
extern tADC sADC[ADC_CONFIGURATIONS_USED];
extern tADCControl sADCControl;
/*****************************************************************************************************
* Definition of module wide (CONST-) CONSTANTs - NOT for use in other modules
*****************************************************************************************************/

/*****************************************************************************************************
* Code of project wide FUNCTIONS
*****************************************************************************************************/

/****************************************************************************************************/
/**
* \brief  Initialize ADC DMA operations 
* \param  void
* \return   
* \todo     
*/

/****************************************************************************************************/
void vfnADC2DMA_Init(uint8_t u8Index)
{
  SIM_SCGC6 |= SIM_SCGC6_DMAMUX_MASK;
  SIM_SCGC7 |= SIM_SCGC7_DMA_MASK;

  /** Look for the DMA request source */
  if (sADC[u8Index].pADCBase == ADC0)
		DMAMUX_CHCFG0 |= DMAMUX_CHCFG_ENBL_MASK | DMAMUX_CHCFG_SOURCE(40);	// DMA request source  	   
  if (sADC[u8Index].pADCBase == ADC1)
		DMAMUX_CHCFG1 |= DMAMUX_CHCFG_ENBL_MASK | DMAMUX_CHCFG_SOURCE(41);	// DMA request source  
  
  /** Enable DMA channels 0 and 1 */
  DMA_ERQ |= DMA_ERQ_ERQ1_MASK | DMA_ERQ_ERQ0_MASK;
  
  if (sADC[u8Index].pADCBase == ADC0)
  {
	DMA_TCD0_SADDR = (uint32_t)(&ADC0_RA);								// Set source address (ADC0_RA)
	DMA_TCD0_DADDR = (unsigned long)&sADCControl.gu16LatestResult[0];	// Set destination address
	DMA_TCD0_SOFF = 0x00;												// Source offset disabled
	DMA_TCD0_SOFF = 0x00;												// Source offset disabled
	DMA_TCD0_ATTR = DMA_ATTR_SSIZE(2) | DMA_ATTR_DSIZE(2);				// Source and destination size 2 = 32 bits	
	DMA_TCD0_NBYTES_MLNO = 0x04;										// Transfer 4 bytes per transaction
	DMA_TCD0_SLAST = 0x00;												// No adjust need 
	DMA_TCD0_DOFF = 0x00;												// Destination offset disable 
	DMA_TCD0_CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(1);				// No link to channel, 1 transaction
	DMA_TCD0_DLASTSGA = 0x00;											// No adjustemnt to destination address
	DMA_TCD0_BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(1); 
	DMA_TCD0_CSR = 0; 	
  }

  if (sADC[u8Index].pADCBase == ADC1)
  {
	DMA_TCD1_SADDR = (uint32_t)(&ADC1_RA);								// Set the Source Address (ADC0_RA)
	DMA_TCD1_DADDR = (unsigned long)&sADCControl.gu16LatestResult[2];	// Set destination address
	DMA_TCD1_SOFF = 0x00;												// Source offset disabled
	DMA_TCD1_ATTR = DMA_ATTR_SSIZE(2) | DMA_ATTR_DSIZE(2);				// Source and destination size 2 = 32 bits	
	DMA_TCD1_NBYTES_MLNO = 0x04;										// Transfer 4 bytes per transaction
	DMA_TCD1_SLAST = 0x00;												// No adjust need 
	DMA_TCD1_DOFF = 0x00;												// Destination offset disable 
	DMA_TCD1_CITER_ELINKNO = DMA_CITER_ELINKNO_CITER(1);				// No link to channel, 1 transaction
	DMA_TCD1_DLASTSGA = 0x00;											// No adjustemnt to destination address
	DMA_TCD1_BITER_ELINKNO = DMA_BITER_ELINKNO_BITER(1); 
	DMA_TCD1_CSR = 0;
  }

}

 
 

