#*******************************************************************************
#
#  FREESCALE SEMICONDUCTOR INC. 2014
#  ALL RIGHTS RESERVED
#  COPYRIGHT (c)
#
#*******************************************************************************
#
#  FILE NAME:  cam_init.tcl
#
#*******************************************************************************

#*******************************************************************************
# Helper scripts 
#*******************************************************************************
etpusource trans.tcl
etpusource common.tcl

#*******************************************************************************
# Included scripts 
#*******************************************************************************
source [get_relative_loc]constants.tcl

#*******************************************************************************
# Functions 
#*******************************************************************************
proc cam_init { CAM_CHAN CAM_BASE_ADDR } {
  #*****************************************************************************
  # Import automatically generated interface header file
  #*****************************************************************************
  include_generated_file "etpu_cam_auto.h"
  
  #*****************************************************************************
  # Definitions.
  #*****************************************************************************
  set CAM_LOG_BASE_ADDR [expr $CAM_BASE_ADDR + $::FS_ETPU_CAM_NUM_PARMS]
  
  #*****************************************************************************
  # eTPU Channel CAM Configuration 
  #*****************************************************************************
  write_chan_base_addr       $CAM_CHAN $CAM_BASE_ADDR 
  write_chan_func            $CAM_CHAN $::FS_ETPU_CAM_FUNCTION_NUMBER
  write_chan_entry_condition $CAM_CHAN $::FS_ETPU_CAM_TABLE_SELECT 
  write_chan_mode            $CAM_CHAN [expr $::FS_ETPU_CAM_FM0_LOG_FALLING + $::FS_ETPU_CAM_FM1_LOG_RISING]
  write_chan_hsrr            $CAM_CHAN $::FS_ETPU_CAM_HSR_INIT 
  write_chan_cpr             $CAM_CHAN 1
  
  #*****************************************************************************
  # eTPU Channel CAM Parameters Initialization
  #*****************************************************************************
  write_chan_data24 $CAM_CHAN $::FS_ETPU_CAM_OFFSET_LOG_SIZE               8
  write_chan_data24 $CAM_CHAN $::FS_ETPU_CAM_OFFSET_LOG_IDX                0
  write_chan_data24 $CAM_CHAN $::FS_ETPU_CAM_OFFSET_LOG_COUNT              0
  write_chan_data24 $CAM_CHAN $::FS_ETPU_CAM_OFFSET_LOG                    $CAM_LOG_BASE_ADDR

  write_chan_data8  $CAM_CHAN $::FS_ETPU_CAM_OFFSET_ERROR                  0
  
  puts "eTPU channel $CAM_CHAN initialized to run CAM function."
}
