/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : flexcan_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This file contains FlexCAN and safe port register 
 *                          configuration in freeze mode
 *
 ******************************************************************************** 
 *
 * Detail Description     : File contains functions where FlexCAN and safe port configuration
 *                          for maximum number of MBs, CAN speed, different operating
 *                          modes,Receive Mask and Interrupt Mask can be done in freeze mode.
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "flexcan_init.h"


/*********************  Initialization Function(s) ************************/

uint8_t flexcan_init_fnc(void)
{
   uint8_t init_status = 0;

   init_status += flexcan_0_init_fnc();
   init_status += 2*safeport_init_fnc();

   return init_status;
}
/*********************  CAN_0 Initialization Function(s) ************************/

uint8_t flexcan_0_init_fnc(void)
{

    uint16_t i, x;
    uint8_t status;
    volatile uint16_t j;

    /* Enable CAN_0 module */
    CAN_0.MCR.B.MDIS = 0;

    /* Reset CAN_0 Module */
    CAN_0.MCR.B.SOFTRST = 1;
    while( CAN_0.MCR.B.SOFTRST ==1){}

    /* Disable CAN_0 module */
    CAN_0.MCR.B.MDIS = 1;

    /* CAN clock source 1: bus , 0: oscillator */
    CAN_0.CR.B.CLKSRC   = 1;

    /* CAN_0 module 1: Disable, 0: Enable*/
    CAN_0.MCR.B.MDIS =  0;

    /* Set FRZ bit */
    CAN_0.MCR.B.FRZ  = 1;
    /* Set HALT bit */
    CAN_0.MCR.B.HALT  = 1;

/* ----------------------------------------------------------- */
/*                   CAN_0.MCR Module Control Register                          */
/* ----------------------------------------------------------- */
    CAN_0.MCR.R = 0x5080000F;
    /* Enabling the CAN module: Enabled*/
    /* Freeze Enable :Enabled*/
    /* FIFO Enable :Disabled*/
    /* Halt : Enabled*/
    /* Wakeup Interrupt Mask : Disabled*/
    /* Soft Reset : Disabled*/
    /* Supervisor Mode : Enabled*/
    /* Warning Interrupt : Disabled*/
    /* Self Reception : Enabled*/
    /* Backwards Compatibility Configuration : Disabled*/
    /* Local Priority Enable : Disabled*/
    /* Abort Enable : Disabled*/
    /* ID Acceptance Mode : A*/
    /* Maximum Number of Message Buffers : 15*/

/* ----------------------------------------------------------- */
/*    CAN_0.CR Control Register                                */
/* ----------------------------------------------------------- */
    CAN_0.CR.R  = 0x07142006;
    /* CAN Speed: 500 kb/sec      */
    /* Prescalar Division Factor: 8              */
    /* Resynchronization Jump Width: 1           */
    /* Phase Segment1: 3                         */
    /* Phase Segment2: 5                         */
    /* Bus -Off Interrupt Mask: Disabled         */
    /* CAN Error Interrupt Mask: Disabled        */
    /* CLOCK Source: System                  */
    /* Loop Back Mode: Disabled                  */
    /* Tx Warning Interrupt : Disabled           */
    /* Rx Warning Interrupt : Disabled           */
    /* CAN bit Sampling Mode: 1 Sample           */
    /* Bus off Recovery: Enabled                 */
    /* Timer Synch Mode: Disabled                */
    /* Lowest Buffer Transfer First: Disabled    */
    /* Listen Only Mode: Disabled                */
    /* Propagation Segment: 7                    */



    /* Set the CAN_0 Maximum Buffer Size */
    CAN_0.MCR.B.MAXMB  = 15;


    /* Clear memory from message buffer 0 to 15 */
    for(x=0; x < 16; x++)
    {
        CAN_0.BUF[x].CS.R = 0;
        CAN_0.BUF[x].ID.R = 0;
        for(i=0; i < 2; i++) 
        {
            CAN_0.BUF[x].DATA.W[i] = 0;
        }
    }

/* ----------------------------------------------------------- */
/*    CAN_0.RXGMASK Global Mask                                */
/* ----------------------------------------------------------- */
    CAN_0.RXGMASK.R  = 0xFFFFFFFF;

/* ----------------------------------------------------------- */
/*    CAN_0.RX14MASK Buffer 14 Mask                            */
/* ----------------------------------------------------------- */
    CAN_0.RX14MASK.R  = 0xFFFFFFFF;

/* ----------------------------------------------------------- */
/*    CAN_0.RX15MASK Buffer 15 Mask                            */
/* ----------------------------------------------------------- */
    CAN_0.RX15MASK.R  = 0xFFFFFFFF;



/* ----------------------------------------------------------- */
/*    CAN_0.IMRL Interrupt Masks Low Register                  */
/* ----------------------------------------------------------- */
    CAN_0.IMRL.R  = 0x00000000;

    /*Set the HALT and the FREEZE bit. */
    /* CAN_0 is in Freeze mode. */
    CAN_0.MCR.B.HALT  =  0;
    CAN_0.MCR.B.FRZ   =  0;
    

    /* await synchronization (delay) */
    for(j=1; j < 255; j++){}

    if(CAN_0.MCR.B.NOTRDY == 1)
    {
       status = 1;
    }
    else
    {
       status = 0;
    }


    return status;

}
/*********************  SAFEPORT Initialization Function(s) ************************/

uint8_t safeport_init_fnc(void)
{

    uint16_t i, x;
    uint8_t status;
    volatile uint16_t j;

    /* Enable SAFEPORT module */
    SAFEPORT.MCR.B.MDIS = 0;

    /* Reset SAFEPORT Module */
    SAFEPORT.MCR.B.SOFTRST = 1;
    while( SAFEPORT.MCR.B.SOFTRST ==1){}

    /* Disable SAFEPORT module */
    SAFEPORT.MCR.B.MDIS = 1;

    /* CAN clock source 1: bus , 0: oscillator */
    SAFEPORT.CR.B.CLKSRC   = 0;

    /* SAFEPORT module 1: Disable, 0: Enable*/
    SAFEPORT.MCR.B.MDIS =  1;

    /* Set FRZ bit */
    SAFEPORT.MCR.B.FRZ  = 1;
    /* Set HALT bit */
    SAFEPORT.MCR.B.HALT  = 1;

/* ----------------------------------------------------------- */
/*                   SAFEPORT.MCR Module Control Register                          */
/* ----------------------------------------------------------- */
    SAFEPORT.MCR.R = 0xD080000F;
    /* Disabling the CAN module: Disabled*/
    /* Freeze Enable :Enabled*/
    /* FIFO Enable :Disabled*/
    /* Halt : Enabled*/
    /* Wakeup Interrupt Mask : Disabled*/
    /* Soft Reset : Disabled*/
    /* Supervisor Mode : Enabled*/
    /* Warning Interrupt : Disabled*/
    /* Self Reception : Enabled*/
    /* Backwards Compatibility Configuration : Disabled*/
    /* Local Priority Enable : Disabled*/
    /* Abort Enable : Disabled*/
    /* ID Acceptance Mode : A*/
    /* Maximum Number of Message Buffers : 15*/

/* ----------------------------------------------------------- */
/*    SAFEPORT.CR Control Register                                */
/* ----------------------------------------------------------- */
    SAFEPORT.CR.R  = 0x18140006;
    /* CAN Speed: 20 kb/sec      */
    /* Prescalar Division Factor: 25              */
    /* Resynchronization Jump Width: 1           */
    /* Phase Segment1: 3                         */
    /* Phase Segment2: 5                         */
    /* Bus -Off Interrupt Mask: Disabled         */
    /* CAN Error Interrupt Mask: Disabled        */
    /* CLOCK Source: Oscillator                  */
    /* Loop Back Mode: Disabled                  */
    /* Tx Warning Interrupt : Disabled           */
    /* Rx Warning Interrupt : Disabled           */
    /* CAN bit Sampling Mode: 1 Sample           */
    /* Bus off Recovery: Enabled                 */
    /* Timer Synch Mode: Disabled                */
    /* Lowest Buffer Transfer First: Disabled    */
    /* Listen Only Mode: Disabled                */
    /* Propagation Segment: 7                    */



    /* Set the SAFEPORT Maximum Buffer Size */
    SAFEPORT.MCR.B.MAXMB  = 15;


    /* Clear memory from message buffer 0 to 15 */
    for(x=0; x < 16; x++)
    {
        SAFEPORT.BUF[x].CS.R = 0;
        SAFEPORT.BUF[x].ID.R = 0;
        for(i=0; i < 2; i++) 
        {
            SAFEPORT.BUF[x].DATA.W[i] = 0;
        }
    }

/* ----------------------------------------------------------- */
/*    SAFEPORT.RXGMASK Global Mask                                */
/* ----------------------------------------------------------- */
    SAFEPORT.RXGMASK.R  = 0xFFFFFFFF;

/* ----------------------------------------------------------- */
/*    SAFEPORT.RX14MASK Buffer 14 Mask                            */
/* ----------------------------------------------------------- */
    SAFEPORT.RX14MASK.R  = 0xFFFFFFFF;

/* ----------------------------------------------------------- */
/*    SAFEPORT.RX15MASK Buffer 15 Mask                            */
/* ----------------------------------------------------------- */
    SAFEPORT.RX15MASK.R  = 0xFFFFFFFF;



/* ----------------------------------------------------------- */
/*    SAFEPORT.IMRL Interrupt Masks Low Register                  */
/* ----------------------------------------------------------- */
    SAFEPORT.IMRL.R  = 0x00000000;

    /*Set the HALT and the FREEZE bit. */
    /* SAFEPORT is in Freeze mode. */
    SAFEPORT.MCR.B.HALT  =  1;
    SAFEPORT.MCR.B.FRZ   =  1;
    

    /* await synchronization (delay) */
    for(j=1; j < 255; j++){}

    if(SAFEPORT.MCR.B.NOTRDY == 1)
    {
       status = 1;
    }
    else
    {
       status = 0;
    }


    return status;

}

 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

