/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : dspi_var.h
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This file contains Transmit and Receive variables declaration
 *
 *
 *######################################################################
*/

#ifndef  _DSPI_VAR_H
#define  _DSPI_VAR_H
/********************  Dependent Include files here **********************/

#include "jdp.h"




#define DSPI_0_PUSHR 0xFFF90034
#define DSPI_1_PUSHR 0xFFF94034
#define DSPI_2_PUSHR 0xFFF98034
#define DSPI_3_PUSHR 0xFFF9C034
#define DSPI_0_POPR  0xFFF9003A
#define DSPI_1_POPR  0xFFF9403A
#define DSPI_2_POPR  0xFFF9803A
#define DSPI_3_POPR  0xFFF9C03A


extern vuint32_t DSPI0_TxQUE[1];    /* Transmit Queue DSPI_0 Variable */
extern vuint32_t DSPI1_TxQUE[1];    /* Transmit Queue DSPI_1 Variable */
extern vuint32_t DSPI2_TxQUE[1];    /* Transmit Queue DSPI_2 Variable */
extern vuint32_t DSPI3_TxQUE[1];    /* Transmit Queue DSPI_3 Variable */

extern vuint16_t DSPI0_RxQUE[1];    /* Receive Queue DSPI_0 Variable */
extern vuint16_t DSPI1_RxQUE[1];    /* Receive Queue DSPI_1 Variable */
extern vuint16_t DSPI2_RxQUE[1];    /* Receive Queue DSPI_2 Variable */
extern vuint16_t DSPI3_RxQUE[1];    /* Receive Queue DSPI_3 Variable */



#endif  /*_DSPI_VAR_H*/

/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

