/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : adc_trigger_init.c
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This File contains the utility function used to trigger ADC Sampling.
 *
 ******************************************************************************** 
 *
 * Detail Description     : This File contains utility function which can trigger Normal &
 *                          Injected Sampling and Abort Normal Sampling. This function are
 *                          never called by RAppID
 *
 ******************************************************************************** 
 *
 *######################################################################
*/

 
 
/********************  Dependent Include files here **********************/

#include "adc_trigger_init.h"







/*********************  Normal Software Trigger Function ************************/

void adc_normal_start_fnc(void)

{
    
        /*ADC 0*/
        ADC_0.MCR.B.NSTART = 1; 
            /* Starts The Normal ADC Conversion */

        /*ADC 1*/
        ADC_1.MCR.B.NSTART = 1; 
            /* Starts The Normal ADC Conversion */

}

/*********************  Injected Software Trigger Function ************************/

void adc_injected_start_fnc(void)
{
        /*ADC 0*/
        ADC_0.MCR.B.JSTART = 1;
            /* Starts The Injected ADC Conversion */
        /*ADC 1*/
        ADC_1.MCR.B.JSTART = 1;
            /* Starts The Injected ADC Conversion */

}

/*********************  Normal Software Conversion  Stop Function ************************/

void adc_normal_stop_fnc(void)
{
        /*ADC 0*/
        ADC_0.MCR.B.ABORT = 1; 
            /*  Stops The Normal ADC Conversion */
        /*ADC 1*/
        ADC_1.MCR.B.ABORT = 1; 
            /*  Stops The Normal ADC Conversion */

}

/*********************  Enter Powedown Mode Function ************************/

void adc_enter_powerdownmode_fnc(void)
{
        /*ADC 0*/
        ADC_0.MCR.B.NSTART = 1; 
            /*  Enter Power down state */
        /*ADC 1*/
        ADC_1.MCR.B.NSTART = 1; 
            /*  Enter Power down state */

}

/*********************  Exit from Powedown Mode Function ************************/

void adc_exit_powerdownmode_fnc(void)
{
        /*ADC 0*/
        ADC_0.MCR.B.PWDN = 0; 
            /*  Exit Power down state */
        /*ADC 1*/
        ADC_1.MCR.B.PWDN = 0; 
            /*  Exit Power down state */

}

 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

