/*
 *######################################################################
 *                                RAppID
 *           Rapid Application Initialization and Documentation Tool
 *                         Freescale Semiconductor Inc.
 *
 *######################################################################
 *
 * Project Name           : TRK-MPC5604P_Example
 *
 * Project File           : TRK-MPC5604P_Example.rsp
 *
 * Revision Number        : 1.0
 *
 * Tool Version           : 1.4.0.4
 *
 * file                   : adc_ctu_var.h
 *
 * Target Compiler        : Codewarrior
 *
 * Target Part            : MPC5604P
 *
 * Part Errata Fixes      : none
 *
 * Project Last Save Date : 12-Feb-2014 16:58:50
 *
 * Created on Date        : 12-Feb-2014 16:58:51
 *
 * Brief Description      : This file contains declaration for CTU variable and Queues.
 *
 *
 *######################################################################
*/

#ifndef  _ADC_CTU_VAR_H
#define  _ADC_CTU_VAR_H
/********************  Dependent Include files here **********************/

#include "jdp.h"





#define ADC_0_DATAREG0 0xFFE00100
#define ADC_1_DATAREG0 0xFFE04100

#define CTU_FR0    0xFFE0C080
#define CTU_FR1    0xFFE0C084
#define CTU_FR2    0xFFE0C088
#define CTU_FR3    0xFFE0C08C


/********************  ADC DMA Variables  **********************/

extern vuint32_t adc_0_datareg[16];/* Read Buffer for  ADC 0*/
extern vuint32_t adc_1_datareg[16];/* Read Buffer for  ADC 1*/

/********************  CTU DMA Variables  **********************/

extern vuint32_t CTU_FIFO_0[1];/*Read Buffer for FIFO 0*/
extern vuint32_t CTU_FIFO_1[1];/*Read Buffer for FIFO 1*/
extern vuint32_t CTU_FIFO_2[1];/*Read Buffer for FIFO 2*/
extern vuint32_t CTU_FIFO_3[1];/*Read Buffer for FIFO 3*/


#endif  /*_ADC_CTU_VAR_H*/

/*
 *######################################################################
 *                           End of File
 *######################################################################
*/

