/*
 *########################################################################
 *                (c) Copyright 2013 Freescale Semiconductor, Inc.
 *                         ALL RIGHTS RESERVED. 
 *########################################################################
 * 
 * Brief Description     : Photo Sensor high level driver file
 *
 **************************************************************************
*/
/******************************************************************************
* Includes
******************************************************************************/
#include "photo_sensor_hld.h"
#include "adc_drv.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/
#define PHOTO_SENSOR_CHANNEL	4

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Local Functions
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Static variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/

/******************************************************************************
*   Function: Init_SBC_DBG
*
*   Description: Returns ADC value of Potentiometer channel 
*
******************************************************************************/
uint16_t Photo_Sensor_Get_Value(void)
{
	return (A2D_GetSingleCh_ADC0(PHOTO_SENSOR_CHANNEL));	
}
 
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/



