/*
 *########################################################################
 *                (c) Copyright 2013 Freescale Semiconductor, Inc.
 *                         ALL RIGHTS RESERVED. 
 *########################################################################
 * 
 * Brief Description     : ADC driver file
 *
 **************************************************************************
*/
/******************************************************************************
* Includes
******************************************************************************/
#include "adc_drv.h"

/******************************************************************************
* Constants
******************************************************************************/

/******************************************************************************
* Macros 
******************************************************************************/

/******************************************************************************
* Types
******************************************************************************/

/******************************************************************************
* Local Functions
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Static variables
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/



/******************************************************************************
*   Function: A2D_GetSingleCh_ADC0
*
*   Description: Sets up, starts, and returns a conversion for a single channel
*
******************************************************************************/
uint16_t A2D_GetSingleCh_ADC0(uint32_t ch)
{
    uint16_t result;
	result = 0;
	
	if (ch <= 15)
	{
		ADC_0.NCMR[0].R = (uint32_t)(0x00000001 << ch);


		ADC_0.MCR.B.NSTART = 1;  /* Trigger ADC Conversion */

		while (ADC_0.CDR[ch].B.VALID != 1)
		{
		}
		result = (uint16_t)((ADC_0.CDR[ch].B.CDATA));
	}
    return(result);
}

/******************************************************************************
*   Function: A2D_GetSingleCh_ADC1
*
*   Description: Sets up, starts, and returns a conversion for a single channel
*
******************************************************************************/
uint16_t A2D_GetSingleCh_ADC1(uint32_t ch)
{
    uint16_t result;
	result = 0;
	
	if (ch <= 15)
	{
		ADC_1.NCMR[0].R = (uint32_t)(0x00000001 << ch);


		ADC_1.MCR.B.NSTART = 1;  /* Trigger ADC Conversion */

		while (ADC_1.CDR[ch].B.VALID != 1)
		{
		}
		result = (uint16_t)((ADC_1.CDR[ch].B.CDATA));
	}
    return(result);
}

/******************************************************************************
*   Function: A2D_GetChResult_ADC0
*
*   Description: Returns the result value for a single channel
*
******************************************************************************/
uint16_t A2D_GetChResult_ADC0(uint32_t ch)
{
    uint16_t result;

    if (ch <= 15)    /* Verify the channel count value */
    {
        result = (uint16_t)((ADC_0.CDR[ch].B.CDATA));
    }

    return(result);
}

/******************************************************************************
*   Function: A2D_GetChResult_ADC1
*
*   Description: Returns the result value for a single channel
*
******************************************************************************/
uint16_t A2D_GetChResult_ADC1(uint32_t ch)
{
    uint16_t result;

    if (ch <= 15)    /* Verify the channel count value */
    {
        result = (uint16_t)((ADC_1.CDR[ch].B.CDATA));
    }

    return(result);
}

/******************************************************************************
*   Function: A2D_SetupCh_ADC0
*
*   Description: Sets up channel for the ADC converter
*
******************************************************************************/
void A2D_SetupCh_ADC0(uint32_t ch)
{
	if (ch <= 32)    /* Verify the channel count value */
	{
		ADC_0.NCMR[0].R = (uint32_t)((0x00000001 << ch) | ADC_0.NCMR[0].R);
	}
 }
 
 /******************************************************************************
*   Function: A2D_SetupCh_ADC1
*
*   Description: Sets up channel for the ADC converter
*
******************************************************************************/
 void A2D_SetupCh_ADC1(uint32_t ch)
{
	if (ch <= 32)    /* Verify the channel count value */
	{
		ADC_1.NCMR[0].R = (uint32_t)((0x00000001 << ch) | ADC_1.NCMR[0].R);
	}
 }
/*
 *######################################################################
 *                           End of File
 *######################################################################
*/



