/******************************************************************************								
*    LAB5 - Touch Sensing Interface (TSI) Module                              *								
*                                                                             *								
*       This lab demonstrates how to use the TSI module to detect touches to  *								
*    copper electrodes on the board. This module helps substitute mechanical  *								
*    buttons with touch sensing electrodes. The corresponding LED turns on    *								
*    when touching an electrode on the board.                                 *								
*       Press the touch electrodes on the board to see the LEDs changing,     *								
*    acknowledging the touch detection.                                       *								
******************************************************************************/								


/**********************************************************************************************
* External objects
**********************************************************************************************/
#include <hidef.h> 
#include "derivative.h"

#include "main.h"
#include "COP.h"
#include "CLK.h"
#include "TSI.h"

/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/
#define THRESHOLD 280

/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

	
/***********************************************************************************************
*
* @brief    GPIO_Init - Initialize the LEDs as outputs
* @param    none
* @return   none
*
************************************************************************************************/
void GPIO_Init()
{
  PORT_PTGOE_PTGOE0 = 1;		/* Init LEDs as outputs */
  PORT_PTGOE_PTGOE1 = 1;
  PORT_PTGOE_PTGOE2 = 1;
  PORT_PTGOE_PTGOE3 = 1;	
  
  PORT_PTDIE_PTDIE4 = 1;		/* Button pins as inputs */
  PORT_PTDIE_PTDIE5 = 1;
  
  PORT_PTGD = 0xFF;				/* LEDs OFF */		
}	
	
	
	
/***********************************************************************************************
*
* @brief    main() - Program entry function
* @param    none
* @return   none
*
************************************************************************************************/  
void main(void) {
  
  COP_Disable();			/* Disable Watchdog */
  CLK_Init();				/* Configure clocks to run at 16Mhz */
  GPIO_Init();				/* Configure button pins as inputs and LED pins as outputs */
  
  EnableInterrupts;
  
  TSI_Init();				/* Initialize the TSI Module */

  for(;;) 
  {	  
	  if(TSI_GetElectrode(0) > THRESHOLD){ 	LED1_ON; }	else{  LED1_OFF;}
	  if(TSI_GetElectrode(1) > THRESHOLD){ 	LED2_ON; }	else{  LED2_OFF;}
	  if(TSI_GetElectrode(14) > THRESHOLD){ LED3_ON; }	else{  LED3_OFF;}
	  if(TSI_GetElectrode(15) > THRESHOLD){ LED4_ON; }	else{  LED4_OFF;}  
  }
  
}
