/*
 * TSI.c
 *
 *  Created on: 03/08/2012
 *      Author: B34981
 */

#include "TSI.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    TSI_Init - Initialize the TSI module 
* @param    none
* @return   none
*
************************************************************************************************/  
void TSI_Init()
{
	TSI_CS0_TSIEN = 1;		/* TSI Enabled */
	TSI_CS0_TSIIEN = 0;		/* TSI Interrupt disabled */
	TSI_CS0_STM = 0;		/* Software Trigger */
 
	TSI_CS1_PS = 1;			/* Clock prescaler. 3-bits. clock/2^PS */
	TSI_CS1_NSCN = 4;		/* Number of samples. Samples = NCSN+1 (up to 32 samples) */
	
	TSI_CS2_REFCHRG = 1;	/* Charge current (1 microAmp) */ 
	TSI_CS2_DVOLT = 0;		/* Charge voltage 0.1-1.33 */
	TSI_CS2_EXTCHRG = 1;	/* External charge current (1 microAmp) */
	
	/* Enable the 4 pins of the board electrodes */
	TSI_PEN0_PEN0 =  1;
	TSI_PEN0_PEN1 =  1;
	TSI_PEN1_PEN14 =  1;
	TSI_PEN1_PEN15 =  1;
}


/***********************************************************************************************
*
* @brief    TSI_GetElectrode - Initialize a scan request on the indicated channel 
* @param    UINT8 ch - Channel to scan
* @return   UINT16 - Number of counts for the scanned channel
*
************************************************************************************************/  
UINT16 TSI_GetElectrode(UINT8 ch)
{	
	TSI_CS3_TSICH = ch;		/* Set channel to scan */
	TSI_CS0_SWTS = 1;		/* Software trigger */
	while(!TSI_CS0_EOSF);	/* Wait for conversion to finish */
	TSI_CS0_EOSF = 1;		/* Clear Flag */
	return TSI_CNT; 
}
