/*
 * KBI.c
 *
 *  Created on: 03/08/2012
 *      Author: B34981
 */

#include "KBI.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/
pt2FuncU8 KBI_Callback;

/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    KBI_Init - Enable Keyboard interrupts on channels 4 and 5 (SW3 and SW2)
* @param    none
* @return   none
*
************************************************************************************************/  
void KBI_Init()
{	
	KBI1_SC_KBIE = 	 0;		/* Mask interrupts*/
	KBI1_ES_KBEDG5 = 0;		/* Falling edge */
	KBI1_ES_KBEDG4 = 0;		/* Falling edge */	
	KBI1_PE_KBIPE5 = 1;		/* Enable KBI channel 5 (SW2) */
	KBI1_PE_KBIPE4 = 1;		/* Enable KBI channel 4 (SW3) */
	KBI1_SC_KBACK = 1;		/* Erase previous flags */
	KBI1_SC_KBIE = 1;		/* Enable KBI Interrupt */
}

/***********************************************************************************************
*
* @brief    KBI_SetCallback - Set a callback function to execute on a falling edge of an enabled KBI pin
* @param    pointer to function with an UINT8 argument
* @return   none
*
************************************************************************************************/  
void KBI_SetCallback(pt2FuncU8 ptr)
{
	 KBI_Callback = ptr; 
}


/***********************************************************************************************
*
* @brief    KBI_ISR - KBI interrupt routine, calls the user callabck
* @param    none
* @return   none
*
************************************************************************************************/  
interrupt VectorNumber_Vkbi1 void KBI_ISR()
{
	UINT8 sw = 0;
	KBI1_SC_KBACK = 1; /* Clear flag*/	
	if(PORT_PTDD_PTDD4)
	{
		sw = 3;		
	}
	else if(PORT_PTDD_PTDD5)
	{
		sw = 2;		
	}
	KBI_Callback(sw);
}

