/******************************************************************************								
*    LAB3 - Analog-To-Digital Converter (ADC) Module                          *								
*                                                                             *								
*       This lab demonstrates how to use the ADC module to read the analog    *								
*    value of the on-board potentiometer. The application reads the           *								
*    potentiometer value and sets it to the LEDs in its binary                *								
*    representation.                                                          *								
*       Move the potentiometer to see the LEDs change the read value.         *								
******************************************************************************/								


/**********************************************************************************************
* External objects
**********************************************************************************************/
#include <hidef.h> 
#include "derivative.h"

#include "main.h"
#include "COP.h"
#include "CLK.h"
#include "ADC.h"

/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

	
/***********************************************************************************************
*
* @brief    GPIO_Init - Initialize the LEDs as outputs
* @param    none
* @return   none
*
************************************************************************************************/
void GPIO_Init()
{
  PORT_PTGOE_PTGOE0 = 1;		/* Init LEDs as outputs */
  PORT_PTGOE_PTGOE1 = 1;
  PORT_PTGOE_PTGOE2 = 1;
  PORT_PTGOE_PTGOE3 = 1;	
  
  PORT_PTDIE_PTDIE4 = 1;		/* Button pins as inputs */
  PORT_PTDIE_PTDIE5 = 1;
  
  PORT_PTGD = 0xFF;				/* LEDs OFF */		
}	
	
	
	
/***********************************************************************************************
*
* @brief    main() - Program entry function
* @param    none
* @return   none
*
************************************************************************************************/  
void main(void) {
  
  COP_Disable();			/* Disable Watchdog */
  CLK_Init();				/* Configure clocks to run at 16Mhz */
  GPIO_Init();				/* Configure button pins as inputs and LED pins as outputs */
  
  EnableInterrupts;
  
  ADC_Init();				/* Initialize the ADC module */
  
  

  for(;;) 
  {
	  PORT_PTGD =~ ADC_Read(0) >> 4;	    /* Set the read ADC value on the LEDs */
  } 
}
