/*
 * PWM.c
 *
 *  Created on: 01/08/2012
 *      Author: B34981
 */

#include "FTM.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/
UINT16 period[4] = {0, 0, 0, 0};
pt2FuncU8 FTM_Callback;


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    FTM_Init - Initialize the FTM counter and enable 4 interrupts (CH0 to CH3)
* @param    none
* @return   none
*
************************************************************************************************/
void FTM_Init()
{	
	FTM2_SC_PS = 0b100;					/* Clock divided over 16 */
	
	FTM2_C0SC_CHIE = 1;					/* Interrupt enable */
	FTM2_C0SC_MSA = 1;					/* Channel as Output Compare */
	
	FTM2_C1SC_CHIE = 1;					/* Interrupt enable */
	FTM2_C1SC_MSA = 1;					/* Channel as Output Compare */
	
	FTM2_C2SC_CHIE = 1;					/* Interrupt enable */
	FTM2_C2SC_MSA = 1;					/* Channel as Output Compare */
	
	FTM2_C3SC_CHIE = 1;					/* Interrupt enable */
	FTM2_C3SC_MSA = 1;					/* Channel as Output Compare */	
	
	FTM2_C0V = period[0];
	FTM2_C1V = period[1];
	FTM2_C2V = period[2];
	FTM2_C3V = period[3];

	FTM2_SC_CLKS = 1;					/* Select the system clock */
}


/***********************************************************************************************
*
* @brief    FTM_SetPeriod - Set the period of the periodic interrupt
* @param    ch - channel to configure, per - period to set
* @return   none
*
************************************************************************************************/
void FTM_SetPeriod(UINT8 ch, UINT16 per)
{
	period[ch] = per;
	
	FTM2_C0V = period[0];
	FTM2_C1V = period[1];
	FTM2_C2V = period[2];
	FTM2_C3V = period[3];
}

/***********************************************************************************************
*
* @brief    FTM_SetCallback - Set the callback function to call on successful matches from any channel 
* @param    pointer to function with an UINT8 argument
* @return   none
*
************************************************************************************************/  
void FTM_SetCallback(pt2FuncU8 ptr)
{
	FTM_Callback = ptr;	
}


/***********************************************************************************************
*
* @brief    FTM2_CH0_ISR - Interrupt for channel 0 match, clear flag, set new timeout and execute callback 
* @param    none
* @return   none
*
************************************************************************************************/
interrupt VectorNumber_Vftm2ch0 void FTM2_CH0_ISR()
{
	(void)FTM2_C0SC;
	FTM2_C0SC_CHF = 0;   				/* Clear Flag */
	FTM2_C0V = FTM2_C0V + period[0];
	FTM_Callback(0);
}

/***********************************************************************************************
*
* @brief    FTM2_CH1_ISR - Interrupt for channel 1 match, clear flag, set new timeout and execute callback 
* @param    none
* @return   none
*
************************************************************************************************/
interrupt VectorNumber_Vftm2ch1 void FTM2_CH1_ISR()
{
	(void)FTM2_C1SC;
	FTM2_C1SC_CHF = 0;   				/* Clear Flag */
	FTM2_C1V = FTM2_C1V + period[1];
	FTM_Callback(1);
}

/***********************************************************************************************
*
* @brief    FTM2_CH2_ISR - Interrupt for channel 2 match, clear flag, set new timeout and execute callback 
* @param    none
* @return   none
*
************************************************************************************************/
interrupt VectorNumber_Vftm2ch2 void FTM2_CH2_ISR()
{
	(void)FTM2_C2SC;
	FTM2_C2SC_CHF = 0;   				/* Clear Flag */
	FTM2_C2V = FTM2_C2V + period[2];
	FTM_Callback(2);
}

/***********************************************************************************************
*
* @brief    FTM2_CH3_ISR - Interrupt for channel 3 match, clear flag, set new timeout and execute callback 
* @param    none
* @return   none
*
************************************************************************************************/
interrupt VectorNumber_Vftm2ch3 void FTM2_CH3_ISR()
{
	(void)FTM2_C3SC;
	FTM2_C3SC_CHF = 0;   				/* Clear Flag */
	FTM2_C3V = FTM2_C3V + period[3];
	FTM_Callback(3);
}
