/******************************************************************************								
*    LAB1 - Serial Communications Interface (SCI)                             *								
*                                                                             *								
*       This lab demonstrates how to use the SCI module to receive and send   *								
*    characters. Using interrupts, it waits for characters sent from a PC     *								
*    terminal and echoes the received data.									  *
*    										                                  *								
*       To use this demo you need to open a  serial terminal. The OSBDM port  *
*       is used to communicate via SCI2 to the RN60 microcontroller.          *								
*                                                                             *								
*       Open the Terminal Utility and set the baud rate to 9600, leave all    *								
*    the other settings with the default values. Click the Open Port button   *								
*    and the console should connect. Every character you write to the serial  *								
*    console will be replied by the RN60 MCU.                                 *								
******************************************************************************/								


/**********************************************************************************************
* External objects
**********************************************************************************************/
#include <hidef.h> 
#include "derivative.h"

#include "main.h"
#include "COP.h"
#include "CLK.h"
#include "SCI.h"

#include "printf.h"

/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/
void SCI_Receive(UINT8 data);

/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

	
/***********************************************************************************************
*
* @brief    GPIO_Init - Initialize the LEDs as outputs
* @param    none
* @return   none
*
************************************************************************************************/
void GPIO_Init()
{
  PORT_PTGOE_PTGOE0 = 1;		/* Init LEDs as outputs */
  PORT_PTGOE_PTGOE1 = 1;
  PORT_PTGOE_PTGOE2 = 1;
  PORT_PTGOE_PTGOE3 = 1;	
  
  PORT_PTDIE_PTDIE4 = 1;		/* Button pins as inputs */
  PORT_PTDIE_PTDIE5 = 1;
  
  PORT_PTGD = 0xFF;				/* LEDs OFF */		
}	
	
	
	
/***********************************************************************************************
*
* @brief    main() - Program entry function
* @param    none
* @return   none
*
************************************************************************************************/  
void main(void) {
  
	COP_Disable();			/* Disable Watchdog */
	CLK_Init();				/* Configure clocks to run at 16Mhz */
	GPIO_Init();			/* Configure button pins as inputs and LED pins as outputs */				
	EnableInterrupts;
  
  	SCI_SetCallback(SCI_Receive);	/* Set the callback function that the SCI driver will call when receiving a char. */

  	SCI_Init();						/* Initialize the SCI module (9600 bauds) */


  for(;;) 
  {
	
  }
  
}

/***********************************************************************************************
*
* @brief    SCI_Receive(UINT8 data). Serial reception callback. This function is called each time a character
* 				is received on the serial port.
* @param    data received from serial port
* @return   none
*
************************************************************************************************/  
void SCI_Receive(UINT8 data)
{
	(void)printf("Received: %c\n", data);
}


