/*
 * SCI.h
 *
 *  Created on: 01/08/2012
 *      Author: B34981
 */

#ifndef SCI_H_
#define SCI_H_
/*******************************************************************************
* Includes
********************************************************************************/

#include "derivative.h"

/*******************************************************************************
* Constants
********************************************************************************/


/*******************************************************************************
* Macros
********************************************************************************/

                
/*******************************************************************************
* Types
********************************************************************************/


/*******************************************************************************
* Variables
********************************************************************************/


/*******************************************************************************
* Global Variables
********************************************************************************/


/*******************************************************************************
* Global Functions
********************************************************************************/

/***********************************************************************************************
*
* @brief    SCI_Init - Initalizes the SCI2 to run at 9600 bauds assuming bus clock of 16Mhz
* @param    none
* @return   none
*
************************************************************************************************/  
void SCI_Init(void); 

/***********************************************************************************************
*
* @brief    SCI_SendChar - Send a single byte on SCI2 
* @param    byte to send
* @return   none
*
************************************************************************************************/  
void SCI_SendChar(UINT8 send);

/***********************************************************************************************
*
* @brief    SCI_GetChar - Retreive the received char from the SCI2 buffer (should be called from Interrupt) 
* @param    none
* @return   received byte
*
************************************************************************************************/
UINT8 SCI_GetChar(void);

/***********************************************************************************************
*
* @brief    SCI_SetCallback(pt2FuncU8 ptr) - Set a callback function to execute when a byte is received on the SCI2
* @param    pointer to function with an UINT8 argument
* @return   none
*
************************************************************************************************/  
void SCI_SetCallback(pt2FuncU8 ptr);

#endif /* SCI_H_ */
