/*
 * CLK.c
 *
 *  Created on: 01/08/2012
 *      Author: B34981
 */

#include "CLK.h"

/**********************************************************************************************
* External objects
**********************************************************************************************/


/**********************************************************************************************
* Global variables
**********************************************************************************************/


/**********************************************************************************************
* Constants and macros
**********************************************************************************************/


/**********************************************************************************************
* Local types
**********************************************************************************************/


/**********************************************************************************************
* Local function prototypes
*********************************************************************************************/


/**********************************************************************************************
* Local variables
**********************************************************************************************/


/**********************************************************************************************
* Local functions
**********************************************************************************************/


/**********************************************************************************************
* Global functions
**********************************************************************************************/

/***********************************************************************************************
*
* @brief    CLK_Init - Initialize the clocks to run at 16 MHz from the 4Mhz external XTAL
* @param    none
* @return   none
*
************************************************************************************************/  
void CLK_Init()
{
	
	ICS_OSCSC_OSCEN = 1;			/* Enable external Oscillator */
	ICS_OSCSC_RANGE = 1;			/* Main oscillator between 4 and 20 MHz */
	ICS_OSCSC_OSCOS = 1;			/* Using oscillator output as clock */
	
	while(!ICS_OSCSC_OSCINIT);		/* Wait for Oscillator to initialize */
	
	ICS_C1_RDIV = 3;				/* Divide the frequency over 256.  8000/256 = 31.25 KHz*/	
	ICS_C1_IREFS = 0;				/* Change FLL reference clock to external clock */
	
	while(ICS_S_IREFST);			/* Wait for the IREFS write to synch  */
	
	while(!ICS_S_LOCK);				/* Wait for PLL lock, now running at 16 MHz (512 * 31.25) */
	
	ICS_C2_BDIV = 0;				/* No prescaler, so clock is still 16 MHz*/
	
	ICS_S_LOLS = 1;					/* Clear Loss of lock sticky bit */
	
}
