#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

void main(void) {
  unsigned char counter = 0;

  EnableInterrupts;
  
  /********************************************/
  /************ PLL INITIALIZATION ************/
  /********************************************/
  CPMUCLKS_PLLSEL = 1;		//FBUS = FPLL/2.   FBUS = 32MHz, 
  CPMUREFDIV_REFFRQ = 1;	//Reference clock between 2MHZ and 6MHZ.	
  CPMUREFDIV_REFDIV = 0x1;	//FREF=8/(1+1) = 4MHZ		
  CPMUSYNR_VCOFRQ = 0x1;    //FVCO is between 48MHZ and 80MHZ	
  CPMUSYNR_SYNDIV = 0x7;	//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 64MHZ
  CPMUPOSTDIV_POSTDIV = 0x0;//FPLL = FVCO/(POSTDIV+1).  FPLL = 64MHZ/(0+1)    FPLL = 64MHz	
  CPMUOSC_OSCE = 1;			//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
  while(!CPMUIFLG_LOCK){}	// Wait for LOCK.      	
  CPMUIFLG = 0xFF;			// clear CMPMU flags

  /********************************************/
  /********* SENT_TX INITIALIZATION ***********/
  /********************************************/
  CONFIG_TXINIT = 1;		//Start Configuration of the SENT module
  TICKRATE = 100;			//Set up tick rate
  PPULSE = 0;				//Do not use pause pulse
  CONFIG_DNIBBLECOUNT = 2;	//Send 2 nibbles at a time
  CONFIG_TXEN = 1;			//Enable the transmitter
  CONFIG_TXINIT = 0;		//Configuration done
  
  /********************************************/
  /************** SENDING DATA ****************/
  /********************************************/
  for(;;) {
    TXBUF = counter;		//Load data to transmit buffer
    INTFLG_TBE = 1;			//Clear transmit buffer empty flag
    while(INTFLG_TC==0){};	//Wait until transmission completes
    INTFLG_TC = 1;			//Clear transmission complete flag
    counter++;				//Change data to be transmitted
  } /* loop forever */

}
