#include "MPC5643L.h"
#include "siu.h"

/************************************************************************/
/* void ConfigureSIU(void) 				 								*/
/************************************************************************/
/* Desc: configure in and output pins									*/
/************************************************************************/
void ConfigureSIU(void) 
{
	//FlexPWM outputs
	SIU.PCR[11].R  = 0x0B00;   //PWM0 A[0] -> PJ9:12
	SIU.PCR[10].R  = 0x0B00;   //PWM0 B[0] -> PJ9:11
	SIU.PCR[57].R  = 0x0500;   //PWM0 X[0] 
	SIU.PCR[39].R  = 0x0B00;   //PWM0 A[1] -> PJ3:8
	SIU.PCR[38].R  = 0x0B00;   //PWM0 B[1] -> 
	SIU.PCR[60].R  = 0x0500;   //PWM0 X[1]
	SIU.PCR[2].R   = 0x0E00;   //PWM0 A[3] -> PJ9:3
	
	//ADC input
	SIU.PCR[64].R = 0x2000;    //ADC1/AN[5]
	
	//clock output
	SIUL.PCR[22].R = 0x4604;   //port B6
	
	//CTU external trigger
	SIUL.PCR[46].R = 0x0900;   //port C14
	
	//DMA debug
	SIU.PCR[0].R  = 0x0300;    //GPIO A[0] ->PJ9:1
	SIU.PCR[3].R  = 0x0300;    //GPIO A[3] ->PJ9:1
	
	//eTimer input
	SIU.PSMI[35].B.PADSEL = 1; //eTimer0[0] D[10] <- PJ8:11
	SIU.PCR[58].R = 0x0100;    //enable input buffer
	
	//eTimer output
	SIU.PCR[1].R = 0x0700;     //eTimer0[1] output -> PJ9:2
	
}
