/************************************************************************/
/*    Phase-shift PWM with external current limit control               */
/************************************************************************/
/* Desc: Output 2 complementary pairs of PWM signals at 100kHz
/*       PWM0_H and PWM0_L on FlexPWM0 submodule 0
/*       PWM1_H and PWM1_L on FlexPWM0 submodule 1
/*       A "fake" Ilimit pulse is generated with FlexPWM0 submodule 2
/************************************************************************/
/* Author: Yves Briant 
/* Date:   14/03/2010
/************************************************************************/

#include "MPC5643L.h"
#include "clocks-modes.h"
#include "dma.h"
#include "flexPWM.h"
#include "adc.h"
#include "siu.h"
#include "ctu.h"
#include "isr.h"
#include "pbridge.h"
#include "xbar.h"
#include "eTimer.h"
#include "Exceptions.h"
#include "INTCInterrupts.h"

/* Table recording ATD converted output voltage: has to be 32bytes aligned for DMA circular buffer */
volatile uint16_t RawVoltagesTable[4] __attribute__ ((aligned (32)));

/************************************************************************/

/* void DisableSoftwareWatchdog (void)									*/
/************************************************************************/
/* Desc: Disable SWT													*/
/*       For development purpose only                                   */
/************************************************************************/
void DisableSoftwareWatchdog (void) {
	// remove the SWT Soft lock
	SWT.SR.R = 0x0000C520;
	SWT.SR.R = 0x0000D928;
	// disable SWT
	SWT.CR.B.WEN = 0x0;
}


/************************************************************************/
/* int main (void)		                    							*/
/************************************************************************/
int main(void) {
	
	/* System Initialization */
	DisableSoftwareWatchdog();		// Disable watchdog
	InitializeModesAndClock();		// Configure PLL and Mode Entry
	ConfigurePBridge();				// Configure Access rights from DMA to Peripheral Bridge access
	ConfigureXBAR();				// Configure Priorities and Park options of crossbar

	/* Peripheral Initialization 1 */
	ConfigureSIU();					// Configure out- and input pins
	
	ConfigureADC1();				// Configure ADC and CTU for output voltage conversion
	ConfigureCTU();
	ConfigureDMA_CTU_FIFO();		// Configure DMA for transferring ADC result from CTU FIFO to RawVoltagesTable

	ConfigureDMA4ForceOut();		// Configure DMA for force-out logic re-configuration
	ConfigureDMA_Priorities();		// Configure DMA priorities
	
	/* Exception Initialization  */
    EXCEP_InitExceptionHandlers();
    INTC_InstallINTCInterruptHandler(DMA_CH4_Isr, 15, 2);	  	// Configure DMA channel 4
    INTC.CPR.B.PRI = 0;											// Set Current priority to 0
    INTC_InitINTCInterrupts();									// Set interrupt handler

    /* Configuration of PWM generation */
	ConfigureETimer0();					// eTimer channel for Ilimit input
	ConfigureFlexPWM04FakeIlimit();		// Simulation of Ilimit pulse
	ConfigureFlexPWM04PhaseShift();		// Generation of 2 pairs of PWM signals
	LaunchFlexPWM0_modules013(); 		// Start PWM generation
	
	for(;;) 
	{
		
	}

}




