#include "MPC5643L.h"
#include "isr.h"

extern volatile uint16_t RawVoltagesTable[4];

/****************************************************************************/
/* void DMA_CH4_Isr(void) 				 								    */
/****************************************************************************/
/* Desc: Interrupt routine called when DMA transfer of 4 voltages completes */	
/*       Computes new SHIFT value according to these last 4 voltages        */        
/****************************************************************************/
void DMA_CH4_Isr(void) 
{

    int32_t sum_4_voltages, shift;
    uint8_t voltage_index;
    
    sum_4_voltages = 0;
    
	//acknowledge DMA#4 interrupt
	EDMA.DMAINTL.R = 0x10;
	
	//compute ADC readings mean value
	for (voltage_index=0;voltage_index<4;voltage_index++) 
	{
		sum_4_voltages += (uint16_t)(RawVoltagesTable[voltage_index]);
	}
	
	//convert to a shift value
	shift = ((0x3FFF - sum_4_voltages)*37)>>10;
	if (shift > 599 ) 
	{
		shift = 599;
	}
	if (shift < 1)
	{
		shift = 1;
	}

	//disable load of register buffer to unlock VALx registers
	FLEXPWM_0.MCTRL.B.CLOK = 2;
	//update VAL2 and VAL3
	FLEXPWM_0.SUB[1].VAL[2].R = (int16_t)(shift-600);
	FLEXPWM_0.SUB[1].VAL[3].R = (int16_t)(shift); 
	//enable load of register buffer
	FLEXPWM_0.MCTRL.B.LDOK = (FLEXPWM_0.MCTRL.B.LDOK | 0x2); 		// Load config values into buffers for submodule 1
	
}
