/************************************************************************/
/*    Phase-shift PWM with external current limit control               */
/************************************************************************/
/* Desc: Configure eTimer0 channel 1 in gated clock
/*       channel 0 = primary clock
/*       channel 0 is the input for the Ilimit pulse
/************************************************************************/
/* Author: Yves Briant 
/* Date:   14/03/2010
/************************************************************************/
#include "MPC5643L.h"
#include "FlexPWM.h"

/************************************************************************/
/* void LaunchFlexPWM0_modules013(void) 								*/
/************************************************************************/
/* Desc: Starts submodules 0,1,3 simultaneously                         */
/************************************************************************/
void LaunchFlexPWM0_modules013(void) 
{
	FLEXPWM_0.MCTRL.B.RUN  = 0xB; 		// Channels 0,1,3 - Go!
}

/************************************************************************/
/* void ConfigureFlexPWM04PhaseShift(void) 								*/
/************************************************************************/
/* Desc: Configure submodule 0 for PWM0_H / PWM0_L                      */
/************************************************************************/
void ConfigureFlexPWM04PhaseShift(void)
{
	/* Submodule 0 for PWM0 *********************************************/
    FLEXPWM_0.SUB[0].INIT.R   = FLEXPWM0_INIT; 	// Initial count value
    
    FLEXPWM_0.SUB[0].CTRL.B.FULL = 0;		    // No full Cycle reload
    FLEXPWM_0.SUB[0].CTRL.B.HALF = 1;           // Half cycle reload

	FLEXPWM_0.SUB[0].CTRL2.B.DBGEN = 1; 	    // PWM runs in debug mode
	FLEXPWM_0.SUB[0].CTRL2.B.INDEP = 0;		    // PWMA & PWMB outputs are complementary
	// DEBUG FLEXPWM_0.SUB[0].CTRL2.B.FORCE_SEL = 6;     // EXT force for PWM1
	FLEXPWM_0.SUB[0].CTRL2.B.PWM23_INIT= 0;     // PWM0_H = 1 at start-up
	FLEXPWM_0.SUB[0].CTRL2.B.PWM45_INIT= 1;     // PWM0_L = 0 at start-up
	
	FLEXPWM_0.SUB[0].DTCNT0.R = FLEXPWM0_DEADTIME;  	// PWM0_H dead time 50nsec
	FLEXPWM_0.SUB[0].DTCNT1.R = FLEXPWM0_DEADTIME;  	// PWM0_L dead time 50nsec
	
	FLEXPWM_0.SUB[0].DISMAP.R = 0xFF00;			// reset PWMA and PWMB Fault Disable Mask of selected submodule 
		
	FLEXPWM_0.SUB[0].VAL[0].R = 0x0230; 		//FLEXPWM0_VAL1;   	// Juste before rising edge
	FLEXPWM_0.SUB[0].VAL[1].R = 0x0258; 		//FLEXPWM0_VAL1;    // Max value for counter 
	FLEXPWM_0.SUB[0].VAL[2].R = FLEXPWM0_INIT;  // PWMA high 
	FLEXPWM_0.SUB[0].VAL[3].R = 0;  			// PWMA Low    

	FLEXPWM_0.SUB[0].DMAEN.B.VALDE = 1;			//Enable DMA
	
	FLEXPWM_0.SUB[0].TCTRL.R = 0x4;     		//Enable trig only for VAL2
    
	/* Submodule 1 for PWM1 *********************************************/
    FLEXPWM_0.SUB[1].INIT.R   = FLEXPWM0_INIT;	// Initial count value
    
    FLEXPWM_0.SUB[1].CTRL.B.FULL = 0;			// No full Cycle reload
    FLEXPWM_0.SUB[1].CTRL.B.HALF = 1;			// Half Cycle reload
  
	FLEXPWM_0.SUB[1].CTRL2.B.DBGEN = 1; 		// PWM runs in debug mode
    FLEXPWM_0.SUB[1].CTRL2.B.INDEP = 0;			// PWMA & PWMB outputs are complementary
    //DEBUG
    FLEXPWM_0.SUB[1].CTRL2.B.FORCE_SEL = 6;     // EXT force for PWM1
    //DEBUG
    FLEXPWM_0.SUB[1].CTRL2.B.PWM23_INIT= 0;     // PWM1_H = 1 at start-up
	FLEXPWM_0.SUB[1].CTRL2.B.PWM45_INIT= 1;     // PWM1_L = 0 at start-up

	FLEXPWM_0.SUB[1].DTCNT0.R = FLEXPWM0_DEADTIME;  // PWMA dead time 50nsec
	FLEXPWM_0.SUB[1].DTCNT1.R = FLEXPWM0_DEADTIME;  // PWMB dead time 50nsec
	
	FLEXPWM_0.SUB[1].DISMAP.R = 0xFF00;			// reset PWMA and PWMB Fault Disable Mask of selected submodule 
	
	FLEXPWM_0.SUB[1].VAL[0].R = 0xFFD8;    		// just before falling edge
	FLEXPWM_0.SUB[1].VAL[1].R = FLEXPWM0_VAL1;  // Max value for counter 
	FLEXPWM_0.SUB[1].VAL[2].R = 0x0;         	// PWMA high 
	FLEXPWM_0.SUB[1].VAL[3].R = FLEXPWM0_VAL1;	// PWMA Low   

    FLEXPWM_0.SUB[1].DMAEN.B.VALDE = 1;		    //Enable DMA
	
	//Enable PWM	
	FLEXPWM_0.OUTEN.B.PWMA_EN = 0xB;
	FLEXPWM_0.OUTEN.B.PWMB_EN = 0xB;
    FLEXPWM_0.OUTEN.B.PWMX_EN = 0xB;
	
	//Force-out logic
	FLEXPWM_0.SWCOUT.B.OUT23_1 = 1;     
	FLEXPWM_0.DTSRCSEL.B.SEL23_1 = 2;   
	
	//Load register
	FLEXPWM_0.MCTRL.B.LDOK = 0x3; 		// Read and write: load config values into buffers 
     
} 


/************************************************************************/
/* void ConfigureFlexPWM04FakeIlimit(void) 								*/
/************************************************************************/
/* Desc: Simulate Ilimit pulse on submodule 3                           */
/*       
/************************************************************************/
void ConfigureFlexPWM04FakeIlimit(void) 
{
    FLEXPWM_0.SUB[3].INIT.R   = FLEXPWM0_INIT;	// Initial count value 0
    FLEXPWM_0.SUB[3].CTRL.B.FULL = 0;			// Full Cycle reload
    FLEXPWM_0.SUB[3].CTRL2.B.INDEP = 1;			// PWMA & PWMB outputs are complementary

	FLEXPWM_0.SUB[3].DISMAP.R = 0xFF00;		// reset PWMA and PWMB Fault Disable Mask of selected submodule 
	
	FLEXPWM_0.SUB[3].CTRL2.B.DBGEN = 1; 	// PWM runs in debug mode
		
	FLEXPWM_0.SUB[3].VAL[0].R = 0x0000; 	// Mid-Cycle Reload Point
	FLEXPWM_0.SUB[3].VAL[1].R = 0x0258;	  	// Max value for counter 
	FLEXPWM_0.SUB[3].VAL[2].R = 150;  		// PWMA high 
	FLEXPWM_0.SUB[3].VAL[3].R = 200;   		// PWMA Low  
	FLEXPWM_0.SUB[3].VAL[4].R = 0x0000; 	// PWMB high  
	FLEXPWM_0.SUB[3].VAL[5].R = 0x0000; 	// PWMB Low   
	
	//Enable PWM	
	FLEXPWM_0.OUTEN.B.PWMA_EN = 0xB;

	//Launch PWM
	FLEXPWM_0.MCTRL.B.LDOK = 0x8; 		// Read and write: load config values into buffers 
	
}

