#include "MPC5643L.h"

/************************************************************************/
/* void ConfigureCTU(void)				 								*/
/************************************************************************/
/* Desc: Configure CTU to launch one conversion within each PWM period  */
/************************************************************************/
void ConfigureCTU(void) 
{
	CTU.TGSISR.R = 0x00000004;  //active input = PWM_EVEN0 (VAL0 - VAL2 - VAL4)
	CTU.TGSCR.R  = 0x0000;      //triggered mode, external trig in toggle mode
	CTU.T0CR.R = 900;
	//Compare modulo & reload value
	CTU.TGSCCR.R = 1200;
	CTU.TGSCRR.R = 0;
	//Command list control registers
	CTU.CLCR1.R = 0x00000000;
	CTU.CLCR2.R = 0x00000000;
	//Trigger Handler control registers
//	CTU.THCR1.R = 0x00000060;  //T0: enable - external pulse - ADC	
	CTU.THCR1.R = 0x00000061;  //T0: enable - external pulse - ADC	
	CTU.THCR2.R = 0x00000000;  //T4-T7: disable
	//Command list register
	CTU.CLR[0].R = 0x4025; //no ISR - last command - single conv - FIFO0 - ADCB - ch5 
	CTU.CLR[1].R = 0x4425; //no ISR - last command - single conv - FIFO0 - ADCB - ch5 
	//Clear error flag register
	CTU.CTUEFR.R = 0xFFFF;
	//Interrupt flag
	CTU.CTUIFR.R = 0xFFFF;
	//Interrupt enable
	CTU.CTUIR.R = 0x0;
	//Control On time for external trigger
	CTU.COTR.R = 120; //1sec duration

	//FIFO control	
	CTU.CR.R  = 0x1;    // Enable DMA for FIFO0
	CTU.FCR.R = 0x0004; // Enable request on threshold limit
	CTU.TH1.R = 0x0004; // FIFO0 threshold: 1
	
	//CLEAR FLAGS
	CTU.CTUEFR.R = 0xFFFF;
	
	// Cross Triggering Unit Control Register
	CTU.CTUCR.B.TGSISR_RE = 1;      	// TGS Input Selection Register Reload Enable
	CTU.CTUCR.B.GRE    = 1;				// General Reload Enable	
}
