#include "../headers/typedefs.h"
#include "../headers/mpc5746m.h"

/****************** Configure the DMA - Loop of transfers ********************/
void DMA_Init(void)
{
	/* Configure CH7 */
	DMA_0.TCD[7].SADDR = (vuint32_t)&SDADC_0.CDR.R + 2; /* Lower half-word from CDR contains conversion result */
	DMA_0.TCD[7].SMOD = 0;    
	DMA_0.TCD[7].SSIZE = 0x1;		/* 16-bit */
	DMA_0.TCD[7].DMOD = 0;
	DMA_0.TCD[7].DSIZE = 0x1;		/* 16-bit */
	DMA_0.TCD[7].SOFF = 0;
	DMA_0.TCD[7].NBYTES = 32;		/* 16x16-bits -> 16 results from the FIFO */
	DMA_0.TCD[7].SLAST = 0;
	DMA_0.TCD[7].DADDR = 0x4001E000;
	DMA_0.TCD[7].CITER_ELINK = 0;     
	//DMA_0.TCD[7].CITER_LINKCH = 0;
	DMA_0.TCD[7].CITER = 10;		/* 10 Minor loops to build up the result table */
	DMA_0.TCD[7].DOFF = 0x2;
	DMA_0.TCD[7].DLAST_SGA = -320;
	DMA_0.TCD[7].BITER = 10;		/* 10 Minor loops to build up the result table */
	DMA_0.TCD[7].BITER_ELINK = 0;
	//DMA_0.TCD[7].BITER_LINKCH = 0;
	DMA_0.TCD[7].BWC = 0;    
	DMA_0.TCD[7].MAJORLINKCH = 0;	/* No Linking */
	DMA_0.TCD[7].MAJORELINK = 0; 
	DMA_0.TCD[7].ESG = 0;
	DMA_0.TCD[7].DREQ = 1;			/* Clear channel's DMA request bit upon completion of major loop */
	DMA_0.TCD[7].INTHALF = 0;
	DMA_0.TCD[7].INTMAJ = 1;		/* The end-of-major loop interrupt is enabled */
	
	/* Configure SDADC Mux channels */
	DMACHMUX_0.CHCONFIG[7].R= 0x84;	/* DMA MUX 0 to set SDADC0 EOC on DMA channel 7 */
	
	/* Enable channels */
	DMA_0.ERQL.R = 0x00000080;		/* Enable channels 7 for SDADC eDMA requests */
 
} /* DMA_Init */