/**************************************************************************/
/* FILE NAME:                              COPYRIGHT (c) Freescale 2008   */
/* MPC56xx_55xx_Dual_PRC0_Interrupt_Init.c        All Rights Reserved     */
/*                                                                        */
/* DESCRIPTION:                                                           */
/* This is the interrupt controller configuration file.                   */
/*========================================================================*/
/*                                                                        */
/*========================================================================*/
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
/* ---   -----------    ----------    ---------------------               */
/* 0.1    R. Moran      10/12/2008     Initial Version                    */
/**************************************************************************/
#include "../../headers/mpc5746m.h"

/*========================================================================*/
/*                      GLOBAL VARIABLES                                  */
/*========================================================================*/

extern const uint32_t IntcIsrVectorTable[];

/*========================================================================*/
/*                      EXTERNAL PROTOTYPES                               */
/*========================================================================*/

extern void e200zX_Interrupt_Setup(void);

/*========================================================================*/
/*                          FUNCTIONS                                     */
/*========================================================================*/

/**************************************************************************/
/* FUNCTION     : InitINTC                                                */
/* PURPOSE      : This function intializes the INTC for software vector   */
/*                mode.                                                   */
/**************************************************************************/
void InitINTC(void) {   

 int temp;
    
// Choose software (HVEN=0) or hardware (HVEN=1) vector mode
 INTC.BCR.R = 0x00000000;
        
 temp = INTC.IACKR[2].R; 	      //read IACKR before enabling interrupts
    
// Set INTC ISR vector table base addr.
 INTC.IACKR[2].R = (uint32_t) &IntcIsrVectorTable[0]; 
}


/**************************************************************************/
/* FUNCTION     : enableIrq                                               */
/* PURPOSE      : This function sets INTC's current priority to 0.        */
/*                External interrupts to the core are enabled.            */
/**************************************************************************/
void enableIrq(void) {
    
    // Ensure INTC's current priority is 0
    INTC.CPR[2].B.PRI = 0;
    
    // Enable external interrupts
    asm(" wrteei 1");       
}

/**************************************************************************/
/* FUNCTION     : Init_INTC_Priority                                      */
/* PURPOSE      : This function configures the priotrty level for the     */
/*                interrupts. Add configs as required.                    */
/**************************************************************************/
void Init_INTC_Priority(void){

    INTC.PSR60_61.R = 0xE001E001; // set IRQ60 & IRQ61 (eDMA chan 7 & 8) to interrupt processors 0,1 & 2 and  have a priority of 1

}


/**************************************************************************/
/* FUNCTION     : xcptn_xmpl                                              */
/* PURPOSE      : This function sets up the necessary functions to raise  */
/*                and handle a SWT Interrupt in hardware vector mode      */
/**************************************************************************/
void xcptn_xmpl(void) {
    
    // Initialise Core IVPR and IVOR Registers
    e200zX_Interrupt_Setup();       
    
    // Initialize INTC for SW vector mode
    InitINTC();               
    
    // Initialise Interrupt Priorities - set in "ISR_Routines.c"
    Init_INTC_Priority();

    // Enable interrupts
    enableIrq();

}


