#include "../headers/typedefs.h"
#include "../headers/mpc5746m.h"

vuint32_t data_array0[] = {
		0xCAFEBEEF, 0xFEEDFACE, 0xBAADBEEF, 0xFACEBEEF,
		0xBAADFACE, 0xFEEDBEEF, 0xBEEFCAFE, 0xFACECAFE,
		0xCAFEBEEF, 0xFEEDFACE, 0xBAADBEEF, 0xFACEBEEF,
		0xBAADFACE, 0xFEEDBEEF, 0xBEEFCAFE, 0xFACECAFE,
		},
		
		data_array1[] = {
		0x11111111, 0x22222222, 0x33333333, 0x44444444,
		};

/****************** Configure the DMA - Loop of transfers ********************/
void DMA_Init(void)
{
	/* Configure CH0 */
	DMA_0.TCD[0].SADDR = (int)&data_array0[0];
	DMA_0.TCD[0].SMOD = 0;    
	DMA_0.TCD[0].SSIZE = 0x2;	/* 32-bit */
	DMA_0.TCD[0].DMOD = 0;
	DMA_0.TCD[0].DSIZE = 0x2;	/* 32-bit */
	DMA_0.TCD[0].SOFF = 0x4;
	DMA_0.TCD[0].NBYTES = 64;	/* 16x32-bits */
	DMA_0.TCD[0].SLAST = -64;
	DMA_0.TCD[0].DADDR = 0x4001F000;
	DMA_0.TCD[0].CITER_ELINK = 0;     
	//DMA_0.TCD[0].CITER_LINKCH = 0;
	DMA_0.TCD[0].CITER = 1;
	DMA_0.TCD[0].DOFF = 0x4;
	DMA_0.TCD[0].DLAST_SGA = -64;
	DMA_0.TCD[0].BITER = 1;
	DMA_0.TCD[0].BITER_ELINK = 0;
	//DMA_0.TCD[0].BITER_LINKCH = 0;
	DMA_0.TCD[0].BWC = 0;    
	DMA_0.TCD[0].MAJORLINKCH = 1;	/* Link to channel 1 */
	DMA_0.TCD[0].MAJORELINK = 1;	/* Enable channel linking */
	DMA_0.TCD[0].ESG = 0;
	DMA_0.TCD[0].DREQ = 0;
	DMA_0.TCD[0].INTHALF = 0;
	DMA_0.TCD[0].INTMAJ = 0;

	/* Configure CH1 */
	DMA_0.TCD[1].SADDR = (int)&data_array1[0];
	DMA_0.TCD[1].SMOD = 0;    
	DMA_0.TCD[1].SSIZE = 0x2;	/* 32-bit */
	DMA_0.TCD[1].DMOD = 0;
	DMA_0.TCD[1].DSIZE = 0x2;	/* 32-bit */
	DMA_0.TCD[1].SOFF = 0x4;
	DMA_0.TCD[1].NBYTES = 16;	/* 4x32-bits */
	DMA_0.TCD[1].SLAST = -16;
	DMA_0.TCD[1].DADDR = 0x4001FF00;
	DMA_0.TCD[1].CITER_ELINK = 0;     
	//DMA_0.TCD[1].CITER_LINKCH = 0;
	DMA_0.TCD[1].CITER = 1;
	DMA_0.TCD[1].DOFF = 0x4;
	DMA_0.TCD[1].DLAST_SGA = -16;
	DMA_0.TCD[1].BITER = 1;
	DMA_0.TCD[1].BWC = 0;    
	//DMA_0.TCD[1].MAJORLINKCH = 2;	/* Link to channel 2 */
	DMA_0.TCD[1].MAJORELINK = 0;	/* Disable channel linking */
	DMA_0.TCD[1].ESG = 0;
	DMA_0.TCD[1].DREQ = 0;
	DMA_0.TCD[1].INTHALF = 0;
	DMA_0.TCD[1].INTMAJ = 0;
 
} /* DMA_Init */