/*
 * Decompiled with CFR 0.152.
 */
package s12z_magniv_serial_bootloader_interface;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.comm.CommDriver;
import javax.comm.CommPortIdentifier;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import s12z_magniv_serial_bootloader_interface.About;

public class S12Z_MagniV_Serial_Bootloader_Interface
extends JFrame {
    private static CommDriver commDriver;
    File file;
    String CommPort;
    CommPortIdentifier portId;
    Enumeration portList;
    InputStream is;
    OutputStream os;
    SerialPort serialPort;
    SERIAL_Sender sender;
    private JMenuItem aboutMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea1;
    private JTextField jTextField1;
    private JTextPane jTextPane1;
    private JMenuBar menuBar;

    public S12Z_MagniV_Serial_Bootloader_Interface() {
        this.initComponents();
        this.portList = CommPortIdentifier.getPortIdentifiers();
        String[] AvailablePorts = new String[15];
        int portNum = 0;
        System.out.println("Looking for ports.. ");
        while (this.portList.hasMoreElements()) {
            this.portId = (CommPortIdentifier)this.portList.nextElement();
            if (this.portId.getPortType() != 1) continue;
            AvailablePorts[portNum] = this.portId.getName();
            System.out.println("Found port " + this.portId.getName() + ", PortNum: " + ++portNum);
        }
        String[] Model = new String[portNum];
        for (int cnt = 0; cnt < portNum; ++cnt) {
            Model[cnt] = AvailablePorts[cnt];
        }
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(Model));
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jFileChooser1 = new JFileChooser();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton2 = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.setDefaultCloseOperation(3);
        this.setTitle("S12Z Bootloader");
        this.setLocationByPlatform(true);
        this.setResizable(false);
        this.jLabel1.setFont(new Font("Tahoma", 1, 19));
        this.jLabel1.setText("S12Z MagniV Serial Bootloader Interface");
        this.jLabel1.setFocusable(false);
        this.jLabel2.setText("Serial Port");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("File to Upload");
        this.jTextField1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Message Box");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jButton2.setText("Download");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jButton2ActionPerformed(evt);
            }
        });
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 26, -2)).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2, -2, 97, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 314, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addContainerGap()));
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int returnVal = this.jFileChooser1.showOpenDialog(null);
        if (returnVal == 0) {
            this.file = this.jFileChooser1.getSelectedFile();
            this.jTextField1.setText(this.file.getAbsolutePath());
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.jTextArea1.append("Port " + this.jComboBox1.getSelectedItem() + " selected\n");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (this.jTextField1.getText().matches("")) {
            JOptionPane.showMessageDialog(null, "Please select a file to download.");
        } else {
            this.file = new File(this.jTextField1.getText());
            if (this.file.isFile()) {
                this.CommPort = this.jComboBox1.getSelectedItem().toString();
                this.portList = CommPortIdentifier.getPortIdentifiers();
                while (this.portList.hasMoreElements()) {
                    this.portId = (CommPortIdentifier)this.portList.nextElement();
                    if (this.portId.getPortType() != 1 || !this.portId.getName().equals(this.CommPort)) continue;
                }
                this.sender = new SERIAL_Sender();
            } else {
                JOptionPane.showMessageDialog(null, "Didn't select a file or couldn't open it");
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        About AboutScreen = new About((Frame)this, true);
        AboutScreen.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(S12Z_MagniV_Serial_Bootloader_Interface.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(S12Z_MagniV_Serial_Bootloader_Interface.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(S12Z_MagniV_Serial_Bootloader_Interface.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(S12Z_MagniV_Serial_Bootloader_Interface.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.setSecurityManager(null);
        try {
            File myDir = new File(".");
            File myDll = new File(myDir, "win32com.dll");
            try {
                String myPath = myDll.getCanonicalPath();
                System.load(myPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
            commDriver = (CommDriver)Class.forName("com.sun.comm.Win32Driver").newInstance();
            commDriver.initialize();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new S12Z_MagniV_Serial_Bootloader_Interface().setVisible(true);
            }
        });
    }

    class SERIAL_Sender
    extends Thread
    implements SerialPortEventListener {
        String str;
        byte[] readBuffer;
        byte newLine;
        int sentLinesCntr;
        int serialCmd = 0;

        @Override
        public void serialEvent(SerialPortEvent event) {
        }

        byte[] hexStringToByteArray(String s) {
            int len = s.length();
            byte[] data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            }
            return data;
        }

        public SERIAL_Sender() {
            System.out.println("Constructor");
            try {
                System.out.println("1");
                S12Z_MagniV_Serial_Bootloader_Interface.this.serialPort = (SerialPort)S12Z_MagniV_Serial_Bootloader_Interface.this.portId.open("SerialBootloader", 2000);
                System.out.println("2");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Opened " + S12Z_MagniV_Serial_Bootloader_Interface.this.CommPort + "\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
                System.out.println("3");
                S12Z_MagniV_Serial_Bootloader_Interface.this.is = S12Z_MagniV_Serial_Bootloader_Interface.this.serialPort.getInputStream();
                System.out.println("4");
                S12Z_MagniV_Serial_Bootloader_Interface.this.os = S12Z_MagniV_Serial_Bootloader_Interface.this.serialPort.getOutputStream();
                S12Z_MagniV_Serial_Bootloader_Interface.this.os.flush();
                S12Z_MagniV_Serial_Bootloader_Interface.this.os.close();
                S12Z_MagniV_Serial_Bootloader_Interface.this.os = S12Z_MagniV_Serial_Bootloader_Interface.this.serialPort.getOutputStream();
                System.out.println("5");
                S12Z_MagniV_Serial_Bootloader_Interface.this.serialPort.setSerialPortParams(19200, 8, 1, 0);
                System.out.println("6");
                System.out.println("Running thread");
                this.start();
            }
            catch (PortInUseException e) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Error: " + e.getMessage() + "\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
            }
            catch (UnsupportedCommOperationException e) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Error: " + e.getMessage() + "\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
            }
            catch (IOException e) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Error: " + e.getMessage() + "\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
            }
        }

        @Override
        public void run() {
            try {
                S12Z_MagniV_Serial_Bootloader_Interface.this.os.flush();
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Beginning Transmission\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
                BufferedReader in = new BufferedReader(new FileReader(S12Z_MagniV_Serial_Bootloader_Interface.this.file.getAbsolutePath()));
                while ((this.str = in.readLine()) != null) {
                    if (!this.str.startsWith("S2")) continue;
                    System.out.println(this.str);
                    byte[] sendData = this.hexStringToByteArray(this.str.substring(2));
                    do {
                        S12Z_MagniV_Serial_Bootloader_Interface.this.os.flush();
                        for (int i = 0; i < sendData.length; ++i) {
                            S12Z_MagniV_Serial_Bootloader_Interface.this.os.write(sendData[i]);
                        }
                        S12Z_MagniV_Serial_Bootloader_Interface.this.os.flush();
                        System.out.println("DataSent");
                        this.serialCmd = 0;
                        while (this.serialCmd != 65 && this.serialCmd != 69) {
                            this.serialCmd = S12Z_MagniV_Serial_Bootloader_Interface.this.is.read();
                            System.out.println("Serial Value: " + this.serialCmd);
                        }
                    } while (this.serialCmd == 69);
                    ++this.sentLinesCntr;
                    S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Sent line " + this.sentLinesCntr + "\n");
                    S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
                }
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Transmission finished \n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Total lines: " + this.sentLinesCntr + "\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
                System.out.println("Attempting to close port");
                S12Z_MagniV_Serial_Bootloader_Interface.this.serialPort.close();
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("\nSerial Port Closed... \n\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
                while (true) {
                    this.join();
                }
            }
            catch (Exception e) {
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.append("Error: " + e.getMessage() + "\n");
                S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.setCaretPosition(S12Z_MagniV_Serial_Bootloader_Interface.this.jTextArea1.getDocument().getLength());
                return;
            }
        }
    }
}

