/******************************************************************************
  Copyright 2009  Freescale Semiconductor. All rights reserved.

  Module:           pit.c 
  Description:      PIT configuration
  Version:          0.1
  Revision:         0.1
  Date(yyyy.mm.dd): 08 April 2010
  Author(s):        b04629
  Company:          Freescale Semiconductor
                    East Kilbride                                                   
                    Scotland                                                    
 ****************************** Revision History ******************************
    Date(yyyy.mm.dd):   Name              Description 
  
 ******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS 
 WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE 
 TIME. AS A RESULT, FRESCALE SEMICONDUCTOR SHALL NOT BE HELD LIABLE FOR ANY 
 DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 FROM THE CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE 
 CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 *****************************************************************************/
#include "lcd.h"
// Bolero PIT functions

void PIT_CH_ENABLE(vint8_t N, vint32_t LDVAL) 
{
  PIT.CH[N].LDVAL.R         = LDVAL;  /* load PIT counter */  
  PIT.CH[N].TCTRL.B.TIE     = 1;      /* enable interrupt */ 
  PIT.CH[N].TCTRL.B.TEN     = 1;      /* enable channel */   
  PIT.PITMCR.B.MDIS         = 0;      /* enable PIT module */
}


void PIT_CH_DISABLE(vint8_t N)        
{
PIT.CH[N].TCTRL.B.TEN     = 0;
}


void PIT_CH_INT_STOP(vint8_t N)        
{
PIT.CH[N].TCTRL.B.TEN     = 0;      /* enable channel */
}


void PIT_CH_INT_FLAG_CLEAR (vint8_t N) 
{
PIT.CH[N].TFLG.B.TIF    = 1;	 /* clear the interrupt flag of PIT channel 0 */
}