/******************************************************************************
  Copyright 2009  Freescale Semiconductor. All rights reserved.

  Module:           main.h 
  Description:      main header file
  Version:          0.1
  Revision:         0.1
  Date(yyyy.mm.dd): 29 May 2008
  Author(s):        b04629
  Company:          Freescale Semiconductor
                    East Kilbride                                                   
                    Scotland                                                    
 ****************************** Revision History ******************************
    Date(yyyy.mm.dd):   Name              Description 
  
 ******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS 
 WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE 
 TIME. AS A RESULT, FRESCALE SEMICONDUCTOR SHALL NOT BE HELD LIABLE FOR ANY 
 DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 FROM THE CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE 
 CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 *****************************************************************************/
#include "MPC560xBx_1.00.h"
//#include "jdp_0700_1_5M.h"
#include "typedefs.h"
/*****************************************************************************/
void ADC_EOC_isr(void);
void ADC_0_WDG_ISR(void);

/* ADC */
#define ADC_NORMAL_CONV 0
#define ADC_INJ_CONV    1
#define ADC_CTU_CONV    2

/* eMIOS */
#define BUSA 0
#define BUSB 1

/* SIU */
#define ALT1_OUTPUT 0x0600
#define ALT2_OUTPUT 0x0A00
#define ALT3_OUTPUT 0x0E00
#define ALT1_INPUT  0x0500
#define ALT2_INPUT  0x0900
#define ALT3_INPUT  0x0D00


/****************************************************************************/
/*                          MODULE : LCD                                   */
/****************************************************************************/
    struct LCD_tag {

        union {
            vuint32_t R;
            struct {
                vuint32_t:4;
                vuint32_t LCLK:4;
                  vuint32_t:24;
            } B;
        } PCR;                  /* LCD Prescaler Control Register */

        union {
            vuint32_t R;
            struct {
                vuint32_t CCEN:1;
                  vuint32_t:4;
                vuint32_t LCC:11;
                  vuint32_t:16;
            } B;
        } CCR;                  /* LCD Contrast Control Register */

        int32_t LCD_reserved1;  /* (0x10 - 0x0C)/4 = 0x01 */

        union {
            vuint32_t R;
            struct {
                vuint32_t FP31EN:1;
                vuint32_t FP30EN:1;
                vuint32_t FP29EN:1;
                vuint32_t FP28EN:1;
                vuint32_t FP27EN:1;
                vuint32_t FP26EN:1;
                vuint32_t FP25EN:1;
                vuint32_t FP24EN:1;
                vuint32_t FP23EN:1;
                vuint32_t FP22EN:1;
                vuint32_t FP21EN:1;
                vuint32_t FP20EN:1;
                vuint32_t FP19EN:1;
                vuint32_t FP18EN:1;
                vuint32_t FP17EN:1;
                vuint32_t FP16EN:1;
                vuint32_t FP15EN:1;
                vuint32_t FP14EN:1;
                vuint32_t FP13EN:1;
                vuint32_t FP12EN:1;
                vuint32_t FP11EN:1;
                vuint32_t FP10EN:1;
                vuint32_t FP9EN:1;
                vuint32_t FP8EN:1;
                vuint32_t FP7EN:1;
                vuint32_t FP6EN:1;
                vuint32_t FP5EN:1;
                vuint32_t FP4EN:1;
                vuint32_t FP3EN:1;
                vuint32_t FP2EN:1;
                vuint32_t FP1EN:1;
                vuint32_t FP0EN:1;
            } B;
        } FPENR0;               /* LCD Frontplane Enable Register 0 */

        union {
            vuint32_t R;
            struct {
                vuint32_t FP63EN:1;
                vuint32_t FP62EN:1;
                vuint32_t FP61EN:1;
                vuint32_t FP60EN:1;
                vuint32_t FP59EN:1;
                vuint32_t FP58EN:1;
                vuint32_t FP57EN:1;
                vuint32_t FP56EN:1;
                vuint32_t FP55EN:1;
                vuint32_t FP54EN:1;
                vuint32_t FP53EN:1;
                vuint32_t FP52EN:1;
                vuint32_t FP51EN:1;
                vuint32_t FP50EN:1;
                vuint32_t FP49EN:1;
                vuint32_t FP48EN:1;
                vuint32_t FP47EN:1;
                vuint32_t FP46EN:1;
                vuint32_t FP45EN:1;
                vuint32_t FP44EN:1;
                vuint32_t FP43EN:1;
                vuint32_t FP42EN:1;
                vuint32_t FP41EN:1;
                vuint32_t FP40EN:1;
                vuint32_t FP39EN:1;
                vuint32_t FP38EN:1;
                vuint32_t FP37EN:1;
                vuint32_t FP36EN:1;
                vuint32_t FP35EN:1;
                vuint32_t FP34EN:1;
                vuint32_t FP33EN:1;
                vuint32_t FP32EN:1;
            } B;
        } FPENR1;               /* LCD Frontplane Enable Register 1 */

        int32_t LCD_reserved2[2];       /* (0x20 - 0x18)/4 = 0x02 */

        union {
            vuint32_t R;
        } RAM[16];              /* LCD RAM Register */

    };                          /* end of LCD_tag */




