#include "MPC560xBx_1.00.h"
//#include "jdp_0700_1_5M.h"
#include "typedefs.h"

// ----- LCD application specific parameters ------
#define PWM 1	// waveform generation method
				// 0 -  method1 - 2 bias with 2 external resistors per backplane
				// 1 -  method2 - all bias levels based on PWM with external RC components 

#define PIT_CH_NR 0	// PIT channel number to be used for waveform timing
#define PIT_INIT_VALUE 0x1000 // this is the init value for PIT, delay before starting the waveform genearion after init

#define DMA_CH_for_PIT 0 // DMA channel for copying waveform timing values from Ram to PIT
#if PWM==0
	#define DMA_CH_for_PCR 1	// DMA channel for copying pad configuration data for backplanes from RAM to SIUL pad configuration registers
	#define DMA_CH_for_MPGPDO 2	// DMA channel for copying pad configuration data for backplanes from RAM to SIUL pad configuration registers
#else
	#define DMA_CH_for_EMIOS_BP 1 	// DMA channel for copying PWM duty cycle values for backplanes from RAM to eMIOS
	#define DMA_CH_for_EMIOS_FP 2	// DMA channel for copying PWM duty cycle values for frotplanes from RAM to eMIOS
#endif

#define LCD_BP_CNT	4   // number of backplanes
//#define LCD_FP_CNT	31  // number of frontplanes external RC
#define LCD_FP_CNT	16  // number of frontplanes external R
#define LCD_IDLE_CNT	0   // number of contrast adjustment phases per refresh cycle
#define CONTRAST_RMS_INCREASE 1 // '1' - voltage levels for BP and FP will be set to opposite
								// voltage levels during contrast adjustment phases to increase RMS
								// '0' - voltage levels for BP and FP will be set to the same 
								// voltage levels during contrast adjustment phases to decrease RMS 
								// in this driver version this paremeter is valid for method 2 only (EMIOS=1)
#define BIAS_CNT			3   // waveform type, voltage levels = bias + 1 

#define LCD_FRAME_FREQUENCY  60  // LCD refresh cycle frequency in Hz 

#define MPGPDO_REG_CNT	4   // number of MPGPDO registers, must be power of 2

#define emios_peripheral_prescaler	1   // peripheral set 3 prescaler
#define emios_predivider		1   // emios global prescaler value
#define PWM_period_cycles 		99 // number of emios clock cycles withon one PWM period



/* DMA related start addresses */
//#define BP_PIT_BASE  0xC3F90040UL
#define MPGPDO_BASE  0xC3F90C80UL
#define PCR_BASE_FOR_BP  0xC3F90060UL

#define PCR_OUTPUT_DIR 0x0200;
#define PCR_INPUT_DIR 0x0100;
#define PCR_TRISTATE 0x0000;
#define PCR_OUTPUT_DIR 0x0200;
#define PCR_EMIOS_ALT1_DIR 0x0600;
#define PCR_EMIOS_ALT2_DIR 0x0A00;
#define PCR_EMIOS_ALT3_DIR 0x0E00;

 
/* FP PCR number, MPGPDO number, bit in MPGPDO */
#define PCR_NUMBER 			 	0
#define MPGPDO_NUMBER        	1
#define BIT_POSITION_IN_MPGPDO 	2
#define EMIOS_CH_NUMBER 		1
#define PCR_EMIOS_AF 			2

/* structure describing LCD data and current state of the drive */
typedef struct {
  uint32_t display_data[LCD_BP_CNT][LCD_FP_CNT]; 	
  uint32_t phase: (LCD_BP_CNT+LCD_IDLE_CNT)*2;
  uint32_t polarity:1;
  uint32_t bus_frequency;
  uint32_t emios_frequency;
  uint32_t phase_reload;   /* frame period = (LCD_BP_CNT+LCD_IDLE_CNT)*<interrupt period> */
  
  uint32_t data_period;         /* data period in one cycle, does not include contrast period, buffered value for next update */
  uint32_t data_period_active;	/* data period in one cycle, does not include contrast period, current value for LCD waveform generation  */
  uint32_t contrast_period; /* contrast period in one cycle, buffered value for next update */
  uint32_t contrast_period_active;       /* contrast period in one cycle, current value for LCD waveform generation  */
  uint32_t data_phase_period;         /*  data_phase_period = data_period / LCD_BP_CNT, buffered value for next update */
  uint32_t data_phase_period_active;    /*  data_phase_period = data_period / LCD_BP_CNT, current value for LCD waveform generation  */
  /* please note that LCD_FRAME_FREQUENCY is equivalent to refresh cycle period */
  /* refresh cycle period = data_period + contrast_period */
  /* whenever user change contrast adjustment time by changing contrast_period, driver will recalculate the data_period to match LCD_FRAME_FREQUENCY */ 
} tLCD_data;

//extern tLCD_data LCD_data;


/* prototypes of CPU functions and the shared data structure */
extern void LCD_init(unsigned int bus_frequency, int contrast_adj); /* bus frequency is in kHz */
extern void LCD_contrast(unsigned int bus_frequency, int contrast_adj);
extern void LCD_stop(void);
extern void LCD_ALL_PINS_LOW(void);           /* drive all pins low once they are configured as outputs */
extern void LCD_ALL_CONFIGURE(void);          /* configure all pins as outputs */
extern void LCD_INT_CONFIGURE(void);          /* configure the periodic interrupt source */

extern uint32_t MPGPDO_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][MPGPDO_REG_CNT];
extern uint16_t PCR_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_BP_CNT];
extern uint32_t PIT_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2];
extern uint32_t EMIOS_BP_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_BP_CNT];
extern uint32_t EMIOS_FP_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_FP_CNT];
//extern volatile int BP_SIUL_INFO [LCD_BP_CNT][4];
//extern vuint32_t FP_SIUL_INFO [LCD_FP_CNT][4];
