#include "MPC560xBx_1.00.h"
//#include "main.h"
#include "lcd.h"




//--------VARIABLES & FUNCTIONS---------------------------
tLCD_data LCD_data;

/* PIT value for DMA, needed to have the option to select different cycle and contrast adjustment timing */
uint32_t PIT_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2]=
{0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000};

uint32_t eMIOS_TIMING_DATA_FOR_DMA [BIAS_CNT+1];

#if PWM==0 //--- external RC----

uint32_t MPGPDO_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][MPGPDO_REG_CNT];
uint16_t PCR_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_BP_CNT];
void INIT_BACKPLANE_PCR_DATA_FOR_DMA(void);

#else //------external resistor--

uint32_t EMIOS_BP_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_BP_CNT];
uint32_t EMIOS_FP_DATA_FOR_DMA [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_FP_CNT];
void INIT_EMIOS_DATA_FOR_DMA(void);

#endif



//--------------GPIO data---------------------------------
//--------------------------------------------------------



//-------------------- Method 1 init ---------------------
//--------------------------------------------------------
#if PWM==0

// init values for 2 backplanes 
#if LCD_BP_CNT0==2

// ---- masked paralle data output registers init values ----
const uint32_t MPGPDO_DATA_FOR_DMA_CONST [(LCD_BP_CNT+LCD_IDLE_CNT)*2][MPGPDO_REG_CNT]=
{
{0xFFFF0000,0xC0010000,0x3FFF0000,0x00000000}, // cycle 0, phase 0 
{0xFFFF0000,0xC0018000,0x3FFF0000,0x00000000}, // cycle 0, phase 1 
{0xFFFFFFFF,0xC001C001,0x3FFF3FFF,0x00000000}, // cycle 0, contrast adjustment phase
{0xFFFFFFFF,0xC001C001,0x3FFF3FFF,0x00000000}, // cycle 1, phase 0 
{0xFFFFFFFF,0xC0014001,0x3FFF3FFF,0x00000000}, // cycle 1, phase 0 
{0xFFFF0000,0xC0010000,0x3FFF0000,0x00000000}  // cycle 1, contrast adjustment phase 
};

// ----------- PCR Register Mask for BP planes ------
const uint16_t PCR_DATA_FOR_DMA_CONST [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_BP_CNT]=
{
{0x0000,0x0000 }, // cycle 0, phase 0 
{0x0000,0x0000 }, // cycle 0, phase 1 
{0x0000,0x0000 }, // cycle 0, contrast adjustment phase
{0x0000,0x0000 }, // cycle 1, phase 0 
{0x0000,0x0000 }, // cycle 1, phase 0 
{0x0000,0x0000 }  // cycle 1, contrast adjustment phase
};

// -------- pad info for backplanes -------------- 
// [ PCR_NUMBER, MPGPDO_NUMBER, BIT_POSITION_IN_MPGPDO ]
const vuint8_t BP_SIUL_INFO [LCD_BP_CNT][3]=
{
{16,1,0}, // LCD backplane0  -> PB[0]
{17,1,1}  // LCD backplane1  -> PB[1]
};

#endif


// init values for 4 backplanes 
#if LCD_BP_CNT==4

// ---- masked paralle data output registers init values ----
const uint32_t MPGPDO_DATA_FOR_DMA_CONST [(LCD_BP_CNT+LCD_IDLE_CNT)*2][MPGPDO_REG_CNT]=
{
{0xFFFF0000,0xF0017000,0x3FFF0000,0x00000000}, // cycle 0, phase 0 
{0xFFFF0000,0xF001B000,0x3FFF0000,0x00000000}, // cycle 0, phase 1 
{0xFFFF0000,0xF001D000,0x3FFF0000,0x00000000}, // cycle 0, phase 2
{0xFFFF0000,0xF001E000,0x3FFF0000,0x00000000}, // cycle 0, phase 3
{0xFFFFFFFF,0xF001F001,0x3FFF3FFF,0x00000000}, // cycle 0, contrast adjustment phase
{0xFFFFFFFF,0xF0018001,0x3FFF3FFF,0x00000000}, // cycle 1, phase 0
{0xFFFFFFFF,0xF0014001,0x3FFF3FFF,0x00000000}, // cycle 1, phase 1
{0xFFFFFFFF,0xF0012001,0x3FFF3FFF,0x00000000}, // cycle 1, phase 2
{0xFFFFFFFF,0xF0011001,0x3FFF3FFF,0x00000000}, // cycle 1, phase 3
{0xFFFF0000,0xF0010000,0x3FFF0000,0x00000000}  // cycle 1, contrast adjustment phase
};

// ----------- PCR Register Mask for BP planes ------
const uint16_t PCR_DATA_FOR_DMA_CONST [(LCD_BP_CNT+LCD_IDLE_CNT)*2][LCD_BP_CNT]=
{
{0x0000,0x0000,0x0000,0x0000 }, // cycle 0, phase 0 
{0x0000,0x0000,0x0000,0x0000 }, // cycle 0, phase 1 
{0x0000,0x0000,0x0000,0x0000 }, // cycle 0, phase 2
{0x0000,0x0000,0x0000,0x0000 }, // cycle 0, phase 3
{0x0000,0x0000,0x0000,0x0000 }, // cycle 0, contrast adjustment phase
{0x0000,0x0000,0x0000,0x0000 }, // cycle 1, phase 0
{0x0000,0x0000,0x0000,0x0000 }, // cycle 1, phase 1
{0x0000,0x0000,0x0000,0x0000 }, // cycle 1, phase 2
{0x0000,0x0000,0x0000,0x0000 }, // cycle 1, phase 3
{0x0000,0x0000,0x0000,0x0000 }  // cycle 1, contrast adjustment phase
};

// -------- pad info for backplanes -------------- 
// [ PCR_NUMBER, MPGPDO_NUMBER, BIT_POSITION_IN_MPGPDO ]
const vuint8_t BP_SIUL_INFO [LCD_BP_CNT][3]=
{
{16,1,0},  // LCD backplane0  -> PB[0] 
{17,1,1},  // LCD backplane1  -> PB[1]
{18,1,2},  // LCD backplane2  -> PB[2] 
{19,1,3}   // LCD backplane3  -> PB[3]
};

#endif


// pad configuration info for frontplanes
// [ PCR_NUMBER, MPGPDO_NUMBER, BIT_POSITION_IN_MPGPDO ]
const vuint8_t FP_SIUL_INFO [LCD_FP_CNT][3]=
{
{0,0,0},   // LCD frontplane0   -> PA[0]
{1,0,1},   // LCD frontplane1   -> PA[1]
{2,0,2},   // LCD frontplane2   -> PA[2]
{3,0,3},   // LCD frontplane3   -> PA[3]
{4,0,4},   // LCD frontplane4   -> PA[4]
{5,0,5},   // LCD frontplane5   -> PA[5]
{6,0,6},   // LCD frontplane6   -> PA[6]
{7,0,7},   // LCD frontplane7   -> PA[7]
{8,0,8},   // LCD frontplane8   -> PA[8]
{9,0,9},   // LCD frontplane9   -> PA[9]
{10,0,10}, // LCD frontplane10  -> PA[10]
{11,0,11}, // LCD frontplane11  -> PA[11]
{12,0,12}, // LCD frontplane12  -> PA[12]
{13,0,13}, // LCD frontplane13  -> PA[13]
{14,0,14}, // LCD frontplane14  -> PA[14]
{15,0,15}, // LCD frontplane15  -> PA[15]
{31,1,15}, // LCD frontplane16  -> PB[15]
{34,2,2},  // LCD frontplane17  -> PC[2]
{35,2,3},  // LCD frontplane18  -> PC[3]
{36,2,4},  // LCD frontplane19  -> PB[4]
{37,2,5},  // LCD frontplane20  -> PC[5]
{38,2,6},  // LCD frontplane21  -> PC[6]
{39,2,7},  // LCD frontplane22  -> PC[7]
{40,2,8},  // LCD frontplane23  -> PC[8]
{41,2,9},  // LCD frontplane24  -> PC[9]
{42,2,10}, // LCD frontplane25  -> PC[10]
{43,2,11}, // LCD frontplane26  -> PC[11]
{44,2,12}, // LCD frontplane27  -> PC[12]
{45,2,13}, // LCD frontplane28  -> PC[13]
{46,2,14}, // LCD frontplane29  -> PC[14]
{47,2,15}  // LCD frontplane30  -> PC[15]
};

#else


//-------------------- Method 2 init ---------------------
//--------------------------------------------------------

// --- gloabl timebase 
// [ PCR_NUMBER, EMIOS_CH_NUMBER, PCR_EMIOS_AF ]  
const vuint32_t EMIOS_TIMEBASE_INFO [3] =
{71,23,1};

#if LCD_BP_CNT==2
// [ PCR_NUMBER, EMIOS_CH_NUMBER, PCR_EMIOS_AF ] 
const vuint32_t BP_EMIOS_INFO [LCD_BP_CNT][3]=
{
{12,28,2}, // LCD backplane0  -> PA[12]
{13,29,2}  // LCD backplane1  -> PA[13]
};
#endif

#if LCD_BP_CNT==4
// [ PCR_NUMBER, EMIOS_CH_NUMBER, PCR_EMIOS_AF ] 
const vuint32_t BP_EMIOS_INFO [LCD_BP_CNT][3]=
{
{12,28,2}, // LCD backplane0  -> PA[12]
{13,29,2}, // LCD backplane1  -> PA[13]
{16,30,2}, // LCD backplane0  -> PA[12]
{17,31,2}  // LCD backplane1  -> PA[13]
};
#endif

// [ PCR_NUMBER, EMIOS_CH_NUMBER, PCR_EMIOS_AF ] 
const vuint32_t FP_EMIOS_INFO [LCD_FP_CNT][3]=
{
{0,0,1},   // LCD frontplane0   -> PA[0]
{1,1,1},   // LCD frontplane1   -> PA[1]
{2,2,1},   // LCD frontplane2   -> PA[2]
{3,3,1},   // LCD frontplane3   -> PA[3]
{4,4,1},   // LCD frontplane4   -> PA[4]
{5,5,1},   // LCD frontplane5   -> PA[5]
{6,6,1},   // LCD frontplane6   -> PA[6]
{7,7,1},   // LCD frontplane7   -> PA[7]
{8,8,1},   // LCD frontplane8   -> PA[8]
{9,9,1},   // LCD frontplane9   -> PA[9]
{10,10,1}, // LCD frontplane10  -> PA[10]
{11,11,1}, // LCD frontplane11  -> PA[11]
{44,12,1}, // LCD frontplane12  -> PC[12]
{45,13,1}, // LCD frontplane13  -> PC[13]
{46,14,1}, // LCD frontplane14  -> PC[14]
{47,15,1} // LCD frontplane15  -> PC[15]
//{64,16,1}, // LCD frontplane16  -> PE[0]
//{65,17,1}, // LCD frontplane17  -> PE[1]
//{66,18,1}, // LCD frontplane18  -> PE[2]
//{67,19,1}, // LCD frontplane19  -> PE[3]
//{68,20,1}, // LCD frontplane20  -> PE[4]
//{69,21,1}, // LCD frontplane21  -> PE[5]
//{70,22,1}, // LCD frontplane22  -> PE[6]
//{60,24,2}, // LCD frontplane23  -> PC[8]
//{61,25,2}, // LCD frontplane24  -> PC[9]
//{62,26,2}, // LCD frontplane25  -> PC[10]
//{63,27,2}  // LCD frontplane26  -> PC[11]
};
#endif
//-------------------------------------------------



/* ------------------------------ F U N C T I O N S -------------------------------------*/

/**************************************************************************/
/* FUNCTION     : LCD_ALL_PINS_LOW                                        */
/* PURPOSE      : function to drive all front and backplane pins low      */
/**************************************************************************/

void LCD_ALL_PINS_LOW(void)
{
int i=0;
/* init PCR and set output to low for back planes */
#if (PWM == 0)

for (i=0; i<LCD_BP_CNT;i++)
	{
	SIU.PCR[BP_SIUL_INFO[i][PCR_NUMBER]].R = PCR_OUTPUT_DIR;
	SIU.GPDO[BP_SIUL_INFO[i][PCR_NUMBER]].R = 0;
	}
for (i=0; i<LCD_FP_CNT;i++)
	{
	SIU.PCR[(FP_SIUL_INFO[i][PCR_NUMBER])].R = PCR_OUTPUT_DIR;
	SIU.GPDO[FP_SIUL_INFO[i][PCR_NUMBER]].R = 0;	
	}
	
#else
	
for (i=0; i<LCD_BP_CNT;i++)
	{
	SIU.PCR[BP_EMIOS_INFO[i][PCR_NUMBER]].R = PCR_OUTPUT_DIR;
	SIU.GPDO[BP_EMIOS_INFO[i][PCR_NUMBER]].R = 0;	
	}
for (i=0; i<LCD_FP_CNT;i++)
	{
	SIU.PCR[FP_EMIOS_INFO[i][PCR_NUMBER]].R = PCR_OUTPUT_DIR;
	SIU.GPDO[FP_EMIOS_INFO[i][PCR_NUMBER]].R = 0;
	}
	
#endif
}


/**************************************************************************/
/* FUNCTION     : INIT_MODULES_FOR_LCD                                    */
/* PURPOSE      :                                						  */
/**************************************************************************/
void INIT_MODULES_FOR_LCD(void)
{
int i = 0;
	
#if PWM==0 

/* init PCR and set output to low for back planes */
for (i=0; i<LCD_BP_CNT;i++)
	{
	SIU.PCR[BP_SIUL_INFO[i][PCR_NUMBER]].R = PCR_OUTPUT_DIR;
	//SIU.GPDO[BP_SIUL_INFO[i][PCR_NUMBER]].R = 0;
	}	
/* init PCR and set output to low for front planes */
for (i=0; i<LCD_FP_CNT;i++)
	{
	SIU.PCR[(FP_SIUL_INFO[i][PCR_NUMBER])].R = PCR_OUTPUT_DIR;
	//SIU.GPDO[FP_SIUL_INFO[i][PCR_NUMBER]].R = 0;
	}
	
#else
	
   EMIOS_0_BUS_init(EMIOS_TIMEBASE_INFO[PCR_NUMBER],EMIOS_TIMEBASE_INFO[EMIOS_CH_NUMBER],EMIOS_TIMEBASE_INFO[PCR_EMIOS_AF], emios_predivider, PWM_period_cycles);             /* GPRE, MOD COUNT => 64MHz/2/(99+1) = 320kHz */
   EMIOS_0_BUS_init(71, 23, 1, emios_predivider, PWM_period_cycles);   
  //----------backplane channels
  	for (i=0;i<LCD_BP_CNT; i++)
	{
	// call eMIOS OPWMT init function to initialize PCR and eMIOS registers according to structure defined in BP_EMIOS_INFO
	EMIOS_0_OPWMT_CH_init(BP_EMIOS_INFO[i][PCR_NUMBER], BP_EMIOS_INFO[i][EMIOS_CH_NUMBER], BP_EMIOS_INFO[i][PCR_EMIOS_AF]);
	}
		
  	for (i=0;i<LCD_FP_CNT; i++)
	{
	// call eMIOS OPWMT init function to initialize PCR and eMIOS registers according to structure defined in BP_EMIOS_INFO
	EMIOS_0_OPWMT_CH_init(FP_EMIOS_INFO[i][PCR_NUMBER], FP_EMIOS_INFO[i][EMIOS_CH_NUMBER], FP_EMIOS_INFO[i][PCR_EMIOS_AF]);
	}
	
#endif

  /* ---- Configure DMA---------- */
  DMA_init(); 
  
  /* ----- Configure PIT--------- */
  PIT_CH_ENABLE(PIT_CH_NR, PIT_INIT_VALUE);    /* Channel 0, Count Value = 0.5s x 64MHz = 32,000,000 */

}  


    
/**************************************************************************/
/* FUNCTION     : INIT_PIT_DATA_FOR_DMA                                   */
/* PURPOSE      : init array for phase timing, to be read by DMA          */
/**************************************************************************/
void INIT_PIT_DATA_FOR_DMA (void)
{
int i,j=0;

for (i=0; i<(LCD_BP_CNT+LCD_IDLE_CNT)*2;i++) /* waveform consists of LCD_BP_CNT+LCD_IDLE_CNT cycles, *2 is due to even and odd part of the waveform */ 	
	{ /* recheck whether this will work for LCD_IDLE_CNT>1*/
		if ((LCD_IDLE_CNT>0)&((i==LCD_BP_CNT+LCD_IDLE_CNT-2) | (i==(LCD_BP_CNT+LCD_IDLE_CNT)*2-2)))
		{
			PIT_DATA_FOR_DMA[i] = LCD_data.contrast_period_active;
		}
		else
		{
			PIT_DATA_FOR_DMA[i] = LCD_data.data_phase_period_active;	
		}
	}

}


#if (PWM==0) // 
/**************************************************************************/
/* FUNCTION     : INIT_BACKPLANE_PCR_DATA_FOR_DMA                         */
/* PURPOSE      : init array for backplane PCR registers,to be read by DMA*/
/**************************************************************************/
void INIT_BACKPLANE_PCR_DATA_FOR_DMA(void)
{
int i,j=0;

PCR_DATA_FOR_DMA = PCR_DATA_FOR_DMA_CONST;
	
for (i=0; i<(LCD_BP_CNT+LCD_IDLE_CNT);i++) /* waveform consists of LCD_BP_CNT+LCD_IDLE_CNT cycles, *2 is due to even and odd part of the waveform */ 
{
 	for (j=0; j<LCD_BP_CNT;j++) /* port direction can change for backplane ports */ 
	{
		if ((i==j) | (i==(LCD_BP_CNT+LCD_IDLE_CNT-1)))
		{
			PCR_DATA_FOR_DMA[i][j] = PCR_OUTPUT_DIR; // EVEN refresh cycle
			PCR_DATA_FOR_DMA[i+LCD_BP_CNT+LCD_IDLE_CNT][j] = PCR_OUTPUT_DIR // ODD refresh cycle
		}
		else	
		{
		/* configure BP pin as tristate in the DMA structure */
			PCR_DATA_FOR_DMA[i][j] = PCR_TRISTATE; // EVEN refresh cycle
	    	PCR_DATA_FOR_DMA[i+LCD_BP_CNT+LCD_IDLE_CNT][j] = PCR_TRISTATE; // ODD refresh cycle
		}

	}
}
	
	
}
#endif



/**********************************************************************************/
/* FUNCTION     : INIT_WAVEFORM_FOR_DMA                                           */
/* PURPOSE      : initialize the data for DMA which is used to drive the waveform */
/**********************************************************************************/
void INIT_WAVEFORM_FOR_DMA (void)
{

INIT_PIT_DATA_FOR_DMA();
 
#if PWM==0

MPGPDO_DATA_FOR_DMA = MPGPDO_DATA_FOR_DMA_CONST;
INIT_BACKPLANE_PCR_DATA_FOR_DMA();

#else 

INIT_EMIOS_DATA_FOR_DMA();

#endif
}


/* contrast adjustment: normal phase and contrast adjustment phase calculation */
void LCD_contrast(unsigned int bus_frequency, int contrast_adj) 
{
LCD_data.data_period = ((((unsigned long int)bus_frequency/LCD_FRAME_FREQUENCY)-LCD_IDLE_CNT*(unsigned long int)contrast_adj)/(LCD_BP_CNT+LCD_IDLE_CNT))-1;
LCD_data.data_period_active = LCD_data.data_period;	
 
LCD_data.data_phase_period = LCD_data.data_period/LCD_BP_CNT;
LCD_data.data_phase_period_active = LCD_data.data_phase_period;

/* contrast adjustment parameter can be positive or negative, it defines the deviation from data_period */
LCD_data.contrast_period = LCD_data.data_phase_period + contrast_adj;	
LCD_data.contrast_period_active = LCD_data.contrast_period;

/* after updating the LCD_data the DMA data structure for PIT timer must be updated*/ 
if (LCD_IDLE_CNT >0)
{
INIT_PIT_DATA_FOR_DMA();	
}

}


/**********************************************************************************/
/* FUNCTION     : update_waveform                                                 */
/* PURPOSE      : update LCD visible and invisible segments                       */
/**********************************************************************************/
void update_waveform ( uint32_t BP_NUMBER, uint32_t FP_NUMBER, uint8_t visible)
{
int i=0;
uint32_t DATA_MASK_0 =0xFFFFFFFF;
uint32_t DATA_MASK_1 =0x00000000;
uint32_t MPGPDO_NUMBER_TEMP = 0;


/* read MPGPDO number from BP_SIUL_INFO array defined in LCD.h */

//#if eMIOS==1

#if PWM==0

	DATA_MASK_1 = DATA_MASK_1 | (1UL << (15-FP_SIUL_INFO[FP_NUMBER][BIT_POSITION_IN_MPGPDO]) );
	DATA_MASK_0 = ~DATA_MASK_1 ;
	MPGPDO_NUMBER_TEMP = FP_SIUL_INFO[FP_NUMBER][MPGPDO_NUMBER];
	if ( visible )
	{
	// set MPGPDO data for DMA for EVEN refresh cycle
	MPGPDO_DATA_FOR_DMA[BP_NUMBER][MPGPDO_NUMBER_TEMP] = MPGPDO_DATA_FOR_DMA[BP_NUMBER][MPGPDO_NUMBER_TEMP] | DATA_MASK_1;	
	// set MPGPDO data for DMA for ODD refresh cycle
	MPGPDO_DATA_FOR_DMA[LCD_BP_CNT+LCD_IDLE_CNT+BP_NUMBER][MPGPDO_NUMBER_TEMP] = MPGPDO_DATA_FOR_DMA[LCD_BP_CNT+LCD_IDLE_CNT+BP_NUMBER][MPGPDO_NUMBER_TEMP] & DATA_MASK_0;
	}
	else
	{
	// set MPGPDO data for DMA for EVEN refresh cycle
	MPGPDO_DATA_FOR_DMA[BP_NUMBER][MPGPDO_NUMBER_TEMP] = MPGPDO_DATA_FOR_DMA[BP_NUMBER][MPGPDO_NUMBER_TEMP] & DATA_MASK_0;
	// set MPGPDO data for DMA for ODD refresh cycle	
	MPGPDO_DATA_FOR_DMA[LCD_BP_CNT+LCD_IDLE_CNT+BP_NUMBER][MPGPDO_NUMBER_TEMP] = MPGPDO_DATA_FOR_DMA[LCD_BP_CNT+LCD_IDLE_CNT+BP_NUMBER][MPGPDO_NUMBER_TEMP] | DATA_MASK_1;
	}

#else 

	if ( visible )
	{
	/*Drive electrode BPphase to voltage level HIGH in even contrust adjustment cycle */
	EMIOS_FP_DATA_FOR_DMA[BP_NUMBER][FP_NUMBER]= eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT];
	/*Drive electrode BPphase to voltage level LOW in odd contrust adjustment cycle */	
	EMIOS_FP_DATA_FOR_DMA[LCD_BP_CNT+LCD_IDLE_CNT+BP_NUMBER][FP_NUMBER]= eMIOS_TIMING_DATA_FOR_DMA[0];		
	}
	else
	{
	/*Drive electrode BPphase to voltage level HIGH in even contrust adjustment cycle */
	EMIOS_FP_DATA_FOR_DMA[BP_NUMBER][FP_NUMBER]= eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT-2];
   /*Drive electrode BPphase to voltage level LOW in odd contrust adjustment cycle */	
	EMIOS_FP_DATA_FOR_DMA[LCD_BP_CNT+LCD_IDLE_CNT+BP_NUMBER][FP_NUMBER]= eMIOS_TIMING_DATA_FOR_DMA[2];		
	}

#endif	
	

/* update display information in LCD_data structure */
LCD_data.display_data[BP_NUMBER][FP_NUMBER]= visible;

}
 
 
/**********************************************************************************/
/* FUNCTION     : INIT_EMIOS_DATA_FOR_DMA                                         */
/* PURPOSE      : init backplane and frontplane EMIOS DATA structure for DMA      */
/**********************************************************************************/ 
void INIT_EMIOS_DATA_FOR_DMA(void)
{

int i,j;

for (i=0; i<(BIAS_CNT+1); i++)
	 eMIOS_TIMING_DATA_FOR_DMA[i]= PWM_period_cycles / BIAS_CNT * i; // review !!!

// ----------------- even refresh cycle --------------------------
// ---------------------backplanes--------------------------------
for (i=0; i<(LCD_BP_CNT);i++)	
{
/* --- DATA in EMIOS memory structure for Backplane Ports---*/
	for (j=0;j<LCD_BP_CNT; j++)
		{
		if (i==j)
		/*Drive electrode BPphase to voltage level 0 */
			EMIOS_BP_DATA_FOR_DMA[i][j]= eMIOS_TIMING_DATA_FOR_DMA[0];	
		
		else
		/*Drive all other BP electrodes to voltage level b-1 */
			EMIOS_BP_DATA_FOR_DMA[i][j]= eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT-1];
		}
}

// ---------------------frontplanes-----------------------------
for (i=0; i<(LCD_BP_CNT);i++)	
{
/* --- DATA in EMIOS memory structure for Frontplane Ports---*/
	for (j=0;j<LCD_FP_CNT; j++)
		{
	//	if (BIAS_CNT==2)
		/*Drive all other FP electrodes to voltage level b-2  => invisible,  */
	//		EMIOS_FP_DATA_FOR_DMA[i][j]= eMIOS_TIMING_DATA_FOR_DMA[1];
	//	else
			EMIOS_FP_DATA_FOR_DMA[i][j]= eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT-2];	
		}
}

// ----------------- odd refresh cycle --------------------------
// ---------------------backplanes--------------------------------
for (i=0; i<(LCD_BP_CNT);i++)	
{
	for (j=0;j<LCD_BP_CNT; j++)
	{
		if (i==j)
		/*Drive electrode BPphase to voltage level 0 */
			EMIOS_BP_DATA_FOR_DMA[i+LCD_BP_CNT+LCD_IDLE_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT];	
		
		else
		/*Drive all other BP electrodes to voltage level b-1 */
		
			EMIOS_BP_DATA_FOR_DMA[i+LCD_BP_CNT+LCD_IDLE_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[1];
		
	}
}

// ---------------------frontplanes-----------------------------
for (i=0; i<(LCD_BP_CNT);i++)	
{
/* --- DATA in EMIOS memory structure for Frontplane Ports---*/
	for (j=0;j<LCD_FP_CNT; j++)
		{
		/*Drive all other BP electrodes to voltage level b-1 => invisible */
			EMIOS_FP_DATA_FOR_DMA[i+LCD_BP_CNT+LCD_IDLE_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[2];
		}
}


//------------------ contrast adjustment cycle ----------------
//--------------------backplanes-------------------------------
for (i=0; i<(LCD_IDLE_CNT);i++)	
{
	/* --- DATA in EMIOS memory structure for construst adjustment Backplane Ports---*/
	for (j=0;j<LCD_BP_CNT; j++)
	{
		/*Drive electrode BPphase to voltage level HIGH in even contrust adjustment cycle */
		EMIOS_BP_DATA_FOR_DMA[i+LCD_BP_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT];
		/*Drive electrode BPphase to voltage level LOW in odd contrust adjustment cycle */	
		EMIOS_BP_DATA_FOR_DMA[i+LCD_BP_CNT*2+LCD_IDLE_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[0];		
	}
}

//--------------------frontplanes-------------------------------
for (i=0; i<(LCD_IDLE_CNT);i++)	
{
	/* --- DATA in EMIOS memory structure for construst adjustment Backplane Ports---*/
	for (j=0;j<LCD_FP_CNT; j++)
	{
		
	#if (CONTRAST_RMS_INCREASE==1)
	{
			/*Drive electrode BPphase to voltage level LOW in even contrust adjustment cycle */
		EMIOS_FP_DATA_FOR_DMA[i+LCD_BP_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[0];
		/*Drive electrode BPphase to voltage level HIGH in odd contrust adjustment cycle */	
		EMIOS_FP_DATA_FOR_DMA[i+LCD_BP_CNT*2+LCD_IDLE_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT];	
	} 	
	#else
	{
		/*Drive electrode FPphase to voltage level HIGH in even contrust adjustment cycle */
		EMIOS_FP_DATA_FOR_DMA[i+LCD_BP_CNT][j]=  eMIOS_TIMING_DATA_FOR_DMA[BIAS_CNT];
		/*Drive electrode FPphase to voltage level LOW in odd contrust adjustment cycle */	
		EMIOS_FP_DATA_FOR_DMA[i+LCD_BP_CNT*2+LCD_IDLE_CNT][j]= eMIOS_TIMING_DATA_FOR_DMA[0];
	
	}
	#endif
	
	}
}
}		


/**************************************************************************/
/* FUNCTION     : LCD_init                                                */
/* PURPOSE      : start-up of the LCD driver.                             */
/**************************************************************************/
void LCD_init(unsigned int bus_frequency, int contrast_adj) 
{
int i =0;                                /* calculate normal phase time and contrast adjustment phase time */

  /* please note that LCD_FRAME_FREQUENCY is equivalent to refresh cycle period */
  /* refresh cycle period = data_period + contrast_period */
  /* whenever user change contrast adjustment time by changing contrast_period, driver will recalculate the data_period to match LCD_FRAME_FREQUENCY */ 
LCD_data.bus_frequency = bus_frequency;
LCD_data.emios_frequency = bus_frequency/(emios_peripheral_prescaler*emios_predivider);
LCD_data.data_period = ((((unsigned long int)bus_frequency/LCD_FRAME_FREQUENCY)-LCD_IDLE_CNT*(unsigned long int)contrast_adj)/(LCD_BP_CNT+LCD_IDLE_CNT))-1;
LCD_data.data_period_active = LCD_data.data_period;	
 
LCD_data.data_phase_period = LCD_data.data_period/LCD_BP_CNT;
LCD_data.data_phase_period_active = LCD_data.data_phase_period;

/* contrast adjustment parameter can be positive or negative, it defines the deviation from data_period */
LCD_data.contrast_period = LCD_data.data_phase_period + contrast_adj;	
LCD_data.contrast_period_active = LCD_data.contrast_period;

/* number of data phases */
LCD_data.phase = (LCD_BP_CNT+LCD_IDLE_CNT)-1; 

LCD_data.polarity=0; 

INIT_WAVEFORM_FOR_DMA();

INIT_MODULES_FOR_LCD();
                              
}

/**************************************************************************/
/* FUNCTION     : LCD_stop                                                */
/* PURPOSE      : shutdown of the LCD driver                              */
/**************************************************************************/
void LCD_stop(void) 
{
	PIT_CH_DISABLE(0);               /* stop the interrupt source */
	LCD_ALL_PINS_LOW();			      /* drive all pins low */
}

/**************************************************************************/
/* FUNCTION     : LCD_start                                               */
/* PURPOSE      : shutdown of the LCD driver                              */
/**************************************************************************/
void LCD_start(void) 
{
  EDMA.ERQRL.R |= 15;    /* Enable DMA request signal for channel 0 */
}
