/******************************************************************************
  Copyright 2009  Freescale Semiconductor. All rights reserved.

  Module:           intc.c 
  Description:      Interrupt configuration 
  Version:          0.1
  Revision:         0.1
  Date(yyyy.mm.dd): 08 April 2010
  Author(s):        b04629
  Company:          Freescale Semiconductor
                    East Kilbride                                                   
                    Scotland                                                    
 ****************************** Revision History ******************************
    Date(yyyy.mm.dd):   Name              Description 
  
 ******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS 
 WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE 
 TIME. AS A RESULT, FRESCALE SEMICONDUCTOR SHALL NOT BE HELD LIABLE FOR ANY 
 DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 FROM THE CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE 
 CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 *****************************************************************************/
#include "main.h"


void INTC_init(void)
{
  /* Configure interrupts at Core */ 
  EXCEP_InitExceptionHandlers();
  
  /* Configure interrupts at INTC */ 
  INTC_InitINTCInterrupts(); 
  /* Configure Interrupt Service Routines for peripherals */
  /* INTC_InstallINTCInterruptHandler(<periph ISR>, <IRQ#>, <priority>); */
  INTC_InstallINTCInterruptHandler(ADC_0_WDG_ISR,64, 2); /* ADC End of Conversion ISR */
  /* The INTC's current priority must be lower than peripheral prioroty to activate interrupt*/
  
  INTC.CPR.B.PRI = 0;        
}

