/******************************************************************************
  Copyright 2009  Freescale Semiconductor. All rights reserved.

  Module:           init.c 
  Description:      ME & CGM configuration
  Version:          0.1
  Revision:         0.1
  Date(yyyy.mm.dd): 08 April 2010
  Author(s):        b04629
  Company:          Freescale Semiconductor
                    East Kilbride                                                   
                    Scotland                                                    
 ****************************** Revision History ******************************
    Date(yyyy.mm.dd):   Name              Description 
  
 ******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS 
 WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE 
 TIME. AS A RESULT, FRESCALE SEMICONDUCTOR SHALL NOT BE HELD LIABLE FOR ANY 
 DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 FROM THE CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE 
 CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 *****************************************************************************/
#include "lcd.h"


void EMIOS_0_OPWMT_CH_init(uint32_t PCR_N, uint32_t N, uint32_t ALT_FUN)
{
	/* Configure EMIOS_0 channel 1 for OPWMT */  
    SIU.PCR[PCR_N].R          = 0x0200; /* EMIOS CH1 PWM output */ 
    SIU.PCR[PCR_N].B.PA       = ALT_FUN;   /* PWM low to high */                                                                                                                    
	EMIOS_0.CH[N].CADR.R      = 0;   /* PWM low to high */ 
	EMIOS_0.CH[N].CBDR.R      = PWM_period_cycles/2;   /* PWM high to low */   	
	EMIOS_0.CH[N].CCR.B.UCPEN = 1;      /* Enable channel prescaler counter */
	EMIOS_0.CH[N].CCR.B.BSL   = 0;      /* Use counter Bus B */
	EMIOS_0.CH[N].CCR.B.MODE  = 0x26;   /* OPWMT mode */
}  



void EMIOS_0_BUS_init(int32_t PCR_N, uint32_t N, uint32_t ALT_FUN, uint32_t global_prescaler, uint32_t CADR)
{
    SIU.PCR[PCR_N].R          = 0x0200; /* EMIOS CH1 PWM output */ 
    SIU.PCR[PCR_N].B.PA       = ALT_FUN;   /* PWM low to high */
    
	/* Enable EMIOS_0 */
	EMIOS_0.MCR.B.MDIS        = 0;	    /* Enable module */      		                                                          EMIOS_0.OUDR.R            = 0x0000;     /* Enable update transfer for all Channels     */  
	EMIOS_0.MCR.B.GTBE        = 1;	    /* Enable global time base */
	EMIOS_0.MCR.B.GPREN       = 1;	    /* Enable global prescaler */ 
	EMIOS_0.MCR.B.GPRE        = (global_prescaler-1);	  /* Global prescaler */      
	
	/* Configure counter bus B on EMIOS_0 channel 0 */
	EMIOS_0.CH[N].CADR.R      = CADR;   /* End of modulus count*/
	EMIOS_0.CH[N].CCR.B.UCPEN = 1;      /* Enable the prescaler counter */
	EMIOS_0.CH[N].CCR.B.BSL   = 0x3;    /* System clock divided by global pre-scaler */
	EMIOS_0.CH[N].CCR.B.MODE  = 0x10;   /* Modulus counter */   
} 

