/******************************************************************************
  Copyright 2009  Freescale Semiconductor. All rights reserved.

  Module:           dma.c 
  Description:      DMA configuration
  Version:          0.1
  Revision:         0.1
  Date(yyyy.mm.dd): 08 April 2010
  Author(s):        b04629
  Company:          Freescale Semiconductor
                    East Kilbride                                                   
                    Scotland                                                    
 ****************************** Revision History ******************************
    Date(yyyy.mm.dd):   Name              Description 
  
 ******************************************************************************
 THE PRESENT SOFTWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS 
 WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE 
 TIME. AS A RESULT, FRESCALE SEMICONDUCTOR SHALL NOT BE HELD LIABLE FOR ANY 
 DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
 FROM THE CONTENT OF SUCH SOFTWARE AND/OR THE USE MADE BY CUSTOMERS OF THE 
 CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
 *****************************************************************************/
#include "lcd.h"
//#include "main.h"

//#pragma mpwc_relax on
//#pragma warn_implicitconv off
//#pragma warn_any_ptr_int_conv off
//#pragma warn_impl_s2u_conv off

const uint8_t SIU_DATA[2]  = {0x01, 0x00};



/**************************************************************************/
/* FUNCTION     : DMA_tcd_init                                            */
/* PURPOSE      : Generic Function for configuring DMA CHx                */
/**************************************************************************/
void DMA_tcd_init_for_PIT ( uint32_t ch, uint32_t saddr, uint32_t daddr)
{ 
    EDMA.CL_TCD[ch].SADDR = saddr;             // Source address (32 bits)
    EDMA.CL_TCD[ch].DADDR = daddr;            // Destination address (32 bits) 
    EDMA.CL_TCD[ch].SMOD  = 0;                 // Source address modulo (5 bits)
    EDMA.CL_TCD[ch].DMOD  = 0;                 // Destination address modulo (5 bits) 
    EDMA.CL_TCD[ch].SSIZE = 2;                 // Source data transfer size  32-bit
    EDMA.CL_TCD[ch].DSIZE = 2;                 // Destination transfer size 32-bit
    EDMA.CL_TCD[ch].SOFF = 4;                  // Signed source address offset 32-bit 
    EDMA.CL_TCD[ch].DOFF = 0;                  // Signed destination address offset 32-bit
    EDMA.CL_TCD[ch].NBYTES = 4; 				// Inner minor byte count (32 bits)
    EDMA.CL_TCD[ch].SLAST = -(LCD_BP_CNT+LCD_IDLE_CNT)*4*2;        // Last source address adjustment. 
    EDMA.CL_TCD[ch].DLAST_SGA = 0;             // Last Destination Address Adjustment / Scatter Gather Address  
    EDMA.CL_TCD[ch].CITERE_LINK = 1;           // Channel-to-channel Linking on Minor Loop Complete - enabled    
    EDMA.CL_TCD[ch].CITERLINKCH = 1; 			// link to channel #1 
    EDMA.CL_TCD[ch].CITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;  // Current "major" iteration count for add end even cycles
    EDMA.CL_TCD[ch].BITERE_LINK = 1;           //Enables channel-to-channel linking on minor loop complete.- enabled
    EDMA.CL_TCD[ch].BITERLINKCH = 1; 			// link channel number
    EDMA.CL_TCD[ch].BITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;       // begining "major" iteration count
    EDMA.CL_TCD[ch].MAJORE_LINK = 1;           // Enable channel-to-channel linking on major loop completion - enabled
    EDMA.CL_TCD[ch].MAJORLINKCH = 1;           // link to channel #1
    EDMA.CL_TCD[ch].BWC = 0;                   // Bandwidth Control (2 bits) - No eDMA engine stalls
    EDMA.CL_TCD[ch].DONE = 0;                  // Channel done 
    EDMA.CL_TCD[ch].ACTIVE = 0;                // Channel active
    EDMA.CL_TCD[ch].E_SG = 0;                  // Enable scatter/gather processing - disabled
    EDMA.CL_TCD[ch].D_REQ = 0;                 // Disable hardware request. If this flag is set, the eDMA hardware automatically clears the corresponding EDMA_ERQL bit when the current major iteration count reaches zero.
    EDMA.CL_TCD[ch].INT_HALF = 0;              // Enable an interrupt when major counter is half complete (1 bit) - disabled
    EDMA.CL_TCD[ch].INT_MAJ = 0;               // Enable an interrupt when major counter is full complete (1 bit) - disabled
    EDMA.CL_TCD[ch].START = 0;                  // Channel start. If this flag is set, the channel is requesting service. The eDMA hardware automatically clears this flag after the channel begins execution.
}


void DMA_tcd_init_for_PCR (uint32_t ch, uint32_t saddr, uint32_t daddr)
{
    EDMA.CL_TCD[ch].SADDR = saddr;             // Source address (32 bits)
    EDMA.CL_TCD[ch].DADDR = daddr;             // Destination address (32 bits) 
    EDMA.CL_TCD[ch].SMOD  = 0;                 // Source address modulo (5 bits)
    EDMA.CL_TCD[ch].DMOD  = (LCD_BP_CNT/2+1);  // Destination address modulo (5 bits) 
    EDMA.CL_TCD[ch].SSIZE = 1;                 // Source data transfer size (3 bits)
    EDMA.CL_TCD[ch].DSIZE = 1;                 // Destination transfer size (3 bits)
    EDMA.CL_TCD[ch].SOFF = 2;                  // Signed source address offset (16 bits)
    EDMA.CL_TCD[ch].DOFF = 2;                  // Signed destination address offset
    EDMA.CL_TCD[ch].NBYTES = LCD_BP_CNT*2;     // Inner minor byte count (32 bits)
    EDMA.CL_TCD[ch].SLAST =  -(LCD_BP_CNT+LCD_IDLE_CNT)*LCD_BP_CNT*2*2;           // Last source address adjustment. Adjustment value added to the source address at the completion of the outer major iteration count. This value can be applied to "restore" the source address to the initial value, or adjust the address to reference the next data structure.
    EDMA.CL_TCD[ch].DLAST_SGA = 0;             // Last Destination Address Adjustment / Scatter Gather Address  
    EDMA.CL_TCD[ch].CITERE_LINK = 1;           // Channel-to-channel Linking on Minor Loop Complete (1 bit) 
    EDMA.CL_TCD[ch].CITERLINKCH = 2; 			// link to channel #1    
    EDMA.CL_TCD[ch].CITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;       // Current "major" iteration count 
    EDMA.CL_TCD[ch].BITERE_LINK = 1;
    EDMA.CL_TCD[ch].BITERLINKCH = 2; 			// link channel number
    EDMA.CL_TCD[ch].BITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;       // begining "major" iteration count
    EDMA.CL_TCD[ch].MAJORE_LINK = 1;           // Enable channel-to-channel linking on major loop completion - disabled
    EDMA.CL_TCD[ch].MAJORLINKCH = 2;           // Link channel number
    EDMA.CL_TCD[ch].BWC = 0;                   // Bandwidth Control (2 bits) - No eDMA engine stalls
    EDMA.CL_TCD[ch].DONE = 0;                  // Channel done 
    EDMA.CL_TCD[ch].ACTIVE = 0;                // Channel active
    EDMA.CL_TCD[ch].E_SG = 0;                  // Enable scatter/gather processing - disabled
    EDMA.CL_TCD[ch].D_REQ = 0;                 // Disable hardware request. If this flag is set, the eDMA hardware automatically clears the corresponding EDMA_ERQL bit when the current major iteration count reaches zero.
    EDMA.CL_TCD[ch].INT_HALF = 0;              // Enable an interrupt when major counter is half complete (1 bit) - disabled
    EDMA.CL_TCD[ch].INT_MAJ = 0;               // Enable an interrupt when major counter is full complete (1 bit) - disabled
    EDMA.CL_TCD[ch].START = 0;                  // Channel start. If this flag is set, the channel is requesting service. The eDMA hardware automatically clears this flag after the channel begins execution.
}

void DMA_tcd_init_for_EMIOS_BP (uint32_t ch, uint32_t saddr, uint32_t daddr)
{
    EDMA.MLCL_TCD[ch].SADDR = saddr;             // Source address (32 bits)
    EDMA.MLCL_TCD[ch].DADDR = daddr;             // Destination address (32 bits) 
    EDMA.MLCL_TCD[ch].SMOD  = 0;                 // Source address modulo (5 bits)
    EDMA.MLCL_TCD[ch].DMOD  = 0;  			 // Destination address modulo (5 bits) 
    EDMA.MLCL_TCD[ch].SSIZE = 2;                 // Source data transfer size (3 bits)
    EDMA.MLCL_TCD[ch].DSIZE = 2;                 // Destination transfer size (3 bits)
    EDMA.MLCL_TCD[ch].SOFF = 4;                  // Signed source address offset (16 bits)
    EDMA.MLCL_TCD[ch].DOFF = 32;                  // Signed destination address offset
    EDMA.MLCL_TCD[ch].NBYTES = LCD_BP_CNT*4;     // Inner minor byte count (32 bits)
    EDMA.MLCL_TCD[ch].SMLOE = 0; /* Source minor loop offset enabled       */
    EDMA.MLCL_TCD[ch].DMLOE= 1; /* Destination minor loop offset enable   */
    EDMA.MLCL_TCD[ch].MLOFF = -32 * LCD_BP_CNT; /* Minor loop offset                      */
    EDMA.MLCL_TCD[ch].SLAST =  -(LCD_BP_CNT+LCD_IDLE_CNT)*LCD_BP_CNT*4*2;           // Last source address adjustment. Adjustment value added to the source address at the completion of the outer major iteration count. This value can be applied to "restore" the source address to the initial value, or adjust the address to reference the next data structure.
    EDMA.MLCL_TCD[ch].DLAST_SGA = -32 * LCD_BP_CNT ;             // Last Destination Address Adjustment / Scatter Gather Address  
    EDMA.MLCL_TCD[ch].CITERE_LINK = 1;           // Channel-to-channel Linking on Minor Loop Complete (1 bit) 
    EDMA.MLCL_TCD[ch].CITERLINKCH = 2; 			// link to channel #1    
    EDMA.MLCL_TCD[ch].CITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;       // Current "major" iteration count 
    EDMA.CL_TCD[ch].BITERE_LINK = 1;
    EDMA.MLCL_TCD[ch].BITERLINKCH = 2; 			// link channel number
    EDMA.MLCL_TCD[ch].BITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;       // begining "major" iteration count
    EDMA.MLCL_TCD[ch].MAJORE_LINK = 1;           // Enable channel-to-channel linking on major loop completion - disabled
    EDMA.MLCL_TCD[ch].MAJORLINKCH = 2;           // Link channel number
    EDMA.MLCL_TCD[ch].BWC = 0;                   // Bandwidth Control (2 bits) - No eDMA engine stalls
    EDMA.MLCL_TCD[ch].DONE = 0;                  // Channel done 
    EDMA.MLCL_TCD[ch].ACTIVE = 0;                // Channel active
    EDMA.MLCL_TCD[ch].E_SG = 0;                  // Enable scatter/gather processing - disabled
    EDMA.MLCL_TCD[ch].D_REQ = 0;                 // Disable hardware request. If this flag is set, the eDMA hardware automatically clears the corresponding EDMA_ERQL bit when the current major iteration count reaches zero.
    EDMA.MLCL_TCD[ch].INT_HALF = 0;              // Enable an interrupt when major counter is half complete (1 bit) - disabled
    EDMA.MLCL_TCD[ch].INT_MAJ = 0;               // Enable an interrupt when major counter is full complete (1 bit) - disabled
    EDMA.MLCL_TCD[ch].START = 0;                  // Channel start. If this flag is set, the channel is requesting service. The eDMA hardware automatically clears this flag after the channel begins execution.
}

void DMA_tcd_init_for_EMIOS_FP (uint32_t ch, uint32_t saddr, uint32_t daddr)
{
    EDMA.MLCL_TCD[ch].SADDR = saddr;             // Source address (32 bits)
    EDMA.MLCL_TCD[ch].DADDR = daddr;             // Destination address (32 bits) 
    EDMA.MLCL_TCD[ch].SMOD  = 0;                 // Source address modulo (5 bits)
    EDMA.MLCL_TCD[ch].DMOD  = 0;  			 // Destination address modulo (5 bits) 
    EDMA.MLCL_TCD[ch].SSIZE = 2;                 // Source data transfer size (3 bits)
    EDMA.MLCL_TCD[ch].DSIZE = 2;                 // Destination transfer size (3 bits)
    EDMA.MLCL_TCD[ch].SOFF = 4;                  // Signed source address offset (16 bits)
    EDMA.MLCL_TCD[ch].DOFF = 32;                  // Signed destination address offset
    EDMA.MLCL_TCD[ch].NBYTES = LCD_FP_CNT*4;     // Inner minor byte count (32 bits)
    EDMA.MLCL_TCD[ch].SMLOE = 0; /* Source minor loop offset enabled       */
    EDMA.MLCL_TCD[ch].DMLOE= 1; /* Destination minor loop offset enable   */
    EDMA.MLCL_TCD[ch].MLOFF = -32 * LCD_FP_CNT; /* Minor loop offset                      */
    EDMA.MLCL_TCD[ch].SLAST =  -(LCD_BP_CNT+LCD_IDLE_CNT)*LCD_FP_CNT*4*2;           // Last source address adjustment. Adjustment value added to the source address at the completion of the outer major iteration count. This value can be applied to "restore" the source address to the initial value, or adjust the address to reference the next data structure.
    EDMA.MLCL_TCD[ch].DLAST_SGA = -32 * LCD_FP_CNT ;             // Last Destination Address Adjustment / Scatter Gather Address  
    EDMA.MLCL_TCD[ch].CITERE_LINK = 0;           // Channel-to-channel Linking on Minor Loop Complete (1 bit) 
    EDMA.MLCL_TCD[ch].CITERLINKCH = 0; 			// link to channel #1    
    EDMA.MLCL_TCD[ch].CITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;       // Current "major" iteration count 
    EDMA.CL_TCD[ch].BITERE_LINK = 0;
    EDMA.MLCL_TCD[ch].BITERLINKCH = 0; 			// link channel number
    EDMA.MLCL_TCD[ch].BITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2;       // begining "major" iteration count
    EDMA.MLCL_TCD[ch].MAJORE_LINK = 0;           // Enable channel-to-channel linking on major loop completion - disabled
    EDMA.MLCL_TCD[ch].MAJORLINKCH = 0;           // Link channel number
    EDMA.MLCL_TCD[ch].BWC = 0;                   // Bandwidth Control (2 bits) - No eDMA engine stalls
    EDMA.MLCL_TCD[ch].DONE = 0;                  // Channel done 
    EDMA.MLCL_TCD[ch].ACTIVE = 0;                // Channel active
    EDMA.MLCL_TCD[ch].E_SG = 0;                  // Enable scatter/gather processing - disabled
    EDMA.MLCL_TCD[ch].D_REQ = 0;                 // Disable hardware request. If this flag is set, the eDMA hardware automatically clears the corresponding EDMA_ERQL bit when the current major iteration count reaches zero.
    EDMA.MLCL_TCD[ch].INT_HALF = 0;              // Enable an interrupt when major counter is half complete (1 bit) - disabled
    EDMA.MLCL_TCD[ch].INT_MAJ = 0;               // Enable an interrupt when major counter is full complete (1 bit) - disabled
    EDMA.MLCL_TCD[ch].START = 0;                  // Channel start. If this flag is set, the channel is requesting service. The eDMA hardware automatically clears this flag after the channel begins execution.
}

void DMA_tcd_init_for_MPGPDO (uint32_t ch, uint32_t saddr, uint32_t daddr)
{
    EDMA.CL_TCD[ch].SADDR = saddr;             // Source address (32 bits)
    EDMA.CL_TCD[ch].DADDR = daddr;             // Destination address (32 bits) 
    EDMA.CL_TCD[ch].SMOD  = 0;                 // Source address modulo (5 bits)
    EDMA.CL_TCD[ch].DMOD  = 4;                  // Destination address modulo (5 bits) 
    EDMA.CL_TCD[ch].SSIZE = 2;                 // Source data transfer size (3 bits)
    EDMA.CL_TCD[ch].DSIZE = 2;                 // Destination transfer size (3 bits)
    EDMA.CL_TCD[ch].SOFF = 4;                  // Signed source address offset (16 bits)
    EDMA.CL_TCD[ch].DOFF = 4;                  // Signed destination address offset
    EDMA.CL_TCD[ch].NBYTES = MPGPDO_REG_CNT*4;           // Inner minor byte count (32 bits)
    EDMA.CL_TCD[ch].SLAST = -(LCD_BP_CNT+LCD_IDLE_CNT)*MPGPDO_REG_CNT*4*2;;            // Last source address adjustment. Adjustment value added to the source address at the completion of the outer major iteration count. This value can be applied to "restore" the source address to the initial value, or adjust the address to reference the next data structure.
    EDMA.CL_TCD[ch].DLAST_SGA = 0;             // Last Destination Address Adjustment / Scatter Gather Address  
    EDMA.CL_TCD[ch].CITERE_LINK = 0;           // Channel-to-channel Linking on Minor Loop Complete (1 bit)    
    EDMA.CL_TCD[ch].CITERLINKCH = 0;
    EDMA.CL_TCD[ch].CITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2; ;       // Current "major" iteration count 
    EDMA.CL_TCD[ch].BITERE_LINK = 0;
    EDMA.CL_TCD[ch].BITERLINKCH = 0;
    EDMA.CL_TCD[ch].BITER = (LCD_BP_CNT+LCD_IDLE_CNT)*2; ;       // begining "major" iteration count
    EDMA.CL_TCD[ch].MAJORE_LINK = 0;         // Enable channel-to-channel linking on major loop completion - disabled
    EDMA.CL_TCD[ch].MAJORLINKCH = 0;          // Link channel number
    EDMA.CL_TCD[ch].BWC = 0;                   // Bandwidth Control (2 bits) - No eDMA engine stalls
    EDMA.CL_TCD[ch].DONE = 0;                  // Channel done 
    EDMA.CL_TCD[ch].ACTIVE = 0;                // Channel active
    EDMA.CL_TCD[ch].E_SG = 0;                  // Enable scatter/gather processing - disabled
    EDMA.CL_TCD[ch].D_REQ = 0;                 // Disable hardware request. If this flag is set, the eDMA hardware automatically clears the corresponding EDMA_ERQL bit when the current major iteration count reaches zero.
    EDMA.CL_TCD[ch].INT_HALF = 0;              // Enable an interrupt when major counter is half complete (1 bit) - disabled
    EDMA.CL_TCD[ch].INT_MAJ = 0;               // Enable an interrupt when major counter is full complete (1 bit) - disabled
    EDMA.CL_TCD[ch].START = 0;                  // Channel start. If this flag is set, the channel is requesting service. The eDMA hardware automatically clears this flag after the channel begins execution.
}

void DMA_tcd_init(uint8_t ch, uint32_t saddr, uint32_t daddr, uint32_t nbytes, uint32_t xiter)
{
    EDMA.TCD[ch].SADDR = saddr;             // Source address (32 bits)
    EDMA.TCD[ch].DADDR = daddr;             // Destination address (32 bits) 
    EDMA.TCD[ch].SMOD  = 0;                 // Source address modulo (5 bits)
    EDMA.TCD[ch].DMOD  = 0;                 // Destination address modulo (5 bits) 
    EDMA.TCD[ch].SSIZE = 0;                 // Source data transfer size (3 bits)
    EDMA.TCD[ch].DSIZE = 0;                 // Destination transfer size (3 bits)
    EDMA.TCD[ch].SOFF = 1;                  // Signed source address offset (16 bits)
    EDMA.TCD[ch].DOFF = 0;                  // Signed destination address offset
    EDMA.TCD[ch].NBYTES = nbytes;           // Inner minor byte count (32 bits)
    EDMA.TCD[ch].SLAST = -2;                // Last source address adjustment. Adjustment value added to the source address at the completion of the outer major iteration count. This value can be applied to "restore" the source address to the initial value, or adjust the address to reference the next data structure.
    EDMA.TCD[ch].DLAST_SGA = 0;             // Last Destination Address Adjustment / Scatter Gather Address  
    EDMA.TCD[ch].CITERE_LINK = 0;           // Channel-to-channel Linking on Minor Loop Complete (1 bit)    
    EDMA.TCD[ch].CITER = xiter;             // Current "major" iteration count Disabled
    EDMA.TCD[ch].BITERE_LINK = 0;
    EDMA.TCD[ch].BITER = 2;             // begining "major" iteration count
    EDMA.TCD[ch].MAJORE_LINK = 0;           // Enable channel-to-channel linking on major loop completion - disabled
    EDMA.TCD[ch].MAJORLINKCH = 0;           // Link channel number
    EDMA.TCD[ch].BWC = 0;                   // Bandwidth Control (2 bits) - No eDMA engine stalls
    EDMA.TCD[ch].DONE = 0;                  // Channel done 
    EDMA.TCD[ch].ACTIVE = 0;                // Channel active
    EDMA.TCD[ch].E_SG = 0;                  // Enable scatter/gather processing - disabled
    EDMA.TCD[ch].D_REQ = 0;                 // Disable hardware request. If this flag is set, the eDMA hardware automatically clears the corresponding EDMA_ERQL bit when the current major iteration count reaches zero.
    EDMA.TCD[ch].INT_HALF = 0;              // Enable an interrupt when major counter is half complete (1 bit) - disabled
    EDMA.TCD[ch].INT_MAJ = 0;               // Enable an interrupt when major counter is full complete (1 bit) - disabled
    EDMA.TCD[ch].START = 0;                 // Channel start. If this flag is set, the channel is requesting service. The eDMA hardware automatically clears this flag after the channel begins execution.
}
/**************************************************************************/
/* FUNCTION     : DMA_init                                                */
/* PURPOSE      : Configure DMA                                           */
/**************************************************************************/



/**************************************************************************/
/* FUNCTION     : DMAMUX_init                                             */
/* PURPOSE      : Assign DMA source for DMA channel                       */
/**************************************************************************/
void DMAMUX_init(uint8_t DMA_CH, uint8_t DMAMUX_SOURCE, uint8_t HW_TRIG)
{
    DMAMUX.CHCONFIG[DMA_CH].B.SOURCE = DMAMUX_SOURCE;
    DMAMUX.CHCONFIG[DMA_CH].B.ENBL   = 1;
    if (HW_TRIG==1)
    {
    DMAMUX.CHCONFIG[DMA_CH].B.TRIG   = 1;	
    }
}


/**************************************************************************/
/* FUNCTION     : DMA_init                                                */
/* PURPOSE      : init DMA and call DMAMUX and DMA TCD init functions     */
/**************************************************************************/
void DMA_init(void)
{
 	EDMA.CR.B.ERCA = 0;                     // Fixed-priority arbitration is used for channel selection within each group
    EDMA.CR.B.EDBG = 0;                     // The assertion of the system debug control input is ignored
    EDMA.CR.B.EMLM = 1;
    
    EDMA.ESR.R = 0xFFFFFFFF;                // Clear all error flags for the last recorded channel
    EDMA.ERL.R = 0xFFFF;                    // Clear all DMA channel error flags
    
    DMAMUX_init(DMA_CH_for_PIT, 60, 1);   /* DMA Ch0 = PIT0, always enabled, triggers the DMA assotiated with the PIT timer  */
  
  	DMA_tcd_init_for_PIT (DMA_CH_for_PIT, (unsigned long int)&PIT_DATA_FOR_DMA[0], (unsigned long int)&PIT.CH[PIT_CH_NR].LDVAL.R); /* Enable DMA channel 0 to transfer timer data from RAM to PIT0 LDVAL Register */
  
	#if PWM==1     
  	DMA_tcd_init_for_EMIOS_BP (DMA_CH_for_EMIOS_BP, (unsigned long int)&EMIOS_BP_DATA_FOR_DMA[0][0], (unsigned long int)&EMIOS_0.CH[28].CBDR.R);
  	DMA_tcd_init_for_EMIOS_FP (DMA_CH_for_EMIOS_FP, (unsigned long int)&EMIOS_FP_DATA_FOR_DMA[0][0], (unsigned long int)&EMIOS_0.CH[0].CBDR.R);
	#else
  	DMA_tcd_init_for_PCR (DMA_CH_for_PCR, (unsigned long int)&PCR_DATA_FOR_DMA[0][0], PCR_BASE_FOR_BP);
  	DMA_tcd_init_for_MPGPDO (DMA_CH_for_MPGPDO, (unsigned long int)&MPGPDO_DATA_FOR_DMA[0][0], MPGPDO_BASE); 
	#endif

//---------------TEST ONLY--------------------------
  DMAMUX_init(3, 63, 1);   /* DMA Ch3 = PIT3, always enabled, this timer is for test purpose only  */  
  DMA_tcd_init(3, (unsigned long int)&SIU_DATA[0], (unsigned long int)&SIU.GPDO[71].R, 1, 1); /* for test purpose only, is not needed for LCD function */
  SIU.PCR[71].R = 0x0200; /* for test purpose only, is not needed for LCD function */
//--------------------------------------------------

}
