/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	zc_detection_drv.h$
*
* $Author:		r30322$
* 
* $Version:		1.0.20.0$
* 
* $Date:		Jan-8-2010$
* 
* $Brief: 		back-EMF zero-crossing detection drivers header 
*               for 3-Phase Sensorless BLDC Motor Control using comparator HSCMP 
*               for zero-crossing and FTM1 for zero-crossing capture
*
* Target:		MC9S08MP16 device
*
*******************************************************************************/
#ifndef _ZC_DETECTION_DRV_H
#define _ZC_DETECTION_DRV_H

//#include "derivative.h" /* include peripheral declarations */
//#include "types.h"      /* include type definitions */
#include "hw_config.h"      /* include hardware configurations */
#include "main.h"           /* include main definitions */





typedef enum
{   ZCDETECT_IDLE,/* Debug 09.12.22 */
    ZCDETECT_STG0,
    ZCDETECT_STG1CURR_RECIRCULATION,
    ZCDETECT_STG2ZCDETECTION_PROC,
    ZCDETECT_STG3ZCDETECTED,
} ZCDETECT_STATE_ENUM;

extern  char zcCompZCPMUX[];
extern  unsigned char adcFirstSampleInputSelectTab[6];

#pragma DATA_SEG SHORT MY_ZEROPAGE
extern ZCDETECT_STATE_ENUM  zcDetectStateIndex;
extern signed char zcCompSectorInit;
extern signed char zcCompSector;
extern signed char zcErrorCounter;
extern signed char zcSeqCorrectCounter;
extern unsigned int CommutationFlag;

#pragma DATA_SEG DEFAULT
extern unsigned short BEMF;

/*FTM0ch1 interrupt enable*/

void ZCDetect_SetIdle(void);
void ZCDetect_SetZCOff(void);
void ZCDetect_BeginABC(signed char zcCompSectorSet);
void ZCDetect_BeginCBA(signed char zcCompSectorSet);
void ZCDetect_SetStg0ABC(signed char zcCompSectorSet);
void ZCDetect_SetStg0CBA(signed char zcCompSectorSet);
void ZCDetect_SetStg1CurrRecirculation(void);
void ZCDetect_SetStg2ZCDetectionProc(void);
void ZCDetect_Stg3ZCDetected(void);
void ZCDetect_Error(void);

void BEMF_ADC_Channel_distinguish(void);


#endif  /* _ZC_DETECTION_DRV_H */
