/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	main.h$
*
* $Author:		r30322$
* 
* $Version:		1.0.75.0$
* 
* $Date:		Jan-24-2010$
* 
* $Brief: 		Main header file for 3-Phase Sensorless BLDC Motor Control
*               includes application constants definitions
*
* Target:		MC9S08MP16 device
*
*******************************************************************************/
#ifndef _MAIN_H
#define _MAIN_H

#include "types.h"     /* include type definitions */
#include "hw_config.h"
//#include "derivative.h" /* include peripheral declarations */


/* SET THE S/W FUNCTIONALITY HERE */
/* #define APPMODE_INFINITE_ALIGNMENT For Debug purpose */

/* #define PWM_BIPOLAR_SWITCHING */         /*  sets bipolar 3-phase power stage pwm switching 
                                                default is unipolar switching */
#define SL_TECHNIQUE_FORCED_PLL       /*  enables forced PLL sensorless commutation technique */
//#define  PWM_BIPOLAR_SWITCHING

/* #define SL_TECHNIQUE_SYNCHRONIZED_PLL */ /*  enables synchronized PLL sensorless commutation technique */

/* #define ZC_MODE_CURRENT_DECAY_SAMPLING */  /* enables  Zero Crossing Detection mode with current decay sampling */

/* Motor Parameters */
#define MOTOR_POLES                 4.0     /* Number of motor poles */
#define CMT_P_REV                   (6*MOTOR_POLES/2)
                                            /* number of commutations per revolution */
#define CALC                        20*2*3/5*4/3;
/* velocity scaling parameters */
#define VELOCITY_RANGE_MAX_RPM      5000.0  /* system velocity maximal range - DETERMINES VELOCITY SCALING */
#define COEF_VELOCITY_PERIOD_SCALE16  (TIM_CMT_CLOCK_FREQUENCY_HZ*60*(MAX_S16+1.0)/VELOCITY_RANGE_MAX_RPM/CMT_P_REV/65536.0)
                                            /* coefficient for velocity period scaling */

/* Alignment Parameters Setting */
#define ALIGNMENT_PERIOD_MS         1000.0   /* Rotor Alignment stage duration [ms] */
#define ALIGNMENT_PERIOD_TIMB   ((ALIGNMENT_PERIOD_MS)*1000.0/(TIMB_PERIOD_US))
                                            /* Rotor Alignment stage duration [Tim B units] */
#define ALIGNMENT_DUTY_CYCLE_FRAC   0.12    /* rotor alignment stage duty cycle [fractional] */
#define ALIGNMENT_DUTY_CYCLE_U16     (ALIGNMENT_DUTY_CYCLE_FRAC*PWM_MODULO)
                                            /* rotor alignment stage duty cycle [fractional] */
#define ADC_DELAY_INIT_U16          (ALIGNMENT_DUTY_CYCLE_U16/4);
                                            /* ADC delay init */
#define ALIGNMENT_PWM_SECTOR_INIT   1       /* alignment pwm sector initialization value */
                                            
/* Open Loop Start Parameters Setting */
#define OL_START_DUTY_CYCLE_FRAC  0.14  /* open loop starup duty cycle [fractional] */
#define OL_START_DUTY_CYCLE_U16     (OL_START_DUTY_CYCLE_FRAC*PWM_MODULO)
                                            /* open loop starup duty cycle */

#define VELOCITY_HW_STEP_RPM        5.0     /* velocity h/w control step [rpm] */
#define VELOCITY_HW_STEP           ((MAX_S16+1.0)*VELOCITY_HW_STEP_RPM/VELOCITY_RANGE_MAX_RPM)
                                            /* velocity h/w control step */
#define FTM0_RISINGEDGE_TIME         10

#define VELOCITY_MAX_RPM            4500.0  /* maximal desired velocity [rpm] */
#define VELOCITY_MAX                ((MAX_S16+1.0)*VELOCITY_MAX_RPM/VELOCITY_RANGE_MAX_RPM)

#define VELOCITY_MIN_RPM            100
                                            /* minimal velocity (at open-loop starting) [rpm] */
#define VELOCITY_MIN ((MAX_S16+1.0)*VELOCITY_MIN_RPM/VELOCITY_RANGE_MAX_RPM)
                                            /* minimal velocity (at open-loop starting) */

#define VELOCITY_THRESHOLD_OL_TO_RUN_RPM   450.0
                                            /* velocity Open Loop to rum mode threshold [rpm] */
#define VELOCITY_THRESHOLD_OL_TO_RUN ((MAX_S16+1.0)*VELOCITY_THRESHOLD_OL_TO_RUN_RPM/VELOCITY_RANGE_MAX_RPM)
                                            /* velocity Open Loop to rum mode threshold */
#if (VELOCITY_THRESHOLD_OL_TO_RUN) > MAX_S16
#error "VELOCITY_THRESHOLD_OL_TO_RUN_RPM must be lower then VELOCITY_RANGE_MAX_RPM"
#endif

#define VELOCITY_THRESHOLD_RUN_TO_OL_RPM    300.0
                                            /* velocity Open Loop to rum mode threshold [rpm] */
#define VELOCITY_THRESHOLD_RUN_TO_OL ((MAX_S16+1.0)*VELOCITY_THRESHOLD_RUN_TO_OL_RPM/VELOCITY_RANGE_MAX_RPM)
                                            /* velocity Open Loop to rum mode threshold */
#if (VELOCITY_THRESHOLD_RUN_TO_OL) > MAX_S16
#error "VELOCITY_THRESHOLD_RUN_TO_OL_RPM must be lower then VELOCITY_RANGE_MAX_RPM"
#endif

#define VELOCITY_DESIRED_START_RPM  500.0
                                            /* desired velocity at open-loop starting velocity [rpm] */
#define VELOCITY_DESIRED_START ((MAX_S16+1.0)*VELOCITY_DESIRED_START_RPM/VELOCITY_RANGE_MAX_RPM)
                                            /* desired velocity at open-loop starting velocity */
#if (VELOCITY_DESIRED_START) > MAX_S16
#error "VELOCITY_DESIRED_START_RPM must be lower then VELOCITY_RANGE_MAX_RPM"
#endif


#define RAMP_ACCELERATION_OL_RPM_S  2300  /* open loop start ramp acceleration [rpm/s] */
#define RAMP_ACCELERATION_OL        ((MAX_S16+1.0)*RAMP_ACCELERATION_OL_RPM_S/VELOCITY_RANGE_MAX_RPM*TIMB_PERIOD_US/1000000.0)
                                            /* open loop start ramp acceleration */
#if (RAMP_ACCELERATION_OL) < 1.0
#endif


/* Sensorless Run Parameters Setting */
#define RAMP_ACCELERATION_CL_RPM_S  1000.0//debug//4000.0  /* Acceleration ramp [rpm/s] */
#define RAMP_ACCELERATION_CL        ((MAX_S16+1.0)*RAMP_ACCELERATION_CL_RPM_S/VELOCITY_RANGE_MAX_RPM*TIMB_PERIOD_US/1000000.0)
                                            /* Acceleration ramp */
#if (RAMP_ACCELERATION_CL) < 1.0
#endif

/* Sensorless commutation coefficients */
#define COEF_ZC_TO_CMT_INIT_FRAC   0.36   /* 0.45coefficient for calculation the period from zero-crossing to commutation
                                               fraction value of tthe period between zero-crossings
                                               DETERMINES COMMUATATION ADVANCING */
#define COEF_ZC_TO_CMT_INIT_U8      ((MAX_U8+1)*COEF_ZC_TO_CMT_INIT_FRAC)
                                            /* coefficient zero crossing to commutation */
#if (COEF_ZC_TO_CMT_INIT_U8) > MAX_U8
#error "COEF_ZC_TO_CMT_INIT_FRAC must be < 1.0 "
#endif

#define COEF_ZC_OFF_INIT_FRAC    0.25       /* coefficient for calculation the period when zero-crossing is not sensed
                                               due to current recirculation */
#define COEF_ZC_OFF_INIT_U8      ((MAX_U8+1)*COEF_ZC_OFF_INIT_FRAC)
                                            /* coefficient Toff crossing to commutation */

#define BLDC_ZC_TOFF_MIN_PERIOD_MS  0.25    /* minimal period when zero-crossing is not sensed 
                                               MUST BE < 1/2 of minimmal commutation period at motor maximal speed [ms] */
#define BLDC_ZC_TOFF_MIN_PERIOD_TIM_CMT  ((BLDC_ZC_TOFF_MIN_PERIOD_MS)*TIM_CMT_CLOCK_FREQUENCY_HZ/1000.0)
                                            /* minimal period when zero-crossing is not sensed  */

#define BLDC_ZC_CUR_DECAY_OFF_PERIOD_MS  0.15    /* minimal period when current decay is not sensed 
                                               MUST BE < 1/2 of minimmal commutation period at motor maximal speed [ms] */
#define BLDC_ZC_CUR_DECAY_OFF_PERIOD_TIM_CMT  ((BLDC_ZC_CUR_DECAY_OFF_PERIOD_MS)*TIM_CMT_CLOCK_FREQUENCY_HZ/1000.0)
                                            /* minimal period when zero-crossing is not sensed  */

#define COEF_CMT_PRESET_FRAC    1.75       /* coefficient commutation preset must be < 2.0 */
#define COEF_CMT_PRESET_HALF_FRAC   (COEF_CMT_PRESET_FRAC/2.0)
                                            /* coefficient commutation preset half fractional - must be < 1.0 */
#define COEF_CMT_PRESET_HALF_U8 ((MAX_U8+1)*COEF_CMT_PRESET_HALF_FRAC)
                                            /* coefficient commutation preset half */

/* Zero Crossing Detection Constants */
#define DELAY_PWM_EDGE_ZC_COMP_ENABLE_US   5.0
                                                /* time duration from starting PWM edge of the TOP BOT Diagonal on 
                                                  to zero crossing detection (enable) window [us] */
#define DELAY_PWM_EDGE_ZC_COMP_ENABLE  (PERIPHCLOCK_FREQUENCY_MHZ*DELAY_PWM_EDGE_ZC_COMP_ENABLE_US)
                                                /* time duration from introducing PWM edge of the TOP BOT Diagonal on 
                                                  to zero crossing detection (enable) window */
#define DELAY_ZC_COMP_DISABLE_PWM_EDGE_US  0.0  /* time duration from zero crossing detection window end (disable)
                                                   to ending PWM edge of the TOP BOT Diagonal on [us] */
#define DELAY_ZC_COMP_DISABLE_PWM_EDGE  (PERIPHCLOCK_FREQUENCY_MHZ*DELAY_ZC_COMP_DISABLE_PWM_EDGE_US)


#define DELAY_ZC_COMP_MIN_US        2.0         /* minimal time duration of the zero crossing detection (enable) window [us] */
#define DELAY_ZC_COMP_MIN           (PERIPHCLOCK_FREQUENCY_MHZ*DELAY_ZC_COMP_MIN_US)
                                                /* minimal time duration of the zero crossing detection (enable) window [us] */

#define ZC_COMP_FILT_CNT            3           /* zero crossing comparator filter count */
#define HSCMP_FILT_CNT          ((ZC_COMP_FILT_CNT<<4)&HSCMP2CR0_FILTER_CNT_MASK)               
                                                /* zero crossing comparator filter count */
#define ZC_COMP_SAMP_PER_NS         5000.0      /* zero crossing comparator filter period */
#define ZC_COMP_SAMP_PER_SYSU   (PERIPHCLOCK_FREQUENCY_MHZ*ZC_COMP_SAMP_PER_NS/1000.0)


/* Restart Parameters Setting */
#define ZC_ERROR_COUNTER_THRESHOLD            11 /* Zero Crossing Error Counter Threshold for restart */
#define CMT_FAULT_RESTART_COUNTER_THRESHOLD   3 /* Commutation fault counter */
#define RESTART_PERIOD_MS           1000.0   /* Restart Timeout stage duration [ms] */
#define RESTART_PERIOD_TIMB     ((RESTART_PERIOD_MS)*1000.0/(TIMB_PERIOD_US))
                                            /* Restart Timeout stage duration [Tim B units] */

#define CMT_STABILIZED_THRESHOLD              5 /* commutation stabilized threshold */ 

/* speed regulator parameters */
#define SPEED_REG_PROP_GAIN_FRACT   0.5     /* speed regualtor proportional gain fractional */
#define SPEED_REG_PROP_GAIN_U8      (SPEED_REG_PROP_GAIN_FRACT*(MAX_U8+1))
#define SPEED_REG_PROP_GAIN_SHFT_S8 -4     
                                            /* speed regualtor integral gain shft 
                                               SPEED_REG_PROP_GAIN = SPEED_REG_PROP_GAIN_FRACT*2^SPEED_REG_PROP_GAIN_SHFT_S8 */
#define SPEED_REG_INT_GAIN_FRACT   0.5      /* speed regualtor integral gain fractional */
#define SPEED_REG_INT_GAIN_U8       (SPEED_REG_INT_GAIN_FRACT*(MAX_U8+1))
#define SPEED_REG_INT_GAIN_SHFT_S8  -7
                                            /* speed regualtor integral gain shft 
                                               SPEED_REG_INT_GAIN = SPEED_REG_INT_GAIN_FRACT*2^SPEED_REG_INT_GAIN_SHFT_S8 */
#define SPEED_REG_LOWER_LIMIT_S16   (PWM_MODULO*0.09)//Debug 09.12.15 (PWM_MODULO*0.10)
                                            /* speed regulator output limit lower */
                                            /* should be >0 to enable correct zero-crossing sensing */
#define SPEED_REG_UPPER_LIMIT_S16   PWM_MODULO
                                            /* speed regulator output limit lower */
/* current/torque regulator parameters */
#define  CURRENT_DCB_LIMIT_MA       1000.0
#define  CURRENT_DCB_LIMIT          (ADC_MAX*CURRENT_DCB_LIMIT_MA/CURRENT_HW_RANGE_MAX_MA)

#define  CURRENT_DCB_ALIGNMENT_MA   2000.0
#define  CURRENT_DCB_ALIGNMENT      (ADC_MAX*CURRENT_DCB_ALIGNMENT_MA/CURRENT_HW_RANGE_MAX_MA)

#define CURRENT_REG_PROP_GAIN_FRACT   0.5     /* speed regualtor proportional gain fractional */
#define CURRENT_REG_PROP_GAIN_U8      (CURRENT_REG_PROP_GAIN_FRACT*(MAX_U8+1))
#define CURRENT_REG_PROP_GAIN_SHFT_S8 -2      
                                            /* speed regualtor integral gain shft 
                                               CURRENT_REG_PROP_GAIN = CURRENT_REG_PROP_GAIN_FRACT*2^CURRENT_REG_PROP_GAIN_SHFT_S8 */
#define CURRENT_REG_INT_GAIN_FRACT   0.5      /* speed regualtor integral gain fractional */
#define CURRENT_REG_INT_GAIN_U8       (CURRENT_REG_INT_GAIN_FRACT*(MAX_U8+1))
#define CURRENT_REG_INT_GAIN_SHFT_S8  -3
                                            /* speed regualtor integral gain shft 
                                               CURRENT_REG_INT_GAIN = CURRENT_REG_INT_GAIN_FRACT*2^CURRENT_REG_INT_GAIN_SHFT_S8 */

#define CURRENT_REG_LOWER_LIMIT_S16   SPEED_REG_LOWER_LIMIT_S16
                                            /* current regulator output limit lower */
#define CURRENT_REG_UPPER_LIMIT_S16   SPEED_REG_UPPER_LIMIT_S16
                                            /* current regulator output limit lower */
                                            
/* synchronouse PLL regulator parameters */                               
#define SYNC_PLL_INTEGRAL_GAIN_FRACT    0.2 /* pll zero crossing feedback regulator integral gain multiplicant fractional */
#define SYNC_PLL_INTEGRAL_GAIN        (SYNC_PLL_INTEGRAL_GAIN_FRACT*(MAX_U8+1))
                                            /* pll zero crossing feedback regulator integral gain multiplicant */
#define SYNC_PLL_PROPORTIONAL_GAIN_FRACT     0.04
                                            /* pll zero crossing feedback regulator proportional gain multiplicant fractional */
#define SYNC_PLL_PROPORTIONAL_GAIN   (SYNC_PLL_PROPORTIONAL_GAIN_FRACT*(MAX_U8+1))
                                            /* pll zero crossing feedback regulator proportional gain multiplicant */

/* forced PLL regulator parameters */
#define FORCED_PLL_GAIN_SHIFT              0
                                            /* pll zero crossing feedback regulator gains shift scaling coefficient */
#define FORCED_PLL_INTEGRAL_GAIN_FRACT    0.004
                                            /* pll zero crossing feedback regulator integral gain multiplicant fractional */
#define FORCED_PLL_INTEGRAL_GAIN        (FORCED_PLL_INTEGRAL_GAIN_FRACT*(MAX_U8+1))
                                            /* pll zero crossing feedback regulator integral gain multiplicant */
#define FORCED_PLL_PROPORTIONAL_GAIN_FRACT  0.004
                                            /* pll zero crossing feedback regulator proportional gain multiplicant fractional */
#define FORCED_PLL_PROPORTIONAL_GAIN   (FORCED_PLL_PROPORTIONAL_GAIN_FRACT*(MAX_U8+1))
                                            /* pll zero crossing feedback regulator proportional gain multiplicant */

#define FORCED_PLL_REG_LOWER_LIMIT_S16   SPEED_REG_LOWER_LIMIT_S16
                                            /* forced PLL regulator output limit lower */
#define FORCED_PLL_REG_UPPER_LIMIT_S16   SPEED_REG_UPPER_LIMIT_S16
                                            /* forced PLL output limit upper */

#define VELOCITY_ERR_DIR_TO_PLL_MODE_RPM     25.0
                                            /* velocity error for transient from Direct Commutation to Forced PLL 
                                                Sensorles Run [rpm] */
#define VELOCITY_ERR_DIR_TO_PLL_MODE ((MAX_S16+1.0)*VELOCITY_ERR_DIR_TO_PLL_MODE_RPM/VELOCITY_RANGE_MAX_RPM)
                                            /* velocity error for transient from Direct Commutation to Forced PLL 
                                                Sensorles Run [system] */

#define PERIOD_ERROR_THRESHOLD_TO_PLL_FRAC    0.4
                                            /* maximal phase error threshold to enter PLL mode */
#define PERIOD_ERROR_THRESHOLD_TO_PLL       (MAX_U8*PERIOD_ERROR_THRESHOLD_TO_PLL_FRAC)
#define CMT_COUNTER_MODE_THRESHOLD          5
                                            /* sequentional successive zero-crossing threshold to enter Forced PLL mode */

#define PERIOD_ERROR_THRESHOLD_TO_DIRECT_SL_FRAC    0.3
                                            /* Forced PLL mode error threshold to exit the mode during acceleration */
#define PERIOD_ERROR_THRESHOLD_TO_DIRECT_SL (MAX_U8*PERIOD_ERROR_THRESHOLD_TO_DIRECT_SL_FRAC)
#define ZC_ERROR_COUNTER_EXIT_PLL_THRESHOLD   5/* Zero Crossing Error Counter Threshold to leave PLL mode */

/* ADC sensing parameters */
#define ADC_SENSING_CALIBRATION_COUNT   64  /* ADC current sensing callibration counter */

#define ADC_SENSING_UDCB_FILT_COUNT         30
#define ADC_SENSING_TEMPERATURE_FILT_COUNT  254

#define PWM_FREQUENCY_KHZ   16.0            /* PWM FREQUENCY 20 [kHz] */
#define PWM_MODULO          (SYSTEMCLOCK_FREQUENCY_MHZ*1000.0/PWM_FREQUENCY_KHZ)


/* FreeMASTER communication setting */
#define FREEEMASTER_BAUDRATE_BAUD   9600.0
                                            /* FreeMASTER communication Baud rate*/
#define SCIBDL_INIT   (BUSCLOCK_FREQUENCY_MHZ*1000000.0/(16*FREEEMASTER_BAUDRATE_BAUD)+0.5)

#endif  /* _MAIN_H */
