/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	hw_config.h$
*
* $Author:		r30322$
* 
* $Version:		1.0.31.0$
* 
* $Date:		Jan-13-2010$
* 
* $Brief: 		hardware configuration header for 3-Phase Sensorless BLDC Motor Control
*
* Target:		MC9S08MP16 device
*
*******************************************************************************/
/* DEFINITION_START */

#ifndef _HW_CONFIG_H
#define _HW_CONFIG_H

#include "derivative.h"                     /* include peripheral declarations */

#define CPU_FREQUENCY_MHZ           16.0    /* CPU FREQUENCY 16 000 000 [Hz] */
#define SYSTEMCLOCK_FREQUENCY_MHZ (CPU_FREQUENCY_MHZ)
#define BUSCLOCK_FREQUENCY_MHZ (CPU_FREQUENCY_MHZ/1.0)
#define PERIPHCLOCK_FREQUENCY_MHZ (BUSCLOCK_FREQUENCY_MHZ)

/* system clock */
#define ICSTRM_INIT                 0x93    /* reference clock trim init 32_894kHz for CPU_FREQUENCY_MHZ 40 */

#define PWM_TO_PDB_SCALE_RSHIFT     1       /* scale shift for PWM to PDB units transformation */
                                            /* 2^(-PWM_TO_PDB_SCALE_RSHIFT) = (PERIPHCLOCK_FREQUENCY_MHZ/SYSTEMCLOCK_FREQUENCY_MHZ) */

/* Variables Scales */
#define CURRENT_HW_HALF_RANGE_MAX_MA    8000//4000.0
                                            /* current range setting depends on h/w [mA] */
#define CURRENT_HW_RANGE_MAX_MA     (2*CURRENT_HW_HALF_RANGE_MAX_MA)
                                            /* current range scaling range maximum on h/w [mA] */
#define ADC_MAX                     (4095.0) /* ADC convertor maximum when 12 bit precission set */

#define CURRENT_SCALE               (CURRENT_HW_RANGE_MAX_MA/1000.0/ADC_MAX)
                                            /* current scaling coefficient */
#define VOLTAGE_HW_RANGE_MAX_V      36.3

#define VOLTAGE_SCALE               (VOLTAGE_HW_RANGE_MAX_V/MAX_U16)

/* Fault Settings */
#define FAULT_OVERVOLTAGE_THRESHOLD_V   28.0 /* overvoltage fault threshold [V] */
#define FAULT_OVERVOLTAGE_THRESHOLD     (ADC_MAX*FAULT_OVERVOLTAGE_THRESHOLD_V/VOLTAGE_HW_RANGE_MAX_V)
                                              /* overvoltage fault threshold [system scale for ADC_MAX] */
#define FAULT_UNDERVOLTAGE_THRESHOLD_V  6.0
                                            /* undervoltage fault threshold [V] */
#define FAULT_UNDERVOLTAGE_THRESHOLD    (ADC_MAX*FAULT_UNDERVOLTAGE_THRESHOLD_V/VOLTAGE_HW_RANGE_MAX_V)
                                            /* undervoltage fault threshold [system scale for ADC_MAX] */

/* PWM constants */
#define FTM2POL_INIT                FTM2_POL_POL0_MASK | FTM2_POL_POL2_MASK | FTM2_POL_POL4_MASK
                                            /* FTM2 polarity MUST BE SET according to 3pps PWM signals polarity */
                                            /* FTM2POL_INIT = FTM2POL_POL0_MASK | FTM2POL_POL2_MASK | FTM2POL_POL4_MASK
                                               High transistors (0,2, 4) has negative polarity (active low and inactive high) */
#define PWM_DEAD_TIME_NS            1000.0  /* 3-phase power stage PWM dead time for FTM2 setting
                                               ONLY ONE or BOTH PWM dead time insertion is necessary
                                               DRIVERMC33937_PWM_DEAD_TIME or FTM_PWM_DEAD_TIME */

/* system clock DTPS0..1 DTVAL0..5 dead time = if (DTPS = 0 or 1) DTVAL/system clock
                                               if (DTPS = 2) DTVAL*4/system clock
                                               if (DTPS = 3) DTVAL*16/system clock
                                               default system clock = 40Mhz */
                                               
#define FTM_PWM_DEAD_TIME           (PWM_DEAD_TIME_NS*SYSTEMCLOCK_FREQUENCY_MHZ/1000.0)
                                            /* ONLY ONE or BOTH PWM dead time insertion is necessary
                                               DRIVERMC33937_PWM_DEAD_TIME or FTM_PWM_DEAD_TIME */
                                            /* dead time 1us = PWM_DEAD_TIME/40Mhz */
#if (FTM_PWM_DEAD_TIME > 63.0)
#error "PWM_DEAD_TIME must be lower or change PWM_DEAD_TIME for using Prescaler"
#endif

#define DRIVERMC33937_PWM_DEAD_TIME     (((6.0*PWM_DEAD_TIME_NS*CPU_FREQUENCY_MHZ/1000.0)-(4.0))/(7.0))
                                            /* PWM dead time inserted by MC33937 driver
                                               ONLY ONE or BOTH PWM dead time insertion is necessary
                                               DRIVERMC33937_PWM_DEAD_TIME or FTM_PWM_DEAD_TIME */

#define PTCD_PWM_OFF                (PORT_PTCD_PTCD0_MASK | PORT_PTCD_PTCD2_MASK )//0001,0101
                                            /* PWM pins off as output when timer channel disabled, set High PWMs to high */
#define PTCDD_PWM_PINSENBL          (PORT_PTCOE_PTCOE0_MASK | PORT_PTCOE_PTCOE1_MASK | PORT_PTCOE_PTCOE2_MASK | \
                                     PORT_PTCOE_PTCOE3_MASK )//0011,1111

#define PTCD_INIT                   PTCD_PWM_OFF /* pwm bottom mosfet signal */
#define PTCDD_INIT                  PTCDD_PWM_PINSENBL 
                                            /* Port C direction init value*/


/* Timer Commutation an zero crossing setting */
#define FTM0_SC_PSX_INIT             (FTM0_SC_PS2_MASK | FTM0_SC_PS0_MASK)
                                            /* PSC = 101 Prescale divisor 32 - Finally clock setting is bus rate /32 */
#define TIM_CMT_CLOCK_FREQUENCY_HZ  (BUSCLOCK_FREQUENCY_MHZ*1000000.0/32.0)
#define TIME_MIN_SET_TIMER_CMT  4          //Debug 10.01.09 3           
                                            /* minimal time delay to set timer cmt (used to avoid hazard states) */


/* MTIM Timer Base setting */
#define MTIMCLK_INIT            MTIM1_CLK_PS3_MASK  
                                            /* PS = 1000 BUS clk / 256  */
                                            /* MTIM timer clock init */
#define MTIMCLK_PRESCALE        256.0       /* MTIM prescaller for MTIMCLK_INIT = MTIMCLK_PS3_MASK */

#define TIMB_PERIOD_US          3000.0      /* Speed Alignment sampling timer period */
#if (TIMB_PERIOD_US*(BUSCLOCK_FREQUENCY_MHZ/MTIMCLK_PRESCALE)) > 255.0
#error "TIMB_PERIOD_US must be lower or change MTIMSC setting in MTIM_TimerB_Init function"
#endif

#define MTIMMOD_INIT            (TIMB_PERIOD_US*(BUSCLOCK_FREQUENCY_MHZ/MTIMCLK_PRESCALE))
                                            /* MTIM timer clock init for MTIMCLK_INIT = MTIMCLK_PS3_MASK */

/* h/w control inputs allocation */
#define TOGGLE_SWITCH_ON1       PORT_PTDD_PTDD0  /* toggle - start switch pin start */
#define TOGGLE_SWITCH_ON2       PORT_PTDD_PTDD1  /* toggle - start switch pin stop */
#define DOWN_SWITCH             PORT_PTDD_PTDD4  /* down switch pin */
#define UP_SWITCH               PORT_PTDD_PTDD5  /* up switch pin */

/* HSCMP zero-crossing comparator setting */
#define PTBDD_ZC_INPUTS    (~(PORT_PTDOE_PTDOE1_MASK | PORT_PTDOE_PTDOE4_MASK | PORT_PTDOE_PTDOE5_MASK)) //~0011,0010           
                                            /* PTBDD1 = 0 Phase A ZC input, PTBDD4 = 0 Phase B ZC input, PTBDD5 = 0 Phase C ZC input */
#define PTBDD_INIT         (0&PTBDD_ZC_INPUTS)

#define ZC_COMP_PHASEA          1           /* comparator plus input phase A P2, M2 input */
#define ZC_COMP_PHASEB          2           /* comparator plus input phase A P3, M3 input */
#define ZC_COMP_PHASEC          3           /* comparator plus input phase A P4 input */

#define ZC_COMP_REF_DAC2        3           /* comparator reference input DAC2 converter M4 input */
#define ZC_COMP_REF_HALFUDCB    0           /* comparator reference input Udcb/2 P1, M1 input */

/* ADC Setting */
#define ADC_INPUT_SELECT_DCB_I     0       /* DC-Bus current  ADC input  */
#define ADC_INPUT_SELECT_DCB_Vhalf     7       /* DC-Bus half voltage  ADC input  */
#define ADC_INPUT_SELECT_BEMF_A     12       /* back-EMF voltage phase A ADC input  */
#define ADC_INPUT_SELECT_BEMF_B     13       /* back-EMF voltage phase B ADC input  */
#define ADC_INPUT_SELECT_BEMF_C     14       /* back-EMF voltage phase C ADC input  */
#define ADC_INPUT_OFFSET            15	
#define ADC_INPUT_SELECT_ADCDISABLE 31


#define APCTL1_INIT             (ADC_APCTL1_ADPC0_MASK | ADC_APCTL1_ADPC1_MASK | ADC_APCTL1_ADPC2_MASK | ADC_APCTL1_ADPC3_MASK | ADC_APCTL1_ADPC4_MASK | ADC_APCTL1_ADPC5_MASK)
                                        /* ADC pin control register disables ADC1 AD4 AD5 pins for IO */
#define APCTL2_INIT             (APCTL2_ADPC11_MASK | APCTL2_ADPC12_MASK)
                                        /* ADC pin control register disables ADC11 AD12 pins for IO */

/* MC33937 driver setting */
#define DRIVER33937_DISABLE()   (PORT_PTHD_PTHD0 = 0)//modified *****
#define DRIVER33937_ENABLE()    (PORT_PTHD_PTHD0 = 1)
#define DRIVER33937_PINENABLE() (PORT_PTHOE_PTHOE0 = 1)

#define DRIVER33937_RESET()     asm(nop)
#define DRIVER33937_RUN()       asm(nop)
#define DRIVER33937_SS_HIGH()   (PORT_PTED_PTED3 = 1)
#define DRIVER33937_SS_LOW()    (PORT_PTED_PTED3 = 0)
#define DRIVER33937_SS_PINENBL() (PORT_PTAOE_PTAOE4 = 1)

#endif  /* _HW_CONFIG_H */
