/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	adc_drv.h
*
* $Author:		r30322$
* 
* $Version:		1.0.16.0$
* 
* $Date:		Nov-13-2009$
* 
* $Brief: 		analog variables for motor control conversion driver header using ADC
*
* Target:		MC9S08MP16 device
*
*******************************************************************************/
#ifndef _ADC_DRV_H
#define _ADC_DRV_H

#include "derivative.h" /* include peripheral declarations */
#include "types.h"      /* include type definitions */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "main.h"
#include "IO_Map.h"

typedef enum
{   ADC_INIT,
    ADC_RUN
} ADC_STATE_ENUM;

typedef union {
  byte Byte;
  struct {
    byte ICalibrated       :1;
    byte UFiltInitialized  :1;
    byte BEMFAClibrated    :1;
    byte BEMFBClibrated    :1;
    byte BEMFCClibrated    :1;
    byte Bit5              :1;
    byte Bit6              :1;
    byte Bit7              :1;
  } Bits;
} ADC_FLAGS;

typedef struct{
    signed long   f32Acc;         /* filter accumulator */
    unsigned int  u16NSamples;    /* number of samples for averaging, filter sample window [0,15] */
}FILTER_MA_T_F16;


#define ADC_FLAGS_ALLINIT_MASK  3

/*ADC interrupt disable*/
#define ADC_DisableInterrupt()\
{ADC_SC1_AIEN = 0; }

void ADCSensing_I_UT_Init (void);


extern FCN_POINTER ADCSensing_I_UT_SaveSecondSample[];

#define ADC_EnableInterrupt() \
    {   \
        ADC_SC1_AIEN = 1; \
    }


extern unsigned char adcI_UTSecondSample_InputSelectTab[2];
extern unsigned char adcI_UTSecondSample_InputSelectTab1[2];
extern unsigned char adc_BEMF_InputSelectTab[6];

extern unsigned char adc_BEMF_InputSelectTab[6];
#define ADCSensing_FilterSampleU(sumU32, counterU8, inputU16) \
{   sumU32 = uadd32_16_32(sumU32, inputU16); \
    counterU8++; }



unsigned int ADCSensing_FilterAverageU (unsigned long *sumU32, unsigned char *counterU8, unsigned int outPrevU8);

void ADCSensingCheckInit(void);
void ADCFIFOSetting(void);

void ADCValue_Average(unsigned int *ptr1,unsigned int *ptr2);

#define ADC_StartOneConversionDisInt(adcInpChnl) \
    ADC_SC1 = (adcInpChnl)

#pragma DATA_SEG SHORT MY_ZEROPAGE
extern char adcSensing_SecondSampState;
extern char adcSensingPwmSector;

extern unsigned char adcSensing_CalibrationCounter;
extern unsigned int uDcb;
extern unsigned int uDcbOffset;
extern unsigned long uDcbSum32;

extern unsigned long uDcbSum32offset;

extern unsigned char adcSensing_AverageUDCBCounter;

extern unsigned char adcSensing_OffsetCounter;

extern signed int iDcb;
extern unsigned int iDcboffset;

extern unsigned long iDcbSum32;
extern unsigned char adcSensing_AverageIDCBCounter;
extern unsigned char adcSensing_AverageTemperatureCounter;

extern unsigned long uBEMFAsum32;
extern unsigned long uBEMFBsum32;
extern unsigned long uBEMFCsum32;

extern unsigned int index1;
extern unsigned int index2;
extern unsigned int ADCSample_zcDetectEnable;

//extern char adcSensing_SecondSampState;


 
extern ADC_FLAGS adcFlags;
extern ADC_STATE_ENUM adcSensingStateIndex;
#pragma DATA_SEG DEFAULT
extern unsigned int uDcbFilt;
extern unsigned int uDcbFilt_half;
extern unsigned int ADCoffset;

extern unsigned int iDcbFilt;

extern FILTER_MA_T_F16  Udcb_filt;
extern signed int u_dc_bus_filt;

#endif  /* _ADC_DRV_H */
